/*
 * Decompiled with CFR 0.152.
 */
package com.brytonsport.active.plantriplib;

import com.brytonsport.active.plantriplib.RoutePoint;
import com.brytonsport.active.plantriplib.RouteResult;
import com.brytonsport.active.plantriplib.Slope;
import com.brytonsport.active.plantriplib.SlopeCandidate;
import com.brytonsport.active.plantriplib.elevDiff;
import com.brytonsport.active.utils.DistanceUtil;
import java.util.ArrayList;

public class BSStats {
    static double ALT_SMOOTH_FACTOR = 10.0;
    static double MIN_DIST_DWHILL = 50.0;
    static double MIN_DIST_UPHILL = 50.0;
    static double SLP_ABS_ABNORMAL = 0.3;
    static double SLP_SMOOTH_FACTOR = 3.0;

    elevDiff calElevDiff(elevDiff elevDiff2, Slope slope) {
        if (elevDiff2 != null) {
            Double d = Math.abs(slope.altitude - elevDiff2.last.altitude);
            Double d2 = slope.distance - elevDiff2.last.distance;
            if (!(slope.grade > 0.01) && !(d2 > 500.0)) {
                if (!(slope.grade < -0.01) && !(d2 > 500.0)) {
                    return elevDiff2;
                }
                return new elevDiff(elevDiff2.gain, elevDiff2.loss + d, slope);
            }
            return new elevDiff(elevDiff2.gain + d, elevDiff2.loss, slope);
        }
        return new elevDiff(0.0, 0.0, slope);
    }

    public RouteResult calRouteDiff(RoutePoint[] object) {
        double d;
        RouteResult routeResult = new RouteResult();
        Object object2 = new ArrayList();
        ArrayList<SlopeCandidate> arrayList = new ArrayList<SlopeCandidate>();
        int n = ((RoutePoint[])object).length;
        int n2 = 0;
        double d2 = 0.0;
        Double d3 = 0.0;
        if (n <= 1) {
            routeResult.gain = d3;
            routeResult.loss = d3;
        } else {
            for (n = 0; n < ((RoutePoint[])object).length; ++n) {
                Object object3;
                RoutePoint routePoint = object[n];
                if (n == 0) {
                    object3 = new Slope(routePoint.alt, d3, d3);
                    ((ArrayList)object2).add(object3);
                    arrayList.add(new SlopeCandidate((Slope)object3, (Slope)object3, (Slope)object3));
                    continue;
                }
                int n3 = n - 1;
                object3 = object[n3];
                Double d4 = ((Slope)((ArrayList)object2).get((int)n3)).distance;
                double d5 = DistanceUtil.distance(((RoutePoint)object3).lat, ((RoutePoint)object3).lon, routePoint.lat, routePoint.lon);
                d = d4;
                d5 = d5;
                object3 = new Slope(routePoint.alt, d + d5, d3);
                arrayList.add(this.calSlope((SlopeCandidate)arrayList.get(n3), (Slope)object3));
                ((ArrayList)object2).add(object3);
            }
        }
        object = null;
        for (n = n2; n < arrayList.size(); ++n) {
            object2 = (SlopeCandidate)arrayList.get(n);
            object = n == 0 ? this.calElevDiff(null, ((SlopeCandidate)object2).ref_last) : this.calElevDiff((elevDiff)object, ((SlopeCandidate)object2).ref_last);
        }
        d = object != null ? object.gain : 0.0;
        routeResult.gain = d;
        d = d2;
        if (object != null) {
            d = object.loss;
        }
        routeResult.loss = d;
        return routeResult;
    }

    SlopeCandidate calSlope(SlopeCandidate slopeCandidate, Slope slope) {
        Double d = slopeCandidate.ref_last.altitude + (slope.altitude - slopeCandidate.ref_last.altitude) / ALT_SMOOTH_FACTOR;
        double d2 = slope.distance - slopeCandidate.ref_1st.distance;
        double d3 = d - slopeCandidate.ref_1st.altitude;
        Object object = d3 > 0.0 ? Double.valueOf(MIN_DIST_UPHILL) : Double.valueOf(MIN_DIST_DWHILL);
        Object object2 = slopeCandidate.ref_2nd;
        if (d2 > (Double)object * 0.67) {
            object = object2 = Double.valueOf(d3 / d2);
            if (Math.abs((Double)object2) > SLP_ABS_ABNORMAL) {
                object = slopeCandidate.ref_last.grade;
            }
            object2 = slopeCandidate.ref_last;
        } else {
            double d4 = slope.distance - slopeCandidate.ref_2nd.distance;
            d2 = d;
            d3 = slopeCandidate.ref_2nd.altitude;
            if (d4 > (Double)object) {
                object = object2 = Double.valueOf((d2 - d3) / d4);
                if (Math.abs((Double)object2) > SLP_ABS_ABNORMAL) {
                    object = slopeCandidate.ref_last.grade;
                }
                object2 = slopeCandidate.ref_last;
            } else {
                object = slopeCandidate.ref_last.grade;
            }
        }
        d2 = slopeCandidate.ref_last.grade;
        d3 = ((Double)object - slopeCandidate.ref_last.grade) / SLP_SMOOTH_FACTOR;
        return new SlopeCandidate(slopeCandidate.ref_last, (Slope)object2, new Slope(d, slope.distance, d2 + d3));
    }
}

