/*
 * Decompiled with CFR 0.152.
 */
package com.brytonsport.active.repo;

import android.bluetooth.BluetoothDevice;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.os.Build;
import android.util.Log;
import androidx.lifecycle.MutableLiveData;
import com.brytonsport.active.base.App;
import com.brytonsport.active.bleplugin.DataUtil;
import com.brytonsport.active.bleplugin.DeviceInfo;
import com.brytonsport.active.db.setting.entity.DeviceManagerEntity;
import com.brytonsport.active.fwupdate.FwPackageInfo;
import com.brytonsport.active.repo.BleRepository;
import com.brytonsport.active.service.BleService;
import com.brytonsport.active.ui.DeviceVo;
import com.brytonsport.active.utils.BleUtil;
import com.brytonsport.active.vm.base.Device;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.inject.Inject;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class BleRepoImpl
implements BleRepository {
    static final String TAG = "BleRepoImpl";
    private final MutableLiveData<Boolean> connectionFailedLiveData;
    private final BroadcastReceiver mBondStateReceiver;
    private final BroadcastReceiver mGattUpdateReceiver;
    private final BroadcastReceiver mScanReceiver;
    private final MutableLiveData<Boolean> peripheralDisconnectedLiveData;
    private Map<String, DeviceVo> peripherals = new LinkedHashMap<String, DeviceVo>();
    private final MutableLiveData<Map<String, DeviceVo>> peripheralsMapLiveData = new MutableLiveData();
    private final MutableLiveData<Device> readDeviceInfoResultLiveData = new MutableLiveData();
    private final BroadcastReceiver stateReceiver;

    @Inject
    public BleRepoImpl() {
        this.peripheralDisconnectedLiveData = new MutableLiveData();
        this.connectionFailedLiveData = new MutableLiveData();
        this.mScanReceiver = new BroadcastReceiver(){

            public void onReceive(Context object, Intent object2) {
                if ("com.brytonsport.active.ACTION_SCAN_RECORD".equals(object2.getAction())) {
                    DeviceVo deviceVo = (DeviceVo)object2.getSerializableExtra("com.brytonsport.active.ACTION_SCAN_RECORD_EXTRA_DATA");
                    object = TAG;
                    object2 = new StringBuilder();
                    ((StringBuilder)object2).append("ACTION_SCAN_RECORD: ");
                    ((StringBuilder)object2).append(deviceVo.getAddress());
                    ((StringBuilder)object2).append(", ");
                    ((StringBuilder)object2).append(deviceVo.getName());
                    Log.d((String)object, (String)((StringBuilder)object2).toString());
                    BleRepoImpl.this.processScanResult(deviceVo);
                }
            }
        };
        this.mBondStateReceiver = new BroadcastReceiver(){

            private String printBondState(int n) {
                switch (n) {
                    default: {
                        return String.valueOf(n);
                    }
                    case 12: {
                        return "BOND_BONDED";
                    }
                    case 11: {
                        return "BOND_BONDING";
                    }
                    case 10: 
                }
                return "BOND_NONE";
            }

            public void onReceive(Context object, Intent intent) {
                object = (BluetoothDevice)intent.getParcelableExtra("android.bluetooth.device.extra.DEVICE");
                int n = intent.getIntExtra("android.bluetooth.device.extra.BOND_STATE", -1);
                int n2 = intent.getIntExtra("android.bluetooth.device.extra.PREVIOUS_BOND_STATE", -1);
                object = new StringBuilder();
                ((StringBuilder)object).append("Bond state change: state ");
                ((StringBuilder)object).append(this.printBondState(n));
                ((StringBuilder)object).append(", previous state ");
                ((StringBuilder)object).append(this.printBondState(n2));
                Log.w((String)"Bond state receiver", (String)((StringBuilder)object).toString());
                if (n == 10) {
                    if (n2 == 11) {
                        Log.d((String)TAG, (String)"\u7d81\u5b9a\u8655\u7406: \u7d81\u5b9a\u5931\u6557\uff0c\u518d\u7d81\u4e00\u6b21");
                    }
                } else if (n == 11) {
                    Log.d((String)TAG, (String)"\u7d81\u5b9a\u8655\u7406: \u7d81\u5b9a\u4e2d\uff0c\u8acb\u71d2\u7b49");
                } else if (n == 12) {
                    Log.d((String)TAG, (String)"\u7d81\u5b9a\u8655\u7406: \u7d81\u5b9a\u6210\u529f");
                }
            }
        };
        this.stateReceiver = new BroadcastReceiver(){

            public void onReceive(Context context, Intent intent) {
            }
        };
        this.mGattUpdateReceiver = new BroadcastReceiver(){

            /*
             * Enabled aggressive block sorting
             */
            public void onReceive(Context object, Intent object2) {
                int n;
                Object object3;
                String string2;
                block23: {
                    block24: {
                        object = object2.getAction();
                        string2 = TAG;
                        object3 = new StringBuilder();
                        ((StringBuilder)object3).append("mGattUpdateReceiver onReceive action: ");
                        ((StringBuilder)object3).append((String)object);
                        Log.d((String)string2, (String)((StringBuilder)object3).toString());
                        ((String)object).hashCode();
                        int n2 = ((String)object).hashCode();
                        n = 1;
                        object3 = true;
                        switch (n2) {
                            case 1856942223: {
                                if (!((String)object).equals("com.brytonsport.active.ACTION_BONDING_SUCCEEDED")) break;
                                n = 8;
                                break block23;
                            }
                            case 1598518254: {
                                if (!((String)object).equals("com.brytonsport.active.ACTION_DISCONNECTED_PERIPHERAL")) break;
                                n = 7;
                                break block23;
                            }
                            case 1397614127: {
                                if (!((String)object).equals("com.brytonsport.active.ACTION_BONDING_STARTED")) break;
                                n = 6;
                                break block23;
                            }
                            case 1104189796: {
                                if (!((String)object).equals("com.brytonsport.active.ACTION_CONNECTED_PERIPHERAL")) break;
                                n = 5;
                                break block23;
                            }
                            case 1015145939: {
                                if (!((String)object).equals("com.example.bluetooth.le.ACTION_READ_DEVICE_INFO")) break;
                                n = 4;
                                break block23;
                            }
                            case 626108438: {
                                if (!((String)object).equals("com.brytonsport.active.ACTION_BONDING_LOST")) break;
                                n = 3;
                                break block23;
                            }
                            case 209779887: {
                                if (!((String)object).equals("com.brytonsport.active.ACTION_BONDING_FAILED")) break;
                                n = 2;
                                break block23;
                            }
                            case 187774391: {
                                if (!((String)object).equals("com.brytonsport.active.ACTION_SERVICES_DISCOVERED")) {
                                    break;
                                }
                                break block23;
                            }
                            case -1166133972: {
                                if (((String)object).equals("com.brytonsport.active.ACTION_CONNECTION_FAILED")) break block24;
                            }
                        }
                        n = -1;
                        break block23;
                    }
                    n = 0;
                }
                switch (n) {
                    default: {
                        return;
                    }
                    case 8: {
                        Log.d((String)TAG, (String)"\u88dd\u7f6e\u7d81\u5b9a\u6210\u529f: ");
                        return;
                    }
                    case 7: {
                        Log.d((String)TAG, (String)"\u88dd\u7f6e\u65b7\u7dda: ");
                        BleRepoImpl.this.peripheralDisconnectedLiveData.postValue(object3);
                        return;
                    }
                    case 6: {
                        Log.d((String)TAG, (String)"\u958b\u59cb\u7d81\u5b9a\u88dd\u7f6e: ");
                        return;
                    }
                    case 5: {
                        Log.d((String)TAG, (String)"\u88dd\u7f6e\u9023\u7dda CONNECTED_PERIPHERAL: ");
                        return;
                    }
                    case 4: {
                        object3 = object2.getByteArrayExtra("com.example.bluetooth.le.EXTRA_DATA");
                        object = object2.getStringExtra("com.example.bluetooth.le.EXTRA_DATA_MAC_ADDRESS");
                        string2 = DataUtil.readDeviceInfoFormat((byte[])object3);
                        String string3 = TAG;
                        object3 = new StringBuilder();
                        ((StringBuilder)object3).append("\u8b80\u53d6\u88dd\u7f6e\u8cc7\u8a0a: ");
                        ((StringBuilder)object3).append(string2.toString());
                        Log.d((String)string3, (String)((StringBuilder)object3).toString());
                        BleRepoImpl.this.processDeviceInfo((String)object, (JSONObject)string2);
                        return;
                    }
                    case 3: {
                        Log.d((String)TAG, (String)"\u88dd\u7f6e\u79fb\u9664\u7d81\u5b9a\u6210\u529f: ");
                        return;
                    }
                    case 2: {
                        Log.d((String)TAG, (String)"\u88dd\u7f6e\u7d81\u5b9a\u5931\u6557: ");
                        return;
                    }
                    case 1: {
                        Log.d((String)TAG, (String)"\u88dd\u7f6e\u9023\u7dda\u6210\u529f: ");
                        return;
                    }
                    case 0: 
                }
                Log.d((String)TAG, (String)"\u88dd\u7f6e\u9023\u7dda\u5931\u6557: ");
                BleRepoImpl.this.connectionFailedLiveData.postValue(object3);
            }
        };
    }

    private static IntentFilter makeGattUpdateIntentFilter() {
        IntentFilter intentFilter = new IntentFilter();
        intentFilter.addAction("com.brytonsport.active.ACTION_BLUETOOTH_STATE_CHANGE");
        intentFilter.addAction("com.brytonsport.active.ACTION_CONNECTED_PERIPHERAL");
        intentFilter.addAction("com.brytonsport.active.ACTION_CONNECTION_FAILED");
        intentFilter.addAction("com.brytonsport.active.ACTION_DISCONNECTED_PERIPHERAL");
        intentFilter.addAction("com.brytonsport.active.ACTION_NOTIFICATION_STATE_SETTING_CHANNEL");
        intentFilter.addAction("com.brytonsport.active.ACTION_BONDING_STARTED");
        intentFilter.addAction("com.brytonsport.active.ACTION_BONDING_SUCCEEDED");
        intentFilter.addAction("com.brytonsport.active.ACTION_BONDING_FAILED");
        intentFilter.addAction("com.brytonsport.active.ACTION_BONDING_LOST");
        intentFilter.addAction("com.brytonsport.active.ACTION_SERVICES_DISCOVERED");
        intentFilter.addAction("com.example.bluetooth.le.ACTION_READ_DEVICE_INFO");
        intentFilter.addAction("com.example.bluetooth.le.ACTION_GET_FILE_LIST");
        intentFilter.addAction("com.example.bluetooth.le.ACTION_GET_FILE");
        intentFilter.addAction("com.example.bluetooth.le.ACTION_GET_FILE_RANGE");
        intentFilter.addAction("com.example.bluetooth.le.ACTION_GET_FILE_RANGE_PART_TWO");
        intentFilter.addAction("com.example.bluetooth.le.ACTION_POST_DATA");
        intentFilter.addAction("com.example.bluetooth.le.ACTION_CRC_ERROR");
        intentFilter.addAction("com.example.bluetooth.le.ACTION_SETTING_COMMAND_RETURN");
        intentFilter.addAction("com.example.bluetooth.le.ACTION_GET_FILE_RANGE_START_TIME");
        intentFilter.addAction("com.example.bluetooth.le.ACTION_GET_FILE_RANGE_DATA_SIZE");
        return intentFilter;
    }

    private static IntentFilter makeScanReceiverIntentFilter() {
        IntentFilter intentFilter = new IntentFilter();
        intentFilter.addAction("com.brytonsport.active.ACTION_SCAN_RECORD");
        return intentFilter;
    }

    private void processScanResult(DeviceVo deviceVo) {
        boolean bl;
        block2: {
            Iterator<Map.Entry<String, DeviceVo>> iterator = this.peripherals.entrySet().iterator();
            while (iterator.hasNext()) {
                if (!iterator.next().getValue().getAddress().equals(deviceVo.getAddress())) continue;
                bl = true;
                break block2;
            }
            bl = false;
        }
        if (!bl && deviceVo.getName() != null && !deviceVo.getName().isEmpty()) {
            this.peripherals.put(deviceVo.getAddress(), deviceVo);
            this.peripheralsMapLiveData.postValue(this.peripherals);
        }
    }

    private void startBleService(Intent intent) {
        if (Build.VERSION.SDK_INT >= 26) {
            App.getInstance().startForegroundService(intent);
        } else {
            App.getInstance().startService(intent);
        }
    }

    @Override
    public void cancelRxProgress() {
        Intent intent = new Intent((Context)App.getInstance(), BleService.class);
        intent.setAction("com.brytonsport.active.ACTION_CANCEL_RX_PROGRESS");
        this.startBleService(intent);
    }

    @Override
    public void cancelSendFileToDevice() {
        Intent intent = new Intent((Context)App.getInstance(), BleService.class);
        intent.setAction("com.brytonsport.active.ACTION_CANCEL_SEND_FILE_TO_DEVICE");
        this.startBleService(intent);
    }

    @Override
    public void checkHasDeviceConnect(DeviceManagerEntity deviceManagerEntity) {
        this.checkHasDeviceConnect(deviceManagerEntity, false);
    }

    @Override
    public void checkHasDeviceConnect(DeviceManagerEntity deviceManagerEntity, boolean bl) {
        Intent intent = new Intent((Context)App.getInstance(), BleService.class);
        intent.setAction("com.example.bluetooth.le.ACTION_CREATE_BOND_OR_CONNECT");
        intent.putExtra("deviceMac", deviceManagerEntity.getMacAddress());
        intent.putExtra("deviceName", deviceManagerEntity.getDevName());
        intent.putExtra("deviceUuid", deviceManagerEntity.getDevUuid());
        intent.putExtra("deviceVer", deviceManagerEntity.getDevVersion());
        intent.putExtra("com.brytonsport.active.SERVICE_SCAN_CONNECT_MODE", bl);
        this.startBleService(intent);
    }

    @Override
    public void disConnectDevice(String string2) {
        Intent intent = new Intent((Context)App.getInstance(), BleService.class);
        intent.setAction("com.example.bluetooth.le.ACTION_DISCONNECT_DEVICE");
        intent.putExtra("disConnectDev", string2);
        this.startBleService(intent);
    }

    @Override
    public MutableLiveData<Boolean> getConnectionFailedLiveData() {
        return this.connectionFailedLiveData;
    }

    @Override
    public void getFile(int n, byte by) {
        Intent intent = new Intent((Context)App.getInstance(), BleService.class);
        intent.setAction("com.brytonsport.active.ACTION_GET_FILE");
        intent.putExtra("idOfGetFile", n);
        intent.putExtra("typeOfGetFile", by);
        this.startBleService(intent);
    }

    @Override
    public void getFileList() {
        Intent intent = new Intent((Context)App.getInstance(), BleService.class);
        intent.setAction("com.brytonsport.active.ACTION_FILE_LIST");
        this.startBleService(intent);
    }

    @Override
    public void getFileRange(int n, byte by, int n2, int n3) {
        Intent intent = new Intent((Context)App.getInstance(), BleService.class);
        intent.setAction("com.brytonsport.active.ACTION_GET_FILE_RANGE");
        intent.putExtra("idOfGetFileRange", n);
        intent.putExtra("typeOfGetFileRange", by);
        intent.putExtra("offset", n2);
        intent.putExtra("chunkSize", n3);
        this.startBleService(intent);
    }

    @Override
    public void getFitFileFromDeviceBySptFtp(int n, byte by) {
        Intent intent = new Intent((Context)App.getInstance(), BleService.class);
        intent.setAction("com.brytonsport.active.ACTION_GET_FIT_FILE_FROM_DEVICE_BY_SPT_FTP");
        intent.putExtra("idOfGetFile", n);
        intent.putExtra("typeOfGetFile", by);
        this.startBleService(intent);
    }

    @Override
    public MutableLiveData<Boolean> getPeripheralDisconnectedLiveData() {
        return this.peripheralDisconnectedLiveData;
    }

    @Override
    public MutableLiveData<Map<String, DeviceVo>> getPeripheralsMapLiveData() {
        return this.peripheralsMapLiveData;
    }

    @Override
    public MutableLiveData<Device> getReadDeviceInfoResultLiveData() {
        return this.readDeviceInfoResultLiveData;
    }

    @Override
    public void getRxProgress() {
        Intent intent = new Intent((Context)App.getInstance(), BleService.class);
        intent.setAction("com.brytonsport.active.ACTION_GET_RX_PROGRESS");
        this.startBleService(intent);
    }

    @Override
    public boolean isDeviceSptGroupRide() {
        Object object = BleUtil.getInstance().getNewAppSupportForService("all");
        boolean bl = false;
        boolean bl2 = false;
        if (object != null) {
            bl = bl2;
            bl = bl2 = object.getBoolean("group_ride");
            bl = bl2;
            object = new StringBuilder();
            bl = bl2;
            ((StringBuilder)object).append("isDeviceSptGroupRide: devSptGroupRide = ");
            bl = bl2;
            ((StringBuilder)object).append(bl2);
            bl = bl2;
            try {
                Log.d((String)"TAG", (String)((StringBuilder)object).toString());
                bl = bl2;
            }
            catch (JSONException jSONException) {
                jSONException.printStackTrace();
            }
        }
        return bl;
    }

    @Override
    public void notifyAppCombine(String string2, String string3, String string4) {
        Intent intent = new Intent((Context)App.getInstance(), BleService.class);
        Object object = BleUtil.getInstance().getNewAppSupportForService("all");
        boolean bl = false;
        boolean bl2 = false;
        if (object != null) {
            bl = bl2;
            bl = bl2 = object.getBoolean("android_notification");
            object = TAG;
            bl = bl2;
            bl = bl2;
            StringBuilder stringBuilder = new StringBuilder();
            bl = bl2;
            stringBuilder.append("notifyAppCombine: devSptNotification = ");
            bl = bl2;
            stringBuilder.append(bl2);
            bl = bl2;
            try {
                Log.d((String)object, (String)stringBuilder.toString());
                bl = bl2;
            }
            catch (JSONException jSONException) {
                jSONException.printStackTrace();
            }
        }
        if (bl) {
            object = new JSONArray();
            object.put((Object)"set.notification");
            object.put((Object)string2);
            object.put((Object)string3);
            object.put((Object)string4);
            intent.setAction("com.example.bluetooth.le.ACTION_SETTING_COMMAND");
            intent.putExtra("com.brytonsport.active.SERVICE_SETTING_COMMAND_PARAM_ARRAY", object.toString());
        } else {
            intent.setAction("com.brytonsport.active.ACTION_NOTIFY_APPLICATION");
            intent.putExtra("com.brytonsport.active.NOTIFY_APPLICATION_NAME", string2);
            intent.putExtra("com.brytonsport.active.NOTIFY_APPLICATION_TITLE", string3);
            intent.putExtra("com.brytonsport.active.NOTIFY_APPLICATION_CONTENT", string4);
        }
        this.startBleService(intent);
    }

    @Override
    public void notifyApplication(String string2, String string3, String string4) {
        Intent intent = new Intent((Context)App.getInstance(), BleService.class);
        intent.setAction("com.brytonsport.active.ACTION_NOTIFY_APPLICATION");
        intent.putExtra("com.brytonsport.active.NOTIFY_APPLICATION_NAME", string2);
        intent.putExtra("com.brytonsport.active.NOTIFY_APPLICATION_TITLE", string3);
        intent.putExtra("com.brytonsport.active.NOTIFY_APPLICATION_CONTENT", string4);
        this.startBleService(intent);
    }

    @Override
    public void notifyIncomingCall(String string2, String string3) {
        Intent intent = new Intent((Context)App.getInstance(), BleService.class);
        intent.setAction("com.brytonsport.active.ACTION_NOTIFY_INCOMING_CALL");
        intent.putExtra("com.brytonsport.active.NOTIFY_CALL_NAME", string2);
        intent.putExtra("com.brytonsport.active.NOTIFY_CALL_NUMBER", string3);
        this.startBleService(intent);
    }

    @Override
    public void notifyIncomingCallCancel() {
        Intent intent = new Intent((Context)App.getInstance(), BleService.class);
        intent.setAction("com.brytonsport.active.ACTION_NOTIFY_INCOMING_CALL_CANCEL");
        this.startBleService(intent);
    }

    @Override
    public void notifyIncomingEmail() {
        Intent intent = new Intent((Context)App.getInstance(), BleService.class);
        intent.setAction("com.brytonsport.active.ACTION_NOTIFY_INCOMING_EMAIL");
        this.startBleService(intent);
    }

    @Override
    public void notifyIncomingText() {
        Intent intent = new Intent((Context)App.getInstance(), BleService.class);
        intent.setAction("com.brytonsport.active.ACTION_NOTIFY_INCOMING_TEXT");
        this.startBleService(intent);
    }

    @Override
    public void openAutoAltitude() {
        Intent intent = new Intent((Context)App.getInstance(), BleService.class);
        intent.setAction("com.brytonsport.active.ACTION_START_AUTO_ALTITUDE");
        this.startBleService(intent);
    }

    @Override
    public void passSettingCommand(JSONArray jSONArray) {
        Intent intent = new Intent((Context)App.getInstance(), BleService.class);
        intent.setAction("com.example.bluetooth.le.ACTION_SETTING_COMMAND");
        intent.putExtra("com.brytonsport.active.SERVICE_SETTING_COMMAND_PARAM_ARRAY", jSONArray.toString());
        this.startBleService(intent);
    }

    @Override
    public void postData(int n, byte[] byArray) {
        Intent intent = new Intent((Context)App.getInstance(), BleService.class);
        intent.setAction("com.brytonsport.active.ACTION_POST_DATA");
        intent.putExtra("com.brytonsport.active.POST_DATA_CONTENT_TYPE", n);
        intent.putExtra("com.brytonsport.active.POST_DATA_CONTENT_BYTE_ARRAY", byArray);
        this.startBleService(intent);
    }

    @Override
    public void postFwUpdateData(int n, FwPackageInfo fwPackageInfo) {
        Intent intent = new Intent((Context)App.getInstance(), BleService.class);
        intent.setAction("com.brytonsport.active.ACTION_POST_FW_UPDATE_DATA");
        intent.putExtra("com.brytonsport.active.POST_DATA_CONTENT_TYPE", n);
        intent.putExtra("com.brytonsport.active.POST_DATA_FW_PACKAGE_INFO", (Serializable)fwPackageInfo);
        this.startBleService(intent);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void processDeviceInfo(String string2, JSONObject jSONObject) {
        Device device;
        if (jSONObject == null) return;
        try {
            device = new Device();
            jSONObject = jSONObject.getJSONArray("result");
            for (int i = 0; i < jSONObject.length(); ++i) {
                JSONArray jSONArray = jSONObject.getJSONArray(i);
                String string3 = jSONArray.getString(0);
                boolean bl = string3.equals("CP");
                boolean bl2 = true;
                if (bl) {
                    int n = Integer.parseInt(jSONArray.getString(1).split(",")[0], 16);
                    boolean bl3 = (n & 0x800) > 0;
                    bl = bl3 && (n & 1) > 0;
                    DeviceInfo.ftp = bl;
                    bl = bl3 && (n & 2) > 0;
                    DeviceInfo.workout = bl;
                    bl = bl3 && (n & 4) > 0;
                    DeviceInfo.plantrip = bl;
                    bl = bl3 && (n & 8) > 0;
                    DeviceInfo.setting = bl;
                    bl = bl3 && (n & 0x10) > 0;
                    DeviceInfo.fwUpt = bl;
                    bl = bl3 && (n & 0x20) > 0;
                    DeviceInfo.alt = bl;
                    bl = bl3 && (n & 0x40) > 0;
                    DeviceInfo.wifi = bl;
                    bl = bl3 && (n & 0x80) > 0;
                    DeviceInfo.fastBt = bl;
                    bl = bl3 && (n & 0x100) > 0;
                    DeviceInfo.grid = bl;
                    bl = bl3 && (n & 0x200) > 0 ? bl2 : false;
                    DeviceInfo.cap = bl;
                    DeviceInfo.chgRxTx = false;
                    HashMap<String, Integer> hashMap = new HashMap<String, Integer>();
                    DeviceInfo.cmd = hashMap;
                    continue;
                }
                if (string3.equals("UD")) {
                    device.uuid = jSONArray.getString(1);
                    continue;
                }
                if (string3.equals("IV")) {
                    device.firmware = jSONArray.getString(1);
                    continue;
                }
                if (!string3.equals("MN")) continue;
                device.deviceName = jSONArray.getString(1);
            }
        }
        catch (JSONException jSONException) {
            Log.d((String)TAG, (String)jSONException.toString());
            return;
        }
        {
            device.macAddress = string2;
            this.readDeviceInfoResultLiveData.postValue(device);
            return;
        }
    }

    @Override
    public void readDeviceInfo() {
        Intent intent = new Intent((Context)App.getInstance(), BleService.class);
        intent.setAction("com.brytonsport.active.ACTION_READ_DEVICE_INFO");
        this.startBleService(intent);
    }

    @Override
    public void registerBluetoothStateReceiver() {
        App.getInstance().registerReceiver(this.stateReceiver, new IntentFilter("android.bluetooth.adapter.action.STATE_CHANGED"));
    }

    @Override
    public void registerBondStateReceiver() {
        App.getInstance().registerReceiver(this.mBondStateReceiver, new IntentFilter("android.bluetooth.device.action.BOND_STATE_CHANGED"));
    }

    @Override
    public void registerGattReceiver() {
        Log.d((String)TAG, (String)"registerGattReceiver: ");
        App.getInstance().registerReceiver(this.mGattUpdateReceiver, BleRepoImpl.makeGattUpdateIntentFilter());
    }

    @Override
    public void registerScanReceiver() {
        App.getInstance().registerReceiver(this.mScanReceiver, BleRepoImpl.makeScanReceiverIntentFilter());
    }

    @Override
    public void requestData(int n) {
        Intent intent = new Intent((Context)App.getInstance(), BleService.class);
        intent.setAction("com.brytonsport.active.ACTION_REQUEST_DATA");
        intent.putExtra("com.brytonsport.active.REQUEST_DATA_REQUEST_TYPE", n);
        this.startBleService(intent);
    }

    public void resetDeviceInfo() {
        DeviceInfo.ftp = false;
        DeviceInfo.workout = false;
        DeviceInfo.plantrip = false;
        DeviceInfo.setting = false;
        DeviceInfo.fwUpt = false;
        DeviceInfo.alt = false;
        DeviceInfo.wifi = false;
        DeviceInfo.fastBt = false;
        DeviceInfo.grid = false;
        DeviceInfo.cap = false;
        DeviceInfo.chgRxTx = false;
        DeviceInfo.cmd = new HashMap<String, Integer>();
    }

    @Override
    public void runConnectTask() {
        Intent intent = new Intent((Context)App.getInstance(), BleService.class);
        intent.setAction("com.brytonsport.activerunConnectTask");
        this.startBleService(intent);
    }

    @Override
    public void startScan() {
        Log.d((String)TAG, (String)"startScan: ");
        Intent intent = new Intent((Context)App.getInstance(), BleService.class);
        intent.setAction("com.brytonsport.activestartscan");
        this.startBleService(intent);
    }

    @Override
    public void stopScan() {
        Log.d((String)TAG, (String)"stopScan: ");
        Intent intent = new Intent((Context)App.getInstance(), BleService.class);
        intent.setAction("com.brytonsport.activestopscan");
        this.startBleService(intent);
    }

    @Override
    public void unBondDevice(String string2) {
        Intent intent = new Intent((Context)App.getInstance(), BleService.class);
        intent.setAction("com.example.bluetooth.le.ACTION_UNBOND_DEVICE");
        intent.putExtra("disConnectDev", string2);
        this.startBleService(intent);
    }

    @Override
    public void unregisterBluetoothStateReceiver() {
        App.getInstance().unregisterReceiver(this.stateReceiver);
    }

    @Override
    public void unregisterBondStateReceiver() {
        App.getInstance().unregisterReceiver(this.mBondStateReceiver);
    }

    @Override
    public void unregisterGattReceiver() {
        Log.d((String)TAG, (String)"unregisterGattReceiver: ");
        App.getInstance().unregisterReceiver(this.mGattUpdateReceiver);
    }

    @Override
    public void unregisterScanReceiver() {
        App.getInstance().unregisterReceiver(this.mScanReceiver);
    }
}

