/*
 * Decompiled with CFR 0.152.
 */
package com.brytonsport.active.repo.account;

import android.content.Intent;
import android.util.Log;
import androidx.lifecycle.LiveData;
import androidx.lifecycle.MutableLiveData;
import com.brytonsport.active.api.APIError;
import com.brytonsport.active.api.ApiService;
import com.brytonsport.active.api.ErrorUtils;
import com.brytonsport.active.api.account.AccountApi;
import com.brytonsport.active.api.account.vo.AccountErrorVo;
import com.brytonsport.active.api.account.vo.AccountLoginVo;
import com.brytonsport.active.api.account.vo.AccountLogoutResponse;
import com.brytonsport.active.api.account.vo.AccountUserIdResponse;
import com.brytonsport.active.api.account.vo.AccountUserInfo;
import com.brytonsport.active.api.account.vo.AccountUserProfile;
import com.brytonsport.active.api.account.vo.AccountZoneVo;
import com.brytonsport.active.base.App;
import com.brytonsport.active.db.AppDatabase;
import com.brytonsport.active.db.account.dao.UserInfoDao;
import com.brytonsport.active.db.account.dao.UserProfileDao;
import com.brytonsport.active.repo.account.LoginRepository$$ExternalSyntheticLambda0;
import com.brytonsport.active.repo.account.LoginRepository$$ExternalSyntheticLambda1;
import com.brytonsport.active.repo.account.LoginRepository$$ExternalSyntheticLambda2;
import com.brytonsport.active.utils.ProfileUtil;
import com.google.gson.Gson;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import javax.inject.Inject;
import okhttp3.MediaType;
import okhttp3.RequestBody;
import okhttp3.ResponseBody;
import org.json.JSONException;
import org.json.JSONObject;
import retrofit2.Call;
import retrofit2.Callback;
import retrofit2.Response;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class LoginRepository {
    static final String TAG = "LoginRepository";
    private static LoginRepository instance;
    private final MutableLiveData<Boolean> _isChangePwdSuccessLiveData;
    private final MutableLiveData<JSONObject> _isDeleteAccountResultLiveData;
    private final MutableLiveData<Boolean> _isForgotPwdSuccessLiveData;
    private final MutableLiveData<Boolean> _isLoginSuccessLiveData;
    private final MutableLiveData<Boolean> _isLogoutSuccessLiveData;
    private final MutableLiveData<Boolean> _isSendVerifyEmailSuccessLiveData;
    private final MutableLiveData<Boolean> _isSetUserInfoSuccessLiveData;
    private final MutableLiveData<Boolean> _isSetUserProfileSuccessLiveData;
    private final MutableLiveData<Boolean> _isSignSuccessLiveData;
    private final MutableLiveData<Boolean> _isUnbindServiceSuccessLiveData;
    private final MutableLiveData<Boolean> _isUserInfoSuccessLiveData;
    private final MutableLiveData<AccountUserInfo> _isUserInfoVerifiedLiveData;
    private final MutableLiveData<Boolean> _isUserProfileSuccessLiveData;
    private final MutableLiveData<JSONObject> checkUuidHasOwnerLiveData;
    private final MutableLiveData<Boolean> deleteUuidSuccessLiveData;
    private final MutableLiveData<AccountErrorVo> liveAccountErrorResponse = new MutableLiveData();
    private final AccountApi loginApi;
    private final MutableLiveData<Boolean> overwriteUuidSuccessLiveData;
    private final MutableLiveData<JSONObject> refreshTokenLiveData;
    private final UserInfoDao userInfoDao;
    private final MutableLiveData<AccountUserInfo> userInfoForConfirmEmailLive;
    private final UserProfileDao userProfileDao;
    private final MutableLiveData<JSONObject> userProfileForLoginResultLiveData;

    @Inject
    public LoginRepository() {
        this._isLoginSuccessLiveData = new MutableLiveData();
        this._isLogoutSuccessLiveData = new MutableLiveData();
        this._isUserInfoSuccessLiveData = new MutableLiveData();
        this._isUserInfoVerifiedLiveData = new MutableLiveData();
        this.userInfoForConfirmEmailLive = new MutableLiveData();
        this._isSetUserInfoSuccessLiveData = new MutableLiveData();
        this._isUserProfileSuccessLiveData = new MutableLiveData();
        this._isSignSuccessLiveData = new MutableLiveData();
        this._isSendVerifyEmailSuccessLiveData = new MutableLiveData();
        this._isSetUserProfileSuccessLiveData = new MutableLiveData();
        this._isChangePwdSuccessLiveData = new MutableLiveData();
        this._isForgotPwdSuccessLiveData = new MutableLiveData();
        this._isUnbindServiceSuccessLiveData = new MutableLiveData();
        this.checkUuidHasOwnerLiveData = new MutableLiveData();
        this.overwriteUuidSuccessLiveData = new MutableLiveData();
        this.deleteUuidSuccessLiveData = new MutableLiveData();
        this._isDeleteAccountResultLiveData = new MutableLiveData();
        this.refreshTokenLiveData = new MutableLiveData();
        this.userProfileForLoginResultLiveData = new MutableLiveData();
        this.loginApi = ApiService.getInstance().getAccountApi();
        this.userInfoDao = AppDatabase.getInstance(App.getInstance().getApplicationContext()).userInfoDao();
        this.userProfileDao = AppDatabase.getInstance(App.getInstance().getApplicationContext()).userProfileDao();
    }

    private void broadcastGetAnnouncement(JSONObject jSONObject) {
        Intent intent = new Intent("com.brytonsport.active.getAnnouncement");
        intent.putExtra("com.brytonsport.active.getAnnouncementResult", jSONObject.toString());
        App.getInstance().sendBroadcast(intent);
    }

    public static LoginRepository getInstance() {
        if (instance == null) {
            instance = new LoginRepository();
        }
        return instance;
    }

    private void insertUserInfoToDb(AccountUserInfo accountUserInfo) {
        Log.d((String)TAG, (String)"insertUserInfoToDb: UserInfo \u5beb\u5165DB");
        new Thread(new LoginRepository$$ExternalSyntheticLambda1(this, (String)ProfileUtil.getInstance().get("userId"), accountUserInfo)).start();
    }

    private void insertUserProfileToDb(AccountUserProfile accountUserProfile) {
        Log.d((String)TAG, (String)"insertUserProfileToDb: \u5c07UserProfile \u5beb\u5165DB");
        new Thread(new LoginRepository$$ExternalSyntheticLambda2(this, (String)ProfileUtil.getInstance().get("userId"), accountUserProfile)).start();
    }

    public void changePassword(String string2, String string3) {
        String string4 = TAG;
        CharSequence charSequence = new StringBuilder();
        charSequence.append("changePassword: ");
        charSequence.append(string2);
        charSequence.append(" -> ");
        charSequence.append(string3);
        Log.d((String)string4, (String)charSequence.toString());
        string4 = (String)ProfileUtil.getInstance().get("userId");
        charSequence = (String)ProfileUtil.getInstance().get("com.brytonsport.active.loginToken");
        this.loginApi.changePassword(string4, (String)charSequence, string2, string3).enqueue((Callback)new Callback<ResponseBody>(){

            public void onFailure(Call<ResponseBody> call, Throwable throwable) {
                LoginRepository.this._isChangePwdSuccessLiveData.postValue(false);
            }

            public void onResponse(Call<ResponseBody> object, Response<ResponseBody> object2) {
                if (object2.isSuccessful()) {
                    String string2 = TAG;
                    object = new StringBuilder();
                    ((StringBuilder)object).append("changePassword onResponse: ");
                    ((StringBuilder)object).append(object2.body());
                    Log.d((String)string2, (String)((StringBuilder)object).toString());
                    object = (ResponseBody)object2.body();
                    LoginRepository.this._isChangePwdSuccessLiveData.postValue(true);
                } else {
                    object = ErrorUtils.parseError(object2);
                    object2 = new AccountErrorVo(object2.code(), ((APIError)object).message());
                    LoginRepository.this.liveAccountErrorResponse.postValue(object2);
                    String string3 = TAG;
                    object2 = new StringBuilder();
                    ((StringBuilder)object2).append("sign error message: ");
                    ((StringBuilder)object2).append(((APIError)object).message());
                    Log.d((String)string3, (String)((StringBuilder)object2).toString());
                    LoginRepository.this._isChangePwdSuccessLiveData.postValue(false);
                }
            }
        });
    }

    public void checkUuid(String string2) {
        String string3 = TAG;
        CharSequence charSequence = new StringBuilder();
        charSequence.append("checkUuid: uuid -> ");
        charSequence.append(string2);
        Log.d((String)string3, (String)charSequence.toString());
        charSequence = (String)ProfileUtil.getInstance().get("userId");
        string3 = (String)ProfileUtil.getInstance().get("com.brytonsport.active.loginToken");
        this.loginApi.checkUuid((String)charSequence, string3, string2).enqueue((Callback)new Callback<ResponseBody>(){

            public void onFailure(Call<ResponseBody> call, Throwable throwable) {
                LoginRepository.this.checkUuidHasOwnerLiveData.postValue(new JSONObject());
            }

            public void onResponse(Call<ResponseBody> object, Response<ResponseBody> object2) {
                JSONObject jSONObject = new JSONObject();
                try {
                    jSONObject.put("successful", object2.isSuccessful());
                }
                catch (JSONException jSONException) {
                    jSONException.printStackTrace();
                }
                if (object2.isSuccessful()) {
                    object = TAG;
                    StringBuilder stringBuilder = new StringBuilder();
                    stringBuilder.append("checkUuid onResponse: ");
                    stringBuilder.append(object2.body());
                    Log.d(object, (String)stringBuilder.toString());
                    object2 = (ResponseBody)object2.body();
                    object = null;
                    try {
                        object2 = object2.string();
                        object = object2;
                    }
                    catch (IOException iOException) {
                        iOException.printStackTrace();
                    }
                    try {
                        object2 = new JSONObject((String)object);
                        if (object2.has("owner")) {
                            jSONObject.put("owner", (Object)object2.getString("owner"));
                        }
                    }
                    catch (JSONException jSONException) {
                        jSONException.printStackTrace();
                    }
                } else {
                    object = ErrorUtils.getErrorBodyMessage(object2);
                    CharSequence charSequence = TAG;
                    Object object3 = new StringBuilder();
                    ((StringBuilder)object3).append("checkUuid error code: ");
                    ((StringBuilder)object3).append(object2.code());
                    Log.d((String)charSequence, (String)((StringBuilder)object3).toString());
                    object3 = TAG;
                    charSequence = new StringBuilder();
                    ((StringBuilder)charSequence).append("checkUuid error message: ");
                    ((StringBuilder)charSequence).append((String)object);
                    Log.d((String)object3, (String)((StringBuilder)charSequence).toString());
                    object3 = ErrorUtils.parseError(object2);
                    object = new AccountErrorVo(object2.code(), (String)object);
                    LoginRepository.this.liveAccountErrorResponse.postValue(object);
                    object = TAG;
                    object2 = new StringBuilder();
                    ((StringBuilder)object2).append("checkUuid error message: ");
                    ((StringBuilder)object2).append(((APIError)object3).message());
                    Log.d((String)object, (String)((StringBuilder)object2).toString());
                }
                LoginRepository.this.checkUuidHasOwnerLiveData.postValue(jSONObject);
            }
        });
    }

    public void createDefaultUserProfileToDb(String string2) {
        this.createDefaultUserProfileToDb(string2, true);
    }

    public void createDefaultUserProfileToDb(String object, boolean bl) {
        Log.d((String)TAG, (String)"createDefaultUserProfileToDb: \u65b0\u589e\u9810\u8a2d\u7684 UserProfile \u5beb\u5165DB");
        Object object2 = (String)ProfileUtil.getInstance().get("userId");
        AccountUserProfile accountUserProfile = new AccountUserProfile();
        accountUserProfile.setUserId((String)object2);
        accountUserProfile.setNickName((String)object);
        accountUserProfile.setWeight(50.0f);
        accountUserProfile.setWeight_I(130.0f);
        accountUserProfile.setHeight(170.0f);
        accountUserProfile.setHeight_I(70.0f);
        accountUserProfile.setBirthday("1990/10/10");
        Integer n = 0;
        accountUserProfile.setGender(0);
        object = 165;
        Integer n2 = 168;
        Integer n3 = 100;
        Integer n4 = 102;
        Integer n5 = 500;
        Integer n6 = 450;
        object2 = new AccountZoneVo();
        ((AccountZoneVo)object2).setMhr(new ArrayList<Integer>(Arrays.asList(173, n, 134, 134, 145, 145, 153, 153, object, object, n2, n2, n2, n2, n2)));
        ((AccountZoneVo)object2).setLthr(new ArrayList<Integer>(Arrays.asList(object, 65, 81, 81, 88, 88, 93, 93, n3, n3, n4, n4, n4, n4, n4)));
        ((AccountZoneVo)object2).setMap(new ArrayList<Integer>(Arrays.asList(600, n, n3, n3, 200, 200, 300, 300, 400, 400, n5, n5, n5, n5, n5)));
        ((AccountZoneVo)object2).setFtp(new ArrayList<Integer>(Arrays.asList(n5, n, 95, 95, 150, 150, 250, 250, 350, 350, n6, n6, n6, n6, n6)));
        accountUserProfile.setZones((AccountZoneVo)object2);
        this.insertUserProfileToDb(accountUserProfile);
        if (bl) {
            this.setUserProfile(accountUserProfile);
        }
    }

    public void deleteAccount() {
        Log.d((String)TAG, (String)"deleteAccount: ");
        String string2 = (String)ProfileUtil.getInstance().get("userId");
        String string3 = (String)ProfileUtil.getInstance().get("com.brytonsport.active.loginToken");
        this.loginApi.deleteUserAccount(string2, string3).enqueue((Callback)new Callback<ResponseBody>(){

            public void onFailure(Call<ResponseBody> jSONObject, Throwable throwable) {
                jSONObject = new JSONObject();
                try {
                    jSONObject.put("message", (Object)throwable.getLocalizedMessage());
                    LoginRepository.this._isDeleteAccountResultLiveData.postValue(jSONObject);
                }
                catch (JSONException jSONException) {
                    jSONException.printStackTrace();
                }
            }

            public void onResponse(Call<ResponseBody> object, Response<ResponseBody> object2) {
                if (object2.isSuccessful()) {
                    object = TAG;
                    StringBuilder stringBuilder = new StringBuilder();
                    stringBuilder.append("deleteAccount onResponse: ");
                    stringBuilder.append(object2.body());
                    Log.d((String)object, (String)stringBuilder.toString());
                    object2 = (ResponseBody)object2.body();
                    object = null;
                    try {
                        object = object2 = object2.string();
                    }
                    catch (IOException iOException) {
                        iOException.printStackTrace();
                    }
                    try {
                        object2 = new JSONObject((String)object);
                        LoginRepository.this._isDeleteAccountResultLiveData.postValue(object2);
                    }
                    catch (JSONException jSONException) {
                        jSONException.printStackTrace();
                    }
                } else {
                    CharSequence charSequence;
                    block34: {
                        StringBuilder stringBuilder;
                        String string2;
                        block33: {
                            block32: {
                                object = object2.errorBody();
                                string2 = "";
                                if (object == null) {
                                    Log.d((String)TAG, (String)"deleteAccount errorBody == null");
                                    charSequence = "";
                                } else {
                                    try {
                                        object = object.string();
                                    }
                                    catch (IOException iOException) {
                                        iOException.printStackTrace();
                                        object = "";
                                    }
                                    charSequence = TAG;
                                    stringBuilder = new StringBuilder();
                                    stringBuilder.append("deleteAccount errorBody: ");
                                    stringBuilder.append((String)object);
                                    Log.d((String)charSequence, (String)stringBuilder.toString());
                                    charSequence = object;
                                }
                                new JSONObject();
                                object = string2;
                                object = string2;
                                stringBuilder = new JSONObject((String)charSequence);
                                object = string2;
                                if (!stringBuilder.has("code")) break block32;
                                object = string2;
                                stringBuilder.put("code", object2.code());
                                object = string2;
                                LoginRepository.this._isDeleteAccountResultLiveData.postValue(stringBuilder);
                            }
                            object = string2;
                            if (!stringBuilder.has("status")) break block33;
                            object = string2;
                            String string3 = stringBuilder.getString("status");
                            object = string2;
                            String string4 = TAG;
                            object = string2;
                            object = string2;
                            charSequence = new StringBuilder();
                            object = string2;
                            ((StringBuilder)charSequence).append("deleteAccount status: ");
                            object = string2;
                            ((StringBuilder)charSequence).append(string3);
                            object = string2;
                            Log.d((String)string4, (String)((StringBuilder)charSequence).toString());
                        }
                        object = string2;
                        charSequence = string2;
                        if (!stringBuilder.has("message")) break block34;
                        object = string2;
                        charSequence = stringBuilder.getString("message");
                        object = charSequence;
                        string2 = TAG;
                        object = charSequence;
                        object = charSequence;
                        stringBuilder = new StringBuilder();
                        object = charSequence;
                        stringBuilder.append("deleteAccount errorBody message: ");
                        object = charSequence;
                        stringBuilder.append((String)charSequence);
                        object = charSequence;
                        try {
                            Log.d((String)string2, (String)stringBuilder.toString());
                        }
                        catch (JSONException jSONException) {
                            jSONException.printStackTrace();
                            charSequence = object;
                        }
                    }
                    object = new AccountErrorVo(object2.code(), (String)charSequence);
                    LoginRepository.this.liveAccountErrorResponse.postValue(object);
                }
            }
        });
    }

    public void deleteUserInfoAllData() {
        this.userInfoDao.deleteAll();
    }

    public void deleteUserProfileAllData() {
        this.userProfileDao.deleteAll();
    }

    public void deleteUuid(String string2) {
        String string3 = TAG;
        CharSequence charSequence = new StringBuilder();
        charSequence.append("deleteUuid: uuid -> ");
        charSequence.append(string2);
        Log.d((String)string3, (String)charSequence.toString());
        string3 = (String)ProfileUtil.getInstance().get("userId");
        charSequence = (String)ProfileUtil.getInstance().get("com.brytonsport.active.loginToken");
        this.loginApi.deleteUuid(string3, (String)charSequence, string2).enqueue((Callback)new Callback<ResponseBody>(){

            public void onFailure(Call<ResponseBody> call, Throwable throwable) {
                LoginRepository.this.deleteUuidSuccessLiveData.postValue(false);
            }

            public void onResponse(Call<ResponseBody> object, Response<ResponseBody> object2) {
                if (object2.isSuccessful()) {
                    String string2 = TAG;
                    object = new StringBuilder();
                    ((StringBuilder)object).append("deleteUuid onResponse: ");
                    ((StringBuilder)object).append(object2.body());
                    Log.d((String)string2, (String)((StringBuilder)object).toString());
                    object2 = (ResponseBody)object2.body();
                    object = null;
                    try {
                        object = object2 = object2.string();
                    }
                    catch (IOException iOException) {
                        iOException.printStackTrace();
                    }
                    try {
                        new JSONObject((String)object);
                    }
                    catch (JSONException jSONException) {
                        jSONException.printStackTrace();
                    }
                    LoginRepository.this.deleteUuidSuccessLiveData.postValue(true);
                } else {
                    object = ErrorUtils.parseError(object2);
                    object2 = new AccountErrorVo(object2.code(), ((APIError)object).message());
                    LoginRepository.this.liveAccountErrorResponse.postValue(object2);
                    String string3 = TAG;
                    object2 = new StringBuilder();
                    ((StringBuilder)object2).append("sign error message: ");
                    ((StringBuilder)object2).append(((APIError)object).message());
                    Log.d((String)string3, (String)((StringBuilder)object2).toString());
                    LoginRepository.this.deleteUuidSuccessLiveData.postValue(false);
                }
            }
        });
    }

    public void forgotPassword(String string2) {
        String string3 = TAG;
        CharSequence charSequence = new StringBuilder();
        charSequence.append("forgotPassword: email -> ");
        charSequence.append(string2);
        Log.d((String)string3, (String)charSequence.toString());
        charSequence = (String)ProfileUtil.getInstance().get("userId");
        string3 = (String)ProfileUtil.getInstance().get("com.brytonsport.active.loginToken");
        this.loginApi.forgotPassword((String)charSequence, string3, string2).enqueue((Callback)new Callback<ResponseBody>(){

            public void onFailure(Call<ResponseBody> call, Throwable throwable) {
                LoginRepository.this._isForgotPwdSuccessLiveData.postValue(false);
            }

            public void onResponse(Call<ResponseBody> object, Response<ResponseBody> object2) {
                if (object2.isSuccessful()) {
                    String string2 = TAG;
                    object = new StringBuilder();
                    ((StringBuilder)object).append("forgotPassword onResponse: ");
                    ((StringBuilder)object).append(object2.body());
                    Log.d((String)string2, (String)((StringBuilder)object).toString());
                    string2 = TAG;
                    object = new StringBuilder();
                    ((StringBuilder)object).append("forgotPassword onResponse.message: ");
                    ((StringBuilder)object).append(object2.message());
                    Log.d((String)string2, (String)((StringBuilder)object).toString());
                    object = (ResponseBody)object2.body();
                    LoginRepository.this._isForgotPwdSuccessLiveData.postValue(true);
                } else {
                    object = ErrorUtils.parseError(object2);
                    object2 = new AccountErrorVo(object2.code(), ((APIError)object).message());
                    LoginRepository.this.liveAccountErrorResponse.postValue(object2);
                    String string3 = TAG;
                    object2 = new StringBuilder();
                    ((StringBuilder)object2).append("sign error message: ");
                    ((StringBuilder)object2).append(((APIError)object).message());
                    Log.d((String)string3, (String)((StringBuilder)object2).toString());
                    LoginRepository.this._isForgotPwdSuccessLiveData.postValue(false);
                }
            }
        });
    }

    public void getAnnouncement() {
        this.loginApi.getAnnouncement("https://www.brytonsport.com/download/Docs/announcement-nativeapp.json").enqueue((Callback)new Callback<ResponseBody>(){

            public void onFailure(Call<ResponseBody> call, Throwable throwable) {
                LoginRepository.this.broadcastGetAnnouncement(new JSONObject());
            }

            public void onResponse(Call<ResponseBody> object, Response<ResponseBody> object2) {
                if (object2.isSuccessful()) {
                    object2 = (ResponseBody)object2.body();
                    object = null;
                    try {
                        object2 = object2.string();
                        object = object2;
                    }
                    catch (IOException iOException) {
                        iOException.printStackTrace();
                    }
                    try {
                        object2 = new JSONObject((String)object);
                        object = TAG;
                        StringBuilder stringBuilder = new StringBuilder();
                        stringBuilder.append("getAnnouncement onResponse: ");
                        stringBuilder.append(object2.toString());
                        Log.d((String)object, (String)stringBuilder.toString());
                        LoginRepository.this.broadcastGetAnnouncement((JSONObject)object2);
                    }
                    catch (JSONException jSONException) {
                        jSONException.printStackTrace();
                    }
                } else {
                    object = ErrorUtils.parseError(object2);
                    object2 = new AccountErrorVo(object2.code(), ((APIError)object).message());
                    LoginRepository.this.liveAccountErrorResponse.postValue(object2);
                    object2 = TAG;
                    StringBuilder stringBuilder = new StringBuilder();
                    stringBuilder.append("getAnnouncement error message: ");
                    stringBuilder.append(((APIError)object).message());
                    Log.d((String)object2, (String)stringBuilder.toString());
                    LoginRepository.this.broadcastGetAnnouncement(new JSONObject());
                }
            }
        });
    }

    public MutableLiveData<JSONObject> getCheckUuidHasOwnerLiveData() {
        return this.checkUuidHasOwnerLiveData;
    }

    public MutableLiveData<Boolean> getDeleteUuidSuccessLiveData() {
        return this.deleteUuidSuccessLiveData;
    }

    public MutableLiveData<AccountErrorVo> getLiveAccountErrorResponse() {
        return this.liveAccountErrorResponse;
    }

    public MutableLiveData<Boolean> getOverwriteUuidSuccessLiveData() {
        return this.overwriteUuidSuccessLiveData;
    }

    public MutableLiveData<JSONObject> getRefreshTokenLiveData() {
        return this.refreshTokenLiveData;
    }

    public void getUserInfo() {
        String string2 = (String)ProfileUtil.getInstance().get("userId");
        String string3 = (String)ProfileUtil.getInstance().get("com.brytonsport.active.loginToken");
        this.loginApi.getUserInfo(string2, string3).enqueue((Callback)new Callback<AccountUserInfo>(){

            public void onFailure(Call<AccountUserInfo> call, Throwable throwable) {
                LoginRepository.this._isUserInfoSuccessLiveData.postValue(false);
            }

            public void onResponse(Call<AccountUserInfo> object, Response<AccountUserInfo> object2) {
                if (object2.isSuccessful()) {
                    object = (AccountUserInfo)object2.body();
                    LoginRepository.this.insertUserInfoToDb(object);
                    String string2 = new Gson().toJson(object);
                    object2 = TAG;
                    object = new StringBuilder();
                    ((StringBuilder)object).append("getUserInfo onResponse: ");
                    ((StringBuilder)object).append(string2);
                    Log.d(object2, (String)((StringBuilder)object).toString());
                    LoginRepository.this._isUserInfoSuccessLiveData.postValue(true);
                } else {
                    object = ErrorUtils.parseErrorByGson(object2);
                    object = new AccountErrorVo(object2.code(), ((APIError)object).message());
                    LoginRepository.this.liveAccountErrorResponse.postValue(object);
                    LoginRepository.this._isUserInfoSuccessLiveData.postValue(false);
                }
            }
        });
    }

    public void getUserInfoForConfirmEmail() {
        String string2 = (String)ProfileUtil.getInstance().get("userId");
        String string3 = (String)ProfileUtil.getInstance().get("com.brytonsport.active.loginToken");
        this.loginApi.getUserInfo(string2, string3).enqueue((Callback)new Callback<AccountUserInfo>(){

            public void onFailure(Call<AccountUserInfo> call, Throwable throwable) {
                LoginRepository.this.userInfoForConfirmEmailLive.postValue(new AccountUserInfo());
            }

            public void onResponse(Call<AccountUserInfo> object, Response<AccountUserInfo> object2) {
                if (object2.isSuccessful()) {
                    AccountUserInfo accountUserInfo = (AccountUserInfo)object2.body();
                    String string2 = new Gson().toJson((Object)accountUserInfo);
                    object2 = TAG;
                    object = new StringBuilder();
                    ((StringBuilder)object).append("getUserInfoForConfirmEmail onResponse: ");
                    ((StringBuilder)object).append(string2);
                    Log.d(object2, (String)((StringBuilder)object).toString());
                    LoginRepository.this.userInfoForConfirmEmailLive.postValue(accountUserInfo);
                } else {
                    object = ErrorUtils.parseErrorByGson(object2);
                    object = new AccountErrorVo(object2.code(), ((APIError)object).message());
                    LoginRepository.this.liveAccountErrorResponse.postValue(object);
                    LoginRepository.this.userInfoForConfirmEmailLive.postValue(new AccountUserInfo());
                }
            }
        });
    }

    public MutableLiveData<AccountUserInfo> getUserInfoForConfirmEmailLive() {
        return this.userInfoForConfirmEmailLive;
    }

    public AccountUserInfo getUserInfoFromDb() {
        String string2 = (String)ProfileUtil.getInstance().get("userId");
        return this.userInfoDao.loadAccountUserInfoByUserId(string2);
    }

    public void getUserInfoWithVerified() {
        String string2 = (String)ProfileUtil.getInstance().get("userId");
        String string3 = (String)ProfileUtil.getInstance().get("com.brytonsport.active.loginToken");
        this.loginApi.getUserInfo(string2, string3).enqueue((Callback)new Callback<AccountUserInfo>(){

            public void onFailure(Call<AccountUserInfo> call, Throwable throwable) {
                LoginRepository.this._isUserInfoVerifiedLiveData.postValue(null);
            }

            public void onResponse(Call<AccountUserInfo> object, Response<AccountUserInfo> object2) {
                if (object2.isSuccessful()) {
                    AccountUserInfo accountUserInfo = (AccountUserInfo)object2.body();
                    LoginRepository.this.insertUserInfoToDb(accountUserInfo);
                    object = new Gson().toJson((Object)accountUserInfo);
                    object2 = TAG;
                    StringBuilder stringBuilder = new StringBuilder();
                    stringBuilder.append("getUserInfo onResponse: ");
                    stringBuilder.append((String)object);
                    Log.d(object2, (String)stringBuilder.toString());
                    LoginRepository.this._isUserInfoVerifiedLiveData.postValue(accountUserInfo);
                } else {
                    object = ErrorUtils.parseErrorByGson(object2);
                    object = new AccountErrorVo(object2.code(), ((APIError)object).message());
                    LoginRepository.this.liveAccountErrorResponse.postValue(object);
                    LoginRepository.this._isUserInfoVerifiedLiveData.postValue(null);
                }
            }
        });
    }

    public void getUserProfile() {
        final String string2 = (String)ProfileUtil.getInstance().get("userId");
        String string3 = (String)ProfileUtil.getInstance().get("com.brytonsport.active.loginToken");
        this.loginApi.getUserProfile(string2, string3).enqueue((Callback)new Callback<AccountUserProfile>(){

            public void onFailure(Call<AccountUserProfile> jSONObject, Throwable throwable) {
                LoginRepository.this._isUserProfileSuccessLiveData.postValue(false);
                jSONObject = new JSONObject();
                try {
                    jSONObject.put("message", (Object)throwable.getLocalizedMessage());
                }
                catch (JSONException jSONException) {
                    jSONException.printStackTrace();
                }
                LoginRepository.this.userProfileForLoginResultLiveData.postValue(jSONObject);
            }

            public void onResponse(Call<AccountUserProfile> object, Response<AccountUserProfile> object2) {
                JSONObject jSONObject = new JSONObject();
                try {
                    jSONObject.put("code", object2.code());
                }
                catch (JSONException jSONException) {
                    jSONException.printStackTrace();
                }
                boolean bl = object2.isSuccessful();
                Object object3 = "";
                if (bl) {
                    object = (AccountUserProfile)object2.body();
                    ((AccountUserProfile)object).setUserId(string2);
                    LoginRepository.this.insertUserProfileToDb((AccountUserProfile)object);
                    object2 = new Gson().toJson(object);
                    String string22 = TAG;
                    StringBuilder stringBuilder = new StringBuilder();
                    stringBuilder.append("getUserProfile onResponse: ");
                    stringBuilder.append((String)object2);
                    Log.d((String)string22, (String)stringBuilder.toString());
                    if (((AccountUserProfile)object).getNickName() != null) {
                        object3 = ((AccountUserProfile)object).getNickName();
                    }
                    ProfileUtil.getInstance().set("nickName", object3);
                    object2 = ProfileUtil.getInstance();
                    object = ((AccountUserProfile)object).getAvatar() == null ? "bryton-gray.jpg" : ((AccountUserProfile)object).getAvatar().getImage();
                    ((ProfileUtil)object2).set("avatar", object);
                    LoginRepository.this._isUserProfileSuccessLiveData.postValue(true);
                } else {
                    CharSequence charSequence;
                    Object object4;
                    block19: {
                        JSONObject jSONObject2;
                        block18: {
                            block17: {
                                object = object2.errorBody();
                                try {
                                    object = object.string();
                                }
                                catch (IOException iOException) {
                                    iOException.printStackTrace();
                                    object = "";
                                }
                                object4 = TAG;
                                charSequence = new StringBuilder();
                                charSequence.append("errorBody: ");
                                charSequence.append((String)object);
                                Log.d((String)object4, (String)charSequence.toString());
                                new JSONObject();
                                object4 = object3;
                                object4 = object3;
                                jSONObject2 = new JSONObject((String)object);
                                object4 = object3;
                                if (!jSONObject2.has("status")) break block17;
                                object4 = object3;
                                charSequence = jSONObject2.getString("status");
                                break block18;
                            }
                            charSequence = "";
                        }
                        object = object3;
                        object4 = object3;
                        if (!jSONObject2.has("message")) break block19;
                        object4 = object3;
                        object = jSONObject2.getString("message");
                    }
                    object4 = object;
                    jSONObject.put("status", (Object)charSequence);
                    object4 = object;
                    jSONObject.put("message", object);
                    object4 = object;
                    try {
                        jSONObject.put("action", (Object)"action_getUserProfile");
                    }
                    catch (JSONException jSONException) {
                        jSONException.printStackTrace();
                        object = object4;
                    }
                    object3 = ErrorUtils.parseError(object2);
                    object = new AccountErrorVo(object2.code(), (String)object, "action_getUserProfile");
                    LoginRepository.this.liveAccountErrorResponse.postValue(object);
                    object2 = TAG;
                    object = new StringBuilder();
                    ((StringBuilder)object).append("getUserProfile error message: ");
                    ((StringBuilder)object).append(((APIError)object3).message());
                    Log.d((String)object2, (String)((StringBuilder)object).toString());
                    LoginRepository.this._isUserProfileSuccessLiveData.postValue(false);
                }
                LoginRepository.this.userProfileForLoginResultLiveData.postValue(jSONObject);
            }
        });
    }

    public MutableLiveData<JSONObject> getUserProfileForLoginResultLiveData() {
        return this.userProfileForLoginResultLiveData;
    }

    public MutableLiveData<JSONObject> get_isDeleteAccountResultLiveData() {
        return this._isDeleteAccountResultLiveData;
    }

    public MutableLiveData<Boolean> isChangePwdSuccessLiveData() {
        return this._isChangePwdSuccessLiveData;
    }

    public MutableLiveData<Boolean> isForgotPwdSuccessLiveData() {
        return this._isForgotPwdSuccessLiveData;
    }

    public MutableLiveData<Boolean> isLoginSuccessLiveData() {
        return this._isLoginSuccessLiveData;
    }

    public MutableLiveData<Boolean> isLogoutSuccessLiveData() {
        return this._isLogoutSuccessLiveData;
    }

    public MutableLiveData<Boolean> isSendVerifyEmailSuccessLiveData() {
        return this._isSendVerifyEmailSuccessLiveData;
    }

    public MutableLiveData<Boolean> isSetUserInfoSuccessLiveData() {
        return this._isSetUserInfoSuccessLiveData;
    }

    public MutableLiveData<Boolean> isSetUserProfileSuccessLiveData() {
        return this._isSetUserProfileSuccessLiveData;
    }

    public MutableLiveData<Boolean> isSignSuccessLiveData() {
        return this._isSignSuccessLiveData;
    }

    public MutableLiveData<Boolean> isUnbindServiceSuccessLiveData() {
        return this._isUnbindServiceSuccessLiveData;
    }

    public MutableLiveData<Boolean> isUserInfoSuccessLiveData() {
        return this._isUserInfoSuccessLiveData;
    }

    public MutableLiveData<AccountUserInfo> isUserInfoVerifiedLiveData() {
        return this._isUserInfoVerifiedLiveData;
    }

    public MutableLiveData<Boolean> isUserProfileSuccessLiveData() {
        return this._isUserProfileSuccessLiveData;
    }

    public /* synthetic */ void lambda$insertUserInfoToDb$0$com-brytonsport-active-repo-account-LoginRepository(String string2, AccountUserInfo accountUserInfo) {
        this.userInfoDao.loadAccountUserInfoByUserId(string2);
        this.userInfoDao.insert(accountUserInfo);
    }

    public /* synthetic */ void lambda$insertUserProfileToDb$1$com-brytonsport-active-repo-account-LoginRepository(String string2, AccountUserProfile accountUserProfile) {
        this.userProfileDao.loadAccountUserProfileByUserId(string2);
        this.userProfileDao.insert(accountUserProfile);
    }

    public /* synthetic */ void lambda$updateUserProfileToDb$2$com-brytonsport-active-repo-account-LoginRepository(AccountUserProfile accountUserProfile) {
        this.userProfileDao.update(accountUserProfile);
    }

    public LiveData<AccountUserInfo> loadUserInfoFromDb() {
        Log.d((String)TAG, (String)"loadUserInfoFromDb: ");
        String string2 = (String)ProfileUtil.getInstance().get("userId");
        return this.userInfoDao.loadAccountUserInfoByUserIdLive(string2);
    }

    public LiveData<AccountUserProfile> loadUserProfileFromDb() {
        Log.d((String)TAG, (String)"loadUserProfileFromDb: ");
        String string2 = (String)ProfileUtil.getInstance().get("userId");
        return this.userProfileDao.loadAccountUserProfileByUserIdLive(string2);
    }

    public void login(String string2, String charSequence) {
        AccountLoginVo accountLoginVo = new AccountLoginVo();
        accountLoginVo.setEmail(string2);
        accountLoginVo.setPassword((String)charSequence);
        string2 = new Gson();
        String string3 = TAG;
        charSequence = new StringBuilder();
        ((StringBuilder)charSequence).append("login: ");
        ((StringBuilder)charSequence).append(string2.toJson((Object)accountLoginVo));
        Log.d((String)string3, (String)((StringBuilder)charSequence).toString());
        this.loginApi.getUserId(accountLoginVo).enqueue((Callback)new Callback<AccountUserIdResponse>(){

            public void onFailure(Call<AccountUserIdResponse> call, Throwable throwable) {
                LoginRepository.this._isLoginSuccessLiveData.postValue(false);
            }

            public void onResponse(Call<AccountUserIdResponse> object, Response<AccountUserIdResponse> object2) {
                if (object2.isSuccessful()) {
                    object = TAG;
                    CharSequence charSequence = new StringBuilder();
                    ((StringBuilder)charSequence).append("login onResponse: ");
                    ((StringBuilder)charSequence).append(object2.body());
                    Log.d((String)object, (String)((StringBuilder)charSequence).toString());
                    object2 = (AccountUserIdResponse)object2.body();
                    object = ((AccountUserIdResponse)object2).getData().getUserId();
                    object2 = ((AccountUserIdResponse)object2).getData().getAuthToken();
                    charSequence = TAG;
                    CharSequence charSequence2 = new StringBuilder();
                    charSequence2.append("login userId: ");
                    charSequence2.append((String)object);
                    Log.d((String)charSequence, (String)charSequence2.toString());
                    charSequence2 = TAG;
                    charSequence = new StringBuilder();
                    ((StringBuilder)charSequence).append("login authToken: ");
                    ((StringBuilder)charSequence).append((String)object2);
                    Log.d((String)charSequence2, (String)((StringBuilder)charSequence).toString());
                    ProfileUtil.getInstance().set("userId", object);
                    ProfileUtil.getInstance().set("com.brytonsport.active.loginToken", object2);
                    ProfileUtil.getInstance().set("loginTokenUpdateTime", new Date().getTime());
                    LoginRepository.this._isLoginSuccessLiveData.postValue(true);
                } else {
                    object = ErrorUtils.parseErrorByGson(object2);
                    object2 = new AccountErrorVo(object2.code(), ((APIError)object).message());
                    LoginRepository.this.liveAccountErrorResponse.postValue(object2);
                    String string2 = TAG;
                    object2 = new StringBuilder();
                    ((StringBuilder)object2).append("login error message: ");
                    ((StringBuilder)object2).append(((APIError)object).message());
                    Log.d((String)string2, (String)((StringBuilder)object2).toString());
                    LoginRepository.this._isLoginSuccessLiveData.postValue(false);
                }
            }
        });
    }

    public void logout() {
        String string2 = (String)ProfileUtil.getInstance().get("userId");
        String string3 = (String)ProfileUtil.getInstance().get("com.brytonsport.active.loginToken");
        this.loginApi.logout(string2, string3).enqueue((Callback)new Callback<AccountLogoutResponse>(){

            public void onFailure(Call<AccountLogoutResponse> call, Throwable throwable) {
                LoginRepository.this._isLogoutSuccessLiveData.postValue(false);
            }

            public void onResponse(Call<AccountLogoutResponse> object, Response<AccountLogoutResponse> response) {
                if (response.isSuccessful()) {
                    object = TAG;
                    StringBuilder stringBuilder = new StringBuilder();
                    stringBuilder.append("logout onResponse: ");
                    stringBuilder.append(response.body());
                    Log.d((String)object, (String)stringBuilder.toString());
                    object = (AccountLogoutResponse)response.body();
                    LoginRepository.this._isLogoutSuccessLiveData.postValue(true);
                } else {
                    String string2;
                    CharSequence charSequence;
                    block26: {
                        StringBuilder stringBuilder;
                        block25: {
                            object = response.errorBody();
                            charSequence = "";
                            if (object == null) {
                                Log.d((String)TAG, (String)"getActivityListFromServer errorBody == null");
                                string2 = "";
                            } else {
                                try {
                                    object = object.string();
                                }
                                catch (IOException iOException) {
                                    iOException.printStackTrace();
                                    object = "";
                                }
                                string2 = TAG;
                                stringBuilder = new StringBuilder();
                                stringBuilder.append("getActivityListFromServer errorBody: ");
                                stringBuilder.append((String)object);
                                Log.d((String)string2, (String)stringBuilder.toString());
                                string2 = object;
                            }
                            new JSONObject();
                            object = charSequence;
                            object = charSequence;
                            stringBuilder = new JSONObject(string2);
                            object = charSequence;
                            if (!stringBuilder.has("status")) break block25;
                            object = charSequence;
                            String string3 = stringBuilder.getString("status");
                            object = charSequence;
                            string2 = TAG;
                            object = charSequence;
                            object = charSequence;
                            StringBuilder stringBuilder2 = new StringBuilder();
                            object = charSequence;
                            stringBuilder2.append("getActivityListFromServer status: ");
                            object = charSequence;
                            stringBuilder2.append(string3);
                            object = charSequence;
                            Log.d((String)string2, (String)stringBuilder2.toString());
                        }
                        object = charSequence;
                        string2 = charSequence;
                        if (!stringBuilder.has("message")) break block26;
                        object = charSequence;
                        string2 = stringBuilder.getString("message");
                        object = string2;
                        charSequence = TAG;
                        object = string2;
                        object = string2;
                        stringBuilder = new StringBuilder();
                        object = string2;
                        stringBuilder.append("getActivityListFromServer errorBody message: ");
                        object = string2;
                        stringBuilder.append(string2);
                        object = string2;
                        try {
                            Log.d((String)charSequence, (String)stringBuilder.toString());
                        }
                        catch (JSONException jSONException) {
                            jSONException.printStackTrace();
                            string2 = object;
                        }
                    }
                    object = new AccountErrorVo(response.code(), string2);
                    ErrorUtils.parseError(response);
                    LoginRepository.this.liveAccountErrorResponse.postValue(object);
                    string2 = TAG;
                    charSequence = new StringBuilder();
                    ((StringBuilder)charSequence).append("logout error Message: ");
                    ((StringBuilder)charSequence).append(((AccountErrorVo)object).getMessage());
                    Log.d((String)string2, (String)((StringBuilder)charSequence).toString());
                    string2 = TAG;
                    object = new StringBuilder();
                    ((StringBuilder)object).append("logout error code: ");
                    ((StringBuilder)object).append(response.code());
                    Log.d((String)string2, (String)((StringBuilder)object).toString());
                    LoginRepository.this._isLogoutSuccessLiveData.postValue(false);
                }
            }
        });
    }

    public void overwriteUuid(String string2) {
        String string3 = TAG;
        CharSequence charSequence = new StringBuilder();
        charSequence.append("overwriteUuid: uuid -> ");
        charSequence.append(string2);
        Log.d((String)string3, (String)charSequence.toString());
        charSequence = (String)ProfileUtil.getInstance().get("userId");
        string3 = (String)ProfileUtil.getInstance().get("com.brytonsport.active.loginToken");
        this.loginApi.overwriteUuid((String)charSequence, string3, string2).enqueue((Callback)new Callback<ResponseBody>(){

            public void onFailure(Call<ResponseBody> call, Throwable throwable) {
                LoginRepository.this.overwriteUuidSuccessLiveData.postValue(false);
            }

            public void onResponse(Call<ResponseBody> object, Response<ResponseBody> object2) {
                if (object2.isSuccessful()) {
                    object = TAG;
                    StringBuilder stringBuilder = new StringBuilder();
                    stringBuilder.append("overwriteUuid onResponse: ");
                    stringBuilder.append(object2.body());
                    Log.d((String)object, (String)stringBuilder.toString());
                    object2 = (ResponseBody)object2.body();
                    object = null;
                    try {
                        object = object2 = object2.string();
                    }
                    catch (IOException iOException) {
                        iOException.printStackTrace();
                    }
                    try {
                        new JSONObject((String)object);
                    }
                    catch (JSONException jSONException) {
                        jSONException.printStackTrace();
                    }
                    LoginRepository.this.overwriteUuidSuccessLiveData.postValue(true);
                } else {
                    object = ErrorUtils.parseError(object2);
                    object2 = new AccountErrorVo(object2.code(), ((APIError)object).message());
                    LoginRepository.this.liveAccountErrorResponse.postValue(object2);
                    String string2 = TAG;
                    object2 = new StringBuilder();
                    ((StringBuilder)object2).append("sign error message: ");
                    ((StringBuilder)object2).append(((APIError)object).message());
                    Log.d((String)string2, (String)((StringBuilder)object2).toString());
                    LoginRepository.this.overwriteUuidSuccessLiveData.postValue(false);
                }
            }
        });
    }

    public void refreshToken() {
        Log.d((String)TAG, (String)"refreshToken: ");
        String string2 = (String)ProfileUtil.getInstance().get("userId");
        String string3 = (String)ProfileUtil.getInstance().get("com.brytonsport.active.loginToken");
        this.loginApi.refreshToken(string2, string3).enqueue((Callback)new Callback<ResponseBody>(){

            public void onFailure(Call<ResponseBody> call, Throwable throwable) {
                LoginRepository.this.refreshTokenLiveData.postValue(new JSONObject());
            }

            public void onResponse(Call<ResponseBody> object, Response<ResponseBody> object2) {
                JSONObject jSONObject;
                block12: {
                    jSONObject = new JSONObject();
                    try {
                        jSONObject.put("successful", object2.isSuccessful());
                    }
                    catch (JSONException jSONException) {
                        jSONException.printStackTrace();
                    }
                    if (object2.isSuccessful()) {
                        String string2 = TAG;
                        object = new StringBuilder();
                        ((StringBuilder)object).append("refreshToken onResponse: ");
                        ((StringBuilder)object).append(object2.body());
                        Log.d((String)string2, (String)((StringBuilder)object).toString());
                        object2 = (ResponseBody)object2.body();
                        object = null;
                        try {
                            object = object2 = object2.string();
                        }
                        catch (IOException iOException) {
                            iOException.printStackTrace();
                        }
                        object2 = new JSONObject((String)object);
                        jSONObject.put("data", object2);
                        if (!object2.has("status") || (object = object2.getString("status")) == null) break block12;
                        try {
                            if (((String)object).equals("success")) {
                                object2 = ProfileUtil.getInstance();
                                object = new Date();
                                ((ProfileUtil)object2).set("loginTokenUpdateTime", ((Date)object).getTime());
                            }
                        }
                        catch (JSONException jSONException) {
                            jSONException.printStackTrace();
                        }
                    } else {
                        object = ErrorUtils.parseError(object2);
                        object2 = new AccountErrorVo(object2.code(), ((APIError)object).message());
                        LoginRepository.this.liveAccountErrorResponse.postValue(object2);
                        try {
                            jSONObject.put("errorStatus", ((APIError)object).status());
                            jSONObject.put("errorMsg", (Object)((APIError)object).message());
                        }
                        catch (JSONException jSONException) {
                            jSONException.printStackTrace();
                        }
                    }
                }
                LoginRepository.this.refreshTokenLiveData.postValue(jSONObject);
            }
        });
    }

    public void sendVerifyEmail(String string2) {
        String string3 = TAG;
        CharSequence charSequence = new StringBuilder();
        charSequence.append("sendVerifyEmail: ");
        charSequence.append(string2);
        Log.d((String)string3, (String)charSequence.toString());
        string3 = (String)ProfileUtil.getInstance().get("userId");
        charSequence = (String)ProfileUtil.getInstance().get("com.brytonsport.active.loginToken");
        this.loginApi.updateEmail(string3, (String)charSequence, string2).enqueue((Callback)new Callback<ResponseBody>(){

            public void onFailure(Call<ResponseBody> call, Throwable throwable) {
                LoginRepository.this._isSendVerifyEmailSuccessLiveData.postValue(false);
            }

            public void onResponse(Call<ResponseBody> object, Response<ResponseBody> object2) {
                if (object2.isSuccessful()) {
                    String string2 = TAG;
                    object = new StringBuilder();
                    ((StringBuilder)object).append("sendVerifyEmail onResponse: ");
                    ((StringBuilder)object).append(object2.body());
                    Log.d((String)string2, (String)((StringBuilder)object).toString());
                    object = (ResponseBody)object2.body();
                    LoginRepository.this._isSendVerifyEmailSuccessLiveData.postValue(true);
                } else {
                    object = ErrorUtils.parseError(object2);
                    object2 = new AccountErrorVo(object2.code(), ((APIError)object).message());
                    LoginRepository.this.liveAccountErrorResponse.postValue(object2);
                    String string3 = TAG;
                    object2 = new StringBuilder();
                    ((StringBuilder)object2).append("sign error message: ");
                    ((StringBuilder)object2).append(((APIError)object).message());
                    Log.d((String)string3, (String)((StringBuilder)object2).toString());
                    LoginRepository.this._isSendVerifyEmailSuccessLiveData.postValue(false);
                }
            }
        });
    }

    public void setAgreeToUserInfo(JSONObject jSONObject) {
    }

    public void setUserInfo(JSONObject jSONObject, String string2) {
        Log.d((String)TAG, (String)"setUserInfo: ");
        String string3 = (String)ProfileUtil.getInstance().get("userId");
        String string4 = (String)ProfileUtil.getInstance().get("com.brytonsport.active.loginToken");
        jSONObject = RequestBody.create((MediaType)MediaType.parse((String)"application/json"), (String)jSONObject.toString());
        this.loginApi.setUserInfo(string3, string4, (RequestBody)jSONObject, string2).enqueue((Callback)new Callback<ResponseBody>(){

            public void onFailure(Call<ResponseBody> call, Throwable throwable) {
                LoginRepository.this._isSetUserInfoSuccessLiveData.postValue(false);
            }

            public void onResponse(Call<ResponseBody> object, Response<ResponseBody> object2) {
                if (object2.isSuccessful()) {
                    object = TAG;
                    StringBuilder stringBuilder = new StringBuilder();
                    stringBuilder.append("setUserInfo onResponse: ");
                    stringBuilder.append(object2.body());
                    Log.d((String)object, (String)stringBuilder.toString());
                    object = (ResponseBody)object2.body();
                    LoginRepository.this._isSetUserInfoSuccessLiveData.postValue(true);
                } else {
                    object = ErrorUtils.parseError(object2);
                    object2 = new AccountErrorVo(object2.code(), ((APIError)object).message());
                    LoginRepository.this.liveAccountErrorResponse.postValue(object2);
                    String string2 = TAG;
                    object2 = new StringBuilder();
                    ((StringBuilder)object2).append("setUserInfo error message: ");
                    ((StringBuilder)object2).append(((APIError)object).message());
                    Log.d((String)string2, (String)((StringBuilder)object2).toString());
                    LoginRepository.this._isSetUserInfoSuccessLiveData.postValue(false);
                }
            }
        });
    }

    public void setUserProfile(AccountUserProfile accountUserProfile) {
        String string2 = new Gson().toJson((Object)accountUserProfile);
        try {
            accountUserProfile = new JSONObject(string2);
            this.setUserProfile((JSONObject)accountUserProfile);
        }
        catch (JSONException jSONException) {
            jSONException.printStackTrace();
        }
    }

    public void setUserProfile(JSONObject jSONObject) {
        Log.d((String)TAG, (String)"setUserProfile: ");
        String string2 = (String)ProfileUtil.getInstance().get("userId");
        String string3 = (String)ProfileUtil.getInstance().get("com.brytonsport.active.loginToken");
        JSONObject jSONObject2 = new JSONObject();
        try {
            jSONObject2.put("data", (Object)jSONObject);
        }
        catch (JSONException jSONException) {
            jSONException.printStackTrace();
        }
        jSONObject = RequestBody.create((MediaType)MediaType.parse((String)"application/json"), (String)jSONObject2.toString());
        this.loginApi.setUserProfile(string2, string3, (RequestBody)jSONObject).enqueue((Callback)new Callback<ResponseBody>(){

            public void onFailure(Call<ResponseBody> call, Throwable throwable) {
                LoginRepository.this._isSetUserProfileSuccessLiveData.postValue(false);
            }

            public void onResponse(Call<ResponseBody> object, Response<ResponseBody> object2) {
                if (object2.isSuccessful()) {
                    String string2 = TAG;
                    object = new StringBuilder();
                    ((StringBuilder)object).append("setUserProfile onResponse: ");
                    ((StringBuilder)object).append(object2.body());
                    Log.d((String)string2, (String)((StringBuilder)object).toString());
                    object = (ResponseBody)object2.body();
                    LoginRepository.this._isSetUserProfileSuccessLiveData.postValue(true);
                } else {
                    object = ErrorUtils.parseError(object2);
                    object2 = new AccountErrorVo(object2.code(), ((APIError)object).message());
                    LoginRepository.this.liveAccountErrorResponse.postValue(object2);
                    object2 = TAG;
                    StringBuilder stringBuilder = new StringBuilder();
                    stringBuilder.append("setUserProfile error message: ");
                    stringBuilder.append(((APIError)object).message());
                    Log.d(object2, (String)stringBuilder.toString());
                    LoginRepository.this._isSetUserProfileSuccessLiveData.postValue(false);
                }
            }
        });
    }

    public void sign(String string2, String charSequence) {
        AccountLoginVo accountLoginVo = new AccountLoginVo();
        accountLoginVo.setEmail(string2);
        accountLoginVo.setPassword((String)charSequence);
        string2 = new Gson();
        String string3 = TAG;
        charSequence = new StringBuilder();
        ((StringBuilder)charSequence).append("sign: ");
        ((StringBuilder)charSequence).append(string2.toJson((Object)accountLoginVo));
        Log.d((String)string3, (String)((StringBuilder)charSequence).toString());
        this.loginApi.createUserAccount(accountLoginVo).enqueue((Callback)new Callback<ResponseBody>(){

            public void onFailure(Call<ResponseBody> call, Throwable throwable) {
                LoginRepository.this._isSignSuccessLiveData.postValue(false);
            }

            public void onResponse(Call<ResponseBody> object, Response<ResponseBody> object2) {
                if (object2.isSuccessful()) {
                    String string2 = TAG;
                    object = new StringBuilder();
                    ((StringBuilder)object).append("sign onResponse: ");
                    ((StringBuilder)object).append(object2.body());
                    Log.d((String)string2, (String)((StringBuilder)object).toString());
                    object = (ResponseBody)object2.body();
                    LoginRepository.this._isSignSuccessLiveData.postValue(true);
                } else {
                    object = ErrorUtils.parseError(object2);
                    object2 = new AccountErrorVo(object2.code(), ((APIError)object).message());
                    LoginRepository.this.liveAccountErrorResponse.postValue(object2);
                    object2 = TAG;
                    StringBuilder stringBuilder = new StringBuilder();
                    stringBuilder.append("sign error message: ");
                    stringBuilder.append(((APIError)object).message());
                    Log.d(object2, (String)stringBuilder.toString());
                    LoginRepository.this._isSignSuccessLiveData.postValue(false);
                }
            }
        });
    }

    public void unbindService(String string2) {
        String string3 = TAG;
        CharSequence charSequence = new StringBuilder();
        charSequence.append("unbindService: ");
        charSequence.append(string2);
        Log.d((String)string3, (String)charSequence.toString());
        charSequence = (String)ProfileUtil.getInstance().get("userId");
        string3 = (String)ProfileUtil.getInstance().get("com.brytonsport.active.loginToken");
        this.loginApi.unbindService((String)charSequence, string3, string2).enqueue((Callback)new Callback<ResponseBody>(){

            public void onFailure(Call<ResponseBody> call, Throwable throwable) {
                LoginRepository.this._isUnbindServiceSuccessLiveData.postValue(false);
            }

            public void onResponse(Call<ResponseBody> object, Response<ResponseBody> object2) {
                if (object2.isSuccessful()) {
                    String string2 = TAG;
                    object = new StringBuilder();
                    ((StringBuilder)object).append("unbindService onResponse: ");
                    ((StringBuilder)object).append(object2.body());
                    Log.d((String)string2, (String)((StringBuilder)object).toString());
                    object = (ResponseBody)object2.body();
                    LoginRepository.this._isUnbindServiceSuccessLiveData.postValue(true);
                } else {
                    object = ErrorUtils.parseErrorByGson(object2);
                    object2 = new AccountErrorVo(object2.code(), ((APIError)object).message());
                    LoginRepository.this.liveAccountErrorResponse.postValue(object2);
                    object2 = TAG;
                    StringBuilder stringBuilder = new StringBuilder();
                    stringBuilder.append("unbindService error message: ");
                    stringBuilder.append(((APIError)object).message());
                    Log.d(object2, (String)stringBuilder.toString());
                    LoginRepository.this._isUnbindServiceSuccessLiveData.postValue(false);
                }
            }
        });
    }

    public void updateUserProfileToDb(AccountUserProfile accountUserProfile) {
        Log.d((String)TAG, (String)"updateUserProfileToDb: \u5c07UserProfile \u66f4\u65b0\u5230DB");
        new Thread(new LoginRepository$$ExternalSyntheticLambda0(this, accountUserProfile)).start();
    }
}

