/*
 * Decompiled with CFR 0.152.
 */
package com.brytonsport.active.repo.course;

import android.util.Log;
import androidx.lifecycle.MutableLiveData;
import com.brytonsport.active.api.ApiService;
import com.brytonsport.active.api.course.GroupTrackApi;
import com.brytonsport.active.service.BleService;
import com.brytonsport.active.utils.ProfileUtil;
import com.brytonsport.active.vm.base.GroupRideInfoResponseData;
import com.brytonsport.active.vm.base.GroupRideMemberResponseData;
import com.brytonsport.active.vm.base.GroupTrackMemberInfo;
import com.brytonsport.active.vm.base.Message;
import com.brytonsport.active.vm.base.MessageDataResponseData;
import com.brytonsport.active.vm.base.MessageResponseData;
import com.google.gson.Gson;
import java.io.IOException;
import java.util.ArrayList;
import okhttp3.MediaType;
import okhttp3.RequestBody;
import okhttp3.ResponseBody;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import retrofit2.Call;
import retrofit2.Callback;
import retrofit2.Response;

public class GroupRideRepository {
    static final String TAG = "GroupRideRepository";
    private static GroupRideRepository instance;
    public ArrayList<Message> messages;
    private int mnPreMessagesCnt = 0;
    private final GroupTrackApi moGroupTrackApi = ApiService.getInstance().getGroupTrackApi();

    public GroupRideRepository() {
        this.messages = new ArrayList();
    }

    static /* synthetic */ int access$102(GroupRideRepository groupRideRepository, int n) {
        groupRideRepository.mnPreMessagesCnt = n;
        return n;
    }

    private boolean checkMessageToAdd(Message message) {
        boolean bl;
        block1: {
            for (Message message2 : this.messages) {
                if (message2.timestamp != message.timestamp || !message2.userid.equals(message.userid) || !message2.message.equals(message.message)) continue;
                bl = true;
                break block1;
            }
            bl = false;
        }
        return bl;
    }

    public static GroupRideRepository getInstance() {
        if (instance == null) {
            instance = new GroupRideRepository();
        }
        return instance;
    }

    public MutableLiveData<GroupRideInfoResponseData> getGroupRideInfo(String string2, String string3, String string4) {
        final MutableLiveData<GroupRideInfoResponseData> mutableLiveData = new MutableLiveData<GroupRideInfoResponseData>();
        this.moGroupTrackApi.getGroupInfo(string2, string3, string4).enqueue((Callback)new Callback<ResponseBody>(){

            public void onFailure(Call<ResponseBody> call, Throwable throwable) {
                mutableLiveData.postValue(null);
                Log.d((String)this.toString(), (String)throwable.toString());
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            public void onResponse(Call<ResponseBody> object, Response<ResponseBody> gson) {
                if (!gson.isSuccessful()) return;
                object = (ResponseBody)gson.body();
                try {
                    gson = object.string();
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                    mutableLiveData.postValue(null);
                    Log.d((String)this.toString(), (String)iOException.toString());
                    return;
                }
                try {
                    object = new JSONObject((String)gson);
                    gson = new Gson();
                    object = (GroupRideInfoResponseData)gson.fromJson(object.toString(), GroupRideInfoResponseData.class);
                    if (((GroupRideInfoResponseData)object).error == null) {
                        mutableLiveData.postValue(object);
                    } else {
                        mutableLiveData.postValue(null);
                    }
                    Log.d((String)this.toString(), (String)"Success");
                    return;
                }
                catch (JSONException jSONException) {
                    jSONException.printStackTrace();
                    return;
                }
            }
        });
        return mutableLiveData;
    }

    public MutableLiveData<String> getGroupTrackLatLngHistory(String string2) {
        final MutableLiveData<String> mutableLiveData = new MutableLiveData<String>();
        int n = this.mnPreMessagesCnt;
        final String string3 = ProfileUtil.getInstance().getPrefString("userId");
        String string4 = ProfileUtil.getInstance().getPrefString("com.brytonsport.active.loginToken");
        this.moGroupTrackApi.getGroupHistory(string3, string4, string2, n, 1000).enqueue((Callback)new Callback<ResponseBody>(){

            public void onFailure(Call<ResponseBody> call, Throwable throwable) {
                mutableLiveData.postValue(null);
                Log.d((String)this.toString(), (String)throwable.toString());
            }

            /*
             * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
             * WARNING - void declaration
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            public void onResponse(Call<ResponseBody> object, Response<ResponseBody> object2) {
                int n;
                int n2;
                int n3;
                Object object3;
                if (!object3.isSuccessful()) {
                    mutableLiveData.postValue(null);
                    int n4 = object3.code();
                    String string2 = this.toString();
                    object3 = new StringBuilder();
                    ((StringBuilder)object3).append("nErrCode = ");
                    ((StringBuilder)object3).append(n4);
                    Log.d((String)string2, (String)((StringBuilder)object3).toString());
                    return;
                }
                ResponseBody responseBody = (ResponseBody)object3.body();
                try {
                    object3 = responseBody.string();
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                    mutableLiveData.postValue(null);
                    Log.d((String)this.toString(), (String)iOException.toString());
                    return;
                }
                try {
                    JSONObject jSONObject = new JSONObject((String)object3);
                    JSONArray jSONArray = (JSONArray)((JSONObject)jSONObject.get("result")).get("data");
                    n3 = jSONArray.length();
                    n2 = GroupRideRepository.this.messages.size();
                    n = 0;
                    for (int i = 0; i < jSONArray.length(); ++i) {
                        JSONObject jSONObject2 = (JSONObject)jSONArray.get(i);
                        if (jSONObject2 == null) {
                            mutableLiveData.postValue(null);
                            return;
                        }
                        object3 = new Gson();
                        for (MessageResponseData messageResponseData : ((MessageDataResponseData)object3.fromJson(String.valueOf(jSONObject2), MessageDataResponseData.class)).getMessage()) {
                            Message message = new Message(messageResponseData);
                            if (message.userid.equals(string3)) {
                                message.isSelf = true;
                            } else {
                                void var1_11;
                                object3 = "";
                                if (BleService.aryGroupTrackMember.containsKey((Object)message.userid)) {
                                    GroupTrackMemberInfo groupTrackMemberInfo;
                                    GroupTrackMemberInfo groupTrackMemberInfo2 = groupTrackMemberInfo = (GroupTrackMemberInfo)BleService.aryGroupTrackMember.get((Object)message.userid);
                                    if (groupTrackMemberInfo != null) {
                                        object3 = groupTrackMemberInfo.nickname;
                                        GroupTrackMemberInfo groupTrackMemberInfo3 = groupTrackMemberInfo;
                                    }
                                } else {
                                    Object var1_10 = null;
                                }
                                message.isSelf = false;
                                message.name = object3;
                                message.oGroupTrackMemberInfo = var1_11;
                            }
                            if (GroupRideRepository.this.checkMessageToAdd(message)) continue;
                            GroupRideRepository.this.messages.add(message);
                            ++n;
                        }
                    }
                }
                catch (JSONException jSONException) {
                    jSONException.printStackTrace();
                    mutableLiveData.postValue(null);
                    Log.d((String)this.toString(), (String)jSONException.toString());
                    return;
                }
                {
                    object3 = mutableLiveData;
                    StringBuilder stringBuilder = new StringBuilder();
                    stringBuilder.append(GroupRideRepository.this.mnPreMessagesCnt);
                    stringBuilder.append("@");
                    stringBuilder.append(n3);
                    stringBuilder.append("@");
                    stringBuilder.append(n2);
                    stringBuilder.append("@");
                    stringBuilder.append(n);
                    ((MutableLiveData)object3).postValue(stringBuilder.toString());
                    GroupRideRepository groupRideRepository = GroupRideRepository.this;
                    GroupRideRepository.access$102(groupRideRepository, groupRideRepository.mnPreMessagesCnt + n3);
                    return;
                }
            }
        });
        return mutableLiveData;
    }

    public MutableLiveData<ArrayList<GroupRideMemberResponseData>> getGroupTrackMember(String string2, Integer n, Integer n2) {
        final MutableLiveData<ArrayList<GroupRideMemberResponseData>> mutableLiveData = new MutableLiveData<ArrayList<GroupRideMemberResponseData>>();
        String string3 = ProfileUtil.getInstance().getPrefString("userId");
        String string4 = ProfileUtil.getInstance().getPrefString("com.brytonsport.active.loginToken");
        this.moGroupTrackApi.getGroupMember(string3, string4, string2, n, n2).enqueue((Callback)new Callback<ResponseBody>(){

            public void onFailure(Call<ResponseBody> call, Throwable throwable) {
                mutableLiveData.postValue(null);
                Log.d((String)this.toString(), (String)throwable.toString());
            }

            /*
             * Loose catch block
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            public void onResponse(Call<ResponseBody> object, Response<ResponseBody> object2) {
                if (!object2.isSuccessful()) return;
                object = (ResponseBody)object2.body();
                object = object.string();
                try {
                    object2 = new JSONObject((String)object);
                    JSONArray jSONArray = (JSONArray)object2.get("result");
                    if (jSONArray.length() == 0) {
                        object = mutableLiveData;
                        object2 = new ArrayList();
                        ((MutableLiveData)object).postValue(object2);
                    } else {
                        object2 = new ArrayList();
                        int n = jSONArray.length();
                        for (int i = 0; i < n; ++i) {
                            JSONObject jSONObject = jSONArray.getJSONObject(i);
                            object = new Gson();
                            ((ArrayList)object2).add((GroupRideMemberResponseData)object.fromJson(jSONObject.toString(), GroupRideMemberResponseData.class));
                        }
                        mutableLiveData.postValue(object2);
                    }
                    Log.d((String)this.toString(), (String)"Success");
                    return;
                }
                catch (JSONException jSONException) {
                    jSONException.printStackTrace();
                    return;
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                    mutableLiveData.postValue(null);
                    Log.d((String)this.toString(), (String)iOException.toString());
                }
            }
        });
        return mutableLiveData;
    }

    public MutableLiveData<Boolean> getMemberCurrent(String string2) {
        final MutableLiveData<Boolean> mutableLiveData = new MutableLiveData<Boolean>();
        String string3 = ProfileUtil.getInstance().getPrefString("userId");
        String string4 = ProfileUtil.getInstance().getPrefString("com.brytonsport.active.loginToken");
        this.moGroupTrackApi.getGroupMemberCurrent(string3, string4, string2).enqueue((Callback)new Callback<ResponseBody>(){

            public void onFailure(Call<ResponseBody> call, Throwable throwable) {
                mutableLiveData.postValue(false);
                Log.d((String)this.toString(), (String)throwable.toString());
            }

            /*
             * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            public void onResponse(Call<ResponseBody> object, Response<ResponseBody> object2) {
                String string2;
                int n;
                boolean bl = object2.isSuccessful();
                object = false;
                if (!bl) {
                    mutableLiveData.postValue(object);
                    n = object2.code();
                    object2 = this.toString();
                    object = new StringBuilder();
                    ((StringBuilder)object).append("nErrCode = ");
                    ((StringBuilder)object).append(n);
                    Log.d((String)object2, (String)((StringBuilder)object).toString());
                    return;
                }
                object2 = (ResponseBody)object2.body();
                try {
                    string2 = object2.string();
                    if (string2 == null) return;
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                    mutableLiveData.postValue(object);
                    Log.d((String)this.toString(), (String)iOException.toString());
                    return;
                }
                try {
                    object2 = new JSONObject(string2);
                    for (n = 0; n < BleService.aryGroupTrackMember.size(); ++n) {
                        GroupTrackMemberInfo groupTrackMemberInfo = (GroupTrackMemberInfo)BleService.aryGroupTrackMember.valueAt(n);
                        if (groupTrackMemberInfo == null || !object2.has(groupTrackMemberInfo.userid)) continue;
                        JSONObject jSONObject = (JSONObject)object2.get(groupTrackMemberInfo.userid);
                        if (!groupTrackMemberInfo.join.booleanValue()) continue;
                        groupTrackMemberInfo.timestamp = jSONObject.getLong("timestamp");
                        string2 = (JSONObject)jSONObject.get("location");
                        groupTrackMemberInfo.lat = string2.getDouble("lat");
                        groupTrackMemberInfo.lng = string2.getDouble("lng");
                        groupTrackMemberInfo.speed = jSONObject.getDouble("speed");
                        groupTrackMemberInfo.distance = jSONObject.getDouble("distance");
                        groupTrackMemberInfo.devGroupRideState = jSONObject.getInt("devGroupRideState");
                    }
                }
                catch (JSONException jSONException) {
                    jSONException.printStackTrace();
                    mutableLiveData.postValue(object);
                    Log.d((String)this.toString(), (String)jSONException.toString());
                    return;
                }
                {
                    mutableLiveData.postValue(true);
                    Log.d((String)this.toString(), (String)BleService.aryGroupTrackMember.toString());
                    return;
                }
            }
        });
        return mutableLiveData;
    }

    public MutableLiveData<String> putCreateGroupTrack(String string2) {
        final MutableLiveData<String> mutableLiveData = new MutableLiveData<String>();
        String string3 = ProfileUtil.getInstance().getPrefString("userId");
        String string4 = ProfileUtil.getInstance().getPrefString("com.brytonsport.active.loginToken");
        string2 = RequestBody.create((MediaType)MediaType.parse((String)"application/json"), (String)string2);
        this.moGroupTrackApi.putCreateGroup(string3, string4, (RequestBody)string2).enqueue((Callback)new Callback<ResponseBody>(){

            public void onFailure(Call<ResponseBody> call, Throwable throwable) {
                mutableLiveData.postValue(null);
                Log.d((String)this.toString(), (String)throwable.toString());
            }

            public void onResponse(Call<ResponseBody> object, Response<ResponseBody> jSONObject) {
                block6: {
                    block5: {
                        block4: {
                            if (!jSONObject.isSuccessful()) break block5;
                            object = (ResponseBody)jSONObject.body();
                            try {
                                object = object.string();
                                if (object == null) break block4;
                            }
                            catch (IOException iOException) {
                                iOException.printStackTrace();
                                mutableLiveData.postValue(null);
                                Log.d((String)this.toString(), (String)iOException.toString());
                                return;
                            }
                            try {
                                jSONObject = new JSONObject((String)object);
                                object = (String)jSONObject.get("result");
                                mutableLiveData.postValue(object);
                            }
                            catch (JSONException jSONException) {
                                jSONException.printStackTrace();
                                mutableLiveData.postValue(null);
                                Log.d((String)this.toString(), (String)jSONException.toString());
                            }
                            break block6;
                        }
                        mutableLiveData.postValue(null);
                        break block6;
                    }
                    mutableLiveData.postValue(null);
                    int n = jSONObject.code();
                    jSONObject = this.toString();
                    object = new StringBuilder();
                    ((StringBuilder)object).append("nErrCode = ");
                    ((StringBuilder)object).append(n);
                    Log.d((String)jSONObject, (String)((StringBuilder)object).toString());
                }
            }
        });
        return mutableLiveData;
    }

    public MutableLiveData<Boolean> putGroupDevLatLng(String string2, String string3) {
        final MutableLiveData<Boolean> mutableLiveData = new MutableLiveData<Boolean>();
        String string4 = ProfileUtil.getInstance().getPrefString("userId");
        String string5 = ProfileUtil.getInstance().getPrefString("com.brytonsport.active.loginToken");
        string3 = RequestBody.create((MediaType)MediaType.parse((String)"application/json"), (String)string3);
        this.moGroupTrackApi.putGroupLatLng(string4, string5, string2, (RequestBody)string3).enqueue((Callback)new Callback<ResponseBody>(){

            public void onFailure(Call<ResponseBody> call, Throwable throwable) {
                mutableLiveData.postValue(false);
                Log.d((String)this.toString(), (String)throwable.toString());
            }

            public void onResponse(Call<ResponseBody> object, Response<ResponseBody> object2) {
                block6: {
                    block5: {
                        block4: {
                            String string2;
                            boolean bl = object2.isSuccessful();
                            object = false;
                            if (!bl) break block5;
                            object2 = (ResponseBody)object2.body();
                            try {
                                string2 = object2.string();
                                if (string2 == null) break block4;
                            }
                            catch (IOException iOException) {
                                iOException.printStackTrace();
                                mutableLiveData.postValue(object);
                                Log.d((String)this.toString(), (String)iOException.toString());
                                return;
                            }
                            try {
                                object2 = new JSONObject(string2);
                                object2 = (Boolean)object2.get("result");
                                mutableLiveData.postValue(true);
                            }
                            catch (JSONException jSONException) {
                                jSONException.printStackTrace();
                                mutableLiveData.postValue(object);
                                Log.d((String)this.toString(), (String)jSONException.toString());
                            }
                            break block6;
                        }
                        mutableLiveData.postValue(object);
                        break block6;
                    }
                    mutableLiveData.postValue(object);
                    int n = object2.code();
                    object = this.toString();
                    object2 = new StringBuilder();
                    ((StringBuilder)object2).append("nErrCode = ");
                    ((StringBuilder)object2).append(n);
                    Log.d(object, (String)((StringBuilder)object2).toString());
                }
            }
        });
        return mutableLiveData;
    }

    public MutableLiveData<Boolean> putGroupMemberReport(String string2, String string3) {
        final MutableLiveData<Boolean> mutableLiveData = new MutableLiveData<Boolean>();
        String string4 = ProfileUtil.getInstance().getPrefString("userId");
        String string5 = ProfileUtil.getInstance().getPrefString("com.brytonsport.active.loginToken");
        string3 = RequestBody.create((MediaType)MediaType.parse((String)"application/json"), (String)string3);
        this.moGroupTrackApi.putGroupReport(string4, string5, string2, (RequestBody)string3).enqueue((Callback)new Callback<ResponseBody>(){

            public void onFailure(Call<ResponseBody> call, Throwable throwable) {
                mutableLiveData.postValue(false);
                Log.d((String)this.toString(), (String)throwable.toString());
            }

            public void onResponse(Call<ResponseBody> object, Response<ResponseBody> object2) {
                block5: {
                    block4: {
                        boolean bl = object2.isSuccessful();
                        object = false;
                        if (!bl) break block4;
                        BleService.aryMessagesToSend.clear();
                        object2 = (ResponseBody)object2.body();
                        try {
                            object2 = object2.string();
                        }
                        catch (IOException iOException) {
                            iOException.printStackTrace();
                            mutableLiveData.postValue(object);
                            Log.d((String)this.toString(), (String)iOException.toString());
                            return;
                        }
                        try {
                            JSONObject jSONObject = new JSONObject((String)object2);
                            object2 = (Boolean)jSONObject.get("result");
                            mutableLiveData.postValue(true);
                        }
                        catch (JSONException jSONException) {
                            jSONException.printStackTrace();
                            mutableLiveData.postValue(object);
                            Log.d((String)this.toString(), (String)jSONException.toString());
                        }
                        break block5;
                    }
                    mutableLiveData.postValue(object);
                    int n = object2.code();
                    object = this.toString();
                    object2 = new StringBuilder();
                    ((StringBuilder)object2).append("nErrCode = ");
                    ((StringBuilder)object2).append(n);
                    Log.d(object, (String)((StringBuilder)object2).toString());
                }
            }
        });
        return mutableLiveData;
    }

    public MutableLiveData<Boolean> putGroupTrackMemberToJoin(String string2, String string3) {
        final MutableLiveData<Boolean> mutableLiveData = new MutableLiveData<Boolean>();
        String string4 = ProfileUtil.getInstance().getPrefString("userId");
        String string5 = ProfileUtil.getInstance().getPrefString("com.brytonsport.active.loginToken");
        string3 = RequestBody.create((MediaType)MediaType.parse((String)"application/json"), (String)string3);
        this.moGroupTrackApi.putGroupMember(string4, string5, string2, (RequestBody)string3).enqueue((Callback)new Callback<ResponseBody>(){

            public void onFailure(Call<ResponseBody> call, Throwable throwable) {
                mutableLiveData.postValue(false);
                Log.d((String)this.toString(), (String)throwable.toString());
            }

            public void onResponse(Call<ResponseBody> object, Response<ResponseBody> object2) {
                block6: {
                    block5: {
                        block4: {
                            boolean bl = object2.isSuccessful();
                            object = false;
                            if (!bl) break block5;
                            object2 = (ResponseBody)object2.body();
                            try {
                                object2 = object2.string();
                                if (object2 == null) break block4;
                            }
                            catch (IOException iOException) {
                                iOException.printStackTrace();
                                mutableLiveData.postValue(object);
                                Log.d((String)this.toString(), (String)iOException.toString());
                                return;
                            }
                            try {
                                JSONObject jSONObject = new JSONObject((String)object2);
                                jSONObject.getInt("result");
                                mutableLiveData.postValue(true);
                            }
                            catch (JSONException jSONException) {
                                jSONException.printStackTrace();
                                mutableLiveData.postValue(object);
                                Log.d((String)this.toString(), (String)jSONException.toString());
                            }
                            break block6;
                        }
                        mutableLiveData.postValue(object);
                        break block6;
                    }
                    mutableLiveData.postValue(object);
                    int n = object2.code();
                    object2 = this.toString();
                    object = new StringBuilder();
                    ((StringBuilder)object).append("nErrCode = ");
                    ((StringBuilder)object).append(n);
                    Log.d((String)object2, (String)((StringBuilder)object).toString());
                }
            }
        });
        return mutableLiveData;
    }

    public MutableLiveData<Boolean> putGroupTrackMemberToLeave(String string2, String string3) {
        return this.putGroupTrackMemberToJoin(string2, string3);
    }

    public void reSetData() {
        this.mnPreMessagesCnt = 0;
        this.messages = new ArrayList();
    }
}

