/*
 * Decompiled with CFR 0.152.
 */
package com.brytonsport.active.repo.course;

import android.util.Log;
import androidx.lifecycle.MutableLiveData;
import com.brytonsport.active.api.APIError;
import com.brytonsport.active.api.ApiService;
import com.brytonsport.active.api.ErrorUtils;
import com.brytonsport.active.api.account.vo.AccountErrorVo;
import com.brytonsport.active.api.course.LiveTrackApi;
import com.brytonsport.active.utils.LiveTrackUtil;
import com.brytonsport.active.utils.NetworkUtil;
import com.brytonsport.active.utils.ProfileUtil;
import java.util.Date;
import javax.inject.Inject;
import okhttp3.MediaType;
import okhttp3.RequestBody;
import okhttp3.ResponseBody;
import org.json.JSONException;
import org.json.JSONObject;
import retrofit2.Call;
import retrofit2.Callback;
import retrofit2.Response;

public class LiveTrackRepository {
    static final String TAG = "LiveTrackRepository";
    private final MutableLiveData<Boolean> addOperationSuccessLiveData = new MutableLiveData();
    private final MutableLiveData<Boolean> createGroupSuccessLiveData = new MutableLiveData();
    private final MutableLiveData<Boolean> getCurrentSuccessLiveData = new MutableLiveData();
    private final LiveTrackApi liveTrackApi;
    private String liveTrackBaseUrl = "https://z8bsz5p8ph.execute-api.ap-northeast-1.amazonaws.com/prod/api/v2/";
    private final MutableLiveData<Boolean> sendMailSuccessLiveData = new MutableLiveData();
    private String sendMailUrl = "https://api.sendgrid.com/v3/mail/send";

    @Inject
    public LiveTrackRepository() {
        this.liveTrackApi = ApiService.getInstance().getLiveTrackApi();
    }

    public void addOperation(final String string2, JSONObject object) {
        String string3 = (String)ProfileUtil.getInstance().get("live_track_group_id");
        object = (String)ProfileUtil.getInstance().get("live_track_group_cred");
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.liveTrackBaseUrl);
        stringBuilder.append("groups/");
        stringBuilder.append(string3);
        stringBuilder.append("/operation");
        string3 = stringBuilder.toString();
        stringBuilder = new JSONObject();
        JSONObject jSONObject = new JSONObject();
        try {
            stringBuilder.put("action", string2);
            if (string2.equals("delete_group")) {
                jSONObject.put("cred", object);
                stringBuilder.put("payload", jSONObject);
            }
        }
        catch (JSONException jSONException) {
            jSONException.printStackTrace();
        }
        object = RequestBody.create((MediaType)MediaType.parse((String)"application/json"), (String)stringBuilder.toString());
        this.liveTrackApi.addOperation(string3, (RequestBody)object).enqueue((Callback)new Callback<ResponseBody>(){

            public void onFailure(Call<ResponseBody> call, Throwable throwable) {
                LiveTrackRepository.this.addOperationSuccessLiveData.postValue(false);
            }

            public void onResponse(Call<ResponseBody> object, Response<ResponseBody> object2) {
                if (object2.isSuccessful()) {
                    object = TAG;
                    StringBuilder stringBuilder = new StringBuilder();
                    stringBuilder.append("addOperation onResponse: ");
                    stringBuilder.append(object2.body());
                    Log.d((String)object, (String)stringBuilder.toString());
                    object = (ResponseBody)object2.body();
                    if (string2.equals("delete_group")) {
                        ProfileUtil.getInstance().set("live_track_group_id", "");
                        ProfileUtil.getInstance().set("live_track_group_cred", "");
                        ProfileUtil.getInstance().set("live_track_extend_24_time_stamp", 0L);
                    }
                    LiveTrackRepository.this.addOperationSuccessLiveData.postValue(true);
                } else {
                    object = ErrorUtils.parseError(object2);
                    new AccountErrorVo(object2.code(), ((APIError)object).message());
                    object2 = TAG;
                    StringBuilder stringBuilder = new StringBuilder();
                    stringBuilder.append("addOperation error message: ");
                    stringBuilder.append(((APIError)object).message());
                    Log.d(object2, (String)stringBuilder.toString());
                    LiveTrackRepository.this.addOperationSuccessLiveData.postValue(false);
                }
            }
        });
    }

    public void createGroup() {
        final String string2 = (String)ProfileUtil.getInstance().get("live_track_group_cred");
        String string3 = (String)ProfileUtil.getInstance().get("userId");
        String string4 = (String)ProfileUtil.getInstance().get("nickName");
        String string5 = (String)ProfileUtil.getInstance().get("avatar");
        CharSequence charSequence = new StringBuilder();
        charSequence.append(this.liveTrackBaseUrl);
        charSequence.append("groups");
        charSequence = charSequence.toString();
        JSONObject jSONObject = new JSONObject();
        JSONObject jSONObject2 = new JSONObject();
        try {
            jSONObject.put("cred", (Object)string2);
            jSONObject.put("expiration", 0);
            jSONObject2.put("id", (Object)string3);
            jSONObject2.put("nickname", (Object)string4);
            jSONObject2.put("icon", (Object)string5);
            jSONObject.put("info", (Object)jSONObject2);
        }
        catch (JSONException jSONException) {
            jSONException.printStackTrace();
        }
        string3 = RequestBody.create((MediaType)MediaType.parse((String)"application/json"), (String)jSONObject.toString());
        this.liveTrackApi.createGroup((String)charSequence, (RequestBody)string3).enqueue((Callback)new Callback<ResponseBody>(){

            public void onFailure(Call<ResponseBody> call, Throwable throwable) {
                LiveTrackRepository.this.createGroupSuccessLiveData.postValue(false);
            }

            public void onResponse(Call<ResponseBody> object, Response<ResponseBody> object2) {
                if (object2.isSuccessful()) {
                    String string22 = TAG;
                    object = new StringBuilder();
                    ((StringBuilder)object).append("createGroup onResponse: ");
                    ((StringBuilder)object).append(object2.body());
                    Log.d((String)string22, (String)((StringBuilder)object).toString());
                    object = (ResponseBody)object2.body();
                    string22 = NetworkUtil.parseResponseBody((Response<ResponseBody>)object2);
                    if (object2.body() != null) {
                        try {
                            object = new JSONObject(string22);
                            string22 = object.getString("result");
                            String string3 = TAG;
                            object2 = new StringBuilder();
                            ((StringBuilder)object2).append("createGroup -> resultObj: ");
                            ((StringBuilder)object2).append(object.toString());
                            Log.d((String)string3, (String)((StringBuilder)object2).toString());
                            ProfileUtil.getInstance().set("live_track_group_id", string22);
                            ProfileUtil.getInstance().set("live_track_group_cred", string2);
                            ProfileUtil.getInstance().set("live_track_manual_state", true);
                            ProfileUtil.getInstance().set("live_track_share_btn_visible", true);
                        }
                        catch (JSONException jSONException) {
                            jSONException.printStackTrace();
                        }
                    }
                    LiveTrackRepository.this.createGroupSuccessLiveData.postValue(true);
                } else {
                    object = ErrorUtils.parseError(object2);
                    new AccountErrorVo(object2.code(), ((APIError)object).message());
                    String string4 = TAG;
                    object2 = new StringBuilder();
                    ((StringBuilder)object2).append("createGroup error message: ");
                    ((StringBuilder)object2).append(((APIError)object).message());
                    Log.d((String)string4, (String)((StringBuilder)object2).toString());
                    LiveTrackRepository.this.createGroupSuccessLiveData.postValue(false);
                }
            }
        });
    }

    public MutableLiveData<Boolean> getAddOperationSuccessLiveData() {
        return this.addOperationSuccessLiveData;
    }

    public MutableLiveData<Boolean> getCreateGroupSuccessLiveData() {
        return this.createGroupSuccessLiveData;
    }

    public void getCurrentForCheckOver24Hour() {
        final String string2 = (String)ProfileUtil.getInstance().get("userId");
        String string3 = (String)ProfileUtil.getInstance().get("live_track_group_id");
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.liveTrackBaseUrl);
        stringBuilder.append("report/");
        stringBuilder.append(string3);
        stringBuilder.append("/current");
        string3 = stringBuilder.toString();
        this.liveTrackApi.getCurrent(string3).enqueue((Callback)new Callback<ResponseBody>(){

            public void onFailure(Call<ResponseBody> call, Throwable throwable) {
                LiveTrackRepository.this.getCurrentSuccessLiveData.postValue(false);
            }

            public void onResponse(Call<ResponseBody> object, Response<ResponseBody> object2) {
                if (object2.isSuccessful()) {
                    object = TAG;
                    StringBuilder stringBuilder = new StringBuilder();
                    stringBuilder.append("getCurrent onResponse: ");
                    stringBuilder.append(object2.body());
                    Log.d((String)object, (String)stringBuilder.toString());
                    object = NetworkUtil.parseResponseBody((Response<ResponseBody>)object2);
                    if (object2.body() != null) {
                        try {
                            object2 = new JSONObject((String)object);
                            if (object2.has(string2)) {
                                long l = object2.getJSONObject(string2).getLong("timestamp");
                                object = new Date();
                                if (((Date)object).getTime() > l + 86400000L) {
                                    LiveTrackRepository.this.addOperation("delete_group", null);
                                }
                            }
                        }
                        catch (JSONException jSONException) {
                            jSONException.printStackTrace();
                        }
                    }
                    LiveTrackRepository.this.getCurrentSuccessLiveData.postValue(true);
                } else {
                    object = ErrorUtils.parseError(object2);
                    new AccountErrorVo(object2.code(), ((APIError)object).message());
                    String string22 = TAG;
                    object2 = new StringBuilder();
                    ((StringBuilder)object2).append("getCurrent error message: ");
                    ((StringBuilder)object2).append(((APIError)object).message());
                    Log.d((String)string22, (String)((StringBuilder)object2).toString());
                    LiveTrackRepository.this.getCurrentSuccessLiveData.postValue(false);
                }
            }
        });
    }

    public MutableLiveData<Boolean> getGetCurrentSuccessLiveData() {
        return this.getCurrentSuccessLiveData;
    }

    public MutableLiveData<Boolean> getSendMailSuccessLiveData() {
        return this.sendMailSuccessLiveData;
    }

    public void sendmail(String string2) {
        String string3 = (String)ProfileUtil.getInstance().get("live_track_group_id");
        string2 = String.format("{\"personalizations\":[{\"to\":%s}],\"from\":{\"email\":\"no-reply@brytonsport.com\",\"name\":\"Bryton\"},\"subject\":\"%s\",\"content\":[{\"type\":\"text/html\",\"value\":\"%s\"}]}", string2, "Bryton Sport", LiveTrackUtil.emailContent((String)ProfileUtil.getInstance().get("live_track_email_message"), string3, (String)ProfileUtil.getInstance().get("nickName")));
        string2 = RequestBody.create((MediaType)MediaType.parse((String)"application/json"), (String)string2);
        this.liveTrackApi.sendmail(this.sendMailUrl, "Bearer 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", "application/json", (RequestBody)string2).enqueue((Callback)new Callback<ResponseBody>(){

            public void onFailure(Call<ResponseBody> call, Throwable throwable) {
                LiveTrackRepository.this.sendMailSuccessLiveData.postValue(false);
            }

            public void onResponse(Call<ResponseBody> object, Response<ResponseBody> object2) {
                if (object2.isSuccessful()) {
                    String string2 = TAG;
                    object = new StringBuilder();
                    ((StringBuilder)object).append("sendmail onResponse: ");
                    ((StringBuilder)object).append(object2.body());
                    Log.d((String)string2, (String)((StringBuilder)object).toString());
                    string2 = NetworkUtil.parseResponseBody((Response<ResponseBody>)object2);
                    if (object2.body() != null) {
                        try {
                            object = new JSONObject(string2);
                            string2 = TAG;
                            object2 = new StringBuilder();
                            ((StringBuilder)object2).append("sendmail -> resultObj: ");
                            ((StringBuilder)object2).append(object.toString());
                            Log.d((String)string2, (String)((StringBuilder)object2).toString());
                        }
                        catch (JSONException jSONException) {
                            jSONException.printStackTrace();
                        }
                    }
                    LiveTrackRepository.this.sendMailSuccessLiveData.postValue(true);
                } else {
                    object = ErrorUtils.parseError(object2);
                    new AccountErrorVo(object2.code(), ((APIError)object).message());
                    String string3 = TAG;
                    object2 = new StringBuilder();
                    ((StringBuilder)object2).append("sendmail error message: ");
                    ((StringBuilder)object2).append(((APIError)object).message());
                    Log.d((String)string3, (String)((StringBuilder)object2).toString());
                    LiveTrackRepository.this.sendMailSuccessLiveData.postValue(false);
                }
            }
        });
    }
}

