/*
 * Decompiled with CFR 0.152.
 */
package com.brytonsport.active.repo.course;

import android.util.Log;
import androidx.lifecycle.MutableLiveData;
import com.brytonsport.active.api.APIError;
import com.brytonsport.active.api.ApiService;
import com.brytonsport.active.api.ErrorUtils;
import com.brytonsport.active.api.account.vo.AccountErrorVo;
import com.brytonsport.active.api.course.PlaceApi;
import com.brytonsport.active.utils.ApiUtil;
import com.brytonsport.active.utils.DistanceUtil;
import com.brytonsport.active.utils.RouteModeConstantsUtil;
import com.brytonsport.active.utils.SignTableUtil;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.Locale;
import javax.inject.Inject;
import okhttp3.MediaType;
import okhttp3.RequestBody;
import okhttp3.ResponseBody;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import retrofit2.Call;
import retrofit2.Callback;
import retrofit2.Response;

public class PlaceRepository {
    static final String TAG = "PlaceRepository";
    private String graphHopperBaseUrl = "https://graphhopper.com/api/1/";
    private String graphHopperKey = "917f326f-93f8-4e9f-97a0-679b508012b9";
    private final PlaceApi placeApi;
    private SimpleDateFormat sdf = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss");
    private final MutableLiveData<JSONObject> searchPoiListLiveData = new MutableLiveData();
    private String textSearchBaseUrl = "https://maps.googleapis.com/maps/api/place/textsearch/json?";
    private final MutableLiveData<JSONObject> turnByTurnResultLiveData = new MutableLiveData();

    @Inject
    public PlaceRepository() {
        this.placeApi = ApiService.getInstance().getPlaceApi();
    }

    private int SignTable(String string2) {
        string2.hashCode();
        int n = string2.hashCode();
        int n2 = 14;
        int n3 = -1;
        switch (n) {
            default: {
                break;
            }
            case 1451: {
                if (!string2.equals("-8")) break;
                n3 = 14;
                break;
            }
            case 1450: {
                if (!string2.equals("-7")) break;
                n3 = 13;
                break;
            }
            case 1449: {
                if (!string2.equals("-6")) break;
                n3 = 12;
                break;
            }
            case 1446: {
                if (!string2.equals("-3")) break;
                n3 = 11;
                break;
            }
            case 1445: {
                if (!string2.equals("-2")) break;
                n3 = 10;
                break;
            }
            case 1444: {
                if (!string2.equals("-1")) break;
                n3 = 9;
                break;
            }
            case 56: {
                if (!string2.equals("8")) break;
                n3 = 8;
                break;
            }
            case 55: {
                if (!string2.equals("7")) break;
                n3 = 7;
                break;
            }
            case 54: {
                if (!string2.equals("6")) break;
                n3 = 6;
                break;
            }
            case 53: {
                if (!string2.equals("5")) break;
                n3 = 5;
                break;
            }
            case 52: {
                if (!string2.equals("4")) break;
                n3 = 4;
                break;
            }
            case 51: {
                if (!string2.equals("3")) break;
                n3 = 3;
                break;
            }
            case 50: {
                if (!string2.equals("2")) break;
                n3 = 2;
                break;
            }
            case 49: {
                if (!string2.equals("1")) break;
                n3 = 1;
                break;
            }
            case 48: {
                if (!string2.equals("0")) break;
                n3 = 0;
            }
        }
        switch (n3) {
            default: {
                n2 = 0;
                break;
            }
            case 14: {
                n2 = 12;
                break;
            }
            case 12: {
                n2 = 32;
                break;
            }
            case 11: {
                n2 = 7;
                break;
            }
            case 10: {
                n2 = 3;
                break;
            }
            case 9: {
                n2 = 5;
                break;
            }
            case 8: {
                n2 = 11;
                break;
            }
            case 7: {
                n2 = 13;
                break;
            }
            case 6: {
                n2 = 31;
                break;
            }
            case 5: {
                n2 = 30;
                break;
            }
            case 4: {
                n2 = 33;
                break;
            }
            case 3: {
                n2 = 6;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
            case 1: {
                n2 = 4;
                break;
            }
            case 0: {
                n2 = 1;
            }
            case 13: 
        }
        return n2;
    }

    private void createFileWithByte(byte[] byArray, String string2) {
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void parseNavigation(JSONArray object) {
        void var1_6;
        block18: {
            int n;
            int n2;
            JSONArray jSONArray;
            JSONArray jSONArray2;
            double d;
            JSONArray jSONArray3;
            JSONObject jSONObject;
            JSONObject jSONObject2;
            String string2 = "loss";
            String string3 = "gain";
            String string4 = "distance";
            try {
                jSONObject2 = object.getJSONObject(0);
                jSONObject = jSONObject2.getJSONArray("paths").getJSONObject(0);
                jSONArray3 = jSONObject.getJSONArray("points");
                d = jSONObject.getDouble("distance");
                jSONArray2 = new JSONArray();
                jSONArray = jSONObject.getJSONArray("instructions");
                object = string3;
                for (n2 = 0; n2 < jSONArray.length(); ++n2) {
                    string3 = new JSONArray();
                    String string5 = jSONArray.getJSONObject(n2).getString("street_name");
                    string5.getBytes("UTF-8");
                    int n3 = jSONArray.getJSONObject(n2).getInt("sign");
                    if (n3 == 6) {
                        n = SignTableUtil.getRoundaboutMappingId(jSONArray.getJSONObject(n2), n3);
                    } else {
                        n = n3;
                        if (n3 < 100) {
                            StringBuilder stringBuilder = new StringBuilder();
                            stringBuilder.append(n3);
                            stringBuilder.append("");
                            n = SignTableUtil.SignTable(stringBuilder.toString());
                        }
                    }
                    string3.put(jSONArray.getJSONObject(n2).getJSONArray("interval").getInt(0));
                    string3.put(n);
                    string3.put(jSONArray.getJSONObject(n2).getDouble("distance"));
                    try {
                        string3.put(jSONArray.getJSONObject(n2).getLong("time"));
                    }
                    catch (Exception exception) {
                        string3.put(null);
                    }
                    string3.put((Object)string5);
                    jSONArray2.put((Object)string3);
                }
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                break block18;
            }
            catch (JSONException jSONException) {
                // empty catch block
                break block18;
            }
            {
                string3 = new JSONArray();
                for (n = 0; n < jSONArray3.length(); ++n) {
                    jSONArray = new JSONObject();
                    n2 = jSONArray3.getJSONArray(n).length();
                    if (n2 == 3) {
                        jSONArray.put("position_lat", jSONArray3.getJSONArray(n).getDouble(1));
                        jSONArray.put("position_long", jSONArray3.getJSONArray(n).getDouble(0));
                        jSONArray.put("altitude", jSONArray3.getJSONArray(n).getInt(2));
                    } else if (jSONArray3.getJSONArray(n).length() == 4) {
                        jSONArray.put("position_lat", jSONArray3.getJSONArray(n).getDouble(1));
                        jSONArray.put("position_long", jSONArray3.getJSONArray(n).getDouble(0));
                        jSONArray.put("altitude", jSONArray3.getJSONArray(n).getInt(2));
                        jSONArray.put("grade", jSONArray3.getJSONArray(n).getDouble(3));
                    }
                    string3.put((Object)jSONArray);
                }
            }
            {
                jSONArray3 = new JSONObject();
                jSONArray3.put("version", (Object)jSONObject2.getJSONObject("version"));
                jSONArray3.put("points", (Object)string3);
                jSONArray3.put(string4, d);
                jSONArray3.put("steps", (Object)jSONArray2);
                jSONArray3.put((String)object, jSONObject.getDouble((String)object));
                jSONArray3.put(string2, jSONObject.getDouble(string2));
            }
            try {
                this.turnByTurnResultLiveData.postValue((JSONObject)jSONArray3);
                Log.d((String)TAG, (String)"parseNavigation: ");
                return;
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
            }
            catch (JSONException jSONException) {}
        }
        var1_6.printStackTrace();
    }

    private void prepareEncodeRoute(JSONObject object) {
        JSONArray jSONArray = new JSONArray();
        JSONObject jSONObject = new JSONObject();
        Object object2 = new JSONArray();
        JSONObject jSONObject2 = new JSONObject();
        try {
            jSONObject2.put("distance", object.getDouble("distance"));
            jSONObject2.put("gain", object.getDouble("ascend"));
            jSONObject2.put("loss", object.getDouble("descend"));
            jSONObject2.put("instructions", (Object)object.getJSONArray("instructions"));
            jSONObject2.put("points", (Object)object.getJSONArray("points"));
            object2.put((Object)jSONObject2);
        }
        catch (JSONException jSONException) {
            jSONException.printStackTrace();
        }
        object = new JSONObject();
        try {
            object.put("major", 0);
            object.put("minor", 1);
        }
        catch (JSONException jSONException) {
            jSONException.printStackTrace();
        }
        try {
            jSONObject.put("paths", object2);
            jSONObject.put("version", object);
        }
        catch (JSONException jSONException) {
            jSONException.printStackTrace();
        }
        jSONArray.put((Object)jSONObject);
        object2 = TAG;
        object = new StringBuilder();
        ((StringBuilder)object).append("prepareEncodeRoute: brytonPlanTrip -> ");
        ((StringBuilder)object).append(jSONObject);
        Log.d((String)object2, (String)((StringBuilder)object).toString());
        this.parseNavigation(jSONArray);
    }

    public String decodeJson2GpxStr(JSONObject object) {
        boolean bl = object.has("points");
        String string2 = "";
        if (bl) {
            block16: {
                int n;
                JSONArray jSONArray;
                String string3 = string2;
                try {
                    jSONArray = object.getJSONArray("points");
                    n = 0;
                    object = string2;
                }
                catch (JSONException jSONException) {
                    jSONException.printStackTrace();
                    string2 = string3;
                }
                while (true) {
                    block17: {
                        string3 = object;
                        string2 = object;
                        if (n >= jSONArray.length()) break block16;
                        string3 = object;
                        Object object2 = jSONArray.getJSONObject(n);
                        string2 = object;
                        string3 = object;
                        if (!object2.has("position_lat")) break block17;
                        string2 = object;
                        string3 = object;
                        if (!object2.has("position_long")) break block17;
                        string3 = object;
                        double d = object2.getDouble("position_lat");
                        string3 = object;
                        double d2 = object2.getDouble("position_long");
                        string3 = object;
                        string2 = String.format(Locale.ENGLISH, "<trkpt lat=\"%f\" lon=\"%f\"></trkpt>", d, d2);
                        string3 = object;
                        string3 = object;
                        object2 = new StringBuilder();
                        string3 = object;
                        ((StringBuilder)object2).append((String)object);
                        string3 = object;
                        ((StringBuilder)object2).append(string2);
                        string3 = object;
                        string2 = ((StringBuilder)object2).toString();
                    }
                    ++n;
                    object = string2;
                }
            }
            return String.format("<gpx><trk><trkseg>%s</trkseg></trk></gpx>", string2);
        }
        return "";
    }

    public MutableLiveData<JSONObject> getSearchPoiListLiveData() {
        return this.searchPoiListLiveData;
    }

    public void getTurnByTurn(int n, double d, double d2, double d3, double d4, String string2) {
        Comparable<StringBuilder> comparable = new StringBuilder();
        comparable.append(this.graphHopperBaseUrl);
        comparable.append("route?point=%f,%f&point=%f,%f&elevation=%b&vehicle=%s&calc_points=%b&ch.disable=%b&heading=%d&heading_penalty=%d&key=%s");
        String string3 = comparable.toString();
        Locale locale = Locale.ENGLISH;
        comparable = true;
        string2 = String.format(locale, string3, d, d2, d3, d4, comparable, string2, comparable, comparable, n % 360, 300, this.graphHopperKey);
        this.placeApi.getTurnByTurn(string2).enqueue((Callback)new Callback<ResponseBody>(){

            public void onFailure(Call<ResponseBody> object, Throwable throwable) {
                String string2 = TAG;
                object = new StringBuilder();
                ((StringBuilder)object).append("onFailure: ");
                ((StringBuilder)object).append(throwable.getMessage());
                Log.d((String)string2, (String)((StringBuilder)object).toString());
                object = new JSONObject();
                try {
                    object.put("errorMsg", (Object)throwable.getLocalizedMessage());
                    PlaceRepository.this.turnByTurnResultLiveData.postValue(object);
                }
                catch (JSONException jSONException) {
                    jSONException.printStackTrace();
                }
            }

            public void onResponse(Call<ResponseBody> object, Response<ResponseBody> object2) {
                if (object2.isSuccessful()) {
                    ResponseBody responseBody = (ResponseBody)object2.body();
                    object = null;
                    try {
                        object = object2 = responseBody.string();
                    }
                    catch (IOException iOException) {
                        iOException.printStackTrace();
                    }
                    try {
                        object2 = new JSONObject((String)object);
                        object = (JSONObject)object2.getJSONArray("paths").get(0);
                        Object object3 = TAG;
                        object2 = new StringBuilder();
                        ((StringBuilder)object2).append("onResponse: pathObj -> ");
                        ((StringBuilder)object2).append(object);
                        Log.d((String)object3, (String)((StringBuilder)object2).toString());
                        object2 = object.getString("points");
                        object3 = TAG;
                        Comparable<StringBuilder> comparable = new StringBuilder();
                        comparable.append("onResponse: pointsEncodeStr -> ");
                        comparable.append(((String)object2).length());
                        Log.d((String)object3, (String)comparable.toString());
                        CharSequence charSequence = TAG;
                        object3 = new StringBuilder();
                        ((StringBuilder)object3).append("getTurnByTurn: \u958b\u59cbdecode -> ");
                        Cloneable cloneable = PlaceRepository.this.sdf;
                        comparable = new Date();
                        ((StringBuilder)object3).append(cloneable.format((Date)comparable));
                        Log.d((String)charSequence, (String)((StringBuilder)object3).toString());
                        comparable = ApiUtil.decodePolyline((String)object2, 1, true);
                        object2 = TAG;
                        charSequence = new StringBuilder();
                        ((StringBuilder)charSequence).append("getTurnByTurn: decode \u5b8c\u6210-> ");
                        object3 = PlaceRepository.this.sdf;
                        cloneable = new Date();
                        ((StringBuilder)charSequence).append(((DateFormat)object3).format((Date)cloneable));
                        Log.d((String)object2, (String)((StringBuilder)charSequence).toString());
                        object.put("points", (Object)comparable);
                        object3 = TAG;
                        object2 = new StringBuilder();
                        ((StringBuilder)object2).append("onResponse: pathObj \u89e3\u5bc6\u5b8c -> ");
                        ((StringBuilder)object2).append(object);
                        Log.d((String)object3, (String)((StringBuilder)object2).toString());
                        PlaceRepository.this.prepareEncodeRoute((JSONObject)object);
                    }
                    catch (JSONException jSONException) {
                        jSONException.printStackTrace();
                    }
                    object = TAG;
                    object2 = new StringBuilder();
                    ((StringBuilder)object2).append("onResponse: ");
                    ((StringBuilder)object2).append(responseBody.toString());
                    Log.d((String)object, (String)((StringBuilder)object2).toString());
                } else {
                    object = ErrorUtils.parseErrorByGson(object2);
                    String string2 = TAG;
                    StringBuilder stringBuilder = new StringBuilder();
                    stringBuilder.append("getTurnByTurn error message: ");
                    stringBuilder.append(((APIError)object).message());
                    Log.d((String)string2, (String)stringBuilder.toString());
                    string2 = new JSONObject();
                    try {
                        string2.put("code", object2.code());
                        string2.put("errorMsg", (Object)((APIError)object).message());
                        PlaceRepository.this.turnByTurnResultLiveData.postValue(string2);
                    }
                    catch (JSONException jSONException) {
                        jSONException.printStackTrace();
                    }
                }
            }
        });
    }

    public MutableLiveData<JSONObject> getTurnByTurnResultLiveData() {
        return this.turnByTurnResultLiveData;
    }

    public void gpx2TurnByTurnJson(String string2) {
        String string3 = RouteModeConstantsUtil.ROUTE_MODE_MTB;
        CharSequence charSequence = new StringBuilder();
        charSequence.append(this.graphHopperBaseUrl);
        charSequence.append("match?elevation=true&vehicle=");
        charSequence.append(string3);
        charSequence.append("&key=");
        charSequence.append(this.graphHopperKey);
        string3 = charSequence.toString();
        charSequence = TAG;
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("gpx2TurnByTurnJson: url = ");
        stringBuilder.append(string3);
        Log.d((String)charSequence, (String)stringBuilder.toString());
        string2 = RequestBody.create((MediaType)MediaType.parse((String)"application/gpx+xml"), (String)string2);
        this.placeApi.gpx2TurnByTurnJson(string3, "application/gpx+xml", (RequestBody)string2).enqueue((Callback)new Callback<ResponseBody>(){

            public void onFailure(Call<ResponseBody> object, Throwable throwable) {
                PlaceRepository.this.turnByTurnResultLiveData.postValue(null);
                String string2 = TAG;
                object = new StringBuilder();
                ((StringBuilder)object).append("onFailure: ");
                ((StringBuilder)object).append(throwable.getMessage());
                Log.d((String)string2, (String)((StringBuilder)object).toString());
                string2 = TAG;
                object = new StringBuilder();
                ((StringBuilder)object).append("encodeAndUploadTurnByTrunFit: \u900f\u904egraphHopper\u628aGpx\u8f49\u51fa\u6709trunByTurn\u8cc7\u8a0a onFailure");
                ((StringBuilder)object).append(throwable.getMessage());
                Log.d((String)string2, (String)((StringBuilder)object).toString());
            }

            public void onResponse(Call<ResponseBody> object, Response<ResponseBody> object2) {
                boolean bl = object2.isSuccessful();
                Object object3 = null;
                object = null;
                if (bl) {
                    Log.d((String)TAG, (String)"encodeAndUploadTurnByTrunFit: \u900f\u904egraphHopper\u628aGpx\u8f49\u51fa\u6709trunByTurn\u8cc7\u8a0a \u6210\u529f");
                    object3 = (ResponseBody)object2.body();
                    try {
                        object = object2 = object3.string();
                    }
                    catch (IOException iOException) {
                        iOException.printStackTrace();
                    }
                    try {
                        object2 = new JSONObject(object);
                        object = (JSONObject)object2.getJSONArray("paths").get(0);
                        Object object4 = TAG;
                        object2 = new StringBuilder();
                        ((StringBuilder)object2).append("onResponse: pathObj -> ");
                        ((StringBuilder)object2).append(object);
                        Log.d((String)object4, (String)((StringBuilder)object2).toString());
                        object2 = object.getString("points");
                        object4 = TAG;
                        Comparable<StringBuilder> comparable = new StringBuilder();
                        comparable.append("onResponse: pointsEncodeStr -> ");
                        comparable.append(((String)object2).length());
                        Log.d((String)object4, (String)comparable.toString());
                        Object object5 = TAG;
                        comparable = new StringBuilder();
                        comparable.append("getTurnByTurn: \u958b\u59cbdecode -> ");
                        SimpleDateFormat simpleDateFormat = PlaceRepository.this.sdf;
                        object4 = new Date();
                        comparable.append(simpleDateFormat.format((Date)object4));
                        Log.d((String)object5, (String)comparable.toString());
                        simpleDateFormat = ApiUtil.decodePolyline((String)object2, 1, true);
                        object2 = TAG;
                        object4 = new StringBuilder();
                        ((StringBuilder)object4).append("getTurnByTurn: decode \u5b8c\u6210-> ");
                        object5 = PlaceRepository.this.sdf;
                        comparable = new Date();
                        ((StringBuilder)object4).append(((DateFormat)object5).format((Date)comparable));
                        Log.d((String)object2, (String)((StringBuilder)object4).toString());
                        object.put("points", (Object)simpleDateFormat);
                        object2 = TAG;
                        object4 = new StringBuilder();
                        ((StringBuilder)object4).append("onResponse: pathObj \u89e3\u5bc6\u5b8c -> ");
                        ((StringBuilder)object4).append(object);
                        Log.d((String)object2, (String)((StringBuilder)object4).toString());
                        PlaceRepository.this.prepareEncodeRoute((JSONObject)object);
                    }
                    catch (JSONException jSONException) {
                        jSONException.printStackTrace();
                    }
                    object2 = TAG;
                    object = new StringBuilder();
                    ((StringBuilder)object).append("onResponse: ");
                    ((StringBuilder)object).append(object3.toString());
                    Log.d((String)object2, (String)((StringBuilder)object).toString());
                } else {
                    object = object2.errorBody();
                    try {
                        object = object.string();
                    }
                    catch (IOException iOException) {
                        iOException.printStackTrace();
                        object = object3;
                    }
                    try {
                        object3 = new JSONObject((String)object);
                        String string2 = TAG;
                        object = new StringBuilder();
                        ((StringBuilder)object).append("encodeAndUploadTurnByTrunFit: \u900f\u904egraphHopper\u628aGpx\u8f49\u51fa\u6709trunByTurn\u8cc7\u8a0a code: ");
                        ((StringBuilder)object).append(object2.code());
                        ((StringBuilder)object).append(", error: ");
                        ((StringBuilder)object).append(object3.toString());
                        Log.d((String)string2, (String)((StringBuilder)object).toString());
                    }
                    catch (JSONException jSONException) {
                        jSONException.printStackTrace();
                    }
                    object = ErrorUtils.parseError(object2);
                    new AccountErrorVo(object2.code(), ((APIError)object).message());
                    object3 = TAG;
                    object2 = new StringBuilder();
                    ((StringBuilder)object2).append("getTurnByTurn error message: ");
                    ((StringBuilder)object2).append(((APIError)object).message());
                    Log.d((String)object3, (String)((StringBuilder)object2).toString());
                }
            }
        });
    }

    public void searchPoiUseTextSearch(final double d, final double d2, String string2, String string3) {
        CharSequence charSequence = new StringBuilder();
        charSequence.append(this.textSearchBaseUrl);
        charSequence.append("location=%f,%f&query=%s&language=%s&rankby=%s&key=%s");
        charSequence = charSequence.toString();
        string2 = String.format(Locale.ENGLISH, (String)charSequence, d, d2, string2, string3, "distance", "AIzaSyDG7rU2pthFKW3M3Pw0Br_ZiuUr_iZQxeM");
        this.placeApi.searchPoiUseTextSearch(string2).enqueue((Callback)new Callback<ResponseBody>(){

            public void onFailure(Call<ResponseBody> object, Throwable throwable) {
                String string2 = TAG;
                object = new StringBuilder();
                ((StringBuilder)object).append("onFailure: ");
                ((StringBuilder)object).append(throwable.getMessage());
                Log.d((String)string2, (String)((StringBuilder)object).toString());
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            public void onResponse(Call<ResponseBody> object, Response<ResponseBody> object2) {
                Object object3;
                block14: {
                    int n;
                    JSONArray jSONArray;
                    JSONObject jSONObject2;
                    JSONObject jSONObject;
                    String string5 = "lng";
                    String string4 = "lat";
                    String string3 = "location";
                    Comparator<JSONObject> comparator = "geometry";
                    String string2 = "name";
                    if (!object2.isSuccessful()) {
                        object = ErrorUtils.parseError(object2);
                        new AccountErrorVo(object2.code(), ((APIError)object).message());
                        String string6 = TAG;
                        object2 = new StringBuilder();
                        ((StringBuilder)object2).append("searchPoiUseTextSearch error message: ");
                        ((StringBuilder)object2).append(((APIError)object).message());
                        Log.d((String)string6, (String)((StringBuilder)object2).toString());
                        return;
                    }
                    object = (ResponseBody)object2.body();
                    object3 = null;
                    try {
                        object3 = object2 = object.string();
                    }
                    catch (IOException iOException) {
                        iOException.printStackTrace();
                    }
                    object2 = object;
                    try {
                        object2 = object;
                        jSONObject = new JSONObject((String)object3);
                        object2 = object;
                        if (jSONObject.getString("status").equals("ZERO_RESULTS")) {
                            object2 = object;
                            object2 = object;
                            object3 = new JSONObject();
                            object2 = object;
                            PlaceRepository.this.searchPoiListLiveData.postValue(object3);
                            return;
                        }
                        object2 = object;
                        jSONObject = jSONObject.getJSONArray("results");
                        object2 = object;
                        object2 = object;
                        jSONObject2 = new JSONObject();
                        object2 = object;
                        object2 = object;
                        jSONArray = new JSONArray();
                        n = 0;
                        object3 = string2;
                        string2 = jSONObject;
                    }
                    catch (JSONException jSONException) {
                        object = object2;
                        break block14;
                    }
                    while (true) {
                        object2 = object;
                        if (n >= string2.length()) break;
                        object2 = object;
                        object2 = object;
                        JSONObject jSONObject3 = new JSONObject();
                        object2 = object;
                        jSONObject3.put("idx", n);
                        object2 = object;
                        jSONObject3.put((String)object3, (Object)string2.getJSONObject(n).getString((String)object3));
                        object2 = object;
                        jSONObject3.put("vicinity", (Object)string2.getJSONObject(n).getString("formatted_address"));
                        object2 = object;
                        object2 = object;
                        jSONObject = new JSONObject();
                        object2 = object;
                        double d4 = string2.getJSONObject(n).getJSONObject((String)((Object)comparator)).getJSONObject(string3).getDouble(string4);
                        object2 = object;
                        double d22 = string2.getJSONObject(n).getJSONObject((String)((Object)comparator)).getJSONObject(string3).getDouble(string5);
                        object2 = object;
                        jSONObject.put(string4, d4);
                        object2 = object;
                        jSONObject.put(string5, d22);
                        object2 = object;
                        jSONObject3.put("latlng", (Object)jSONObject);
                        object2 = object;
                        jSONObject3.put("placeId", (Object)string2.getJSONObject(n).getString("place_id"));
                        object2 = object;
                        double d3 = d;
                        jSONObject3.put("distance", DistanceUtil.distance(d4, d22, d3, d2));
                        jSONArray.put((Object)jSONObject3);
                        ++n;
                        continue;
                        break;
                    }
                    object2 = object;
                    object3 = new ArrayList();
                    for (n = 0; n < jSONArray.length(); ++n) {
                        object3.add(jSONArray.getJSONObject(n));
                    }
                    try {
                        comparator = new Comparator<JSONObject>(){

                            @Override
                            public int compare(JSONObject jSONObject, JSONObject jSONObject2) {
                                double d;
                                double d2;
                                try {
                                    d2 = jSONObject.getDouble("distance");
                                    d = jSONObject2.getDouble("distance");
                                }
                                catch (JSONException jSONException) {
                                    jSONException.printStackTrace();
                                    return 0;
                                }
                                int n = d2 > d ? 1 : -1;
                                return n;
                            }
                        };
                        Collections.sort(object3, comparator);
                        comparator = new Comparator<JSONObject>();
                        for (n = 0; n < object3.size(); ++n) {
                            comparator.put(object3.get(n));
                        }
                    }
                    catch (JSONException jSONException) {}
                    jSONObject2.put("data", (Object)comparator);
                    PlaceRepository.this.searchPoiListLiveData.postValue(jSONObject2);
                    object = object2;
                }
                object3.printStackTrace();
                object3 = TAG;
                object2 = new StringBuilder();
                ((StringBuilder)object2).append("onResponse: ");
                ((StringBuilder)object2).append(object.toString());
                Log.d((String)object3, (String)((StringBuilder)object2).toString());
            }
        });
    }
}

