/*
 * Decompiled with CFR 0.152.
 */
package com.brytonsport.active.repo.course;

import android.content.Context;
import android.util.Log;
import androidx.lifecycle.MutableLiveData;
import androidx.lifecycle.Observer;
import com.brytonsport.active.api.ApiService;
import com.brytonsport.active.api.ErrorUtils;
import com.brytonsport.active.api.account.vo.AccountErrorVo;
import com.brytonsport.active.api.course.PlanTripWorkoutApi;
import com.brytonsport.active.base.App;
import com.brytonsport.active.db.AppDatabase;
import com.brytonsport.active.db.course.dao.FileIdHistoryDao;
import com.brytonsport.active.db.course.entity.FileIdHistoryEntity;
import com.brytonsport.active.fit.BrytonPlanTrip;
import com.brytonsport.active.repo.course.PlanTripRepository$$ExternalSyntheticLambda0;
import com.brytonsport.active.utils.ActivityFileUtil;
import com.brytonsport.active.utils.BrytonErrorCodeUtil;
import com.brytonsport.active.utils.FileIdHistoryUtil;
import com.brytonsport.active.utils.NetworkUtil;
import com.brytonsport.active.utils.PlanTripUtil;
import com.brytonsport.active.utils.ProfileUtil;
import com.brytonsport.active.vm.base.Route;
import com.brytonsport.active.vm.base.RouteDecodeState;
import com.brytonsport.active.vm.base.RouteGetImage;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.inject.Inject;
import okhttp3.MediaType;
import okhttp3.MultipartBody;
import okhttp3.RequestBody;
import okhttp3.ResponseBody;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import retrofit2.Call;
import retrofit2.Callback;
import retrofit2.Response;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class PlanTripRepository {
    static final String TAG = "PlanTripRepository";
    private int deletePlanTripErrorCount = 0;
    private int deletePlanTripOkCount = 0;
    private int deletePlanTripTimeoutCount = 0;
    private int deletePlanTripTotalNum = 0;
    private final FileIdHistoryDao fileIdHistoryDao;
    private final MutableLiveData<RouteGetImage> getRouteImageSaveLiveData;
    private final MutableLiveData<JSONObject> getShareRouteFileLiveData;
    private final MutableLiveData<Boolean> isPlanTripUpdateLiveData;
    private final MutableLiveData<Boolean> isPlanTripUploadLiveData;
    private final MutableLiveData<AccountErrorVo> liveAccountErrorResponse;
    private MutableLiveData<Boolean> planTripDeleteFor3rdPartySyncLive;
    private MutableLiveData<Boolean> planTripDeleteResultLive;
    private MutableLiveData<Boolean> planTripFitDownloadLiveData;
    private final PlanTripWorkoutApi planTripWorkoutApi;
    private final MutableLiveData<RouteDecodeState> routeDecodeStateLiveData;
    private final MutableLiveData<List<Route>> routeListResultLiveData = new MutableLiveData();
    String staticMapBaseUrl = "http://tiles.brytonfit.com/styles/terrain/static/auto/100x100.png?stroke=blue&width=3&path=|%s";

    @Inject
    public PlanTripRepository() {
        this.getRouteImageSaveLiveData = new MutableLiveData();
        this.isPlanTripUploadLiveData = new MutableLiveData();
        this.isPlanTripUpdateLiveData = new MutableLiveData();
        this.planTripDeleteResultLive = new MutableLiveData();
        this.routeDecodeStateLiveData = new MutableLiveData();
        this.planTripFitDownloadLiveData = new MutableLiveData();
        this.planTripDeleteFor3rdPartySyncLive = new MutableLiveData();
        this.liveAccountErrorResponse = new MutableLiveData();
        this.getShareRouteFileLiveData = new MutableLiveData();
        this.planTripWorkoutApi = ApiService.getInstance().getPlanTripWorkoutApi();
        this.fileIdHistoryDao = AppDatabase.getInstance(App.getInstance().getApplicationContext()).fileIdHistoryDao();
    }

    private void checkAndSaveDelete3rdPartyFileId(Route route) {
        int n = FileIdHistoryUtil.getTypeBy3rdPartyProvider(route.provider);
        if (n != FileIdHistoryUtil.TYPE_NONE) {
            this.addNewFileIdHistory(n, route.orgID);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void countDeletePlanTrip(NetworkUtil.ApiResultState object) {
        synchronized (this) {
            int n;
            block14: {
                block13: {
                    n = 12.$SwitchMap$com$brytonsport$active$utils$NetworkUtil$ApiResultState[((Enum)object).ordinal()];
                    if (n == 1) break block13;
                    if (n != 2) {
                        if (n == 3) {
                            ++this.deletePlanTripTimeoutCount;
                        }
                        break block14;
                    } else {
                        ++this.deletePlanTripErrorCount;
                    }
                    break block14;
                }
                ++this.deletePlanTripOkCount;
            }
            String string2 = String.format("countDeletePlanTrip: \u522a\u9664\u6210\u529f %d\u7b46\uff0c\u5931\u6557 %d\u7b46\uff0cTimeout %d\u7b46", this.deletePlanTripOkCount, this.deletePlanTripErrorCount, this.deletePlanTripTimeoutCount);
            String string3 = TAG;
            Log.d((String)string3, (String)string2);
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append(string2);
            stringBuilder.append("\uff0c\u9700\u8981\u522a\u9664\u7684\u7e3d\u7b46\u6578");
            stringBuilder.append(this.deletePlanTripTotalNum);
            stringBuilder.append("\u7b46");
            Log.d((String)string3, (String)stringBuilder.toString());
            n = this.deletePlanTripTotalNum;
            if (n == 1) {
                if (this.deletePlanTripOkCount == n) {
                    this.planTripDeleteResultLive.postValue(true);
                } else {
                    this.planTripDeleteResultLive.postValue(false);
                }
            } else {
                int n2 = this.deletePlanTripOkCount;
                if (this.deletePlanTripErrorCount + n2 + this.deletePlanTripTimeoutCount == n) {
                    if (n2 == n) {
                        this.planTripDeleteResultLive.postValue(true);
                    } else {
                        this.planTripDeleteResultLive.postValue(false);
                    }
                }
            }
            return;
        }
    }

    private void fitDecodeOk(String charSequence, JSONObject object, String string2) {
        String string3 = TAG;
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("");
        stringBuilder.append(string2);
        stringBuilder.append(" fitDecodeOk");
        Log.d((String)string3, (String)stringBuilder.toString());
        if (object.has("points")) {
            object = object.getJSONArray("points");
            string3 = new JSONArray();
            int n = 0;
            while (true) {
                if (n >= object.length()) break;
                stringBuilder = object.getJSONObject(n);
                if (stringBuilder.has("position_lat") && stringBuilder.has("position_long") && stringBuilder.getDouble("position_lat") != -1.0 && stringBuilder.getDouble("position_long") != -1.0) {
                    string3.put((Object)stringBuilder);
                }
                ++n;
                continue;
                break;
            }
            try {
                if (string3.length() <= 0) {
                    object = TAG;
                    charSequence = new StringBuilder();
                    ((StringBuilder)charSequence).append("");
                    ((StringBuilder)charSequence).append(string2);
                    ((StringBuilder)charSequence).append(" \u6c92\u9ede\u6c92\u8fa6\u6cd5\u756b");
                    Log.d((String)object, (String)((StringBuilder)charSequence).toString());
                } else {
                    if (string3.length() == 1) {
                        string3.put((Object)string3.getJSONObject(0));
                    }
                    this.getStaticMap((String)charSequence, this.shrinkSameple((JSONArray)string3, 50, string2), string2);
                }
            }
            catch (JSONException jSONException) {
                jSONException.printStackTrace();
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void getStaticMap(String string2, JSONArray jSONArray, final String string3) {
        CharSequence charSequence;
        final String string4 = ProfileUtil.getInstance().getPrefString("userId");
        String string5 = ProfileUtil.getInstance().getPrefString("com.brytonsport.active.loginToken");
        string2 = "";
        int n = 0;
        while (true) {
            charSequence = string2;
            String string6 = string2;
            try {
                if (n >= jSONArray.length()) break;
                string6 = string2;
                charSequence = jSONArray.getJSONObject(n);
                string6 = string2;
                double d = charSequence.getDouble("position_lat");
                string6 = string2;
                double d2 = charSequence.getDouble("position_long");
                string6 = string2;
                string6 = string2;
                charSequence = new StringBuilder();
                string6 = string2;
                ((StringBuilder)charSequence).append(string2);
                string6 = string2;
                ((StringBuilder)charSequence).append(String.format(Locale.ENGLISH, "%.6f,%.6f", d2, d));
                string6 = string2;
                string6 = string2 = ((StringBuilder)charSequence).toString();
                string6 = string2;
                charSequence = new StringBuilder();
                string6 = string2;
                ((StringBuilder)charSequence).append(string2);
                string6 = string2;
                ((StringBuilder)charSequence).append("|");
                string6 = string2;
                string2 = ((StringBuilder)charSequence).toString();
                ++n;
            }
            catch (Exception exception) {
                charSequence = string6;
                break;
            }
        }
        string2 = String.format(this.staticMapBaseUrl, charSequence);
        this.planTripWorkoutApi.downloadFitWithDynamicUrl(string4, string5, string2).enqueue((Callback)new Callback<ResponseBody>(){

            public void onFailure(Call<ResponseBody> call, Throwable throwable) {
                Log.e((String)TAG, (String)"error");
                PlanTripRepository.this.getRouteImageSaveLiveData.postValue(new RouteGetImage(string3, false));
            }

            public void onResponse(Call<ResponseBody> object, Response<ResponseBody> object2) {
                if (object2.isSuccessful()) {
                    object = App.getInstance();
                    object2 = (ResponseBody)object2.body();
                    StringBuilder stringBuilder = new StringBuilder();
                    stringBuilder.append(string4);
                    stringBuilder.append("/png");
                    String string2 = stringBuilder.toString();
                    stringBuilder = new StringBuilder();
                    stringBuilder.append(string3);
                    stringBuilder.append(".png");
                    boolean bl = ActivityFileUtil.writeResponseBodyToDisk(object, object2, string2, stringBuilder.toString());
                    object2 = TAG;
                    object = new StringBuilder();
                    ((StringBuilder)object).append(string3);
                    ((StringBuilder)object).append(".png download was a success? ");
                    ((StringBuilder)object).append(bl);
                    Log.d((String)object2, (String)((StringBuilder)object).toString());
                    if (bl) {
                        object = new StringBuilder();
                        ((StringBuilder)object).append(string4);
                        ((StringBuilder)object).append("/png");
                        ((StringBuilder)object).append(File.separator);
                        ((StringBuilder)object).append(string3);
                        ((StringBuilder)object).append(".png");
                        object2 = ((StringBuilder)object).toString();
                        object = TAG;
                        stringBuilder = new StringBuilder();
                        stringBuilder.append("onResponse: \u7e2e\u5716\u8def\u5f91 -> ");
                        stringBuilder.append(string3);
                        stringBuilder.append(", path: ");
                        stringBuilder.append((String)object2);
                        Log.d((String)object, (String)stringBuilder.toString());
                        PlanTripRepository.this.getRouteImageSaveLiveData.postValue(new RouteGetImage(string3, true));
                    }
                } else {
                    Log.d((String)TAG, (String)"server contact failed");
                    PlanTripRepository.this.getRouteImageSaveLiveData.postValue(new RouteGetImage(string3, false));
                }
            }
        });
    }

    /*
     * Exception decompiling
     */
    private void planTripListToDisplayModel(JSONObject var1_1) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private JSONArray shrinkSameple(JSONArray jSONArray, int n, String string2) {
        String string3 = TAG;
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("");
        stringBuilder.append(string2);
        stringBuilder.append(" shrinkSameple size: ");
        stringBuilder.append(jSONArray.length());
        stringBuilder.append(", \u8981\u7e2e\u6210\u5e7e\u7b46: ");
        stringBuilder.append(n);
        Log.d((String)string3, (String)stringBuilder.toString());
        int n2 = jSONArray.length();
        int n3 = n2 / n;
        if (n2 <= n) {
            return jSONArray;
        }
        string2 = new JSONArray();
        for (n = 0; n < n2; ++n) {
            if (n % n3 == 0) {
                string2.put((Object)jSONArray.getJSONObject(n));
                continue;
            }
            if (n != n2 - 1) continue;
            try {
                string2.put((Object)jSONArray.getJSONObject(n));
            }
            catch (JSONException jSONException) {
                jSONException.printStackTrace();
                break;
            }
            continue;
        }
        return string2;
    }

    public void addNewFileIdHistory(int n, String string2) {
        new Thread(new PlanTripRepository$$ExternalSyntheticLambda0(this, n, string2)).start();
    }

    public void decodeActivityFit(String string2, String string3, String string4) {
        this.decodeActivityFit(string2, string3, string4, true);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void decodeActivityFit(String string2, String mutableLiveData, String string3, boolean bl) {
        Object object = App.getInstance().getFilesDir();
        CharSequence charSequence = new StringBuilder();
        ((StringBuilder)charSequence).append(object);
        ((StringBuilder)charSequence).append(File.separator);
        ((StringBuilder)charSequence).append((String)((Object)mutableLiveData));
        ((StringBuilder)charSequence).append(File.separator);
        ((StringBuilder)charSequence).append(string3);
        ((StringBuilder)charSequence).append(".fit");
        mutableLiveData = ((StringBuilder)charSequence).toString();
        object = new BrytonPlanTrip();
        ((BrytonPlanTrip)object).encodeFileSet((String)((Object)mutableLiveData));
        mutableLiveData = new JSONObject();
        try {
            block7: {
                block8: {
                    if (!((BrytonPlanTrip)object).decode((JSONObject)mutableLiveData)) {
                        mutableLiveData = TAG;
                        object = new StringBuilder();
                        ((StringBuilder)object).append("");
                        ((StringBuilder)object).append(string3);
                        ((StringBuilder)object).append(" decode error");
                        Log.d((String)((Object)mutableLiveData), (String)((StringBuilder)object).toString());
                        mutableLiveData = this.routeDecodeStateLiveData;
                        object = new RouteDecodeState(string2, false);
                        mutableLiveData.postValue((RouteDecodeState)object);
                        return;
                    }
                    charSequence = TAG;
                    object = new StringBuilder();
                    ((StringBuilder)object).append("");
                    ((StringBuilder)object).append(string3);
                    ((StringBuilder)object).append(" decode ok");
                    Log.d((String)charSequence, (String)((StringBuilder)object).toString());
                    if (!mutableLiveData.has("steps")) break block8;
                    if (mutableLiveData.getJSONArray("steps").length() > 0) {
                        boolean bl2 = mutableLiveData.has("stepHasTurnInfoManeuver") ? mutableLiveData.getBoolean("stepHasTurnInfoManeuver") : false;
                        if (bl2) {
                            PlanTripUtil.writePlanTripTurn2Pref(string2, true);
                            break block7;
                        } else {
                            PlanTripUtil.writePlanTripTurn2Pref(string2, false);
                        }
                        break block7;
                    } else {
                        PlanTripUtil.writePlanTripTurn2Pref(string2, false);
                    }
                    break block7;
                }
                PlanTripUtil.writePlanTripTurn2Pref(string2, false);
            }
            if (!bl) return;
            this.fitDecodeOk(string2, (JSONObject)mutableLiveData, string3);
            return;
        }
        catch (Exception exception) {
            object = TAG;
            charSequence = new StringBuilder();
            ((StringBuilder)charSequence).append("");
            ((StringBuilder)charSequence).append(string3);
            ((StringBuilder)charSequence).append(" decode Exception: ");
            ((StringBuilder)charSequence).append(exception.getMessage());
            Log.d((String)object, (String)((StringBuilder)charSequence).toString());
            this.routeDecodeStateLiveData.postValue(new RouteDecodeState(string2, false));
        }
    }

    public JSONObject decodeActivityFitSync(String object, String object2, String string2) {
        object = App.getInstance().getFilesDir();
        CharSequence charSequence = new StringBuilder();
        ((StringBuilder)charSequence).append(object);
        ((StringBuilder)charSequence).append(File.separator);
        ((StringBuilder)charSequence).append((String)object2);
        ((StringBuilder)charSequence).append(File.separator);
        ((StringBuilder)charSequence).append(string2);
        ((StringBuilder)charSequence).append(".fit");
        object = ((StringBuilder)charSequence).toString();
        object2 = new BrytonPlanTrip();
        ((BrytonPlanTrip)object2).encodeFileSet((String)object);
        object = new JSONObject();
        try {
            if (((BrytonPlanTrip)object2).decode((JSONObject)object)) {
                object2 = TAG;
                charSequence = new StringBuilder();
                ((StringBuilder)charSequence).append("");
                ((StringBuilder)charSequence).append(string2);
                ((StringBuilder)charSequence).append(" decode ok");
                Log.d((String)object2, (String)((StringBuilder)charSequence).toString());
            } else {
                object2 = TAG;
                charSequence = new StringBuilder();
                ((StringBuilder)charSequence).append("");
                ((StringBuilder)charSequence).append(string2);
                ((StringBuilder)charSequence).append(" decode error");
                Log.d((String)object2, (String)((StringBuilder)charSequence).toString());
            }
        }
        catch (Exception exception) {
            charSequence = TAG;
            object2 = new StringBuilder();
            ((StringBuilder)object2).append("");
            ((StringBuilder)object2).append(string2);
            ((StringBuilder)object2).append(" decode Exception: ");
            ((StringBuilder)object2).append(exception.getMessage());
            Log.d((String)charSequence, (String)((StringBuilder)object2).toString());
        }
        return object;
    }

    public JSONObject decodePlanTripFitForDetail(String charSequence, String string2, String string3) {
        string2 = this.getPlanTripFitFilepath((String)charSequence, string2, string3);
        Object object = new BrytonPlanTrip();
        ((BrytonPlanTrip)object).encodeFileSet(string2);
        string2 = new JSONObject();
        try {
            if (((BrytonPlanTrip)object).decode((JSONObject)string2)) {
                object = TAG;
                StringBuilder stringBuilder = new StringBuilder();
                stringBuilder.append("");
                stringBuilder.append(string3);
                stringBuilder.append(" decode ok");
                Log.d((String)object, (String)stringBuilder.toString());
                this.fitDecodeOk((String)charSequence, (JSONObject)string2, string3);
            } else {
                charSequence = TAG;
                object = new StringBuilder();
                ((StringBuilder)object).append("");
                ((StringBuilder)object).append(string3);
                ((StringBuilder)object).append(" decode error");
                Log.d((String)charSequence, (String)((StringBuilder)object).toString());
            }
        }
        catch (Exception exception) {
            object = TAG;
            charSequence = new StringBuilder();
            ((StringBuilder)charSequence).append("");
            ((StringBuilder)charSequence).append(string3);
            ((StringBuilder)charSequence).append(" decode Exception: ");
            ((StringBuilder)charSequence).append(exception.getMessage());
            Log.d((String)object, (String)((StringBuilder)charSequence).toString());
        }
        return string2;
    }

    public JSONObject decodePlantripFitForGr(String charSequence, String string2) {
        Object object;
        block7: {
            object = App.getInstance().getFilesDir();
            if (charSequence == null) {
                charSequence = new StringBuilder();
                ((StringBuilder)charSequence).append(object);
                ((StringBuilder)charSequence).append(File.separator);
                ((StringBuilder)charSequence).append(string2);
                ((StringBuilder)charSequence).append(".fit");
                charSequence = ((StringBuilder)charSequence).toString();
            } else {
                StringBuilder stringBuilder = new StringBuilder();
                stringBuilder.append(object);
                stringBuilder.append(File.separator);
                stringBuilder.append((String)charSequence);
                stringBuilder.append(File.separator);
                stringBuilder.append(string2);
                stringBuilder.append(".fit");
                charSequence = stringBuilder.toString();
            }
            object = new BrytonPlanTrip();
            ((BrytonPlanTrip)object).encodeFileSet((String)charSequence);
            charSequence = new JSONObject();
            try {
                if (!((BrytonPlanTrip)object).decode((JSONObject)charSequence)) break block7;
                string2 = new JSONObject();
                string2.put("data", (Object)charSequence);
                return string2;
            }
            catch (Exception exception) {
                charSequence = new JSONObject();
                try {
                    charSequence.put("message", (Object)exception.getMessage());
                }
                catch (JSONException jSONException) {
                    jSONException.printStackTrace();
                }
                return charSequence;
            }
        }
        object = new JSONObject();
        charSequence = new StringBuilder();
        ((StringBuilder)charSequence).append("decode GR route ");
        ((StringBuilder)charSequence).append(string2);
        ((StringBuilder)charSequence).append(" error");
        object.put("message", (Object)((StringBuilder)charSequence).toString());
        return object;
    }

    public MutableLiveData<JSONObject> decodePlantripFitForShare(String charSequence, String string2) {
        MutableLiveData<JSONObject> mutableLiveData = new MutableLiveData<JSONObject>();
        Object object = App.getInstance().getFilesDir();
        if (charSequence == null) {
            charSequence = new StringBuilder();
            ((StringBuilder)charSequence).append(object);
            ((StringBuilder)charSequence).append(File.separator);
            ((StringBuilder)charSequence).append(string2);
            ((StringBuilder)charSequence).append(".fit");
            charSequence = ((StringBuilder)charSequence).toString();
        } else {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append(object);
            stringBuilder.append(File.separator);
            stringBuilder.append((String)charSequence);
            stringBuilder.append(File.separator);
            stringBuilder.append(string2);
            stringBuilder.append(".fit");
            charSequence = stringBuilder.toString();
        }
        object = new BrytonPlanTrip();
        ((BrytonPlanTrip)object).encodeFileSet((String)charSequence);
        charSequence = new JSONObject();
        try {
            if (((BrytonPlanTrip)object).decode((JSONObject)charSequence)) {
                string2 = new JSONObject();
                string2.put("data", (Object)charSequence);
                mutableLiveData.postValue((JSONObject)string2);
            } else {
                object = new JSONObject();
                charSequence = new StringBuilder();
                ((StringBuilder)charSequence).append("decode share route ");
                ((StringBuilder)charSequence).append(string2);
                ((StringBuilder)charSequence).append(" error");
                object.put("message", (Object)((StringBuilder)charSequence).toString());
                mutableLiveData.postValue((JSONObject)object);
            }
        }
        catch (Exception exception) {
            charSequence = new JSONObject();
            try {
                charSequence.put("message", (Object)exception.getMessage());
            }
            catch (JSONException jSONException) {
                jSONException.printStackTrace();
            }
            mutableLiveData.postValue((JSONObject)charSequence);
        }
        return mutableLiveData;
    }

    public void deletePlanTrip(Route route) {
        this.deletePlanTripTotalNum = 1;
        this.deletePlanTripByRoute(route);
    }

    public void deletePlanTripByRoute(final Route route) {
        final String string2 = route.id;
        String string3 = ProfileUtil.getInstance().getPrefString("userId");
        String string4 = ProfileUtil.getInstance().getPrefString("com.brytonsport.active.loginToken");
        this.planTripWorkoutApi.deletePlanTrip(string3, string4, string2).enqueue((Callback)new Callback<ResponseBody>(){

            public void onFailure(Call<ResponseBody> object, Throwable throwable) {
                object = new StringBuilder();
                ((StringBuilder)object).append("deletePlanTrip -> ");
                ((StringBuilder)object).append(string2);
                ((StringBuilder)object).append(" onFailure : ");
                ((StringBuilder)object).append(throwable.getMessage());
                object = ((StringBuilder)object).toString();
                Log.d((String)TAG, (String)object);
                PlanTripRepository.this.countDeletePlanTrip(NetworkUtil.ApiResultState.TIMEOUT);
            }

            public void onResponse(Call<ResponseBody> object, Response<ResponseBody> object2) {
                if (object2.isSuccessful()) {
                    object = NetworkUtil.parseResponseBody(object2);
                    object2 = TAG;
                    StringBuilder stringBuilder = new StringBuilder();
                    stringBuilder.append("delete ");
                    stringBuilder.append(string2);
                    stringBuilder.append(" success: ");
                    stringBuilder.append((String)object);
                    Log.d((String)object2, (String)stringBuilder.toString());
                    PlanTripRepository.this.checkAndSaveDelete3rdPartyFileId(route);
                    PlanTripRepository.this.countDeletePlanTrip(NetworkUtil.ApiResultState.SUCCESS);
                } else {
                    object = NetworkUtil.parseResponseErrorBody(object2);
                    object2 = new StringBuilder();
                    ((StringBuilder)object2).append("deletePlanTrip -> ");
                    ((StringBuilder)object2).append(string2);
                    ((StringBuilder)object2).append(" error: ");
                    ((StringBuilder)object2).append((String)object);
                    object = ((StringBuilder)object2).toString();
                    Log.d((String)TAG, object);
                    PlanTripRepository.this.countDeletePlanTrip(NetworkUtil.ApiResultState.FAILURE);
                }
            }
        });
    }

    public void deletePlanTripFor3rdPartySync(Route object) {
        final String string2 = ((Route)object).id;
        object = ProfileUtil.getInstance().getPrefString("userId");
        String string3 = ProfileUtil.getInstance().getPrefString("com.brytonsport.active.loginToken");
        this.planTripWorkoutApi.deletePlanTrip((String)object, string3, string2).enqueue((Callback)new Callback<ResponseBody>(){

            public void onFailure(Call<ResponseBody> object, Throwable throwable) {
                object = new StringBuilder();
                ((StringBuilder)object).append("deletePlanTripFor3rdPartySync -> ");
                ((StringBuilder)object).append(string2);
                ((StringBuilder)object).append(" onFailure : ");
                ((StringBuilder)object).append(throwable.getMessage());
                object = ((StringBuilder)object).toString();
                Log.d((String)TAG, (String)object);
                PlanTripRepository.this.planTripDeleteFor3rdPartySyncLive.postValue(false);
            }

            public void onResponse(Call<ResponseBody> object, Response<ResponseBody> object2) {
                if (object2.isSuccessful()) {
                    object = NetworkUtil.parseResponseBody(object2);
                    object2 = TAG;
                    StringBuilder stringBuilder = new StringBuilder();
                    stringBuilder.append("deletePlanTripFor3rdPartySync ");
                    stringBuilder.append(string2);
                    stringBuilder.append(" success: ");
                    stringBuilder.append((String)object);
                    Log.d((String)object2, (String)stringBuilder.toString());
                    PlanTripRepository.this.planTripDeleteFor3rdPartySyncLive.postValue(true);
                } else {
                    object = NetworkUtil.parseResponseErrorBody(object2);
                    object2 = new StringBuilder();
                    ((StringBuilder)object2).append("deletePlanTripFor3rdPartySync -> ");
                    ((StringBuilder)object2).append(string2);
                    ((StringBuilder)object2).append(" error: ");
                    ((StringBuilder)object2).append((String)object);
                    object = ((StringBuilder)object2).toString();
                    Log.d((String)TAG, object);
                    PlanTripRepository.this.planTripDeleteFor3rdPartySyncLive.postValue(false);
                }
            }
        });
    }

    public void deletePlanTripList(List<Route> object) {
        this.deletePlanTripTotalNum = object.size();
        Iterator<Route> iterator = object.iterator();
        while (iterator.hasNext()) {
            object = iterator.next();
            if (((Route)object).isKomootLockRoute) {
                this.checkAndSaveDelete3rdPartyFileId((Route)object);
                continue;
            }
            this.deletePlanTripByRoute((Route)object);
        }
    }

    public void encodePlanTripToFit(JSONObject jSONObject, String string2) {
        Object object = App.getInstance().getFilesDir();
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(object);
        stringBuilder.append(File.separator);
        stringBuilder.append(string2);
        string2 = stringBuilder.toString();
        object = new BrytonPlanTrip();
        ((BrytonPlanTrip)object).encodeFileSet(string2);
        ((BrytonPlanTrip)object).encode(jSONObject);
    }

    public void encodePlanTripToFitWithPath(JSONObject jSONObject, String string2, String object) {
        File file = App.getInstance().getFilesDir();
        Comparable<StringBuilder> comparable = new StringBuilder();
        ((StringBuilder)comparable).append(file);
        ((StringBuilder)comparable).append(File.separator);
        ((StringBuilder)comparable).append((String)object);
        comparable = new File(((StringBuilder)comparable).toString());
        if (!((File)comparable).exists()) {
            ((File)comparable).mkdirs();
        }
        comparable = new StringBuilder();
        ((StringBuilder)comparable).append(file);
        ((StringBuilder)comparable).append(File.separator);
        ((StringBuilder)comparable).append((String)object);
        ((StringBuilder)comparable).append(File.separator);
        ((StringBuilder)comparable).append(string2);
        string2 = ((StringBuilder)comparable).toString();
        object = new File(string2);
        if (!((File)object).exists()) {
            try {
                ((File)object).createNewFile();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
        object = new BrytonPlanTrip();
        ((BrytonPlanTrip)object).encodeFileSet(string2);
        ((BrytonPlanTrip)object).encode(jSONObject);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public JSONObject getAbstract(JSONObject jSONObject) {
        Date date;
        JSONObject jSONObject2;
        try {
            jSONObject2 = new JSONObject();
            jSONObject2.put("ver", 1);
            date = new Date();
            jSONObject2.put("updateAt", date.getTime());
            boolean bl = jSONObject.has("gain");
            int n = 0;
            if (bl) {
                jSONObject2.put("altGain", jSONObject.getDouble("gain"));
            } else {
                jSONObject2.put("altGain", 0);
            }
            if (jSONObject.has("distance")) {
                jSONObject2.put("distance", jSONObject.getDouble("distance"));
            } else {
                jSONObject2.put("distance", 0);
            }
            date = new JSONObject();
            jSONObject = jSONObject.getJSONArray("points");
            while (n < jSONObject.length()) {
                block8: {
                    if (!jSONObject.getJSONObject(n).has("position_lat") || !jSONObject.getJSONObject(n).has("position_long")) break block8;
                    date.put("lat", jSONObject.getJSONObject(n).getDouble("position_lat"));
                    date.put("lng", jSONObject.getJSONObject(n).getDouble("position_long"));
                    break;
                }
                ++n;
            }
        }
        catch (JSONException jSONException) {
            jSONException.printStackTrace();
            return null;
        }
        {
            jSONObject2.put("startPoint", (Object)date);
            return jSONObject2;
        }
    }

    public MutableLiveData<RouteGetImage> getGetRouteImageSaveLiveData() {
        return this.getRouteImageSaveLiveData;
    }

    public MutableLiveData<JSONObject> getGetShareRouteFileLiveData() {
        return this.getShareRouteFileLiveData;
    }

    public MutableLiveData<Boolean> getIsPlanTripUpdateLiveData() {
        return this.isPlanTripUpdateLiveData;
    }

    public MutableLiveData<Boolean> getIsPlanTripUploadLiveData() {
        return this.isPlanTripUploadLiveData;
    }

    public MutableLiveData<AccountErrorVo> getLiveAccountErrorResponse() {
        return this.liveAccountErrorResponse;
    }

    public MutableLiveData<Boolean> getPlanTripDeleteFor3rdPartySyncLive() {
        return this.planTripDeleteFor3rdPartySyncLive;
    }

    public MutableLiveData<Boolean> getPlanTripDeleteResultLive() {
        return this.planTripDeleteResultLive;
    }

    public void getPlanTripFile(String string2, String string3) {
        String string4 = TAG;
        CharSequence charSequence = new StringBuilder();
        charSequence.append("\u4e0b\u8f09 getPlanTripFile -> planTripId: ");
        charSequence.append(string2);
        charSequence.append(", url: ");
        charSequence.append(string3);
        Log.d((String)string4, (String)charSequence.toString());
        charSequence = ProfileUtil.getInstance().getPrefString("userId");
        string4 = ProfileUtil.getInstance().getPrefString("com.brytonsport.active.loginToken");
        this.planTripWorkoutApi.downloadFitWithDynamicUrl((String)charSequence, string4, string3).enqueue((Callback)new Callback<ResponseBody>((String)charSequence, string2){
            final /* synthetic */ String val$planTripId;
            final /* synthetic */ String val$userId;
            {
                this.val$userId = string2;
                this.val$planTripId = string3;
            }

            public void onFailure(Call<ResponseBody> call, Throwable throwable) {
                Log.e((String)TAG, (String)"error");
                PlanTripRepository.this.planTripFitDownloadLiveData.postValue(false);
            }

            public void onResponse(Call<ResponseBody> object, Response<ResponseBody> object2) {
                boolean bl = object2.isSuccessful();
                object = false;
                if (bl) {
                    Object object3 = App.getInstance();
                    object2 = (ResponseBody)object2.body();
                    StringBuilder stringBuilder = new StringBuilder();
                    stringBuilder.append(this.val$userId);
                    stringBuilder.append("/plantrip");
                    String string2 = stringBuilder.toString();
                    stringBuilder = new StringBuilder();
                    stringBuilder.append(this.val$planTripId);
                    stringBuilder.append(".fit");
                    bl = ActivityFileUtil.writeResponseBodyToDisk((Context)object3, (ResponseBody)object2, string2, stringBuilder.toString());
                    object2 = TAG;
                    object3 = new StringBuilder();
                    ((StringBuilder)object3).append(this.val$planTripId);
                    ((StringBuilder)object3).append(".fit download was a success? ");
                    ((StringBuilder)object3).append(bl);
                    Log.d((String)object2, (String)((StringBuilder)object3).toString());
                    if (bl) {
                        object = new StringBuilder();
                        ((StringBuilder)object).append(this.val$userId);
                        ((StringBuilder)object).append("/plantrip");
                        ((StringBuilder)object).append(File.separator);
                        ((StringBuilder)object).append(this.val$planTripId);
                        ((StringBuilder)object).append(".fit");
                        object2 = ((StringBuilder)object).toString();
                        object = TAG;
                        object3 = new StringBuilder();
                        ((StringBuilder)object3).append("\u8def\u5f91");
                        ((StringBuilder)object3).append((String)object2);
                        Log.d((String)object, (String)((StringBuilder)object3).toString());
                        object2 = PlanTripRepository.this;
                        object3 = this.val$planTripId;
                        object = new StringBuilder();
                        ((StringBuilder)object).append(this.val$userId);
                        ((StringBuilder)object).append(File.separator);
                        ((StringBuilder)object).append("plantrip");
                        ((PlanTripRepository)object2).decodeActivityFit((String)object3, ((StringBuilder)object).toString(), this.val$planTripId);
                        PlanTripRepository.this.planTripFitDownloadLiveData.postValue(true);
                    } else {
                        PlanTripRepository.this.planTripFitDownloadLiveData.postValue(object);
                    }
                } else {
                    Log.d((String)TAG, (String)"server contact failed");
                    PlanTripRepository.this.planTripFitDownloadLiveData.postValue(object);
                }
            }
        });
    }

    public void getPlanTripFileFromShare(String string2, String string3) {
        String string4 = ProfileUtil.getInstance().getPrefString("userId");
        CharSequence charSequence = new StringBuilder();
        charSequence.append(string4);
        charSequence.append(File.separator);
        charSequence.append("shareplantrip");
        charSequence = charSequence.toString();
        string4 = string3;
        string4 = string3 = URLEncoder.encode(string3, "UTF-8");
        String string5 = TAG;
        string4 = string3;
        string4 = string3;
        StringBuilder stringBuilder = new StringBuilder();
        string4 = string3;
        stringBuilder.append("\u8def\u7dda55 \u540d\u7a31 encode: ");
        string4 = string3;
        stringBuilder.append(string3);
        string4 = string3;
        Log.d((String)string5, (String)stringBuilder.toString());
        string4 = string3;
        string4 = string3 = string3.replaceAll("%(?![0-9a-fA-F]{2})", "%25");
        string4 = string3;
        stringBuilder = new StringBuilder();
        string4 = string3;
        stringBuilder.append("\u8def\u7dda55 \u540d\u7a31 %25: ");
        string4 = string3;
        stringBuilder.append(string3);
        string4 = string3;
        Log.d((String)string5, (String)stringBuilder.toString());
        string4 = string3;
        string4 = string3 = string3.replaceAll("\\+", "%2B");
        string4 = string3;
        stringBuilder = new StringBuilder();
        string4 = string3;
        stringBuilder.append("\u8def\u7dda55 \u540d\u7a31 %2B: ");
        string4 = string3;
        stringBuilder.append(string3);
        string4 = string3;
        try {
            Log.d((String)string5, (String)stringBuilder.toString());
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            unsupportedEncodingException.printStackTrace();
            string3 = string4;
        }
        this.planTripWorkoutApi.downloadFitWithDynamicUrl(string2).enqueue((Callback)new Callback<ResponseBody>((String)charSequence, string3){
            final /* synthetic */ String val$filePath;
            final /* synthetic */ String val$finalFileName;
            {
                this.val$filePath = string2;
                this.val$finalFileName = string3;
            }

            public void onFailure(Call<ResponseBody> jSONObject, Throwable throwable) {
                jSONObject = new JSONObject();
                try {
                    jSONObject.put("code", BrytonErrorCodeUtil.API_TIMEOUT);
                    jSONObject.put("funType", (Object)"download");
                    jSONObject.put("message", (Object)throwable.getLocalizedMessage());
                    PlanTripRepository.this.getShareRouteFileLiveData.postValue(jSONObject);
                }
                catch (JSONException jSONException) {
                    jSONException.printStackTrace();
                }
            }

            public void onResponse(Call<ResponseBody> object, Response<ResponseBody> responseBody) {
                if (responseBody.isSuccessful()) {
                    object = App.getInstance();
                    responseBody = (ResponseBody)responseBody.body();
                    String string2 = this.val$filePath;
                    StringBuilder stringBuilder = new StringBuilder();
                    stringBuilder.append(this.val$finalFileName);
                    stringBuilder.append(".fit");
                    if (ActivityFileUtil.writeResponseBodyToDisk((Context)object, responseBody, string2, stringBuilder.toString())) {
                        PlanTripRepository.this.decodePlantripFitForShare(this.val$filePath, this.val$finalFileName).observeForever(new Observer<JSONObject>(){

                            /*
                             * WARNING - void declaration
                             * Enabled aggressive block sorting
                             * Enabled unnecessary exception pruning
                             * Enabled aggressive exception aggregation
                             */
                            @Override
                            public void onChanged(JSONObject object) {
                                if (object == null) return;
                                if (object.has("data")) {
                                    try {
                                        void var1_4;
                                        JSONObject jSONObject = object.getJSONObject("data");
                                        boolean bl = false;
                                        if (object.has("stepHasTurnInfoManeuver")) {
                                            bl = object.getBoolean("stepHasTurnInfoManeuver");
                                        }
                                        if (bl) {
                                            String string2 = PlanTripUtil.PROVIDER_SHARE_WITH_TURN;
                                        } else {
                                            String string3 = PlanTripUtil.PROVIDER_SHARE;
                                        }
                                        jSONObject = PlanTripRepository.this.getAbstract(jSONObject);
                                        PlanTripRepository.this.uploadToServerForShare(val$filePath, val$finalFileName, (String)var1_4, null, jSONObject);
                                        return;
                                    }
                                    catch (JSONException jSONException) {
                                        jSONException.printStackTrace();
                                        JSONObject jSONObject = new JSONObject();
                                        try {
                                            String string4 = jSONException.getMessage();
                                            jSONObject.put("code", BrytonErrorCodeUtil.JSON_PARSE_ERROR);
                                            jSONObject.put("message", (Object)string4);
                                            PlanTripRepository.this.getShareRouteFileLiveData.postValue(jSONObject);
                                            return;
                                        }
                                        catch (JSONException jSONException2) {
                                            jSONException.printStackTrace();
                                            return;
                                        }
                                    }
                                }
                                if (!object.has("message")) return;
                                try {
                                    object.put("code", BrytonErrorCodeUtil.PLANTRIP_DECODE_FAILED);
                                    PlanTripRepository.this.getShareRouteFileLiveData.postValue(object);
                                    return;
                                }
                                catch (JSONException jSONException) {
                                    jSONException.printStackTrace();
                                }
                            }
                        });
                    } else {
                        try {
                            object = new JSONObject();
                            object.put("code", BrytonErrorCodeUtil.PLANTRIP_SAVE_FILE_FAILED);
                            object.put("funType", (Object)"download");
                            object.put("message", (Object)"write fit to app storage failed");
                            PlanTripRepository.this.getShareRouteFileLiveData.postValue(object);
                        }
                        catch (JSONException jSONException) {
                            jSONException.printStackTrace();
                        }
                    }
                } else {
                    object = responseBody.errorBody();
                    try {
                        object = object.string();
                    }
                    catch (IOException iOException) {
                        iOException.printStackTrace();
                        object = "";
                    }
                    try {
                        JSONObject jSONObject = new JSONObject((String)object);
                        jSONObject.put("code", responseBody.code());
                        jSONObject.put("funType", (Object)"download");
                        PlanTripRepository.this.getShareRouteFileLiveData.postValue(jSONObject);
                    }
                    catch (JSONException jSONException) {
                        jSONException.printStackTrace();
                    }
                }
            }
        });
    }

    public MutableLiveData<Boolean> getPlanTripFitDownloadLiveData() {
        return this.planTripFitDownloadLiveData;
    }

    public String getPlanTripFitFilepath(String object, String charSequence, String string2) {
        object = App.getInstance().getFilesDir();
        if (charSequence != null && !((String)charSequence).isEmpty()) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append(object);
            stringBuilder.append(File.separator);
            stringBuilder.append((String)charSequence);
            stringBuilder.append(File.separator);
            stringBuilder.append(string2);
            stringBuilder.append(".fit");
            object = stringBuilder.toString();
        } else {
            charSequence = new StringBuilder();
            ((StringBuilder)charSequence).append(object);
            ((StringBuilder)charSequence).append(File.separator);
            ((StringBuilder)charSequence).append(string2);
            ((StringBuilder)charSequence).append(".fit");
            object = ((StringBuilder)charSequence).toString();
        }
        return object;
    }

    public void getPlanTripList() {
        String string2 = (String)ProfileUtil.getInstance().get("userId");
        String string3 = (String)ProfileUtil.getInstance().get("com.brytonsport.active.loginToken");
        this.planTripWorkoutApi.getPlanTripWorkoutList(string2, string3).enqueue((Callback)new Callback<ResponseBody>(){

            public void onFailure(Call<ResponseBody> object, Throwable throwable) {
                object = TAG;
                StringBuilder stringBuilder = new StringBuilder();
                stringBuilder.append("onFailure: ");
                stringBuilder.append(throwable.getMessage());
                Log.d(object, (String)stringBuilder.toString());
            }

            public void onResponse(Call<ResponseBody> object, Response<ResponseBody> object2) {
                if (object2.isSuccessful()) {
                    object2 = (ResponseBody)object2.body();
                    object = null;
                    try {
                        object = object2 = object2.string();
                    }
                    catch (IOException iOException) {
                        iOException.printStackTrace();
                    }
                    try {
                        object2 = new JSONObject((String)object);
                        PlanTripRepository.this.planTripListToDisplayModel((JSONObject)object2);
                    }
                    catch (JSONException jSONException) {
                        jSONException.printStackTrace();
                    }
                } else {
                    object = ErrorUtils.getErrorBodyMessage(object2);
                    CharSequence charSequence = TAG;
                    CharSequence charSequence2 = new StringBuilder();
                    charSequence2.append("getPlanTripList error code: ");
                    charSequence2.append(object2.code());
                    Log.d((String)charSequence, (String)charSequence2.toString());
                    charSequence2 = TAG;
                    charSequence = new StringBuilder();
                    ((StringBuilder)charSequence).append("getPlanTripList error message: ");
                    ((StringBuilder)charSequence).append((String)object);
                    Log.d((String)charSequence2, (String)((StringBuilder)charSequence).toString());
                    ErrorUtils.parseError(object2);
                    object = new AccountErrorVo(object2.code(), (String)object);
                    PlanTripRepository.this.liveAccountErrorResponse.postValue(object);
                }
            }
        });
    }

    public MutableLiveData<RouteDecodeState> getRouteDecodeStateLiveData() {
        return this.routeDecodeStateLiveData;
    }

    public MutableLiveData<List<Route>> getRouteListResultLiveData() {
        return this.routeListResultLiveData;
    }

    public /* synthetic */ void lambda$addNewFileIdHistory$0$com-brytonsport-active-repo-course-PlanTripRepository(int n, String string2) {
        this.fileIdHistoryDao.insert(new FileIdHistoryEntity(n, string2, new Date().getTime()));
    }

    public byte[] loadPlanTripFit2ByteArray(String object) {
        Object object2 = App.getInstance().getFilesDir();
        Comparable<StringBuilder> comparable = new StringBuilder();
        ((StringBuilder)comparable).append(object2);
        ((StringBuilder)comparable).append(File.separator);
        ((StringBuilder)comparable).append((String)object);
        ((StringBuilder)comparable).append(".fit");
        comparable = new File(((StringBuilder)comparable).toString());
        int n = (int)((File)comparable).length();
        object = new byte[n];
        try {
            FileInputStream fileInputStream = new FileInputStream((File)comparable);
            object2 = new BufferedInputStream(fileInputStream);
            ((BufferedInputStream)object2).read((byte[])object, 0, n);
            ((BufferedInputStream)object2).close();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        catch (FileNotFoundException fileNotFoundException) {
            fileNotFoundException.printStackTrace();
        }
        return object;
    }

    public void updatePlanTripToServer(final String string2, String string3, String string4, String string5, JSONObject jSONObject) {
        Object object = ProfileUtil.getInstance().getPrefString("userId");
        File file = App.getInstance().getFilesDir();
        Comparable<StringBuilder> comparable = new StringBuilder();
        ((StringBuilder)comparable).append(file);
        ((StringBuilder)comparable).append(File.separator);
        ((StringBuilder)comparable).append((String)object);
        ((StringBuilder)comparable).append(File.separator);
        ((StringBuilder)comparable).append("plantrip");
        ((StringBuilder)comparable).append(File.separator);
        ((StringBuilder)comparable).append(string2);
        ((StringBuilder)comparable).append(".fit");
        comparable = new File(((StringBuilder)comparable).toString());
        object = RequestBody.create((MediaType)MediaType.parse((String)"*/*"), (File)comparable);
        comparable = MultipartBody.Part.createFormData((String)"track", (String)((File)comparable).getName(), (RequestBody)object);
        object = new HashMap();
        if (string3 != null && !string3.isEmpty()) {
            object.put("name", RequestBody.create((MediaType)MediaType.parse((String)"text/plain"), (String)string3));
        }
        if (string4 != null && !string4.isEmpty()) {
            object.put("provider", RequestBody.create((MediaType)MediaType.parse((String)"text/plain"), (String)string4));
        }
        if (string5 != null && !string5.isEmpty()) {
            object.put("orgid", RequestBody.create((MediaType)MediaType.parse((String)"text/plain"), (String)string5));
        }
        if (jSONObject != null) {
            object.put("info", RequestBody.create((MediaType)MediaType.parse((String)"text/plain"), (String)jSONObject.toString()));
        }
        this.planTripWorkoutApi.updatePlanTripToServer(string2, (MultipartBody.Part)comparable, (Map<String, RequestBody>)object).enqueue((Callback)new Callback<ResponseBody>(){

            public void onFailure(Call<ResponseBody> object, Throwable throwable) {
                object = new StringBuilder();
                ((StringBuilder)object).append("updatePlanTripToServer -> ");
                ((StringBuilder)object).append(string2);
                ((StringBuilder)object).append(" onFailure : ");
                ((StringBuilder)object).append(throwable.getMessage());
                object = ((StringBuilder)object).toString();
                Log.d((String)TAG, (String)object);
                PlanTripRepository.this.isPlanTripUpdateLiveData.postValue(false);
            }

            public void onResponse(Call<ResponseBody> object, Response<ResponseBody> object2) {
                if (object2.isSuccessful()) {
                    object = NetworkUtil.parseResponseBody(object2);
                    if (object2.body() != null) {
                        PlanTripRepository.this.isPlanTripUpdateLiveData.postValue(true);
                        object2 = TAG;
                        StringBuilder stringBuilder = new StringBuilder();
                        stringBuilder.append("updatePlanTripToServer onResponse: resultObj -> ");
                        stringBuilder.append((String)object);
                        Log.d((String)object2, (String)stringBuilder.toString());
                    }
                } else {
                    object = NetworkUtil.parseResponseErrorBody(object2);
                    object2 = new StringBuilder();
                    ((StringBuilder)object2).append("updatePlanTripToServer ->upload ");
                    ((StringBuilder)object2).append(string2);
                    ((StringBuilder)object2).append(" to server error: ");
                    ((StringBuilder)object2).append((String)object);
                    object = ((StringBuilder)object2).toString();
                    PlanTripRepository.this.isPlanTripUpdateLiveData.postValue(false);
                    Log.d((String)TAG, object);
                }
            }
        });
    }

    public void uploadToServer(final String string2, String string3, String string4, JSONObject jSONObject) {
        String string5 = ProfileUtil.getInstance().getPrefString("userId");
        Serializable serializable = App.getInstance().getFilesDir();
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(serializable);
        stringBuilder.append(File.separator);
        stringBuilder.append(string2);
        stringBuilder.append(".fit");
        serializable = new File(stringBuilder.toString());
        stringBuilder = RequestBody.create((MediaType)MediaType.parse((String)"*/*"), (File)serializable);
        stringBuilder = MultipartBody.Part.createFormData((String)"track", (String)((File)serializable).getName(), (RequestBody)stringBuilder);
        serializable = new HashMap();
        if (string2 != null && !string2.isEmpty()) {
            serializable.put("name", RequestBody.create((MediaType)MediaType.parse((String)"text/plain"), (String)string2));
        }
        if (string3 != null && !string3.isEmpty()) {
            serializable.put("provider", RequestBody.create((MediaType)MediaType.parse((String)"text/plain"), (String)string3));
        }
        if (string4 != null && !string4.isEmpty()) {
            serializable.put("orgid", RequestBody.create((MediaType)MediaType.parse((String)"text/plain"), (String)string4));
        }
        if (jSONObject != null) {
            serializable.put("info", RequestBody.create((MediaType)MediaType.parse((String)"text/plain"), (String)jSONObject.toString()));
        }
        this.planTripWorkoutApi.uploadPlanTripFitToServer(string5, (MultipartBody.Part)stringBuilder, (Map<String, RequestBody>)((Object)serializable)).enqueue((Callback)new Callback<ResponseBody>(){

            public void onFailure(Call<ResponseBody> object, Throwable throwable) {
                object = new StringBuilder();
                ((StringBuilder)object).append("uploadToServer -> ");
                ((StringBuilder)object).append(string2);
                ((StringBuilder)object).append(" onFailure : ");
                ((StringBuilder)object).append(throwable.getMessage());
                object = ((StringBuilder)object).toString();
                Log.d((String)TAG, (String)object);
                PlanTripRepository.this.isPlanTripUploadLiveData.postValue(false);
            }

            public void onResponse(Call<ResponseBody> object, Response<ResponseBody> object2) {
                if (object2.isSuccessful()) {
                    String string22 = NetworkUtil.parseResponseBody(object2);
                    if (object2.body() != null) {
                        try {
                            object = new JSONObject(string22);
                            object.getString("fileid").isEmpty();
                            PlanTripRepository.this.isPlanTripUploadLiveData.postValue(true);
                            string22 = TAG;
                            object2 = new StringBuilder();
                            ((StringBuilder)object2).append("uploadToServer onResponse: resultObj -> ");
                            ((StringBuilder)object2).append(object.toString());
                            Log.d((String)string22, (String)((StringBuilder)object2).toString());
                        }
                        catch (JSONException jSONException) {
                            jSONException.printStackTrace();
                        }
                    }
                } else {
                    object2 = NetworkUtil.parseResponseErrorBody(object2);
                    object = new StringBuilder();
                    object.append("uploadToServer ->upload ");
                    object.append(string2);
                    object.append(" to server error: ");
                    object.append((String)object2);
                    object = object.toString();
                    PlanTripRepository.this.isPlanTripUploadLiveData.postValue(false);
                    Log.d((String)TAG, (String)object);
                }
            }
        });
    }

    public void uploadToServer(final String string2, JSONObject jSONObject, String string3) {
        String string4 = ProfileUtil.getInstance().getPrefString("userId");
        Object object = App.getInstance().getFilesDir();
        Comparable<StringBuilder> comparable = new StringBuilder();
        comparable.append(object);
        comparable.append(File.separator);
        comparable.append(string2);
        comparable = new File(comparable.toString());
        comparable = RequestBody.create((MediaType)MediaType.parse((String)"*/*"), (File)comparable);
        object = string2.replace(".fit", "");
        comparable = MultipartBody.Part.createFormData((String)"track", (String)object, (RequestBody)comparable);
        object = RequestBody.create((MediaType)MediaType.parse((String)"text/plain"), (String)object);
        string3 = RequestBody.create((MediaType)MediaType.parse((String)"text/plain"), (String)string3);
        jSONObject = RequestBody.create((MediaType)MediaType.parse((String)"text/plain"), (String)jSONObject.toString());
        this.planTripWorkoutApi.uploadPlanTripFitToServer(string4, (MultipartBody.Part)comparable, (RequestBody)object, (RequestBody)string3, (RequestBody)jSONObject).enqueue((Callback)new Callback<ResponseBody>(){

            public void onFailure(Call<ResponseBody> object, Throwable throwable) {
                object = new StringBuilder();
                ((StringBuilder)object).append("uploadToServer -> ");
                ((StringBuilder)object).append(string2);
                ((StringBuilder)object).append(" onFailure : ");
                ((StringBuilder)object).append(throwable.getMessage());
                object = ((StringBuilder)object).toString();
                Log.d((String)TAG, (String)object);
                PlanTripRepository.this.isPlanTripUploadLiveData.postValue(false);
            }

            public void onResponse(Call<ResponseBody> object, Response<ResponseBody> object2) {
                if (object2.isSuccessful()) {
                    String string22 = NetworkUtil.parseResponseBody(object2);
                    if (object2.body() != null) {
                        try {
                            object = new JSONObject(string22);
                            object.getString("fileid").isEmpty();
                            PlanTripRepository.this.isPlanTripUploadLiveData.postValue(true);
                            string22 = TAG;
                            object2 = new StringBuilder();
                            ((StringBuilder)object2).append("uploadToServer onResponse: resultObj -> ");
                            ((StringBuilder)object2).append(object.toString());
                            Log.d((String)string22, (String)((StringBuilder)object2).toString());
                        }
                        catch (JSONException jSONException) {
                            jSONException.printStackTrace();
                        }
                    }
                } else {
                    object2 = NetworkUtil.parseResponseErrorBody(object2);
                    object = new StringBuilder();
                    object.append("uploadToServer ->upload ");
                    object.append(string2);
                    object.append(" to server error: ");
                    object.append((String)object2);
                    object = object.toString();
                    PlanTripRepository.this.isPlanTripUploadLiveData.postValue(false);
                    Log.d((String)TAG, (String)object);
                }
            }
        });
    }

    public void uploadToServerForShare(String hashMap, String string2, String string3, String string4, JSONObject jSONObject) {
        String string5 = ProfileUtil.getInstance().getPrefString("userId");
        File file = App.getInstance().getFilesDir();
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(file);
        stringBuilder.append(File.separator);
        stringBuilder.append((String)((Object)hashMap));
        stringBuilder.append(File.separator);
        stringBuilder.append(string2);
        stringBuilder.append(".fit");
        hashMap = new File(stringBuilder.toString());
        stringBuilder = RequestBody.create((MediaType)MediaType.parse((String)"*/*"), (File)((Object)hashMap));
        stringBuilder = MultipartBody.Part.createFormData((String)"track", (String)((File)((Object)hashMap)).getName(), (RequestBody)stringBuilder);
        hashMap = new HashMap<String, RequestBody>();
        if (string2 != null && !string2.isEmpty()) {
            hashMap.put("name", RequestBody.create((MediaType)MediaType.parse((String)"text/plain"), (String)string2));
        }
        if (string3 != null && !string3.isEmpty()) {
            hashMap.put("provider", RequestBody.create((MediaType)MediaType.parse((String)"text/plain"), (String)string3));
        }
        if (string4 != null && !string4.isEmpty()) {
            hashMap.put("orgid", RequestBody.create((MediaType)MediaType.parse((String)"text/plain"), (String)string4));
        }
        if (jSONObject != null) {
            hashMap.put("info", RequestBody.create((MediaType)MediaType.parse((String)"text/plain"), (String)jSONObject.toString()));
        }
        this.planTripWorkoutApi.uploadPlanTripFitToServer(string5, (MultipartBody.Part)stringBuilder, hashMap).enqueue((Callback)new Callback<ResponseBody>(){

            public void onFailure(Call<ResponseBody> jSONObject, Throwable throwable) {
                jSONObject = new JSONObject();
                try {
                    jSONObject.put("code", BrytonErrorCodeUtil.API_TIMEOUT);
                    jSONObject.put("funType", (Object)"upload");
                    jSONObject.put("message", (Object)throwable.getLocalizedMessage());
                    PlanTripRepository.this.getShareRouteFileLiveData.postValue(jSONObject);
                }
                catch (JSONException jSONException) {
                    jSONException.printStackTrace();
                }
            }

            public void onResponse(Call<ResponseBody> object, Response<ResponseBody> response) {
                if (response.isSuccessful()) {
                    object = NetworkUtil.parseResponseBody(response);
                    String string2 = TAG;
                    StringBuilder stringBuilder = new StringBuilder();
                    stringBuilder.append("\u5206\u4eab\u8def\u7dda \u4e0a\u50b3 onResponse: ");
                    stringBuilder.append((String)object);
                    Log.d((String)string2, (String)stringBuilder.toString());
                    if (!((String)object).isEmpty()) {
                        stringBuilder = new JSONObject((String)object);
                        stringBuilder.getString("fileid").isEmpty();
                        try {
                            stringBuilder.put("code", response.code());
                            stringBuilder.put("funType", "upload");
                            PlanTripRepository.this.getShareRouteFileLiveData.postValue(stringBuilder);
                        }
                        catch (JSONException jSONException) {
                            try {
                                jSONException.printStackTrace();
                            }
                            catch (JSONException jSONException2) {
                                jSONException2.printStackTrace();
                            }
                        }
                    }
                } else {
                    object = response.errorBody();
                    try {
                        object = object.string();
                    }
                    catch (IOException iOException) {
                        iOException.printStackTrace();
                        object = "";
                    }
                    try {
                        JSONObject jSONObject = new JSONObject((String)object);
                        jSONObject.put("code", response.code());
                        jSONObject.put("funType", (Object)"upload");
                        PlanTripRepository.this.getShareRouteFileLiveData.postValue(jSONObject);
                    }
                    catch (JSONException jSONException) {
                        jSONException.printStackTrace();
                    }
                }
            }
        });
    }
}

