/*
 * Decompiled with CFR 0.152.
 */
package com.brytonsport.active.repo.course;

import android.content.Context;
import android.util.Log;
import androidx.lifecycle.MutableLiveData;
import com.brytonsport.active.api.APIError;
import com.brytonsport.active.api.ApiService;
import com.brytonsport.active.api.ErrorUtils;
import com.brytonsport.active.api.account.vo.AccountErrorVo;
import com.brytonsport.active.api.course.PlanTripWorkoutApi;
import com.brytonsport.active.base.App;
import com.brytonsport.active.fit.BrytonWorkout;
import com.brytonsport.active.repo.course.WorkoutRepositoryHandler;
import com.brytonsport.active.utils.ActivityFileUtil;
import com.brytonsport.active.utils.NetworkUtil;
import com.brytonsport.active.utils.ProfileUtil;
import com.brytonsport.active.vm.base.TrainingPlan;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import okhttp3.MediaType;
import okhttp3.MultipartBody;
import okhttp3.RequestBody;
import okhttp3.ResponseBody;
import org.json.JSONException;
import org.json.JSONObject;
import retrofit2.Call;
import retrofit2.Callback;
import retrofit2.Response;

public class WorkoutRepository {
    static final String TAG = "WorkoutRepository";
    private final MutableLiveData<ArrayList<TrainingPlan>> defaultWorkoutLiveData;
    private int deleteWorkoutErrorCount = 0;
    private int deleteWorkoutOkCount = 0;
    private int deleteWorkoutTimeoutCount = 0;
    private int deleteWorkoutTotalNum = 0;
    private final MutableLiveData<Boolean> getTpWorkoutDecodeJsonSaveLiveData;
    private final MutableLiveData<Boolean> getWorkoutDecodeJsonSaveLiveData;
    private final MutableLiveData<AccountErrorVo> liveAccountErrorResponse;
    private final PlanTripWorkoutApi planTripWorkoutApi;
    private final MutableLiveData<List<TrainingPlan>> trainingPlanListResultLiveData = new MutableLiveData();
    private MutableLiveData<Boolean> workoutDeleteResultLive;
    String workoutEncode2FitPath;
    String workoutEncodePath;
    String workoutSavedPath;

    @Inject
    public WorkoutRepository() {
        this.defaultWorkoutLiveData = new MutableLiveData();
        this.getWorkoutDecodeJsonSaveLiveData = new MutableLiveData();
        this.getTpWorkoutDecodeJsonSaveLiveData = new MutableLiveData();
        this.workoutDeleteResultLive = new MutableLiveData();
        this.liveAccountErrorResponse = new MutableLiveData();
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(App.getInstance().getFilesDir());
        stringBuilder.append(File.separator);
        stringBuilder.append("workout_encode");
        this.workoutEncodePath = stringBuilder.toString();
        stringBuilder = new StringBuilder();
        stringBuilder.append(this.workoutEncodePath);
        stringBuilder.append(File.separator);
        stringBuilder.append("%s.fit");
        this.workoutEncode2FitPath = stringBuilder.toString();
        stringBuilder = new StringBuilder();
        stringBuilder.append(App.getInstance().getFilesDir());
        stringBuilder.append(File.separator);
        stringBuilder.append("workout");
        stringBuilder.append(File.separator);
        stringBuilder.append("%s.fit");
        this.workoutSavedPath = stringBuilder.toString();
        this.planTripWorkoutApi = ApiService.getInstance().getPlanTripWorkoutApi();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void countDeleteWorkout(NetworkUtil.ApiResultState object) {
        synchronized (this) {
            block7: {
                int n;
                block6: {
                    n = 9.$SwitchMap$com$brytonsport$active$utils$NetworkUtil$ApiResultState[((Enum)object).ordinal()];
                    if (n == 1) break block6;
                    if (n != 2) {
                        if (n == 3) {
                            ++this.deleteWorkoutTimeoutCount;
                            this.workoutDeleteResultLive.postValue(false);
                        }
                        break block7;
                    } else {
                        ++this.deleteWorkoutErrorCount;
                        this.workoutDeleteResultLive.postValue(false);
                    }
                    break block7;
                }
                this.deleteWorkoutOkCount = n = this.deleteWorkoutOkCount + 1;
                if (n == this.deleteWorkoutTotalNum) {
                    this.workoutDeleteResultLive.postValue(true);
                }
            }
            String string2 = String.format("countDeleteWorkout: \u522a\u9664\u6210\u529f %d\u7b46\uff0c\u5931\u6557 %d\u7b46\uff0cTimeout %d\u7b46", this.deleteWorkoutOkCount, this.deleteWorkoutErrorCount, this.deleteWorkoutTimeoutCount);
            Log.d((String)TAG, (String)string2);
            return;
        }
    }

    private void decodeWorkoutFit(String object, String object2) {
        object2 = BrytonWorkout.decodeFitToJson((String)object, (String)object2);
        object = this.getWorkoutDecodeJsonSaveLiveData;
        boolean bl = object2 != null;
        ((MutableLiveData)object).postValue(bl);
    }

    private void getDefaultWorkout(final Integer n, final String[] stringArray, final ArrayList<TrainingPlan> arrayList) {
        if (n >= stringArray.length) {
            this.defaultWorkoutLiveData.postValue(arrayList);
            return;
        }
        if (stringArray[n].equals("1")) {
            this.getDefaultWorkout(n + 1, stringArray, arrayList);
            return;
        }
        Object object = new StringBuilder();
        ((StringBuilder)object).append("default_");
        ((StringBuilder)object).append(String.valueOf(n));
        final String string2 = ((StringBuilder)object).toString();
        object = new StringBuilder();
        ((StringBuilder)object).append("workoutjson");
        ((StringBuilder)object).append(File.separator);
        ((StringBuilder)object).append(string2);
        ((StringBuilder)object).append(".json");
        String string3 = ((StringBuilder)object).toString();
        object = new StringBuilder();
        ((StringBuilder)object).append(App.getInstance().getFilesDir());
        ((StringBuilder)object).append(File.separator);
        ((StringBuilder)object).append(string3);
        if (new File(((StringBuilder)object).toString()).exists()) {
            object = new TrainingPlan();
            ((TrainingPlan)object).id = string2;
            ((TrainingPlan)object).loadWorkoutJSON();
            arrayList.add((TrainingPlan)object);
            this.getDefaultWorkout(n + 1, stringArray, arrayList);
            return;
        }
        int n2 = n;
        if (n2 != 0) {
            if (n2 != 1) {
                if (n2 != 2) {
                    return;
                }
                object = "https://corp.brytonsport.com/device/EnduranceTraining.fit";
            } else {
                object = "https://corp.brytonsport.com/device/EasyTempo.fit";
            }
        } else {
            object = "https://corp.brytonsport.com/device/IntervalWorkout.fit";
        }
        this.planTripWorkoutApi.downloadFit((String)object).enqueue((Callback)new Callback<ResponseBody>(){

            public void onFailure(Call<ResponseBody> call, Throwable throwable) {
                Log.e((String)TAG, (String)"error");
            }

            public void onResponse(Call<ResponseBody> object, Response<ResponseBody> object2) {
                if (object2.isSuccessful()) {
                    object = App.getInstance();
                    ResponseBody responseBody = (ResponseBody)object2.body();
                    object2 = new StringBuilder();
                    ((StringBuilder)object2).append(string2);
                    ((StringBuilder)object2).append(".fit");
                    if (ActivityFileUtil.writeResponseBodyToDisk(object, responseBody, "/default_workout", ((StringBuilder)object2).toString())) {
                        WorkoutRepository.this.decodeWorkoutFit("/default_workout", string2);
                        object = new TrainingPlan();
                        ((TrainingPlan)object).id = string2;
                        ((TrainingPlan)object).loadWorkoutJSON();
                        arrayList.add(object);
                        WorkoutRepository.this.getDefaultWorkout(n + 1, stringArray, arrayList);
                    }
                } else {
                    Log.d((String)TAG, (String)"server contact failed");
                }
            }
        });
    }

    /*
     * Exception decompiling
     */
    private void workoutListToDisplayModel(JSONObject var1_1) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [86[UNCONDITIONALDOLOOP]], but top level block is 47[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public void createWorkout(TrainingPlan trainingPlan, WorkoutRepositoryHandler workoutRepositoryHandler) {
        Comparable<File> comparable;
        Object object = ProfileUtil.getInstance().getPrefString("userId");
        String string2 = trainingPlan.name;
        File file = new File(String.format(this.workoutEncode2FitPath, string2));
        if (file.exists()) {
            file.delete();
        } else {
            comparable = new File(this.workoutEncodePath);
            if (!((File)comparable).exists()) {
                ((File)comparable).mkdirs();
            }
        }
        comparable = new StringBuilder();
        ((StringBuilder)comparable).append(App.getInstance().getFilesDir());
        ((StringBuilder)comparable).append(File.separator);
        ((StringBuilder)comparable).append((String)object);
        ((StringBuilder)comparable).append("/workout_tp");
        ((StringBuilder)comparable).append(File.separator);
        ((StringBuilder)comparable).append(trainingPlan.id);
        ((StringBuilder)comparable).append(".fit");
        object = new File(((StringBuilder)comparable).toString());
        if (((File)object).exists()) {
            ((File)object).renameTo(file);
        }
        this.encodeWorkoutToFit(new BrytonWorkout(trainingPlan), string2);
        file = trainingPlan.createInfoJson();
        this.uploadWorkoutToServer(string2, trainingPlan.name, trainingPlan.provider, trainingPlan.orgId, (JSONObject)file, workoutRepositoryHandler);
    }

    public void decodeTrainingPeaksWorkoutFit(String charSequence, String charSequence2, String string2) {
        Comparable<File> comparable = App.getInstance().getFilesDir();
        Object object = new StringBuilder();
        ((StringBuilder)object).append(comparable);
        ((StringBuilder)object).append(File.separator);
        ((StringBuilder)object).append((String)charSequence2);
        ((StringBuilder)object).append(File.separator);
        ((StringBuilder)object).append(string2);
        ((StringBuilder)object).append(".fit");
        charSequence2 = ((StringBuilder)object).toString();
        object = new BrytonWorkout();
        ((BrytonWorkout)object).encodeFileSet((String)charSequence2);
        charSequence2 = new JSONObject();
        try {
            if (((BrytonWorkout)object).decode((JSONObject)charSequence2)) {
                object = TAG;
                comparable = new Comparable<File>();
                ((StringBuilder)comparable).append("");
                ((StringBuilder)comparable).append(string2);
                ((StringBuilder)comparable).append(" decode ok");
                Log.d((String)object, (String)((StringBuilder)comparable).toString());
                object = App.getInstance();
                comparable = new Comparable<File>();
                ((StringBuilder)comparable).append(File.separator);
                ((StringBuilder)comparable).append("workoutjson_tp");
                String string3 = ((StringBuilder)comparable).toString();
                comparable = new Comparable<File>();
                ((StringBuilder)comparable).append((String)charSequence);
                ((StringBuilder)comparable).append(".json");
                ActivityFileUtil.writeJsonFile((Context)object, string3, (JSONObject)charSequence2, ((StringBuilder)comparable).toString());
                this.getTpWorkoutDecodeJsonSaveLiveData.postValue(true);
            } else {
                charSequence = TAG;
                charSequence2 = new StringBuilder();
                ((StringBuilder)charSequence2).append("");
                ((StringBuilder)charSequence2).append(string2);
                ((StringBuilder)charSequence2).append(" decode error");
                Log.d((String)charSequence, (String)((StringBuilder)charSequence2).toString());
                this.getTpWorkoutDecodeJsonSaveLiveData.postValue(false);
            }
        }
        catch (Exception exception) {
            object = TAG;
            charSequence = new StringBuilder();
            ((StringBuilder)charSequence).append("");
            ((StringBuilder)charSequence).append(string2);
            ((StringBuilder)charSequence).append(" decode Exception: ");
            ((StringBuilder)charSequence).append(exception.getMessage());
            Log.d((String)object, (String)((StringBuilder)charSequence).toString());
            this.getTpWorkoutDecodeJsonSaveLiveData.postValue(false);
        }
    }

    public void deleteSingleWorkout(String string2) {
        this.deleteWorkoutOkCount = 0;
        this.deleteWorkoutErrorCount = 0;
        this.deleteWorkoutTimeoutCount = 0;
        this.deleteWorkoutTotalNum = 1;
        this.deleteWorkout(string2);
    }

    public void deleteWorkout(final String string2) {
        String string3 = ProfileUtil.getInstance().getPrefString("userId");
        String string4 = ProfileUtil.getInstance().getPrefString("com.brytonsport.active.loginToken");
        this.planTripWorkoutApi.deletePlanTrip(string3, string4, string2).enqueue((Callback)new Callback<ResponseBody>(){

            public void onFailure(Call<ResponseBody> object, Throwable throwable) {
                object = new StringBuilder();
                ((StringBuilder)object).append("deleteWorkout -> ");
                ((StringBuilder)object).append(string2);
                ((StringBuilder)object).append(" onFailure : ");
                ((StringBuilder)object).append(throwable.getMessage());
                object = ((StringBuilder)object).toString();
                Log.d((String)TAG, (String)object);
                WorkoutRepository.this.countDeleteWorkout(NetworkUtil.ApiResultState.TIMEOUT);
            }

            public void onResponse(Call<ResponseBody> object, Response<ResponseBody> object2) {
                if (object2.isSuccessful()) {
                    NetworkUtil.parseResponseBody(object2);
                    object = TAG;
                    object2 = new StringBuilder();
                    ((StringBuilder)object2).append("delete ");
                    ((StringBuilder)object2).append(string2);
                    ((StringBuilder)object2).append(" success");
                    Log.d(object, (String)((StringBuilder)object2).toString());
                    WorkoutRepository.this.countDeleteWorkout(NetworkUtil.ApiResultState.SUCCESS);
                } else {
                    object = NetworkUtil.parseResponseErrorBody(object2);
                    object2 = new StringBuilder();
                    ((StringBuilder)object2).append("deleteWorkout -> ");
                    ((StringBuilder)object2).append(string2);
                    ((StringBuilder)object2).append(" error: ");
                    ((StringBuilder)object2).append((String)object);
                    object = ((StringBuilder)object2).toString();
                    Log.d((String)TAG, object);
                    WorkoutRepository.this.countDeleteWorkout(NetworkUtil.ApiResultState.FAILURE);
                }
            }
        });
    }

    public void deleteWorkoutList(List<TrainingPlan> object) {
        this.deleteWorkoutTotalNum = 0;
        this.deleteWorkoutOkCount = 0;
        this.deleteWorkoutErrorCount = 0;
        this.deleteWorkoutTimeoutCount = 0;
        Iterator<TrainingPlan> iterator = object.iterator();
        while (iterator.hasNext()) {
            object = iterator.next();
            if (((TrainingPlan)object).id.startsWith("default_")) {
                Integer n = Integer.valueOf(((TrainingPlan)object).id.split("_")[1]);
                String string2 = ProfileUtil.getInstance().getPrefString("defaultWorkouts_deleted");
                object = string2;
                if (string2.length() == 0) {
                    object = "1,1,1";
                }
                ((String)object).split((String)",")[n.intValue()] = "0";
                continue;
            }
            ++this.deleteWorkoutTotalNum;
            this.deleteWorkout(((TrainingPlan)object).id);
        }
    }

    public void downloadWorkoutFile(TrainingPlan trainingPlan, WorkoutRepositoryHandler workoutRepositoryHandler) {
        if (!trainingPlan.url.isEmpty() && !trainingPlan.id.isEmpty()) {
            String string2 = trainingPlan.id;
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("workoutjson");
            stringBuilder.append(File.separator);
            stringBuilder.append(string2);
            stringBuilder.append(".json");
            string2 = stringBuilder.toString();
            stringBuilder = new StringBuilder();
            stringBuilder.append(App.getInstance().getFilesDir());
            stringBuilder.append(File.separator);
            stringBuilder.append(string2);
            if (new File(stringBuilder.toString()).exists()) {
                workoutRepositoryHandler.onComplete();
                return;
            }
            this.getWorkoutFile(trainingPlan.id, trainingPlan.url, workoutRepositoryHandler);
            return;
        }
        workoutRepositoryHandler.onComplete();
    }

    public void downloadWorkoutFit2ByteArray(final TrainingPlan trainingPlan, final WorkoutRepositoryHandler workoutRepositoryHandler) {
        final String string2 = ProfileUtil.getInstance().getPrefString("userId");
        String string3 = trainingPlan.id;
        final String string4 = trainingPlan.id;
        final File file = new File(String.format(this.workoutEncode2FitPath, string3));
        if (file.exists()) {
            if (trainingPlan.ver < 5) {
                Log.d((String)TAG, (String)"downloadWorkoutFit2ByteArray: \u5c0f\u65bc5 \u9700\u91cd\u65b0encode \u4e00\u6b21");
                this.encodeWorkoutToFit(new BrytonWorkout(trainingPlan), trainingPlan.id);
            } else {
                Log.d((String)TAG, (String)"downloadWorkoutFit2ByteArray: info ver \u70ba5\u4ee5\u4e0a -> \u652f\u63f4420, 750 workout encode \u7684\u7248\u672c");
            }
            workoutRepositoryHandler.onDownloadedWorkoutFitBytes(this.loadWorkoutFit2ByteArray(string3));
            return;
        }
        string3 = ProfileUtil.getInstance().getPrefString("com.brytonsport.active.loginToken");
        String string5 = trainingPlan.url;
        this.planTripWorkoutApi.downloadFitWithDynamicUrl(string2, string3, string5).enqueue((Callback)new Callback<ResponseBody>(){

            public void onFailure(Call<ResponseBody> call, Throwable throwable) {
                Log.e((String)TAG, (String)"error");
                workoutRepositoryHandler.onFail();
            }

            public void onResponse(Call<ResponseBody> object, Response<ResponseBody> responseBody) {
                if (responseBody.isSuccessful()) {
                    object = new File(WorkoutRepository.this.workoutEncodePath);
                    if (!((File)object).exists()) {
                        ((File)object).mkdirs();
                    }
                    object = App.getInstance();
                    responseBody = (ResponseBody)responseBody.body();
                    CharSequence charSequence = new StringBuilder();
                    charSequence.append(string2);
                    charSequence.append("/workout");
                    charSequence = charSequence.toString();
                    StringBuilder stringBuilder = new StringBuilder();
                    stringBuilder.append(string4);
                    stringBuilder.append(".fit");
                    if (ActivityFileUtil.writeResponseBodyToDisk((Context)object, responseBody, (String)charSequence, stringBuilder.toString())) {
                        object = new StringBuilder();
                        ((StringBuilder)object).append(App.getInstance().getFilesDir());
                        ((StringBuilder)object).append(File.separator);
                        ((StringBuilder)object).append(string2);
                        ((StringBuilder)object).append("/workout");
                        ((StringBuilder)object).append(File.separator);
                        ((StringBuilder)object).append(string4);
                        ((StringBuilder)object).append(".fit");
                        new File(((StringBuilder)object).toString()).renameTo(file);
                        WorkoutRepository.this.downloadWorkoutFit2ByteArray(trainingPlan, workoutRepositoryHandler);
                    } else {
                        workoutRepositoryHandler.onFail();
                    }
                } else {
                    Log.d((String)TAG, (String)"server contact failed");
                    workoutRepositoryHandler.onFail();
                }
            }
        });
    }

    public void encodeWorkoutToFit(BrytonWorkout brytonWorkout, String string2) {
        brytonWorkout.encodeFileSet(String.format(this.workoutEncode2FitPath, string2));
        brytonWorkout.encode();
    }

    public void encodeWorkoutToFit(JSONObject jSONObject, String string2) {
        string2 = String.format(this.workoutEncode2FitPath, string2);
        BrytonWorkout brytonWorkout = new BrytonWorkout();
        brytonWorkout.encodeFileSet(string2);
        brytonWorkout.encode(jSONObject);
    }

    public MutableLiveData<ArrayList<TrainingPlan>> getDefaultWorkoutLiveData() {
        return this.defaultWorkoutLiveData;
    }

    public void getDefaultWorkouts() {
        String[] stringArray;
        String[] stringArray2 = stringArray = ProfileUtil.getInstance().getPrefString("defaultWorkouts_deleted").split(",");
        if (stringArray.length < 3) {
            stringArray2 = new String[]{"0", "0", "0"};
        }
        this.getDefaultWorkout(0, stringArray2, new ArrayList<TrainingPlan>());
    }

    public MutableLiveData<Boolean> getGetTpWorkoutDecodeJsonSaveLiveData() {
        return this.getTpWorkoutDecodeJsonSaveLiveData;
    }

    public MutableLiveData<Boolean> getGetWorkoutDecodeJsonSaveLiveData() {
        return this.getWorkoutDecodeJsonSaveLiveData;
    }

    public MutableLiveData<AccountErrorVo> getLiveAccountErrorResponse() {
        return this.liveAccountErrorResponse;
    }

    public MutableLiveData<List<TrainingPlan>> getTrainingPlanListResultLiveData() {
        return this.trainingPlanListResultLiveData;
    }

    public MutableLiveData<Boolean> getWorkoutDeleteResultLive() {
        return this.workoutDeleteResultLive;
    }

    public void getWorkoutFile(String string2, String string3, WorkoutRepositoryHandler workoutRepositoryHandler) {
        String string4 = TAG;
        CharSequence charSequence = new StringBuilder();
        charSequence.append("getWorkoutFile -> workoutId: ");
        charSequence.append(string2);
        charSequence.append(", workoutUrl: ");
        charSequence.append(string3);
        Log.d((String)string4, (String)charSequence.toString());
        charSequence = ProfileUtil.getInstance().getPrefString("userId");
        string4 = ProfileUtil.getInstance().getPrefString("com.brytonsport.active.loginToken");
        this.planTripWorkoutApi.downloadFitWithDynamicUrl((String)charSequence, string4, string3).enqueue((Callback)new Callback<ResponseBody>((String)charSequence, string2, workoutRepositoryHandler){
            final /* synthetic */ WorkoutRepositoryHandler val$handler;
            final /* synthetic */ String val$userId;
            final /* synthetic */ String val$workoutId;
            {
                this.val$userId = string2;
                this.val$workoutId = string3;
                this.val$handler = workoutRepositoryHandler;
            }

            public void onFailure(Call<ResponseBody> object, Throwable throwable) {
                Log.e((String)TAG, (String)"error");
                object = this.val$handler;
                if (object != null) {
                    ((WorkoutRepositoryHandler)object).onFail();
                }
            }

            public void onResponse(Call<ResponseBody> object, Response<ResponseBody> object2) {
                if (object2.isSuccessful()) {
                    object = App.getInstance();
                    object2 = (ResponseBody)object2.body();
                    CharSequence charSequence = new StringBuilder();
                    charSequence.append(this.val$userId);
                    charSequence.append("/workout");
                    charSequence = charSequence.toString();
                    StringBuilder stringBuilder = new StringBuilder();
                    stringBuilder.append(this.val$workoutId);
                    stringBuilder.append(".fit");
                    boolean bl = ActivityFileUtil.writeResponseBodyToDisk((Context)object, object2, (String)charSequence, stringBuilder.toString());
                    object2 = TAG;
                    object = new StringBuilder();
                    ((StringBuilder)object).append(this.val$workoutId);
                    ((StringBuilder)object).append(".fit download was a success? ");
                    ((StringBuilder)object).append(bl);
                    Log.d((String)object2, (String)((StringBuilder)object).toString());
                    if (bl) {
                        object = new StringBuilder();
                        ((StringBuilder)object).append(this.val$userId);
                        ((StringBuilder)object).append("/workout");
                        ((StringBuilder)object).append(File.separator);
                        ((StringBuilder)object).append(this.val$workoutId);
                        ((StringBuilder)object).append(".fit");
                        charSequence = ((StringBuilder)object).toString();
                        object2 = TAG;
                        object = new StringBuilder();
                        ((StringBuilder)object).append("\u8def\u5f91");
                        ((StringBuilder)object).append((String)charSequence);
                        Log.d((String)object2, (String)((StringBuilder)object).toString());
                        object2 = WorkoutRepository.this;
                        object = new StringBuilder();
                        ((StringBuilder)object).append(this.val$userId);
                        ((StringBuilder)object).append(File.separator);
                        ((StringBuilder)object).append("workout");
                        ((WorkoutRepository)object2).decodeWorkoutFit(((StringBuilder)object).toString(), this.val$workoutId);
                        object = this.val$handler;
                        if (object != null) {
                            ((WorkoutRepositoryHandler)object).onComplete();
                        }
                    }
                } else {
                    Log.d((String)TAG, (String)"server contact failed");
                    object = this.val$handler;
                    if (object != null) {
                        ((WorkoutRepositoryHandler)object).onFail();
                    }
                }
            }
        });
    }

    public void getWorkoutList(final WorkoutRepositoryHandler workoutRepositoryHandler) {
        String string2 = (String)ProfileUtil.getInstance().get("userId");
        String string3 = (String)ProfileUtil.getInstance().get("com.brytonsport.active.loginToken");
        this.planTripWorkoutApi.getPlanTripWorkoutList(string2, string3).enqueue((Callback)new Callback<ResponseBody>(){

            public void onFailure(Call<ResponseBody> object, Throwable throwable) {
                String string2 = TAG;
                object = new StringBuilder();
                ((StringBuilder)object).append("onFailure: ");
                ((StringBuilder)object).append(throwable.getMessage());
                Log.d((String)string2, (String)((StringBuilder)object).toString());
                object = workoutRepositoryHandler;
                if (object != null) {
                    ((WorkoutRepositoryHandler)object).onFail();
                }
            }

            public void onResponse(Call<ResponseBody> object, Response<ResponseBody> object2) {
                if (object2.isSuccessful()) {
                    ResponseBody responseBody = (ResponseBody)object2.body();
                    object = null;
                    try {
                        object = object2 = responseBody.string();
                    }
                    catch (IOException iOException) {
                        iOException.printStackTrace();
                    }
                    try {
                        object2 = new JSONObject((String)object);
                        WorkoutRepository.this.workoutListToDisplayModel((JSONObject)object2);
                    }
                    catch (JSONException jSONException) {
                        jSONException.printStackTrace();
                    }
                    object = TAG;
                    object2 = new StringBuilder();
                    ((StringBuilder)object2).append("onResponse: ");
                    ((StringBuilder)object2).append(responseBody.toString());
                    Log.d((String)object, (String)((StringBuilder)object2).toString());
                    object = workoutRepositoryHandler;
                    if (object != null) {
                        ((WorkoutRepositoryHandler)object).onComplete();
                    }
                } else {
                    CharSequence charSequence;
                    object = ErrorUtils.parseError(object2);
                    new AccountErrorVo(object2.code(), ((APIError)object).message());
                    AccountErrorVo accountErrorVo = ErrorUtils.getErrorVo(object2);
                    object2 = object2.errorBody();
                    object = "";
                    if (object2 == null) {
                        Log.d((String)TAG, (String)"getWorkoutList errorBody == null");
                    } else {
                        try {
                            object = object2 = object2.string();
                        }
                        catch (IOException iOException) {
                            iOException.printStackTrace();
                        }
                        object2 = TAG;
                        charSequence = new StringBuilder();
                        ((StringBuilder)charSequence).append("getWorkoutList errorBody: ");
                        ((StringBuilder)charSequence).append((String)object);
                        Log.d((String)object2, (String)((StringBuilder)charSequence).toString());
                    }
                    new JSONObject();
                    try {
                        object2 = new JSONObject((String)object);
                        if (object2.has("status")) {
                            String string2 = object2.getString("status");
                            object = TAG;
                            charSequence = new StringBuilder();
                            ((StringBuilder)charSequence).append("getWorkoutList status: ");
                            ((StringBuilder)charSequence).append(string2);
                            Log.d((String)object, (String)((StringBuilder)charSequence).toString());
                        }
                        if (object2.has("message")) {
                            object = object2.getString("message");
                            charSequence = TAG;
                            object2 = new StringBuilder();
                            ((StringBuilder)object2).append("getWorkoutList errorBody message: ");
                            ((StringBuilder)object2).append((String)object);
                            Log.d((String)charSequence, (String)((StringBuilder)object2).toString());
                        }
                    }
                    catch (JSONException jSONException) {
                        jSONException.printStackTrace();
                    }
                    WorkoutRepository.this.liveAccountErrorResponse.postValue(accountErrorVo);
                    object = TAG;
                    object2 = new StringBuilder();
                    ((StringBuilder)object2).append("getWorkoutList error message: ");
                    ((StringBuilder)object2).append(accountErrorVo.getMessage());
                    Log.d((String)object, (String)((StringBuilder)object2).toString());
                    object = workoutRepositoryHandler;
                    if (object != null) {
                        ((WorkoutRepositoryHandler)object).onFail();
                    }
                }
            }
        });
    }

    public byte[] loadWorkoutFit2ByteArray(String object) {
        File file = new File(String.format(this.workoutEncode2FitPath, object));
        int n = (int)file.length();
        object = new byte[n];
        try {
            FileInputStream fileInputStream = new FileInputStream(file);
            BufferedInputStream bufferedInputStream = new BufferedInputStream(fileInputStream);
            bufferedInputStream.read((byte[])object, 0, n);
            bufferedInputStream.close();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        catch (FileNotFoundException fileNotFoundException) {
            fileNotFoundException.printStackTrace();
        }
        return object;
    }

    public void updateWorkout(TrainingPlan trainingPlan, Boolean object, WorkoutRepositoryHandler workoutRepositoryHandler) {
        final String string2 = ProfileUtil.getInstance().getPrefString("userId");
        if (((Boolean)object).booleanValue()) {
            this.encodeWorkoutToFit(new BrytonWorkout(trainingPlan), trainingPlan.id);
            object = trainingPlan.createInfoJson();
            this.decodeWorkoutFit("workout", trainingPlan.id);
            this.updateWorkoutToServer(trainingPlan.id, trainingPlan.name, trainingPlan.provider, null, (JSONObject)object, workoutRepositoryHandler);
        } else {
            String string3 = trainingPlan.id;
            object = trainingPlan.id;
            CharSequence charSequence = new StringBuilder();
            charSequence.append(App.getInstance().getFilesDir());
            charSequence.append(File.separator);
            charSequence.append(string2);
            charSequence.append("/workout");
            charSequence.append(File.separator);
            charSequence.append(string3);
            charSequence.append(".fit");
            if (!new File(charSequence.toString()).exists()) {
                string3 = ProfileUtil.getInstance().getPrefString("com.brytonsport.active.loginToken");
                charSequence = trainingPlan.url;
                this.planTripWorkoutApi.downloadFitWithDynamicUrl(string2, string3, (String)charSequence).enqueue((Callback)new Callback<ResponseBody>((String)object, trainingPlan, workoutRepositoryHandler){
                    final /* synthetic */ WorkoutRepositoryHandler val$handler;
                    final /* synthetic */ TrainingPlan val$plan;
                    final /* synthetic */ String val$workoutId;
                    {
                        this.val$workoutId = string3;
                        this.val$plan = trainingPlan;
                        this.val$handler = workoutRepositoryHandler;
                    }

                    public void onFailure(Call<ResponseBody> call, Throwable throwable) {
                        Log.e((String)TAG, (String)"error");
                    }

                    public void onResponse(Call<ResponseBody> object, Response<ResponseBody> responseBody) {
                        if (responseBody.isSuccessful()) {
                            object = App.getInstance();
                            responseBody = (ResponseBody)responseBody.body();
                            StringBuilder stringBuilder = new StringBuilder();
                            stringBuilder.append(string2);
                            stringBuilder.append("/workout");
                            String string22 = stringBuilder.toString();
                            stringBuilder = new StringBuilder();
                            stringBuilder.append(this.val$workoutId);
                            stringBuilder.append(".fit");
                            if (ActivityFileUtil.writeResponseBodyToDisk(object, responseBody, string22, stringBuilder.toString())) {
                                WorkoutRepository.this.updateWorkout(this.val$plan, false, this.val$handler);
                            } else {
                                this.val$handler.onFail();
                            }
                        } else {
                            Log.d((String)TAG, (String)"server contact failed");
                            this.val$handler.onFail();
                        }
                    }
                });
            } else {
                object = trainingPlan.createInfoJson();
                this.updateWorkoutToServer(trainingPlan.id, trainingPlan.name, trainingPlan.provider, null, (JSONObject)object, workoutRepositoryHandler);
            }
        }
    }

    public void updateWorkoutToServer(final String string2, String string3, String string4, String string5, JSONObject jSONObject, final WorkoutRepositoryHandler workoutRepositoryHandler) {
        Object object = ProfileUtil.getInstance().getPrefString("userId");
        Comparable<StringBuilder> comparable = new StringBuilder();
        ((StringBuilder)comparable).append(App.getInstance().getFilesDir());
        ((StringBuilder)comparable).append(File.separator);
        ((StringBuilder)comparable).append((String)object);
        ((StringBuilder)comparable).append("/workout");
        ((StringBuilder)comparable).append(File.separator);
        ((StringBuilder)comparable).append(string2);
        ((StringBuilder)comparable).append(".fit");
        comparable = new File(((StringBuilder)comparable).toString());
        object = RequestBody.create((MediaType)MediaType.parse((String)"*/*"), (File)comparable);
        comparable = MultipartBody.Part.createFormData((String)"track", (String)((File)comparable).getName(), (RequestBody)object);
        object = new HashMap();
        if (string3 != null && !string3.isEmpty()) {
            object.put("name", RequestBody.create((MediaType)MediaType.parse((String)"text/plain"), (String)string3));
        }
        if (string4 != null && !string4.isEmpty()) {
            object.put("provider", RequestBody.create((MediaType)MediaType.parse((String)"text/plain"), (String)string4));
        }
        if (string5 != null && !string5.isEmpty()) {
            object.put("orgid", RequestBody.create((MediaType)MediaType.parse((String)"text/plain"), (String)string5));
        }
        if (jSONObject != null) {
            object.put("info", RequestBody.create((MediaType)MediaType.parse((String)"text/plain"), (String)jSONObject.toString()));
        }
        this.planTripWorkoutApi.updateWorkoutToServer(string2, (MultipartBody.Part)comparable, (Map<String, RequestBody>)object).enqueue((Callback)new Callback<ResponseBody>(){

            public void onFailure(Call<ResponseBody> object, Throwable throwable) {
                object = new StringBuilder();
                ((StringBuilder)object).append("updateWorkoutToServer -> ");
                ((StringBuilder)object).append(string2);
                ((StringBuilder)object).append(" onFailure : ");
                ((StringBuilder)object).append(throwable.getMessage());
                object = ((StringBuilder)object).toString();
                Log.d((String)TAG, (String)object);
                workoutRepositoryHandler.onFail();
            }

            public void onResponse(Call<ResponseBody> object, Response<ResponseBody> object2) {
                if (object2.isSuccessful()) {
                    object = NetworkUtil.parseResponseBody(object2);
                    if (object2.body() != null) {
                        workoutRepositoryHandler.onComplete();
                        object2 = TAG;
                        StringBuilder stringBuilder = new StringBuilder();
                        stringBuilder.append("updateWorkoutToServer onResponse: resultObj -> ");
                        stringBuilder.append((String)object);
                        Log.d((String)object2, (String)stringBuilder.toString());
                    }
                } else {
                    object = NetworkUtil.parseResponseErrorBody(object2);
                    object2 = new StringBuilder();
                    ((StringBuilder)object2).append("updateWorkoutToServer ->upload ");
                    ((StringBuilder)object2).append(string2);
                    ((StringBuilder)object2).append(" to server error: ");
                    ((StringBuilder)object2).append((String)object);
                    object = ((StringBuilder)object2).toString();
                    workoutRepositoryHandler.onFail();
                    Log.d((String)TAG, object);
                }
            }
        });
    }

    public void uploadWorkoutToServer(String hashMap, final String string2, String string3, String string4, JSONObject jSONObject, final WorkoutRepositoryHandler workoutRepositoryHandler) {
        String string5 = ProfileUtil.getInstance().getPrefString("userId");
        hashMap = new File(String.format(this.workoutEncode2FitPath, hashMap));
        RequestBody requestBody = RequestBody.create((MediaType)MediaType.parse((String)"*/*"), (File)((Object)hashMap));
        requestBody = MultipartBody.Part.createFormData((String)"track", (String)((File)((Object)hashMap)).getName(), (RequestBody)requestBody);
        hashMap = new HashMap<String, RequestBody>();
        if (string2 != null && !string2.isEmpty()) {
            hashMap.put("name", RequestBody.create((MediaType)MediaType.parse((String)"text/plain"), (String)string2));
        }
        if (string3 != null && !string3.isEmpty()) {
            hashMap.put("provider", RequestBody.create((MediaType)MediaType.parse((String)"text/plain"), (String)string3));
        }
        if (string4 != null && !string4.isEmpty()) {
            hashMap.put("orgid", RequestBody.create((MediaType)MediaType.parse((String)"text/plain"), (String)string4));
        }
        if (jSONObject != null) {
            hashMap.put("info", RequestBody.create((MediaType)MediaType.parse((String)"text/plain"), (String)jSONObject.toString()));
        }
        this.planTripWorkoutApi.uploadWorkoutFitToServer(string5, (MultipartBody.Part)requestBody, hashMap).enqueue((Callback)new Callback<ResponseBody>(){

            public void onFailure(Call<ResponseBody> object, Throwable throwable) {
                object = new StringBuilder();
                ((StringBuilder)object).append("uploadWorkoutToServer -> ");
                ((StringBuilder)object).append(string2);
                ((StringBuilder)object).append(" onFailure : ");
                ((StringBuilder)object).append(throwable.getMessage());
                object = ((StringBuilder)object).toString();
                Log.d((String)TAG, (String)object);
                workoutRepositoryHandler.onFail();
            }

            public void onResponse(Call<ResponseBody> object, Response<ResponseBody> object2) {
                if (object2.isSuccessful()) {
                    CharSequence charSequence = NetworkUtil.parseResponseBody(object2);
                    if (object2.body() != null) {
                        try {
                            object = new JSONObject((String)charSequence);
                            object.getString("fileid").isEmpty();
                            workoutRepositoryHandler.onComplete();
                            object2 = TAG;
                            charSequence = new StringBuilder();
                            ((StringBuilder)charSequence).append("uploadWorkoutToServer onResponse: resultObj -> ");
                            ((StringBuilder)charSequence).append(object.toString());
                            Log.d((String)object2, (String)((StringBuilder)charSequence).toString());
                        }
                        catch (JSONException jSONException) {
                            jSONException.printStackTrace();
                        }
                    }
                } else {
                    object = NetworkUtil.parseResponseErrorBody(object2);
                    object2 = new StringBuilder();
                    ((StringBuilder)object2).append("uploadWorkoutToServer ->upload ");
                    ((StringBuilder)object2).append(string2);
                    ((StringBuilder)object2).append(" to server error: ");
                    ((StringBuilder)object2).append((String)object);
                    object = ((StringBuilder)object2).toString();
                    workoutRepositoryHandler.onFail();
                    Log.d((String)TAG, (String)object);
                }
            }
        });
    }
}

