/*
 * Decompiled with CFR 0.152.
 */
package com.brytonsport.active.repo.profile;

import android.content.Context;
import android.util.Log;
import androidx.lifecycle.MutableLiveData;
import com.brytonsport.active.api.APIError;
import com.brytonsport.active.api.ApiService;
import com.brytonsport.active.api.ErrorUtils;
import com.brytonsport.active.api.account.AccountApi;
import com.brytonsport.active.api.account.vo.AccountErrorVo;
import com.brytonsport.active.api.account.vo.AccountUserInfo;
import com.brytonsport.active.api.account.vo.Strava;
import com.brytonsport.active.api.profile.ClimbApi;
import com.brytonsport.active.api.profile.KomootApi;
import com.brytonsport.active.api.profile.ReliveApi;
import com.brytonsport.active.api.profile.RideWithGpsApi;
import com.brytonsport.active.api.profile.RouteyouApi;
import com.brytonsport.active.api.profile.SelfloopsApi;
import com.brytonsport.active.api.profile.StravaApi;
import com.brytonsport.active.api.profile.TodaysplanApi;
import com.brytonsport.active.api.profile.TrainingPeaksApi;
import com.brytonsport.active.base.App;
import com.brytonsport.active.db.AppDatabase;
import com.brytonsport.active.db.account.dao.UserInfoDao;
import com.brytonsport.active.fit.BrytonWorkout;
import com.brytonsport.active.plantriplib.RouteResult;
import com.brytonsport.active.repo.profile.Connect3rdPartyRepository$$ExternalSyntheticLambda0;
import com.brytonsport.active.repo.profile.Connect3rdPartyRepositoryHandler;
import com.brytonsport.active.utils.ActivityFileUtil;
import com.brytonsport.active.utils.Base64Util;
import com.brytonsport.active.utils.ClimbApiActionListener;
import com.brytonsport.active.utils.ClimbProLocation;
import com.brytonsport.active.utils.ClimbResponseData;
import com.brytonsport.active.utils.DistanceUtil;
import com.brytonsport.active.utils.FileUtil;
import com.brytonsport.active.utils.FirebaseCustomUtil;
import com.brytonsport.active.utils.GZipUtils;
import com.brytonsport.active.utils.ManeuverUtil;
import com.brytonsport.active.utils.PlanTripUtil;
import com.brytonsport.active.utils.ProfileUtil;
import com.brytonsport.active.utils.xml.XmlToJson;
import com.brytonsport.active.vm.base.TrainingPlan;
import com.google.gson.Gson;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.inject.Inject;
import okhttp3.MediaType;
import okhttp3.MultipartBody;
import okhttp3.RequestBody;
import okhttp3.ResponseBody;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import retrofit2.Call;
import retrofit2.Callback;
import retrofit2.Response;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class Connect3rdPartyRepository {
    public static final String SERVER_SERVICE_NAME_KOMOOT = "komoot";
    public static final String SERVER_SERVICE_NAME_RELIVE = "relive";
    public static final String SERVER_SERVICE_NAME_ROUTEYOU = "routeyou";
    public static final String SERVER_SERVICE_NAME_SELFLOOPS = "selfloops";
    public static final String SERVER_SERVICE_NAME_STRAVA = "strava";
    public static final String SERVER_SERVICE_NAME_TODAYSPLAN = "todaysplan";
    public static final String SERVER_SERVICE_NAME_TRAININGPEAKS = "trainingpeaks";
    static final String TAG = "Connect3rdPartyRepository";
    private final MutableLiveData<Boolean> _isUpdateService2ServerSuccessLiveData;
    private final AccountApi accountApi;
    private final ClimbApi climbApi;
    private String climbApiBaseUrl = "https://okaymlks2a.execute-api.us-west-2.amazonaws.com/prod/api/v1";
    private MutableLiveData<Boolean> isGetRideWithGpsUserIdLiveData;
    private final KomootApi komootApi;
    private String komootBaseUrl = "https://auth-api.main.komoot.net/oauth/token?redirect_uri=%s&grant_type=authorization_code&code=%s";
    private final MutableLiveData<AccountErrorVo> liveAccountErrorResponse;
    private List<Integer> mAltitudeList = new ArrayList<Integer>();
    private int mGain = 0;
    private MutableLiveData<String> mKomootPlanTripListLiveData;
    private MutableLiveData<String> mKomootPlanTripOnlyUnlockListLiveData;
    private MutableLiveData<String> mKomootRouteLiveData;
    private int mLoss = 0;
    private MutableLiveData<String> mRideWithGpsPlanTripListLiveData;
    private MutableLiveData<String> mRideWithGpsRouteLiveData;
    private MutableLiveData<String> mStravaPlanTripListLiveData;
    private MutableLiveData<String> mStravaRouteLiveData;
    private MutableLiveData<Token2ServerResult> mToken2ServerLiveData;
    private MutableLiveData<Boolean> mTrainingPeaksNeedRefreshToken;
    private MutableLiveData<ArrayList<TrainingPlan>> mTrainingPeaksWorkoutListLiveData;
    private MutableLiveData<String> mUpload2ReliveLiveData;
    private MutableLiveData<String> mUpload2SelfloopsLiveData;
    private MutableLiveData<String> mUpload2StravaLiveData;
    private MutableLiveData<String> mUpload2TodaysplanLiveData;
    private MutableLiveData<String> mUpload2TrainingPeaksLiveData;
    private String redirectUri = "https://active.brytonsport.com";
    private final ReliveApi reliveApi;
    private String reliveBaseUrl = "https://public.api.relive.cc/v1/oauth/token";
    private String reliveRedirectUrl = "https://active.brytonsport.com/_oauth/relive?close";
    private final RideWithGpsApi rideWithGpsApi;
    private String rideWithGpsApiBaseUrl = "https://ridewithgps.com/users/current.json";
    private final RouteyouApi routeyouApi;
    private String routeyouApiBaseUrl = "https://api.routeyou.com/2.0/rest/oauth/token";
    private String routeyouRedirectUri = "oauth://active.brytonsport.com";
    private final SelfloopsApi selfloopsApi;
    private String selfloopsApiBaseUrl = "https://www.selfloops.com/oauth/token";
    private final StravaApi stravaApi;
    private String stravaBaseUrl = "https://www.strava.com/oauth/token?client_id=%s&client_secret=%s&grant_type=authorization_code&code=%s";
    private final TodaysplanApi todaysplanApi;
    private String todaysplanApiBaseUrl = "https://whats.todaysplan.com.au/rest/oauth/access_token";
    private final TrainingPeaksApi trainingPeaksApi;
    private String trainingPeaksBaseUrl = "https://oauth.trainingpeaks.com/oauth/token";
    private final UserInfoDao userInfoDao;

    @Inject
    public Connect3rdPartyRepository() {
        this.isGetRideWithGpsUserIdLiveData = new MutableLiveData();
        this.mRideWithGpsPlanTripListLiveData = new MutableLiveData();
        this.mRideWithGpsRouteLiveData = new MutableLiveData();
        this.mTrainingPeaksWorkoutListLiveData = new MutableLiveData();
        this.mTrainingPeaksNeedRefreshToken = new MutableLiveData();
        this.mToken2ServerLiveData = new MutableLiveData();
        this.mKomootPlanTripListLiveData = new MutableLiveData();
        this.mKomootPlanTripOnlyUnlockListLiveData = new MutableLiveData();
        this.mKomootRouteLiveData = new MutableLiveData();
        this.mStravaPlanTripListLiveData = new MutableLiveData();
        this.mStravaRouteLiveData = new MutableLiveData();
        this.liveAccountErrorResponse = new MutableLiveData();
        this._isUpdateService2ServerSuccessLiveData = new MutableLiveData();
        this.mUpload2StravaLiveData = new MutableLiveData();
        this.mUpload2TrainingPeaksLiveData = new MutableLiveData();
        this.mUpload2ReliveLiveData = new MutableLiveData();
        this.mUpload2TodaysplanLiveData = new MutableLiveData();
        this.mUpload2SelfloopsLiveData = new MutableLiveData();
        this.accountApi = ApiService.getInstance().getAccountApi();
        this.stravaApi = ApiService.getInstance().getStravaApi();
        this.komootApi = ApiService.getInstance().getKomootApi();
        this.trainingPeaksApi = ApiService.getInstance().getTrainingPeaksApi();
        this.reliveApi = ApiService.getInstance().getReliveApi();
        this.rideWithGpsApi = ApiService.getInstance().getRideWithGpsApi();
        this.todaysplanApi = ApiService.getInstance().getTodaysplanApi();
        this.selfloopsApi = ApiService.getInstance().getSelfloopsApi();
        this.routeyouApi = ApiService.getInstance().getRouteyouApi();
        this.climbApi = ApiService.getInstance().getClimbApi();
        this.userInfoDao = AppDatabase.getInstance(App.getInstance().getApplicationContext()).userInfoDao();
    }

    private void getElevationGain() {
        List<Integer> list = this.mAltitudeList;
        int n = list.get(0);
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        int n5 = 1000000;
        for (int i = 0; i < this.mAltitudeList.size(); ++i) {
            int n6 = this.mAltitudeList.get(i);
            int n7 = n2;
            if (n6 > n) {
                n7 = n2 + (n6 - n);
            }
            int n8 = n3;
            if (n6 < n) {
                n8 = n3 + (n - n6);
            }
            int n9 = n4;
            if (n6 > n4) {
                n9 = n6;
            }
            int n10 = n5;
            if (n6 < n5) {
                n10 = n6;
            }
            n = n6;
            n2 = n7;
            n3 = n8;
            n4 = n9;
            n5 = n10;
        }
        this.mGain = n2;
        this.mLoss = n3;
    }

    private JSONObject getFinalJson(ArrayList<ClimbProLocation> jSONObject) throws JSONException {
        JSONArray jSONArray = new JSONArray();
        for (ClimbProLocation climbProLocation : jSONObject) {
            jSONObject = new JSONObject();
            jSONObject.put("x", (double)climbProLocation.lat);
            jSONObject.put("y", (double)climbProLocation.lon);
            jSONArray.put((Object)jSONObject);
        }
        jSONObject = new JSONObject();
        jSONObject.put("points", (Object)jSONArray);
        return jSONObject;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private JSONObject getKomootPlanTripListDecode(String string2) {
        JSONObject jSONObject = new JSONObject();
        JSONArray jSONArray = new JSONArray();
        try {
            JSONObject jSONObject2 = new JSONObject(string2);
            if (!jSONObject2.has("_embedded")) return jSONObject;
            string2 = jSONObject2.getJSONObject("_embedded");
            if (!string2.has("tours")) return jSONObject;
            int n = (string2 = string2.getJSONArray("tours")).length();
            if (n > 0) {
                for (n = 0; n < string2.length(); ++n) {
                    JSONObject jSONObject3;
                    jSONObject2 = new JSONObject();
                    if (n == 0) {
                        jSONObject.put("code", 200);
                        jSONObject.put("errorMessage", null);
                    }
                    if ((jSONObject3 = string2.getJSONObject(n)).has("id")) {
                        jSONObject2.put("id", (Object)jSONObject3.getString("id"));
                    }
                    if (jSONObject3.has("name")) {
                        jSONObject2.put("name", (Object)jSONObject3.getString("name"));
                        jSONObject2.put("provider", (Object)SERVER_SERVICE_NAME_KOMOOT);
                    }
                    if (jSONObject3.has("changed_at")) {
                        jSONObject2.put("changed_at", jSONObject3.get("changed_at"));
                    }
                    jSONArray.put((Object)jSONObject2);
                }
                jSONObject.put("data", (Object)jSONArray);
                return jSONObject;
            }
            jSONObject.put("code", 400);
            jSONObject.put("errorMessage", (Object)"error msg");
            jSONObject.put("data", null);
            return jSONObject;
        }
        catch (JSONException jSONException) {
            Log.d((String)"Grad Debug", (String)"JSONArray() error.");
            jSONException.printStackTrace();
        }
        return jSONObject;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private JSONObject getRideWithGpsPlanTripListDecode(String string2) {
        JSONObject jSONObject = new JSONObject();
        JSONArray jSONArray = new JSONArray();
        try {
            JSONArray jSONArray2 = new JSONArray(string2);
            int n = jSONArray2.length();
            if (n > 0) {
                for (int i = 0; i < n; ++i) {
                    if (i == 0) {
                        jSONObject.put("code", 200);
                        jSONObject.put("errorMessage", null);
                    }
                    JSONObject jSONObject2 = jSONArray2.getJSONObject(i);
                    string2 = new JSONObject();
                    if (jSONObject2.has("id")) {
                        string2.put("id", (Object)jSONObject2.getString("id"));
                    }
                    if (jSONObject2.has("name")) {
                        string2.put("name", (Object)jSONObject2.getString("name"));
                        string2.put("provider", (Object)"ridewithgps");
                    }
                    if (jSONObject2.has("created_at")) {
                        string2.put("created_at", jSONObject2.get("created_at"));
                    }
                    jSONArray.put((Object)string2);
                }
                jSONObject.put("data", (Object)jSONArray);
                return jSONObject;
            }
            jSONObject.put("code", 400);
            jSONObject.put("errorMessage", (Object)"error msg");
            jSONObject.put("data", null);
            return jSONObject;
        }
        catch (JSONException jSONException) {
            Log.d((String)"Grad Debug", (String)"JSONArray() error.");
            jSONException.printStackTrace();
        }
        return jSONObject;
    }

    /*
     * Loose catch block
     */
    private JSONObject gpxContextParser(String object) {
        Object object2;
        block45: {
            String string2;
            block46: {
                Object object3;
                block42: {
                    block38: {
                        double d;
                        int n;
                        block44: {
                            block43: {
                                String string3 = "ele";
                                String string4 = "lat";
                                object2 = "Grad Debug";
                                JSONObject jSONObject = new XmlToJson.Builder((String)object).build().toJson();
                                object = new JSONObject();
                                JSONObject jSONObject2 = new JSONObject();
                                JSONArray jSONArray = new JSONArray();
                                this.mAltitudeList.clear();
                                string2 = object2;
                                object3 = object;
                                if (!jSONObject.has("gpx")) break block38;
                                string2 = object2;
                                object3 = object;
                                jSONObject = jSONObject.getJSONObject("gpx");
                                string2 = object2;
                                object3 = object;
                                if (!jSONObject.has("trk")) break block38;
                                string2 = object2;
                                object3 = object;
                                jSONObject = jSONObject.getJSONObject("trk");
                                string2 = object2;
                                object3 = object;
                                if (!jSONObject.has("trkseg")) break block38;
                                string2 = object2;
                                object3 = object;
                                jSONObject = jSONObject.getJSONObject("trkseg").getJSONArray("trkpt");
                                string2 = object2;
                                object3 = object;
                                int n2 = jSONObject.length();
                                if (n2 <= 0) break block38;
                                string2 = object2;
                                object3 = object;
                                string2 = object2;
                                object3 = object;
                                StringBuilder stringBuilder = new StringBuilder();
                                string2 = object2;
                                object3 = object;
                                stringBuilder.append("Total ");
                                string2 = object2;
                                object3 = object;
                                stringBuilder.append(String.valueOf(n2));
                                string2 = object2;
                                object3 = object;
                                stringBuilder.append(" item");
                                string2 = object2;
                                object3 = object;
                                Log.d((String)"Grad Debug", (String)stringBuilder.toString());
                                string2 = object2;
                                object3 = object;
                                jSONObject2.put("major", 0);
                                string2 = object2;
                                object3 = object;
                                jSONObject2.put("minor", 1);
                                string2 = object2;
                                object3 = object;
                                object.put("version", (Object)jSONObject2);
                                float f = 0.0f;
                                float f2 = 0.0f;
                                float f3 = 0.0f;
                                float f4 = 0.0f;
                                float f5 = 0.0f;
                                for (n = 0; n < n2; ++n) {
                                    block41: {
                                        boolean bl;
                                        block40: {
                                            block39: {
                                                try {
                                                    jSONObject2 = new JSONObject();
                                                    stringBuilder = jSONObject.getJSONObject(n);
                                                    bl = stringBuilder.has(string4);
                                                    if (!bl) break block39;
                                                    string2 = object2;
                                                    object3 = object;
                                                }
                                                catch (JSONException jSONException) {
                                                    string2 = object2;
                                                    object2 = object;
                                                    object = string2;
                                                    break block42;
                                                }
                                                f4 = (float)stringBuilder.getDouble(string4);
                                                string2 = object2;
                                                object3 = object;
                                                jSONObject2.put("position_lat", (double)f4);
                                            }
                                            bl = stringBuilder.has("lon");
                                            if (!bl) break block40;
                                            string2 = object2;
                                            object3 = object;
                                            f5 = (float)stringBuilder.getDouble("lon");
                                            string2 = object2;
                                            object3 = object;
                                            jSONObject2.put("position_long", (double)f5);
                                        }
                                        bl = stringBuilder.has(string3);
                                        if (!bl) break block41;
                                        string2 = object2;
                                        object3 = object;
                                        int n3 = (int)stringBuilder.getDouble(string3);
                                        string2 = object2;
                                        object3 = object;
                                        jSONObject2.put("altitude", n3);
                                        string2 = object2;
                                        object3 = object;
                                        jSONArray.put((Object)jSONObject2);
                                        string2 = object2;
                                        object3 = object;
                                        this.mAltitudeList.add(n3);
                                    }
                                    if (n != 0) {
                                        double d2 = f;
                                        double d3 = f2;
                                        d = f3;
                                        double d4 = f4;
                                        double d5 = f5;
                                        f = (float)(d2 + DistanceUtil.distance(d3, d, d4, d5));
                                    }
                                    f3 = f5;
                                    float f6 = f4;
                                    f2 = f4;
                                    f4 = f6;
                                }
                                string2 = object2;
                                object2 = object;
                                try {
                                    object2.put("points", (Object)jSONArray);
                                    object2.put("distance", (double)f);
                                    object = new ArrayList();
                                    object.add(object2);
                                    object = PlanTripUtil.calPlanTripRouteGain(object);
                                    if (object != null) break block43;
                                    d = 0.0;
                                    break block44;
                                }
                                catch (JSONException jSONException) {
                                    break block46;
                                }
                            }
                            d = ((RouteResult)object).gain;
                        }
                        n = (int)d;
                        try {
                            this.mGain = n;
                            object2.put("gain", n);
                            object2.put("loss", this.mLoss);
                            break block45;
                        }
                        catch (JSONException jSONException) {
                            break block46;
                        }
                        catch (JSONException jSONException) {
                            string2 = object2;
                            object2 = jSONException;
                            object3 = object;
                            object = object2;
                            object2 = object3;
                            break block46;
                        }
                    }
                    object2 = object;
                    break block45;
                    catch (JSONException jSONException) {
                        object = string2;
                        object2 = object3;
                        object3 = jSONException;
                    }
                }
                string2 = object;
                object = object3;
            }
            Log.d((String)string2, (String)"JSONArray() error.");
            object.printStackTrace();
        }
        return object2;
    }

    private void loadUserInfoGetStravaProfile(JSONObject jSONObject) {
        Log.d((String)TAG, (String)"loadUserInfoGetStravaProfile: 20221110");
        new Thread(new Connect3rdPartyRepository$$ExternalSyntheticLambda0(this, (String)ProfileUtil.getInstance().get("userId"), jSONObject)).start();
    }

    private void prepareKomootToken2Server(JSONObject jSONObject) {
        JSONObject jSONObject2 = new JSONObject();
        try {
            if (jSONObject.has("access_token")) {
                jSONObject2.put("access_token", (Object)jSONObject.getString("access_token"));
            }
            if (jSONObject.has("refresh_token")) {
                jSONObject2.put("refresh_token", (Object)jSONObject.getString("refresh_token"));
            }
            if (jSONObject.has("expires_in")) {
                jSONObject2.put("expires_in", jSONObject.getInt("expires_in"));
            }
            if (jSONObject.has("username")) {
                jSONObject2.put("ID", (Object)jSONObject.getString("username"));
            }
        }
        catch (JSONException jSONException) {
            jSONException.printStackTrace();
        }
        this.updateServiceOAuth2Server(SERVER_SERVICE_NAME_KOMOOT, jSONObject2);
    }

    private void prepareReliveToken2Server(JSONObject jSONObject, String string2) {
        JSONObject jSONObject2 = new JSONObject();
        try {
            if (jSONObject.has("access_token")) {
                jSONObject2.put("access_token", (Object)jSONObject.getString("access_token"));
            }
            if (jSONObject.has("refresh_token")) {
                jSONObject2.put("refresh_token", (Object)jSONObject.getString("refresh_token"));
            } else {
                jSONObject2.put("refresh_token", (Object)string2);
            }
            if (jSONObject.has("expires_in")) {
                jSONObject2.put("expires_in", jSONObject.getInt("expires_in"));
            }
        }
        catch (JSONException jSONException) {
            jSONException.printStackTrace();
        }
        this.updateServiceOAuth2Server(SERVER_SERVICE_NAME_RELIVE, jSONObject2);
    }

    private void prepareRouteyouToken2Server(JSONObject jSONObject) {
        JSONObject jSONObject2 = new JSONObject();
        try {
            if (jSONObject.has("access_token")) {
                jSONObject2.put("access_token", (Object)jSONObject.getString("access_token"));
            }
            if (jSONObject.has("refresh_token")) {
                jSONObject2.put("refresh_token", (Object)jSONObject.getString("refresh_token"));
            }
            if (jSONObject.has("expires_in")) {
                jSONObject2.put("expires_in", jSONObject.getInt("expires_in"));
            }
        }
        catch (JSONException jSONException) {
            jSONException.printStackTrace();
        }
        this.updateServiceOAuth2Server(SERVER_SERVICE_NAME_ROUTEYOU, jSONObject2);
    }

    private void prepareSelfloopsToken2Server(JSONObject jSONObject) {
        JSONObject jSONObject2 = new JSONObject();
        try {
            if (jSONObject.has("access_token")) {
                jSONObject2.put("access_token", (Object)jSONObject.getString("access_token"));
            }
            if (jSONObject.has("refresh_token")) {
                jSONObject2.put("refresh_token", (Object)jSONObject.getString("refresh_token"));
            }
            if (jSONObject.has("expires_in")) {
                jSONObject2.put("expires_in", jSONObject.getInt("expires_in"));
            }
        }
        catch (JSONException jSONException) {
            jSONException.printStackTrace();
        }
        this.updateServiceOAuth2Server(SERVER_SERVICE_NAME_SELFLOOPS, jSONObject2);
    }

    private void prepareStravaToken2Server(JSONObject jSONObject) {
        JSONObject jSONObject2 = new JSONObject();
        try {
            if (jSONObject.has("access_token")) {
                jSONObject2.put("access_token", (Object)jSONObject.getString("access_token"));
            }
            if (jSONObject.has("refresh_token")) {
                jSONObject2.put("refresh_token", (Object)jSONObject.getString("refresh_token"));
            }
            if (jSONObject.has("expires_in")) {
                jSONObject2.put("expires_in", jSONObject.getInt("expires_in"));
            }
            if (jSONObject.has("athlete")) {
                if ((jSONObject = jSONObject.getJSONObject("athlete")).has("id")) {
                    jSONObject2.put("id", (Object)jSONObject.getString("id"));
                }
                if (jSONObject.has("firstname")) {
                    jSONObject2.put("firstname", (Object)jSONObject.getString("firstname"));
                }
                if (jSONObject.has("lastname")) {
                    jSONObject2.put("lastname", (Object)jSONObject.getString("lastname"));
                }
                if (jSONObject.has("sex")) {
                    jSONObject2.put("sex", (Object)jSONObject.getString("sex"));
                }
                this.updateServiceOAuth2Server(SERVER_SERVICE_NAME_STRAVA, jSONObject2);
            } else {
                this.loadUserInfoGetStravaProfile(jSONObject2);
            }
        }
        catch (JSONException jSONException) {
            jSONException.printStackTrace();
        }
    }

    private void prepareTodaysplanToken2Server(JSONObject jSONObject) {
        JSONObject jSONObject2 = new JSONObject();
        try {
            if (jSONObject.has("access_token")) {
                jSONObject2.put("access_token", (Object)jSONObject.getString("access_token"));
            }
            if (jSONObject.has("refresh_token")) {
                jSONObject2.put("refresh_token", (Object)jSONObject.getString("refresh_token"));
            } else {
                jSONObject2.put("refresh_token", (Object)"null");
            }
            if (jSONObject.has("expires_in")) {
                jSONObject2.put("expires_in", jSONObject.getInt("expires_in"));
            }
        }
        catch (JSONException jSONException) {
            jSONException.printStackTrace();
        }
        this.updateServiceOAuth2Server(SERVER_SERVICE_NAME_TODAYSPLAN, jSONObject2);
    }

    private void prepareTrainingPeaksToken2Server(JSONObject jSONObject) {
        JSONObject jSONObject2 = new JSONObject();
        try {
            if (jSONObject.has("access_token")) {
                jSONObject2.put("access_token", (Object)jSONObject.getString("access_token"));
            }
            if (jSONObject.has("refresh_token")) {
                jSONObject2.put("refresh_token", (Object)jSONObject.getString("refresh_token"));
            }
            if (jSONObject.has("expires_in")) {
                jSONObject2.put("expires_in", jSONObject.getInt("expires_in"));
            }
        }
        catch (JSONException jSONException) {
            jSONException.printStackTrace();
        }
        this.updateServiceOAuth2Server(SERVER_SERVICE_NAME_TRAININGPEAKS, jSONObject2);
    }

    public MutableLiveData<ClimbResponseData> climbApi(ArrayList<ClimbProLocation> call) {
        final MutableLiveData<ClimbResponseData> mutableLiveData = new MutableLiveData<ClimbResponseData>();
        try {
            call = this.getFinalJson((ArrayList<ClimbProLocation>)call);
            call = RequestBody.create((MediaType)MediaType.parse((String)"application/json"), (String)call.toString());
            call = this.climbApi.refreshToken("https://okaymlks2a.execute-api.us-west-2.amazonaws.com/prod/api/v1/?g1=150&g2=1.5&g3=150&c1=1.8&c2=2000&c3=300&d1=1000", "application/json", (RequestBody)call);
            Callback<ResponseBody> callback = new Callback<ResponseBody>(){

                public void onFailure(Call<ResponseBody> call, Throwable throwable) {
                    mutableLiveData.postValue(null);
                    Log.d((String)TAG, (String)"\u6ce2\u6bb5 climbApi() \u5411Server\u53d6\u5f97Climb\u6578\u64da onFailure");
                }

                public void onResponse(Call<ResponseBody> object, Response<ResponseBody> object2) {
                    if (object2.isSuccessful()) {
                        object = (ResponseBody)object2.body();
                        try {
                            object2 = object.string();
                            object = new Gson();
                            object = (ClimbResponseData)object.fromJson(object2, ClimbResponseData.class);
                            mutableLiveData.postValue(object);
                        }
                        catch (IOException iOException) {
                            iOException.printStackTrace();
                        }
                    } else {
                        Object object3 = object2.errorBody();
                        object = null;
                        try {
                            object3 = object3.string();
                            object = object3;
                        }
                        catch (IOException iOException) {
                            iOException.printStackTrace();
                        }
                        try {
                            object3 = new JSONObject((String)object);
                            object3.put("code", object2.code());
                            object2 = TAG;
                            object = new StringBuilder();
                            ((StringBuilder)object).append("\u6ce2\u6bb5 climbApi() \u5411Server\u53d6\u5f97Climb\u6578\u64da \u5931\u6557: ");
                            ((StringBuilder)object).append(object3.toString());
                            Log.d(object2, (String)((StringBuilder)object).toString());
                        }
                        catch (JSONException jSONException) {
                            jSONException.printStackTrace();
                        }
                    }
                }
            };
            call.enqueue((Callback)callback);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return mutableLiveData;
    }

    public void climbApi(ArrayList<ClimbProLocation> call, final ClimbApiActionListener climbApiActionListener) {
        try {
            call = this.getFinalJson((ArrayList<ClimbProLocation>)call);
            call = RequestBody.create((MediaType)MediaType.parse((String)"application/json"), (String)call.toString());
            call = this.climbApi.refreshToken("https://okaymlks2a.execute-api.us-west-2.amazonaws.com/prod/api/v1/?g1=150&g2=1.5&g3=150&c1=1.8&c2=2000&c3=300&d1=1000", "application/json", (RequestBody)call);
            Callback<ResponseBody> callback = new Callback<ResponseBody>(){

                public void onFailure(Call<ResponseBody> jSONObject, Throwable throwable) {
                    try {
                        jSONObject = new JSONObject();
                        jSONObject.put("message", (Object)throwable.getMessage());
                        climbApiActionListener.onError(jSONObject);
                    }
                    catch (JSONException jSONException) {
                        jSONException.printStackTrace();
                    }
                    Log.d((String)TAG, (String)"\u6ce2\u6bb5 climbApi() \u5411Server\u53d6\u5f97Climb\u6578\u64da onFailure");
                }

                public void onResponse(Call<ResponseBody> object, Response<ResponseBody> object2) {
                    if (object2.isSuccessful()) {
                        object = (ResponseBody)object2.body();
                        try {
                            object2 = object.string();
                            object = new Gson();
                            object = (ClimbResponseData)object.fromJson(object2, ClimbResponseData.class);
                            climbApiActionListener.onSuccess((ClimbResponseData)object);
                        }
                        catch (IOException iOException) {
                            iOException.printStackTrace();
                        }
                    } else {
                        Object object3 = object2.errorBody();
                        object = null;
                        try {
                            object3 = object3.string();
                            object = object3;
                        }
                        catch (IOException iOException) {
                            iOException.printStackTrace();
                        }
                        try {
                            object3 = new JSONObject((String)object);
                            object3.put("code", object2.code());
                            climbApiActionListener.onError((JSONObject)object3);
                            object2 = TAG;
                            object = new StringBuilder();
                            ((StringBuilder)object).append("\u6ce2\u6bb5 climbApi() \u5411Server\u53d6\u5f97Climb\u6578\u64da \u5931\u6557: ");
                            ((StringBuilder)object).append(object3.toString());
                            Log.d(object2, (String)((StringBuilder)object).toString());
                        }
                        catch (JSONException jSONException) {
                            jSONException.printStackTrace();
                        }
                    }
                }
            };
            call.enqueue((Callback)callback);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public MutableLiveData<Boolean> getIsGetRideWithGpsUserIdLiveData() {
        return this.isGetRideWithGpsUserIdLiveData;
    }

    public void getKomootPlanTrip(String string2, final String string3, final String string4, final Object object) {
        CharSequence charSequence = new StringBuilder();
        charSequence.append("https://external-api.komoot.de/v007/tours/");
        charSequence.append(string3);
        charSequence.append(".gpx");
        charSequence = charSequence.toString();
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Bearer ");
        stringBuilder.append(string2);
        string2 = stringBuilder.toString();
        this.komootApi.getPlanTrip((String)charSequence, string2).enqueue((Callback)new Callback<ResponseBody>(){

            public void onFailure(Call<ResponseBody> object2, Throwable throwable) {
                String string2 = TAG;
                object2 = new StringBuilder();
                ((StringBuilder)object2).append("onFailure: ");
                ((StringBuilder)object2).append(throwable.getMessage());
                Log.d((String)string2, (String)((StringBuilder)object2).toString());
                Connect3rdPartyRepository.this.mKomootRouteLiveData.postValue(null);
            }

            public void onResponse(Call<ResponseBody> object4, Response<ResponseBody> object2) {
                if (object2.isSuccessful()) {
                    object2 = (ResponseBody)object2.body();
                    try {
                        object4 = object2.string();
                    }
                    catch (IOException iOException) {
                        iOException.printStackTrace();
                        object4 = null;
                    }
                    Object object3 = Connect3rdPartyRepository.this.gpxContextParser((String)object4);
                    if (object3 != null) {
                        try {
                            object3.put("tmp_orgid", (Object)string3);
                            object3.put("tmp_r_name", (Object)string4);
                            object3.put("tmp_r_provider", (Object)PlanTripUtil.PROVIDER_SYNC_FROM_KOMOOT);
                            object3.put("changed_at", object);
                        }
                        catch (JSONException jSONException) {
                            jSONException.printStackTrace();
                        }
                        Connect3rdPartyRepository.this.mKomootRouteLiveData.postValue(object3.toString());
                    } else {
                        Connect3rdPartyRepository.this.mKomootRouteLiveData.postValue(null);
                    }
                    object4 = TAG;
                    object3 = new StringBuilder();
                    ((StringBuilder)object3).append("onResponse: ");
                    ((StringBuilder)object3).append(object2.toString());
                    Log.d((String)object4, (String)((StringBuilder)object3).toString());
                } else {
                    object4 = ErrorUtils.parseError(object2);
                    new AccountErrorVo(object2.code(), ((APIError)object4).message());
                    String string2 = TAG;
                    object2 = new StringBuilder();
                    ((StringBuilder)object2).append("getKomootPlanTrip error message: ");
                    ((StringBuilder)object2).append(((APIError)object4).message());
                    Log.d((String)string2, (String)((StringBuilder)object2).toString());
                    Connect3rdPartyRepository.this.mKomootRouteLiveData.postValue(null);
                }
            }
        });
    }

    public void getKomootPlanTripList(String string2, String string3, final boolean bl) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("https://external-api.komoot.de/v007/users/");
        stringBuilder.append(string3);
        stringBuilder.append("/tours/?only_unlocked=");
        stringBuilder.append(bl);
        string3 = stringBuilder.toString();
        stringBuilder = new StringBuilder();
        stringBuilder.append("Bearer ");
        stringBuilder.append(string2);
        string2 = stringBuilder.toString();
        this.komootApi.getPlanTripList(string3, string2).enqueue((Callback)new Callback<ResponseBody>(){

            public void onFailure(Call<ResponseBody> object, Throwable throwable) {
                object = TAG;
                StringBuilder stringBuilder = new StringBuilder();
                stringBuilder.append("onFailure: ");
                stringBuilder.append(throwable.getMessage());
                Log.d(object, (String)stringBuilder.toString());
                if (bl) {
                    Connect3rdPartyRepository.this.mKomootPlanTripOnlyUnlockListLiveData.postValue(null);
                } else {
                    Connect3rdPartyRepository.this.mKomootPlanTripListLiveData.postValue(null);
                }
            }

            public void onResponse(Call<ResponseBody> object, Response<ResponseBody> object2) {
                if (object2.isSuccessful()) {
                    object2 = (ResponseBody)object2.body();
                    try {
                        object = object2.string();
                    }
                    catch (IOException iOException) {
                        iOException.printStackTrace();
                        object = null;
                    }
                    object = Connect3rdPartyRepository.this.getKomootPlanTripListDecode(object);
                    if (bl) {
                        if (object != null) {
                            Connect3rdPartyRepository.this.mKomootPlanTripOnlyUnlockListLiveData.postValue(object.toString());
                        } else {
                            Connect3rdPartyRepository.this.mKomootPlanTripOnlyUnlockListLiveData.postValue(null);
                        }
                    } else if (object != null) {
                        Connect3rdPartyRepository.this.mKomootPlanTripListLiveData.postValue(object.toString());
                    } else {
                        Connect3rdPartyRepository.this.mKomootPlanTripListLiveData.postValue(null);
                    }
                    String string2 = TAG;
                    object = new StringBuilder();
                    ((StringBuilder)object).append("onResponse: ");
                    ((StringBuilder)object).append(object2.toString());
                    Log.d((String)string2, (String)((StringBuilder)object).toString());
                } else {
                    Object object3 = ErrorUtils.parseError(object2);
                    object = new AccountErrorVo(object2.code(), ((APIError)object3).message());
                    String string3 = TAG;
                    object2 = new StringBuilder();
                    ((StringBuilder)object2).append("getKomootPlanTripList error message: ");
                    ((StringBuilder)object2).append(((APIError)object3).message());
                    Log.d((String)string3, (String)((StringBuilder)object2).toString());
                    if (bl) {
                        object3 = Connect3rdPartyRepository.this.mKomootPlanTripOnlyUnlockListLiveData;
                        object2 = new StringBuilder();
                        ((StringBuilder)object2).append("");
                        ((StringBuilder)object2).append(((AccountErrorVo)object).getCode());
                        ((MutableLiveData)object3).postValue(((StringBuilder)object2).toString());
                    } else {
                        object2 = Connect3rdPartyRepository.this.mKomootPlanTripListLiveData;
                        object3 = new StringBuilder();
                        ((StringBuilder)object3).append("");
                        ((StringBuilder)object3).append(((AccountErrorVo)object).getCode());
                        ((MutableLiveData)object2).postValue(((StringBuilder)object3).toString());
                    }
                }
            }
        });
    }

    public MutableLiveData<String> getKomootPlanTripListLiveData() {
        return this.mKomootPlanTripListLiveData;
    }

    public MutableLiveData<String> getKomootPlanTripOnlyUnlockListLiveData() {
        return this.mKomootPlanTripOnlyUnlockListLiveData;
    }

    public MutableLiveData<String> getKomootRouteLiveData() {
        return this.mKomootRouteLiveData;
    }

    public void getKomootToken(String string2) {
        string2 = String.format(this.komootBaseUrl, this.redirectUri, string2);
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Basic ");
        CharSequence charSequence = new StringBuilder();
        charSequence.append("bryton-vg3tsv");
        charSequence.append(":");
        charSequence.append("rah7jae5aph2piephaigo0joh");
        stringBuilder.append(Base64Util.encodeString(charSequence.toString()));
        charSequence = stringBuilder.toString();
        this.komootApi.getToken(string2, "application/json", (String)charSequence).enqueue((Callback)new Callback<ResponseBody>(){

            public void onFailure(Call<ResponseBody> object, Throwable throwable) {
                object = TAG;
                StringBuilder stringBuilder = new StringBuilder();
                stringBuilder.append("onFailure: ");
                stringBuilder.append(throwable.getMessage());
                Log.d(object, (String)stringBuilder.toString());
            }

            public void onResponse(Call<ResponseBody> object, Response<ResponseBody> object2) {
                if (object2.isSuccessful()) {
                    ResponseBody responseBody = (ResponseBody)object2.body();
                    object = null;
                    try {
                        object = object2 = responseBody.string();
                    }
                    catch (IOException iOException) {
                        iOException.printStackTrace();
                    }
                    try {
                        object2 = new JSONObject((String)object);
                        Connect3rdPartyRepository.this.prepareKomootToken2Server((JSONObject)object2);
                    }
                    catch (JSONException jSONException) {
                        jSONException.printStackTrace();
                    }
                    object = TAG;
                    object2 = new StringBuilder();
                    ((StringBuilder)object2).append("onResponse: ");
                    ((StringBuilder)object2).append(responseBody.toString());
                    Log.d((String)object, (String)((StringBuilder)object2).toString());
                } else {
                    object = ErrorUtils.parseError(object2);
                    object2 = new AccountErrorVo(object2.code(), ((APIError)object).message());
                    Connect3rdPartyRepository.this.liveAccountErrorResponse.postValue(object2);
                    object2 = TAG;
                    StringBuilder stringBuilder = new StringBuilder();
                    stringBuilder.append("getKomootToken error message: ");
                    stringBuilder.append(((APIError)object).message());
                    Log.d((String)object2, (String)stringBuilder.toString());
                }
            }
        });
    }

    public MutableLiveData<AccountErrorVo> getLiveAccountErrorResponse() {
        return this.liveAccountErrorResponse;
    }

    public void getReliveToken(String string2) {
        this.reliveApi.getToken(this.reliveBaseUrl, "application/x-www-form-urlencoded", "L2rqoyOeoJ", "authorization_code", string2, this.reliveRedirectUrl, "zrMDpMnsJCXcynNfw48B").enqueue((Callback)new Callback<ResponseBody>(){

            public void onFailure(Call<ResponseBody> object, Throwable throwable) {
                object = TAG;
                StringBuilder stringBuilder = new StringBuilder();
                stringBuilder.append("onFailure: ");
                stringBuilder.append(throwable.getMessage());
                Log.d(object, (String)stringBuilder.toString());
            }

            public void onResponse(Call<ResponseBody> object, Response<ResponseBody> object2) {
                if (object2.isSuccessful()) {
                    Object object3;
                    object2 = (ResponseBody)object2.body();
                    try {
                        object = object2.string();
                    }
                    catch (IOException iOException) {
                        iOException.printStackTrace();
                        object = null;
                    }
                    try {
                        object3 = new JSONObject((String)object);
                        Connect3rdPartyRepository.this.prepareReliveToken2Server((JSONObject)object3, null);
                    }
                    catch (JSONException jSONException) {
                        jSONException.printStackTrace();
                    }
                    object = TAG;
                    object3 = new StringBuilder();
                    ((StringBuilder)object3).append("onResponse: ");
                    ((StringBuilder)object3).append(object2.toString());
                    Log.d((String)object, (String)((StringBuilder)object3).toString());
                } else {
                    object = ErrorUtils.parseError(object2);
                    new AccountErrorVo(object2.code(), ((APIError)object).message());
                    object2 = TAG;
                    StringBuilder stringBuilder = new StringBuilder();
                    stringBuilder.append("getReliveToken error message: ");
                    stringBuilder.append(((APIError)object).message());
                    Log.d((String)object2, (String)stringBuilder.toString());
                }
            }
        });
    }

    public void getRideWithGpsPlanTrip(String string2, final Object object) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("https://ridewithgps.com/routes/");
        stringBuilder.append(string2);
        stringBuilder.append(".json");
        string2 = stringBuilder.toString();
        this.rideWithGpsApi.getPlanTrip(string2).enqueue((Callback)new Callback<ResponseBody>(){

            public void onFailure(Call<ResponseBody> object2, Throwable throwable) {
                String string2 = TAG;
                object2 = new StringBuilder();
                ((StringBuilder)object2).append("onFailure: ");
                ((StringBuilder)object2).append(throwable.getMessage());
                Log.d((String)string2, (String)((StringBuilder)object2).toString());
                Connect3rdPartyRepository.this.mRideWithGpsPlanTripListLiveData.postValue(null);
            }

            public void onResponse(Call<ResponseBody> object3, Response<ResponseBody> object2) {
                if (object2.isSuccessful()) {
                    object2 = (ResponseBody)object2.body();
                    try {
                        object3 = object2.string();
                    }
                    catch (IOException iOException) {
                        iOException.printStackTrace();
                        object3 = null;
                    }
                    object3 = Connect3rdPartyRepository.this.getRideWithGpsPlanTripDecode((String)object3, object);
                    if (object3 != null) {
                        Connect3rdPartyRepository.this.mRideWithGpsRouteLiveData.postValue(object3.toString());
                    } else {
                        Connect3rdPartyRepository.this.mRideWithGpsPlanTripListLiveData.postValue(null);
                    }
                    String string2 = TAG;
                    object3 = new StringBuilder();
                    ((StringBuilder)object3).append("onResponse: ");
                    ((StringBuilder)object3).append(object2.toString());
                    Log.d((String)string2, (String)((StringBuilder)object3).toString());
                } else {
                    object3 = ErrorUtils.parseError(object2);
                    new AccountErrorVo(object2.code(), ((APIError)object3).message());
                    object2 = TAG;
                    StringBuilder stringBuilder = new StringBuilder();
                    stringBuilder.append("getRideWithGpsPlanTrip error message: ");
                    stringBuilder.append(((APIError)object3).message());
                    Log.d((String)object2, (String)stringBuilder.toString());
                    Connect3rdPartyRepository.this.mRideWithGpsPlanTripListLiveData.postValue(null);
                }
            }
        });
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public JSONObject getRideWithGpsPlanTripDecode(String string2, Object object) {
        String string3 = "y";
        String string4 = "distance";
        JSONObject jSONObject = new JSONObject();
        JSONObject jSONObject2 = new JSONObject();
        Object object2 = new JSONArray();
        try {
            int n;
            JSONArray jSONArray;
            JSONObject jSONObject3 = new JSONObject(string2);
            jSONObject2.put("major", 0);
            jSONObject2.put("minor", 1);
            jSONObject.put("version", (Object)jSONObject2);
            if (jSONObject3.has("course_points")) {
                jSONArray = new JSONArray();
                jSONObject2 = jSONObject3.getJSONArray("course_points");
                string2 = string4;
                string4 = jSONObject2;
                for (n = 0; n < string4.length(); ++n) {
                    JSONArray jSONArray2 = new JSONArray();
                    jSONObject2 = string4.getJSONObject(n);
                    if (jSONObject2.has("i")) {
                        jSONArray2.put(jSONObject2.getInt("i"));
                    }
                    if (jSONObject2.has("t")) {
                        jSONArray2.put(ManeuverUtil.getManeuverIdxFromRideWithGps(jSONObject2.getString("t")));
                    }
                    if (jSONObject2.has("d")) {
                        jSONArray2.put(jSONObject2.getDouble("d"));
                    }
                    jSONArray2.put(0L);
                    if (jSONObject2.has("n")) {
                        jSONArray2.put((Object)jSONObject2.getString("n"));
                    }
                    jSONArray.put((Object)jSONArray2);
                }
                string4 = object2;
                jSONObject.put("steps", (Object)jSONArray);
                object2 = string2;
                string2 = string4;
            } else {
                string2 = object2;
                string3 = "y";
                object2 = "distance";
            }
            if (jSONObject3.has("track_points")) {
                string4 = jSONObject3.getJSONArray("track_points");
                for (n = 0; n < string4.length(); ++n) {
                    jSONArray = new JSONObject();
                    jSONObject2 = string4.getJSONObject(n);
                    if (jSONObject2.has("x")) {
                        jSONArray.put("position_long", (double)((float)jSONObject2.getDouble("x")));
                    }
                    if (jSONObject2.has(string3)) {
                        jSONArray.put("position_lat", (double)((float)jSONObject2.getDouble(string3)));
                    }
                    if (jSONObject2.has("e")) {
                        jSONArray.put("altitude", (double)((float)jSONObject2.getDouble("e")));
                    }
                    string2.put((Object)jSONArray);
                }
                jSONObject.put("points", (Object)string2);
            }
            if (jSONObject3.has((String)object2)) {
                jSONObject.put((String)object2, (double)((float)jSONObject3.getDouble((String)object2)));
            }
            if (jSONObject3.has("elevation_gain")) {
                jSONObject.put("gain", (double)((float)jSONObject3.getDouble("elevation_gain")));
            }
            if (jSONObject3.has("elevation_loss")) {
                jSONObject.put("loss", (double)((float)jSONObject3.getDouble("elevation_loss")));
            }
            if (jSONObject3.has("id")) {
                jSONObject.put("tmp_orgid", (Object)jSONObject3.getString("id"));
            }
            if (jSONObject3.has("name")) {
                jSONObject.put("tmp_r_name", (Object)jSONObject3.getString("name"));
            }
            jSONObject.put("tmp_r_provider", (Object)PlanTripUtil.PROVIDER_SYNC_FROM_RIDE_WITH_GPS);
            jSONObject.put("created_at", object);
            return jSONObject;
        }
        catch (JSONException jSONException) {
            Log.d((String)"Grad Debug", (String)"JSONArray() error.");
            jSONException.printStackTrace();
        }
        return jSONObject;
    }

    public void getRideWithGpsPlanTripList() {
        String string2 = (String)ProfileUtil.getInstance().get("rideWithGpsUserId");
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("https://ridewithgps.com/users/");
        stringBuilder.append(string2);
        stringBuilder.append("/routes.json");
        string2 = stringBuilder.toString();
        this.rideWithGpsApi.getPlanTripList(string2).enqueue((Callback)new Callback<ResponseBody>(){

            public void onFailure(Call<ResponseBody> object, Throwable throwable) {
                object = TAG;
                StringBuilder stringBuilder = new StringBuilder();
                stringBuilder.append("onFailure: ");
                stringBuilder.append(throwable.getMessage());
                Log.d(object, (String)stringBuilder.toString());
                Connect3rdPartyRepository.this.mRideWithGpsPlanTripListLiveData.postValue(null);
            }

            public void onResponse(Call<ResponseBody> object, Response<ResponseBody> object2) {
                if (object2.isSuccessful()) {
                    object2 = (ResponseBody)object2.body();
                    try {
                        object = object2.string();
                    }
                    catch (IOException iOException) {
                        iOException.printStackTrace();
                        object = null;
                    }
                    object = Connect3rdPartyRepository.this.getRideWithGpsPlanTripListDecode((String)object);
                    if (object != null) {
                        Connect3rdPartyRepository.this.mRideWithGpsPlanTripListLiveData.postValue(object.toString());
                    } else {
                        Connect3rdPartyRepository.this.mRideWithGpsPlanTripListLiveData.postValue(null);
                    }
                    String string2 = TAG;
                    object = new StringBuilder();
                    ((StringBuilder)object).append("onResponse: ");
                    ((StringBuilder)object).append(object2.toString());
                    Log.d((String)string2, (String)((StringBuilder)object).toString());
                } else {
                    object = ErrorUtils.parseError(object2);
                    object2 = new AccountErrorVo(object2.code(), ((APIError)object).message());
                    Connect3rdPartyRepository.this.liveAccountErrorResponse.postValue(object2);
                    String string3 = TAG;
                    object2 = new StringBuilder();
                    ((StringBuilder)object2).append("getRideWithGpsPlanTripList error message: ");
                    ((StringBuilder)object2).append(((APIError)object).message());
                    Log.d((String)string3, (String)((StringBuilder)object2).toString());
                    Connect3rdPartyRepository.this.mRideWithGpsPlanTripListLiveData.postValue(null);
                }
            }
        });
    }

    public MutableLiveData<String> getRideWithGpsPlanTripListLiveData() {
        return this.mRideWithGpsPlanTripListLiveData;
    }

    public MutableLiveData<String> getRideWithGpsRouteLiveData() {
        return this.mRideWithGpsRouteLiveData;
    }

    public void getRideWithGpsUserId(String string2, String string3) {
        this.rideWithGpsApi.getUserId(this.rideWithGpsApiBaseUrl, string2, string3, "1dec0b62", "2").enqueue((Callback)new Callback<ResponseBody>(){

            public void onFailure(Call<ResponseBody> object, Throwable throwable) {
                String string2 = TAG;
                object = new StringBuilder();
                ((StringBuilder)object).append("onFailure: ");
                ((StringBuilder)object).append(throwable.getMessage());
                Log.d((String)string2, (String)((StringBuilder)object).toString());
                Connect3rdPartyRepository.this.isGetRideWithGpsUserIdLiveData.postValue(false);
            }

            public void onResponse(Call<ResponseBody> object, Response<ResponseBody> object2) {
                if (object2.isSuccessful()) {
                    ResponseBody responseBody;
                    block8: {
                        responseBody = (ResponseBody)object2.body();
                        object = null;
                        try {
                            object2 = responseBody.string();
                            object = object2;
                        }
                        catch (IOException iOException) {
                            iOException.printStackTrace();
                        }
                        object2 = new JSONObject((String)object);
                        if (!object2.has("user") || (object = object2.getJSONObject("user")) == null) break block8;
                        try {
                            if (object.has("id") && !((String)(object = object.getString("id"))).isEmpty()) {
                                ProfileUtil.getInstance().set("rideWithGpsUserId", object);
                                Connect3rdPartyRepository.this.isGetRideWithGpsUserIdLiveData.postValue(true);
                            }
                        }
                        catch (JSONException jSONException) {
                            jSONException.printStackTrace();
                        }
                    }
                    object2 = TAG;
                    object = new StringBuilder();
                    ((StringBuilder)object).append("onResponse: ");
                    ((StringBuilder)object).append(responseBody.toString());
                    Log.d((String)object2, (String)((StringBuilder)object).toString());
                } else {
                    object = ErrorUtils.parseError(object2);
                    new AccountErrorVo(object2.code(), ((APIError)object).message());
                    object2 = TAG;
                    StringBuilder stringBuilder = new StringBuilder();
                    stringBuilder.append("getRideWithGpsUserId error message: ");
                    stringBuilder.append(((APIError)object).message());
                    Log.d((String)object2, (String)stringBuilder.toString());
                    Connect3rdPartyRepository.this.isGetRideWithGpsUserIdLiveData.postValue(false);
                }
            }
        });
    }

    public void getRouteyouToken(String string2) {
        this.routeyouApi.getToken(this.routeyouApiBaseUrl, "application/x-www-form-urlencoded", "4ys0malpfnkol0ep", "authorization_code", string2, this.routeyouRedirectUri, "nJgzdRqPl9m3KZOuhuJBeb3dBlwr_V93b_hzfgi0").enqueue((Callback)new Callback<ResponseBody>(){

            public void onFailure(Call<ResponseBody> object, Throwable throwable) {
                String string2 = TAG;
                object = new StringBuilder();
                ((StringBuilder)object).append("onFailure: ");
                ((StringBuilder)object).append(throwable.getMessage());
                Log.d((String)string2, (String)((StringBuilder)object).toString());
            }

            public void onResponse(Call<ResponseBody> object, Response<ResponseBody> object2) {
                if (object2.isSuccessful()) {
                    ResponseBody responseBody = (ResponseBody)object2.body();
                    object = null;
                    try {
                        object = object2 = responseBody.string();
                    }
                    catch (IOException iOException) {
                        iOException.printStackTrace();
                    }
                    try {
                        object2 = new JSONObject((String)object);
                        Connect3rdPartyRepository.this.prepareRouteyouToken2Server((JSONObject)object2);
                    }
                    catch (JSONException jSONException) {
                        jSONException.printStackTrace();
                    }
                    object = TAG;
                    object2 = new StringBuilder();
                    ((StringBuilder)object2).append("onResponse: ");
                    ((StringBuilder)object2).append(responseBody.toString());
                    Log.d((String)object, (String)((StringBuilder)object2).toString());
                } else {
                    object = ErrorUtils.parseError(object2);
                    new AccountErrorVo(object2.code(), ((APIError)object).message());
                    String string2 = TAG;
                    object2 = new StringBuilder();
                    ((StringBuilder)object2).append("getRouteyouToken error message: ");
                    ((StringBuilder)object2).append(((APIError)object).message());
                    Log.d((String)string2, (String)((StringBuilder)object2).toString());
                }
            }
        });
    }

    public void getSelfloopsToken(String string2) {
        String string3 = this.selfloopsApiBaseUrl;
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Basic ");
        CharSequence charSequence = new StringBuilder();
        charSequence.append("bc60072ad48f94e0f75ee3958bc22625d38bae4f86665ddce9af6c52e8dc09d1");
        charSequence.append(":");
        charSequence.append("d854440e3e901b33a184b9706b125ac520de3d72817eeb73fc74be119f2ded8c");
        stringBuilder.append(Base64Util.encodeString(charSequence.toString()));
        charSequence = stringBuilder.toString();
        this.selfloopsApi.getToken(string3, (String)charSequence, "application/x-www-form-urlencoded", "authorization_code", string2).enqueue((Callback)new Callback<ResponseBody>(){

            public void onFailure(Call<ResponseBody> object, Throwable throwable) {
                String string2 = TAG;
                object = new StringBuilder();
                ((StringBuilder)object).append("onFailure: ");
                ((StringBuilder)object).append(throwable.getMessage());
                Log.d((String)string2, (String)((StringBuilder)object).toString());
            }

            public void onResponse(Call<ResponseBody> object, Response<ResponseBody> object2) {
                if (object2.isSuccessful()) {
                    ResponseBody responseBody = (ResponseBody)object2.body();
                    object = null;
                    try {
                        object = object2 = responseBody.string();
                    }
                    catch (IOException iOException) {
                        iOException.printStackTrace();
                    }
                    try {
                        object2 = new JSONObject((String)object);
                        Connect3rdPartyRepository.this.prepareSelfloopsToken2Server((JSONObject)object2);
                    }
                    catch (JSONException jSONException) {
                        jSONException.printStackTrace();
                    }
                    object = TAG;
                    object2 = new StringBuilder();
                    ((StringBuilder)object2).append("onResponse: ");
                    ((StringBuilder)object2).append(responseBody.toString());
                    Log.d((String)object, (String)((StringBuilder)object2).toString());
                } else {
                    object = ErrorUtils.parseError(object2);
                    new AccountErrorVo(object2.code(), ((APIError)object).message());
                    String string2 = TAG;
                    object2 = new StringBuilder();
                    ((StringBuilder)object2).append("getSelfloopsToken error message: ");
                    ((StringBuilder)object2).append(((APIError)object).message());
                    Log.d((String)string2, (String)((StringBuilder)object2).toString());
                }
            }
        });
    }

    public void getStravaPlanTrip(String string2, final String string3, final String string4, final Object object) {
        CharSequence charSequence = new StringBuilder();
        charSequence.append("https://www.strava.com/api/v3/routes/");
        charSequence.append(string3);
        charSequence.append("/export_gpx");
        charSequence = charSequence.toString();
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Bearer ");
        stringBuilder.append(string2);
        string2 = stringBuilder.toString();
        this.stravaApi.getPlanTrip((String)charSequence, string2).enqueue((Callback)new Callback<ResponseBody>(){

            public void onFailure(Call<ResponseBody> object2, Throwable throwable) {
                object2 = TAG;
                StringBuilder stringBuilder = new StringBuilder();
                stringBuilder.append("onFailure: ");
                stringBuilder.append(throwable.getMessage());
                Log.d(object2, (String)stringBuilder.toString());
                Connect3rdPartyRepository.this.mStravaRouteLiveData.postValue(null);
            }

            public void onResponse(Call<ResponseBody> object4, Response<ResponseBody> object2) {
                if (object2.isSuccessful()) {
                    object2 = (ResponseBody)object2.body();
                    try {
                        object4 = object2.string();
                    }
                    catch (IOException iOException) {
                        iOException.printStackTrace();
                        object4 = null;
                    }
                    Object object3 = Connect3rdPartyRepository.this.gpxContextParser((String)object4);
                    if (object3 != null) {
                        try {
                            object3.put("tmp_orgid", (Object)string3);
                            object3.put("tmp_r_name", (Object)string4);
                            object3.put("tmp_r_provider", (Object)PlanTripUtil.PROVIDER_SYNC_FROM_STRAVA);
                            object3.put("updated_at", object);
                        }
                        catch (JSONException jSONException) {
                            jSONException.printStackTrace();
                        }
                        Connect3rdPartyRepository.this.mStravaRouteLiveData.postValue(object3.toString());
                    } else {
                        Connect3rdPartyRepository.this.mStravaRouteLiveData.postValue(null);
                    }
                    object3 = TAG;
                    object4 = new StringBuilder();
                    ((StringBuilder)object4).append("onResponse: ");
                    ((StringBuilder)object4).append(object2.toString());
                    Log.d((String)object3, (String)((StringBuilder)object4).toString());
                } else {
                    object4 = ErrorUtils.parseError(object2);
                    object2 = new AccountErrorVo(object2.code(), ((APIError)object4).message());
                    Connect3rdPartyRepository.this.liveAccountErrorResponse.postValue(object2);
                    object2 = TAG;
                    StringBuilder stringBuilder = new StringBuilder();
                    stringBuilder.append("getStravaPlanTrip error message: ");
                    stringBuilder.append(((APIError)object4).message());
                    Log.d((String)object2, (String)stringBuilder.toString());
                    Connect3rdPartyRepository.this.mStravaRouteLiveData.postValue(null);
                }
            }
        });
    }

    public void getStravaPlanTripList(String string2, String string3) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("https://www.strava.com/api/v3/athletes/");
        stringBuilder.append(string3);
        stringBuilder.append("/routes");
        string3 = stringBuilder.toString();
        stringBuilder = new StringBuilder();
        stringBuilder.append("Bearer ");
        stringBuilder.append(string2);
        string2 = stringBuilder.toString();
        this.stravaApi.getPlanTripList(string3, string2).enqueue((Callback)new Callback<ResponseBody>(){

            public void onFailure(Call<ResponseBody> object, Throwable throwable) {
                String string2 = TAG;
                object = new StringBuilder();
                ((StringBuilder)object).append("onFailure: ");
                ((StringBuilder)object).append(throwable.getMessage());
                Log.d((String)string2, (String)((StringBuilder)object).toString());
                Connect3rdPartyRepository.this.mStravaPlanTripListLiveData.postValue(null);
            }

            public void onResponse(Call<ResponseBody> object, Response<ResponseBody> object2) {
                if (object2.isSuccessful()) {
                    object2 = (ResponseBody)object2.body();
                    try {
                        object = object2.string();
                    }
                    catch (IOException iOException) {
                        iOException.printStackTrace();
                        object = null;
                    }
                    object = Connect3rdPartyRepository.this.getStravaPlanTripListDecode((String)object);
                    if (object != null) {
                        Connect3rdPartyRepository.this.mStravaPlanTripListLiveData.postValue(object.toString());
                    } else {
                        Connect3rdPartyRepository.this.mStravaPlanTripListLiveData.postValue(null);
                    }
                    String string2 = TAG;
                    object = new StringBuilder();
                    ((StringBuilder)object).append("onResponse: ");
                    ((StringBuilder)object).append(object2.toString());
                    Log.d((String)string2, (String)((StringBuilder)object).toString());
                } else {
                    Object object3 = ErrorUtils.parseError(object2);
                    object = new AccountErrorVo(object2.code(), ((APIError)object3).message());
                    Connect3rdPartyRepository.this.liveAccountErrorResponse.postValue(object);
                    object2 = TAG;
                    StringBuilder stringBuilder = new StringBuilder();
                    stringBuilder.append("getStravaPlanTripList error message: ");
                    stringBuilder.append(((APIError)object3).message());
                    Log.d((String)object2, (String)stringBuilder.toString());
                    object3 = Connect3rdPartyRepository.this.mStravaPlanTripListLiveData;
                    object2 = new StringBuilder();
                    ((StringBuilder)object2).append("");
                    ((StringBuilder)object2).append(((AccountErrorVo)object).getCode());
                    ((MutableLiveData)object3).postValue(((StringBuilder)object2).toString());
                }
            }
        });
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public JSONObject getStravaPlanTripListDecode(String string2) {
        JSONObject jSONObject = new JSONObject();
        JSONArray jSONArray = new JSONArray();
        try {
            JSONArray jSONArray2 = new JSONArray(string2);
            int n = jSONArray2.length();
            if (n > 0) {
                for (int i = 0; i < n; ++i) {
                    if (i == 0) {
                        jSONObject.put("code", 200);
                        jSONObject.put("errorMessage", null);
                    }
                    JSONObject jSONObject2 = jSONArray2.getJSONObject(i);
                    string2 = new JSONObject();
                    if (jSONObject2.has("id")) {
                        string2.put("id", (Object)jSONObject2.getString("id"));
                    }
                    if (jSONObject2.has("name")) {
                        string2.put("name", (Object)jSONObject2.getString("name"));
                        string2.put("provider", (Object)SERVER_SERVICE_NAME_STRAVA);
                    }
                    if (jSONObject2.has("updated_at")) {
                        string2.put("updated_at", jSONObject2.get("updated_at"));
                    }
                    jSONArray.put((Object)string2);
                }
                jSONObject.put("data", (Object)jSONArray);
                return jSONObject;
            }
            jSONObject.put("code", 400);
            jSONObject.put("errorMessage", (Object)"error msg");
            jSONObject.put("data", null);
            return jSONObject;
        }
        catch (JSONException jSONException) {
            Log.d((String)"Grad Debug", (String)"JSONArray() error.");
            jSONException.printStackTrace();
        }
        return jSONObject;
    }

    public MutableLiveData<String> getStravaPlanTripListLiveData() {
        return this.mStravaPlanTripListLiveData;
    }

    public MutableLiveData<String> getStravaRouteLiveData() {
        return this.mStravaRouteLiveData;
    }

    public void getStravaToken(String string2) {
        string2 = String.format(this.stravaBaseUrl, "10260", "b4df54eef61a6f1d32ec194d2d1f8b143fb581df", string2);
        this.stravaApi.getToken(string2).enqueue((Callback)new Callback<ResponseBody>(){

            public void onFailure(Call<ResponseBody> object, Throwable throwable) {
                String string2 = TAG;
                object = new StringBuilder();
                ((StringBuilder)object).append("onFailure: ");
                ((StringBuilder)object).append(throwable.getMessage());
                Log.d((String)string2, (String)((StringBuilder)object).toString());
            }

            public void onResponse(Call<ResponseBody> object, Response<ResponseBody> object2) {
                if (object2.isSuccessful()) {
                    ResponseBody responseBody = (ResponseBody)object2.body();
                    object = null;
                    try {
                        object = object2 = responseBody.string();
                    }
                    catch (IOException iOException) {
                        iOException.printStackTrace();
                    }
                    try {
                        object2 = new JSONObject((String)object);
                        Connect3rdPartyRepository.this.prepareStravaToken2Server((JSONObject)object2);
                    }
                    catch (JSONException jSONException) {
                        jSONException.printStackTrace();
                    }
                    object2 = TAG;
                    object = new StringBuilder();
                    ((StringBuilder)object).append("onResponse: ");
                    ((StringBuilder)object).append(responseBody.toString());
                    Log.d((String)object2, (String)((StringBuilder)object).toString());
                } else {
                    object = ErrorUtils.parseError(object2);
                    object2 = new AccountErrorVo(object2.code(), ((APIError)object).message());
                    Connect3rdPartyRepository.this.liveAccountErrorResponse.postValue(object2);
                    String string2 = TAG;
                    object2 = new StringBuilder();
                    ((StringBuilder)object2).append("getStravaToken error message: ");
                    ((StringBuilder)object2).append(((APIError)object).message());
                    Log.d((String)string2, (String)((StringBuilder)object2).toString());
                }
            }
        });
    }

    public void getTodaysplanToken(String string2) {
        this.todaysplanApi.getToken(this.todaysplanApiBaseUrl, "application/x-www-form-urlencoded", "BrytonActive", "authorization_code", string2, this.reliveRedirectUrl, "3A77RzQDezP3cHntzn3zUy8uqy9yQvWA").enqueue((Callback)new Callback<ResponseBody>(){

            public void onFailure(Call<ResponseBody> object, Throwable throwable) {
                String string2 = TAG;
                object = new StringBuilder();
                ((StringBuilder)object).append("onFailure: ");
                ((StringBuilder)object).append(throwable.getMessage());
                Log.d((String)string2, (String)((StringBuilder)object).toString());
            }

            public void onResponse(Call<ResponseBody> object, Response<ResponseBody> object2) {
                if (object2.isSuccessful()) {
                    ResponseBody responseBody = (ResponseBody)object2.body();
                    object = null;
                    try {
                        object = object2 = responseBody.string();
                    }
                    catch (IOException iOException) {
                        iOException.printStackTrace();
                    }
                    try {
                        object2 = new JSONObject((String)object);
                        Connect3rdPartyRepository.this.prepareTodaysplanToken2Server((JSONObject)object2);
                    }
                    catch (JSONException jSONException) {
                        jSONException.printStackTrace();
                    }
                    object = TAG;
                    object2 = new StringBuilder();
                    ((StringBuilder)object2).append("onResponse: ");
                    ((StringBuilder)object2).append(responseBody.toString());
                    Log.d((String)object, (String)((StringBuilder)object2).toString());
                } else {
                    object = ErrorUtils.parseError(object2);
                    new AccountErrorVo(object2.code(), ((APIError)object).message());
                    String string2 = TAG;
                    object2 = new StringBuilder();
                    ((StringBuilder)object2).append("getTodaysplanToken error message: ");
                    ((StringBuilder)object2).append(((APIError)object).message());
                    Log.d((String)string2, (String)((StringBuilder)object2).toString());
                }
            }
        });
    }

    public MutableLiveData<Token2ServerResult> getToken2ServerLiveData() {
        return this.mToken2ServerLiveData;
    }

    public MutableLiveData<ArrayList<TrainingPlan>> getTrainingPeaksLiveData() {
        return this.mTrainingPeaksWorkoutListLiveData;
    }

    public MutableLiveData<Boolean> getTrainingPeaksNeedRefreshToken() {
        return this.mTrainingPeaksNeedRefreshToken;
    }

    public void getTrainingPeaksToken(String string2) {
        this.trainingPeaksApi.getToken(this.trainingPeaksBaseUrl, "application/x-www-form-urlencoded", "bryton", "authorization_code", string2, this.redirectUri, "qtXfT2ngWLMI8hvB5MLYlxSD7dAPWQTUMOp12pfP4").enqueue((Callback)new Callback<ResponseBody>(){

            public void onFailure(Call<ResponseBody> object, Throwable throwable) {
                object = TAG;
                StringBuilder stringBuilder = new StringBuilder();
                stringBuilder.append("onFailure: ");
                stringBuilder.append(throwable.getMessage());
                Log.d(object, (String)stringBuilder.toString());
            }

            public void onResponse(Call<ResponseBody> object, Response<ResponseBody> object2) {
                if (object2.isSuccessful()) {
                    ResponseBody responseBody = (ResponseBody)object2.body();
                    object = null;
                    try {
                        object2 = responseBody.string();
                        object = object2;
                    }
                    catch (IOException iOException) {
                        iOException.printStackTrace();
                    }
                    try {
                        object2 = new JSONObject((String)object);
                        Connect3rdPartyRepository.this.prepareTrainingPeaksToken2Server(object2);
                    }
                    catch (JSONException jSONException) {
                        jSONException.printStackTrace();
                    }
                    object2 = TAG;
                    object = new StringBuilder();
                    ((StringBuilder)object).append("onResponse: ");
                    ((StringBuilder)object).append(responseBody.toString());
                    Log.d((String)object2, (String)((StringBuilder)object).toString());
                } else {
                    object = ErrorUtils.parseError(object2);
                    new AccountErrorVo(object2.code(), ((APIError)object).message());
                    object2 = TAG;
                    StringBuilder stringBuilder = new StringBuilder();
                    stringBuilder.append("getTrainingPeaksToken error message: ");
                    stringBuilder.append(((APIError)object).message());
                    Log.d((String)object2, (String)stringBuilder.toString());
                }
            }
        });
    }

    public void getTrainingPeaksWorkoutFit(String string2, final String string3, final Connect3rdPartyRepositoryHandler connect3rdPartyRepositoryHandler) {
        final String string4 = ProfileUtil.getInstance().getPrefString("userId");
        CharSequence charSequence = new StringBuilder();
        charSequence.append("https://api.trainingpeaks.com/v2/workouts/wod/file/");
        charSequence.append(string3);
        charSequence.append("/?format=fit");
        charSequence = charSequence.toString();
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Bearer ");
        stringBuilder.append(string2);
        string2 = stringBuilder.toString();
        this.trainingPeaksApi.getWorkout((String)charSequence, string2).enqueue((Callback)new Callback<ResponseBody>(){

            public void onFailure(Call<ResponseBody> object, Throwable throwable) {
                String string2 = TAG;
                object = new StringBuilder();
                ((StringBuilder)object).append("onFailure: ");
                ((StringBuilder)object).append(throwable.getMessage());
                Log.d((String)string2, (String)((StringBuilder)object).toString());
                connect3rdPartyRepositoryHandler.onFail();
            }

            public void onResponse(Call<ResponseBody> responseBody, Response<ResponseBody> object) {
                if (object.isSuccessful()) {
                    responseBody = (ResponseBody)object.body();
                    Object object2 = App.getInstance();
                    object = (ResponseBody)object.body();
                    CharSequence charSequence = new StringBuilder();
                    charSequence.append(string4);
                    charSequence.append("/workout_tp");
                    charSequence = charSequence.toString();
                    StringBuilder stringBuilder = new StringBuilder();
                    stringBuilder.append(string3);
                    stringBuilder.append(".fit");
                    if (ActivityFileUtil.writeResponseBodyToDisk((Context)object2, (ResponseBody)object, (String)charSequence, stringBuilder.toString())) {
                        Log.d((String)TAG, (String)"TP workout fit save ok");
                        object = new StringBuilder();
                        ((StringBuilder)object).append(string4);
                        ((StringBuilder)object).append("/workout_tp");
                        if (BrytonWorkout.decodeFitToJson(((StringBuilder)object).toString(), string3) != null) {
                            connect3rdPartyRepositoryHandler.onComplete();
                        } else {
                            connect3rdPartyRepositoryHandler.onFail();
                        }
                    } else {
                        Log.d((String)TAG, (String)"TP workout fit save failed");
                        connect3rdPartyRepositoryHandler.onFail();
                    }
                    object = TAG;
                    object2 = new StringBuilder();
                    ((StringBuilder)object2).append("onResponse: ");
                    ((StringBuilder)object2).append(responseBody.toString());
                    Log.d((String)object, (String)((StringBuilder)object2).toString());
                } else {
                    responseBody = ErrorUtils.parseError(object);
                    new AccountErrorVo(object.code(), responseBody.message());
                    object = TAG;
                    StringBuilder stringBuilder = new StringBuilder();
                    stringBuilder.append("getTrainingPeaksWorkoutFit error message: ");
                    stringBuilder.append(responseBody.message());
                    Log.d((String)object, (String)stringBuilder.toString());
                    connect3rdPartyRepositoryHandler.onFail();
                }
            }
        });
    }

    public void getTrainingPeaksWorkoutList(String string2, String string3) {
        Log.d((String)TAG, (String)"step 4 getTrainingPeaksWorkoutList: ");
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("https://api.trainingpeaks.com/v2/workouts/wod/");
        stringBuilder.append(string3);
        stringBuilder.append("?numberOfDays=7");
        string3 = stringBuilder.toString();
        stringBuilder = new StringBuilder();
        stringBuilder.append("Bearer ");
        stringBuilder.append(string2);
        string2 = stringBuilder.toString();
        this.trainingPeaksApi.getWorkoutList(string3, string2).enqueue((Callback)new Callback<ResponseBody>(){

            public void onFailure(Call<ResponseBody> object, Throwable throwable) {
                String string2 = TAG;
                object = new StringBuilder();
                ((StringBuilder)object).append("onFailure: ");
                ((StringBuilder)object).append(throwable.getMessage());
                Log.d((String)string2, (String)((StringBuilder)object).toString());
                Connect3rdPartyRepository.this.mTrainingPeaksWorkoutListLiveData.postValue(new ArrayList());
            }

            public void onResponse(Call<ResponseBody> object, Response<ResponseBody> object2) {
                boolean bl = object2.isSuccessful();
                Boolean bl2 = true;
                if (bl) {
                    ResponseBody responseBody = (ResponseBody)object2.body();
                    object = null;
                    try {
                        object = object2 = responseBody.string();
                    }
                    catch (IOException iOException) {
                        iOException.printStackTrace();
                    }
                    object2 = new JSONArray(object);
                    ArrayList<TrainingPlan> arrayList = TAG;
                    object = new StringBuilder();
                    ((StringBuilder)object).append("step 5 onResponse resultArray: ");
                    ((StringBuilder)object).append(object2.toString());
                    Log.d((String)((Object)arrayList), (String)((StringBuilder)object).toString());
                    arrayList = new ArrayList<TrainingPlan>();
                    int n = 0;
                    while (true) {
                        if (n >= object2.length()) break;
                        object = object2.getJSONObject(n);
                        if (!Boolean.valueOf(object.getBoolean("Completed")).booleanValue()) {
                            TrainingPlan trainingPlan = TrainingPlan.createWithTrainingPeaksJson((JSONObject)object);
                            JSONArray jSONArray = object.getJSONArray("WorkoutFileFormats");
                            object = 0;
                            while ((Integer)object < jSONArray.length()) {
                                if (jSONArray.getString(((Integer)object).intValue()).equals("zwo")) {
                                    trainingPlan.hasZwo = bl2;
                                    break;
                                }
                                object = (Integer)object + 1;
                            }
                            arrayList.add(trainingPlan);
                        }
                        ++n;
                        continue;
                        break;
                    }
                    try {
                        Connect3rdPartyRepository.this.mTrainingPeaksWorkoutListLiveData.postValue(arrayList);
                    }
                    catch (JSONException jSONException) {
                        jSONException.printStackTrace();
                    }
                    object = TAG;
                    object2 = new StringBuilder();
                    ((StringBuilder)object2).append("onResponse authResponse: ");
                    ((StringBuilder)object2).append(responseBody.toString());
                    Log.d((String)object, (String)((StringBuilder)object2).toString());
                } else if (object2.code() == 401) {
                    Connect3rdPartyRepository.this.mTrainingPeaksNeedRefreshToken.postValue(bl2);
                } else {
                    Connect3rdPartyRepository.this.mTrainingPeaksWorkoutListLiveData.postValue(new ArrayList());
                }
            }
        });
    }

    public void getTrainingPeaksWorkoutZwo(String string2, final String string3, final Connect3rdPartyRepositoryHandler connect3rdPartyRepositoryHandler) {
        final String string4 = ProfileUtil.getInstance().getPrefString("userId");
        CharSequence charSequence = new StringBuilder();
        charSequence.append("https://api.trainingpeaks.com/v2/workouts/wod/file/");
        charSequence.append(string3);
        charSequence.append("/?format=zwo");
        charSequence = charSequence.toString();
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Bearer ");
        stringBuilder.append(string2);
        string2 = stringBuilder.toString();
        this.trainingPeaksApi.getWorkout((String)charSequence, string2).enqueue((Callback)new Callback<ResponseBody>(){

            public void onFailure(Call<ResponseBody> object, Throwable throwable) {
                object = TAG;
                StringBuilder stringBuilder = new StringBuilder();
                stringBuilder.append("onFailure: ");
                stringBuilder.append(throwable.getMessage());
                Log.d(object, (String)stringBuilder.toString());
                connect3rdPartyRepositoryHandler.onFail();
            }

            public void onResponse(Call<ResponseBody> responseBody, Response<ResponseBody> object) {
                if (object.isSuccessful()) {
                    responseBody = (ResponseBody)object.body();
                    Object object2 = App.getInstance();
                    object = (ResponseBody)object.body();
                    CharSequence charSequence = new StringBuilder();
                    charSequence.append(string4);
                    charSequence.append("/workout_tp");
                    charSequence = charSequence.toString();
                    StringBuilder stringBuilder = new StringBuilder();
                    stringBuilder.append(string3);
                    stringBuilder.append(".zwo");
                    if (ActivityFileUtil.writeResponseBodyToDisk((Context)object2, (ResponseBody)object, (String)charSequence, stringBuilder.toString())) {
                        Log.d((String)TAG, (String)"TP workout zwo save ok");
                        connect3rdPartyRepositoryHandler.onComplete();
                    } else {
                        Log.d((String)TAG, (String)"TP workout zwo save failed");
                        connect3rdPartyRepositoryHandler.onFail();
                    }
                    object = TAG;
                    object2 = new StringBuilder();
                    ((StringBuilder)object2).append("onResponse: ");
                    ((StringBuilder)object2).append(responseBody.toString());
                    Log.d((String)object, (String)((StringBuilder)object2).toString());
                } else {
                    responseBody = ErrorUtils.parseError(object);
                    new AccountErrorVo(object.code(), responseBody.message());
                    String string2 = TAG;
                    object = new StringBuilder();
                    ((StringBuilder)object).append("getTrainingPeaksWorkoutZwo error message: ");
                    ((StringBuilder)object).append(responseBody.message());
                    Log.d((String)string2, (String)((StringBuilder)object).toString());
                    connect3rdPartyRepositoryHandler.onFail();
                }
            }
        });
    }

    public MutableLiveData<Boolean> getUpdateService2ServerSuccessLiveData() {
        return this._isUpdateService2ServerSuccessLiveData;
    }

    public MutableLiveData<String> getUpload2ReliveLiveData() {
        return this.mUpload2ReliveLiveData;
    }

    public MutableLiveData<String> getUpload2SelfloopsLiveData() {
        return this.mUpload2SelfloopsLiveData;
    }

    public MutableLiveData<String> getUpload2StravaLiveData() {
        return this.mUpload2StravaLiveData;
    }

    public MutableLiveData<String> getUpload2TodaysplanLiveData() {
        return this.mUpload2TodaysplanLiveData;
    }

    public MutableLiveData<String> getUpload2TrainingPeaksLiveData() {
        return this.mUpload2TrainingPeaksLiveData;
    }

    public /* synthetic */ void lambda$loadUserInfoGetStravaProfile$0$com-brytonsport-active-repo-profile-Connect3rdPartyRepository(String object, JSONObject jSONObject) {
        if ((object = this.userInfoDao.loadAccountUserInfoByUserId((String)object)) != null && ((AccountUserInfo)object).getServices() != null && (object = ((AccountUserInfo)object).getServices().getStrava()) != null) {
            try {
                if (((Strava)object).getId() != null) {
                    jSONObject.put("id", (Object)((Strava)object).getId());
                }
                if (((Strava)object).getFirstname() != null) {
                    jSONObject.put("firstname", (Object)((Strava)object).getFirstname());
                }
                if (((Strava)object).getLastname() != null) {
                    jSONObject.put("lastname", (Object)((Strava)object).getLastname());
                }
                if (((Strava)object).getSex() != null) {
                    jSONObject.put("sex", (Object)((Strava)object).getSex());
                }
            }
            catch (JSONException jSONException) {
                jSONException.printStackTrace();
            }
            this.updateServiceOAuth2Server(SERVER_SERVICE_NAME_STRAVA, jSONObject);
        }
    }

    public void refreshKomootToken(String string2) {
        string2 = String.format("https://auth-api.main.komoot.net/oauth/token?refresh_token=%s&grant_type=refresh_token", string2);
        CharSequence charSequence = new StringBuilder();
        charSequence.append("Basic ");
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("bryton-vg3tsv");
        stringBuilder.append(":");
        stringBuilder.append("rah7jae5aph2piephaigo0joh");
        charSequence.append(Base64Util.encodeString(stringBuilder.toString()));
        charSequence = charSequence.toString();
        this.komootApi.refreshToken(string2, "application/json", (String)charSequence).enqueue((Callback)new Callback<ResponseBody>(){

            public void onFailure(Call<ResponseBody> object, Throwable throwable) {
                object = TAG;
                StringBuilder stringBuilder = new StringBuilder();
                stringBuilder.append("onFailure: ");
                stringBuilder.append(throwable.getMessage());
                Log.d(object, (String)stringBuilder.toString());
                Connect3rdPartyRepository.this.mToken2ServerLiveData.postValue(new Token2ServerResult(Connect3rdPartyRepository.SERVER_SERVICE_NAME_KOMOOT, false));
            }

            public void onResponse(Call<ResponseBody> object, Response<ResponseBody> object2) {
                if (object2.isSuccessful()) {
                    ResponseBody responseBody = (ResponseBody)object2.body();
                    object = null;
                    try {
                        object = object2 = responseBody.string();
                    }
                    catch (IOException iOException) {
                        iOException.printStackTrace();
                    }
                    try {
                        object2 = new JSONObject((String)object);
                        Connect3rdPartyRepository.this.prepareKomootToken2Server((JSONObject)object2);
                    }
                    catch (JSONException jSONException) {
                        jSONException.printStackTrace();
                        Connect3rdPartyRepository.this.mToken2ServerLiveData.postValue(new Token2ServerResult(Connect3rdPartyRepository.SERVER_SERVICE_NAME_KOMOOT, false));
                    }
                    object2 = TAG;
                    object = new StringBuilder();
                    ((StringBuilder)object).append("onResponse: ");
                    ((StringBuilder)object).append(responseBody.toString());
                    Log.d((String)object2, (String)((StringBuilder)object).toString());
                } else {
                    object = ErrorUtils.parseError(object2);
                    new AccountErrorVo(object2.code(), ((APIError)object).message());
                    String string2 = TAG;
                    object2 = new StringBuilder();
                    ((StringBuilder)object2).append("refreshKomootToken error message: ");
                    ((StringBuilder)object2).append(((APIError)object).message());
                    Log.d((String)string2, (String)((StringBuilder)object2).toString());
                    Connect3rdPartyRepository.this.mToken2ServerLiveData.postValue(new Token2ServerResult(Connect3rdPartyRepository.SERVER_SERVICE_NAME_KOMOOT, false));
                }
            }
        });
    }

    public void refreshReliveToken(final String string2) {
        this.reliveApi.refreshToken(this.reliveBaseUrl, "application/x-www-form-urlencoded", "L2rqoyOeoJ", "refresh_token", "zrMDpMnsJCXcynNfw48B", string2).enqueue((Callback)new Callback<ResponseBody>(){

            public void onFailure(Call<ResponseBody> object, Throwable throwable) {
                String string22 = TAG;
                object = new StringBuilder();
                ((StringBuilder)object).append("onFailure: ");
                ((StringBuilder)object).append(throwable.getMessage());
                Log.d((String)string22, (String)((StringBuilder)object).toString());
                Connect3rdPartyRepository.this.mToken2ServerLiveData.postValue(new Token2ServerResult(Connect3rdPartyRepository.SERVER_SERVICE_NAME_RELIVE, false));
            }

            public void onResponse(Call<ResponseBody> object, Response<ResponseBody> object2) {
                if (object2.isSuccessful()) {
                    ResponseBody responseBody = (ResponseBody)object2.body();
                    object = null;
                    try {
                        object2 = responseBody.string();
                        object = object2;
                    }
                    catch (IOException iOException) {
                        iOException.printStackTrace();
                    }
                    try {
                        object2 = new JSONObject((String)object);
                        Connect3rdPartyRepository.this.prepareReliveToken2Server(object2, string2);
                    }
                    catch (JSONException jSONException) {
                        jSONException.printStackTrace();
                        Connect3rdPartyRepository.this.mToken2ServerLiveData.postValue(new Token2ServerResult(Connect3rdPartyRepository.SERVER_SERVICE_NAME_RELIVE, false));
                    }
                    object2 = TAG;
                    object = new StringBuilder();
                    ((StringBuilder)object).append("onResponse: ");
                    ((StringBuilder)object).append(responseBody.toString());
                    Log.d((String)object2, (String)((StringBuilder)object).toString());
                } else {
                    object = ErrorUtils.parseError(object2);
                    new AccountErrorVo(object2.code(), ((APIError)object).message());
                    object2 = TAG;
                    StringBuilder stringBuilder = new StringBuilder();
                    stringBuilder.append("refreshReliveToken error message: ");
                    stringBuilder.append(((APIError)object).message());
                    Log.d((String)object2, (String)stringBuilder.toString());
                    Connect3rdPartyRepository.this.mToken2ServerLiveData.postValue(new Token2ServerResult(Connect3rdPartyRepository.SERVER_SERVICE_NAME_RELIVE, false));
                }
            }
        });
    }

    public void refreshRouteyouToken(String string2) {
        this.routeyouApi.refreshToken(this.routeyouApiBaseUrl, "application/x-www-form-urlencoded", "4ys0malpfnkol0ep", "refresh_token", string2, "nJgzdRqPl9m3KZOuhuJBeb3dBlwr_V93b_hzfgi0").enqueue((Callback)new Callback<ResponseBody>(){

            public void onFailure(Call<ResponseBody> object, Throwable throwable) {
                object = TAG;
                StringBuilder stringBuilder = new StringBuilder();
                stringBuilder.append("onFailure: ");
                stringBuilder.append(throwable.getMessage());
                Log.d(object, (String)stringBuilder.toString());
            }

            public void onResponse(Call<ResponseBody> object, Response<ResponseBody> object2) {
                if (object2.isSuccessful()) {
                    ResponseBody responseBody = (ResponseBody)object2.body();
                    object = null;
                    try {
                        object = object2 = responseBody.string();
                    }
                    catch (IOException iOException) {
                        iOException.printStackTrace();
                    }
                    try {
                        object2 = new JSONObject((String)object);
                        Connect3rdPartyRepository.this.prepareRouteyouToken2Server((JSONObject)object2);
                    }
                    catch (JSONException jSONException) {
                        jSONException.printStackTrace();
                    }
                    object2 = TAG;
                    object = new StringBuilder();
                    ((StringBuilder)object).append("onResponse: ");
                    ((StringBuilder)object).append(responseBody.toString());
                    Log.d((String)object2, (String)((StringBuilder)object).toString());
                } else {
                    object = ErrorUtils.parseError(object2);
                    new AccountErrorVo(object2.code(), ((APIError)object).message());
                    String string2 = TAG;
                    object2 = new StringBuilder();
                    ((StringBuilder)object2).append("refreshRouteyouToken error message: ");
                    ((StringBuilder)object2).append(((APIError)object).message());
                    Log.d((String)string2, (String)((StringBuilder)object2).toString());
                }
            }
        });
    }

    public void refreshSelfloopsToken(String string2) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Basic ");
        CharSequence charSequence = new StringBuilder();
        charSequence.append("bc60072ad48f94e0f75ee3958bc22625d38bae4f86665ddce9af6c52e8dc09d1");
        charSequence.append(":");
        charSequence.append("d854440e3e901b33a184b9706b125ac520de3d72817eeb73fc74be119f2ded8c");
        stringBuilder.append(Base64Util.encodeString(charSequence.toString()));
        charSequence = stringBuilder.toString();
        this.selfloopsApi.refreshToken(this.selfloopsApiBaseUrl, (String)charSequence, "application/x-www-form-urlencoded", "refresh_token", string2).enqueue((Callback)new Callback<ResponseBody>(){

            public void onFailure(Call<ResponseBody> object, Throwable throwable) {
                String string2 = TAG;
                object = new StringBuilder();
                ((StringBuilder)object).append("onFailure: ");
                ((StringBuilder)object).append(throwable.getMessage());
                Log.d((String)string2, (String)((StringBuilder)object).toString());
                Connect3rdPartyRepository.this.mToken2ServerLiveData.postValue(new Token2ServerResult(Connect3rdPartyRepository.SERVER_SERVICE_NAME_SELFLOOPS, false));
            }

            public void onResponse(Call<ResponseBody> object, Response<ResponseBody> object2) {
                boolean bl = object2.isSuccessful();
                Object object3 = null;
                object = null;
                if (bl) {
                    object3 = (ResponseBody)object2.body();
                    try {
                        object = object2 = object3.string();
                    }
                    catch (IOException iOException) {
                        iOException.printStackTrace();
                    }
                    try {
                        object2 = new JSONObject((String)object);
                        Connect3rdPartyRepository.this.prepareSelfloopsToken2Server((JSONObject)object2);
                    }
                    catch (JSONException jSONException) {
                        jSONException.printStackTrace();
                        Connect3rdPartyRepository.this.mToken2ServerLiveData.postValue(new Token2ServerResult(Connect3rdPartyRepository.SERVER_SERVICE_NAME_SELFLOOPS, false));
                    }
                    object = TAG;
                    object2 = new StringBuilder();
                    ((StringBuilder)object2).append("onResponse: ");
                    ((StringBuilder)object2).append(object3.toString());
                    Log.d((String)object, (String)((StringBuilder)object2).toString());
                } else {
                    object = object2.errorBody();
                    try {
                        object = object.string();
                    }
                    catch (IOException iOException) {
                        iOException.printStackTrace();
                        object = object3;
                    }
                    try {
                        new JSONObject((String)object);
                    }
                    catch (JSONException jSONException) {
                        jSONException.printStackTrace();
                    }
                    object = ErrorUtils.parseError(object2);
                    new AccountErrorVo(object2.code(), ((APIError)object).message());
                    object3 = TAG;
                    object2 = new StringBuilder();
                    ((StringBuilder)object2).append("refreshSelfloopsToken error message: ");
                    ((StringBuilder)object2).append(((APIError)object).message());
                    Log.d((String)object3, (String)((StringBuilder)object2).toString());
                    Connect3rdPartyRepository.this.mToken2ServerLiveData.postValue(new Token2ServerResult(Connect3rdPartyRepository.SERVER_SERVICE_NAME_SELFLOOPS, false));
                }
            }
        });
    }

    public void refreshStravaToken(String string2) {
        string2 = String.format("https://www.strava.com/oauth/token?client_id=%s&client_secret=%s&grant_type=refresh_token&refresh_token=%s", "10260", "b4df54eef61a6f1d32ec194d2d1f8b143fb581df", string2);
        this.stravaApi.refreshToken(string2).enqueue((Callback)new Callback<ResponseBody>(){

            public void onFailure(Call<ResponseBody> object, Throwable throwable) {
                object = TAG;
                StringBuilder stringBuilder = new StringBuilder();
                stringBuilder.append("onFailure: ");
                stringBuilder.append(throwable.getMessage());
                Log.d(object, (String)stringBuilder.toString());
                Connect3rdPartyRepository.this.mToken2ServerLiveData.postValue(new Token2ServerResult(Connect3rdPartyRepository.SERVER_SERVICE_NAME_STRAVA, false));
            }

            public void onResponse(Call<ResponseBody> object, Response<ResponseBody> object2) {
                if (object2.isSuccessful()) {
                    ResponseBody responseBody = (ResponseBody)object2.body();
                    object = null;
                    try {
                        object = object2 = responseBody.string();
                    }
                    catch (IOException iOException) {
                        iOException.printStackTrace();
                    }
                    try {
                        object2 = new JSONObject((String)object);
                        Connect3rdPartyRepository.this.prepareStravaToken2Server((JSONObject)object2);
                    }
                    catch (JSONException jSONException) {
                        jSONException.printStackTrace();
                        Connect3rdPartyRepository.this.mToken2ServerLiveData.postValue(new Token2ServerResult(Connect3rdPartyRepository.SERVER_SERVICE_NAME_STRAVA, false));
                    }
                    object2 = TAG;
                    object = new StringBuilder();
                    ((StringBuilder)object).append("onResponse: ");
                    ((StringBuilder)object).append(responseBody.toString());
                    Log.d((String)object2, (String)((StringBuilder)object).toString());
                } else {
                    object = ErrorUtils.parseError(object2);
                    object2 = new AccountErrorVo(object2.code(), ((APIError)object).message());
                    Connect3rdPartyRepository.this.liveAccountErrorResponse.postValue(object2);
                    String string2 = TAG;
                    object2 = new StringBuilder();
                    ((StringBuilder)object2).append("refreshStravaToken error message: ");
                    ((StringBuilder)object2).append(((APIError)object).message());
                    Log.d((String)string2, (String)((StringBuilder)object2).toString());
                    Connect3rdPartyRepository.this.mToken2ServerLiveData.postValue(new Token2ServerResult(Connect3rdPartyRepository.SERVER_SERVICE_NAME_STRAVA, false));
                }
            }
        });
    }

    public void refreshTrainingPeaksToken(String string2) {
        this.trainingPeaksApi.refreshToken(this.trainingPeaksBaseUrl, "application/x-www-form-urlencoded", "bryton", "qtXfT2ngWLMI8hvB5MLYlxSD7dAPWQTUMOp12pfP4", "refresh_token", string2).enqueue((Callback)new Callback<ResponseBody>(){

            public void onFailure(Call<ResponseBody> object, Throwable throwable) {
                object = TAG;
                StringBuilder stringBuilder = new StringBuilder();
                stringBuilder.append("onFailure: ");
                stringBuilder.append(throwable.getMessage());
                Log.d(object, (String)stringBuilder.toString());
                Connect3rdPartyRepository.this.mToken2ServerLiveData.postValue(new Token2ServerResult(Connect3rdPartyRepository.SERVER_SERVICE_NAME_TRAININGPEAKS, false));
            }

            public void onResponse(Call<ResponseBody> object, Response<ResponseBody> object2) {
                if (object2.isSuccessful()) {
                    ResponseBody responseBody = (ResponseBody)object2.body();
                    object = null;
                    try {
                        object = object2 = responseBody.string();
                    }
                    catch (IOException iOException) {
                        iOException.printStackTrace();
                    }
                    try {
                        object2 = new JSONObject((String)object);
                        Connect3rdPartyRepository.this.prepareTrainingPeaksToken2Server((JSONObject)object2);
                    }
                    catch (JSONException jSONException) {
                        jSONException.printStackTrace();
                        Connect3rdPartyRepository.this.mToken2ServerLiveData.postValue(new Token2ServerResult(Connect3rdPartyRepository.SERVER_SERVICE_NAME_TRAININGPEAKS, false));
                    }
                    object2 = TAG;
                    object = new StringBuilder();
                    ((StringBuilder)object).append("onResponse: ");
                    ((StringBuilder)object).append(responseBody.toString());
                    Log.d((String)object2, (String)((StringBuilder)object).toString());
                } else {
                    object = ErrorUtils.parseError(object2);
                    new AccountErrorVo(object2.code(), ((APIError)object).message());
                    String string2 = TAG;
                    object2 = new StringBuilder();
                    ((StringBuilder)object2).append("refreshTrainingPeaksToken error message: ");
                    ((StringBuilder)object2).append(((APIError)object).message());
                    Log.d((String)string2, (String)((StringBuilder)object2).toString());
                    Connect3rdPartyRepository.this.mToken2ServerLiveData.postValue(new Token2ServerResult(Connect3rdPartyRepository.SERVER_SERVICE_NAME_TRAININGPEAKS, false));
                }
            }
        });
    }

    public void updateServiceOAuth2Server(final String string2, JSONObject jSONObject) {
        String string3 = TAG;
        CharSequence charSequence = new StringBuilder();
        charSequence.append("updateServiceOAuth2Server: ");
        charSequence.append(string2);
        Log.d((String)string3, (String)charSequence.toString());
        string3 = (String)ProfileUtil.getInstance().get("userId");
        charSequence = (String)ProfileUtil.getInstance().get("com.brytonsport.active.loginToken");
        jSONObject = RequestBody.create((MediaType)MediaType.parse((String)"application/json"), (String)jSONObject.toString());
        this.accountApi.updateServiceOAuth2Server(string3, (String)charSequence, string2, (RequestBody)jSONObject).enqueue((Callback)new Callback<ResponseBody>(){

            public void onFailure(Call<ResponseBody> call, Throwable throwable) {
                Connect3rdPartyRepository.this._isUpdateService2ServerSuccessLiveData.postValue(false);
                Connect3rdPartyRepository.this.mToken2ServerLiveData.postValue(new Token2ServerResult(string2, false));
            }

            public void onResponse(Call<ResponseBody> object, Response<ResponseBody> object2) {
                if (object2.isSuccessful()) {
                    String string22 = TAG;
                    object = new StringBuilder();
                    ((StringBuilder)object).append("updateServiceOAuth2Server onResponse: ");
                    ((StringBuilder)object).append(object2.body());
                    Log.d((String)string22, (String)((StringBuilder)object).toString());
                    object = (ResponseBody)object2.body();
                    Connect3rdPartyRepository.this._isUpdateService2ServerSuccessLiveData.postValue(true);
                    Connect3rdPartyRepository.this.mToken2ServerLiveData.postValue(new Token2ServerResult(string2, true));
                } else {
                    object = ErrorUtils.parseError(object2);
                    object2 = new AccountErrorVo(object2.code(), ((APIError)object).message());
                    Connect3rdPartyRepository.this.liveAccountErrorResponse.postValue(object2);
                    String string3 = TAG;
                    object2 = new StringBuilder();
                    ((StringBuilder)object2).append("updateServiceOAuth2Server error message: ");
                    ((StringBuilder)object2).append(((APIError)object).message());
                    Log.d((String)string3, (String)((StringBuilder)object2).toString());
                    Connect3rdPartyRepository.this._isUpdateService2ServerSuccessLiveData.postValue(false);
                    Connect3rdPartyRepository.this.mToken2ServerLiveData.postValue(new Token2ServerResult(string2, false));
                }
            }
        });
    }

    public void uploadActivity2Relive(String string2, String string3) {
        Object object = (String)ProfileUtil.getInstance().get("userId");
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Bearer ");
        stringBuilder.append(string2);
        string2 = stringBuilder.toString();
        stringBuilder = new StringBuilder();
        stringBuilder.append(App.getInstance().getFilesDir());
        stringBuilder.append(File.separator);
        stringBuilder.append((String)object);
        stringBuilder.append(File.separator);
        stringBuilder.append("fit");
        stringBuilder.append(File.separator);
        stringBuilder.append(string3);
        stringBuilder.append(".fit");
        object = new File(stringBuilder.toString());
        stringBuilder = RequestBody.create((MediaType)MediaType.parse((String)"multipart/form-data"), (File)object);
        object = MultipartBody.Part.createFormData((String)"file", (String)((File)object).getName(), (RequestBody)stringBuilder);
        string3 = RequestBody.create((MediaType)MediaType.parse((String)"multipart/form-data"), (String)string3);
        this.reliveApi.uploadActivity("https://public.api.relive.cc/v1/upload", string2, (MultipartBody.Part)object, (RequestBody)string3).enqueue((Callback)new Callback<ResponseBody>(){

            public void onFailure(Call<ResponseBody> object, Throwable throwable) {
                String string2 = TAG;
                object = new StringBuilder();
                ((StringBuilder)object).append("onFailure: ");
                ((StringBuilder)object).append(throwable.getMessage());
                Log.d((String)string2, (String)((StringBuilder)object).toString());
                Connect3rdPartyRepository.this.mUpload2ReliveLiveData.postValue(null);
            }

            public void onResponse(Call<ResponseBody> object, Response<ResponseBody> object2) {
                if (object2.isSuccessful()) {
                    Object object3;
                    object2 = (ResponseBody)object2.body();
                    try {
                        object = object2.string();
                    }
                    catch (IOException iOException) {
                        iOException.printStackTrace();
                        object = null;
                    }
                    try {
                        object3 = new JSONObject(object);
                        Connect3rdPartyRepository.this.mUpload2ReliveLiveData.postValue(object3.toString());
                    }
                    catch (JSONException jSONException) {
                        jSONException.printStackTrace();
                        Connect3rdPartyRepository.this.mUpload2ReliveLiveData.postValue(null);
                    }
                    object3 = TAG;
                    object = new StringBuilder();
                    ((StringBuilder)object).append("onResponse: ");
                    ((StringBuilder)object).append(object2.toString());
                    Log.d((String)object3, (String)((StringBuilder)object).toString());
                } else {
                    Object object4 = ErrorUtils.parseError(object2);
                    object = new AccountErrorVo(object2.code(), ((APIError)object4).message());
                    object2 = TAG;
                    StringBuilder stringBuilder = new StringBuilder();
                    stringBuilder.append("uploadActivity2Relive error message: ");
                    stringBuilder.append(((APIError)object4).message());
                    Log.d((String)object2, (String)stringBuilder.toString());
                    object4 = Connect3rdPartyRepository.this.mUpload2ReliveLiveData;
                    object2 = new StringBuilder();
                    ((StringBuilder)object2).append("");
                    ((StringBuilder)object2).append(((AccountErrorVo)object).getCode());
                    ((MutableLiveData)object4).postValue(((StringBuilder)object2).toString());
                }
            }
        });
    }

    public void uploadActivity2Selfloops(String string2, String string3) {
        Object object = (String)ProfileUtil.getInstance().get("userId");
        CharSequence charSequence = new StringBuilder();
        charSequence.append("Bearer ");
        charSequence.append(string2);
        string2 = charSequence.toString();
        charSequence = new StringBuilder();
        charSequence.append(App.getInstance().getFilesDir());
        charSequence.append(File.separator);
        charSequence.append((String)object);
        charSequence.append(File.separator);
        charSequence.append("fit");
        charSequence.append(File.separator);
        charSequence.append(string3);
        charSequence.append(".fit");
        new File(charSequence.toString());
        charSequence = new StringBuilder();
        charSequence.append(App.getInstance().getFilesDir());
        charSequence.append(File.separator);
        charSequence.append((String)object);
        charSequence.append(File.separator);
        charSequence.append("fit");
        charSequence.append(File.separator);
        charSequence.append(string3);
        charSequence.append(".fit");
        charSequence = charSequence.toString();
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(App.getInstance().getFilesDir());
        stringBuilder.append(File.separator);
        stringBuilder.append((String)object);
        stringBuilder.append(File.separator);
        stringBuilder.append("fit");
        stringBuilder.append(File.separator);
        stringBuilder.append(string3);
        stringBuilder.append(".gzip");
        object = stringBuilder.toString();
        GZipUtils.compressGzipFile((String)charSequence, (String)object);
        object = new File((String)object);
        charSequence = RequestBody.create((MediaType)MediaType.parse((String)"application/x-gzip"), (File)object);
        object = MultipartBody.Part.createFormData((String)"fitfile", (String)((File)object).getName(), (RequestBody)charSequence);
        string3 = RequestBody.create((MediaType)MediaType.parse((String)"multipart/form-data"), (String)string3);
        this.selfloopsApi.uploadActivity("https://www.selfloops.com/restapi/public/v5/activities/upload.json", string2, (MultipartBody.Part)object, (RequestBody)string3).enqueue((Callback)new Callback<ResponseBody>(){

            public void onFailure(Call<ResponseBody> object, Throwable throwable) {
                String string2 = TAG;
                object = new StringBuilder();
                ((StringBuilder)object).append("onFailure: ");
                ((StringBuilder)object).append(throwable.getMessage());
                Log.d((String)string2, (String)((StringBuilder)object).toString());
                Connect3rdPartyRepository.this.mUpload2SelfloopsLiveData.postValue(null);
            }

            public void onResponse(Call<ResponseBody> object, Response<ResponseBody> object2) {
                boolean bl = object2.isSuccessful();
                object = null;
                if (bl) {
                    Object object3;
                    object2 = (ResponseBody)object2.body();
                    try {
                        object = object2.string();
                    }
                    catch (IOException iOException) {
                        iOException.printStackTrace();
                        object = null;
                    }
                    try {
                        object3 = new JSONObject((String)object);
                        Connect3rdPartyRepository.this.mUpload2SelfloopsLiveData.postValue(object3.toString());
                    }
                    catch (JSONException jSONException) {
                        jSONException.printStackTrace();
                        Connect3rdPartyRepository.this.mUpload2SelfloopsLiveData.postValue(null);
                    }
                    object = TAG;
                    object3 = new StringBuilder();
                    ((StringBuilder)object3).append("onResponse: ");
                    ((StringBuilder)object3).append(object2.toString());
                    Log.d((String)object, (String)((StringBuilder)object3).toString());
                } else {
                    object2 = object2.errorBody();
                    try {
                        object2 = object2.string();
                        object = object2;
                    }
                    catch (IOException iOException) {
                        iOException.printStackTrace();
                    }
                    try {
                        new JSONObject((String)object);
                    }
                    catch (JSONException jSONException) {
                        jSONException.printStackTrace();
                    }
                    Connect3rdPartyRepository.this.mUpload2SelfloopsLiveData.postValue("400");
                }
            }
        });
    }

    public void uploadActivity2Strava(String string2, String object) {
        String string3 = (String)ProfileUtil.getInstance().get("userId");
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Bearer ");
        stringBuilder.append(string2);
        string2 = stringBuilder.toString();
        stringBuilder = new StringBuilder();
        stringBuilder.append(App.getInstance().getFilesDir());
        stringBuilder.append(File.separator);
        stringBuilder.append(string3);
        stringBuilder.append(File.separator);
        stringBuilder.append("fit");
        stringBuilder.append(File.separator);
        stringBuilder.append((String)object);
        stringBuilder.append(".fit");
        object = new File(stringBuilder.toString());
        string3 = RequestBody.create((MediaType)MediaType.parse((String)"multipart/form-data"), (File)object);
        object = MultipartBody.Part.createFormData((String)"file", (String)((File)object).getName(), (RequestBody)string3);
        string3 = RequestBody.create((MediaType)MediaType.parse((String)"multipart/form-data"), (String)"fit");
        this.stravaApi.uploadActivity("https://www.strava.com/api/v3/uploads", string2, (MultipartBody.Part)object, (RequestBody)string3).enqueue((Callback)new Callback<ResponseBody>(){

            public void onFailure(Call<ResponseBody> object, Throwable throwable) {
                object = TAG;
                StringBuilder stringBuilder = new StringBuilder();
                stringBuilder.append("onFailure: ");
                stringBuilder.append(throwable.getMessage());
                Log.d(object, (String)stringBuilder.toString());
                Connect3rdPartyRepository.this.mUpload2StravaLiveData.postValue(null);
            }

            public void onResponse(Call<ResponseBody> object, Response<ResponseBody> object2) {
                boolean bl = object2.isSuccessful();
                object = null;
                if (bl) {
                    Object object3;
                    object2 = (ResponseBody)object2.body();
                    try {
                        object = object2.string();
                    }
                    catch (IOException iOException) {
                        iOException.printStackTrace();
                        object = null;
                    }
                    try {
                        object3 = new JSONObject((String)object);
                        Connect3rdPartyRepository.this.mUpload2StravaLiveData.postValue(object3.toString());
                    }
                    catch (JSONException jSONException) {
                        jSONException.printStackTrace();
                        Connect3rdPartyRepository.this.mUpload2StravaLiveData.postValue(null);
                    }
                    object3 = TAG;
                    object = new StringBuilder();
                    ((StringBuilder)object).append("onResponse: ");
                    ((StringBuilder)object).append(object2.toString());
                    Log.d((String)object3, (String)((StringBuilder)object).toString());
                } else {
                    Object object4 = object2.errorBody();
                    try {
                        object = object4 = object4.string();
                    }
                    catch (IOException iOException) {
                        iOException.printStackTrace();
                    }
                    try {
                        object4 = new JSONObject((String)object);
                        object4.put("code", object2.code());
                        object = new StringBuilder();
                        ((StringBuilder)object).append("\u6d3b\u52d5\u7d00\u9304 \u624b\u52d5\u4e0a\u50b3\u5931\u6557[strava]\uff0cmsg[");
                        ((StringBuilder)object).append(object4.toString());
                        ((StringBuilder)object).append("]");
                        object = ((StringBuilder)object).toString();
                        FirebaseCustomUtil.getInstance().setActivityLogMessage((String)object);
                    }
                    catch (JSONException jSONException) {
                        jSONException.printStackTrace();
                    }
                    object4 = ErrorUtils.parseError(object2);
                    object = new AccountErrorVo(object2.code(), ((APIError)object4).message());
                    Connect3rdPartyRepository.this.liveAccountErrorResponse.postValue(object);
                    object2 = TAG;
                    StringBuilder stringBuilder = new StringBuilder();
                    stringBuilder.append("uploadActivity2Strava error message: ");
                    stringBuilder.append(((APIError)object4).message());
                    Log.d((String)object2, (String)stringBuilder.toString());
                    object2 = Connect3rdPartyRepository.this.mUpload2StravaLiveData;
                    object4 = new StringBuilder();
                    ((StringBuilder)object4).append("");
                    ((StringBuilder)object4).append(((AccountErrorVo)object).getCode());
                    ((MutableLiveData)object2).postValue(((StringBuilder)object4).toString());
                }
            }
        });
    }

    public void uploadActivity2Todaysplan(String string2, String string3) {
        Object object = (String)ProfileUtil.getInstance().get("userId");
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Bearer ");
        stringBuilder.append(string2);
        string2 = stringBuilder.toString();
        stringBuilder = new StringBuilder();
        stringBuilder.append(App.getInstance().getFilesDir());
        stringBuilder.append(File.separator);
        stringBuilder.append((String)object);
        stringBuilder.append(File.separator);
        stringBuilder.append("fit");
        stringBuilder.append(File.separator);
        stringBuilder.append(string3);
        stringBuilder.append(".fit");
        object = new File(stringBuilder.toString());
        stringBuilder = RequestBody.create((MediaType)MediaType.parse((String)"multipart/form-data"), (File)object);
        object = MultipartBody.Part.createFormData((String)"file", (String)((File)object).getName(), (RequestBody)stringBuilder);
        string3 = RequestBody.create((MediaType)MediaType.parse((String)"multipart/form-data"), (String)string3);
        this.todaysplanApi.uploadActivity("https://whats.todaysplan.com.au/rest/files/upload", string2, (MultipartBody.Part)object, (RequestBody)string3).enqueue((Callback)new Callback<ResponseBody>(){

            public void onFailure(Call<ResponseBody> object, Throwable throwable) {
                String string2 = TAG;
                object = new StringBuilder();
                ((StringBuilder)object).append("onFailure: ");
                ((StringBuilder)object).append(throwable.getMessage());
                Log.d((String)string2, (String)((StringBuilder)object).toString());
                Connect3rdPartyRepository.this.mUpload2TodaysplanLiveData.postValue(null);
            }

            public void onResponse(Call<ResponseBody> object, Response<ResponseBody> object2) {
                if (object2.isSuccessful()) {
                    Object object3;
                    object2 = (ResponseBody)object2.body();
                    try {
                        object = object2.string();
                    }
                    catch (IOException iOException) {
                        iOException.printStackTrace();
                        object = null;
                    }
                    try {
                        object3 = new JSONObject(object);
                        Connect3rdPartyRepository.this.mUpload2TodaysplanLiveData.postValue(object3.toString());
                    }
                    catch (JSONException jSONException) {
                        jSONException.printStackTrace();
                        Connect3rdPartyRepository.this.mUpload2TodaysplanLiveData.postValue(null);
                    }
                    object = TAG;
                    object3 = new StringBuilder();
                    ((StringBuilder)object3).append("onResponse: ");
                    ((StringBuilder)object3).append(object2.toString());
                    Log.d(object, (String)((StringBuilder)object3).toString());
                } else {
                    Object object4 = ErrorUtils.parseError(object2);
                    object = new AccountErrorVo(object2.code(), ((APIError)object4).message());
                    object2 = TAG;
                    StringBuilder stringBuilder = new StringBuilder();
                    stringBuilder.append("uploadActivity2Todaysplan error message: ");
                    stringBuilder.append(((APIError)object4).message());
                    Log.d((String)object2, (String)stringBuilder.toString());
                    object4 = Connect3rdPartyRepository.this.mUpload2TodaysplanLiveData;
                    object2 = new StringBuilder();
                    ((StringBuilder)object2).append("");
                    ((StringBuilder)object2).append(((AccountErrorVo)object).getCode());
                    ((MutableLiveData)object4).postValue(((StringBuilder)object2).toString());
                }
            }
        });
    }

    public void uploadActivity2TrainingPeaks(String string2, String string3) {
        String string4 = (String)ProfileUtil.getInstance().get("userId");
        Comparable<StringBuilder> comparable = new StringBuilder();
        ((StringBuilder)comparable).append("Bearer ");
        ((StringBuilder)comparable).append(string2);
        string2 = ((StringBuilder)comparable).toString();
        comparable = new StringBuilder();
        ((StringBuilder)comparable).append(App.getInstance().getFilesDir());
        ((StringBuilder)comparable).append(File.separator);
        ((StringBuilder)comparable).append(string4);
        ((StringBuilder)comparable).append(File.separator);
        ((StringBuilder)comparable).append("fit");
        ((StringBuilder)comparable).append(File.separator);
        ((StringBuilder)comparable).append(string3);
        ((StringBuilder)comparable).append(".fit");
        comparable = new File(((StringBuilder)comparable).toString());
        Object object = RequestBody.create((MediaType)MediaType.parse((String)"multipart/form-data"), (File)comparable);
        MultipartBody.Part.createFormData((String)"file", (String)((File)comparable).getName(), (RequestBody)object);
        comparable = new JSONObject();
        try {
            object = new StringBuilder();
            ((StringBuilder)object).append(App.getInstance().getFilesDir());
            ((StringBuilder)object).append(File.separator);
            ((StringBuilder)object).append(string4);
            ((StringBuilder)object).append(File.separator);
            ((StringBuilder)object).append("fit");
            ((StringBuilder)object).append(File.separator);
            ((StringBuilder)object).append(string3);
            ((StringBuilder)object).append(".fit");
            comparable.put("Data", FileUtil.getBase64FromPath(((StringBuilder)object).toString()));
            comparable.put("Filename", string3);
            comparable.put("UploadClient", "Bryton");
        }
        catch (JSONException jSONException) {
            jSONException.printStackTrace();
        }
        string3 = RequestBody.create((MediaType)MediaType.parse((String)"application/json"), (String)comparable.toString());
        this.trainingPeaksApi.uploadActivity("https://api.trainingpeaks.com/v3/file", string2, "application/json", (RequestBody)string3).enqueue((Callback)new Callback<ResponseBody>(){

            public void onFailure(Call<ResponseBody> object, Throwable throwable) {
                String string2 = TAG;
                object = new StringBuilder();
                ((StringBuilder)object).append("onFailure: ");
                ((StringBuilder)object).append(throwable.getMessage());
                Log.d((String)string2, (String)((StringBuilder)object).toString());
                Connect3rdPartyRepository.this.mUpload2TrainingPeaksLiveData.postValue(null);
            }

            public void onResponse(Call<ResponseBody> object, Response<ResponseBody> object2) {
                if (object2.isSuccessful()) {
                    ResponseBody responseBody = (ResponseBody)object2.body();
                    try {
                        object = responseBody.string();
                    }
                    catch (IOException iOException) {
                        iOException.printStackTrace();
                        object = null;
                    }
                    if (object != null && !((String)object).isEmpty()) {
                        try {
                            object2 = new JSONArray((String)object);
                            object = new JSONObject();
                            object.put("data", (Object)object2.toString());
                            Connect3rdPartyRepository.this.mUpload2TrainingPeaksLiveData.postValue(object.toString());
                        }
                        catch (JSONException jSONException) {
                            jSONException.printStackTrace();
                            Connect3rdPartyRepository.this.mUpload2TrainingPeaksLiveData.postValue(null);
                        }
                    } else {
                        object = new JSONObject();
                        try {
                            object.put("status", object2.code());
                        }
                        catch (JSONException jSONException) {
                            jSONException.printStackTrace();
                        }
                        Connect3rdPartyRepository.this.mUpload2TrainingPeaksLiveData.postValue(object.toString());
                    }
                    object = TAG;
                    object2 = new StringBuilder();
                    ((StringBuilder)object2).append("onResponse: ");
                    ((StringBuilder)object2).append(responseBody.toString());
                    Log.d((String)object, (String)((StringBuilder)object2).toString());
                } else {
                    object = ErrorUtils.parseError(object2);
                    new AccountErrorVo(object2.code(), ((APIError)object).message());
                    CharSequence charSequence = TAG;
                    StringBuilder stringBuilder = new StringBuilder();
                    stringBuilder.append("uploadActivity2TrainingPeaks error message: ");
                    stringBuilder.append(((APIError)object).message());
                    Log.d((String)charSequence, (String)stringBuilder.toString());
                    object = Connect3rdPartyRepository.this.mUpload2TrainingPeaksLiveData;
                    charSequence = new StringBuilder();
                    ((StringBuilder)charSequence).append("");
                    ((StringBuilder)charSequence).append(object2.code());
                    ((MutableLiveData)object).postValue(((StringBuilder)charSequence).toString());
                }
            }
        });
    }

    public class Token2ServerResult {
        private boolean result;
        private String serviceName;

        public Token2ServerResult(String string2, boolean bl) {
            this.serviceName = string2;
            this.result = bl;
        }

        public String name() {
            return this.serviceName;
        }

        public boolean result() {
            return this.result;
        }
    }
}

