/*
 * Decompiled with CFR 0.152.
 */
package com.brytonsport.active.repo.result;

import android.content.Context;
import android.util.Log;
import androidx.lifecycle.LiveData;
import androidx.lifecycle.MutableLiveData;
import com.brytonsport.active.api.ApiResponse;
import com.brytonsport.active.api.ApiService;
import com.brytonsport.active.api.ErrorUtils;
import com.brytonsport.active.api.NetworkBoundResource;
import com.brytonsport.active.api.Resource;
import com.brytonsport.active.api.account.vo.AccountErrorVo;
import com.brytonsport.active.api.account.vo.AccountUserInfo;
import com.brytonsport.active.api.account.vo.Strava;
import com.brytonsport.active.api.result.ActivityCount;
import com.brytonsport.active.api.result.BrytonActivityApi;
import com.brytonsport.active.base.App;
import com.brytonsport.active.base.SingleLiveEvent;
import com.brytonsport.active.bleplugin.ParserUtil;
import com.brytonsport.active.db.AppDatabase;
import com.brytonsport.active.db.account.dao.UserInfoDao;
import com.brytonsport.active.db.result.dao.BrytonActivityDao;
import com.brytonsport.active.db.result.entity.ActivityEntity;
import com.brytonsport.active.db.setting.entity.DeviceManagerEntity;
import com.brytonsport.active.fit.BrytonActivity;
import com.brytonsport.active.repo.result.ActivityRepository$$ExternalSyntheticLambda0;
import com.brytonsport.active.repo.result.ActivityRepository$$ExternalSyntheticLambda1;
import com.brytonsport.active.repo.result.ActivityRepository$$ExternalSyntheticLambda2;
import com.brytonsport.active.repo.result.ActivityRepository$$ExternalSyntheticLambda3;
import com.brytonsport.active.repo.result.ActivityRepository$$ExternalSyntheticLambda4;
import com.brytonsport.active.repo.result.ActivityRepository$$ExternalSyntheticLambda5;
import com.brytonsport.active.repo.result.ActivityRepository$$ExternalSyntheticLambda6;
import com.brytonsport.active.repo.result.ActivityRepository$5$$ExternalSyntheticLambda0;
import com.brytonsport.active.repo.result.ActivityRepository$5$$ExternalSyntheticLambda1;
import com.brytonsport.active.repo.setting.DeviceRepository;
import com.brytonsport.active.utils.ActivityFileUtil;
import com.brytonsport.active.utils.FirebaseCustomUtil;
import com.brytonsport.active.utils.NetworkUtil;
import com.brytonsport.active.utils.ProfileUtil;
import com.brytonsport.active.utils.TimeUtilByLee;
import com.brytonsport.active.vm.base.DayActivity;
import java.io.File;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.Semaphore;
import javax.inject.Inject;
import javax.inject.Singleton;
import okhttp3.MediaType;
import okhttp3.MultipartBody;
import okhttp3.RequestBody;
import okhttp3.ResponseBody;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import retrofit2.Call;
import retrofit2.Callback;
import retrofit2.Response;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Singleton
public class ActivityRepository {
    static final String TAG = "ActivityRepository";
    private List<ActivityCount> activityCounts;
    private MutableLiveData<Boolean> activityCountsNextLive;
    private MutableLiveData<Boolean> activityDeleteResultLive;
    private MutableLiveData<String> activityDeleteResultText;
    private SingleLiveEvent<Boolean> activityFitDownloadSuccessLive;
    private SingleLiveEvent<Integer> activityListCountLive;
    private final BrytonActivityApi brytonActivityApi;
    private final BrytonActivityDao brytonActivityDao;
    private int deleteActivityErrorCount = 0;
    private int deleteActivityOkCount = 0;
    private int deleteActivityTimeoutCount = 0;
    private int deleteActivityTotalNum = 0;
    private MutableLiveData<Boolean> editActivityNameSuccessLive;
    private int fitOnGoingCnt = 0;
    private final MutableLiveData<Boolean> isLogUploadLiveData;
    private final MutableLiveData<AccountErrorVo> liveAccountErrorResponse;
    private int loadActivityListLimitNum = 50;
    Semaphore semaphore = new Semaphore(1);
    private int upload2ServerErrorCount = 0;
    private int upload2ServerOkCount = 0;
    private int upload2ServerTimeoutCount = 0;
    public int uploadFit2ServerTotalNum = 0;
    private final UserInfoDao userInfoDao;

    @Inject
    public ActivityRepository() {
        this.activityCounts = new ArrayList<ActivityCount>();
        this.activityCountsNextLive = new MutableLiveData();
        this.activityDeleteResultLive = new MutableLiveData();
        this.activityDeleteResultText = new MutableLiveData();
        this.editActivityNameSuccessLive = new MutableLiveData();
        this.activityFitDownloadSuccessLive = new SingleLiveEvent();
        this.isLogUploadLiveData = new MutableLiveData();
        this.activityListCountLive = new SingleLiveEvent();
        this.liveAccountErrorResponse = new MutableLiveData();
        this.brytonActivityApi = ApiService.getInstance().getBrytonActivityApi();
        this.brytonActivityDao = AppDatabase.getInstance(App.getInstance().getApplicationContext()).brytonActivityDao();
        this.userInfoDao = AppDatabase.getInstance(App.getInstance().getApplicationContext()).userInfoDao();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void countDeleteActivity(NetworkUtil.ApiResultState object) {
        synchronized (this) {
            int n;
            block9: {
                block8: {
                    n = 9.$SwitchMap$com$brytonsport$active$utils$NetworkUtil$ApiResultState[((Enum)object).ordinal()];
                    if (n == 1) break block8;
                    if (n != 2) {
                        if (n == 3) {
                            ++this.deleteActivityTimeoutCount;
                        }
                        break block9;
                    } else {
                        ++this.deleteActivityErrorCount;
                    }
                    break block9;
                }
                ++this.deleteActivityOkCount;
            }
            String string2 = String.format("countDeleteActivity: \u522a\u9664\u6210\u529f %d\u7b46\uff0c\u5931\u6557 %d\u7b46\uff0cTimeout %d\u7b46", this.deleteActivityOkCount, this.deleteActivityErrorCount, this.deleteActivityTimeoutCount);
            String string3 = TAG;
            Log.d((String)string3, (String)string2);
            CharSequence charSequence = String.format("%d / %d", this.deleteActivityOkCount, this.deleteActivityTotalNum);
            this.activityDeleteResultText.postValue((String)charSequence);
            int n2 = this.deleteActivityOkCount;
            int n3 = this.deleteActivityErrorCount;
            n = this.deleteActivityTimeoutCount;
            int n4 = this.deleteActivityTotalNum;
            if (n2 + n3 + n == n4) {
                charSequence = new StringBuilder();
                ((StringBuilder)charSequence).append(string2);
                ((StringBuilder)charSequence).append("\uff0c\u9700\u8981\u522a\u9664\u7684\u7e3d\u7b46\u6578");
                ((StringBuilder)charSequence).append(this.deleteActivityTotalNum);
                ((StringBuilder)charSequence).append("\u7b46");
                Log.d((String)string3, (String)((StringBuilder)charSequence).toString());
                this.activityDeleteResultLive.postValue(true);
            } else if (n4 == 1) {
                this.activityDeleteResultLive.postValue(false);
            }
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void countUploadFit2Server(NetworkUtil.ApiResultState object) {
        synchronized (this) {
            block6: {
                block5: {
                    int n = 9.$SwitchMap$com$brytonsport$active$utils$NetworkUtil$ApiResultState[((Enum)object).ordinal()];
                    if (n == 1) break block5;
                    if (n != 2) {
                        if (n == 3) {
                            ++this.upload2ServerTimeoutCount;
                        }
                        break block6;
                    } else {
                        ++this.upload2ServerErrorCount;
                    }
                    break block6;
                }
                ++this.upload2ServerOkCount;
            }
            String string2 = String.format("countUploadFit2Server: \u4e0a\u50b3\u6210\u529f %d\u7b46\uff0c\u5931\u6557 %d\u7b46\uff0cTimeout %d\u7b46", this.upload2ServerOkCount, this.upload2ServerErrorCount, this.upload2ServerTimeoutCount);
            Log.d((String)TAG, (String)string2);
            return;
        }
    }

    private void decodeActivityFit(String string2, String string3, String string4, DayActivity dayActivity) {
        new Thread(new ActivityRepository$$ExternalSyntheticLambda1(this, string4, string3, string2, dayActivity)).start();
    }

    private void deleteActivity(DayActivity object) {
        String string2 = ((DayActivity)object)._id;
        Object object2 = ((DayActivity)object).localStartTime;
        CharSequence charSequence = ((DayActivity)object).name;
        object = charSequence;
        if (((String)charSequence).equals("new activity")) {
            object = new StringBuilder();
            ((StringBuilder)object).append("bike");
            ((StringBuilder)object).append(ParserUtil.fileIdToFormatString((Long)object2).substring(2, 10));
            object = ((StringBuilder)object).toString();
            String string3 = TAG;
            charSequence = new StringBuilder();
            ((StringBuilder)charSequence).append("deleteActivity dateStr: ");
            ((StringBuilder)charSequence).append((String)object);
            ((StringBuilder)charSequence).append(", localStartTime = ");
            ((StringBuilder)charSequence).append(object2);
            Log.d((String)string3, (String)((StringBuilder)charSequence).toString());
        }
        charSequence = ProfileUtil.getInstance().getPrefString("userId");
        object2 = ProfileUtil.getInstance().getPrefString("com.brytonsport.active.loginToken");
        this.brytonActivityApi.deleteActivity((String)charSequence, (String)object2, string2).enqueue((Callback)new Callback<ResponseBody>((String)object){
            final /* synthetic */ String val$finalName;
            {
                this.val$finalName = string2;
            }

            public void onFailure(Call<ResponseBody> object, Throwable throwable) {
                object = new StringBuilder();
                ((StringBuilder)object).append("deleteActivity -> ");
                ((StringBuilder)object).append(this.val$finalName);
                ((StringBuilder)object).append(" onFailure : ");
                ((StringBuilder)object).append(throwable.getMessage());
                object = ((StringBuilder)object).toString();
                Log.d((String)TAG, (String)object);
                ActivityRepository.this.countDeleteActivity(NetworkUtil.ApiResultState.TIMEOUT);
            }

            public void onResponse(Call<ResponseBody> object, Response<ResponseBody> object2) {
                if (object2.isSuccessful()) {
                    NetworkUtil.parseResponseBody(object2);
                    object2 = TAG;
                    object = new StringBuilder();
                    ((StringBuilder)object).append("delete ");
                    ((StringBuilder)object).append(this.val$finalName);
                    ((StringBuilder)object).append(" success");
                    Log.d((String)object2, (String)((StringBuilder)object).toString());
                    ActivityRepository.this.countDeleteActivity(NetworkUtil.ApiResultState.SUCCESS);
                } else {
                    object = NetworkUtil.parseResponseErrorBody(object2);
                    object2 = new StringBuilder();
                    ((StringBuilder)object2).append("deleteActivity -> ");
                    ((StringBuilder)object2).append(this.val$finalName);
                    ((StringBuilder)object2).append(" error: ");
                    ((StringBuilder)object2).append((String)object);
                    object = ((StringBuilder)object2).toString();
                    Log.d((String)TAG, (String)object);
                    ActivityRepository.this.countDeleteActivity(NetworkUtil.ApiResultState.FAILURE);
                }
            }
        });
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    private void fitDecodeOk(String var1_1, JSONObject var2_2, String var3_6, DayActivity var4_7) {
        block9: {
            block10: {
                var5_8 = ActivityRepository.TAG;
                var6_9 = new StringBuilder();
                var6_9.append("");
                var6_9.append(var3_6);
                var6_9.append(" fitDecodeOk \u6ce8\u610f");
                Log.d((String)var5_8, (String)var6_9.toString());
                if (!var2_2 /* !! */ .has("samples")) break block9;
                var5_8 = var2_2 /* !! */ .getJSONArray("samples");
                var6_9 = new JSONArray();
                var7_10 = 0;
                while (true) {
                    if (var7_10 >= var5_8.length()) break;
                    var2_2 /* !! */  = var5_8.getJSONObject(var7_10);
                    if (var2_2 /* !! */ .has("position_lat") && var2_2 /* !! */ .has("position_long") && var2_2 /* !! */ .getDouble("position_lat") != -1.0 && var2_2 /* !! */ .getDouble("position_long") != -1.0) {
                        var6_9.put((Object)var2_2 /* !! */ );
                    }
                    ++var7_10;
                    continue;
                    break;
                }
                if (var6_9.length() > 0) ** GOTO lbl45
                var2_2 /* !! */  = ActivityRepository.TAG;
                var5_8 = new StringBuilder();
                var5_8.append("");
                var5_8.append(var3_6);
                var5_8.append(" \u6c92\u9ede\u6c92\u8fa6\u6cd5\u756b");
                Log.d((String)var2_2 /* !! */ , (String)var5_8.toString());
                try {
                    this.updateMapImageToDb(var1_1, "");
                    this.countUploadFit2Server(NetworkUtil.ApiResultState.SUCCESS);
                    this.removeGettingActivityId(var1_1);
                    Log.d((String)var2_2 /* !! */ , (String)"\u5c07\u6b63\u5728\u7522\u751f\u7e2e\u5716\u72c0\u614b\u6e05\u9664: fitDecodeOk -> \u6c92\u9ede\u6c92\u8fa6\u6cd5\u756b");
                    this.removeActivityIsGenImageIng(var4_7);
                    break block9;
lbl45:
                    // 1 sources

                    if (var6_9.length() == 1) {
                        var6_9.put((Object)var6_9.getJSONObject(0));
                    }
                    var2_2 /* !! */  = this.shrinkSameple((JSONArray)var6_9, 50, var3_6);
                    var5_8 = new ActivityRepository$$ExternalSyntheticLambda2(this, var1_1, (JSONArray)var2_2 /* !! */ , var3_6, var4_7);
                    var6_9 = new Thread((Runnable)var5_8);
                    var6_9.start();
                    break block9;
                }
                catch (JSONException var2_3) {
                    break block10;
                }
                catch (JSONException var2_4) {
                    // empty catch block
                }
            }
            var2_5.printStackTrace();
            this.removeGettingActivityId(var1_1);
            Log.d((String)ActivityRepository.TAG, (String)"\u5c07\u6b63\u5728\u7522\u751f\u7e2e\u5716\u72c0\u614b\u6e05\u9664: fitDecodeOk -> JSONException");
            this.removeActivityIsGenImageIng(var4_7);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void getStaticMap(final String string2, JSONArray object, final String string3, final DayActivity dayActivity) {
        CharSequence charSequence;
        final String string4 = ProfileUtil.getInstance().getPrefString("userId");
        String string5 = ProfileUtil.getInstance().getPrefString("com.brytonsport.active.loginToken");
        String string6 = "";
        int n = 0;
        while (true) {
            charSequence = string6;
            String string7 = string6;
            try {
                if (n >= object.length()) break;
                string7 = string6;
                charSequence = object.getJSONObject(n);
                string7 = string6;
                double d = charSequence.getDouble("position_lat");
                string7 = string6;
                double d2 = charSequence.getDouble("position_long");
                string7 = string6;
                string7 = string6;
                charSequence = new StringBuilder();
                string7 = string6;
                ((StringBuilder)charSequence).append(string6);
                string7 = string6;
                ((StringBuilder)charSequence).append(String.format(Locale.ENGLISH, "%.6f,%.6f", d2, d));
                string7 = string6;
                string7 = string6 = ((StringBuilder)charSequence).toString();
                string7 = string6;
                charSequence = new StringBuilder();
                string7 = string6;
                ((StringBuilder)charSequence).append(string6);
                string7 = string6;
                ((StringBuilder)charSequence).append("|");
                string7 = string6;
                string6 = ((StringBuilder)charSequence).toString();
                ++n;
            }
            catch (Exception exception) {
                charSequence = string7;
                break;
            }
        }
        string6 = TAG;
        object = new StringBuilder();
        ((StringBuilder)object).append("\u6ce8\u610f getStaticMap: \u53d6\u5f97\u7e2e\u5716 > ");
        ((StringBuilder)object).append(string3);
        Log.d((String)string6, (String)((StringBuilder)object).toString());
        object = String.format("http://tiles.brytonfit.com/styles/terrain/static/auto/420x110.png?stroke=blue&width=3&path=|%s", charSequence);
        ProfileUtil.getInstance().set("activityGetStaticMapTemp", object);
        this.brytonActivityApi.downloadFitWithDynamicUrl(string4, string5, (String)object).enqueue((Callback)new Callback<ResponseBody>(){

            public void onFailure(Call<ResponseBody> call, Throwable throwable) {
                Log.e((String)TAG, (String)"error");
                ActivityRepository.this.countUploadFit2Server(NetworkUtil.ApiResultState.TIMEOUT);
                ActivityRepository.this.removeGettingActivityId(string2);
                Log.d((String)TAG, (String)"\u5c07\u6b63\u5728\u7522\u751f\u7e2e\u5716\u72c0\u614b\u6e05\u9664: getStaticMap -> onFailure");
                ActivityRepository.this.removeActivityIsGenImageIng(dayActivity);
            }

            public void onResponse(Call<ResponseBody> object, Response<ResponseBody> object2) {
                if (object2.isSuccessful()) {
                    object = App.getInstance();
                    object2 = (ResponseBody)object2.body();
                    CharSequence charSequence = new StringBuilder();
                    charSequence.append(string4);
                    charSequence.append("/png");
                    charSequence = charSequence.toString();
                    StringBuilder stringBuilder = new StringBuilder();
                    stringBuilder.append(string3);
                    stringBuilder.append(".png");
                    boolean bl = ActivityFileUtil.writeResponseBodyToDisk(object, (ResponseBody)object2, (String)charSequence, stringBuilder.toString());
                    object = TAG;
                    object2 = new StringBuilder();
                    ((StringBuilder)object2).append(string3);
                    ((StringBuilder)object2).append(".png download was a success? ");
                    ((StringBuilder)object2).append(bl);
                    Log.d(object, (String)((StringBuilder)object2).toString());
                    if (bl) {
                        object = new StringBuilder();
                        ((StringBuilder)object).append(string4);
                        ((StringBuilder)object).append("/png");
                        ((StringBuilder)object).append(File.separator);
                        ((StringBuilder)object).append(string3);
                        ((StringBuilder)object).append(".png");
                        object = ((StringBuilder)object).toString();
                        ActivityRepository.this.updateMapImageToDb(string2, (String)object);
                    }
                    ActivityRepository.this.countUploadFit2Server(NetworkUtil.ApiResultState.SUCCESS);
                } else {
                    Log.d((String)TAG, (String)"server contact failed");
                    ActivityRepository.this.countUploadFit2Server(NetworkUtil.ApiResultState.FAILURE);
                }
                ActivityRepository.this.removeGettingActivityId(string2);
                Log.d((String)TAG, (String)"\u5c07\u6b63\u5728\u7522\u751f\u7e2e\u5716\u72c0\u614b\u6e05\u9664: getStaticMap -> onResponse");
                ActivityRepository.this.removeActivityIsGenImageIng(dayActivity);
            }
        });
    }

    private void insertActivityListToDb(List<ActivityEntity> list) {
        Log.d((String)TAG, (String)"insertActivityListToDb: \u5c07activity list ");
        AppDatabase.getInstance((Context)App.getInstance()).brytonActivityDao().insertActivityList(list);
    }

    private void insertActivityToDb(ActivityEntity activityEntity) {
        String string2 = TAG;
        Log.d((String)string2, (String)"insertActivityToDb: \u65b0\u589e\u4e00\u7b46activity");
        ActivityEntity activityEntity2 = AppDatabase.getInstance((Context)App.getInstance()).brytonActivityDao().loadActivityById(activityEntity.get_id());
        if (activityEntity2 != null) {
            if (activityEntity2.getUploadedAt() != activityEntity.getUploadedAt()) {
                Log.d((String)string2, (String)"insertActivityToDb: \u65b0\u589e\u4e00\u7b46activity -> \u5982\u679cUploadedAt \u4e0d\u4e00\u5236\u624d\u66f4\u65b0");
                AppDatabase.getInstance((Context)App.getInstance()).brytonActivityDao().insert(activityEntity);
            } else {
                Log.d((String)string2, (String)"insertActivityToDb: \u65b0\u589e\u4e00\u7b46activity -> \u5982\u679cUploadedAt \u4e00\u6a23\u5247\u4e0d\u66f4\u65b0");
            }
        } else {
            Log.d((String)string2, (String)"insertActivityToDb: \u65b0\u589e\u4e00\u7b46activity -> DB\u6c92\u6709\u6b64\u7b46ID\uff0c\u4ee3\u8868\u662f\u5168\u65b0\u4e0a\u50b3\u7684");
            AppDatabase.getInstance((Context)App.getInstance()).brytonActivityDao().insert(activityEntity);
        }
    }

    static /* synthetic */ void lambda$updateMapImageToDb$5(String object, String string2) {
        object = AppDatabase.getInstance((Context)App.getInstance()).brytonActivityDao().loadActivityById((String)object);
        if (object != null) {
            ((ActivityEntity)object).setMapImage(string2);
            AppDatabase.getInstance((Context)App.getInstance()).brytonActivityDao().insert((ActivityEntity)object);
        }
    }

    private void loadActivityToDeleteToDb(String object) {
        Log.d((String)TAG, (String)"loadActivityToDeleteToDb: \u6839\u64daID\u522a\u9664activity");
        object = AppDatabase.getInstance((Context)App.getInstance()).brytonActivityDao().loadActivityById((String)object);
        if (object != null) {
            AppDatabase.getInstance((Context)App.getInstance()).brytonActivityDao().delete((ActivityEntity)object);
        }
    }

    private void prepareActivityListToDb(List<ActivityEntity> list) {
        String string2 = TAG;
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(" \u5f9e\u6a5f\u5668\u540c\u6b65Fit \u5230app \u5b8c\u6210: \u585e\u8cc7\u6599\u5230DB \u6bd4\u6578: ");
        stringBuilder.append(list.size());
        Log.d((String)string2, (String)stringBuilder.toString());
        stringBuilder = new StringBuilder();
        stringBuilder.append("prepareActivityListToDb getActivityList(server) \u66f4\u65b0\u7b46\u6578: ");
        stringBuilder.append(list.size());
        Log.d((String)string2, (String)stringBuilder.toString());
        if ((Integer)ProfileUtil.getInstance().get("activityListTimestamp") == 0) {
            for (int i = list.size() - 1; i >= 0; --i) {
                if (!list.get(i).getName().equals("_deleted")) continue;
                list.remove(i);
            }
            string2 = TAG;
            stringBuilder = new StringBuilder();
            stringBuilder.append("\u53d6\u5f97\u6d3b\u52d5\u7d00\u9304 timeStamp\u70ba0, \u904e\u6ffe\u6389_deleted \u5f8c\u7684\u7b46\u6578: ");
            stringBuilder.append(list.size());
            Log.d((String)string2, (String)stringBuilder.toString());
            new Thread(new ActivityRepository$$ExternalSyntheticLambda3(this, list)).start();
        } else {
            Log.d((String)string2, (String)"timeStamp\u4e0d\u70ba0, \u7b2c\u4e8c\u6b21\u5f8c: ");
            new Thread(new ActivityRepository$$ExternalSyntheticLambda4(this, list)).start();
        }
    }

    private void removeActivityIsGenImageIng(DayActivity dayActivity) {
        if (dayActivity != null) {
            dayActivity.isGenImageIng = false;
        }
    }

    private void removeFitProcessCount() {
        int n = this.fitOnGoingCnt;
        if (n > 0) {
            this.fitOnGoingCnt = n - 1;
        }
    }

    private void removeGettingActivityId(String string2) {
        if (App.gettingActivityFitSet.contains(string2)) {
            this.removeFitProcessCount();
            App.gettingActivityFitSet.remove(string2);
        }
    }

    private void resetUpload2ServerCount() {
        this.upload2ServerOkCount = 0;
        this.upload2ServerErrorCount = 0;
        this.upload2ServerTimeoutCount = 0;
    }

    private void updateMapImageToDb() {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        ArrayList<String> arrayList = new ArrayList<String>();
        for (ActivityCount object2 : this.activityCounts) {
            arrayList.add(object2.getActivityId());
            hashMap.put(object2.getActivityId(), object2.getFilePath());
        }
        String string2 = TAG;
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("updateMapImageToDb: \u4f9d\u6b21\u66f4\u65b0\u6bd4\u6578 -> ");
        stringBuilder.append(this.activityCounts.size());
        Log.d((String)string2, (String)stringBuilder.toString());
        new Thread(new ActivityRepository$$ExternalSyntheticLambda5(this, arrayList, hashMap)).start();
    }

    private void updateMapImageToDb(String string2, String string3) {
        this.activityCounts.add(new ActivityCount(string2, string3));
        String string4 = TAG;
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("updateMapImageToDb: \u5bb6\u9053count\u4e2d -> ");
        stringBuilder.append(string2);
        Log.d((String)string4, (String)stringBuilder.toString());
        stringBuilder = new StringBuilder();
        stringBuilder.append("updateMapImageToDb: \u66f4\u65b0DB -> ");
        stringBuilder.append(string3);
        Log.d((String)string4, (String)stringBuilder.toString());
        new Thread(new ActivityRepository$$ExternalSyntheticLambda6(string2, string3)).start();
    }

    public BrytonActivity.DecodeResult decodeActivityFitForService(String object, String string2) {
        Object object2;
        Object object3;
        Object object4;
        block18: {
            ++this.fitOnGoingCnt;
            object4 = App.getInstance().getFilesDir();
            object3 = new StringBuilder();
            ((StringBuilder)object3).append(object4);
            ((StringBuilder)object3).append(File.separator);
            ((StringBuilder)object3).append((String)object);
            ((StringBuilder)object3).append(File.separator);
            ((StringBuilder)object3).append(string2);
            ((StringBuilder)object3).append(".fit");
            object3 = ((StringBuilder)object3).toString();
            object2 = new BrytonActivity();
            ((BrytonActivity)object2).encodeFileSet((String)object3);
            JSONObject jSONObject = new JSONObject();
            DeviceManagerEntity deviceManagerEntity = DeviceRepository.getInstance().loadDeviceIsChoice();
            object3 = this.getUserInfoFromDb();
            object4 = object3 != null && ((AccountUserInfo)object3).getServices() != null ? ((AccountUserInfo)object3).getServices().getStrava() : null;
            object3 = BrytonActivity.DecodeResult.UNKNOWN;
            object3 = object = ((BrytonActivity)object2).decode(this, jSONObject, string2, (String)object, deviceManagerEntity, (Strava)object4, true);
            if (object != BrytonActivity.DecodeResult.SUCCESS) break block18;
            object3 = object;
            object4 = TAG;
            object3 = object;
            object3 = object;
            object2 = new StringBuilder();
            object3 = object;
            ((StringBuilder)object2).append("");
            object3 = object;
            ((StringBuilder)object2).append(string2);
            object3 = object;
            ((StringBuilder)object2).append(" decode ok");
            object3 = object;
            Log.d((String)object4, (String)((StringBuilder)object2).toString());
            object3 = object;
            this.removeFitProcessCount();
            return object;
        }
        object3 = object;
        object4 = TAG;
        object3 = object;
        object3 = object;
        object2 = new StringBuilder();
        object3 = object;
        ((StringBuilder)object2).append("");
        object3 = object;
        ((StringBuilder)object2).append(string2);
        object3 = object;
        ((StringBuilder)object2).append(" decode error");
        object3 = object;
        try {
            Log.d((String)object4, (String)((StringBuilder)object2).toString());
        }
        catch (Exception exception) {
            object2 = TAG;
            object = new StringBuilder();
            ((StringBuilder)object).append("");
            ((StringBuilder)object).append(string2);
            ((StringBuilder)object).append(" decode Exception: ");
            ((StringBuilder)object).append(exception.getMessage());
            Log.d((String)object2, (String)((StringBuilder)object).toString());
            object = object3;
        }
        this.removeFitProcessCount();
        return object;
    }

    public void deleteActivityAllData() {
        this.brytonActivityDao.deleteAll();
    }

    public void deleteActivityFromInfoPage(DayActivity dayActivity) {
        this.deleteActivityTotalNum = 1;
        this.deleteActivity(dayActivity);
    }

    public void deleteActivityList(List<DayActivity> object) {
        this.deleteActivityTotalNum = object.size();
        object = object.iterator();
        while (object.hasNext()) {
            this.deleteActivity((DayActivity)object.next());
        }
    }

    public void editActivityName(DayActivity object) {
        final String string2 = ((DayActivity)object)._id;
        String string3 = ProfileUtil.getInstance().getPrefString("userId");
        String string4 = ProfileUtil.getInstance().getPrefString("com.brytonsport.active.loginToken");
        object = ((DayActivity)object).name;
        this.brytonActivityApi.editActivityName(string3, string4, string2, (String)object).enqueue((Callback)new Callback<ResponseBody>(){

            public void onFailure(Call<ResponseBody> object, Throwable throwable) {
                object = new StringBuilder();
                ((StringBuilder)object).append("editActivityName -> ");
                ((StringBuilder)object).append(string2);
                ((StringBuilder)object).append(" onFailure : ");
                ((StringBuilder)object).append(throwable.getMessage());
                object = ((StringBuilder)object).toString();
                Log.d((String)TAG, (String)object);
                ActivityRepository.this.editActivityNameSuccessLive.postValue(false);
            }

            public void onResponse(Call<ResponseBody> object, Response<ResponseBody> object2) {
                if (object2.isSuccessful()) {
                    object = NetworkUtil.parseResponseBody(object2);
                    String string22 = TAG;
                    object2 = new StringBuilder();
                    ((StringBuilder)object2).append("editActivityName ");
                    ((StringBuilder)object2).append(string2);
                    ((StringBuilder)object2).append(" success: ");
                    ((StringBuilder)object2).append((String)object);
                    Log.d((String)string22, (String)((StringBuilder)object2).toString());
                    ActivityRepository.this.editActivityNameSuccessLive.postValue(true);
                } else {
                    object2 = NetworkUtil.parseResponseErrorBody(object2);
                    object = new StringBuilder();
                    ((StringBuilder)object).append("editActivityName -> ");
                    ((StringBuilder)object).append(string2);
                    ((StringBuilder)object).append(" error: ");
                    ((StringBuilder)object).append((String)object2);
                    object = ((StringBuilder)object).toString();
                    Log.d((String)TAG, (String)object);
                    ActivityRepository.this.editActivityNameSuccessLive.postValue(false);
                }
            }
        });
    }

    public MutableLiveData<Boolean> getActivityCountsNextLive() {
        return this.activityCountsNextLive;
    }

    public MutableLiveData<Boolean> getActivityDeleteResultLive() {
        return this.activityDeleteResultLive;
    }

    public MutableLiveData<String> getActivityDeleteResultText() {
        return this.activityDeleteResultText;
    }

    public void getActivityFile(DayActivity dayActivity) {
        this.getActivityFile(dayActivity._id, dayActivity.localStartTime, dayActivity);
    }

    public void getActivityFile(String string2, Long l) {
        this.getActivityFile(string2, l, null);
    }

    public void getActivityFile(String string2, Long l, DayActivity dayActivity) {
        ++this.fitOnGoingCnt;
        new Thread(new ActivityRepository$$ExternalSyntheticLambda0(this, l, string2, dayActivity)).start();
    }

    public void getActivityFileByDetailPage(String string2, final Long l) {
        final String string3 = ProfileUtil.getInstance().getPrefString("userId");
        String string4 = ProfileUtil.getInstance().getPrefString("com.brytonsport.active.loginToken");
        String string5 = TAG;
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("getActivityFileByDetailPage \u53d6\u5f97fit\u6a94: ");
        stringBuilder.append(ParserUtil.fileIdToFormatString(l));
        stringBuilder.append(".fit");
        Log.d((String)string5, (String)stringBuilder.toString());
        this.brytonActivityApi.getActivityFit(string3, string4, string2).enqueue((Callback)new Callback<ResponseBody>(){

            public void onFailure(Call<ResponseBody> call, Throwable throwable) {
                Log.e((String)TAG, (String)"error");
                ActivityRepository.this.activityFitDownloadSuccessLive.postValue(false);
            }

            public void onResponse(Call<ResponseBody> object, Response<ResponseBody> object2) {
                boolean bl = object2.isSuccessful();
                object = false;
                if (bl) {
                    Object object3 = App.getInstance();
                    object2 = (ResponseBody)object2.body();
                    StringBuilder stringBuilder = new StringBuilder();
                    stringBuilder.append(string3);
                    stringBuilder.append("/fit");
                    String string2 = stringBuilder.toString();
                    stringBuilder = new StringBuilder();
                    stringBuilder.append(ParserUtil.fileIdToFormatString(l));
                    stringBuilder.append(".fit");
                    bl = ActivityFileUtil.writeResponseBodyToDisk((Context)object3, (ResponseBody)object2, string2, stringBuilder.toString());
                    object3 = TAG;
                    object2 = new StringBuilder();
                    ((StringBuilder)object2).append(ParserUtil.fileIdToFormatString(l));
                    ((StringBuilder)object2).append(".fit save success? ");
                    ((StringBuilder)object2).append(bl);
                    Log.d((String)object3, (String)((StringBuilder)object2).toString());
                    if (bl) {
                        ActivityRepository.this.activityFitDownloadSuccessLive.postValue(true);
                    } else {
                        ActivityRepository.this.activityFitDownloadSuccessLive.postValue(object);
                    }
                } else {
                    Log.d((String)TAG, (String)"server contact failed");
                    ActivityRepository.this.activityFitDownloadSuccessLive.postValue(object);
                }
            }
        });
    }

    public SingleLiveEvent<Boolean> getActivityFitDownloadSuccessLive() {
        return this.activityFitDownloadSuccessLive;
    }

    public LiveData<Resource<List<ActivityEntity>>> getActivityList() {
        return new NetworkBoundResource<List<ActivityEntity>, List<ActivityEntity>>(){
            private List<ActivityEntity> resultsDb;

            @Override
            protected LiveData<ApiResponse<List<ActivityEntity>>> createCall() {
                String string2 = ProfileUtil.getInstance().getPrefString("userId");
                String string3 = ProfileUtil.getInstance().getPrefString("com.brytonsport.active.loginToken");
                int n = (Integer)ProfileUtil.getInstance().get("activityListTimestamp");
                String string4 = TAG;
                StringBuilder stringBuilder = new StringBuilder();
                stringBuilder.append("createCall: \u5f9e\u7db2\u8def\u53d6\u5f97\u8cc7\u6599 timeStamp: ");
                stringBuilder.append(n);
                Log.d((String)string4, (String)stringBuilder.toString());
                return ActivityRepository.this.brytonActivityApi.getActivityList(string2, string3, n, 10000);
            }

            public /* synthetic */ void lambda$saveCallResult$0$com-brytonsport-active-repo-result-ActivityRepository$5(List list) {
                Log.d((String)TAG, (String)"timeStamp\u70ba0, \u904e\u6ffe\u6389_deleted \u7684\u7b46\u6578: \u904e\u6ffe\u5b8c\u5df2\u522a\u9664\u7684\u8cc7\u6599\uff0c\u5b58\u5165DB");
                ActivityRepository.this.insertActivityListToDb(list);
            }

            public /* synthetic */ void lambda$saveCallResult$1$com-brytonsport-active-repo-result-ActivityRepository$5(List list) {
                Object object;
                Object object2 = list.iterator();
                int n = 0;
                while (object2.hasNext()) {
                    object = (ActivityEntity)object2.next();
                    if (((ActivityEntity)object).getName().equals("_deleted")) {
                        ++n;
                        ActivityRepository.this.loadActivityToDeleteToDb(((ActivityEntity)object).get_id());
                        continue;
                    }
                    ActivityRepository.this.insertActivityToDb((ActivityEntity)object);
                }
                object = TAG;
                object2 = new StringBuilder();
                ((StringBuilder)object2).append("\u66f4\u65b0getActivityList(server), _deleted \u7684\u7b46\u6578: ");
                ((StringBuilder)object2).append(n);
                ((StringBuilder)object2).append("\uff0c\u65b0\u589e\u7684\u7b46\u6578: ");
                ((StringBuilder)object2).append(list.size() - n);
                Log.d((String)object, (String)((StringBuilder)object2).toString());
            }

            @Override
            protected LiveData<List<ActivityEntity>> loadFromDb() {
                return ActivityRepository.this.brytonActivityDao.loadActivityListByLocalStartTime(ActivityRepository.this.loadActivityListLimitNum);
            }

            @Override
            protected void saveCallResult(List<ActivityEntity> list) {
                String string2 = TAG;
                StringBuilder stringBuilder = new StringBuilder();
                stringBuilder.append("saveCallResult getActivityList(server) \u66f4\u65b0\u7b46\u6578: ");
                stringBuilder.append(list.size());
                Log.d((String)string2, (String)stringBuilder.toString());
                if ((Integer)ProfileUtil.getInstance().get("activityListTimestamp") == 0) {
                    for (int i = list.size() - 1; i >= 0; --i) {
                        if (!list.get(i).getName().equals("_deleted")) continue;
                        list.remove(i);
                    }
                    string2 = TAG;
                    stringBuilder = new StringBuilder();
                    stringBuilder.append("timeStamp\u70ba0, \u904e\u6ffe\u6389_deleted \u5f8c\u7684\u7b46\u6578: ");
                    stringBuilder.append(list.size());
                    Log.d((String)string2, (String)stringBuilder.toString());
                    new Thread(new ActivityRepository$5$$ExternalSyntheticLambda0(this, list)).start();
                } else {
                    Log.d((String)TAG, (String)"timeStamp\u4e0d\u70ba0, \u7b2c\u4e8c\u6b21\u5f8c: ");
                    new Thread(new ActivityRepository$5$$ExternalSyntheticLambda1(this, list)).start();
                }
            }

            @Override
            protected boolean shouldFetch(List<ActivityEntity> list) {
                boolean bl = list == null || list.size() == 0;
                if (bl) {
                    Log.d((String)TAG, (String)"shouldFetch: db \u6c92\u6709\u8cc7\u6599\u8981\u5f9e\u7db2\u8def\u53d6\u5f97");
                } else {
                    Log.d((String)TAG, (String)"shouldFetch: db \u5df2\u7d93\u6709\u8cc7\u6599\u4e86");
                }
                return true;
            }
        }.asLiveData();
    }

    public SingleLiveEvent<Integer> getActivityListCountLive() {
        return this.activityListCountLive;
    }

    public LiveData<List<ActivityEntity>> getActivityListFromDb(int n) {
        return this.brytonActivityDao.loadActivityListByLocalStartTime(n);
    }

    public void getActivityListFromServer() {
        try {
            this.semaphore.acquire();
        }
        catch (InterruptedException interruptedException) {
            interruptedException.printStackTrace();
            FirebaseCustomUtil.getInstance().setCustomLogMessage("getActivityListFromServer \u53d6\u5f97Semaphore\u5931\u6557");
        }
        String string2 = ProfileUtil.getInstance().getPrefString("userId");
        String string3 = ProfileUtil.getInstance().getPrefString("com.brytonsport.active.loginToken");
        int n = (Integer)ProfileUtil.getInstance().get("activityListTimestamp");
        String string4 = TAG;
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("getActivityListFromServer: \u5f9e\u7db2\u8def\u53d6\u5f97\u8cc7\u6599 timeStamp: ");
        stringBuilder.append(n);
        Log.d((String)string4, (String)stringBuilder.toString());
        final int n2 = TimeUtilByLee.getCurrentUtcTime();
        if (!App.getInstance().nowSyncingFitUploadState && n2 - n > 5) {
            stringBuilder = new StringBuilder();
            stringBuilder.append("\u53d6\u5f97server \u6d3b\u52d5\u6e05\u55ae [\u958b\u59cb]: getActivityListFromServer: ");
            stringBuilder.append(new Date());
            Log.d((String)string4, (String)stringBuilder.toString());
            this.brytonActivityApi.getActivityListFromServer(string2, string3, n, 10000).enqueue((Callback)new Callback<List<ActivityEntity>>(){

                public void onFailure(Call<List<ActivityEntity>> call, Throwable throwable) {
                    Log.e((String)TAG, (String)"getActivityListFromServer onFailure: ", (Throwable)throwable);
                    ActivityRepository.this.semaphore.release();
                    ActivityRepository.this.activityListCountLive.postValue(-1);
                }

                public void onResponse(Call<List<ActivityEntity>> object, Response<List<ActivityEntity>> object2) {
                    if (object2.isSuccessful()) {
                        Log.d((String)TAG, (String)" \u5f9e\u6a5f\u5668\u540c\u6b65Fit \u5230app \u5b8c\u6210: \u547c\u53ebserver \u53d6\u5f97\u6d3b\u52d5\u6e05\u55ae\u6210\u529f");
                        object = (List)object2.body();
                        object2 = TAG;
                        StringBuilder stringBuilder = new StringBuilder();
                        stringBuilder.append("getActivityListFromServer: \u53d6\u5f97\u7b46\u6578: ");
                        stringBuilder.append(object.size());
                        Log.d(object2, (String)stringBuilder.toString());
                        object2 = TAG;
                        stringBuilder = new StringBuilder();
                        stringBuilder.append("\u53d6\u5f97server \u6d3b\u52d5\u6e05\u55ae [\u5f9eserver\u62ff\u5230\u7d50\u679c] onResponse: ");
                        stringBuilder.append(new Date());
                        Log.d(object2, (String)stringBuilder.toString());
                        ActivityRepository.this.prepareActivityListToDb((List)object);
                        ProfileUtil.getInstance().set("activityListTimestamp", n2);
                    } else {
                        ActivityRepository.this.liveAccountErrorResponse.postValue(ErrorUtils.getErrorVo(object2));
                        object = TAG;
                        StringBuilder stringBuilder = new StringBuilder();
                        stringBuilder.append("getActivityListFromServer response.code(): ");
                        stringBuilder.append(object2.code());
                        Log.d((String)object, (String)stringBuilder.toString());
                        ActivityRepository.this.semaphore.release();
                        ActivityRepository.this.activityListCountLive.postValue(-1);
                    }
                }
            });
            return;
        }
        this.semaphore.release();
    }

    public LiveData<List<ActivityEntity>> getActivityListStartAndEndTimeFromDb(int n, int n2) {
        return this.brytonActivityDao.loadActivityListBetweenStartAndEndTime(n, n2);
    }

    public MutableLiveData<Boolean> getEditActivityNameSuccessLive() {
        return this.editActivityNameSuccessLive;
    }

    public int getFitProcessCount() {
        return this.fitOnGoingCnt;
    }

    public MutableLiveData<Boolean> getIsLogUploadLiveData() {
        return this.isLogUploadLiveData;
    }

    public MutableLiveData<AccountErrorVo> getLiveAccountErrorResponse() {
        return this.liveAccountErrorResponse;
    }

    public AccountUserInfo getUserInfoFromDb() {
        String string2 = (String)ProfileUtil.getInstance().get("userId");
        return this.userInfoDao.loadAccountUserInfoByUserId(string2);
    }

    public /* synthetic */ void lambda$decodeActivityFit$3$com-brytonsport-active-repo-result-ActivityRepository(String string2, String charSequence, String string3, DayActivity dayActivity) {
        String string4 = TAG;
        Object object = new StringBuilder();
        ((StringBuilder)object).append("\u6ce8\u610f Thread getActivityFile \u53d6\u5f97fit \u6210\u529f\u6e96\u5099decode: ");
        ((StringBuilder)object).append(string2);
        ((StringBuilder)object).append(".fit");
        Log.d((String)string4, (String)((StringBuilder)object).toString());
        object = App.getInstance().getFilesDir();
        Object object2 = new StringBuilder();
        ((StringBuilder)object2).append(object);
        ((StringBuilder)object2).append(File.separator);
        ((StringBuilder)object2).append((String)charSequence);
        ((StringBuilder)object2).append(File.separator);
        ((StringBuilder)object2).append(string2);
        ((StringBuilder)object2).append(".fit");
        object = ((StringBuilder)object2).toString();
        object2 = new BrytonActivity();
        ((BrytonActivity)object2).encodeFileSet((String)object);
        JSONObject jSONObject = new JSONObject();
        DeviceManagerEntity deviceManagerEntity = DeviceRepository.getInstance().loadDeviceIsChoice();
        object = this.getUserInfoFromDb();
        object = object != null && ((AccountUserInfo)object).getServices() != null ? ((AccountUserInfo)object).getServices().getStrava() : null;
        try {
            if (((BrytonActivity)object2).decode(this, jSONObject, string2, (String)charSequence, deviceManagerEntity, (Strava)object) == BrytonActivity.DecodeResult.SUCCESS) {
                charSequence = new StringBuilder();
                ((StringBuilder)charSequence).append("");
                ((StringBuilder)charSequence).append(string2);
                ((StringBuilder)charSequence).append(" decode ok");
                Log.d((String)string4, (String)((StringBuilder)charSequence).toString());
                this.fitDecodeOk(string3, jSONObject, string2, dayActivity);
            } else {
                this.countUploadFit2Server(NetworkUtil.ApiResultState.FAILURE);
                charSequence = new StringBuilder();
                ((StringBuilder)charSequence).append("");
                ((StringBuilder)charSequence).append(string2);
                ((StringBuilder)charSequence).append(" decode error");
                Log.d((String)string4, (String)((StringBuilder)charSequence).toString());
                this.removeGettingActivityId(string3);
                Log.d((String)string4, (String)"\u5c07\u6b63\u5728\u7522\u751f\u7e2e\u5716\u72c0\u614b\u6e05\u9664: decodeActivityFit -> decode error");
                this.removeActivityIsGenImageIng(dayActivity);
            }
        }
        catch (Exception exception) {
            this.countUploadFit2Server(NetworkUtil.ApiResultState.FAILURE);
            object = TAG;
            charSequence = new StringBuilder();
            ((StringBuilder)charSequence).append("");
            ((StringBuilder)charSequence).append(string2);
            ((StringBuilder)charSequence).append(" decode Exception: ");
            ((StringBuilder)charSequence).append(exception.getMessage());
            Log.d((String)object, (String)((StringBuilder)charSequence).toString());
            this.removeGettingActivityId(string3);
            Log.d((String)object, (String)"\u5c07\u6b63\u5728\u7522\u751f\u7e2e\u5716\u72c0\u614b\u6e05\u9664: decodeActivityFit -> Exception");
            this.removeActivityIsGenImageIng(dayActivity);
        }
    }

    public /* synthetic */ void lambda$fitDecodeOk$4$com-brytonsport-active-repo-result-ActivityRepository(String string2, JSONArray jSONArray, String string3, DayActivity dayActivity) {
        this.getStaticMap(string2, jSONArray, string3, dayActivity);
    }

    public /* synthetic */ void lambda$getActivityFile$2$com-brytonsport-active-repo-result-ActivityRepository(final Long l, final String string2, final DayActivity dayActivity) {
        final String string3 = ProfileUtil.getInstance().getPrefString("userId");
        String string4 = ProfileUtil.getInstance().getPrefString("com.brytonsport.active.loginToken");
        String string5 = TAG;
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("\u6ce8\u610f Thread getActivityFile \u53d6\u5f97fit\u9ee8: ");
        stringBuilder.append(ParserUtil.fileIdToFormatString(l));
        stringBuilder.append(".fit");
        Log.d((String)string5, (String)stringBuilder.toString());
        this.brytonActivityApi.getActivityFit(string3, string4, string2).enqueue((Callback)new Callback<ResponseBody>(){

            public void onFailure(Call<ResponseBody> call, Throwable throwable) {
                Log.e((String)TAG, (String)"error");
                ActivityRepository.this.countUploadFit2Server(NetworkUtil.ApiResultState.TIMEOUT);
                ActivityRepository.this.removeGettingActivityId(string2);
                Log.d((String)TAG, (String)"\u5c07\u6b63\u5728\u7522\u751f\u7e2e\u5716\u72c0\u614b\u6e05\u9664: getActivityFile -> onFailure");
                ActivityRepository.this.removeActivityIsGenImageIng(dayActivity);
            }

            public void onResponse(Call<ResponseBody> object, Response<ResponseBody> object2) {
                if (object2.isSuccessful()) {
                    object = App.getInstance();
                    object2 = (ResponseBody)object2.body();
                    CharSequence charSequence = new StringBuilder();
                    charSequence.append(string3);
                    charSequence.append("/fit");
                    String string22 = charSequence.toString();
                    charSequence = new StringBuilder();
                    charSequence.append(ParserUtil.fileIdToFormatString(l));
                    charSequence.append(".fit");
                    boolean bl = ActivityFileUtil.writeResponseBodyToDisk(object, (ResponseBody)object2, string22, charSequence.toString());
                    object2 = TAG;
                    object = new StringBuilder();
                    ((StringBuilder)object).append(ParserUtil.fileIdToFormatString(l));
                    ((StringBuilder)object).append(".fit save success \u6ce8\u610f? ");
                    ((StringBuilder)object).append(bl);
                    Log.d((String)object2, (String)((StringBuilder)object).toString());
                    if (bl) {
                        object = ActivityRepository.this;
                        charSequence = string2;
                        object2 = new StringBuilder();
                        ((StringBuilder)object2).append(string3);
                        ((StringBuilder)object2).append(File.separator);
                        ((StringBuilder)object2).append("fit");
                        ((ActivityRepository)object).decodeActivityFit((String)charSequence, ((StringBuilder)object2).toString(), ParserUtil.fileIdToFormatString(l), dayActivity);
                    }
                } else {
                    Log.d((String)TAG, (String)"server contact failed");
                    ActivityRepository.this.countUploadFit2Server(NetworkUtil.ApiResultState.FAILURE);
                    ActivityRepository.this.removeGettingActivityId(string2);
                    Log.d((String)TAG, (String)"\u5c07\u6b63\u5728\u7522\u751f\u7e2e\u5716\u72c0\u614b\u6e05\u9664: getActivityFile -> onResponse error");
                    ActivityRepository.this.removeActivityIsGenImageIng(dayActivity);
                }
            }
        });
    }

    public /* synthetic */ void lambda$prepareActivityListToDb$0$com-brytonsport-active-repo-result-ActivityRepository(List list) {
        String string2 = TAG;
        Log.d((String)string2, (String)"timeStamp\u70ba0, \u904e\u6ffe\u6389_deleted \u7684\u7b46\u6578: \u904e\u6ffe\u5b8c\u5df2\u522a\u9664\u7684\u8cc7\u6599\uff0c\u5b58\u5165DB");
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("\u53d6\u5f97server \u6d3b\u52d5\u6e05\u55ae [timeStamp\u70ba0, \u904e\u6ffe\u6389_deleted \u7684\u7b46\u6578] \u6e96\u5099\u5b58\u5165DB\uff0c\u7b46\u6578: ");
        stringBuilder.append(list.size());
        Log.d((String)string2, (String)stringBuilder.toString());
        if (list.size() > 0) {
            this.activityListCountLive.postValue(2);
        } else {
            this.activityListCountLive.postValue(1);
        }
        this.insertActivityListToDb(list);
        this.semaphore.release();
    }

    public /* synthetic */ void lambda$prepareActivityListToDb$1$com-brytonsport-active-repo-result-ActivityRepository(List list) {
        Object object;
        Object object2 = list.iterator();
        int n = 0;
        while (object2.hasNext()) {
            object = (ActivityEntity)object2.next();
            if (((ActivityEntity)object).getName().equals("_deleted")) {
                ++n;
                this.loadActivityToDeleteToDb(((ActivityEntity)object).get_id());
                continue;
            }
            this.insertActivityToDb((ActivityEntity)object);
        }
        int n2 = this.brytonActivityDao.loadActivityListCount();
        object = TAG;
        object2 = new StringBuilder();
        ((StringBuilder)object2).append("\u53d6\u5f97\u6d3b\u52d5\u7d00\u9304 prepareActivityListToDb actListCount: ");
        ((StringBuilder)object2).append(n2);
        Log.d((String)object, (String)((StringBuilder)object2).toString());
        object2 = new StringBuilder();
        ((StringBuilder)object2).append("\u53d6\u5f97server \u6d3b\u52d5\u6e05\u55ae [timeStamp\u4e0d\u70ba0, \u7b2c\u4e8c\u6b21\u5f8c] \u6e96\u5099\u5b58\u5165DB\uff0c\u7b46\u6578: ");
        ((StringBuilder)object2).append(n2);
        Log.d((String)object, (String)((StringBuilder)object2).toString());
        if (n2 > 0) {
            this.activityListCountLive.postValue(4);
        } else {
            this.activityListCountLive.postValue(3);
        }
        this.semaphore.release();
        object2 = new StringBuilder();
        ((StringBuilder)object2).append("\u53d6\u5f97\u6d3b\u52d5\u7d00\u9304 \u66f4\u65b0getActivityList(server), _deleted \u7684\u7b46\u6578: ");
        ((StringBuilder)object2).append(n);
        ((StringBuilder)object2).append("\uff0c\u65b0\u589e\u7684\u7b46\u6578: ");
        ((StringBuilder)object2).append(list.size() - n);
        Log.d((String)object, (String)((StringBuilder)object2).toString());
    }

    public /* synthetic */ void lambda$updateMapImageToDb$6$com-brytonsport-active-repo-result-ActivityRepository(List object, Map map) {
        List<ActivityEntity> list = AppDatabase.getInstance((Context)App.getInstance()).brytonActivityDao().loadActivityByIdList((List<String>)object);
        if (list != null) {
            for (ActivityEntity activityEntity : list) {
                if (!map.containsKey(activityEntity.get_id())) continue;
                activityEntity.setMapImage((String)map.get(activityEntity.get_id()));
            }
            AppDatabase.getInstance((Context)App.getInstance()).brytonActivityDao().insertActivityList(list);
        }
        this.activityCountsNextLive.postValue(true);
    }

    public void resetUploadData() {
        this.deleteActivityOkCount = 0;
        this.activityCountsNextLive = new MutableLiveData();
        this.activityDeleteResultLive = new MutableLiveData();
        this.editActivityNameSuccessLive = new MutableLiveData();
        this.activityFitDownloadSuccessLive = new SingleLiveEvent();
        this.activityDeleteResultText = new MutableLiveData();
    }

    public JSONArray shrinkSameple(JSONArray jSONArray, int n, String string2) {
        String string3 = TAG;
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("");
        stringBuilder.append(string2);
        stringBuilder.append(" shrinkSameple size: ");
        stringBuilder.append(jSONArray.length());
        stringBuilder.append(", \u8981\u7e2e\u6210\u5e7e\u7b46: ");
        stringBuilder.append(n);
        Log.d((String)string3, (String)stringBuilder.toString());
        int n2 = jSONArray.length();
        int n3 = n2 / n;
        if (n2 <= n) {
            return jSONArray;
        }
        string2 = new JSONArray();
        for (n = 0; n < n2; ++n) {
            if (n % n3 == 0) {
                string2.put((Object)jSONArray.getJSONObject(n));
                continue;
            }
            if (n != n2 - 1) continue;
            try {
                string2.put((Object)jSONArray.getJSONObject(n));
            }
            catch (JSONException jSONException) {
                jSONException.printStackTrace();
                break;
            }
            continue;
        }
        return string2;
    }

    public void uploadActivityLogToServer(final String string2, String object, String string3, JSONObject jSONObject) {
        String string4 = ProfileUtil.getInstance().getPrefString("userId");
        File file = App.getInstance().getFilesDir();
        Comparable<StringBuilder> comparable = new StringBuilder();
        ((StringBuilder)comparable).append(file);
        ((StringBuilder)comparable).append(File.separator);
        ((StringBuilder)comparable).append((String)object);
        ((StringBuilder)comparable).append(File.separator);
        ((StringBuilder)comparable).append(string2);
        ((StringBuilder)comparable).append(".fit");
        comparable = new File(((StringBuilder)comparable).toString());
        object = RequestBody.create((MediaType)MediaType.parse((String)"*/*"), (File)comparable);
        comparable = MultipartBody.Part.createFormData((String)"track", (String)((File)comparable).getName(), (RequestBody)object);
        object = new HashMap();
        if (string3 != null && !string3.isEmpty()) {
            object.put("name", RequestBody.create((MediaType)MediaType.parse((String)"text/plain"), (String)string3));
        }
        if (jSONObject != null) {
            object.put("info", RequestBody.create((MediaType)MediaType.parse((String)"text/plain"), (String)jSONObject.toString()));
        }
        this.brytonActivityApi.uploadActivityLogToServer(string4, (MultipartBody.Part)comparable, (Map<String, RequestBody>)object).enqueue((Callback)new Callback<ResponseBody>(){

            public void onFailure(Call<ResponseBody> object, Throwable throwable) {
                object = new StringBuilder();
                ((StringBuilder)object).append("uploadActivityLogToServer -> ");
                ((StringBuilder)object).append(string2);
                ((StringBuilder)object).append(" onFailure : ");
                ((StringBuilder)object).append(throwable.getMessage());
                object = ((StringBuilder)object).toString();
                Log.d((String)TAG, (String)object);
                ActivityRepository.this.isLogUploadLiveData.postValue(false);
            }

            public void onResponse(Call<ResponseBody> object, Response<ResponseBody> object2) {
                if (object2.isSuccessful()) {
                    CharSequence charSequence = NetworkUtil.parseResponseBody(object2);
                    if (object2.body() != null) {
                        try {
                            object = new JSONObject((String)charSequence);
                            object.getString("fileid").isEmpty();
                            ActivityRepository.this.isLogUploadLiveData.postValue(true);
                            object2 = TAG;
                            charSequence = new StringBuilder();
                            ((StringBuilder)charSequence).append("uploadActivityLogToServer onResponse: resultObj -> ");
                            ((StringBuilder)charSequence).append(object.toString());
                            Log.d(object2, (String)((StringBuilder)charSequence).toString());
                        }
                        catch (JSONException jSONException) {
                            jSONException.printStackTrace();
                        }
                    }
                } else {
                    object2 = NetworkUtil.parseResponseErrorBody(object2);
                    object = new StringBuilder();
                    object.append("uploadActivityLogToServer ->upload ");
                    object.append(string2);
                    object.append(" to server error: ");
                    object.append((String)object2);
                    object = object.toString();
                    ActivityRepository.this.isLogUploadLiveData.postValue(false);
                    Log.d((String)TAG, (String)object);
                }
            }
        });
    }
}

