/*
 * Decompiled with CFR 0.152.
 */
package com.brytonsport.active.repo.setting;

import android.util.Log;
import androidx.lifecycle.LiveData;
import androidx.lifecycle.MutableLiveData;
import com.brytonsport.active.base.App;
import com.brytonsport.active.db.AppDatabase;
import com.brytonsport.active.db.setting.dao.DeviceManagerDao;
import com.brytonsport.active.db.setting.entity.DeviceManagerEntity;
import com.brytonsport.active.repo.setting.DeviceRepository$$ExternalSyntheticLambda0;
import com.brytonsport.active.repo.setting.DeviceRepository$$ExternalSyntheticLambda1;
import com.brytonsport.active.repo.setting.DeviceRepository$$ExternalSyntheticLambda10;
import com.brytonsport.active.repo.setting.DeviceRepository$$ExternalSyntheticLambda2;
import com.brytonsport.active.repo.setting.DeviceRepository$$ExternalSyntheticLambda3;
import com.brytonsport.active.repo.setting.DeviceRepository$$ExternalSyntheticLambda4;
import com.brytonsport.active.repo.setting.DeviceRepository$$ExternalSyntheticLambda5;
import com.brytonsport.active.repo.setting.DeviceRepository$$ExternalSyntheticLambda6;
import com.brytonsport.active.repo.setting.DeviceRepository$$ExternalSyntheticLambda7;
import com.brytonsport.active.repo.setting.DeviceRepository$$ExternalSyntheticLambda8;
import com.brytonsport.active.repo.setting.DeviceRepository$$ExternalSyntheticLambda9;
import com.brytonsport.active.utils.BleUtil;
import com.brytonsport.active.utils.FeatureUtil;
import com.brytonsport.active.utils.FirmwareVersionUtil;
import com.brytonsport.active.vm.base.Device;
import java.util.List;
import javax.inject.Inject;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class DeviceRepository {
    static final String TAG = "DeviceRepository";
    private static DeviceRepository singleton;
    private final MutableLiveData<String> deviceFirmVerLiveData;
    private final DeviceManagerDao deviceManagerDao;
    private final MutableLiveData<Boolean> isDeviceAlreadyConnectedLive = new MutableLiveData();
    private final MutableLiveData<Integer> isDeviceFeatureSupportLive = new MutableLiveData();

    @Inject
    public DeviceRepository() {
        this.deviceFirmVerLiveData = new MutableLiveData();
        this.deviceManagerDao = AppDatabase.getInstance(App.getInstance().getApplicationContext()).deviceManagerDao();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static DeviceRepository getInstance() {
        if (singleton != null) return singleton;
        synchronized (DeviceRepository.class) {
            DeviceRepository deviceRepository;
            if (singleton != null) return singleton;
            singleton = deviceRepository = new DeviceRepository();
            return singleton;
        }
    }

    public void delete(String string2) {
        new Thread(new DeviceRepository$$ExternalSyntheticLambda9(this, string2)).start();
    }

    public void deleteAllData() {
        this.deviceManagerDao.deleteAll();
    }

    public void deviceFeatureSupport(FeatureUtil.FeatureType featureType) {
        new Thread(new DeviceRepository$$ExternalSyntheticLambda5(this, featureType)).start();
    }

    public int deviceFeatureSupportSync(FeatureUtil.FeatureType featureType) {
        boolean bl;
        Object object = this.deviceManagerDao.loadDeviceEntityIsChoice();
        if (object != null && !((DeviceManagerEntity)object).getMacAddress().isEmpty()) {
            bl = BleUtil.getInstance().isDeviceAlreadyConnected(((DeviceManagerEntity)object).getMacAddress());
            object = ((DeviceManagerEntity)object).getDevUuid();
        } else {
            bl = false;
            object = "";
        }
        return FeatureUtil.isSupport(featureType, (String)object, bl);
    }

    public int deviceFeatureSupportSyncForAllDevices(FeatureUtil.FeatureType featureType) {
        int n;
        List<DeviceManagerEntity> list = this.deviceManagerDao.loadDeviceManagerList();
        int n2 = n = 0;
        if (list != null) {
            n2 = n;
            if (list.size() > 0) {
                n2 = 0;
                for (n = 0; n < list.size(); ++n) {
                    DeviceManagerEntity deviceManagerEntity = list.get(n);
                    boolean bl = featureType.equals((Object)FeatureUtil.FeatureType.LiveTrack) ? deviceManagerEntity.isSptLiveTrack() : (featureType.equals((Object)FeatureUtil.FeatureType.GroupRide) ? deviceManagerEntity.isSptGroupRide() : false);
                    if (!bl) continue;
                    n2 = 1;
                }
            }
        }
        return n2;
    }

    public String getConnectedDeviceName() {
        Object object = this.deviceManagerDao.loadDeviceEntityIsChoice();
        object = object != null && !((DeviceManagerEntity)object).getMacAddress().isEmpty() ? ((DeviceManagerEntity)object).getDevName() : "";
        return object;
    }

    public String getConnectedDeviceUuid() {
        Object object = this.deviceManagerDao.loadDeviceEntityIsChoice();
        object = object != null && !((DeviceManagerEntity)object).getMacAddress().isEmpty() ? ((DeviceManagerEntity)object).getDevUuid() : "";
        return object;
    }

    public MutableLiveData<String> getDeviceFirmVerLiveData() {
        return this.deviceFirmVerLiveData;
    }

    public void getDeviceInfoFromDb() {
        new Thread(new DeviceRepository$$ExternalSyntheticLambda0(this)).start();
    }

    public MutableLiveData<Boolean> getIsDeviceAlreadyConnectedLive() {
        return this.isDeviceAlreadyConnectedLive;
    }

    public MutableLiveData<Integer> getIsDeviceFeatureSupportLive() {
        return this.isDeviceFeatureSupportLive;
    }

    public void insert(DeviceManagerEntity deviceManagerEntity) {
        new Thread(new DeviceRepository$$ExternalSyntheticLambda3(this, deviceManagerEntity)).start();
    }

    public void isDeviceAlreadyConnected() {
        new Thread(new DeviceRepository$$ExternalSyntheticLambda2(this)).start();
    }

    public boolean isDeviceAlreadyConnectedSync() {
        DeviceManagerEntity deviceManagerEntity = this.deviceManagerDao.loadDeviceEntityIsChoice();
        boolean bl = deviceManagerEntity != null && !deviceManagerEntity.getMacAddress().isEmpty() ? BleUtil.getInstance().isDeviceAlreadyConnected(deviceManagerEntity.getMacAddress()) : false;
        return bl;
    }

    public /* synthetic */ void lambda$delete$3$com-brytonsport-active-repo-setting-DeviceRepository(String object) {
        if ((object = this.deviceManagerDao.loadDeviceEntityByAddress((String)object)) != null) {
            this.deviceManagerDao.delete((DeviceManagerEntity)object);
        }
    }

    public /* synthetic */ void lambda$deviceFeatureSupport$9$com-brytonsport-active-repo-setting-DeviceRepository(FeatureUtil.FeatureType featureType) {
        boolean bl;
        Object object = this.deviceManagerDao.loadDeviceEntityIsChoice();
        if (object != null && !((DeviceManagerEntity)object).getMacAddress().isEmpty()) {
            bl = BleUtil.getInstance().isDeviceAlreadyConnected(((DeviceManagerEntity)object).getMacAddress());
            object = ((DeviceManagerEntity)object).getDevUuid();
        } else {
            bl = false;
            object = "";
        }
        this.isDeviceFeatureSupportLive.postValue(FeatureUtil.isSupport(featureType, (String)object, bl));
    }

    public /* synthetic */ void lambda$getDeviceInfoFromDb$10$com-brytonsport-active-repo-setting-DeviceRepository() {
        Object object = this.deviceManagerDao.loadDeviceEntityIsChoice();
        String string2 = "";
        if (object != null && !((DeviceManagerEntity)object).getMacAddress().isEmpty()) {
            BleUtil.getInstance().isDeviceAlreadyConnected(((DeviceManagerEntity)object).getMacAddress());
            object = ((DeviceManagerEntity)object).getDevVersion();
        } else {
            object = "";
        }
        object = ((String)object).isEmpty() ? string2 : FirmwareVersionUtil.getLangVersionByFirmVer((String)object);
        this.deviceFirmVerLiveData.postValue((String)object);
    }

    public /* synthetic */ void lambda$insert$0$com-brytonsport-active-repo-setting-DeviceRepository(DeviceManagerEntity deviceManagerEntity) {
        for (DeviceManagerEntity deviceManagerEntity2 : this.deviceManagerDao.loadDeviceManagerList()) {
            deviceManagerEntity2.setChoices(false);
            this.deviceManagerDao.update(deviceManagerEntity2);
        }
        if (deviceManagerEntity.getMacAddress() != null && !deviceManagerEntity.getMacAddress().isEmpty()) {
            this.deviceManagerDao.insert(deviceManagerEntity);
        }
    }

    public /* synthetic */ void lambda$isDeviceAlreadyConnected$8$com-brytonsport-active-repo-setting-DeviceRepository() {
        DeviceManagerEntity deviceManagerEntity = this.deviceManagerDao.loadDeviceEntityIsChoice();
        if (deviceManagerEntity != null && !deviceManagerEntity.getMacAddress().isEmpty()) {
            boolean bl = BleUtil.getInstance().isDeviceAlreadyConnected(deviceManagerEntity.getMacAddress());
            this.isDeviceAlreadyConnectedLive.postValue(bl);
        } else {
            this.isDeviceAlreadyConnectedLive.postValue(false);
        }
    }

    public /* synthetic */ void lambda$update$1$com-brytonsport-active-repo-setting-DeviceRepository(DeviceManagerEntity deviceManagerEntity) {
        this.deviceManagerDao.update(deviceManagerEntity);
    }

    public /* synthetic */ void lambda$updateDeviceActiveState$4$com-brytonsport-active-repo-setting-DeviceRepository(Device device) {
        for (DeviceManagerEntity deviceManagerEntity : this.deviceManagerDao.loadDeviceManagerList()) {
            if (deviceManagerEntity.getMacAddress().equals(device.macAddress)) {
                deviceManagerEntity.setChoices(true);
                deviceManagerEntity.setDevUuid(device.uuid);
                deviceManagerEntity.setDevVersion(device.firmware);
            } else {
                deviceManagerEntity.setChoices(false);
            }
            this.deviceManagerDao.update(deviceManagerEntity);
        }
    }

    public /* synthetic */ void lambda$updateDeviceConnectState$5$com-brytonsport-active-repo-setting-DeviceRepository(Device device) {
        for (DeviceManagerEntity deviceManagerEntity : this.deviceManagerDao.loadDeviceManagerList()) {
            if (deviceManagerEntity.getMacAddress().equals(device.macAddress)) {
                deviceManagerEntity.setConnected(false);
            }
            this.deviceManagerDao.update(deviceManagerEntity);
        }
    }

    public /* synthetic */ void lambda$updateDeviceConnectState$6$com-brytonsport-active-repo-setting-DeviceRepository(String string2, boolean bl) {
        for (DeviceManagerEntity deviceManagerEntity : this.deviceManagerDao.loadDeviceManagerList()) {
            if (!deviceManagerEntity.getMacAddress().equals(string2)) continue;
            deviceManagerEntity.setConnected(bl);
            this.deviceManagerDao.update(deviceManagerEntity);
        }
    }

    public /* synthetic */ void lambda$updateDeviceInfo$7$com-brytonsport-active-repo-setting-DeviceRepository(Device device) {
        for (DeviceManagerEntity deviceManagerEntity : this.deviceManagerDao.loadDeviceManagerList()) {
            if (deviceManagerEntity.getMacAddress().equals(device.macAddress)) {
                deviceManagerEntity.setDevVersion(device.firmware);
                deviceManagerEntity.setDevUuid(device.uuid);
                deviceManagerEntity.setCapability(device.capability);
                if (!device.deviceName.isEmpty()) {
                    deviceManagerEntity.setDevName(device.deviceName);
                }
            }
            this.deviceManagerDao.update(deviceManagerEntity);
        }
    }

    public /* synthetic */ void lambda$updateLtGrFeature$2$com-brytonsport-active-repo-setting-DeviceRepository(boolean bl, boolean bl2) {
        DeviceManagerEntity deviceManagerEntity = this.deviceManagerDao.loadDeviceEntityIsChoice();
        if (deviceManagerEntity != null && !deviceManagerEntity.getMacAddress().isEmpty() && BleUtil.getInstance().isDeviceAlreadyConnected(deviceManagerEntity.getMacAddress())) {
            deviceManagerEntity.setSptLiveTrack(bl);
            deviceManagerEntity.setSptGroupRide(bl2);
            this.deviceManagerDao.update(deviceManagerEntity);
        }
    }

    public DeviceManagerEntity loadDeviceIsChoice() {
        Log.d((String)TAG, (String)"loadDeviceIsChoice: ");
        return this.deviceManagerDao.loadDeviceEntityIsChoice();
    }

    public LiveData<DeviceManagerEntity> loadDeviceIsChoiceAndConnected() {
        Log.d((String)TAG, (String)"loadDeviceIsChoiceAndConnected: ");
        return this.deviceManagerDao.loadDeviceEntityIsChoiceAndConnected();
    }

    public List<DeviceManagerEntity> loadDeviceManagerList() {
        Log.d((String)TAG, (String)"loadDeviceManagerList: ");
        return this.deviceManagerDao.loadDeviceManagerList();
    }

    public LiveData<List<DeviceManagerEntity>> loadDeviceManagerListFromDb() {
        Log.d((String)TAG, (String)"loadDeviceManagerListFromDb: ");
        return this.deviceManagerDao.loadDeviceManagerListLive();
    }

    public void update(DeviceManagerEntity deviceManagerEntity) {
        new Thread(new DeviceRepository$$ExternalSyntheticLambda4(this, deviceManagerEntity)).start();
    }

    public void updateDeviceActiveState(Device device) {
        new Thread(new DeviceRepository$$ExternalSyntheticLambda6(this, device)).start();
    }

    public void updateDeviceConnectState(Device device) {
        new Thread(new DeviceRepository$$ExternalSyntheticLambda7(this, device)).start();
    }

    public void updateDeviceConnectState(String string2) {
        this.updateDeviceConnectState(string2, false);
    }

    public void updateDeviceConnectState(String string2, boolean bl) {
        new Thread(new DeviceRepository$$ExternalSyntheticLambda10(this, string2, bl)).start();
    }

    public void updateDeviceInfo(Device device) {
        new Thread(new DeviceRepository$$ExternalSyntheticLambda8(this, device)).start();
    }

    public void updateLtGrFeature(boolean bl, boolean bl2) {
        new Thread(new DeviceRepository$$ExternalSyntheticLambda1(this, bl, bl2)).start();
    }
}

