/*
 * Decompiled with CFR 0.152.
 */
package com.brytonsport.active.repo.setting;

import android.content.Context;
import android.util.Base64;
import android.util.Log;
import androidx.lifecycle.MutableLiveData;
import com.brytonsport.active.api.APIError;
import com.brytonsport.active.api.ApiService;
import com.brytonsport.active.api.ErrorUtils;
import com.brytonsport.active.api.account.vo.AccountErrorVo;
import com.brytonsport.active.api.setting.FirmwareApi;
import com.brytonsport.active.base.App;
import com.brytonsport.active.utils.ActivityFileUtil;
import java.io.IOException;
import javax.inject.Inject;
import okhttp3.ResponseBody;
import retrofit2.Call;
import retrofit2.Callback;
import retrofit2.Response;

public class FirmwareUpdateRepository {
    static final String TAG = "FirmwareUpdateRepository";
    private String corpBaseUri = "https://corp.brytonsport.com";
    private final FirmwareApi firmwareApi;
    private final MutableLiveData<Boolean> isGetLangPackSuccessLiveData;
    private final MutableLiveData<Boolean> isGetSptLangListSuccessLiveData;
    private String langSavePath;
    private String sptLangListUri;
    private String sptLangPackUri;
    private final MutableLiveData<String> sptLanguageListLiveData;
    private final MutableLiveData<SptLanguagePack> sptLanguagePackLiveData;

    @Inject
    public FirmwareUpdateRepository() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.corpBaseUri);
        stringBuilder.append("/lang/%s/%s/list");
        this.sptLangListUri = stringBuilder.toString();
        stringBuilder = new StringBuilder();
        stringBuilder.append(this.corpBaseUri);
        stringBuilder.append("/lang/%s/%s/%s.bft");
        this.sptLangPackUri = stringBuilder.toString();
        this.langSavePath = "language/%s/%s/";
        this.isGetSptLangListSuccessLiveData = new MutableLiveData();
        this.isGetLangPackSuccessLiveData = new MutableLiveData();
        this.sptLanguageListLiveData = new MutableLiveData();
        this.sptLanguagePackLiveData = new MutableLiveData();
        this.firmwareApi = ApiService.getInstance().getFirmwareApi();
    }

    public MutableLiveData<Boolean> getIsGetLangPackSuccessLiveData() {
        return this.isGetLangPackSuccessLiveData;
    }

    public MutableLiveData<Boolean> getIsGetSptLangListSuccessLiveData() {
        return this.isGetSptLangListSuccessLiveData;
    }

    public void getSptLanguageListByModalAndVer(final String string2, String string3) {
        String string4 = String.format(this.sptLangListUri, string2, string3);
        string2 = String.format(this.langSavePath, string2, string3);
        this.firmwareApi.getSptLanguageList(string4).enqueue((Callback)new Callback<ResponseBody>(){

            public void onFailure(Call<ResponseBody> call, Throwable throwable) {
                FirmwareUpdateRepository.this.isGetSptLangListSuccessLiveData.postValue(false);
                FirmwareUpdateRepository.this.sptLanguageListLiveData.postValue(null);
            }

            public void onResponse(Call<ResponseBody> object, Response<ResponseBody> object2) {
                if (object2.isSuccessful()) {
                    try {
                        String string22 = ((ResponseBody)object2.body()).string();
                        FirmwareUpdateRepository.this.sptLanguageListLiveData.postValue(string22);
                        object = TAG;
                        StringBuilder stringBuilder = new StringBuilder();
                        stringBuilder.append("getSptLanguageListByModalAndVer onResponse: ");
                        stringBuilder.append(string22);
                        Log.d((String)object, (String)stringBuilder.toString());
                    }
                    catch (IOException iOException) {
                        iOException.printStackTrace();
                    }
                    FirmwareUpdateRepository.this.isGetSptLangListSuccessLiveData.postValue(true);
                    ActivityFileUtil.writeResponseBodyToDisk((Context)App.getInstance(), (ResponseBody)object2.body(), string2, "sptLangList.txt");
                } else {
                    object = ErrorUtils.parseError(object2);
                    new AccountErrorVo(object2.code(), ((APIError)object).message());
                    String string3 = TAG;
                    object2 = new StringBuilder();
                    ((StringBuilder)object2).append("getSptLanguageListByModalAndVer error message: ");
                    ((StringBuilder)object2).append(((APIError)object).message());
                    Log.d((String)string3, (String)((StringBuilder)object2).toString());
                    FirmwareUpdateRepository.this.isGetSptLangListSuccessLiveData.postValue(false);
                    FirmwareUpdateRepository.this.sptLanguageListLiveData.postValue(null);
                }
            }
        });
    }

    public MutableLiveData<String> getSptLanguageListLiveData() {
        return this.sptLanguageListLiveData;
    }

    public void getSptLanguagePack(final String string2, String string3, final String string4) {
        String string5 = String.format(this.sptLangPackUri, string2, string3, string4);
        string2 = String.format(this.langSavePath, string2, string3);
        this.firmwareApi.getLanguagePack(string5).enqueue((Callback)new Callback<ResponseBody>(){

            public void onFailure(Call<ResponseBody> call, Throwable throwable) {
                FirmwareUpdateRepository.this.sptLanguagePackLiveData.postValue(new SptLanguagePack(string4, null));
                FirmwareUpdateRepository.this.isGetLangPackSuccessLiveData.postValue(false);
            }

            public void onResponse(Call<ResponseBody> object, Response<ResponseBody> object2) {
                if (object2.isSuccessful()) {
                    object = TAG;
                    Object object3 = new StringBuilder();
                    ((StringBuilder)object3).append("getSptLanguagePack onResponse: ");
                    ((StringBuilder)object3).append(object2.body());
                    Log.d((String)object, (String)((StringBuilder)object3).toString());
                    object = (ResponseBody)object2.body();
                    try {
                        object = object.bytes();
                        object = Base64.encodeToString(object, (int)0, (int)((Call<ResponseBody>)object).length, (int)0);
                        MutableLiveData mutableLiveData = FirmwareUpdateRepository.this.sptLanguagePackLiveData;
                        object3 = new SptLanguagePack(string4, (String)object);
                        mutableLiveData.postValue(object3);
                        FirmwareUpdateRepository.this.isGetLangPackSuccessLiveData.postValue(true);
                        object = App.getInstance();
                        mutableLiveData = (ResponseBody)object2.body();
                        object2 = string2;
                        object3 = new StringBuilder();
                        ((StringBuilder)object3).append(string4);
                        ((StringBuilder)object3).append(".bft");
                        ActivityFileUtil.writeResponseBodyToDisk(object, (ResponseBody)mutableLiveData, (String)object2, ((StringBuilder)object3).toString());
                    }
                    catch (IOException iOException) {
                        iOException.printStackTrace();
                        FirmwareUpdateRepository.this.sptLanguagePackLiveData.postValue(new SptLanguagePack(string4, null));
                    }
                } else {
                    object = ErrorUtils.parseError(object2);
                    new AccountErrorVo(object2.code(), object.message());
                    String string22 = TAG;
                    object2 = new StringBuilder();
                    ((StringBuilder)object2).append("getSptLanguagePack error message: ");
                    ((StringBuilder)object2).append(object.message());
                    Log.d((String)string22, (String)((StringBuilder)object2).toString());
                    FirmwareUpdateRepository.this.sptLanguagePackLiveData.postValue(new SptLanguagePack(string4, null));
                    FirmwareUpdateRepository.this.isGetLangPackSuccessLiveData.postValue(false);
                }
            }
        });
    }

    public MutableLiveData<SptLanguagePack> getSptLanguagePackLiveData() {
        return this.sptLanguagePackLiveData;
    }

    public class SptLanguagePack {
        String key;
        String languagePack;

        public SptLanguagePack(String string2, String string3) {
            this.key = string2;
            this.languagePack = string3;
        }

        public String getKey() {
            return this.key;
        }

        public String getLanguagePack() {
            return this.languagePack;
        }
    }
}

