/*
 * Decompiled with CFR 0.152.
 */
package com.brytonsport.active.service;

import android.content.Context;
import android.content.Intent;
import android.os.Build;
import android.os.Bundle;
import android.service.notification.StatusBarNotification;
import android.util.Log;
import com.brytonsport.active.base.App;
import com.brytonsport.active.service.BleService;
import org.json.JSONException;
import org.json.JSONObject;

public class NotificationCommands {
    private static final String TAG = "NotificationCommands";

    private String getExtra(Bundle object, String string2) {
        try {
            object = object.get(string2).toString();
            return object;
        }
        catch (Exception exception) {
            return "";
        }
    }

    private String getExtraLines(Bundle object, String string2) {
        try {
            object = object.getCharSequenceArray(string2);
            object = object[((CharSequence[])object).length - 1].toString();
            return object;
        }
        catch (Exception exception) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("Unable to get extra lines ");
            stringBuilder.append(string2);
            Log.d((String)TAG, (String)stringBuilder.toString());
            return "";
        }
    }

    private JSONObject parse(StatusBarNotification statusBarNotification) throws JSONException {
        JSONObject jSONObject = new JSONObject();
        Bundle bundle = statusBarNotification.getNotification().extras;
        jSONObject.put("title", (Object)this.getExtra(bundle, "android.title"));
        jSONObject.put("package", (Object)statusBarNotification.getPackageName());
        jSONObject.put("text", (Object)this.getExtra(bundle, "android.text"));
        jSONObject.put("textLines", (Object)this.getExtraLines(bundle, "android.textLines"));
        return jSONObject;
    }

    public void notifyListener(Context context, StatusBarNotification statusBarNotification) {
        try {
            this.postToHandler(context, this.parse(statusBarNotification));
        }
        catch (JSONException jSONException) {
            jSONException.printStackTrace();
        }
    }

    public void postToHandler(Context context, JSONObject jSONObject) {
        synchronized (this) {
            Intent intent = new Intent((Context)App.getInstance(), BleService.class);
            intent.setAction("com.brytonsport.active.ACTION_NOTIFY_POST");
            intent.putExtra("com.brytonsport.active.SERVICE_NOTIFICATION_POST", jSONObject.toString());
            if (Build.VERSION.SDK_INT >= 26) {
                context.startForegroundService(intent);
            } else {
                context.startService(intent);
            }
            return;
        }
    }

    public void postToHandler(JSONObject jSONObject) {
        synchronized (this) {
            Intent intent = new Intent((Context)App.getInstance(), BleService.class);
            intent.setAction("com.brytonsport.active.ACTION_NOTIFY_POST");
            intent.putExtra("com.brytonsport.active.SERVICE_NOTIFICATION_POST", jSONObject.toString());
            if (Build.VERSION.SDK_INT >= 26) {
                App.getInstance().startForegroundService(intent);
            } else {
                App.getInstance().startService(intent);
            }
            return;
        }
    }
}

