/*
 * Decompiled with CFR 0.152.
 */
package com.brytonsport.active.service;

import android.content.Context;
import android.content.IntentFilter;
import android.service.notification.NotificationListenerService;
import android.service.notification.StatusBarNotification;
import android.util.Log;
import com.brytonsport.active.service.NotificationCommands;
import com.brytonsport.active.service.PhoneCallReceiver;
import com.brytonsport.active.service.SMSReceiver;
import com.brytonsport.active.utils.NotifyPostUtil;
import java.util.ArrayList;
import java.util.List;

public class NotificationService
extends NotificationListenerService {
    private static final String IGNORE_PKG = "snapdragon,com.google.android.googlequicksearchbox";
    private static final String TAG = "NotificationService";
    private static Context context;
    public static boolean enabled = false;
    private static NotificationCommands mPoster;
    private static int notificationId = 1;
    private static List<StatusBarNotification> notifications;
    private PhoneCallReceiver mPhoneCallReceiver;
    private SMSReceiver mSMSReceiver;

    static {
        mPoster = new NotificationCommands();
    }

    public static NotificationCommands getPoster() {
        return mPoster;
    }

    private boolean ignorePkg(String string2) {
        String[] stringArray = IGNORE_PKG.split(",");
        int n = stringArray.length;
        for (int i = 0; i < n; ++i) {
            if (!string2.contains(stringArray[i])) continue;
            return true;
        }
        return false;
    }

    private boolean isAllowedApp(String string2) {
        return NotifyPostUtil.getInst().isListening(string2);
    }

    public void onCreate() {
        super.onCreate();
        Log.i((String)TAG, (String)"onCreate");
        enabled = true;
        notifications = new ArrayList<StatusBarNotification>();
        context = this;
        if (this.mSMSReceiver == null) {
            this.mSMSReceiver = new SMSReceiver();
        }
        IntentFilter intentFilter = new IntentFilter("android.provider.Telephony.SMS_RECEIVED");
        intentFilter.setPriority(1000);
        this.registerReceiver(this.mSMSReceiver, intentFilter);
    }

    public void onDestroy() {
        Log.i((String)TAG, (String)"onDestroy");
        enabled = false;
        SMSReceiver sMSReceiver = this.mSMSReceiver;
        if (sMSReceiver != null) {
            this.unregisterReceiver(sMSReceiver);
            this.mSMSReceiver = null;
        }
    }

    public void onNotificationPosted(StatusBarNotification object) {
        String string2 = TAG;
        CharSequence charSequence = new StringBuilder();
        ((StringBuilder)charSequence).append("notification package name ");
        ((StringBuilder)charSequence).append(object.getPackageName());
        Log.d((String)string2, (String)((StringBuilder)charSequence).toString());
        charSequence = object.getPackageName();
        if (!(((String)charSequence).equals("android") || this.ignorePkg((String)charSequence) || object.isOngoing())) {
            if (this.isAllowedApp((String)charSequence)) {
                mPoster.notifyListener(context, (StatusBarNotification)object);
            }
        } else {
            object = new StringBuilder();
            ((StringBuilder)object).append("Ignore notification from pkg ");
            ((StringBuilder)object).append((String)charSequence);
            Log.d((String)string2, (String)((StringBuilder)object).toString());
        }
    }

    public void onNotificationRemoved(StatusBarNotification statusBarNotification) {
    }
}

