/*
 * Decompiled with CFR 0.152.
 */
package com.brytonsport.active.service;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.os.Build;
import android.util.Log;
import com.brytonsport.active.base.App;
import com.brytonsport.active.service.BleService;
import com.brytonsport.active.service.ServiceUtil;

public class StartReceiver
extends BroadcastReceiver {
    public static final String ACTION_OPEN_APP_SETTING = "com.brytonsport.active.action.open.app.setting";
    public static final String ACTION_OPEN_GPS_SETTING = "com.example.bleserviceapp.action.open.gps.setting";
    public static final String ACTION_STOP_FOREGROUND_SERVICE = "com.brytonsport.active.action.stop.foregroundservice";
    public static final String ACTION_STOP_SERVICE = "com.brytonsport.active.action.stop.service";
    private static final String TAG = "StartReceiver";

    private void startBleService(Intent intent) {
        if (Build.VERSION.SDK_INT >= 26) {
            App.getInstance().startForegroundService(intent);
        } else {
            App.getInstance().startService(intent);
        }
    }

    public void onReceive(Context context, Intent intent) {
        if (intent.getAction().equals("android.intent.action.BOOT_COMPLETED")) {
            intent = new Intent();
            intent.setClass(context, BleService.class);
            intent.setAction("com.brytonsport.activereBootAndStartService");
            if (Build.VERSION.SDK_INT >= 26) {
                Log.d((String)TAG, (String)"Starting the BleService in >=26 Mode");
                context.startForegroundService(intent);
                return;
            }
            Log.d((String)TAG, (String)"Starting the BleService in < 26 Mode");
            context.startService(intent);
        } else if (intent.getAction().equals(ACTION_STOP_SERVICE)) {
            if (ServiceUtil.isMyServiceRunning(context, BleService.class)) {
                Log.d((String)TAG, (String)"onReceive: BleService is Running");
            }
            context = new Intent(context, BleService.class);
            context.setAction("com.brytonsport.activestopService");
            Log.d((String)TAG, (String)"Stop the BleService ");
            this.startBleService((Intent)context);
        } else if (intent.getAction().equals(ACTION_OPEN_APP_SETTING)) {
            intent = new Intent("android.settings.APPLICATION_DETAILS_SETTINGS", Uri.fromParts((String)"package", (String)context.getPackageName(), null));
            intent.addCategory("android.intent.category.DEFAULT");
            intent.addFlags(0x10000000);
            context.startActivity(intent);
        } else if (intent.getAction().equals(ACTION_OPEN_GPS_SETTING)) {
            intent = new Intent("android.settings.LOCATION_SOURCE_SETTINGS");
            intent.addCategory("android.intent.category.DEFAULT");
            intent.addFlags(0x10000000);
            context.startActivity(intent);
        }
    }
}

