/*
 * Decompiled with CFR 0.152.
 */
package com.brytonsport.active.service;

import com.android.volley.AuthFailureError;
import com.android.volley.NetworkResponse;
import com.android.volley.ParseError;
import com.android.volley.Request;
import com.android.volley.Response;
import com.android.volley.VolleyError;
import com.android.volley.toolbox.HttpHeaderParser;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.Map;

public class VolleyMultipartRequest
extends Request<NetworkResponse> {
    private final String boundary;
    private final String lineEnd;
    private Response.ErrorListener mErrorListener;
    private Map<String, String> mHeaders;
    private Response.Listener<NetworkResponse> mListener;
    private final String twoHyphens;

    public VolleyMultipartRequest(int n, String string2, Response.Listener<NetworkResponse> listener, Response.ErrorListener errorListener) {
        super(n, string2, errorListener);
        this.twoHyphens = "--";
        this.lineEnd = "\r\n";
        this.boundary = "+++++";
        this.mListener = listener;
        this.mErrorListener = errorListener;
    }

    private void buildDataPart(DataOutputStream dataOutputStream, DataPart object, String object2) throws IOException {
        dataOutputStream.writeBytes("--+++++\r\n");
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Content-Disposition: form-data; name=\"");
        stringBuilder.append((String)object2);
        stringBuilder.append("\"; filename=\"");
        stringBuilder.append(((DataPart)object).getFileName());
        stringBuilder.append("\"");
        stringBuilder.append("\r\n");
        dataOutputStream.writeBytes(stringBuilder.toString());
        if (((DataPart)object).getType() != null && !((DataPart)object).getType().trim().isEmpty()) {
            object2 = new StringBuilder();
            ((StringBuilder)object2).append("Content-Type: ");
            ((StringBuilder)object2).append(((DataPart)object).getType());
            ((StringBuilder)object2).append("\r\n");
            dataOutputStream.writeBytes(((StringBuilder)object2).toString());
        }
        dataOutputStream.writeBytes("\r\n");
        object = new ByteArrayInputStream(((DataPart)object).getContent());
        int n = Math.min(((ByteArrayInputStream)object).available(), 0x100000);
        object2 = new byte[n];
        int n2 = ((ByteArrayInputStream)object).read((byte[])object2, 0, n);
        while (n2 > 0) {
            dataOutputStream.write((byte[])object2, 0, n);
            n = Math.min(((ByteArrayInputStream)object).available(), 0x100000);
            n2 = ((ByteArrayInputStream)object).read((byte[])object2, 0, n);
        }
        dataOutputStream.writeBytes("\r\n");
    }

    private void buildTextPart(DataOutputStream dataOutputStream, String charSequence, String string2) throws IOException {
        dataOutputStream.writeBytes("--+++++\r\n");
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Content-Disposition: form-data; name=\"");
        stringBuilder.append((String)charSequence);
        stringBuilder.append("\"");
        stringBuilder.append("\r\n");
        dataOutputStream.writeBytes(stringBuilder.toString());
        dataOutputStream.writeBytes("\r\n");
        charSequence = new StringBuilder();
        ((StringBuilder)charSequence).append(string2);
        ((StringBuilder)charSequence).append("\r\n");
        dataOutputStream.writeBytes(((StringBuilder)charSequence).toString());
    }

    private void dataParse(DataOutputStream dataOutputStream, Map<String, DataPart> object) throws IOException {
        for (Map.Entry entry : object.entrySet()) {
            this.buildDataPart(dataOutputStream, (DataPart)entry.getValue(), (String)entry.getKey());
        }
    }

    private void textParse(DataOutputStream dataOutputStream, Map<String, String> object, String string2) throws IOException {
        try {
            for (Map.Entry entry : object.entrySet()) {
                this.buildTextPart(dataOutputStream, (String)entry.getKey(), (String)entry.getValue());
            }
            return;
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            object = new StringBuilder();
            ((StringBuilder)object).append("Encoding not supported: ");
            ((StringBuilder)object).append(string2);
            throw new RuntimeException(((StringBuilder)object).toString(), unsupportedEncodingException);
        }
    }

    @Override
    public void deliverError(VolleyError volleyError) {
        this.mErrorListener.onErrorResponse(volleyError);
    }

    @Override
    protected void deliverResponse(NetworkResponse networkResponse) {
        this.mListener.onResponse(networkResponse);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public byte[] getBody() throws AuthFailureError {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
        try {
            Map<String, Object> map = this.getParams();
            if (map != null && map.size() > 0) {
                this.textParse(dataOutputStream, map, this.getParamsEncoding());
            }
            if ((map = this.getByteData()) != null && map.size() > 0) {
                this.dataParse(dataOutputStream, map);
            }
            dataOutputStream.writeBytes("--+++++--\r\n");
            return (ByteArrayOutputStream)byteArrayOutputStream.toByteArray();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            return null;
        }
    }

    @Override
    public String getBodyContentType() {
        return "multipart/form-data;boundary=+++++";
    }

    protected Map<String, DataPart> getByteData() throws AuthFailureError {
        return null;
    }

    @Override
    public Map<String, String> getHeaders() throws AuthFailureError {
        Map<String, String> map = this.mHeaders;
        if (map == null) {
            map = super.getHeaders();
        }
        return map;
    }

    @Override
    protected Response<NetworkResponse> parseNetworkResponse(NetworkResponse object) {
        try {
            object = Response.success(object, HttpHeaderParser.parseCacheHeaders((NetworkResponse)object));
            return object;
        }
        catch (Exception exception) {
            return Response.error(new ParseError(exception));
        }
    }

    public class DataPart {
        private byte[] content;
        private String fileName;
        private String type;

        public DataPart() {
        }

        public DataPart(String string2, byte[] byArray) {
            this.fileName = string2;
            this.content = byArray;
            this.type = "image/jpeg";
        }

        byte[] getContent() {
            return this.content;
        }

        String getFileName() {
            return this.fileName;
        }

        String getType() {
            return this.type;
        }
    }
}

