/*
 * Decompiled with CFR 0.152.
 */
package com.brytonsport.active.ui;

import android.app.Activity;
import android.content.Context;
import android.os.Bundle;
import android.util.Log;
import android.view.LayoutInflater;
import androidx.lifecycle.Observer;
import androidx.lifecycle.ViewModelProvider;
import androidx.recyclerview.widget.DividerItemDecoration;
import androidx.recyclerview.widget.LinearLayoutManager;
import com.brytonsport.active.databinding.ActivityScanBinding;
import com.brytonsport.active.ui.DeviceVo;
import com.brytonsport.active.ui.Hilt_ScanActivity;
import com.brytonsport.active.ui.adapter.ScanListAdapter;
import com.brytonsport.active.utils.LocationUtils;
import com.brytonsport.active.vm.ScanViewModel;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import pub.devrel.easypermissions.AfterPermissionGranted;
import pub.devrel.easypermissions.EasyPermissions;

public class ScanActivity
extends Hilt_ScanActivity<ActivityScanBinding, ScanViewModel> {
    private static final int RC_SCAN_AND_LOCATION = 23;
    static final String TAG = "ScanActivity";
    private Map<String, DeviceVo> peripherals;
    private List<DeviceVo> scanList;
    private ScanListAdapter scanListAdapter;

    static /* synthetic */ Map access$002(ScanActivity scanActivity, Map map) {
        scanActivity.peripherals = map;
        return map;
    }

    private void initScanList() {
        this.peripherals = new LinkedHashMap<String, DeviceVo>();
        this.scanList = new ArrayList<DeviceVo>();
        this.scanListAdapter = new ScanListAdapter(this, this.scanList, new ScanListAdapter.OnItemClickListener(){

            @Override
            public void onItemClick(DeviceVo deviceVo) {
                ScanActivity.this.stopScan();
            }

            @Override
            public void onRemoveItemClick(DeviceVo deviceVo) {
            }
        });
        ((ActivityScanBinding)this.binding).deviceList.setLayoutManager(new LinearLayoutManager((Context)this));
        ((ActivityScanBinding)this.binding).deviceList.addItemDecoration(new DividerItemDecoration((Context)this, 1));
        ((ActivityScanBinding)this.binding).deviceList.setAdapter(this.scanListAdapter);
    }

    @AfterPermissionGranted(value=23)
    private void methodRequiresTwoPermission() {
        String[] stringArray = LocationUtils.isSorAbove() ? new String[]{"android.permission.BLUETOOTH_SCAN", "android.permission.BLUETOOTH_CONNECT"} : new String[]{"android.permission.ACCESS_COARSE_LOCATION", "android.permission.ACCESS_FINE_LOCATION"};
        if (EasyPermissions.hasPermissions((Context)this, (String[])stringArray)) {
            this.startScan();
        } else {
            EasyPermissions.requestPermissions((Activity)this, (String)"\u8acb\u5141\u8a31\u6383\u63cf\u85cd\u82bd\u6b0a\u9650", (int)23, (String[])stringArray);
        }
    }

    private void observeViewModel() {
        ((ScanViewModel)this.viewModel).getScanRecordLiveData().observe(this, new Observer<Map<String, DeviceVo>>(){

            @Override
            public void onChanged(Map<String, DeviceVo> object) {
                ScanActivity.access$002(ScanActivity.this, object);
                ArrayList<DeviceVo> arrayList = new ArrayList<DeviceVo>();
                object = ScanActivity.this.peripherals.entrySet().iterator();
                while (object.hasNext()) {
                    DeviceVo deviceVo = (DeviceVo)((Map.Entry)object.next()).getValue();
                    DeviceVo deviceVo2 = new DeviceVo();
                    deviceVo2.setAddress(deviceVo.getAddress());
                    deviceVo2.setName(deviceVo.getName());
                    arrayList.add(deviceVo2);
                }
                ScanActivity.this.scanListAdapter.addDevice(arrayList);
            }
        });
    }

    private void startScan() {
        Log.d((String)TAG, (String)"startScan: ");
        ((ScanViewModel)this.viewModel).startScan();
    }

    private void stopScan() {
        ((ScanViewModel)this.viewModel).stopScan();
    }

    @Override
    protected ActivityScanBinding createViewBinding(LayoutInflater layoutInflater) {
        return ActivityScanBinding.inflate(layoutInflater);
    }

    @Override
    protected ScanViewModel createViewModel() {
        return new ViewModelProvider(this).get(ScanViewModel.class);
    }

    @Override
    protected void initColor() {
    }

    @Override
    protected void initFont() {
    }

    @Override
    protected void initText() {
    }

    @Override
    protected void onCreate(Bundle bundle) {
        super.onCreate(bundle);
        this.observeViewModel();
        ((ScanViewModel)this.viewModel).registerScanReceiver();
        this.initScanList();
        this.methodRequiresTwoPermission();
    }

    @Override
    protected void onDestroy() {
        super.onDestroy();
        ((ScanViewModel)this.viewModel).unregisterScanReceiver();
    }

    @Override
    public void onRequestPermissionsResult(int n, String[] stringArray, int[] nArray) {
        super.onRequestPermissionsResult(n, stringArray, nArray);
        EasyPermissions.onRequestPermissionsResult((int)n, (String[])stringArray, (int[])nArray, (Object[])new Object[]{this});
    }

    @Override
    protected void setListeners() {
    }
}

