/*
 * Decompiled with CFR 0.152.
 */
package com.brytonsport.active.ui.account;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.text.Editable;
import android.text.TextWatcher;
import android.view.LayoutInflater;
import android.view.View;
import android.widget.ImageView;
import androidx.lifecycle.Observer;
import androidx.lifecycle.ViewModelProvider;
import com.brytonsport.active.api.account.vo.AccountErrorVo;
import com.brytonsport.active.api.account.vo.AccountUserInfo;
import com.brytonsport.active.api.account.vo.Email;
import com.brytonsport.active.base.App;
import com.brytonsport.active.base.EasyBaseFragmentActivity;
import com.brytonsport.active.databinding.ActivityLoginBinding;
import com.brytonsport.active.ui.account.AccountAlertActivity;
import com.brytonsport.active.ui.account.AccountConfirmationActivity;
import com.brytonsport.active.ui.account.ForgetPasswordActivity;
import com.brytonsport.active.ui.account.Hilt_LoginActivity;
import com.brytonsport.active.ui.account.LoginActivity$$ExternalSyntheticLambda0;
import com.brytonsport.active.ui.account.LoginActivity$$ExternalSyntheticLambda1;
import com.brytonsport.active.ui.account.LoginActivity$$ExternalSyntheticLambda2;
import com.brytonsport.active.ui.account.LoginActivity$$ExternalSyntheticLambda3;
import com.brytonsport.active.ui.account.LoginActivity$$ExternalSyntheticLambda4;
import com.brytonsport.active.ui.account.LoginActivity$$ExternalSyntheticLambda5;
import com.brytonsport.active.ui.account.LoginActivity$$ExternalSyntheticLambda6;
import com.brytonsport.active.ui.account.SignupActivity;
import com.brytonsport.active.ui.result.ResultActivity;
import com.brytonsport.active.utils.Constants;
import com.brytonsport.active.utils.NetworkUtil;
import com.brytonsport.active.utils.ToastUtil;
import com.brytonsport.active.utils.i18N;
import com.brytonsport.active.views.dialog.ConfirmDialog;
import com.brytonsport.active.vm.account.LoginViewModel;
import java.util.Date;
import org.json.JSONException;
import org.json.JSONObject;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class LoginActivity
extends Hilt_LoginActivity<ActivityLoginBinding, LoginViewModel> {
    private boolean checkClickable() {
        int n;
        ImageView imageView;
        block5: {
            block4: {
                imageView = ((ActivityLoginBinding)this.binding).emailIcon;
                boolean bl = ((ActivityLoginBinding)this.binding).accountEdit.isFocused();
                int n2 = 2131165444;
                n = bl && !((ActivityLoginBinding)this.binding).accountEdit.getEditableText().toString().isEmpty() ? 2131165444 : 2131165464;
                imageView.setImageResource(n);
                imageView = ((ActivityLoginBinding)this.binding).passwordIcon;
                if (!((ActivityLoginBinding)this.binding).passwordEdit.isFocused()) break block4;
                n = n2;
                if (!((ActivityLoginBinding)this.binding).passwordEdit.getEditableText().toString().isEmpty()) break block5;
            }
            n = 2131165532;
        }
        imageView.setImageResource(n);
        if (!((ActivityLoginBinding)this.binding).accountEdit.getEditableText().toString().isEmpty() && !((ActivityLoginBinding)this.binding).passwordEdit.getEditableText().toString().isEmpty()) {
            ((ActivityLoginBinding)this.binding).loginButton.setTextColor(-1);
            ((ActivityLoginBinding)this.binding).loginButton.setBackgroundResource(2131165838);
            return true;
        }
        ((ActivityLoginBinding)this.binding).loginButton.setTextColor(-12892323);
        ((ActivityLoginBinding)this.binding).loginButton.setBackgroundResource(2131165833);
        return false;
    }

    private void closeLoading() {
        this.dismissProgressDialog();
    }

    public static Intent createIntent(Context context) {
        return new Intent(context, LoginActivity.class);
    }

    private void observeViewModel() {
        ((LoginViewModel)this.viewModel).getLoginCheckMsgLiveData().observe(this, new Observer<String>(){

            @Override
            public void onChanged(String string2) {
                LoginActivity.this.closeLoading();
                ToastUtil.showToast((Context)LoginActivity.this, string2);
            }
        });
        ((LoginViewModel)this.viewModel).getLiveAccountErrorResponse().observe(this, new Observer<AccountErrorVo>(){

            @Override
            public void onChanged(AccountErrorVo object) {
                LoginActivity.this.closeLoading();
                if (object != null) {
                    String string2;
                    int n = ((AccountErrorVo)object).getCode();
                    String string3 = ((AccountErrorVo)object).getMessage();
                    if (string3 != null) {
                        if (string3.equals("User not found")) {
                            string2 = i18N.get("M_InvalidEmail");
                        } else {
                            string2 = string3;
                            if (string3.equals("Incorrect password")) {
                                string2 = i18N.get("M_InvalidPassword");
                            }
                        }
                    } else {
                        string2 = i18N.get("LoginFailed");
                    }
                    object = ((AccountErrorVo)object).getAction();
                    if (object == null || !((String)object).equals("action_getUserProfile")) {
                        string3 = LoginActivity.this.activity;
                        object = new StringBuilder();
                        ((StringBuilder)object).append(string2);
                        ((StringBuilder)object).append(" (code: ");
                        ((StringBuilder)object).append(n);
                        ((StringBuilder)object).append(")");
                        ConfirmDialog.showSelfSingle((Activity)string3, ((StringBuilder)object).toString(), i18N.get("B_OK"));
                        ((LoginViewModel)LoginActivity.this.viewModel).resetUserId();
                    }
                }
            }
        });
        ((LoginViewModel)this.viewModel).isLoginSuccessLiveData().observe(this, new Observer<Boolean>(){

            @Override
            public void onChanged(Boolean bl) {
                if (bl.booleanValue()) {
                    ((LoginViewModel)LoginActivity.this.viewModel).getUserInfoWithVerified();
                } else {
                    LoginActivity.this.closeLoading();
                }
            }
        });
        ((LoginViewModel)this.viewModel).isUserInfoSuccessLiveData().observe(this, new Observer<Boolean>(){

            @Override
            public void onChanged(Boolean bl) {
                if (bl.booleanValue()) {
                    ((LoginViewModel)LoginActivity.this.viewModel).getUserProfile();
                } else {
                    LoginActivity.this.closeLoading();
                }
            }
        });
        ((LoginViewModel)this.viewModel).isUserInfoVerifiedLiveData().observe(this, new Observer<AccountUserInfo>(){

            @Override
            public void onChanged(AccountUserInfo object) {
                if (object != null) {
                    Object object2 = ((AccountUserInfo)object).getCreatedAt();
                    if (object2 != null && ((Date)object2).getTime() > Constants.DATE_20180326) {
                        LoginActivity loginActivity = null;
                        object2 = loginActivity;
                        if (((AccountUserInfo)object).getEmails() != null) {
                            object2 = loginActivity;
                            if (((AccountUserInfo)object).getEmails().size() > 0) {
                                object2 = ((AccountUserInfo)object).getEmails().get(0);
                            }
                        }
                        if (object2 != null && ((Email)object2).getVerified().booleanValue()) {
                            ((LoginViewModel)LoginActivity.this.viewModel).getUserProfile();
                        } else {
                            loginActivity = LoginActivity.this;
                            Activity activity = loginActivity.activity;
                            object = object2 == null ? "" : ((Email)object2).getAddress();
                            loginActivity.startActivity(AccountConfirmationActivity.createIntent((Context)activity, (String)object));
                            LoginActivity.this.finish();
                        }
                    } else {
                        ((LoginViewModel)LoginActivity.this.viewModel).getUserProfile();
                    }
                } else {
                    ((LoginViewModel)LoginActivity.this.viewModel).resetUserId();
                }
            }
        });
        ((LoginViewModel)this.viewModel).getUserProfileForLoginResultLiveData().observe(this, new Observer<JSONObject>(){

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public void onChanged(JSONObject object) {
                LoginActivity.this.closeLoading();
                if (object == null) return;
                boolean bl = object.has("code");
                String string2 = "";
                if (bl) {
                    try {
                        int n = object.getInt("code");
                        if (object.has("message")) {
                            string2 = object.getString("message");
                        }
                        if (n == 200) {
                            object = LoginActivity.this;
                            ((EasyBaseFragmentActivity)object).startActivity(ResultActivity.createIntent((Context)((LoginActivity)object).activity));
                            LoginActivity.this.finish();
                            return;
                        }
                        if (n == 404) {
                            ((LoginViewModel)LoginActivity.this.viewModel).createDefaultUserProfileToDb();
                            object = LoginActivity.this;
                            ((EasyBaseFragmentActivity)object).startActivity(ResultActivity.createIntent((Context)((LoginActivity)object).activity));
                            LoginActivity.this.finish();
                            return;
                        }
                        ((LoginViewModel)LoginActivity.this.viewModel).resetUserId();
                        object = LoginActivity.this.activity;
                        StringBuilder stringBuilder = new StringBuilder();
                        stringBuilder.append(string2);
                        stringBuilder.append(" (code: ");
                        stringBuilder.append(n);
                        stringBuilder.append(")");
                        ConfirmDialog.showSelfSingle((Activity)object, stringBuilder.toString(), i18N.get("B_OK"));
                        return;
                    }
                    catch (JSONException jSONException) {
                        jSONException.printStackTrace();
                        return;
                    }
                }
                try {
                    if (object.has("message")) {
                        string2 = object.getString("message");
                    }
                    ConfirmDialog.showSelfSingle(LoginActivity.this.activity, string2, i18N.get("B_OK"));
                    ((LoginViewModel)LoginActivity.this.viewModel).resetUserId();
                    return;
                }
                catch (JSONException jSONException) {
                    jSONException.printStackTrace();
                }
            }
        });
    }

    private void openLoading() {
        this.showProgressDialog("");
    }

    @Override
    protected ActivityLoginBinding createViewBinding(LayoutInflater layoutInflater) {
        return ActivityLoginBinding.inflate(layoutInflater);
    }

    @Override
    protected LoginViewModel createViewModel() {
        return new ViewModelProvider(this).get(LoginViewModel.class);
    }

    @Override
    protected void initColor() {
        ((ActivityLoginBinding)this.binding).getRoot().setBackgroundResource(2131034148);
    }

    @Override
    protected void initFont() {
    }

    @Override
    protected void initText() {
        App.put("Login", i18N.get("Login"));
        App.put("Hey! You\u2019re back!", i18N.get("Hey"));
        App.put("Email Address", i18N.get("M_EmailAddr"));
        App.put("Password", i18N.get("Password"));
        App.put("Forget Password?", i18N.get("ForgetPassword"));
        App.put("Don\u2019t have one? ", i18N.get("Nothave"));
        App.put("Create a new account", i18N.get("CreateANewAccount"));
        App.put("Used to login with 3rd party account?", i18N.get("UsedLoginWith3rd"));
        App.put("Learn More", i18N.get("LearnMore"));
        ((ActivityLoginBinding)this.binding).titleText.setText((CharSequence)i18N.get("B_Login"));
        ((ActivityLoginBinding)this.binding).subtitleText.setText((CharSequence)App.get("Hey! You\u2019re back!"));
        ((ActivityLoginBinding)this.binding).accountEdit.setHint((CharSequence)i18N.get("M_EmailAddr"));
        ((ActivityLoginBinding)this.binding).passwordEdit.setHint((CharSequence)i18N.get("M_Password"));
        ((ActivityLoginBinding)this.binding).forgetText.setText((CharSequence)i18N.get("ForgetPassword"));
        ((ActivityLoginBinding)this.binding).loginButton.setText((CharSequence)i18N.get("B_Login"));
        ((ActivityLoginBinding)this.binding).dontHaveOneText.setText((CharSequence)App.get("Don\u2019t have one? "));
        ((ActivityLoginBinding)this.binding).signupButton.setText((CharSequence)App.get("Create a new account"));
        ((ActivityLoginBinding)this.binding).usedToLoginText.setText((CharSequence)App.get("Used to login with 3rd party account?"));
        ((ActivityLoginBinding)this.binding).learnMoreButton.setText((CharSequence)App.get("Learn More"));
        ((ActivityLoginBinding)this.binding).usedToLoginText.setVisibility(0);
        ((ActivityLoginBinding)this.binding).learnMoreButton.setVisibility(0);
    }

    public /* synthetic */ void lambda$setListeners$0$com-brytonsport-active-ui-account-LoginActivity(View view) {
        ((ActivityLoginBinding)this.binding).accountEdit.setText((CharSequence)"");
    }

    public /* synthetic */ void lambda$setListeners$1$com-brytonsport-active-ui-account-LoginActivity(View view) {
        ((ActivityLoginBinding)this.binding).passwordEdit.setText((CharSequence)"");
    }

    public /* synthetic */ void lambda$setListeners$2$com-brytonsport-active-ui-account-LoginActivity(View view) {
        this.startActivity(SignupActivity.createIntent((Context)this));
    }

    public /* synthetic */ void lambda$setListeners$3$com-brytonsport-active-ui-account-LoginActivity(View view) {
        this.startActivity(ForgetPasswordActivity.createIntent((Context)this));
    }

    public /* synthetic */ void lambda$setListeners$4$com-brytonsport-active-ui-account-LoginActivity(View view) {
        this.startActivity(AccountAlertActivity.createIntent((Context)this));
        this.finish();
    }

    public /* synthetic */ void lambda$setListeners$5$com-brytonsport-active-ui-account-LoginActivity(View view, boolean bl) {
        this.checkClickable();
    }

    public /* synthetic */ void lambda$setListeners$6$com-brytonsport-active-ui-account-LoginActivity(View view, boolean bl) {
        this.checkClickable();
    }

    @Override
    public void onBackPressed() {
    }

    @Override
    protected void onCreate() {
        super.onCreate();
        this.setActionbarVisibility(8);
        this.observeViewModel();
    }

    @Override
    protected void setListeners() {
        TextWatcher textWatcher = new TextWatcher(){

            public void afterTextChanged(Editable editable) {
                LoginActivity.this.checkClickable();
            }

            public void beforeTextChanged(CharSequence charSequence, int n, int n2, int n3) {
            }

            public void onTextChanged(CharSequence charSequence, int n, int n2, int n3) {
            }
        };
        ((ActivityLoginBinding)this.binding).accountEdit.addTextChangedListener(textWatcher);
        ((ActivityLoginBinding)this.binding).passwordEdit.addTextChangedListener(textWatcher);
        ((ActivityLoginBinding)this.binding).emailIcon.setOnClickListener((View.OnClickListener)new LoginActivity$$ExternalSyntheticLambda0(this));
        ((ActivityLoginBinding)this.binding).passwordIcon.setOnClickListener((View.OnClickListener)new LoginActivity$$ExternalSyntheticLambda1(this));
        ((ActivityLoginBinding)this.binding).loginButton.setOnClickListener(new View.OnClickListener(){

            public void onClick(View object) {
                if (!LoginActivity.this.checkClickable()) {
                    return;
                }
                if (!NetworkUtil.isNetworkConnect((Context)LoginActivity.this.activity)) {
                    ConfirmDialog.showSelfSingle(LoginActivity.this.activity, i18N.get("M_NoInternet"));
                }
                LoginActivity.this.openLoading();
                String string2 = ((ActivityLoginBinding)LoginActivity.this.binding).accountEdit.getText().toString();
                object = ((ActivityLoginBinding)LoginActivity.this.binding).passwordEdit.getText().toString();
                ((LoginViewModel)LoginActivity.this.viewModel).login(string2, (String)object);
            }
        });
        ((ActivityLoginBinding)this.binding).signupButton.setOnClickListener((View.OnClickListener)new LoginActivity$$ExternalSyntheticLambda2(this));
        ((ActivityLoginBinding)this.binding).forgetText.setOnClickListener((View.OnClickListener)new LoginActivity$$ExternalSyntheticLambda3(this));
        ((ActivityLoginBinding)this.binding).learnMoreButton.setOnClickListener((View.OnClickListener)new LoginActivity$$ExternalSyntheticLambda4(this));
        ((ActivityLoginBinding)this.binding).accountEdit.setOnFocusChangeListener((View.OnFocusChangeListener)new LoginActivity$$ExternalSyntheticLambda5(this));
        ((ActivityLoginBinding)this.binding).passwordEdit.setOnFocusChangeListener((View.OnFocusChangeListener)new LoginActivity$$ExternalSyntheticLambda6(this));
    }
}

