/*
 * Decompiled with CFR 0.152.
 */
package com.brytonsport.active.ui.adapter;

import android.content.Context;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.TextView;
import androidx.constraintlayout.widget.ConstraintLayout;
import androidx.recyclerview.widget.RecyclerView;
import com.brytonsport.active.ui.LogMsg;
import java.util.List;

public class MsgListAdapter
extends RecyclerView.Adapter<ViewHolder> {
    private OnItemClickListener listener;
    private List<LogMsg> localDataSet;

    public MsgListAdapter(List<LogMsg> list, OnItemClickListener onItemClickListener) {
        this.localDataSet = list;
        this.listener = onItemClickListener;
    }

    public void addDevice(List<LogMsg> list) {
        this.localDataSet = list;
        this.notifyDataSetChanged();
    }

    public void clearDevice() {
        this.localDataSet.clear();
        this.notifyDataSetChanged();
    }

    @Override
    public int getItemCount() {
        List<LogMsg> list = this.localDataSet;
        int n = list == null ? 0 : list.size();
        return n;
    }

    @Override
    public void onBindViewHolder(ViewHolder viewHolder, int n) {
        viewHolder.bind(this.localDataSet.get(n), this.listener);
    }

    @Override
    public ViewHolder onCreateViewHolder(ViewGroup viewGroup, int n) {
        return new ViewHolder(LayoutInflater.from((Context)viewGroup.getContext()).inflate(2131427443, viewGroup, false));
    }

    public static interface OnItemClickListener {
        public void onItemClick(String var1);
    }

    public static class ViewHolder
    extends RecyclerView.ViewHolder {
        private final ConstraintLayout itemView;
        private final TextView nameView;
        private final TextView timeView;

        public ViewHolder(View view) {
            super(view);
            this.timeView = (TextView)view.findViewById(2131231869);
            this.nameView = (TextView)view.findViewById(2131231426);
            this.itemView = (ConstraintLayout)view.findViewById(2131231294);
        }

        public void bind(LogMsg logMsg, OnItemClickListener onItemClickListener) {
            this.nameView.setText((CharSequence)logMsg.getMsg());
            this.timeView.setText((CharSequence)logMsg.getTimeStr());
            if (logMsg.isHint()) {
                this.timeView.setTextColor(-65536);
                this.nameView.setTextColor(-65536);
            } else {
                this.timeView.setTextColor(-1);
                this.nameView.setTextColor(-1);
            }
        }

        public ConstraintLayout getItemView() {
            return this.itemView;
        }

        public TextView getNameView() {
            return this.nameView;
        }
    }
}

