/*
 * Decompiled with CFR 0.152.
 */
package com.brytonsport.active.ui.adapter;

import android.app.Activity;
import android.content.Context;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.TextView;
import androidx.constraintlayout.widget.ConstraintLayout;
import androidx.recyclerview.widget.RecyclerView;
import com.brytonsport.active.ui.DeviceVo;
import com.brytonsport.active.utils.DeviceImageUtil;
import java.util.List;

public class ScanListAdapter
extends RecyclerView.Adapter<ViewHolder> {
    private OnItemClickListener listener;
    private List<DeviceVo> localDataSet;
    private Activity mActivity;

    public ScanListAdapter(Activity activity, List<DeviceVo> list, OnItemClickListener onItemClickListener) {
        this.localDataSet = list;
        this.listener = onItemClickListener;
        this.mActivity = activity;
    }

    public void addDevice(List<DeviceVo> list) {
        this.localDataSet = list;
        this.notifyDataSetChanged();
    }

    public void clearDevice() {
        this.localDataSet.clear();
        this.notifyDataSetChanged();
    }

    @Override
    public int getItemCount() {
        return this.localDataSet.size();
    }

    @Override
    public void onBindViewHolder(ViewHolder viewHolder, int n) {
        DeviceVo deviceVo = this.localDataSet.get(n);
        viewHolder.bind(this.mActivity, deviceVo, this.listener);
    }

    @Override
    public ViewHolder onCreateViewHolder(ViewGroup viewGroup, int n) {
        return new ViewHolder(LayoutInflater.from((Context)viewGroup.getContext()).inflate(2131427444, viewGroup, false));
    }

    public static interface OnItemClickListener {
        public void onItemClick(DeviceVo var1);

        public void onRemoveItemClick(DeviceVo var1);
    }

    public static class ViewHolder
    extends RecyclerView.ViewHolder {
        private final TextView addressView;
        private final ImageView iconView;
        private final ConstraintLayout itemView;
        private final TextView nameView;
        private final ImageView removeView;
        private final TextView uuidView;

        public ViewHolder(View view) {
            super(view);
            this.iconView = (ImageView)view.findViewById(2131231254);
            this.nameView = (TextView)view.findViewById(2131231061);
            this.uuidView = (TextView)view.findViewById(2131231950);
            this.addressView = (TextView)view.findViewById(2131230815);
            this.removeView = (ImageView)view.findViewById(2131231638);
            this.itemView = (ConstraintLayout)view.findViewById(2131231294);
        }

        public void bind(Activity activity, final DeviceVo deviceVo, final OnItemClickListener onItemClickListener) {
            this.nameView.setText((CharSequence)deviceVo.getName());
            this.uuidView.setText((CharSequence)deviceVo.getUuid());
            this.addressView.setText((CharSequence)deviceVo.getAddress());
            this.iconView.setImageResource(DeviceImageUtil.getDeviceImage(deviceVo.getName()));
            this.itemView.setOnClickListener(new View.OnClickListener(){

                public void onClick(View view) {
                    onItemClickListener.onItemClick(deviceVo);
                }
            });
            this.removeView.setOnClickListener(new View.OnClickListener(){

                public void onClick(View view) {
                    onItemClickListener.onRemoveItemClick(deviceVo);
                }
            });
        }

        public TextView getAddressView() {
            return this.addressView;
        }

        public ConstraintLayout getItemView() {
            return this.itemView;
        }

        public TextView getNameView() {
            return this.nameView;
        }

        public TextView getUuidView() {
            return this.uuidView;
        }
    }
}

