/*
 * Decompiled with CFR 0.152.
 */
package com.brytonsport.active.ui.calendar;

import android.content.Context;
import android.content.Intent;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.LinearLayout;
import androidx.lifecycle.Observer;
import androidx.lifecycle.ViewModelProvider;
import com.brytonsport.active.base.App;
import com.brytonsport.active.databinding.ActivityCalendarMonthBinding;
import com.brytonsport.active.db.result.entity.ActivityEntity;
import com.brytonsport.active.ui.calendar.CalendarMonthActivity$$ExternalSyntheticLambda0;
import com.brytonsport.active.ui.calendar.CalendarMonthActivity$$ExternalSyntheticLambda1;
import com.brytonsport.active.ui.calendar.CalendarMonthActivity$$ExternalSyntheticLambda2;
import com.brytonsport.active.ui.calendar.CalendarMonthActivity$$ExternalSyntheticLambda3;
import com.brytonsport.active.ui.calendar.CalendarMonthActivity$$ExternalSyntheticLambda4;
import com.brytonsport.active.ui.calendar.CalendarWeekActivity;
import com.brytonsport.active.ui.calendar.Hilt_CalendarMonthActivity;
import com.brytonsport.active.utils.TimeUtilByLee;
import com.brytonsport.active.utils.TimeUtils;
import com.brytonsport.active.utils.Utils;
import com.brytonsport.active.utils.i18N;
import com.brytonsport.active.views.dialog.MonthSelectDialog;
import com.brytonsport.active.views.view.VerticalProgressBar;
import com.brytonsport.active.vm.calendar.CalendarMonthViewModel;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class CalendarMonthActivity
extends Hilt_CalendarMonthActivity<ActivityCalendarMonthBinding, CalendarMonthViewModel> {
    private int days;
    private int month;
    private SimpleDateFormat monthFormatter;
    private int year;
    private SimpleDateFormat yearFormatter = new SimpleDateFormat("yyyy");

    public CalendarMonthActivity() {
        this.monthFormatter = new SimpleDateFormat("MMM");
    }

    public static Intent createIntent(Context context, int n, int n2) {
        return new Intent(context, CalendarMonthActivity.class).putExtra("year", n).putExtra("month", n2);
    }

    private int getMonthFromBundle() {
        return this.getIntent().getIntExtra("month", 1);
    }

    private int getYearFromBundle() {
        return this.getIntent().getIntExtra("year", 2021);
    }

    private void observeViewModel() {
        ((CalendarMonthViewModel)this.viewModel).getListLiveData().observe(this, new Observer<List<ActivityEntity>>(){

            @Override
            public void onChanged(List<ActivityEntity> list) {
                if (list != null) {
                    StringBuilder stringBuilder = new StringBuilder();
                    stringBuilder.append("onChanged: \u6708\u6aa2\u8996\u66f4\u65b0\u7b46\u6578: ");
                    stringBuilder.append(list.size());
                    Log.d((String)"ActivityBase", (String)stringBuilder.toString());
                    ((CalendarMonthViewModel)CalendarMonthActivity.this.viewModel).prepareDataToView(list);
                    CalendarMonthActivity.this.setData();
                }
            }
        });
    }

    private void refreshHeaderProgressView() {
        ((ActivityCalendarMonthBinding)this.binding).ganttLayout.removeAllViews();
        this.days = TimeUtilByLee.getLastDayByMonth(this.year, this.month - 1);
        for (int i = 0; i < this.days; ++i) {
            VerticalProgressBar verticalProgressBar = new VerticalProgressBar((Context)this);
            ((ActivityCalendarMonthBinding)this.binding).ganttLayout.addView((View)verticalProgressBar, (ViewGroup.LayoutParams)new LinearLayout.LayoutParams(0, -1, 1.0f));
            verticalProgressBar.setProgressWidth(5);
        }
    }

    private void setData() {
        int n;
        ArrayList<CalendarMonthViewModel.MonthActivity> arrayList = ((CalendarMonthViewModel)this.viewModel).getMonthActivityList(this.year, this.month);
        Date object2 = new Date(this.year - 1900, this.month - 1, 1);
        ((ActivityCalendarMonthBinding)this.binding).yearText.setText((CharSequence)String.valueOf(this.year));
        ((ActivityCalendarMonthBinding)this.binding).monthText.setText((CharSequence)this.monthFormatter.format(object2));
        ((ActivityCalendarMonthBinding)this.binding).calendarView.setDate(object2);
        ((ActivityCalendarMonthBinding)this.binding).ganttLayout.removeAllViews();
        int n2 = 0;
        for (n = 0; n < TimeUtilByLee.getLastDayByMonth(this.year, this.month - 1); ++n) {
            VerticalProgressBar verticalProgressBar = new VerticalProgressBar((Context)this);
            ((ActivityCalendarMonthBinding)this.binding).ganttLayout.addView((View)verticalProgressBar, (ViewGroup.LayoutParams)new LinearLayout.LayoutParams(0, -1, 1.0f));
            verticalProgressBar.setProgressWidth(5);
        }
        Iterator<CalendarMonthViewModel.MonthActivity> iterator = arrayList.iterator();
        int n3 = 0;
        n = 0;
        float f = 0.0f;
        float f2 = 0.0f;
        while (iterator.hasNext()) {
            CalendarMonthViewModel.MonthActivity monthActivity = iterator.next();
            int n4 = n3 + monthActivity.rideNumber + monthActivity.runNumber;
            float f3 = f + monthActivity.distance;
            int n5 = n + monthActivity.duration;
            n3 = n4;
            n = n5;
            f = f3;
            if (!(f2 < monthActivity.distance)) continue;
            f2 = monthActivity.distance;
            n3 = n4;
            n = n5;
            f = f3;
        }
        ((ActivityCalendarMonthBinding)this.binding).activitiesText.setText((CharSequence)String.valueOf(n3));
        ((ActivityCalendarMonthBinding)this.binding).activitiesTitle.setText((CharSequence)i18N.get("F_Activity_sub"));
        ((ActivityCalendarMonthBinding)this.binding).timeText.setText((CharSequence)TimeUtils.msToTime((long)n * 1000L));
        ((ActivityCalendarMonthBinding)this.binding).timeTitle.setText((CharSequence)App.get("Time"));
        ((ActivityCalendarMonthBinding)this.binding).distanceText.setText((CharSequence)Utils.convertKMStr(f));
        ((ActivityCalendarMonthBinding)this.binding).distanceUnitText.setText((CharSequence)Utils.getUnitByKM());
        for (n = n2; n < this.days; ++n) {
            ((VerticalProgressBar)((ActivityCalendarMonthBinding)this.binding).ganttLayout.getChildAt(n)).setProgress(0.0f);
            for (CalendarMonthViewModel.MonthActivity monthActivity : arrayList) {
                n3 = monthActivity.getDate().getDate() - 1;
                if (n != n3) continue;
                ((VerticalProgressBar)((ActivityCalendarMonthBinding)this.binding).ganttLayout.getChildAt(n3)).setProgress(monthActivity.distance / f2);
                ((ActivityCalendarMonthBinding)this.binding).calendarView.addSticker(monthActivity.getDate(), monthActivity.getSticker(), monthActivity.rideNumber, monthActivity.runNumber);
            }
        }
    }

    @Override
    protected ActivityCalendarMonthBinding createViewBinding(LayoutInflater layoutInflater) {
        return ActivityCalendarMonthBinding.inflate(layoutInflater);
    }

    @Override
    protected CalendarMonthViewModel createViewModel() {
        return new ViewModelProvider(this).get(CalendarMonthViewModel.class);
    }

    @Override
    protected void initColor() {
        ((ActivityCalendarMonthBinding)this.binding).getRoot().setBackgroundResource(2131034148);
    }

    @Override
    protected void initFont() {
    }

    @Override
    protected void initText() {
        App.put("Activities", i18N.get("F_Result"));
        App.put("Time", i18N.get("Time"));
        this.setTitle(i18N.get("F_Calendar"));
    }

    public /* synthetic */ void lambda$setListeners$0$com-brytonsport-active-ui-calendar-CalendarMonthActivity(int n) {
        this.month = n--;
        this.refreshHeaderProgressView();
        CalendarMonthViewModel calendarMonthViewModel = (CalendarMonthViewModel)this.viewModel;
        int n2 = this.year;
        calendarMonthViewModel.searchRepo(TimeUtilByLee.getFirstDayTimeStampByYearMonth(n2, n), TimeUtilByLee.getLastDayTimeStampByMonth(this.year, n));
    }

    public /* synthetic */ void lambda$setListeners$1$com-brytonsport-active-ui-calendar-CalendarMonthActivity(View view) {
        new MonthSelectDialog((Context)this.activity, this.month).setOnSaveClickListener(new CalendarMonthActivity$$ExternalSyntheticLambda3(this)).showPopup();
    }

    public /* synthetic */ void lambda$setListeners$2$com-brytonsport-active-ui-calendar-CalendarMonthActivity(View view) {
        int n;
        this.month = n = this.month - 1;
        if (n < 1) {
            this.month = 12;
            --this.year;
        }
        this.refreshHeaderProgressView();
        ((CalendarMonthViewModel)this.viewModel).searchRepo(TimeUtilByLee.getFirstDayTimeStampByYearMonth(this.year, this.month - 1), TimeUtilByLee.getLastDayTimeStampByMonth(this.year, this.month - 1));
    }

    public /* synthetic */ void lambda$setListeners$3$com-brytonsport-active-ui-calendar-CalendarMonthActivity(View view) {
        int n;
        this.month = n = this.month + 1;
        if (n > 12) {
            this.month = 1;
            ++this.year;
        }
        this.refreshHeaderProgressView();
        ((CalendarMonthViewModel)this.viewModel).searchRepo(TimeUtilByLee.getFirstDayTimeStampByYearMonth(this.year, this.month - 1), TimeUtilByLee.getLastDayTimeStampByMonth(this.year, this.month - 1));
    }

    public /* synthetic */ void lambda$setListeners$4$com-brytonsport-active-ui-calendar-CalendarMonthActivity(long l) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("setListeners: \u6708\u6aa2\u8996\u9032\u5230\u9031 startTime= ");
        stringBuilder.append(l);
        Log.d((String)"ActivityBase", (String)stringBuilder.toString());
        this.startActivity(CalendarWeekActivity.createIntent((Context)this, l));
    }

    @Override
    protected void onCreate() {
        super.onCreate();
        this.year = this.getYearFromBundle();
        this.month = this.getMonthFromBundle();
        this.refreshHeaderProgressView();
        ((CalendarMonthViewModel)this.viewModel).searchRepo(TimeUtilByLee.getFirstDayTimeStampByYearMonth(this.year, this.month - 1), TimeUtilByLee.getLastDayTimeStampByMonth(this.year, this.month - 1));
        this.observeViewModel();
    }

    @Override
    protected void setListeners() {
        ((ActivityCalendarMonthBinding)this.binding).monthLayout.setOnClickListener((View.OnClickListener)new CalendarMonthActivity$$ExternalSyntheticLambda0(this));
        ((ActivityCalendarMonthBinding)this.binding).prevIcon.setOnClickListener((View.OnClickListener)new CalendarMonthActivity$$ExternalSyntheticLambda1(this));
        ((ActivityCalendarMonthBinding)this.binding).nextIcon.setOnClickListener((View.OnClickListener)new CalendarMonthActivity$$ExternalSyntheticLambda2(this));
        ((ActivityCalendarMonthBinding)this.binding).calendarView.setOnWeekClickListener(new CalendarMonthActivity$$ExternalSyntheticLambda4(this));
    }
}

