/*
 * Decompiled with CFR 0.152.
 */
package com.brytonsport.active.ui.calendar;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.View;
import androidx.lifecycle.Observer;
import androidx.lifecycle.ViewModelProvider;
import com.brytonsport.active.databinding.ActivityCalendarWeekBinding;
import com.brytonsport.active.db.result.entity.ActivityEntity;
import com.brytonsport.active.ui.calendar.CalendarWeekActivity$$ExternalSyntheticLambda0;
import com.brytonsport.active.ui.calendar.CalendarWeekActivity$$ExternalSyntheticLambda1;
import com.brytonsport.active.ui.calendar.CalendarWeekActivity$$ExternalSyntheticLambda2;
import com.brytonsport.active.ui.calendar.CalendarWeekActivity$$ExternalSyntheticLambda3;
import com.brytonsport.active.ui.calendar.CalendarWeekActivity$$ExternalSyntheticLambda4;
import com.brytonsport.active.ui.calendar.Hilt_CalendarWeekActivity;
import com.brytonsport.active.ui.calendar.adapter.CalendarWeekAdapter;
import com.brytonsport.active.ui.calendar.adapter.item.CalendarWeekGanttItem;
import com.brytonsport.active.ui.result.ResultInfoActivity;
import com.brytonsport.active.utils.TimeUtilByLee;
import com.brytonsport.active.utils.i18N;
import com.brytonsport.active.views.dialog.IntegerSelectDialog;
import com.brytonsport.active.views.layoutmanager.AdvancedLinearLayoutManager;
import com.brytonsport.active.vm.base.DayActivity;
import com.brytonsport.active.vm.calendar.CalendarWeekViewModel;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class CalendarWeekActivity
extends Hilt_CalendarWeekActivity<ActivityCalendarWeekBinding, CalendarWeekViewModel> {
    private CalendarWeekAdapter calendarWeekAdapter;
    private Date endDate;
    private SimpleDateFormat monthFormatter;
    private Date startDate;
    private SimpleDateFormat yearFormatter = new SimpleDateFormat("yyyy");

    public CalendarWeekActivity() {
        this.monthFormatter = new SimpleDateFormat("MMM");
        this.startDate = new Date();
        this.endDate = new Date();
    }

    public static Intent createIntent(Context context, long l) {
        return new Intent(context, CalendarWeekActivity.class).putExtra("startTime", l);
    }

    private void observeViewModel() {
        ((CalendarWeekViewModel)this.viewModel).getListLiveData().observe(this, new Observer<List<ActivityEntity>>(){

            @Override
            public void onChanged(List<ActivityEntity> list) {
                if (list != null) {
                    StringBuilder stringBuilder = new StringBuilder();
                    stringBuilder.append("onChanged: \u5468\u6aa2\u8996\u66f4\u65b0\u7b46\u6578: ");
                    stringBuilder.append(list.size());
                    Log.d((String)"ActivityBase", (String)stringBuilder.toString());
                    ((CalendarWeekViewModel)CalendarWeekActivity.this.viewModel).prepareDataToView(list);
                    CalendarWeekActivity.this.setData();
                }
            }
        });
    }

    private void setData() {
        CalendarWeekGanttItem calendarWeekGanttItem = ((ActivityCalendarWeekBinding)this.binding).calendarWeekGanttItem;
        calendarWeekGanttItem.setStartDate(this.startDate);
        calendarWeekGanttItem.setDayActivityList(((CalendarWeekViewModel)this.viewModel).getListByWeek(this.startDate));
        this.calendarWeekAdapter.swapItems(((CalendarWeekViewModel)this.viewModel).getDayListByWeek(this.startDate));
    }

    @Override
    protected ActivityCalendarWeekBinding createViewBinding(LayoutInflater layoutInflater) {
        return ActivityCalendarWeekBinding.inflate(layoutInflater);
    }

    @Override
    protected CalendarWeekViewModel createViewModel() {
        return new ViewModelProvider(this).get(CalendarWeekViewModel.class);
    }

    public Date getStartDateFromBundle() {
        return new Date(this.getIntent().getLongExtra("startTime", new Date().getTime()));
    }

    @Override
    protected void initColor() {
        ((ActivityCalendarWeekBinding)this.binding).getRoot().setBackgroundResource(2131034148);
    }

    @Override
    protected void initFont() {
    }

    @Override
    protected void initText() {
        this.setTitle(i18N.get("F_Calendar"));
    }

    public /* synthetic */ void lambda$setListeners$0$com-brytonsport-active-ui-calendar-CalendarWeekActivity(CalendarWeekGanttItem calendarWeekGanttItem, String string2) {
        this.startDate = calendarWeekGanttItem.setStartDateByWeekIndex(Integer.parseInt(string2.split(" ")[0]));
        ((CalendarWeekViewModel)this.viewModel).searchRepo(TimeUtilByLee.getFirstDayTimeStampByWeek(this.startDate), TimeUtilByLee.getLastDayTimeStampByWeek(this.startDate));
    }

    public /* synthetic */ void lambda$setListeners$1$com-brytonsport-active-ui-calendar-CalendarWeekActivity(CalendarWeekGanttItem calendarWeekGanttItem, View object) {
        object = new StringBuilder();
        ((StringBuilder)object).append(calendarWeekGanttItem.binding.weekText.getText().toString());
        ((StringBuilder)object).append(" week");
        object = ((StringBuilder)object).toString();
        new IntegerSelectDialog((Context)this.activity, i18N.get("T_week"), i18N.get("T_week"), 52, 1, (String)object).setOnSaveClickListener(new CalendarWeekActivity$$ExternalSyntheticLambda4(this, calendarWeekGanttItem)).showPopup();
    }

    public /* synthetic */ void lambda$setListeners$2$com-brytonsport-active-ui-calendar-CalendarWeekActivity(View view) {
        this.startDate = new Date(this.startDate.getTime() - 604800000L);
        ((CalendarWeekViewModel)this.viewModel).searchRepo(TimeUtilByLee.getFirstDayTimeStampByWeek(this.startDate), TimeUtilByLee.getLastDayTimeStampByWeek(this.startDate));
    }

    public /* synthetic */ void lambda$setListeners$3$com-brytonsport-active-ui-calendar-CalendarWeekActivity(View view) {
        this.startDate = new Date(this.startDate.getTime() + 604800000L);
        ((CalendarWeekViewModel)this.viewModel).searchRepo(TimeUtilByLee.getFirstDayTimeStampByWeek(this.startDate), TimeUtilByLee.getLastDayTimeStampByWeek(this.startDate));
    }

    public /* synthetic */ void lambda$setListeners$4$com-brytonsport-active-ui-calendar-CalendarWeekActivity(DayActivity dayActivity) {
        this.startActivity(ResultInfoActivity.createIntent((Context)this.activity, dayActivity));
    }

    @Override
    protected void onCreate() {
        super.onCreate();
        this.startDate = this.getStartDateFromBundle();
        ((CalendarWeekViewModel)this.viewModel).searchRepo(TimeUtilByLee.getFirstDayTimeStampByWeek(this.startDate), TimeUtilByLee.getLastDayTimeStampByWeek(this.startDate));
        ArrayList<Object> arrayList = new ArrayList<Object>();
        ((ActivityCalendarWeekBinding)this.binding).calenderList.setLayoutManager(new AdvancedLinearLayoutManager((Context)this));
        this.calendarWeekAdapter = new CalendarWeekAdapter((Activity)this, arrayList);
        ((ActivityCalendarWeekBinding)this.binding).calenderList.setAdapter(this.calendarWeekAdapter);
        this.observeViewModel();
    }

    @Override
    protected void setListeners() {
        CalendarWeekGanttItem calendarWeekGanttItem = ((ActivityCalendarWeekBinding)this.binding).calendarWeekGanttItem;
        calendarWeekGanttItem.binding.weekLayout.setOnClickListener((View.OnClickListener)new CalendarWeekActivity$$ExternalSyntheticLambda2(this, calendarWeekGanttItem));
        calendarWeekGanttItem.binding.prevIcon.setOnClickListener((View.OnClickListener)new CalendarWeekActivity$$ExternalSyntheticLambda0(this));
        calendarWeekGanttItem.binding.nextIcon.setOnClickListener((View.OnClickListener)new CalendarWeekActivity$$ExternalSyntheticLambda1(this));
        this.calendarWeekAdapter.setOnActionClickListener(new CalendarWeekActivity$$ExternalSyntheticLambda3(this));
    }
}

