/*
 * Decompiled with CFR 0.152.
 */
package com.brytonsport.active.ui.calendar.adapter.item;

import android.content.Context;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import com.brytonsport.active.base.App;
import com.brytonsport.active.databinding.ItemCalendarWeekGanttBinding;
import com.brytonsport.active.utils.TimeUtils;
import com.brytonsport.active.utils.Utils;
import com.brytonsport.active.utils.i18N;
import com.brytonsport.active.vm.base.DayActivity;
import com.james.views.FreeLayout;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;

public class CalendarWeekGanttItem
extends FreeLayout {
    public ItemCalendarWeekGanttBinding binding;
    private Date firstDate;
    private SimpleDateFormat monthFormatter = new SimpleDateFormat("MMM");

    public CalendarWeekGanttItem(Context context) {
        super(context);
        this.init(context);
    }

    public CalendarWeekGanttItem(Context context, AttributeSet attributeSet) {
        super(context, attributeSet);
        this.init(context);
    }

    public CalendarWeekGanttItem(Context context, AttributeSet attributeSet, int n) {
        super(context, attributeSet, n);
        this.init(context);
    }

    private boolean equalDate(Date date, Date date2) {
        boolean bl = date.getYear() == date2.getYear() && date.getMonth() == date2.getMonth() && date.getDate() == date2.getDate();
        return bl;
    }

    private void init(Context object) {
        object = ItemCalendarWeekGanttBinding.inflate(LayoutInflater.from((Context)object));
        this.binding = object;
        this.addFreeView((View)((ItemCalendarWeekGanttBinding)object).getRoot(), -1, -2);
        this.binding.activityTitle.setText((CharSequence)App.get("\u6d3b\u52d5"));
        this.binding.timeTitle.setText((CharSequence)App.get("\u6642\u9593"));
        this.binding.distanceText.setText((CharSequence)"");
        this.binding.activityText.setText((CharSequence)"");
        this.binding.hourText.setText((CharSequence)"");
        this.binding.minuteText.setText((CharSequence)"");
        this.binding.weekText.setText((CharSequence)"--");
        if (App.isFirstDayMonday()) {
            this.binding.progress1.setText(i18N.get("Monday"));
            this.binding.progress2.setText(i18N.get("TuesDay"));
            this.binding.progress3.setText(i18N.get("Wednesday"));
            this.binding.progress4.setText(i18N.get("Thursday"));
            this.binding.progress5.setText(i18N.get("Friday"));
            this.binding.progress6.setText(i18N.get("Saturday"));
            this.binding.progress7.setText(i18N.get("Sunday"));
        } else {
            this.binding.progress1.setText(i18N.get("Sunday"));
            this.binding.progress2.setText(i18N.get("Monday"));
            this.binding.progress3.setText(i18N.get("TuesDay"));
            this.binding.progress4.setText(i18N.get("Wednesday"));
            this.binding.progress5.setText(i18N.get("Thursday"));
            this.binding.progress6.setText(i18N.get("Friday"));
            this.binding.progress7.setText(i18N.get("Saturday"));
        }
    }

    public void setDayActivityList(ArrayList<DayActivity> textView) {
        float f;
        HashMap<Integer, Float> hashMap = new HashMap<Integer, Float>();
        int n = 0;
        Integer n2 = 0;
        int n3 = 0;
        while (true) {
            f = 0.0f;
            if (n3 >= 7) break;
            hashMap.put(n3, Float.valueOf(0.0f));
            ++n3;
        }
        Iterator<DayActivity> iterator = textView.iterator();
        float f2 = 0.0f;
        n3 = n;
        while (iterator.hasNext()) {
            DayActivity dayActivity = iterator.next();
            int n4 = dayActivity.getDayOfWeek() - 1;
            float f3 = (float)dayActivity.distance;
            float f4 = f + f3;
            n = n3 + dayActivity.duration;
            if (hashMap.get(n4) != null) {
                hashMap.put(n4, Float.valueOf(f3 += ((Float)hashMap.get(n4)).floatValue()));
            } else {
                hashMap.put(n4, Float.valueOf(f3));
            }
            n3 = n;
            f = f4;
            if (!(f2 < f3)) continue;
            n3 = n;
            f2 = f3;
            f = f4;
        }
        if (App.isFirstDayMonday()) {
            this.binding.progress1.setProgress(((Float)hashMap.get(1)).floatValue() / f2);
            this.binding.progress2.setProgress(((Float)hashMap.get(2)).floatValue() / f2);
            this.binding.progress3.setProgress(((Float)hashMap.get(3)).floatValue() / f2);
            this.binding.progress4.setProgress(((Float)hashMap.get(4)).floatValue() / f2);
            this.binding.progress5.setProgress(((Float)hashMap.get(5)).floatValue() / f2);
            this.binding.progress6.setProgress(((Float)hashMap.get(6)).floatValue() / f2);
            this.binding.progress7.setProgress(((Float)hashMap.get(n2)).floatValue() / f2);
        } else {
            this.binding.progress1.setProgress(((Float)hashMap.get(n2)).floatValue() / f2);
            this.binding.progress2.setProgress(((Float)hashMap.get(1)).floatValue() / f2);
            this.binding.progress3.setProgress(((Float)hashMap.get(2)).floatValue() / f2);
            this.binding.progress4.setProgress(((Float)hashMap.get(3)).floatValue() / f2);
            this.binding.progress5.setProgress(((Float)hashMap.get(4)).floatValue() / f2);
            this.binding.progress6.setProgress(((Float)hashMap.get(5)).floatValue() / f2);
            this.binding.progress7.setProgress(((Float)hashMap.get(6)).floatValue() / f2);
        }
        this.binding.distanceText.setText((CharSequence)Utils.convertKMStr(f));
        this.binding.distanceUnitText.setText((CharSequence)Utils.getUnitByKM());
        this.binding.activityText.setText((CharSequence)String.valueOf(textView.size()));
        textView = this.binding.hourText;
        textView.setText((CharSequence)String.valueOf((n3 /= 60) / 60));
        this.binding.minuteText.setText((CharSequence)String.valueOf(n3 % 60));
    }

    public void setStartDate(Date comparable) {
        Date date = new Date(((Date)comparable).getTime() + TimeUtils.WEEK - 1000L);
        this.firstDate = ((Date)comparable).getYear() < date.getYear() ? new Date(date.getYear(), 0, 1) : new Date(((Date)comparable).getYear(), 0, 1);
        int n = (int)Math.floor((((Date)comparable).getTime() - this.firstDate.getTime()) / TimeUtils.WEEK);
        this.binding.yearText.setText((CharSequence)String.valueOf(this.firstDate.getYear() + 1900));
        date = this.binding.weekText;
        comparable = new StringBuilder();
        ((StringBuilder)comparable).append("");
        ((StringBuilder)comparable).append(n + 1);
        date.setText(((StringBuilder)comparable).toString());
    }

    public Date setStartDateByWeekIndex(int n) {
        if (this.firstDate == null) {
            this.firstDate = new Date();
        }
        Date date = new Date(this.firstDate.getTime() + (long)(n - 1) * TimeUtils.WEEK);
        n = date.getDay();
        if (App.isFirstDayMonday()) {
            n = date.getDay() == 0 ? 6 : date.getDay();
            --n;
        }
        date = new Date(date.getTime() - (long)n * TimeUtils.DAY);
        this.setStartDate(date);
        return date;
    }
}

