/*
 * Decompiled with CFR 0.152.
 */
package com.brytonsport.active.ui.course;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.graphics.Color;
import android.graphics.drawable.Drawable;
import android.util.Log;
import android.view.LayoutInflater;
import androidx.lifecycle.ViewModelProvider;
import com.brytonsport.active.databinding.ActivityCourseGroupTrackMapBinding;
import com.brytonsport.active.ui.course.Hilt_CourseGroupTrackMapActivity;
import com.brytonsport.active.utils.ToastUtil;
import com.brytonsport.active.utils.i18N;
import com.brytonsport.active.vm.base.GroupTrack;
import com.brytonsport.active.vm.course.CourseGroupTrackInfoViewModel;
import com.google.gson.Gson;
import com.mapbox.geojson.Feature;
import com.mapbox.geojson.FeatureCollection;
import com.mapbox.geojson.Geometry;
import com.mapbox.geojson.LineString;
import com.mapbox.geojson.Point;
import com.mapbox.mapboxsdk.camera.CameraUpdateFactory;
import com.mapbox.mapboxsdk.geometry.LatLng;
import com.mapbox.mapboxsdk.geometry.LatLngBounds;
import com.mapbox.mapboxsdk.maps.MapboxMap;
import com.mapbox.mapboxsdk.maps.OnMapReadyCallback;
import com.mapbox.mapboxsdk.maps.Style;
import com.mapbox.mapboxsdk.plugins.localization.LocalizationPlugin;
import com.mapbox.mapboxsdk.style.layers.Layer;
import com.mapbox.mapboxsdk.style.layers.LineLayer;
import com.mapbox.mapboxsdk.style.layers.PropertyFactory;
import com.mapbox.mapboxsdk.style.layers.PropertyValue;
import com.mapbox.mapboxsdk.style.layers.SymbolLayer;
import com.mapbox.mapboxsdk.style.sources.GeoJsonSource;
import com.mapbox.mapboxsdk.style.sources.Source;
import com.mapbox.mapboxsdk.utils.BitmapUtils;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.List;
import org.json.JSONException;
import org.json.JSONObject;
import pub.devrel.easypermissions.AfterPermissionGranted;
import pub.devrel.easypermissions.EasyPermissions;

public class CourseGroupTrackMapActivity
extends Hilt_CourseGroupTrackMapActivity<ActivityCourseGroupTrackMapBinding, CourseGroupTrackInfoViewModel> {
    private static final int RC_LOCATION = 24;
    private String ICON_END_SOURCE_ID = "icon-end-source-id";
    private String ICON_POI_CHECK_POINT_SOURCE_ID = "icon-poi-checkpoint-source-id";
    private String ICON_POI_DRINK_SOURCE_ID = "icon-poi-drink-source-id";
    private String ICON_POI_EMERGENCY_SOURCE_ID = "icon-poi-emergency-source-id";
    private String ICON_POI_FOOD_SOURCE_ID = "icon-poi-food-source-id";
    private String ICON_POI_GENERAL_SOURCE_ID = "icon-poi-general-source-id";
    private String ICON_POI_MEETING_POINT_SOURCE_ID = "icon-poi-meetingpoint-source-id";
    private String ICON_POI_PEAK_SOURCE_ID = "icon-poi-peak-source-id";
    private String ICON_POI_SOURCE_ID = "icon-poi-source-id";
    private String ICON_START_SOURCE_ID = "icon-start-source-id";
    private String NOW_POI_SOURCE_ID = "";
    private GeoJsonSource geoJsonSource;
    private LatLngBounds latLngBounds;
    private List<LatLng> latLngList;
    private MapboxMap mMapboxMap;
    private Style mapBoxStyle;
    private GeoJsonSource poiMarkerGeoJsonSource = null;
    private List<Point> points = new ArrayList<Point>();

    public CourseGroupTrackMapActivity() {
        this.latLngList = new ArrayList<LatLng>();
    }

    static /* synthetic */ MapboxMap access$002(CourseGroupTrackMapActivity courseGroupTrackMapActivity, MapboxMap mapboxMap) {
        courseGroupTrackMapActivity.mMapboxMap = mapboxMap;
        return mapboxMap;
    }

    static /* synthetic */ Style access$102(CourseGroupTrackMapActivity courseGroupTrackMapActivity, Style style2) {
        courseGroupTrackMapActivity.mapBoxStyle = style2;
        return style2;
    }

    private void addEndMarkerImage(Style style2, double d, double d2) {
        style2.addSource((Source)new GeoJsonSource(this.ICON_END_SOURCE_ID, FeatureCollection.fromFeatures((Feature[])new Feature[]{Feature.fromGeometry((Geometry)Point.fromLngLat((double)d2, (double)d))})));
    }

    private void addPoiLayer(Style style2) {
        style2.addLayer((Layer)new SymbolLayer("symbol-layer-id3", this.ICON_POI_SOURCE_ID).withProperties(new PropertyValue[]{PropertyFactory.iconImage((String)"icon-poi-point"), PropertyFactory.iconSize((Float)Float.valueOf(0.3f)), PropertyFactory.iconAnchor((String)"bottom")}));
    }

    private void addPoiMarkerImage(Style style2, String string2, double d, double d2) {
        GeoJsonSource geoJsonSource;
        if (!this.NOW_POI_SOURCE_ID.equals(string2)) {
            if (style2.getLayer("symbol-layer-id3") == null) {
                this.addPoiLayer(style2);
            } else {
                style2.getLayer("symbol-layer-id3").setProperties(new PropertyValue[]{PropertyFactory.iconImage((String)string2)});
            }
        }
        if ((geoJsonSource = this.poiMarkerGeoJsonSource) == null) {
            this.NOW_POI_SOURCE_ID = string2;
            string2 = new GeoJsonSource(this.ICON_POI_SOURCE_ID, FeatureCollection.fromFeatures((Feature[])new Feature[]{Feature.fromGeometry((Geometry)Point.fromLngLat((double)d2, (double)d))}));
            this.poiMarkerGeoJsonSource = string2;
            style2.addSource((Source)string2);
        } else {
            geoJsonSource.setGeoJson(FeatureCollection.fromFeatures((Feature[])new Feature[]{Feature.fromGeometry((Geometry)Point.fromLngLat((double)d2, (double)d))}));
        }
    }

    private void addStartEndMarker() {
        Point point = this.points;
        if (point != null && point.size() > 0) {
            point = this.points.get(0);
            Point point2 = this.points;
            point2 = point2.get(point2.size() - 1);
            this.addStartMarkerImage(this.mapBoxStyle, point.latitude(), point.longitude());
            this.addEndMarkerImage(this.mapBoxStyle, point2.latitude(), point2.longitude());
        }
    }

    private void addStartMarkerImage(Style style2, double d, double d2) {
        style2.addSource((Source)new GeoJsonSource(this.ICON_START_SOURCE_ID, FeatureCollection.fromFeatures((Feature[])new Feature[]{Feature.fromGeometry((Geometry)Point.fromLngLat((double)d2, (double)d))})));
    }

    public static Intent createIntent(Context context, GroupTrack groupTrack) {
        return new Intent(context, CourseGroupTrackMapActivity.class).putExtra("groupTrack", groupTrack.encode());
    }

    private void drawMapRoute() {
        LatLngBounds latLngBounds = this.latLngBounds;
        if (latLngBounds != null) {
            this.mMapboxMap.easeCamera(CameraUpdateFactory.newLatLngBounds((LatLngBounds)latLngBounds, (int)150), 1000);
        }
        latLngBounds = Feature.fromGeometry((Geometry)LineString.fromLngLats(this.points));
        GeoJsonSource geoJsonSource = this.geoJsonSource;
        if (geoJsonSource == null) {
            latLngBounds = new GeoJsonSource("geojson-source", (Feature)latLngBounds);
            this.geoJsonSource = latLngBounds;
            this.mapBoxStyle.addSource((Source)latLngBounds);
        } else {
            geoJsonSource.setGeoJson((Feature)latLngBounds);
        }
        this.mapBoxStyle.addLayer((Layer)new LineLayer("linelayer", "geojson-source").withProperties(new PropertyValue[]{PropertyFactory.lineJoin((String)"round"), PropertyFactory.lineWidth((Float)Float.valueOf(4.0f)), PropertyFactory.lineColor((int)Color.parseColor((String)"#003ADB"))}));
    }

    private GroupTrack getGroupTrackFromBundle() {
        return (GroupTrack)new Gson().fromJson(this.getIntent().getStringExtra("groupTrack"), GroupTrack.class);
    }

    private void initMap() {
        ((ActivityCourseGroupTrackMapBinding)this.binding).mapView.getMapAsync(new OnMapReadyCallback(){

            public void onMapReady(final MapboxMap mapboxMap) {
                CourseGroupTrackMapActivity.access$002(CourseGroupTrackMapActivity.this, mapboxMap);
                mapboxMap.setStyle("mapbox://styles/mapbox/streets-v11", new Style.OnStyleLoaded(){

                    public void onStyleLoaded(Style style2) {
                        CourseGroupTrackMapActivity.access$102(CourseGroupTrackMapActivity.this, style2);
                        CourseGroupTrackMapActivity.this.initSymbolLayer(style2);
                        style2 = new LocalizationPlugin(((ActivityCourseGroupTrackMapBinding)CourseGroupTrackMapActivity.this.binding).mapView, mapboxMap, style2);
                        try {
                            style2.matchMapLanguageWithDeviceDefault();
                        }
                        catch (RuntimeException runtimeException) {
                            Log.d((String)"ActivityBase", (String)runtimeException.toString());
                        }
                        if (((CourseGroupTrackInfoViewModel)CourseGroupTrackMapActivity.this.viewModel).decodeObj != null) {
                            CourseGroupTrackMapActivity.this.setMapPoints(((CourseGroupTrackInfoViewModel)CourseGroupTrackMapActivity.this.viewModel).decodeObj);
                            CourseGroupTrackMapActivity.this.addStartEndMarker();
                            CourseGroupTrackMapActivity.this.drawMapRoute();
                        } else {
                            ToastUtil.showToast((Context)CourseGroupTrackMapActivity.this.activity, "fit\u6a94\u89e3\u78bc\u932f\u8aa4, \u5716\u8cc7\u986f\u793a\u7565\u904e");
                        }
                    }
                });
            }
        });
    }

    private void initSymbolLayer(Style style2) {
        style2.addImage("icon-start-point", BitmapUtils.getBitmapFromDrawable((Drawable)this.getResources().getDrawable(2131165530)));
        style2.addImage("icon-end-point", BitmapUtils.getBitmapFromDrawable((Drawable)this.getResources().getDrawable(2131165528)));
        SymbolLayer symbolLayer = new SymbolLayer("symbol-layer-id", this.ICON_START_SOURCE_ID);
        PropertyValue propertyValue = PropertyFactory.iconImage((String)"icon-start-point");
        Float f = Float.valueOf(0.3f);
        style2.addLayer((Layer)symbolLayer.withProperties(new PropertyValue[]{propertyValue, PropertyFactory.iconSize((Float)f), PropertyFactory.iconAnchor((String)"bottom")}));
        style2.addLayer((Layer)new SymbolLayer("symbol-layer-id2", this.ICON_END_SOURCE_ID).withProperties(new PropertyValue[]{PropertyFactory.iconImage((String)"icon-end-point"), PropertyFactory.iconSize((Float)f), PropertyFactory.iconAnchor((String)"bottom")}));
    }

    @AfterPermissionGranted(value=24)
    private void methodRequiresTwoPermission() {
        String[] stringArray = new String[]{"android.permission.ACCESS_COARSE_LOCATION", "android.permission.ACCESS_FINE_LOCATION"};
        if (EasyPermissions.hasPermissions((Context)this, (String[])stringArray)) {
            if (((CourseGroupTrackInfoViewModel)this.viewModel).decodeObj != null) {
                this.initMap();
            }
        } else {
            EasyPermissions.requestPermissions((Activity)this, (String)i18N.get("FaqGpsTitleFornine"), (int)24, (String[])stringArray);
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String readJsonFile(int var1_1) {
        block15: {
            block14: {
                var2_2 = this.getResources().openRawResource(var1_1);
                var3_4 = new StringWriter();
                var4_5 = new char[1024];
                try {
                    var6_10 = new InputStreamReader((InputStream)var2_2, "UTF-8");
                    var5_6 = new BufferedReader(var6_10);
                    break block14;
                }
                catch (Throwable var5_7) {
                    break block15;
                }
                catch (UnsupportedEncodingException var5_8) {
                    var5_8.printStackTrace();
                    var5_6 = null;
                }
            }
            while (true) {
                try {
                    var1_1 = var5_6.read(var4_5);
                    if (var1_1 == -1) {
                    }
                    ** GOTO lbl-1000
                }
                catch (IOException var6_11) {
                    var6_11.printStackTrace();
                }
                try {
                    var2_2.close();
                }
                catch (IOException var5_9) {
                    var5_9.printStackTrace();
                }
                var2_2 = var3_4.toString();
                var5_6 = new StringBuilder();
                var5_6.append("readJsonFile: ");
                var5_6.append((String)var2_2);
                Log.d((String)"", (String)var5_6.toString());
                return var2_2;
lbl-1000:
                // 1 sources

                {
                    var3_4.write(var4_5, 0, var1_1);
                }
            }
        }
        try {
            var2_2.close();
            throw var5_7;
        }
        catch (IOException var2_3) {
            var2_3.printStackTrace();
        }
        throw var5_7;
    }

    private void setMapPoints(JSONObject jSONObject) {
        block9: {
            this.points = new ArrayList<Point>();
            jSONObject = jSONObject.getJSONArray("points");
            if (jSONObject == null) break block9;
            if (jSONObject.length() <= 0) break block9;
            int n = 0;
            while (true) {
                if (n >= jSONObject.length()) break;
                JSONObject jSONObject2 = jSONObject.getJSONObject(n);
                double d = jSONObject2.getDouble("position_lat");
                double d2 = jSONObject2.getDouble("position_long");
                jSONObject2 = Point.fromLngLat((double)d2, (double)d);
                this.points.add((Point)jSONObject2);
                jSONObject2 = new LatLng(d, d2);
                this.latLngList.add((LatLng)jSONObject2);
                ++n;
                continue;
                break;
            }
            try {
                if (this.latLngBounds == null) {
                    if (this.points.size() >= 2) {
                        jSONObject = new LatLngBounds.Builder();
                        this.latLngBounds = jSONObject.includes(this.latLngList).build();
                    }
                } else {
                    this.latLngBounds = null;
                    jSONObject = new LatLngBounds.Builder();
                    this.latLngBounds = jSONObject.includes(this.latLngList).build();
                }
            }
            catch (JSONException jSONException) {
                jSONException.printStackTrace();
            }
        }
    }

    @Override
    protected ActivityCourseGroupTrackMapBinding createViewBinding(LayoutInflater layoutInflater) {
        return ActivityCourseGroupTrackMapBinding.inflate(layoutInflater);
    }

    @Override
    protected CourseGroupTrackInfoViewModel createViewModel() {
        CourseGroupTrackInfoViewModel courseGroupTrackInfoViewModel = new ViewModelProvider(this).get(CourseGroupTrackInfoViewModel.class);
        courseGroupTrackInfoViewModel.groupTrack = this.getGroupTrackFromBundle();
        return courseGroupTrackInfoViewModel;
    }

    @Override
    protected void initColor() {
    }

    @Override
    protected void initFont() {
    }

    @Override
    protected void initText() {
        this.setTitle(((CourseGroupTrackInfoViewModel)this.viewModel).groupTrack.groupName);
    }

    @Override
    protected void onCreate() {
        super.onCreate();
        ((ActivityCourseGroupTrackMapBinding)this.binding).mapView.onCreate(null);
        this.methodRequiresTwoPermission();
        ((CourseGroupTrackInfoViewModel)this.viewModel).decodePlanTripFitForDetail();
    }

    @Override
    protected void onDestroy() {
        super.onDestroy();
        ((ActivityCourseGroupTrackMapBinding)this.binding).mapView.onDestroy();
    }

    @Override
    public void onLowMemory() {
        super.onLowMemory();
        ((ActivityCourseGroupTrackMapBinding)this.binding).mapView.onLowMemory();
    }

    @Override
    public void onPause() {
        super.onPause();
        ((ActivityCourseGroupTrackMapBinding)this.binding).mapView.onPause();
    }

    @Override
    public void onRequestPermissionsResult(int n, String[] stringArray, int[] nArray) {
        super.onRequestPermissionsResult(n, stringArray, nArray);
        EasyPermissions.onRequestPermissionsResult((int)n, (String[])stringArray, (int[])nArray, (Object[])new Object[]{this});
    }

    @Override
    public void onResume() {
        super.onResume();
        ((ActivityCourseGroupTrackMapBinding)this.binding).mapView.onResume();
    }

    @Override
    protected void onStart() {
        super.onStart();
        ((ActivityCourseGroupTrackMapBinding)this.binding).mapView.onStart();
    }

    @Override
    protected void onStop() {
        super.onStop();
        ((ActivityCourseGroupTrackMapBinding)this.binding).mapView.onStop();
    }

    @Override
    protected void setListeners() {
    }
}

