/*
 * Decompiled with CFR 0.152.
 */
package com.brytonsport.active.ui.course;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.graphics.Color;
import android.graphics.drawable.Drawable;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.animation.AnimationUtils;
import android.widget.FrameLayout;
import android.widget.TextView;
import androidx.lifecycle.Observer;
import androidx.lifecycle.ViewModelProvider;
import com.brytonsport.active.base.App;
import com.brytonsport.active.databinding.ActivityCourseMarkPositionBinding;
import com.brytonsport.active.ui.course.CourseMarkPositionActivity$$ExternalSyntheticLambda0;
import com.brytonsport.active.ui.course.CourseMarkPositionActivity$$ExternalSyntheticLambda1;
import com.brytonsport.active.ui.course.CourseMarkPositionActivity$$ExternalSyntheticLambda2;
import com.brytonsport.active.ui.course.CourseMarkPositionActivity$$ExternalSyntheticLambda3;
import com.brytonsport.active.ui.course.CourseMarkPositionActivity$$ExternalSyntheticLambda4;
import com.brytonsport.active.ui.course.CourseNavigationInfoActivity;
import com.brytonsport.active.ui.course.Hilt_CourseMarkPositionActivity;
import com.brytonsport.active.utils.Utils;
import com.brytonsport.active.utils.i18N;
import com.brytonsport.active.views.dialog.InputDialog;
import com.brytonsport.active.vm.base.SearchResult;
import com.brytonsport.active.vm.course.CourseMarkPositionViewModel;
import com.mapbox.geojson.Feature;
import com.mapbox.geojson.FeatureCollection;
import com.mapbox.geojson.Geometry;
import com.mapbox.geojson.LineString;
import com.mapbox.geojson.Point;
import com.mapbox.mapboxsdk.camera.CameraUpdateFactory;
import com.mapbox.mapboxsdk.geometry.LatLng;
import com.mapbox.mapboxsdk.geometry.LatLngBounds;
import com.mapbox.mapboxsdk.location.LocationComponent;
import com.mapbox.mapboxsdk.location.LocationComponentActivationOptions;
import com.mapbox.mapboxsdk.maps.MapboxMap;
import com.mapbox.mapboxsdk.maps.OnMapReadyCallback;
import com.mapbox.mapboxsdk.maps.Style;
import com.mapbox.mapboxsdk.plugins.localization.LocalizationPlugin;
import com.mapbox.mapboxsdk.plugins.markerview.MarkerView;
import com.mapbox.mapboxsdk.plugins.markerview.MarkerViewManager;
import com.mapbox.mapboxsdk.style.layers.Layer;
import com.mapbox.mapboxsdk.style.layers.LineLayer;
import com.mapbox.mapboxsdk.style.layers.PropertyFactory;
import com.mapbox.mapboxsdk.style.layers.PropertyValue;
import com.mapbox.mapboxsdk.style.layers.SymbolLayer;
import com.mapbox.mapboxsdk.style.sources.GeoJsonSource;
import com.mapbox.mapboxsdk.style.sources.Source;
import com.mapbox.mapboxsdk.utils.BitmapUtils;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import pub.devrel.easypermissions.AfterPermissionGranted;
import pub.devrel.easypermissions.EasyPermissions;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class CourseMarkPositionActivity
extends Hilt_CourseMarkPositionActivity<ActivityCourseMarkPositionBinding, CourseMarkPositionViewModel> {
    private static final int RC_LOCATION = 21;
    private String ICON_SOURCE_ID = "icon-source-id";
    private GeoJsonSource geoJsonSource;
    private LatLngBounds latLngBounds;
    private List<LatLng> latLngList = new ArrayList<LatLng>();
    private MapboxMap mMapboxMap;
    private Style mapBoxStyle;
    private MarkerView markerView;
    private MarkerViewManager markerViewManager;
    private List<Point> points = new ArrayList<Point>();

    static /* synthetic */ MapboxMap access$002(CourseMarkPositionActivity courseMarkPositionActivity, MapboxMap mapboxMap) {
        courseMarkPositionActivity.mMapboxMap = mapboxMap;
        return mapboxMap;
    }

    static /* synthetic */ Style access$102(CourseMarkPositionActivity courseMarkPositionActivity, Style style2) {
        courseMarkPositionActivity.mapBoxStyle = style2;
        return style2;
    }

    private void addMarkerImage(Style style2, double d, double d2) {
        style2.addSource((Source)new GeoJsonSource(this.ICON_SOURCE_ID, FeatureCollection.fromFeatures((Feature[])new Feature[]{Feature.fromGeometry((Geometry)Point.fromLngLat((double)d2, (double)d))})));
    }

    private void addMarkerView(int n, LatLng latLng) {
        if (this.markerViewManager == null) {
            this.markerViewManager = new MarkerViewManager(((ActivityCourseMarkPositionBinding)this.binding).mapView, this.mMapboxMap);
        }
        View view = LayoutInflater.from((Context)this).inflate(2131427539, null);
        view.setLayoutParams((ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-2, -2));
        ((TextView)view.findViewById(2131231353)).setText((CharSequence)String.valueOf(n));
        latLng = new MarkerView(latLng, view);
        this.markerView = latLng;
        this.markerViewManager.addMarker((MarkerView)latLng);
    }

    public static Intent createIntent(Context context, SearchResult searchResult) {
        return new Intent(context, CourseMarkPositionActivity.class).putExtra("data", searchResult.encode());
    }

    private void drawMapRoute() {
        LatLngBounds latLngBounds = this.latLngBounds;
        if (latLngBounds != null) {
            this.mMapboxMap.easeCamera(CameraUpdateFactory.newLatLngBounds((LatLngBounds)latLngBounds, (int)150), 1000);
        }
        Feature feature = Feature.fromGeometry((Geometry)LineString.fromLngLats(this.points));
        latLngBounds = this.geoJsonSource;
        if (latLngBounds == null) {
            latLngBounds = new GeoJsonSource("geojson-source", feature);
            this.geoJsonSource = latLngBounds;
            this.mapBoxStyle.addSource((Source)latLngBounds);
            this.mapBoxStyle.addLayer((Layer)new LineLayer("linelayer", "geojson-source").withProperties(new PropertyValue[]{PropertyFactory.lineJoin((String)"round"), PropertyFactory.lineWidth((Float)Float.valueOf(4.0f)), PropertyFactory.lineColor((int)Color.parseColor((String)"#003ADB"))}));
        } else {
            latLngBounds.setGeoJson(feature);
        }
    }

    private void enableLocationComponent(Style style2) {
        LocationComponent locationComponent = this.mMapboxMap.getLocationComponent();
        locationComponent.activateLocationComponent(LocationComponentActivationOptions.builder((Context)this, (Style)style2).build());
        locationComponent.setLocationComponentEnabled(true);
        locationComponent.setCameraMode(24);
        locationComponent.setRenderMode(4);
    }

    private SearchResult getSearchResultFromBundle() {
        return new SearchResult(this.getIntent().getStringExtra("data"));
    }

    private void initMap() {
        ((ActivityCourseMarkPositionBinding)this.binding).mapView.getMapAsync(new OnMapReadyCallback(){

            public void onMapReady(final MapboxMap mapboxMap) {
                CourseMarkPositionActivity.access$002(CourseMarkPositionActivity.this, mapboxMap);
                mapboxMap.setStyle("mapbox://styles/mapbox/streets-v11", new Style.OnStyleLoaded(){

                    public void onStyleLoaded(Style object) {
                        CourseMarkPositionActivity.access$102(CourseMarkPositionActivity.this, (Style)object);
                        CourseMarkPositionActivity.this.initSymbolLayer((Style)object);
                        CourseMarkPositionActivity.this.enableLocationComponent(CourseMarkPositionActivity.this.mapBoxStyle);
                        CourseMarkPositionActivity.this.setMapView();
                        object = new LocalizationPlugin(((ActivityCourseMarkPositionBinding)CourseMarkPositionActivity.this.binding).mapView, mapboxMap, (Style)object);
                        try {
                            object.matchMapLanguageWithDeviceDefault();
                        }
                        catch (RuntimeException runtimeException) {
                            Log.d((String)"ActivityBase", (String)runtimeException.toString());
                        }
                        object = new StringBuilder();
                        ((StringBuilder)object).append("onStyleLoaded: ");
                        ((StringBuilder)object).append(CourseMarkPositionActivity.this.mMapboxMap.getLocationComponent().getLastKnownLocation().getLatitude());
                        ((StringBuilder)object).append(", ");
                        ((StringBuilder)object).append(CourseMarkPositionActivity.this.mMapboxMap.getLocationComponent().getLastKnownLocation().getLongitude());
                        Log.d((String)"ActivityBase", (String)((StringBuilder)object).toString());
                    }
                });
            }
        });
    }

    private void initSymbolLayer(Style style2) {
        style2.addImage("moving-pink-dot", BitmapUtils.getBitmapFromDrawable((Drawable)this.getResources().getDrawable(2131165528)));
        style2.addLayer((Layer)new SymbolLayer("symbol-layer-id", this.ICON_SOURCE_ID).withProperties(new PropertyValue[]{PropertyFactory.iconImage((String)"moving-pink-dot"), PropertyFactory.iconSize((Float)Float.valueOf(0.3f)), PropertyFactory.iconAnchor((String)"bottom")}));
    }

    @AfterPermissionGranted(value=21)
    private void methodRequiresTwoPermission() {
        String[] stringArray = new String[]{"android.permission.ACCESS_COARSE_LOCATION", "android.permission.ACCESS_FINE_LOCATION"};
        if (EasyPermissions.hasPermissions((Context)this, (String[])stringArray)) {
            this.initMap();
        } else {
            EasyPermissions.requestPermissions((Activity)this, (String)i18N.get("FaqGpsTitleFornine"), (int)21, (String[])stringArray);
        }
    }

    private void observeViewModel() {
        ((CourseMarkPositionViewModel)this.viewModel).getTurnByTurnResultLiveData().observe(this, new Observer<JSONObject>(){

            @Override
            public void onChanged(JSONObject jSONObject) {
                JSONArray jSONArray;
                try {
                    jSONArray = jSONObject.getJSONArray("points");
                }
                catch (JSONException jSONException) {
                    jSONException.printStackTrace();
                    jSONArray = null;
                }
                if (jSONArray != null && jSONArray.length() > 0) {
                    CourseMarkPositionActivity.this.setMapPoints(jSONObject);
                    CourseMarkPositionActivity.this.drawMapRoute();
                }
            }
        });
        ((CourseMarkPositionViewModel)this.viewModel).mIsMyFavSynced.observe(this, new Observer<Boolean>(){

            @Override
            public void onChanged(Boolean bl) {
                StringBuilder stringBuilder = new StringBuilder();
                stringBuilder.append("My fav sync result = ");
                stringBuilder.append(bl);
                Log.d((String)"ActivityBase", (String)stringBuilder.toString());
            }
        });
    }

    private void setMapPoints(JSONObject jSONObject) {
        block10: {
            if (this.points == null) {
                this.points = new ArrayList<Point>();
            }
            jSONObject = jSONObject.getJSONArray("points");
            if (jSONObject == null) break block10;
            if (jSONObject.length() <= 0) break block10;
            int n = 0;
            while (true) {
                if (n >= jSONObject.length()) break;
                JSONObject jSONObject2 = jSONObject.getJSONObject(n);
                double d = jSONObject2.getDouble("position_lat");
                double d2 = jSONObject2.getDouble("position_long");
                jSONObject2 = Point.fromLngLat((double)d2, (double)d);
                this.points.add((Point)jSONObject2);
                jSONObject2 = new LatLng(d, d2);
                this.latLngList.add((LatLng)jSONObject2);
                ++n;
                continue;
                break;
            }
            try {
                if (this.latLngBounds == null) {
                    if (this.points.size() >= 2) {
                        jSONObject = new LatLngBounds.Builder();
                        this.latLngBounds = jSONObject.includes(this.latLngList).build();
                    }
                } else {
                    this.latLngBounds = null;
                    jSONObject = new LatLngBounds.Builder();
                    this.latLngBounds = jSONObject.includes(this.latLngList).build();
                }
            }
            catch (JSONException jSONException) {
                jSONException.printStackTrace();
            }
        }
    }

    private void setMapView() {
        LatLng latLng = new LatLng(((CourseMarkPositionViewModel)this.viewModel).searchResult.lat, ((CourseMarkPositionViewModel)this.viewModel).searchResult.lng);
        try {
            this.addMarkerImage(this.mapBoxStyle, ((CourseMarkPositionViewModel)this.viewModel).searchResult.lat, ((CourseMarkPositionViewModel)this.viewModel).searchResult.lng);
        }
        catch (Exception exception) {
            Log.e((String)"ActivityBase", (String)"setMapView: ", (Throwable)exception);
        }
        this.mMapboxMap.moveCamera(CameraUpdateFactory.newLatLng((LatLng)latLng));
    }

    @Override
    protected ActivityCourseMarkPositionBinding createViewBinding(LayoutInflater layoutInflater) {
        return ActivityCourseMarkPositionBinding.inflate(layoutInflater);
    }

    @Override
    protected CourseMarkPositionViewModel createViewModel() {
        CourseMarkPositionViewModel courseMarkPositionViewModel = new ViewModelProvider(this).get(CourseMarkPositionViewModel.class);
        courseMarkPositionViewModel.searchResult = this.getSearchResultFromBundle();
        return courseMarkPositionViewModel;
    }

    @Override
    protected void initColor() {
    }

    @Override
    protected void initFont() {
    }

    @Override
    protected void initText() {
        App.put("Save as Favorite", i18N.get("SavePoiFavorite"));
        App.put("You can find the saved locations in \u201cMy Favorites\u201d.", i18N.get("FindSaveFavoritesPOI"));
        Object object = new StringBuilder();
        object.append(i18N.get("MyFavorite"));
        object.append("01");
        App.put("My Favorite 01", object.toString());
        App.put("Save", i18N.get("B_Save"));
        App.put("Plan Route", i18N.get("PlanRoute"));
        ((ActivityCourseMarkPositionBinding)this.binding).nameText.setText((CharSequence)((CourseMarkPositionViewModel)this.viewModel).searchResult.text);
        object = ((CourseMarkPositionViewModel)this.viewModel).searchResult.distance.split(" ");
        if (object != null && ((String[])object).length > 0) {
            String string2 = new DecimalFormat("#####.##").format(Utils.parseDouble(object[0], Locale.ENGLISH));
            object = ((String[])object).length > 1 ? object[1] : "km";
            TextView textView = ((ActivityCourseMarkPositionBinding)this.binding).distanceText;
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append(string2);
            stringBuilder.append(" ");
            stringBuilder.append((String)object);
            textView.setText((CharSequence)stringBuilder.toString());
        } else {
            ((ActivityCourseMarkPositionBinding)this.binding).distanceText.setText((CharSequence)((CourseMarkPositionViewModel)this.viewModel).searchResult.distance);
        }
        ((ActivityCourseMarkPositionBinding)this.binding).addressText.setText((CharSequence)((CourseMarkPositionViewModel)this.viewModel).searchResult.address);
        ((ActivityCourseMarkPositionBinding)this.binding).saveText.setText((CharSequence)App.get("Save"));
        ((ActivityCourseMarkPositionBinding)this.binding).planRouteButton.setText((CharSequence)App.get("Plan Route"));
        if (((CourseMarkPositionViewModel)this.viewModel).searchResult.isFavorite) {
            ((ActivityCourseMarkPositionBinding)this.binding).favoriteIcon.setVisibility(0);
            ((ActivityCourseMarkPositionBinding)this.binding).saveButton.setVisibility(8);
        }
    }

    public /* synthetic */ void lambda$onCreate$0$com-brytonsport-active-ui-course-CourseMarkPositionActivity() {
        ((ActivityCourseMarkPositionBinding)this.binding).bottomLayout.startAnimation(AnimationUtils.loadAnimation((Context)this, (int)2130772013));
    }

    public /* synthetic */ void lambda$setListeners$1$com-brytonsport-active-ui-course-CourseMarkPositionActivity(View view) {
        this.finish();
    }

    public /* synthetic */ void lambda$setListeners$2$com-brytonsport-active-ui-course-CourseMarkPositionActivity(String string2) {
        ((ActivityCourseMarkPositionBinding)this.binding).favoriteIcon.setVisibility(0);
        ((ActivityCourseMarkPositionBinding)this.binding).saveButton.setVisibility(8);
        ((CourseMarkPositionViewModel)this.viewModel).syncDeviceMyFavList((Context)this.activity, string2);
    }

    public /* synthetic */ void lambda$setListeners$3$com-brytonsport-active-ui-course-CourseMarkPositionActivity(View view) {
        new InputDialog((Context)this.activity).setTitle(App.get("Save as Favorite")).setMessage(i18N.get("FindSaveFavoritesPOI")).setHint(App.get("My Favorite 01")).setOnInputConfirmListener(new CourseMarkPositionActivity$$ExternalSyntheticLambda3(this)).show();
    }

    public /* synthetic */ void lambda$setListeners$4$com-brytonsport-active-ui-course-CourseMarkPositionActivity(View view) {
        view = this.mMapboxMap;
        if (view != null && view.getLocationComponent() != null && this.mMapboxMap.getLocationComponent().getLastKnownLocation() != null) {
            double d = this.mMapboxMap.getLocationComponent().getLastKnownLocation().getLatitude();
            double d2 = this.mMapboxMap.getLocationComponent().getLastKnownLocation().getLongitude();
            ((CourseMarkPositionViewModel)this.viewModel).searchResult.nowLat = d;
            ((CourseMarkPositionViewModel)this.viewModel).searchResult.nowLng = d2;
            this.startActivity(CourseNavigationInfoActivity.createIntent((Context)this.activity, ((CourseMarkPositionViewModel)this.viewModel).searchResult));
        }
    }

    @Override
    protected void onCreate() {
        super.onCreate();
        ((ActivityCourseMarkPositionBinding)this.binding).mapView.onCreate(null);
        this.setActionbarVisibility(8);
        this.post(new CourseMarkPositionActivity$$ExternalSyntheticLambda4(this));
        this.methodRequiresTwoPermission();
        this.observeViewModel();
    }

    @Override
    protected void onDestroy() {
        super.onDestroy();
        ((ActivityCourseMarkPositionBinding)this.binding).mapView.onDestroy();
    }

    @Override
    protected void onPause() {
        super.onPause();
        ((ActivityCourseMarkPositionBinding)this.binding).mapView.onPause();
    }

    @Override
    public void onRequestPermissionsResult(int n, String[] stringArray, int[] nArray) {
        super.onRequestPermissionsResult(n, stringArray, nArray);
        EasyPermissions.onRequestPermissionsResult((int)n, (String[])stringArray, (int[])nArray, (Object[])new Object[]{this});
    }

    @Override
    protected void onResume() {
        super.onResume();
        ((ActivityCourseMarkPositionBinding)this.binding).mapView.onResume();
    }

    @Override
    protected void onStart() {
        super.onStart();
        ((ActivityCourseMarkPositionBinding)this.binding).mapView.onStart();
    }

    @Override
    protected void onStop() {
        super.onStop();
        ((ActivityCourseMarkPositionBinding)this.binding).mapView.onStop();
    }

    @Override
    protected void setListeners() {
        ((ActivityCourseMarkPositionBinding)this.binding).cancelButton.setOnClickListener((View.OnClickListener)new CourseMarkPositionActivity$$ExternalSyntheticLambda0(this));
        ((ActivityCourseMarkPositionBinding)this.binding).saveButton.setOnClickListener((View.OnClickListener)new CourseMarkPositionActivity$$ExternalSyntheticLambda1(this));
        ((ActivityCourseMarkPositionBinding)this.binding).planRouteButton.setOnClickListener((View.OnClickListener)new CourseMarkPositionActivity$$ExternalSyntheticLambda2(this));
    }
}

