/*
 * Decompiled with CFR 0.152.
 */
package com.brytonsport.active.ui.course;

import android.app.Activity;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.graphics.Color;
import android.graphics.drawable.Drawable;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.animation.Animation;
import android.widget.FrameLayout;
import android.widget.TextView;
import androidx.lifecycle.Observer;
import androidx.lifecycle.ViewModelProvider;
import com.brytonsport.active.base.App;
import com.brytonsport.active.databinding.ActivityCourseNavigationInfoBinding;
import com.brytonsport.active.ui.course.CourseNavigationInfoActivity$$ExternalSyntheticLambda0;
import com.brytonsport.active.ui.course.CourseNavigationInfoActivity$$ExternalSyntheticLambda1;
import com.brytonsport.active.ui.course.CourseNavigationInfoActivity$$ExternalSyntheticLambda2;
import com.brytonsport.active.ui.course.CourseNavigationInfoActivity$$ExternalSyntheticLambda3;
import com.brytonsport.active.ui.course.CourseNavigationInfoActivity$$ExternalSyntheticLambda4;
import com.brytonsport.active.ui.course.CourseNavigationInfoActivity$$ExternalSyntheticLambda5;
import com.brytonsport.active.ui.course.Hilt_CourseNavigationInfoActivity;
import com.brytonsport.active.utils.ChartUtils;
import com.brytonsport.active.utils.DeviceBusyStatusUtil;
import com.brytonsport.active.utils.DistanceUtil;
import com.brytonsport.active.utils.GestureUtils;
import com.brytonsport.active.utils.RouteModeConstantsUtil;
import com.brytonsport.active.utils.Utils;
import com.brytonsport.active.utils.i18N;
import com.brytonsport.active.views.dialog.ConfirmDialog;
import com.brytonsport.active.views.dialog.SelectPopupDialog;
import com.brytonsport.active.vm.base.SearchResult;
import com.brytonsport.active.vm.base.analysis.Altitude;
import com.brytonsport.active.vm.course.CourseNavigationInfoViewModel;
import com.github.mikephil.charting.charts.CombinedChart;
import com.github.mikephil.charting.data.CombinedData;
import com.github.mikephil.charting.data.Entry;
import com.github.mikephil.charting.data.LineData;
import com.github.mikephil.charting.data.LineDataSet;
import com.github.mikephil.charting.formatter.IAxisValueFormatter;
import com.github.mikephil.charting.formatter.IndexAxisValueFormatter;
import com.github.mikephil.charting.interfaces.datasets.IDataSet;
import com.james.easyanimation.EasyAnimation;
import com.mapbox.geojson.Feature;
import com.mapbox.geojson.FeatureCollection;
import com.mapbox.geojson.Geometry;
import com.mapbox.geojson.LineString;
import com.mapbox.geojson.Point;
import com.mapbox.mapboxsdk.camera.CameraUpdateFactory;
import com.mapbox.mapboxsdk.geometry.LatLng;
import com.mapbox.mapboxsdk.geometry.LatLngBounds;
import com.mapbox.mapboxsdk.maps.MapboxMap;
import com.mapbox.mapboxsdk.maps.OnMapReadyCallback;
import com.mapbox.mapboxsdk.maps.Style;
import com.mapbox.mapboxsdk.plugins.localization.LocalizationPlugin;
import com.mapbox.mapboxsdk.plugins.markerview.MarkerView;
import com.mapbox.mapboxsdk.plugins.markerview.MarkerViewManager;
import com.mapbox.mapboxsdk.style.layers.Layer;
import com.mapbox.mapboxsdk.style.layers.LineLayer;
import com.mapbox.mapboxsdk.style.layers.PropertyFactory;
import com.mapbox.mapboxsdk.style.layers.PropertyValue;
import com.mapbox.mapboxsdk.style.layers.SymbolLayer;
import com.mapbox.mapboxsdk.style.sources.GeoJsonSource;
import com.mapbox.mapboxsdk.style.sources.Source;
import com.mapbox.mapboxsdk.utils.BitmapUtils;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import pub.devrel.easypermissions.AfterPermissionGranted;
import pub.devrel.easypermissions.EasyPermissions;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class CourseNavigationInfoActivity
extends Hilt_CourseNavigationInfoActivity<ActivityCourseNavigationInfoBinding, CourseNavigationInfoViewModel> {
    private static final int RC_LOCATION = 22;
    private String ICON_END_SOURCE_ID = "icon-end-source-id";
    private String ICON_START_SOURCE_ID = "icon-start-source-id";
    private GeoJsonSource geoJsonSource;
    GeoJsonSource iconEndMarkerGeoJsonSource;
    GeoJsonSource iconStartMarkerGeoJsonSource;
    private LatLngBounds latLngBounds;
    private List<LatLng> latLngList = new ArrayList<LatLng>();
    private final BroadcastReceiver mGattUpdateReceiver;
    private MapboxMap mMapboxMap;
    private Style mapBoxStyle;
    private MarkerView markerView;
    private MarkerViewManager markerViewManager;
    private List<Point> points = new ArrayList<Point>();

    public CourseNavigationInfoActivity() {
        this.mGattUpdateReceiver = new BroadcastReceiver(){

            public void onReceive(Context object, Intent intent) {
                String string2 = intent.getAction();
                object = new StringBuilder();
                ((StringBuilder)object).append("mGattUpdateReceiver action: ");
                ((StringBuilder)object).append(string2);
                Log.d((String)"ActivityBase", (String)((StringBuilder)object).toString());
                string2.hashCode();
                if (!string2.equals("com.brytonsport.active.SERVICE_REQUEST_DATA")) {
                    if (string2.equals("com.brytonsport.active.SERVICE_POST_DATA")) {
                        int n = intent.getIntExtra("com.brytonsport.active.SERVICE_POST_FILE_TYPE", 0);
                        object = new StringBuilder();
                        ((StringBuilder)object).append("onReceive post data ok, postDataContentType -> ");
                        ((StringBuilder)object).append(n);
                        Log.d((String)"ActivityBase", (String)((StringBuilder)object).toString());
                        CourseNavigationInfoActivity.this.dismissProgressDialog();
                        if (n == 11) {
                            ConfirmDialog.showSelf(CourseNavigationInfoActivity.this.activity, i18N.get("routeToDev"), i18N.get("UploadSuccess"));
                            ((CourseNavigationInfoViewModel)CourseNavigationInfoActivity.this.viewModel).sendPlanTripNameToDevice();
                        }
                    }
                } else {
                    object = intent.getByteArrayExtra("com.brytonsport.active.SERVICE_BYTE_ARRAY_EXTRA_DATA");
                    CourseNavigationInfoActivity.this.createFileWithByte((byte[])object, "/fav/", "favcontent");
                }
            }
        };
    }

    static /* synthetic */ MapboxMap access$002(CourseNavigationInfoActivity courseNavigationInfoActivity, MapboxMap mapboxMap) {
        courseNavigationInfoActivity.mMapboxMap = mapboxMap;
        return mapboxMap;
    }

    static /* synthetic */ Style access$102(CourseNavigationInfoActivity courseNavigationInfoActivity, Style style2) {
        courseNavigationInfoActivity.mapBoxStyle = style2;
        return style2;
    }

    private void addEndMarkerImage(Style style2, double d, double d2) {
        GeoJsonSource geoJsonSource = this.iconEndMarkerGeoJsonSource;
        if (geoJsonSource == null) {
            this.iconEndMarkerGeoJsonSource = geoJsonSource = new GeoJsonSource(this.ICON_END_SOURCE_ID, FeatureCollection.fromFeatures((Feature[])new Feature[]{Feature.fromGeometry((Geometry)Point.fromLngLat((double)d2, (double)d))}));
            style2.addSource((Source)geoJsonSource);
        } else {
            geoJsonSource.setGeoJson(FeatureCollection.fromFeatures((Feature[])new Feature[]{Feature.fromGeometry((Geometry)Point.fromLngLat((double)d2, (double)d))}));
        }
    }

    private void addMarkerView(int n, LatLng latLng) {
        if (this.markerViewManager == null) {
            this.markerViewManager = new MarkerViewManager(((ActivityCourseNavigationInfoBinding)this.binding).mapView, this.mMapboxMap);
        }
        View view = LayoutInflater.from((Context)this).inflate(2131427539, null);
        view.setLayoutParams((ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-2, -2));
        ((TextView)view.findViewById(2131231353)).setText((CharSequence)String.valueOf(n));
        latLng = new MarkerView(latLng, view);
        this.markerView = latLng;
        this.markerViewManager.addMarker((MarkerView)latLng);
    }

    private void addStartEndMarker() {
        Point point = this.points;
        if (point != null && point.size() > 0) {
            point = this.points.get(0);
            Point point2 = this.points;
            point2 = point2.get(point2.size() - 1);
            this.addStartMarkerImage(this.mapBoxStyle, point.latitude(), point.longitude());
            this.addEndMarkerImage(this.mapBoxStyle, point2.latitude(), point2.longitude());
        }
    }

    private void addStartMarkerImage(Style style2, double d, double d2) {
        GeoJsonSource geoJsonSource = this.iconStartMarkerGeoJsonSource;
        if (geoJsonSource == null) {
            this.iconStartMarkerGeoJsonSource = geoJsonSource = new GeoJsonSource(this.ICON_START_SOURCE_ID, FeatureCollection.fromFeatures((Feature[])new Feature[]{Feature.fromGeometry((Geometry)Point.fromLngLat((double)d2, (double)d))}));
            style2.addSource((Source)geoJsonSource);
        } else {
            geoJsonSource.setGeoJson(FeatureCollection.fromFeatures((Feature[])new Feature[]{Feature.fromGeometry((Geometry)Point.fromLngLat((double)d2, (double)d))}));
        }
    }

    private void callPlanTrip() {
        ((CourseNavigationInfoViewModel)this.viewModel).getTurnByTurn(((CourseNavigationInfoViewModel)this.viewModel).searchResult.nowLat, ((CourseNavigationInfoViewModel)this.viewModel).searchResult.nowLng, ((CourseNavigationInfoViewModel)this.viewModel).searchResult.lat, ((CourseNavigationInfoViewModel)this.viewModel).searchResult.lng);
    }

    private void clearRoutePath() {
        this.mapBoxStyle.removeLayer("linelayer");
        this.mapBoxStyle.removeLayer("symbol-layer-id");
        this.mapBoxStyle.removeLayer("symbol-layer-id2");
    }

    /*
     * Loose catch block
     */
    private void createFileWithByte(byte[] object422, String object2, String object3) {
        block27: {
            block31: {
                block29: {
                    String[] stringArray;
                    block30: {
                        block28: {
                            stringArray = new StringBuilder();
                            stringArray.append("createFileWithByte: bytes size = ");
                            stringArray.append(((byte[])object422).length);
                            Log.d((String)"ActivityBase", (String)stringArray.toString());
                            File file = this.getFilesDir();
                            stringArray = new StringBuilder();
                            stringArray.append(file);
                            stringArray.append((String)object2);
                            stringArray = new File(stringArray.toString());
                            if (!stringArray.exists()) {
                                stringArray.mkdirs();
                            }
                            object2 = new StringBuilder();
                            object2.append(stringArray);
                            object2.append("/");
                            object2.append((String)object3);
                            file = new File(object2.toString());
                            object2 = new StringBuilder();
                            object2.append("createFileWithByte: \u8def\u5f91 = ");
                            object2.append(file.getAbsolutePath());
                            Log.d((String)"ActivityBase", (String)object2.toString());
                            stringArray = null;
                            object2 = null;
                            if (file.exists()) {
                                file.delete();
                            }
                            file.createNewFile();
                            object3 = new FileOutputStream(file);
                            stringArray = new BufferedOutputStream((OutputStream)object3);
                            stringArray.write((byte[])object422);
                            stringArray.flush();
                            try {
                                ((FileOutputStream)object3).close();
                            }
                            catch (IOException iOException) {
                                iOException.printStackTrace();
                            }
                            stringArray.close();
                            catch (Throwable throwable) {
                                object2 = stringArray;
                                break block27;
                            }
                            catch (Exception exception) {
                                object422 = stringArray;
                                break block28;
                            }
                            catch (Throwable throwable) {
                                object2 = null;
                                break block27;
                            }
                            catch (Exception exception) {
                                object422 = null;
                            }
                        }
                        stringArray = object2;
                        object2 = object3;
                        break block30;
                        catch (Throwable throwable) {
                            object2 = null;
                            object3 = stringArray;
                            break block27;
                        }
                        catch (Exception exception) {
                            object422 = null;
                            stringArray = exception;
                        }
                    }
                    stringArray.printStackTrace();
                    if (object2 == null) break block29;
                    try {
                        object2.close();
                    }
                    catch (IOException iOException) {
                        iOException.printStackTrace();
                    }
                }
                if (object422 == null) break block31;
                try {
                    object422.close();
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
            object2 = this.fileList();
            int n = ((String[])object2).length;
            for (int i = 0; i < n; ++i) {
                object422 = object2[i];
            }
            return;
            catch (Throwable throwable) {
                object3 = object2;
                object2 = object422;
                object422 = throwable;
            }
        }
        if (object3 != null) {
            try {
                ((FileOutputStream)object3).close();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
        if (object2 != null) {
            try {
                object2.close();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        throw object422;
    }

    public static Intent createIntent(Context context, SearchResult searchResult) {
        return new Intent(context, CourseNavigationInfoActivity.class).putExtra("data", searchResult.encode());
    }

    private void drawChart() {
        Altitude altitude;
        CombinedChart combinedChart = ((ActivityCourseNavigationInfoBinding)this.binding).altitudeChart;
        ArrayList<Altitude> arrayList = ((CourseNavigationInfoViewModel)this.viewModel).altitudeList;
        boolean bl = ((CourseNavigationInfoViewModel)this.viewModel).totalDistance >= 1000.0;
        ArrayList<String> arrayList2 = new ArrayList<String>();
        LineDataSet lineDataSet = new ArrayList();
        for (int i = 0; i < arrayList.size(); ++i) {
            StringBuilder stringBuilder;
            altitude = arrayList.get(i);
            lineDataSet.add(new Entry((float)i, altitude.meter));
            if (bl) {
                stringBuilder = new StringBuilder();
                stringBuilder.append(String.format("%.2f", Float.valueOf(Utils.convertKM((float)DistanceUtil.distanceMeteor2Km(altitude.distance)))));
                stringBuilder.append(Utils.getUnitByKM());
                arrayList2.add(stringBuilder.toString());
                continue;
            }
            stringBuilder = new StringBuilder();
            stringBuilder.append(String.format("%.2f", Float.valueOf(altitude.distance)));
            stringBuilder.append(" m");
            arrayList2.add(stringBuilder.toString());
        }
        lineDataSet = new LineDataSet(lineDataSet, "");
        lineDataSet.setDrawCircles(false);
        lineDataSet.setDrawFilled(true);
        lineDataSet.setLineWidth(2.0f);
        lineDataSet.setFillColor(-16723133);
        lineDataSet.setColor(-16723133);
        lineDataSet.setDrawValues(false);
        lineDataSet.setMode(LineDataSet.Mode.CUBIC_BEZIER);
        altitude = new LineData();
        altitude.addDataSet((IDataSet)lineDataSet);
        lineDataSet = new CombinedData();
        lineDataSet.setData((LineData)altitude);
        ChartUtils.setDefaultChartStyle(combinedChart);
        combinedChart.getAxisLeft().setAxisMaximum(ChartUtils.getMaxAltitude(arrayList) * 1.5f);
        combinedChart.setData((CombinedData)lineDataSet);
        combinedChart.setScaleXEnabled(true);
        combinedChart.setScaleYEnabled(false);
        combinedChart.getXAxis().setValueFormatter((IAxisValueFormatter)new IndexAxisValueFormatter(arrayList2));
        combinedChart.invalidate();
    }

    private void drawMapRoute() {
        LatLngBounds latLngBounds = this.latLngBounds;
        if (latLngBounds != null) {
            this.mMapboxMap.easeCamera(CameraUpdateFactory.newLatLngBounds((LatLngBounds)latLngBounds, (int)150, (int)150, (int)150, (int)900), 1000);
        }
        Feature feature = Feature.fromGeometry((Geometry)LineString.fromLngLats(this.points));
        latLngBounds = this.geoJsonSource;
        if (latLngBounds == null) {
            latLngBounds = new GeoJsonSource("geojson-source", feature);
            this.geoJsonSource = latLngBounds;
            this.mapBoxStyle.addSource((Source)latLngBounds);
        } else {
            latLngBounds.setGeoJson(feature);
        }
        this.mapBoxStyle.addLayer((Layer)new LineLayer("linelayer", "geojson-source").withProperties(new PropertyValue[]{PropertyFactory.lineJoin((String)"round"), PropertyFactory.lineWidth((Float)Float.valueOf(4.0f)), PropertyFactory.lineColor((int)Color.parseColor((String)"#003ADB"))}));
    }

    private SearchResult getSearchResultFromBundle() {
        return new SearchResult(this.getIntent().getStringExtra("data"));
    }

    private void initMap() {
        ((ActivityCourseNavigationInfoBinding)this.binding).mapView.getMapAsync(new OnMapReadyCallback(){

            public void onMapReady(final MapboxMap mapboxMap) {
                CourseNavigationInfoActivity.access$002(CourseNavigationInfoActivity.this, mapboxMap);
                mapboxMap.setStyle("mapbox://styles/mapbox/streets-v11", new Style.OnStyleLoaded(){

                    public void onStyleLoaded(Style style2) {
                        CourseNavigationInfoActivity.access$102(CourseNavigationInfoActivity.this, style2);
                        CourseNavigationInfoActivity.this.initSymbolLayer(style2);
                        CourseNavigationInfoActivity.this.setMapView();
                        style2 = new LocalizationPlugin(((ActivityCourseNavigationInfoBinding)CourseNavigationInfoActivity.this.binding).mapView, mapboxMap, style2);
                        try {
                            style2.matchMapLanguageWithDeviceDefault();
                        }
                        catch (RuntimeException runtimeException) {
                            Log.d((String)"ActivityBase", (String)runtimeException.toString());
                        }
                    }
                });
            }
        });
    }

    private void initSymbolLayer(Style style2) {
        style2.addImage("icon-start-point", BitmapUtils.getBitmapFromDrawable((Drawable)this.getResources().getDrawable(2131165530)));
        style2.addImage("icon-end-point", BitmapUtils.getBitmapFromDrawable((Drawable)this.getResources().getDrawable(2131165528)));
    }

    private static IntentFilter makeGattUpdateIntentFilter() {
        IntentFilter intentFilter = new IntentFilter();
        intentFilter.addAction("com.brytonsport.active.SERVICE_POST_DATA");
        intentFilter.addAction("com.brytonsport.active.SERVICE_REQUEST_DATA");
        return intentFilter;
    }

    @AfterPermissionGranted(value=22)
    private void methodRequiresTwoPermission() {
        String[] stringArray = new String[]{"android.permission.ACCESS_COARSE_LOCATION", "android.permission.ACCESS_FINE_LOCATION"};
        if (EasyPermissions.hasPermissions((Context)this, (String[])stringArray)) {
            this.initMap();
            this.callPlanTrip();
        } else {
            EasyPermissions.requestPermissions((Activity)this, (String)i18N.get("FaqGpsTitleFornine"), (int)22, (String[])stringArray);
        }
    }

    private void observeViewModel() {
        ((CourseNavigationInfoViewModel)this.viewModel).getTurnByTurnResultLiveData().observe(this, new Observer<JSONObject>(){

            @Override
            public void onChanged(JSONObject jSONObject) {
                double d;
                ((CourseNavigationInfoViewModel)CourseNavigationInfoActivity.this.viewModel).turnByTurnResultObj = jSONObject;
                if (jSONObject.has("distance")) {
                    try {
                        ((CourseNavigationInfoViewModel)CourseNavigationInfoActivity.this.viewModel).totalDistance = d = jSONObject.getDouble("distance");
                        ((ActivityCourseNavigationInfoBinding)CourseNavigationInfoActivity.this.binding).distanceView.setValue(App.get("\u8ddd\u96e2"), String.format("%.2f", Float.valueOf(Utils.convertKM((float)DistanceUtil.distanceMeteor2Km(d)))), Utils.getUnitByKM());
                    }
                    catch (JSONException jSONException) {
                        jSONException.printStackTrace();
                    }
                }
                if (jSONObject.has("gain")) {
                    try {
                        d = jSONObject.getDouble("gain");
                        ((ActivityCourseNavigationInfoBinding)CourseNavigationInfoActivity.this.binding).altitudeView.setValue(App.get("\u7e3d\u722c\u5347"), String.format("%.2f", Float.valueOf(Utils.convertM((float)d))), Utils.getUnitByM());
                    }
                    catch (JSONException jSONException) {
                        jSONException.printStackTrace();
                    }
                }
                JSONArray jSONArray = null;
                try {
                    JSONArray jSONArray2;
                    jSONArray = jSONArray2 = jSONObject.getJSONArray("points");
                }
                catch (JSONException jSONException) {
                    jSONException.printStackTrace();
                }
                if (jSONArray != null && jSONArray.length() > 0) {
                    CourseNavigationInfoActivity.this.setMapPoints(jSONObject);
                    CourseNavigationInfoActivity.this.drawMapRoute();
                    CourseNavigationInfoActivity.this.mapBoxStyle.addLayer((Layer)new SymbolLayer("symbol-layer-id", CourseNavigationInfoActivity.this.ICON_START_SOURCE_ID).withProperties(new PropertyValue[]{PropertyFactory.iconImage((String)"icon-start-point"), PropertyFactory.iconSize((Float)Float.valueOf(0.3f)), PropertyFactory.iconAnchor((String)"bottom")}));
                    CourseNavigationInfoActivity.this.mapBoxStyle.addLayer((Layer)new SymbolLayer("symbol-layer-id2", CourseNavigationInfoActivity.this.ICON_END_SOURCE_ID).withProperties(new PropertyValue[]{PropertyFactory.iconImage((String)"icon-end-point"), PropertyFactory.iconSize((Float)Float.valueOf(0.3f)), PropertyFactory.iconAnchor((String)"bottom")}));
                    CourseNavigationInfoActivity.this.addStartEndMarker();
                    CourseNavigationInfoActivity.this.prepareChart(jSONArray);
                    CourseNavigationInfoActivity.this.drawChart();
                }
            }
        });
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void prepareChart(JSONArray jSONArray) {
        ArrayList<Altitude> arrayList = new ArrayList<Altitude>();
        int n = 0;
        while (true) {
            if (n >= jSONArray.length()) {
                ((CourseNavigationInfoViewModel)this.viewModel).altitudeList = arrayList;
                return;
            }
            try {
                JSONObject jSONObject = jSONArray.getJSONObject(n);
                double d = jSONObject.getDouble("altitude");
                double d2 = 0.0;
                double d3 = jSONObject.getDouble("position_lat");
                double d4 = jSONObject.getDouble("position_long");
                if (n > 0) {
                    int n2 = n - 1;
                    JSONObject jSONObject2 = jSONArray.getJSONObject(n2);
                    d2 = DistanceUtil.distance(jSONObject2.getDouble("position_lat"), jSONObject2.getDouble("position_long"), d3, d4) + (double)((Altitude)arrayList.get((int)n2)).distance;
                }
                Altitude altitude = new Altitude((float)d, (float)d2);
                arrayList.add(altitude);
            }
            catch (JSONException jSONException) {
                jSONException.printStackTrace();
            }
            ++n;
        }
    }

    private void setMapPoints(JSONObject jSONObject) {
        block9: {
            this.points = new ArrayList<Point>();
            jSONObject = jSONObject.getJSONArray("points");
            if (jSONObject == null) break block9;
            if (jSONObject.length() <= 0) break block9;
            int n = 0;
            while (true) {
                if (n >= jSONObject.length()) break;
                JSONObject jSONObject2 = jSONObject.getJSONObject(n);
                double d = jSONObject2.getDouble("position_lat");
                double d2 = jSONObject2.getDouble("position_long");
                jSONObject2 = Point.fromLngLat((double)d2, (double)d);
                this.points.add((Point)jSONObject2);
                jSONObject2 = new LatLng(d, d2);
                this.latLngList.add((LatLng)jSONObject2);
                ++n;
                continue;
                break;
            }
            try {
                if (this.latLngBounds == null) {
                    if (this.points.size() >= 2) {
                        jSONObject = new LatLngBounds.Builder();
                        this.latLngBounds = jSONObject.includes(this.latLngList).build();
                    }
                } else {
                    this.latLngBounds = null;
                    jSONObject = new LatLngBounds.Builder();
                    this.latLngBounds = jSONObject.includes(this.latLngList).build();
                }
            }
            catch (JSONException jSONException) {
                jSONException.printStackTrace();
            }
        }
    }

    private void setMapView() {
        LatLng latLng = new LatLng(((CourseNavigationInfoViewModel)this.viewModel).searchResult.lat, ((CourseNavigationInfoViewModel)this.viewModel).searchResult.lng);
        this.mMapboxMap.moveCamera(CameraUpdateFactory.newLatLng((LatLng)latLng));
    }

    @Override
    protected ActivityCourseNavigationInfoBinding createViewBinding(LayoutInflater layoutInflater) {
        return ActivityCourseNavigationInfoBinding.inflate(layoutInflater);
    }

    @Override
    protected CourseNavigationInfoViewModel createViewModel() {
        CourseNavigationInfoViewModel courseNavigationInfoViewModel = new ViewModelProvider(this).get(CourseNavigationInfoViewModel.class);
        courseNavigationInfoViewModel.searchResult = this.getSearchResultFromBundle();
        return courseNavigationInfoViewModel;
    }

    @Override
    protected void initColor() {
    }

    @Override
    protected void initFont() {
    }

    @Override
    protected void initText() {
        App.put("Navigation", i18N.get("navigation"));
        App.put("\u8ddd\u96e2", i18N.get("Distance"));
        App.put("\u7e3d\u722c\u5347", i18N.get("TotalAscent"));
        App.put("Road Bike", i18N.get("Cycling"));
        App.put("Mountain Bike", i18N.get("Mountainbiking"));
        App.put("Motorcycle", i18N.get("Motorcycle"));
        App.put("Car", i18N.get("Driving"));
        App.put("Send to Paired Device", i18N.get("B_DownloadToDev"));
        this.setTitle(App.get("Navigation"));
        ((ActivityCourseNavigationInfoBinding)this.binding).nameText.setText((CharSequence)((CourseNavigationInfoViewModel)this.viewModel).searchResult.text);
        ((ActivityCourseNavigationInfoBinding)this.binding).distanceView.setValue(App.get("\u8ddd\u96e2"), "-", Utils.getUnitByKM());
        ((ActivityCourseNavigationInfoBinding)this.binding).altitudeView.setValue(App.get("\u7e3d\u722c\u5347"), "-", Utils.getUnitByM());
        ((ActivityCourseNavigationInfoBinding)this.binding).sendToPairedDeviceButton.setText((CharSequence)App.get("Send to Paired Device"));
    }

    public /* synthetic */ void lambda$onCreate$0$com-brytonsport-active-ui-course-CourseNavigationInfoActivity() {
        ((ActivityCourseNavigationInfoBinding)this.binding).bottomLayout.setVisibility(0);
        ((ActivityCourseNavigationInfoBinding)this.binding).bottomLayout.startAnimation((Animation)EasyAnimation.getInstance().getBottomIn(200));
    }

    public /* synthetic */ void lambda$setListeners$1$com-brytonsport-active-ui-course-CourseNavigationInfoActivity(boolean bl) {
        int n = bl ? 8 : 0;
        this.setActionbarVisibility(n);
    }

    public /* synthetic */ void lambda$setListeners$2$com-brytonsport-active-ui-course-CourseNavigationInfoActivity(boolean bl) {
        int n = bl ? 8 : 0;
        this.setActionbarVisibility(n);
    }

    public /* synthetic */ void lambda$setListeners$3$com-brytonsport-active-ui-course-CourseNavigationInfoActivity(int n) {
        if (n == 0) {
            ((ActivityCourseNavigationInfoBinding)this.binding).typeIcon.setImageResource(0x7F07007F);
            ((CourseNavigationInfoViewModel)this.viewModel).routeMode = RouteModeConstantsUtil.ROUTE_MODE_RACING_BIKE;
        } else if (n == 1) {
            ((ActivityCourseNavigationInfoBinding)this.binding).typeIcon.setImageResource(2131165310);
            ((CourseNavigationInfoViewModel)this.viewModel).routeMode = RouteModeConstantsUtil.ROUTE_MODE_MTB;
        } else if (n == 2) {
            ((ActivityCourseNavigationInfoBinding)this.binding).typeIcon.setImageResource(2131165309);
            ((CourseNavigationInfoViewModel)this.viewModel).routeMode = RouteModeConstantsUtil.ROUTE_MODE_SCOOTER;
        } else if (n == 3) {
            ((ActivityCourseNavigationInfoBinding)this.binding).typeIcon.setImageResource(2131165308);
            ((CourseNavigationInfoViewModel)this.viewModel).routeMode = RouteModeConstantsUtil.ROUTE_MODE_CAR;
        }
        this.clearRoutePath();
        this.callPlanTrip();
    }

    public /* synthetic */ void lambda$setListeners$4$com-brytonsport-active-ui-course-CourseNavigationInfoActivity(View object) {
        object = new ArrayList();
        ((ArrayList)object).add(App.get("Road Bike"));
        ((ArrayList)object).add(App.get("Mountain Bike"));
        ((ArrayList)object).add(App.get("Motorcycle"));
        ((ArrayList)object).add(App.get("Car"));
        new SelectPopupDialog((Context)this.activity).setOnMenuItemClickListener(new CourseNavigationInfoActivity$$ExternalSyntheticLambda4(this)).showPopup((ArrayList<String>)object);
    }

    public /* synthetic */ void lambda$setListeners$5$com-brytonsport-active-ui-course-CourseNavigationInfoActivity(View object) {
        object = DeviceBusyStatusUtil.getNowDeviceStatus();
        if (object.equals((Object)DeviceBusyStatusUtil.DeviceStatus.SyncActivity)) {
            ConfirmDialog.showSelfSingle(this.activity, i18N.get("M_ReadDevice"), i18N.get("B_OK"));
        } else if (object.equals((Object)DeviceBusyStatusUtil.DeviceStatus.RunningGroupRide)) {
            ConfirmDialog.showSelfSingle(this.activity, i18N.get("StopGRFrist"), i18N.get("B_OK"));
        } else if (object.equals((Object)DeviceBusyStatusUtil.DeviceStatus.SendServerEeToDev)) {
            ConfirmDialog.showSelfSingle(this.activity, i18N.get("M_DeviceBusy"), i18N.get("B_OK"));
        } else {
            this.showProgressDialog("");
            ((CourseNavigationInfoViewModel)this.viewModel).sendPlanTripToDevice();
        }
    }

    @Override
    protected void onCreate() {
        super.onCreate();
        this.registerReceiver(this.mGattUpdateReceiver, CourseNavigationInfoActivity.makeGattUpdateIntentFilter());
        ((ActivityCourseNavigationInfoBinding)this.binding).mapView.onCreate(null);
        ((ActivityCourseNavigationInfoBinding)this.binding).bottomLayout.setVisibility(8);
        this.postDelayed(new CourseNavigationInfoActivity$$ExternalSyntheticLambda5(this), 500L);
        this.methodRequiresTwoPermission();
        this.observeViewModel();
    }

    @Override
    protected void onDestroy() {
        super.onDestroy();
        ((ActivityCourseNavigationInfoBinding)this.binding).mapView.onDestroy();
        this.unregisterReceiver(this.mGattUpdateReceiver);
    }

    @Override
    protected void onPause() {
        super.onPause();
        ((ActivityCourseNavigationInfoBinding)this.binding).mapView.onPause();
    }

    @Override
    public void onRequestPermissionsResult(int n, String[] stringArray, int[] nArray) {
        super.onRequestPermissionsResult(n, stringArray, nArray);
        EasyPermissions.onRequestPermissionsResult((int)n, (String[])stringArray, (int[])nArray, (Object[])new Object[]{this});
    }

    @Override
    protected void onResume() {
        super.onResume();
        ((ActivityCourseNavigationInfoBinding)this.binding).mapView.onResume();
    }

    @Override
    protected void onStart() {
        super.onStart();
        ((ActivityCourseNavigationInfoBinding)this.binding).mapView.onStart();
    }

    @Override
    protected void onStop() {
        super.onStop();
        ((ActivityCourseNavigationInfoBinding)this.binding).mapView.onStop();
    }

    @Override
    protected void setListeners() {
        GestureUtils.dragBottomLayout(this, (View)((ActivityCourseNavigationInfoBinding)this.binding).touchLayout, new CourseNavigationInfoActivity$$ExternalSyntheticLambda2(this));
        GestureUtils.dragBottomLayout(this, (View)((ActivityCourseNavigationInfoBinding)this.binding).valueLayout, new CourseNavigationInfoActivity$$ExternalSyntheticLambda3(this));
        ((ActivityCourseNavigationInfoBinding)this.binding).typeIcon.setOnClickListener((View.OnClickListener)new CourseNavigationInfoActivity$$ExternalSyntheticLambda0(this));
        ((ActivityCourseNavigationInfoBinding)this.binding).sendToPairedDeviceButton.setOnClickListener((View.OnClickListener)new CourseNavigationInfoActivity$$ExternalSyntheticLambda1(this));
    }
}

