/*
 * Decompiled with CFR 0.152.
 */
package com.brytonsport.active.ui.course;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.text.Editable;
import android.text.TextUtils;
import android.text.TextWatcher;
import android.view.KeyEvent;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.TextView;
import androidx.lifecycle.Observer;
import androidx.lifecycle.ViewModelProvider;
import com.brytonsport.active.base.App;
import com.brytonsport.active.databinding.ActivityCourseSearchBinding;
import com.brytonsport.active.db.course.entity.CourseSearchHistoryEntity;
import com.brytonsport.active.ui.course.CourseSearchActivity$$ExternalSyntheticLambda0;
import com.brytonsport.active.ui.course.CourseSearchActivity$$ExternalSyntheticLambda1;
import com.brytonsport.active.ui.course.CourseSearchActivity$$ExternalSyntheticLambda2;
import com.brytonsport.active.ui.course.CourseSearchActivity$$ExternalSyntheticLambda3;
import com.brytonsport.active.ui.course.CourseSearchActivity$$ExternalSyntheticLambda4;
import com.brytonsport.active.ui.course.Hilt_CourseSearchActivity;
import com.brytonsport.active.ui.course.adapter.SearchResultAdapter;
import com.brytonsport.active.utils.DistanceUtil;
import com.brytonsport.active.utils.Utils;
import com.brytonsport.active.utils.i18N;
import com.brytonsport.active.views.layoutmanager.AdvancedLinearLayoutManager;
import com.brytonsport.active.vm.base.SearchResult;
import com.brytonsport.active.vm.course.CourseSearchViewModel;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class CourseSearchActivity
extends Hilt_CourseSearchActivity<ActivityCourseSearchBinding, CourseSearchViewModel> {
    private double nowLat;
    private double nowLng;
    private SearchResultAdapter resultAdapter;
    private String searchString;

    static /* synthetic */ String access$102(CourseSearchActivity courseSearchActivity, String string2) {
        courseSearchActivity.searchString = string2;
        return string2;
    }

    private void animateSearchLayout(int n) {
        int n2 = ((ViewGroup.MarginLayoutParams)((ActivityCourseSearchBinding)this.binding).searchLayout.getLayoutParams()).topMargin;
        if (n2 <= 0) {
            ((ViewGroup.MarginLayoutParams)((ActivityCourseSearchBinding)this.binding).searchLayout.getLayoutParams()).topMargin = 0;
            ((ActivityCourseSearchBinding)this.binding).searchLayout.requestLayout();
            return;
        }
        ((ViewGroup.MarginLayoutParams)((ActivityCourseSearchBinding)this.binding).searchLayout.getLayoutParams()).topMargin = n2 - n;
        ((ActivityCourseSearchBinding)this.binding).searchLayout.requestLayout();
        this.postDelayed(new CourseSearchActivity$$ExternalSyntheticLambda4(this, n), 10L);
    }

    public static Intent createIntent(Context context, double d, double d2) {
        return new Intent(context, CourseSearchActivity.class).putExtra("nowLat", d).putExtra("nowLng", d2);
    }

    private void executeSearchEvent() {
        if (this.nowLat != 0.0 && this.nowLng != 0.0) {
            ((CourseSearchViewModel)this.viewModel).searchPoiUseTextSearch(this.nowLat, this.nowLng, this.searchString);
            ((CourseSearchViewModel)this.viewModel).addNewSearchHistory(this.searchString);
        }
        if (TextUtils.isEmpty((CharSequence)this.searchString)) {
            ((ActivityCourseSearchBinding)this.binding).clearImage.setVisibility(8);
            this.resultAdapter.swapItems(((CourseSearchViewModel)this.viewModel).getDefaultResults());
        } else {
            ((ActivityCourseSearchBinding)this.binding).clearImage.setVisibility(0);
            this.resultAdapter.swapItems(((CourseSearchViewModel)this.viewModel).getSearchResults(this.searchString));
        }
    }

    private void observeViewModel() {
        ((CourseSearchViewModel)this.viewModel).getSearchPoiListLiveData().observe(this, new Observer<JSONObject>(){

            @Override
            public void onChanged(JSONObject jSONObject) {
                if (jSONObject.has("data")) {
                    JSONArray jSONArray = new JSONArray();
                    JSONObject jSONObject2 = new JSONObject();
                    jSONObject2.put("type", 0);
                    jSONObject2.put("icon", 2131165558);
                    jSONObject2.put("text", (Object)App.get("Relevants"));
                    jSONArray.put((Object)jSONObject2);
                    JSONArray jSONArray2 = jSONObject.getJSONArray("data");
                    for (int i = 0; i < jSONArray2.length(); ++i) {
                        jSONObject = jSONArray2.getJSONObject(i);
                        JSONObject jSONObject3 = jSONObject.getJSONObject("latlng");
                        jSONObject2 = new JSONObject();
                        jSONObject2.put("type", 2);
                        jSONObject2.put("text", (Object)jSONObject.getString("name"));
                        jSONObject2.put("address", (Object)jSONObject.getString("vicinity"));
                        StringBuilder stringBuilder = new StringBuilder();
                        stringBuilder.append(Utils.convertKM((float)DistanceUtil.distanceMeteor2Km(jSONObject.getDouble("distance"))));
                        stringBuilder.append(" ");
                        stringBuilder.append(Utils.getUnitByKM());
                        jSONObject2.put("distance", (Object)stringBuilder.toString());
                        jSONObject2.put("lat", jSONObject3.getDouble("lat"));
                        jSONObject2.put("lng", jSONObject3.getDouble("lng"));
                        jSONArray.put((Object)jSONObject2);
                    }
                    try {
                        jSONObject = new JSONObject();
                        jSONObject.put("searches", (Object)jSONArray);
                        ((CourseSearchViewModel)CourseSearchActivity.this.viewModel).updateSearchResult(jSONObject.toString());
                        CourseSearchActivity.this.resultAdapter.swapItems(((CourseSearchViewModel)CourseSearchActivity.this.viewModel).getSearchResults(""));
                    }
                    catch (JSONException jSONException) {
                        jSONException.printStackTrace();
                    }
                }
            }
        });
        ((CourseSearchViewModel)this.viewModel).loadSearchHistoryListLive().observe(this, new Observer<List<CourseSearchHistoryEntity>>(){

            @Override
            public void onChanged(List<CourseSearchHistoryEntity> jSONObject) {
                if (jSONObject.size() > 0) {
                    JSONArray jSONArray = new JSONArray();
                    JSONObject jSONObject2 = new JSONObject();
                    jSONObject2.put("type", 0);
                    jSONObject2.put("icon", 2131165572);
                    jSONObject2.put("text", (Object)App.get("Recents"));
                    jSONArray.put((Object)jSONObject2);
                    for (int i = 0; i < jSONObject.size(); ++i) {
                        CourseSearchHistoryEntity courseSearchHistoryEntity = jSONObject.get(i);
                        jSONObject2 = new JSONObject();
                        jSONObject2.put("type", 1);
                        jSONObject2.put("text", (Object)courseSearchHistoryEntity.getContent());
                        jSONArray.put((Object)jSONObject2);
                    }
                    try {
                        jSONObject = new JSONObject();
                        jSONObject.put("defaults", (Object)jSONArray);
                        ((CourseSearchViewModel)CourseSearchActivity.this.viewModel).updateSearchResult(jSONObject.toString());
                        CourseSearchActivity.this.updateLocation();
                        ((CourseSearchViewModel)CourseSearchActivity.this.viewModel).updateDefaults((Context)CourseSearchActivity.this.activity, CourseSearchActivity.this.mLocation);
                        CourseSearchActivity.this.resultAdapter.swapItems(((CourseSearchViewModel)CourseSearchActivity.this.viewModel).getDefaultResults());
                    }
                    catch (JSONException jSONException) {
                        jSONException.printStackTrace();
                    }
                }
            }
        });
    }

    private void startSearchLayoutAnimation() {
        this.post(new CourseSearchActivity$$ExternalSyntheticLambda3(this));
    }

    @Override
    protected ActivityCourseSearchBinding createViewBinding(LayoutInflater layoutInflater) {
        return ActivityCourseSearchBinding.inflate(layoutInflater);
    }

    @Override
    protected CourseSearchViewModel createViewModel() {
        return new ViewModelProvider(this).get(CourseSearchViewModel.class);
    }

    @Override
    protected void initColor() {
    }

    @Override
    protected void initFont() {
    }

    @Override
    protected void initText() {
        App.put("Where to?", i18N.get("_750Wereto"));
        App.put("Cancel", i18N.get("B_Cancel"));
        App.put("Recents", i18N.get("Recent"));
        App.put("Favorites", i18N.get("Favorites"));
        App.put("Relevants", i18N.get("Relevants"));
        this.setActionbarVisibility(8);
        ((ActivityCourseSearchBinding)this.binding).searchEdit.setHint((CharSequence)App.get("Where to?"));
        ((ActivityCourseSearchBinding)this.binding).searchEdit.setFocusable(true);
        ((ActivityCourseSearchBinding)this.binding).searchEdit.requestFocus();
        ((ActivityCourseSearchBinding)this.binding).cancelText.setText((CharSequence)App.get("Cancel"));
    }

    public /* synthetic */ void lambda$animateSearchLayout$4$com-brytonsport-active-ui-course-CourseSearchActivity(int n) {
        this.animateSearchLayout(n);
    }

    public /* synthetic */ void lambda$setListeners$0$com-brytonsport-active-ui-course-CourseSearchActivity(View view) {
        this.finish();
    }

    public /* synthetic */ void lambda$setListeners$1$com-brytonsport-active-ui-course-CourseSearchActivity(View view) {
        ((ActivityCourseSearchBinding)this.binding).clearImage.setVisibility(8);
        ((ActivityCourseSearchBinding)this.binding).searchEdit.setText((CharSequence)"");
        if (((CourseSearchViewModel)this.viewModel).getDefaultResults().size() != 0) {
            this.resultAdapter.swapItems(((CourseSearchViewModel)this.viewModel).getDefaultResults());
        } else if (((CourseSearchViewModel)this.viewModel).mDefaultsList.size() != 0) {
            this.resultAdapter.swapItems(((CourseSearchViewModel)this.viewModel).mDefaultsList);
        }
    }

    public /* synthetic */ void lambda$setListeners$2$com-brytonsport-active-ui-course-CourseSearchActivity(SearchResult searchResult) {
        if (searchResult.type == 1) {
            if (searchResult.isFavorite) {
                this.setResult(-1, new Intent().putExtra("data", searchResult.encode()));
                this.finish();
            } else {
                ((ActivityCourseSearchBinding)this.binding).searchEdit.setText((CharSequence)searchResult.text);
                this.executeSearchEvent();
            }
        } else if (searchResult.type == 2) {
            this.setResult(-1, new Intent().putExtra("data", searchResult.encode()));
            this.finish();
        }
    }

    public /* synthetic */ void lambda$startSearchLayoutAnimation$3$com-brytonsport-active-ui-course-CourseSearchActivity() {
        this.animateSearchLayout(((ViewGroup.MarginLayoutParams)((ActivityCourseSearchBinding)this.binding).searchLayout.getLayoutParams()).topMargin / 20);
    }

    @Override
    protected void onCreate() {
        super.onCreate();
        this.updateLocation();
        ((CourseSearchViewModel)this.viewModel).updateDefaults((Context)this, this.mLocation);
        this.startSearchLayoutAnimation();
        ((ActivityCourseSearchBinding)this.binding).searchList.setLayoutManager(new AdvancedLinearLayoutManager((Context)this));
        this.resultAdapter = new SearchResultAdapter((Activity)this, ((CourseSearchViewModel)this.viewModel).getDefaultResults());
        ((ActivityCourseSearchBinding)this.binding).searchList.setAdapter(this.resultAdapter);
        this.nowLat = this.getIntent().getDoubleExtra("nowLat", 0.0);
        this.nowLng = this.getIntent().getDoubleExtra("nowLng", 0.0);
        this.observeViewModel();
    }

    @Override
    protected void setListeners() {
        ((ActivityCourseSearchBinding)this.binding).cancelText.setOnClickListener((View.OnClickListener)new CourseSearchActivity$$ExternalSyntheticLambda0(this));
        ((ActivityCourseSearchBinding)this.binding).clearImage.setOnClickListener((View.OnClickListener)new CourseSearchActivity$$ExternalSyntheticLambda1(this));
        ((ActivityCourseSearchBinding)this.binding).searchEdit.setOnEditorActionListener(new TextView.OnEditorActionListener(){

            public boolean onEditorAction(TextView textView, int n, KeyEvent keyEvent) {
                if (n != 3 && (keyEvent == null || keyEvent.getKeyCode() != 66)) {
                    return false;
                }
                CourseSearchActivity.this.executeSearchEvent();
                return true;
            }
        });
        ((ActivityCourseSearchBinding)this.binding).searchEdit.addTextChangedListener(new TextWatcher(){

            public void afterTextChanged(Editable editable) {
                CourseSearchActivity.access$102(CourseSearchActivity.this, editable.toString());
                editable = ((ActivityCourseSearchBinding)CourseSearchActivity.this.binding).clearImage;
                int n = TextUtils.isEmpty((CharSequence)CourseSearchActivity.this.searchString) ? 8 : 0;
                editable.setVisibility(n);
            }

            public void beforeTextChanged(CharSequence charSequence, int n, int n2, int n3) {
            }

            public void onTextChanged(CharSequence charSequence, int n, int n2, int n3) {
            }
        });
        this.resultAdapter.setOnResultItemClickListener(new CourseSearchActivity$$ExternalSyntheticLambda2(this));
    }
}

