/*
 * Decompiled with CFR 0.152.
 */
package com.brytonsport.active.ui.course;

import android.content.Context;
import android.content.Intent;
import android.os.Handler;
import android.os.Message;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.View;
import android.widget.ImageView;
import androidx.lifecycle.LiveData;
import androidx.lifecycle.Observer;
import androidx.lifecycle.ViewModelProvider;
import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.viewpager.widget.PagerAdapter;
import androidx.viewpager.widget.ViewPager;
import com.brytonsport.active.api.account.vo.AccountErrorVo;
import com.brytonsport.active.api.account.vo.AccountUserInfo;
import com.brytonsport.active.api.account.vo.Services;
import com.brytonsport.active.api.account.vo.Trainingpeaks;
import com.brytonsport.active.base.App;
import com.brytonsport.active.databinding.ActivityCourseWorkoutBinding;
import com.brytonsport.active.repo.profile.Connect3rdPartyRepository;
import com.brytonsport.active.repo.setting.DeviceRepository;
import com.brytonsport.active.ui.course.CourseWorkoutActivity$$ExternalSyntheticLambda0;
import com.brytonsport.active.ui.course.CourseWorkoutActivity$$ExternalSyntheticLambda1;
import com.brytonsport.active.ui.course.CourseWorkoutActivity$$ExternalSyntheticLambda2;
import com.brytonsport.active.ui.course.CourseWorkoutActivity$$ExternalSyntheticLambda3;
import com.brytonsport.active.ui.course.CourseWorkoutActivity$$ExternalSyntheticLambda4;
import com.brytonsport.active.ui.course.CourseWorkoutActivity$$ExternalSyntheticLambda5;
import com.brytonsport.active.ui.course.CourseWorkoutActivity$$ExternalSyntheticLambda6;
import com.brytonsport.active.ui.course.CourseWorkoutActivity$$ExternalSyntheticLambda7;
import com.brytonsport.active.ui.course.CourseWorkoutActivity$$ExternalSyntheticLambda8;
import com.brytonsport.active.ui.course.Hilt_CourseWorkoutActivity;
import com.brytonsport.active.ui.course.dialog.DeleteWorkoutDialog;
import com.brytonsport.active.ui.course.pager.MyWorkoutPager;
import com.brytonsport.active.ui.course.pager.TrainingPlanPager;
import com.brytonsport.active.utils.DeviceBusyStatusUtil;
import com.brytonsport.active.utils.FeatureUtil;
import com.brytonsport.active.utils.NetworkUtil;
import com.brytonsport.active.utils.ToastUtil;
import com.brytonsport.active.utils.i18N;
import com.brytonsport.active.views.adapter.ViewPagerAdapter;
import com.brytonsport.active.views.dialog.BottomPopupDialog;
import com.brytonsport.active.views.dialog.ConfirmDialog;
import com.brytonsport.active.views.dialog.PopupDialog;
import com.brytonsport.active.vm.base.TrainingPlan;
import com.brytonsport.active.vm.course.CourseWorkoutViewModel;
import java.util.ArrayList;
import java.util.List;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class CourseWorkoutActivity
extends Hilt_CourseWorkoutActivity<ActivityCourseWorkoutBinding, CourseWorkoutViewModel> {
    LiveData<AccountUserInfo> accountLiveData;
    private int firstVisiblePosition = 0;
    private int lastVisiblePosition = 0;
    private ImageView menuDeleteIcon;
    private ImageView menuSortIcon;
    private ImageView menuSyncIcon;
    private MyWorkoutPager myWorkoutPager;
    private Trainingpeaks trainingPeaks;
    private TrainingPlanPager trainingPlanPager;
    private Handler updateRouteImageHandler = new Handler(new Handler.Callback(){

        public boolean handleMessage(Message object) {
            if (((Message)object).what == 1) {
                CourseWorkoutActivity.this.updateRouteImageHandler.removeMessages(1);
                ((CourseWorkoutActivity)CourseWorkoutActivity.this).myWorkoutPager.myWorkoutAdapter.notifyItemRangeChanged(CourseWorkoutActivity.this.firstVisiblePosition, CourseWorkoutActivity.this.lastVisiblePosition - CourseWorkoutActivity.this.firstVisiblePosition + 1);
                object = new StringBuilder();
                ((StringBuilder)object).append("updateRouteImageHandler -> firstVisiblePosition: ");
                ((StringBuilder)object).append(CourseWorkoutActivity.this.firstVisiblePosition);
                ((StringBuilder)object).append(", \u66f4\u65b0\u5e7e\u7b46: ");
                ((StringBuilder)object).append(CourseWorkoutActivity.this.lastVisiblePosition - CourseWorkoutActivity.this.firstVisiblePosition + 1);
                ((StringBuilder)object).append(", getItemCount: ");
                ((StringBuilder)object).append(((CourseWorkoutActivity)CourseWorkoutActivity.this).myWorkoutPager.myWorkoutAdapter.getItemCount());
                Log.d((String)"ActivityBase", (String)((StringBuilder)object).toString());
            }
            return true;
        }
    });

    static /* synthetic */ Trainingpeaks access$302(CourseWorkoutActivity courseWorkoutActivity, Trainingpeaks trainingpeaks) {
        courseWorkoutActivity.trainingPeaks = trainingpeaks;
        return trainingpeaks;
    }

    static /* synthetic */ int access$702(CourseWorkoutActivity courseWorkoutActivity, int n) {
        courseWorkoutActivity.firstVisiblePosition = n;
        return n;
    }

    static /* synthetic */ int access$802(CourseWorkoutActivity courseWorkoutActivity, int n) {
        courseWorkoutActivity.lastVisiblePosition = n;
        return n;
    }

    private void checkSptWorkout() {
        new Thread(new CourseWorkoutActivity$$ExternalSyntheticLambda7(this)).start();
    }

    private void closeLoading() {
        this.dismissProgressDialog();
    }

    public static Intent createIntent(Context context) {
        return new Intent(context, CourseWorkoutActivity.class);
    }

    private void downLoadToDevice() {
        BottomPopupDialog bottomPopupDialog = new BottomPopupDialog((Context)this.activity);
        bottomPopupDialog.setOnMenuItemClickListener(new CourseWorkoutActivity$$ExternalSyntheticLambda5(this)).setHint(App.get("The workouts in 7 days will be synced to the device."));
        new Thread(new CourseWorkoutActivity$$ExternalSyntheticLambda8(this, bottomPopupDialog)).start();
    }

    private void loadAccountInfo() {
        LiveData<AccountUserInfo> liveData = ((CourseWorkoutViewModel)this.viewModel).getUserInfoFromDb();
        this.accountLiveData = liveData;
        liveData.observe(this, new Observer<AccountUserInfo>(){

            @Override
            public void onChanged(AccountUserInfo object) {
                if (object == null) {
                    return;
                }
                if ((object = ((AccountUserInfo)object).getServices()) != null) {
                    CourseWorkoutActivity.access$302(CourseWorkoutActivity.this, ((Services)object).getTrainingpeaks());
                    if (CourseWorkoutActivity.this.trainingPeaks != null) {
                        Log.d((String)"ActivityBase", (String)"\u547c\u53eb syncTrainingPeaksWorkout: ");
                        CourseWorkoutActivity.this.syncTrainingPeaksWorkout();
                    }
                }
            }
        });
    }

    private void observeViewModel() {
        ((CourseWorkoutViewModel)this.viewModel).getToken2ServerLiveData().observe(this, new Observer<Connect3rdPartyRepository.Token2ServerResult>(){

            @Override
            public void onChanged(Connect3rdPartyRepository.Token2ServerResult token2ServerResult) {
                if (token2ServerResult != null && token2ServerResult.result() && token2ServerResult.name().equals("trainingpeaks")) {
                    ((CourseWorkoutViewModel)CourseWorkoutActivity.this.viewModel).getUserInfo();
                }
            }
        });
        ((CourseWorkoutViewModel)this.viewModel).getTrainingPeaksNeedRefreshToken().observe(this, new Observer<Boolean>(){

            @Override
            public void onChanged(Boolean object) {
                object = CourseWorkoutActivity.this.trainingPeaks.getRefreshToken();
                if (object != null && !((String)object).isEmpty()) {
                    ((CourseWorkoutViewModel)CourseWorkoutActivity.this.viewModel).refreshTrainingPeaksToken((String)object);
                }
            }
        });
        ((CourseWorkoutViewModel)this.viewModel).getLiveAccountErrorResponse().observe(this, new Observer<AccountErrorVo>(){

            @Override
            public void onChanged(AccountErrorVo accountErrorVo) {
                if (accountErrorVo.getMessage() != null && !accountErrorVo.getMessage().isEmpty() && accountErrorVo.getCode() == 401 && accountErrorVo.getMessage().equals("You must be logged in to do this.")) {
                    CourseWorkoutActivity.this.showTokenExpireDialog();
                }
            }
        });
        ((CourseWorkoutViewModel)this.viewModel).getTrainingPeaksResultLiveData().observe(this, new Observer<ArrayList<TrainingPlan>>(){

            @Override
            public void onChanged(ArrayList<TrainingPlan> arrayList) {
                ((CourseWorkoutViewModel)CourseWorkoutActivity.this.viewModel).uploadTrainingPeaksWorkouts(CourseWorkoutActivity.this.trainingPeaks.getAccessToken(), arrayList);
            }
        });
        ((CourseWorkoutViewModel)this.viewModel).getDefaultWorkoutListLiveData().observe(this, new Observer<ArrayList<TrainingPlan>>(){

            @Override
            public void onChanged(ArrayList<TrainingPlan> arrayList) {
                ((CourseWorkoutViewModel)CourseWorkoutActivity.this.viewModel).defaultWorkouts = arrayList;
                arrayList = new ArrayList();
                arrayList.addAll(((CourseWorkoutViewModel)CourseWorkoutActivity.this.viewModel).workouts);
                arrayList.addAll(((CourseWorkoutViewModel)CourseWorkoutActivity.this.viewModel).defaultWorkouts);
                CourseWorkoutActivity.this.myWorkoutPager.updateWorkoutList(arrayList);
            }
        });
        ((CourseWorkoutViewModel)this.viewModel).getTrainingPlanListResultLiveData().observe(this, new Observer<List<TrainingPlan>>(){

            @Override
            public void onChanged(List<TrainingPlan> list) {
                ((CourseWorkoutViewModel)CourseWorkoutActivity.this.viewModel).workouts = (ArrayList)list;
                list = new ArrayList<TrainingPlan>();
                ((ArrayList)list).addAll(((CourseWorkoutViewModel)CourseWorkoutActivity.this.viewModel).workouts);
                ((ArrayList)list).addAll(((CourseWorkoutViewModel)CourseWorkoutActivity.this.viewModel).defaultWorkouts);
                CourseWorkoutActivity.this.myWorkoutPager.updateWorkoutList((ArrayList<TrainingPlan>)list);
                CourseWorkoutActivity.this.trainingPlanPager.updateWorkoutList(((CourseWorkoutViewModel)CourseWorkoutActivity.this.viewModel).workouts);
            }
        });
        ((CourseWorkoutViewModel)this.viewModel).getGetWorkoutDecodeJsonSaveLiveData().observe(this, new Observer<Boolean>(){

            @Override
            public void onChanged(Boolean object) {
                object = CourseWorkoutActivity.this;
                CourseWorkoutActivity.access$702((CourseWorkoutActivity)object, ((LinearLayoutManager)((CourseWorkoutActivity)object).myWorkoutPager.binding.workoutList.getLayoutManager()).findFirstVisibleItemPosition());
                object = CourseWorkoutActivity.this;
                CourseWorkoutActivity.access$802((CourseWorkoutActivity)object, ((LinearLayoutManager)((CourseWorkoutActivity)object).myWorkoutPager.binding.workoutList.getLayoutManager()).findLastVisibleItemPosition());
                object = new StringBuilder();
                ((StringBuilder)object).append("WorkoutDecodeJson \u7522\u597d onChanged -> firstVisiblePosition: ");
                ((StringBuilder)object).append(CourseWorkoutActivity.this.firstVisiblePosition);
                ((StringBuilder)object).append(", lastVisiblePosition: ");
                ((StringBuilder)object).append(CourseWorkoutActivity.this.lastVisiblePosition);
                Log.d((String)"ActivityBase", (String)((StringBuilder)object).toString());
                CourseWorkoutActivity.this.updateRouteImageHandler.removeMessages(1);
                CourseWorkoutActivity.this.updateRouteImageHandler.sendEmptyMessageDelayed(1, 3000L);
            }
        });
        ((CourseWorkoutViewModel)this.viewModel).getWorkoutDeleteResultLive().observe(this, new Observer<Boolean>(){

            @Override
            public void onChanged(Boolean bl) {
                CourseWorkoutActivity.this.closeLoading();
                if (!bl.booleanValue()) {
                    ToastUtil.showToast((Context)CourseWorkoutActivity.this, "failed to delete");
                }
            }
        });
    }

    private void openLoading() {
        this.showProgressDialog("");
    }

    private void syncTrainingPeaksWorkout() {
        ((CourseWorkoutViewModel)this.viewModel).syncTrainingPeaks(this.trainingPeaks.getAccessToken());
    }

    @Override
    protected ActivityCourseWorkoutBinding createViewBinding(LayoutInflater layoutInflater) {
        return ActivityCourseWorkoutBinding.inflate(layoutInflater);
    }

    @Override
    protected CourseWorkoutViewModel createViewModel() {
        return new ViewModelProvider(this).get(CourseWorkoutViewModel.class);
    }

    @Override
    protected void initColor() {
        ((ActivityCourseWorkoutBinding)this.binding).getRoot().setBackgroundResource(2131034148);
    }

    @Override
    protected void initFont() {
    }

    @Override
    protected void initText() {
        App.put("The workouts in 7 days will be synced to the device.", i18N.get("SyncWtoD7"));
        App.put("Sync Weekly Plans to Device", i18N.get("SyncWtoD"));
        App.put("ADD WORKOUT", i18N.get("T_AddWorkout"));
        App.put("Cancel", i18N.get("B_Cancel"));
        this.setTitle(i18N.get("T_Workout"));
        ((ActivityCourseWorkoutBinding)this.binding).trainingPlanTab.textView.setText((CharSequence)i18N.get("WorkoutPlan"));
        ((ActivityCourseWorkoutBinding)this.binding).myWorkoutTab.textView.setText((CharSequence)i18N.get("T_MyWorkout"));
    }

    public /* synthetic */ void lambda$checkSptWorkout$6$com-brytonsport-active-ui-course-CourseWorkoutActivity() {
        int n = DeviceRepository.getInstance().deviceFeatureSupportSync(FeatureUtil.FeatureType.WorkoutPlan);
        if (!DeviceRepository.getInstance().isDeviceAlreadyConnectedSync()) {
            this.runOnUiThread(new Runnable(){

                @Override
                public void run() {
                    ConfirmDialog.showSelfSingle(CourseWorkoutActivity.this, i18N.get("M_NoConnectedDev"));
                }
            });
        } else if (n <= 0) {
            Log.d((String)"ActivityBase", (String)"checkSptWorkoutPlan: 0: \u4e0d\u652f\u63f4");
            this.runOnUiThread(new Runnable(){

                @Override
                public void run() {
                    ConfirmDialog.showSelfSingle(CourseWorkoutActivity.this, i18N.get("M_NotSupportThisDev"));
                }
            });
        } else {
            this.runOnUiThread(new Runnable(){

                @Override
                public void run() {
                    DeviceBusyStatusUtil.DeviceStatus deviceStatus = DeviceBusyStatusUtil.getNowDeviceStatus();
                    if (deviceStatus.equals((Object)DeviceBusyStatusUtil.DeviceStatus.SyncActivity)) {
                        ConfirmDialog.showSelfSingle(CourseWorkoutActivity.this.activity, i18N.get("M_ReadDevice"), i18N.get("B_OK"));
                    } else if (deviceStatus.equals((Object)DeviceBusyStatusUtil.DeviceStatus.RunningGroupRide)) {
                        ConfirmDialog.showSelfSingle(CourseWorkoutActivity.this.activity, i18N.get("StopGRFrist"), i18N.get("B_OK"));
                    } else if (deviceStatus.equals((Object)DeviceBusyStatusUtil.DeviceStatus.SendServerEeToDev)) {
                        ConfirmDialog.showSelfSingle(CourseWorkoutActivity.this.activity, i18N.get("M_DeviceBusy"), i18N.get("B_OK"));
                    } else {
                        CourseWorkoutActivity.this.downLoadToDevice();
                    }
                }
            });
        }
    }

    public /* synthetic */ void lambda$downLoadToDevice$7$com-brytonsport-active-ui-course-CourseWorkoutActivity(int n) {
        ArrayList<TrainingPlan> arrayList = this.trainingPlanPager.getRecentPlans();
        if (arrayList.size() > 0) {
            this.showProgressDialog("");
            ((CourseWorkoutViewModel)this.viewModel).sendWorkoutsToDevice(arrayList, new CourseWorkoutViewModel.SyncListener(){

                @Override
                public void onComplete() {
                    ConfirmDialog.showSelfSingle(CourseWorkoutActivity.this.activity, i18N.get("workoutToDev"), i18N.get("B_Done"));
                    CourseWorkoutActivity.this.dismissProgressDialog();
                }
            });
        }
    }

    public /* synthetic */ void lambda$downLoadToDevice$8$com-brytonsport-active-ui-course-CourseWorkoutActivity(final BottomPopupDialog bottomPopupDialog) {
        final Boolean bl = ((CourseWorkoutViewModel)this.viewModel).isDeviceConnected();
        this.activity.runOnUiThread(new Runnable(){

            @Override
            public void run() {
                bottomPopupDialog.showPopup(App.get("Sync Weekly Plans to Device"));
                if (!bl.booleanValue()) {
                    bottomPopupDialog.disableMenu(0);
                }
            }
        });
    }

    public /* synthetic */ void lambda$setListeners$0$com-brytonsport-active-ui-course-CourseWorkoutActivity(View view) {
        this.checkSptWorkout();
    }

    public /* synthetic */ void lambda$setListeners$1$com-brytonsport-active-ui-course-CourseWorkoutActivity(int n) {
        if (n == 0) {
            this.myWorkoutPager.myWorkoutAdapter.sortByAddedDate();
        } else if (n == 1) {
            this.myWorkoutPager.myWorkoutAdapter.sortByName();
        } else if (n == 2) {
            this.myWorkoutPager.myWorkoutAdapter.sortByDuration();
        } else if (n == 3) {
            this.myWorkoutPager.myWorkoutAdapter.sortBySource();
        }
    }

    public /* synthetic */ void lambda$setListeners$2$com-brytonsport-active-ui-course-CourseWorkoutActivity(View view) {
        new PopupDialog((Context)this.activity).setOnMenuItemClickListener(new CourseWorkoutActivity$$ExternalSyntheticLambda6(this)).showPopup(i18N.get("B_AddedDate"), i18N.get("B_Name"), i18N.get("B_Duration"), i18N.get("B_Source"));
    }

    public /* synthetic */ void lambda$setListeners$3$com-brytonsport-active-ui-course-CourseWorkoutActivity(ArrayList arrayList) {
        this.openLoading();
        ((CourseWorkoutViewModel)this.viewModel).deleteWorkoutList(arrayList);
        this.myWorkoutPager.myWorkoutAdapter.deleteTrainingPlans(arrayList);
    }

    public /* synthetic */ void lambda$setListeners$4$com-brytonsport-active-ui-course-CourseWorkoutActivity(View view) {
        new DeleteWorkoutDialog(this.activity).setOnActionClickListener(new CourseWorkoutActivity$$ExternalSyntheticLambda4(this)).showPopup(this.myWorkoutPager.myWorkoutAdapter.getAllTrainingPlans());
    }

    public /* synthetic */ void lambda$setListeners$5$com-brytonsport-active-ui-course-CourseWorkoutActivity(View view) {
        if (view.equals((Object)((ActivityCourseWorkoutBinding)this.binding).trainingPlanTab)) {
            this.menuSyncIcon.setVisibility(0);
            this.menuSortIcon.setVisibility(8);
            this.menuDeleteIcon.setVisibility(8);
            ((ActivityCourseWorkoutBinding)this.binding).viewPager.setCurrentItem(0, true);
        } else if (view.equals((Object)((ActivityCourseWorkoutBinding)this.binding).myWorkoutTab)) {
            this.menuSyncIcon.setVisibility(8);
            this.menuSortIcon.setVisibility(0);
            this.menuDeleteIcon.setVisibility(0);
            ((ActivityCourseWorkoutBinding)this.binding).viewPager.setCurrentItem(1, true);
        }
    }

    @Override
    protected void onCreate() {
        super.onCreate();
        if (!NetworkUtil.isNetworkConnect((Context)this)) {
            ConfirmDialog.showSelfSingle(this.activity, i18N.get("M_NoInternet"));
        }
        this.menuSyncIcon = this.addMenu(2131165575);
        this.menuSortIcon = this.addMenu(2131165604);
        this.menuDeleteIcon = this.addMenu(2131165451);
        this.menuSortIcon.setVisibility(8);
        this.menuDeleteIcon.setVisibility(8);
        ((ActivityCourseWorkoutBinding)this.binding).trainingPlanTab.setSelected(true);
        this.trainingPlanPager = new TrainingPlanPager((Context)this, ((CourseWorkoutViewModel)this.viewModel).workouts);
        this.myWorkoutPager = new MyWorkoutPager(this, ((CourseWorkoutViewModel)this.viewModel).workouts, (CourseWorkoutViewModel)this.viewModel);
        Object object = new ArrayList<View>();
        ((ArrayList)object).add(this.trainingPlanPager);
        ((ArrayList)object).add(this.myWorkoutPager);
        object = new ViewPagerAdapter((Context)this, (List<View>)object);
        ((ActivityCourseWorkoutBinding)this.binding).viewPager.setAdapter((PagerAdapter)object);
        ((ActivityCourseWorkoutBinding)this.binding).trainingPlanTab.setSelected(false);
        ((ActivityCourseWorkoutBinding)this.binding).myWorkoutTab.setSelected(true);
        this.menuSyncIcon.setVisibility(8);
        this.menuSortIcon.setVisibility(0);
        this.menuDeleteIcon.setVisibility(0);
        ((ActivityCourseWorkoutBinding)this.binding).viewPager.setCurrentItem(1, true);
        ((CourseWorkoutViewModel)this.viewModel).getWorkoutList();
        ((CourseWorkoutViewModel)this.viewModel).getDefaultWorkouts();
        ((CourseWorkoutViewModel)this.viewModel).registerBLEReceiver((Context)this);
        this.observeViewModel();
        this.loadAccountInfo();
    }

    @Override
    protected void onDestroy() {
        super.onDestroy();
        ((CourseWorkoutViewModel)this.viewModel).unregisterBLEReceiver((Context)this);
    }

    @Override
    protected void setListeners() {
        this.menuSyncIcon.setOnClickListener((View.OnClickListener)new CourseWorkoutActivity$$ExternalSyntheticLambda0(this));
        this.menuSortIcon.setOnClickListener((View.OnClickListener)new CourseWorkoutActivity$$ExternalSyntheticLambda1(this));
        this.menuDeleteIcon.setOnClickListener((View.OnClickListener)new CourseWorkoutActivity$$ExternalSyntheticLambda2(this));
        CourseWorkoutActivity$$ExternalSyntheticLambda3 courseWorkoutActivity$$ExternalSyntheticLambda3 = new CourseWorkoutActivity$$ExternalSyntheticLambda3(this);
        ((ActivityCourseWorkoutBinding)this.binding).trainingPlanTab.setOnClickListener(courseWorkoutActivity$$ExternalSyntheticLambda3);
        ((ActivityCourseWorkoutBinding)this.binding).myWorkoutTab.setOnClickListener(courseWorkoutActivity$$ExternalSyntheticLambda3);
        ((ActivityCourseWorkoutBinding)this.binding).viewPager.addOnPageChangeListener(new ViewPager.OnPageChangeListener(){

            @Override
            public void onPageScrollStateChanged(int n) {
            }

            @Override
            public void onPageScrolled(int n, float f, int n2) {
            }

            @Override
            public void onPageSelected(int n) {
                CourseWorkoutActivity.this.menuSyncIcon.setVisibility(8);
                CourseWorkoutActivity.this.menuSortIcon.setVisibility(8);
                CourseWorkoutActivity.this.menuDeleteIcon.setVisibility(8);
                ((ActivityCourseWorkoutBinding)CourseWorkoutActivity.this.binding).trainingPlanTab.setSelected(false);
                ((ActivityCourseWorkoutBinding)CourseWorkoutActivity.this.binding).myWorkoutTab.setSelected(false);
                if (n == 0) {
                    CourseWorkoutActivity.this.menuSyncIcon.setVisibility(0);
                    ((ActivityCourseWorkoutBinding)CourseWorkoutActivity.this.binding).trainingPlanTab.setSelected(true);
                } else if (n == 1) {
                    CourseWorkoutActivity.this.menuSortIcon.setVisibility(0);
                    CourseWorkoutActivity.this.menuDeleteIcon.setVisibility(0);
                    ((ActivityCourseWorkoutBinding)CourseWorkoutActivity.this.binding).myWorkoutTab.setSelected(true);
                }
            }
        });
        ((CourseWorkoutViewModel)this.viewModel).isUserInfoSuccessLiveData().observe(this, new Observer<Boolean>(){

            @Override
            public void onChanged(Boolean bl) {
                Log.d((String)"ActivityBase", (String)"\u5f85\u9a57\u8b49 \u524d\u9762\u5df2\u5148\u8a3b\u518a\u89c0\u5bdf\u8005: \u6216\u53ef\u907f\u514dTrainingPeaks\u4e00\u6b21\u540c\u6b65\u591a\u7b46 loadAccountInfo");
            }
        });
    }
}

