/*
 * Decompiled with CFR 0.152.
 */
package com.brytonsport.active.ui.course.adapter;

import android.content.Context;
import android.text.TextUtils;
import android.view.View;
import androidx.recyclerview.widget.RecyclerView;
import com.brytonsport.active.ui.course.CourseGroupTrackQuickReplyActivity;
import com.brytonsport.active.ui.course.adapter.item.GroupTrackQuickReplyHeaderItem;
import com.brytonsport.active.ui.course.adapter.item.GroupTrackQuickReplyItem;
import com.brytonsport.active.ui.setting.adapter.item.SettingSubtitleItem;
import com.brytonsport.active.utils.i18N;
import com.brytonsport.active.views.adapter.FreeRecyclerViewAdapter;
import com.brytonsport.active.views.adapter.callback.ItemMoveCallback;
import com.brytonsport.active.vm.base.QuickReply;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;

public class GroupTrackQuickReplyAdapter
extends FreeRecyclerViewAdapter<Object>
implements ItemMoveCallback.ItemTouchHelperContract {
    public static final int TYPE_HEADER = 4097;
    public static final int TYPE_QUICK_REPLY_PLACEHOLDER = 4099;
    public static final int TYPE_SUBTITLE = 4098;
    private ArrayList<QuickReply> defaultQuickReplies = new ArrayList();

    public GroupTrackQuickReplyAdapter(CourseGroupTrackQuickReplyActivity courseGroupTrackQuickReplyActivity, ArrayList<Object> arrayList) {
        super(courseGroupTrackQuickReplyActivity, arrayList);
    }

    @Override
    public boolean canRowMoved(RecyclerView.ViewHolder viewHolder) {
        return false;
    }

    public ArrayList<QuickReply> getQuickReplies() {
        ArrayList<QuickReply> arrayList = new ArrayList<QuickReply>();
        arrayList.addAll(this.defaultQuickReplies);
        for (Object object : this.getItems()) {
            if (!(object instanceof QuickReply)) continue;
            object = (QuickReply)object;
            if (TextUtils.isEmpty((CharSequence)((QuickReply)object).message)) continue;
            arrayList.add((QuickReply)object);
        }
        return arrayList;
    }

    @Override
    public int getViewType(int n) {
        if (this.getItem(n) instanceof Integer) {
            return (Integer)this.getItem(n);
        }
        return 4099;
    }

    @Override
    public View initView(int n) {
        if (n == 4097) {
            return new GroupTrackQuickReplyHeaderItem((Context)this.activity);
        }
        if (n == 4098) {
            return new SettingSubtitleItem((Context)this.activity);
        }
        return new GroupTrackQuickReplyItem((Context)this.activity);
    }

    @Override
    public void onRowClear(RecyclerView.ViewHolder viewHolder) {
        viewHolder.itemView.findViewById(2131231295).setBackgroundColor(-14998216);
        viewHolder.itemView.findViewById(2131231094).setVisibility(0);
    }

    @Override
    public void onRowMoved(int n, int n2) {
        if (n < n2) {
            int n3 = n;
            while (n3 < n2) {
                ArrayList arrayList = this.getItems();
                int n4 = n3 + 1;
                Collections.swap(arrayList, n3, n4);
                n3 = n4;
            }
        } else {
            for (int i = n; i > n2; --i) {
                Collections.swap(this.getItems(), i, i - 1);
            }
        }
        this.notifyItemMoved(n, n2);
    }

    @Override
    public void onRowSelected(RecyclerView.ViewHolder viewHolder) {
        viewHolder.itemView.findViewById(2131231295).setBackgroundColor(-14076856);
        viewHolder.itemView.findViewById(2131231094).setVisibility(4);
    }

    public void setQuickReplies(ArrayList<QuickReply> object) {
        Iterator<QuickReply> iterator = ((ArrayList)object).iterator();
        int n = 0;
        while (iterator.hasNext()) {
            object = iterator.next();
            if (((QuickReply)object).isDefault) {
                this.defaultQuickReplies.add((QuickReply)object);
                continue;
            }
            ++n;
            this.addItem(object);
        }
        if (n < 8) {
            int n2 = 0;
            while (n2 < 8 - n) {
                this.addItem(new QuickReply(false, ++n2 + 2, ""));
            }
        }
        this.notifyDataSetChanged();
    }

    @Override
    public void setView(int n, int n2, View view) {
        if (n2 == 4097) {
            ((GroupTrackQuickReplyHeaderItem)view).setDefaultQuickReplies(this.defaultQuickReplies);
        } else if (n2 == 4098) {
            ((SettingSubtitleItem)view).binding.titleText.setText((CharSequence)i18N.get("CustomizedMessages"));
        } else {
            QuickReply quickReply = (QuickReply)this.getItem(n);
            ((GroupTrackQuickReplyItem)view).setQuickReply(quickReply);
        }
    }
}

