/*
 * Decompiled with CFR 0.152.
 */
package com.brytonsport.active.ui.course.adapter.item;

import android.content.Context;
import android.view.LayoutInflater;
import android.view.View;
import android.widget.ImageView;
import com.brytonsport.active.base.App;
import com.brytonsport.active.databinding.ItemRouteBinding;
import com.brytonsport.active.utils.PlanTripUtil;
import com.brytonsport.active.utils.ProfileUtil;
import com.brytonsport.active.utils.ShapeUtils;
import com.brytonsport.active.utils.TimeUtils;
import com.brytonsport.active.utils.Utils;
import com.brytonsport.active.utils.i18N;
import com.brytonsport.active.vm.base.Route;
import com.brytonsport.active.vm.course.CourseMyRoutesViewModel;
import com.bumptech.glide.Glide;
import com.bumptech.glide.RequestBuilder;
import com.james.views.FreeLayout;
import java.io.File;
import java.text.DecimalFormat;
import java.text.NumberFormat;

public class RouteItem
extends FreeLayout {
    public ItemRouteBinding binding;
    private CourseMyRoutesViewModel courseMyRoutesViewModel;
    private Route route;

    public RouteItem(Context object, CourseMyRoutesViewModel courseMyRoutesViewModel) {
        super((Context)object);
        this.courseMyRoutesViewModel = courseMyRoutesViewModel;
        object = ItemRouteBinding.inflate(LayoutInflater.from((Context)object));
        this.binding = object;
        this.addFreeView((View)((ItemRouteBinding)object).getRoot(), -1, -2);
        ShapeUtils.getRoundedCorner((View)this.binding.baseLayout, 15);
        ShapeUtils.getRoundedCorner((View)this.binding.mapImage, 15);
        this.setSelectable(false);
    }

    public void changeKomootLockView(boolean bl) {
        if (bl) {
            this.binding.komootLockLayout.setVisibility(0);
            this.binding.normalDataLayout.setVisibility(8);
            this.binding.lockHintText.setText((CharSequence)i18N.get("M_KmUnlockRegion"));
        } else {
            this.binding.komootLockLayout.setVisibility(8);
            this.binding.normalDataLayout.setVisibility(0);
        }
    }

    public void setRoute(Route route) {
        StringBuilder stringBuilder;
        this.getContext();
        this.route = route;
        Object object = this.courseMyRoutesViewModel;
        if (object != null) {
            if (((CourseMyRoutesViewModel)object).isPlanTripPngExist(route.id)) {
                object = ProfileUtil.getInstance().getPrefString("userId");
                stringBuilder = new StringBuilder();
                stringBuilder.append((String)object);
                stringBuilder.append("/png");
                stringBuilder.append(File.separator);
                stringBuilder.append(route.id);
                stringBuilder.append(".png");
                object = stringBuilder.toString();
                stringBuilder = new StringBuilder();
                stringBuilder.append(App.getInstance().getFilesDir());
                stringBuilder.append(File.separator);
                stringBuilder.append((String)object);
                object = new File(stringBuilder.toString());
                ((RequestBuilder)Glide.with((Context)App.getInstance()).load((File)object)).into(this.binding.mapImage);
            } else {
                ((RequestBuilder)Glide.with((Context)App.getInstance()).load(2131165279)).into(this.binding.mapImage);
            }
        }
        if (route.isFitDecodeOk) {
            object = PlanTripUtil.readPlanTripTurnFromPref(route.id);
            this.binding.sourceIcon.setImageResource(route.getSourceIcon((Boolean)object));
        } else {
            this.binding.sourceIcon.setImageResource(2131165379);
        }
        this.binding.nameText.setText((CharSequence)route.name);
        this.binding.dateText.setText((CharSequence)TimeUtils.msToDate(route.time));
        stringBuilder = this.binding.distanceText;
        object = new StringBuilder();
        ((StringBuilder)object).append(Utils.convertKM(route.distance));
        ((StringBuilder)object).append(" ");
        ((StringBuilder)object).append(Utils.getUnitByKM());
        stringBuilder.setText(((StringBuilder)object).toString());
        object = new DecimalFormat("####.#");
        stringBuilder = this.binding.altitudeText;
        StringBuilder stringBuilder2 = new StringBuilder();
        stringBuilder2.append(((NumberFormat)object).format(Utils.convertM(route.altitude)));
        stringBuilder2.append(" ");
        stringBuilder2.append(Utils.getUnitByM());
        stringBuilder.setText(stringBuilder2.toString());
    }

    public void setSelectable(boolean bl) {
        ImageView imageView = this.binding.selectIcon;
        int n = bl ? 0 : 8;
        imageView.setVisibility(n);
    }

    public void setSelected(boolean bl) {
        super.setSelected(bl);
        ImageView imageView = this.binding.selectIcon;
        int n = bl ? 2131165574 : 2131165619;
        imageView.setImageResource(n);
    }
}

