/*
 * Decompiled with CFR 0.152.
 */
package com.brytonsport.active.ui.course.pager;

import android.app.Activity;
import android.app.AlertDialog;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.view.LayoutInflater;
import android.view.View;
import android.widget.RelativeLayout;
import androidx.recyclerview.widget.DefaultItemAnimator;
import com.brytonsport.active.base.BaseActivity;
import com.brytonsport.active.databinding.PagerTrainingPlanBinding;
import com.brytonsport.active.repo.course.WorkoutRepositoryHandler;
import com.brytonsport.active.ui.course.CourseWorkoutActivity;
import com.brytonsport.active.ui.course.CourseWorkoutPlanActivity;
import com.brytonsport.active.ui.course.adapter.TrainingPlanAdapter;
import com.brytonsport.active.ui.course.dialog.AddWorkoutDialog;
import com.brytonsport.active.ui.course.dialog.CopyWorkoutDialog;
import com.brytonsport.active.ui.course.pager.TrainingPlanPager$$ExternalSyntheticLambda0;
import com.brytonsport.active.ui.course.pager.TrainingPlanPager$1$$ExternalSyntheticLambda0;
import com.brytonsport.active.ui.course.pager.TrainingPlanPager$1$$ExternalSyntheticLambda1;
import com.brytonsport.active.ui.course.pager.TrainingPlanPager$1$$ExternalSyntheticLambda2;
import com.brytonsport.active.ui.course.pager.TrainingPlanPager$1$$ExternalSyntheticLambda3;
import com.brytonsport.active.ui.course.pager.TrainingPlanPager$1$3$$ExternalSyntheticLambda0;
import com.brytonsport.active.utils.i18N;
import com.brytonsport.active.views.dialog.ConfirmDialog;
import com.brytonsport.active.views.dialog.MonthSelectDialog;
import com.brytonsport.active.views.dialog.SelectPopupDialog;
import com.brytonsport.active.views.layoutmanager.AdvancedLinearLayoutManager;
import com.brytonsport.active.vm.base.TrainingPlan;
import com.brytonsport.active.vm.course.CourseWorkoutViewModel;
import com.james.easyclass.model.Res;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.Iterator;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class TrainingPlanPager
extends RelativeLayout {
    private Activity activity;
    private PagerTrainingPlanBinding binding;
    private Date currentDate;
    private int month;
    private TrainingPlanAdapter trainingPlanAdapter;
    private ArrayList<TrainingPlan> trainingPlans;
    private int year;

    public TrainingPlanPager(Context object, ArrayList<TrainingPlan> cloneable) {
        super((Context)object);
        this.activity = (Activity)object;
        this.trainingPlans = cloneable;
        cloneable = new Date();
        this.year = ((Date)cloneable).getYear() + 1900;
        this.month = ((Date)cloneable).getMonth() + 1;
        object = PagerTrainingPlanBinding.inflate(LayoutInflater.from((Context)object));
        this.binding = object;
        this.addView((View)((PagerTrainingPlanBinding)object).getRoot());
        this.setView();
    }

    static /* synthetic */ int access$002(TrainingPlanPager trainingPlanPager, int n) {
        trainingPlanPager.month = n;
        return n;
    }

    static /* synthetic */ int access$008(TrainingPlanPager trainingPlanPager) {
        int n = trainingPlanPager.month;
        trainingPlanPager.month = n + 1;
        return n;
    }

    static /* synthetic */ int access$010(TrainingPlanPager trainingPlanPager) {
        int n = trainingPlanPager.month;
        trainingPlanPager.month = n - 1;
        return n;
    }

    static /* synthetic */ Date access$102(TrainingPlanPager trainingPlanPager, Date date) {
        trainingPlanPager.currentDate = date;
        return date;
    }

    static /* synthetic */ int access$208(TrainingPlanPager trainingPlanPager) {
        int n = trainingPlanPager.year;
        trainingPlanPager.year = n + 1;
        return n;
    }

    static /* synthetic */ int access$210(TrainingPlanPager trainingPlanPager) {
        int n = trainingPlanPager.year;
        trainingPlanPager.year = n - 1;
        return n;
    }

    private Date getMonthDate() {
        return new Date(this.year - 1900, this.month - 1, 1);
    }

    private ArrayList<TrainingPlan> getTrainingPlans() {
        long l = new Date(this.year - 1900, this.month - 1, 1).getTime();
        long l2 = new Date(this.year - 1900, this.month, 1).getTime();
        ArrayList<TrainingPlan> arrayList = new ArrayList<TrainingPlan>();
        block0: for (TrainingPlan trainingPlan : this.trainingPlans) {
            Iterator<Date> iterator = trainingPlan.plans.iterator();
            while (iterator.hasNext()) {
                long l3 = iterator.next().getTime();
                if (l > l3 || l3 >= l2) continue;
                arrayList.add(trainingPlan);
                continue block0;
            }
        }
        return arrayList;
    }

    private ArrayList<TrainingPlan> getTrainingPlansByDate() {
        ArrayList<TrainingPlan> arrayList = new ArrayList<TrainingPlan>();
        for (TrainingPlan trainingPlan : this.trainingPlans) {
            for (Date date : trainingPlan.plans) {
                if (this.currentDate.getYear() != date.getYear() || this.currentDate.getMonth() != date.getMonth() || this.currentDate.getDate() != date.getDate()) continue;
                arrayList.add(trainingPlan);
            }
        }
        return arrayList;
    }

    private void setData() {
        ArrayList<TrainingPlan> arrayList = this.getTrainingPlans();
        if (this.currentDate == null) {
            if (!arrayList.isEmpty()) {
                for (Date object2 : arrayList.get((int)(arrayList.size() - 1)).plans) {
                    if (object2.getMonth() + 1 != this.month) continue;
                    this.currentDate = object2;
                    break;
                }
            } else {
                this.currentDate = new Date();
            }
        }
        ArrayList<TrainingPlan> arrayList2 = this.getTrainingPlansByDate();
        ArrayList<Integer> arrayList22 = new ArrayList<Integer>();
        arrayList22.add(4097);
        arrayList22.add(4098);
        if (!arrayList2.isEmpty()) {
            arrayList22.addAll(arrayList2);
        } else {
            arrayList22.add(4100);
        }
        TrainingPlanAdapter trainingPlanAdapter = this.trainingPlanAdapter;
        if (trainingPlanAdapter == null) {
            this.trainingPlanAdapter = new TrainingPlanAdapter(this.activity, (ArrayList<Object>)arrayList22);
        } else {
            trainingPlanAdapter.swapItems(arrayList22);
        }
        this.trainingPlanAdapter.setMonthPlan(this.currentDate, new Date(this.year - 1900, this.month - 1, 1), arrayList);
    }

    private void setView() {
        final BaseActivity baseActivity = (BaseActivity)this.getContext();
        this.setData();
        this.binding.trainingPlanList.setItemAnimator(new DefaultItemAnimator());
        this.binding.trainingPlanList.setLayoutManager(new AdvancedLinearLayoutManager(this.getContext()));
        this.binding.trainingPlanList.setAdapter(this.trainingPlanAdapter);
        this.trainingPlanAdapter.setOnActionClickListener(new TrainingPlanAdapter.OnActionClickListener(){

            public /* synthetic */ void lambda$onMonthClick$0$com-brytonsport-active-ui-course-pager-TrainingPlanPager$1(int n) {
                TrainingPlanPager.access$102(TrainingPlanPager.this, null);
                TrainingPlanPager.access$002(TrainingPlanPager.this, n);
                TrainingPlanPager.this.setData();
            }

            public /* synthetic */ void lambda$onMoreClick$1$com-brytonsport-active-ui-course-pager-TrainingPlanPager$1(TrainingPlan trainingPlan, final BaseActivity baseActivity2, ArrayList serializable) {
                SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyyMMdd");
                Iterator iterator = ((ArrayList)serializable).iterator();
                while (iterator.hasNext()) {
                    Date date;
                    block2: {
                        date = (Date)iterator.next();
                        String string2 = simpleDateFormat.format(date);
                        Boolean bl = false;
                        Iterator<Date> iterator2 = trainingPlan.plans.iterator();
                        do {
                            serializable = bl;
                            if (!iterator2.hasNext()) break block2;
                        } while (!simpleDateFormat.format(iterator2.next()).equals(string2));
                        serializable = Boolean.valueOf(true);
                    }
                    if (((Boolean)serializable).booleanValue()) continue;
                    trainingPlan.plans.add(date);
                }
                ((CourseWorkoutViewModel)((CourseWorkoutActivity)baseActivity2).viewModel).uploadWorkout(trainingPlan, new WorkoutRepositoryHandler(){

                    @Override
                    public void onComplete() {
                        baseActivity2.dismissProgressDialog();
                        TrainingPlanPager.this.setData();
                    }

                    @Override
                    public void onFail() {
                        baseActivity2.dismissProgressDialog();
                        AlertDialog.Builder builder = new AlertDialog.Builder((Context)baseActivity2);
                        builder.setTitle((CharSequence)Res.string.dialog_internet_title).setMessage((CharSequence)"__upload failed__").setCancelable(false).setPositiveButton((CharSequence)Res.string.dialog_confirm_button, new DialogInterface.OnClickListener(){

                            public void onClick(DialogInterface dialogInterface, int n) {
                            }
                        });
                        builder.create().show();
                    }
                });
                baseActivity2.showProgressDialog("");
            }

            public /* synthetic */ void lambda$onMoreClick$2$com-brytonsport-active-ui-course-pager-TrainingPlanPager$1(TrainingPlan trainingPlan, final BaseActivity baseActivity2, DialogInterface object, int n) {
                if (n == -1) {
                    SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyyMMdd");
                    String string2 = simpleDateFormat.format(TrainingPlanPager.this.currentDate);
                    n = 0;
                    while ((Integer)(object = Integer.valueOf(n)) < trainingPlan.plans.size()) {
                        if (simpleDateFormat.format(trainingPlan.plans.get((Integer)object)).equals(string2)) {
                            trainingPlan.plans.remove((Integer)object);
                            break;
                        }
                        n = (Integer)object + 1;
                    }
                    ((CourseWorkoutViewModel)((CourseWorkoutActivity)baseActivity2).viewModel).uploadWorkout(trainingPlan, new WorkoutRepositoryHandler(){

                        @Override
                        public void onComplete() {
                            baseActivity2.dismissProgressDialog();
                            TrainingPlanPager.this.setData();
                        }

                        @Override
                        public void onFail() {
                            baseActivity2.dismissProgressDialog();
                            AlertDialog.Builder builder = new AlertDialog.Builder((Context)baseActivity2);
                            builder.setTitle((CharSequence)Res.string.dialog_internet_title).setMessage((CharSequence)"__upload failed__").setCancelable(false).setPositiveButton((CharSequence)Res.string.dialog_confirm_button, new DialogInterface.OnClickListener(){

                                public void onClick(DialogInterface dialogInterface, int n) {
                                }
                            });
                            builder.create().show();
                        }
                    });
                    baseActivity2.showProgressDialog("");
                }
            }

            public /* synthetic */ void lambda$onMoreClick$3$com-brytonsport-active-ui-course-pager-TrainingPlanPager$1(BaseActivity baseActivity2, TrainingPlan trainingPlan, int n) {
                if (n == 0) {
                    new CopyWorkoutDialog(baseActivity2, TrainingPlanPager.this.getMonthDate()).setOnDatePickListener(new TrainingPlanPager$1$$ExternalSyntheticLambda1(this, trainingPlan, baseActivity2)).showPopup();
                } else {
                    ConfirmDialog.showSelf((Activity)baseActivity2, i18N.get("B_OK"), i18N.get("B_Cancel"), "", "Are you sure you want to delete the training plan?", (DialogInterface.OnClickListener)new TrainingPlanPager$1$$ExternalSyntheticLambda0(this, trainingPlan, baseActivity2));
                }
            }

            @Override
            public void onAddClick() {
                ArrayList<TrainingPlan> arrayList = ((CourseWorkoutViewModel)((CourseWorkoutActivity)baseActivity).viewModel).workouts;
                TrainingPlanPager.this.showAddWorkoutDialog(arrayList);
            }

            @Override
            public void onDayClick(Date date) {
                TrainingPlanPager.access$102(TrainingPlanPager.this, date);
                TrainingPlanPager.this.setData();
            }

            @Override
            public void onMonthClick() {
                new MonthSelectDialog((Context)baseActivity, TrainingPlanPager.this.month).setOnSaveClickListener(new TrainingPlanPager$1$$ExternalSyntheticLambda2(this)).showPopup();
            }

            @Override
            public void onMoreClick(TrainingPlan trainingPlan) {
                new SelectPopupDialog((Context)baseActivity).setOnMenuItemClickListener(new TrainingPlanPager$1$$ExternalSyntheticLambda3(this, baseActivity, trainingPlan)).showPopup(i18N.get("B_CopytoMultipleDates"), i18N.get("B_RemoveFromPlan"));
            }

            @Override
            public void onNextMonthClick() {
                TrainingPlanPager.access$102(TrainingPlanPager.this, null);
                TrainingPlanPager.access$008(TrainingPlanPager.this);
                if (TrainingPlanPager.this.month > 12) {
                    TrainingPlanPager.access$002(TrainingPlanPager.this, 1);
                    TrainingPlanPager.access$208(TrainingPlanPager.this);
                }
                TrainingPlanPager.this.setData();
            }

            @Override
            public void onPrevMonthClick() {
                TrainingPlanPager.access$102(TrainingPlanPager.this, null);
                TrainingPlanPager.access$010(TrainingPlanPager.this);
                if (TrainingPlanPager.this.month < 1) {
                    TrainingPlanPager.access$002(TrainingPlanPager.this, 12);
                    TrainingPlanPager.access$210(TrainingPlanPager.this);
                }
                TrainingPlanPager.this.setData();
            }

            @Override
            public void onWorkoutClick(int n, final TrainingPlan trainingPlan) {
                baseActivity.showProgressDialog("");
                ((CourseWorkoutViewModel)((CourseWorkoutActivity)baseActivity).viewModel).loadWorkoutDetail(trainingPlan, new WorkoutRepositoryHandler(){

                    static /* synthetic */ void lambda$onComplete$0(int n, int n2, Intent intent) {
                    }

                    @Override
                    public void onComplete() {
                        trainingPlan.loadWorkoutJSON();
                        baseActivity.dismissProgressDialog();
                        baseActivity.startActivityForResult(CourseWorkoutPlanActivity.createIntent((Context)baseActivity, trainingPlan, false), TrainingPlanPager$1$3$$ExternalSyntheticLambda0.INSTANCE);
                    }

                    @Override
                    public void onFail() {
                        baseActivity.dismissProgressDialog();
                    }
                });
            }
        });
    }

    private void showAddWorkoutDialog(ArrayList<TrainingPlan> arrayList) {
        new AddWorkoutDialog(this.activity).setOnItemClickListener(new TrainingPlanPager$$ExternalSyntheticLambda0(this, arrayList)).showPopup(arrayList);
    }

    public ArrayList<TrainingPlan> getRecentPlans() {
        Date object2 = new Date();
        Cloneable cloneable = Calendar.getInstance();
        ((Calendar)cloneable).setTime(object2);
        ((Calendar)cloneable).set(11, 0);
        ((Calendar)cloneable).set(12, 0);
        ((Calendar)cloneable).set(13, 0);
        ((Calendar)cloneable).set(14, 0);
        long l = ((Calendar)cloneable).getTime().getTime();
        ((Calendar)cloneable).add(5, 7);
        ((Calendar)cloneable).set(11, 23);
        ((Calendar)cloneable).set(12, 59);
        ((Calendar)cloneable).set(13, 59);
        ((Calendar)cloneable).set(14, 999);
        long l2 = ((Calendar)cloneable).getTime().getTime();
        cloneable = new ArrayList();
        block0: for (TrainingPlan trainingPlan : this.trainingPlans) {
            Iterator<Date> iterator = trainingPlan.plans.iterator();
            while (iterator.hasNext()) {
                long l3 = iterator.next().getTime();
                if (l3 < l || l3 >= l2) continue;
                ((ArrayList)cloneable).add(trainingPlan);
                continue block0;
            }
        }
        return cloneable;
    }

    public /* synthetic */ void lambda$showAddWorkoutDialog$0$com-brytonsport-active-ui-course-pager-TrainingPlanPager(ArrayList object, int n) {
        this.trainingPlanAdapter.removeItem(4100);
        object = (TrainingPlan)((ArrayList)object).get(n);
        if (((TrainingPlan)object).plans.contains(this.currentDate)) {
            return;
        }
        ((TrainingPlan)object).plans.add(this.currentDate);
        CourseWorkoutViewModel courseWorkoutViewModel = (CourseWorkoutViewModel)((CourseWorkoutActivity)this.activity).viewModel;
        ((CourseWorkoutActivity)this.activity).showProgressDialog("");
        courseWorkoutViewModel.uploadWorkout((TrainingPlan)object, new WorkoutRepositoryHandler((TrainingPlan)object){
            final /* synthetic */ TrainingPlan val$trainingPlan;
            {
                this.val$trainingPlan = trainingPlan;
            }

            @Override
            public void onComplete() {
                ((CourseWorkoutActivity)TrainingPlanPager.this.activity).dismissProgressDialog();
                if (!TrainingPlanPager.this.trainingPlans.contains(this.val$trainingPlan)) {
                    TrainingPlanPager.this.trainingPlans.add(this.val$trainingPlan);
                }
                TrainingPlanPager.this.trainingPlanAdapter.addItem(this.val$trainingPlan);
                TrainingPlanPager.this.trainingPlanAdapter.notifyItemChanged(0);
            }
        });
    }

    public void updateWorkoutList(ArrayList<TrainingPlan> arrayList) {
        this.trainingPlans = arrayList;
        this.setView();
    }
}

