/*
 * Decompiled with CFR 0.152.
 */
package com.brytonsport.active.ui.notification.adapter;

import android.app.Activity;
import android.content.Context;
import android.text.TextUtils;
import android.view.View;
import com.brytonsport.active.db.notification.entity.NotificationEntity;
import com.brytonsport.active.ui.notification.adapter.NotificationAdapter$$ExternalSyntheticLambda0;
import com.brytonsport.active.ui.notification.adapter.item.NotificationItem;
import com.brytonsport.active.utils.NotificationConstantsUtil;
import com.brytonsport.active.utils.TimeUtilByLee;
import com.brytonsport.active.utils.i18N;
import com.brytonsport.active.views.adapter.FreeRecyclerViewAdapter;
import java.util.ArrayList;
import java.util.Iterator;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class NotificationAdapter
extends FreeRecyclerViewAdapter<NotificationEntity> {
    private boolean isEdit = false;
    private OnNotificationItemClickListener onNotificationItemClickListener;

    public NotificationAdapter(Activity activity, ArrayList<NotificationEntity> arrayList) {
        super(activity, arrayList);
    }

    @Override
    public int getViewType(int n) {
        return 0;
    }

    @Override
    public View initView(int n) {
        return new NotificationItem((Context)this.activity);
    }

    public boolean isEdit() {
        return this.isEdit;
    }

    public /* synthetic */ void lambda$setView$0$com-brytonsport-active-ui-notification-adapter-NotificationAdapter(NotificationEntity notificationEntity, int n, View object) {
        if (this.isEdit) {
            notificationEntity.setSelected(notificationEntity.isSelected() ^ true);
            this.notifyItemChanged(n);
        } else {
            object = this.onNotificationItemClickListener;
            if (object != null) {
                object.onClick(n, notificationEntity);
            }
        }
    }

    public void selectAll() {
        Iterator iterator = this.getItems().iterator();
        while (iterator.hasNext()) {
            ((NotificationEntity)iterator.next()).setSelected(true);
        }
        this.notifyDataSetChanged();
    }

    public void setEdit(boolean bl) {
        this.isEdit = bl;
        this.notifyDataSetChanged();
    }

    public void setOnNotificationItemClickListener(OnNotificationItemClickListener onNotificationItemClickListener) {
        this.onNotificationItemClickListener = onNotificationItemClickListener;
    }

    @Override
    public void setView(final int n, int n2, View view) {
        NotificationItem notificationItem = (NotificationItem)view;
        final NotificationEntity notificationEntity = (NotificationEntity)this.getItem(n);
        if (this.isEdit) {
            if (notificationEntity.isSelected()) {
                notificationItem.binding.statusImage.setImageResource(2131165574);
            } else {
                notificationItem.binding.statusImage.setImageResource(2131165619);
            }
        } else {
            notificationItem.binding.statusImage.setImageResource(NotificationConstantsUtil.getStatusIcon(notificationEntity.getStatus()));
        }
        if (notificationEntity.getStatus() == NotificationConstantsUtil.CATEGORY_ANNOUNCEMENT) {
            notificationItem.binding.titleText.setText((CharSequence)i18N.get("T_ImportantAnnouncement"));
        } else if (notificationEntity.getStatus() == NotificationConstantsUtil.CATEGORY_NEW_APP_VERSION) {
            notificationItem.binding.titleText.setText((CharSequence)i18N.get("M_AppVersionUpdate"));
        } else {
            notificationItem.binding.titleText.setText((CharSequence)notificationEntity.getTitle());
        }
        if (notificationEntity.getStatus() == NotificationConstantsUtil.CATEGORY_ANNOUNCEMENT) {
            notificationItem.binding.contentText.setText((CharSequence)NotificationConstantsUtil.parserAnnouncementContent(notificationEntity.getContent()));
        } else {
            notificationItem.binding.contentText.setText((CharSequence)notificationEntity.getContent());
        }
        view = notificationItem.binding.contentText;
        n2 = TextUtils.isEmpty((CharSequence)notificationEntity.getContent()) ? 8 : 0;
        view.setVisibility(n2);
        notificationItem.binding.timeText.setText((CharSequence)TimeUtilByLee.getMillon(notificationEntity.getPushDate()));
        notificationItem.binding.getRoot().setOnClickListener((View.OnClickListener)new NotificationAdapter$$ExternalSyntheticLambda0(this, notificationEntity, n));
        notificationItem.binding.getRoot().setOnLongClickListener(new View.OnLongClickListener(){

            public boolean onLongClick(View view) {
                notificationEntity.setSelected(true);
                NotificationAdapter.this.notifyItemChanged(n);
                if (NotificationAdapter.this.onNotificationItemClickListener != null) {
                    NotificationAdapter.this.onNotificationItemClickListener.onLongClick(n, notificationEntity);
                }
                return false;
            }
        });
    }

    public void toggleSelect() {
        Iterator iterator = this.getItems().iterator();
        boolean bl = false;
        while (iterator.hasNext()) {
            if (!((NotificationEntity)iterator.next()).isSelected()) continue;
            bl = true;
        }
        if (bl) {
            this.unselectAll();
        } else {
            this.selectAll();
        }
    }

    public void unselectAll() {
        Iterator iterator = this.getItems().iterator();
        while (iterator.hasNext()) {
            ((NotificationEntity)iterator.next()).setSelected(false);
        }
        this.notifyDataSetChanged();
    }

    public void updateDataList(ArrayList<NotificationEntity> arrayList) {
        this.swapItems(arrayList);
    }

    public static interface OnNotificationItemClickListener {
        public void onClick(int var1, NotificationEntity var2);

        public void onLongClick(int var1, NotificationEntity var2);
    }
}

