/*
 * Decompiled with CFR 0.152.
 */
package com.brytonsport.active.ui.photo;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.PointF;
import android.view.MotionEvent;
import android.view.View;
import android.widget.ImageView;
import android.widget.RelativeLayout;
import com.james.views.FreeLayout;

public class CropView
extends FreeLayout {
    private static final String TAG = "CropView";
    private ImageView cropImage;
    private int height = 0;
    private int left = 0;
    private OnCropListener mOnCropListener;
    private ImageView photoImage;
    private Bitmap src;
    private int top = 0;
    private int width = 0;

    public CropView(Context context) {
        super(context);
        this.photoImage = (ImageView)this.addFreeView((View)new ImageView(context), -2, -2, new int[]{13});
        context = (ImageView)this.addFreeView((View)new ImageView(context), 240, 240);
        this.cropImage = context;
        context.setImageResource(2131165758);
        this.cropImage.setVisibility(4);
        this.setListener();
    }

    static /* synthetic */ int access$002(CropView cropView, int n) {
        cropView.left = n;
        return n;
    }

    static /* synthetic */ int access$102(CropView cropView, int n) {
        cropView.top = n;
        return n;
    }

    static /* synthetic */ int access$602(CropView cropView, int n) {
        cropView.width = n;
        return n;
    }

    static /* synthetic */ int access$702(CropView cropView, int n) {
        cropView.height = n;
        return n;
    }

    private void moveCropImage(int n, int n2) {
        RelativeLayout.LayoutParams layoutParams = (RelativeLayout.LayoutParams)this.cropImage.getLayoutParams();
        int n3 = n;
        if (n <= this.photoImage.getLeft()) {
            n3 = this.photoImage.getLeft();
        }
        int n4 = n3;
        if (n3 >= this.photoImage.getRight() - this.cropImage.getWidth()) {
            n4 = this.photoImage.getRight() - this.cropImage.getWidth();
        }
        n = n2;
        if (n2 <= this.photoImage.getTop()) {
            n = this.photoImage.getTop();
        }
        n2 = n;
        if (n >= this.photoImage.getBottom() - this.cropImage.getHeight()) {
            n2 = this.photoImage.getBottom() - this.cropImage.getHeight();
        }
        layoutParams.leftMargin = n4;
        layoutParams.topMargin = n2;
        this.cropImage.requestLayout();
    }

    private void resizeCropImage(int n, int n2) {
        RelativeLayout.LayoutParams layoutParams = (RelativeLayout.LayoutParams)this.cropImage.getLayoutParams();
        n2 = Math.min(Math.min(this.photoImage.getRight() - this.cropImage.getLeft(), n), Math.min(this.photoImage.getBottom() - this.cropImage.getTop(), n2));
        int n3 = layoutParams.width;
        layoutParams.width = n2;
        layoutParams.height = n2;
        n = layoutParams.leftMargin;
        n2 = (n3 - n2) / 2;
        layoutParams.leftMargin = n + n2;
        layoutParams.topMargin += n2;
        this.cropImage.requestLayout();
    }

    private void setListener() {
        this.cropImage.setOnTouchListener(new View.OnTouchListener(){
            boolean isMove;
            float offset_distance = 0.0f;
            int offset_x;
            int offset_y;
            float ori_distance = -1.0f;
            int ori_x;
            int ori_y;

            private void midPoint(PointF pointF, MotionEvent motionEvent) {
                float f = motionEvent.getX(0);
                float f2 = motionEvent.getX(1);
                float f3 = motionEvent.getY(0);
                float f4 = motionEvent.getY(1);
                pointF.set((f + f2) / 2.0f, (f3 + f4) / 2.0f);
            }

            private float spacing(MotionEvent motionEvent) {
                double d;
                try {
                    float f = motionEvent.getX(0) - motionEvent.getX(1);
                    float f2 = motionEvent.getY(0) - motionEvent.getY(1);
                    d = Math.sqrt(f * f + f2 * f2);
                }
                catch (Exception exception) {
                    return Float.MIN_VALUE;
                }
                return (float)d;
            }

            public boolean onTouch(View object, MotionEvent motionEvent) {
                if (motionEvent.getAction() == 0) {
                    this.ori_x = (int)motionEvent.getRawX();
                    this.ori_y = (int)motionEvent.getRawY();
                    this.offset_x = 0;
                    this.offset_y = 0;
                } else {
                    boolean bl = motionEvent.findPointerIndex(1) == -1;
                    this.isMove = bl;
                    if (bl) {
                        if (motionEvent.getAction() == 2) {
                            int n = (int)motionEvent.getRawX();
                            int n2 = (int)motionEvent.getRawY();
                            this.offset_x = n - this.ori_x;
                            this.offset_y = n2 - this.ori_y;
                            object = CropView.this;
                            ((CropView)((Object)object)).moveCropImage(((CropView)((Object)object)).left + this.offset_x, CropView.this.top + this.offset_y);
                        } else if (motionEvent.getAction() == 1) {
                            object = CropView.this;
                            CropView.access$002((CropView)((Object)object), ((CropView)((Object)object)).left + this.offset_x);
                            object = CropView.this;
                            CropView.access$102((CropView)((Object)object), ((CropView)((Object)object)).top + this.offset_y);
                            if (CropView.this.left <= CropView.this.photoImage.getLeft()) {
                                object = CropView.this;
                                CropView.access$002((CropView)((Object)object), ((CropView)((Object)object)).photoImage.getLeft());
                            }
                            if (CropView.this.left >= CropView.this.photoImage.getRight() - CropView.this.cropImage.getWidth()) {
                                object = CropView.this;
                                CropView.access$002((CropView)((Object)object), ((CropView)((Object)object)).photoImage.getRight() - CropView.this.cropImage.getWidth());
                            }
                            if (CropView.this.top <= CropView.this.photoImage.getTop()) {
                                object = CropView.this;
                                CropView.access$102((CropView)((Object)object), ((CropView)((Object)object)).photoImage.getTop());
                            }
                            if (CropView.this.top >= CropView.this.photoImage.getBottom() - CropView.this.cropImage.getHeight()) {
                                object = CropView.this;
                                CropView.access$102((CropView)((Object)object), ((CropView)((Object)object)).photoImage.getBottom() - CropView.this.cropImage.getHeight());
                            }
                            object = CropView.this;
                            ((CropView)((Object)object)).moveCropImage(((CropView)((Object)object)).left, CropView.this.top);
                            this.offset_x = 0;
                            this.offset_y = 0;
                            if (CropView.this.mOnCropListener != null) {
                                CropView.this.mOnCropListener.onCrop(CropView.this.getCroppedBitmap());
                            }
                        }
                    } else if (motionEvent.getAction() == 2) {
                        float f = this.spacing(motionEvent);
                        if (f != Float.MIN_VALUE) {
                            float f2 = this.ori_distance;
                            if (f2 == -1.0f) {
                                this.ori_distance = f;
                            } else {
                                this.offset_distance = f - f2;
                            }
                        }
                        object = CropView.this;
                        ((CropView)((Object)object)).resizeCropImage(((CropView)((Object)object)).width + (int)this.offset_distance, CropView.this.height + (int)this.offset_distance);
                    } else if (motionEvent.getAction() == 1) {
                        object = CropView.this;
                        CropView.access$602((CropView)((Object)object), ((CropView)((Object)object)).width + (int)this.offset_distance);
                        object = CropView.this;
                        CropView.access$702((CropView)((Object)object), ((CropView)((Object)object)).height + (int)this.offset_distance);
                        object = CropView.this;
                        CropView.access$602((CropView)((Object)object), Math.min(((CropView)((Object)object)).photoImage.getRight() - CropView.this.cropImage.getLeft(), CropView.this.width));
                        object = CropView.this;
                        CropView.access$702((CropView)((Object)object), Math.min(((CropView)((Object)object)).photoImage.getBottom() - CropView.this.cropImage.getTop(), CropView.this.height));
                        int n = Math.min(CropView.this.width, CropView.this.height);
                        CropView.this.resizeCropImage(n, n);
                        this.ori_distance = -1.0f;
                        this.offset_distance = 0.0f;
                        if (CropView.this.mOnCropListener != null) {
                            CropView.this.mOnCropListener.onCrop(CropView.this.getCroppedBitmap());
                        }
                    }
                }
                return true;
            }
        });
    }

    public Bitmap getCroppedBitmap() {
        int n = (this.left - this.photoImage.getLeft()) * this.src.getWidth() / this.photoImage.getWidth();
        int n2 = (this.top - this.photoImage.getTop()) * this.src.getHeight() / this.photoImage.getHeight();
        int n3 = this.cropImage.getWidth() * this.src.getWidth() / this.photoImage.getWidth();
        int n4 = this.cropImage.getHeight() * this.src.getHeight() / this.photoImage.getHeight();
        return Bitmap.createBitmap((Bitmap)this.src, (int)n, (int)n2, (int)n3, (int)n4);
    }

    public void setImageBitmap(Bitmap bitmap) {
        if (bitmap == null) {
            return;
        }
        this.src = bitmap;
        this.cropImage.setVisibility(4);
        int n = bitmap.getWidth() > bitmap.getHeight() ? bitmap.getWidth() : bitmap.getHeight();
        this.photoImage.setImageBitmap(bitmap);
        this.photoImage.setScaleType(ImageView.ScaleType.CENTER_CROP);
        if (n == bitmap.getWidth()) {
            this.setFreeView((View)this.photoImage, 640, bitmap.getHeight() * 640 / bitmap.getWidth(), new int[]{13});
        } else {
            this.setFreeView((View)this.photoImage, 1080, bitmap.getHeight() * 1080 / bitmap.getWidth(), new int[]{13});
        }
        this.postDelayed(new Runnable(){

            @Override
            public void run() {
                CropView cropView = CropView.this;
                CropView.access$002(cropView, cropView.photoImage.getLeft());
                cropView = CropView.this;
                CropView.access$102(cropView, cropView.photoImage.getTop());
                CropView.this.cropImage.setVisibility(0);
                int n = CropView.this.photoImage.getWidth() > CropView.this.photoImage.getHeight() ? CropView.this.photoImage.getHeight() : CropView.this.photoImage.getWidth();
                CropView.access$602(CropView.this, n);
                CropView.access$702(CropView.this, n);
                CropView.this.resizeCropImage(n, n);
                cropView = CropView.this;
                cropView.moveCropImage(cropView.left, CropView.this.top);
            }
        }, 500L);
    }

    public void setOnCropListener(OnCropListener onCropListener) {
        this.mOnCropListener = onCropListener;
    }

    public static interface OnCropListener {
        public void onCrop(Bitmap var1);
    }
}

