/*
 * Decompiled with CFR 0.152.
 */
package com.brytonsport.active.ui.photo;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Canvas;
import android.graphics.Matrix;
import android.graphics.Paint;
import android.graphics.PorterDuff;
import android.graphics.PorterDuffXfermode;
import android.graphics.Xfermode;
import android.text.TextUtils;
import android.util.Log;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class ImageHelper {
    public static final String FILE_PHOTO_CROP = "user_crop.jpg";
    public static final String FILE_PHOTO_HISTORY = "user_history.jpg";
    public static final String FILE_PHOTO_HISTORY_UPLOAD = "user_history_upload.jpeg";
    public static final String FILE_PHOTO_MEDICINE = "medicine.jpg";
    public static final String FILE_PHOTO_ORIGIN = "user_origin.jpg";
    private static final String TAG = "ImageHelper";
    private static ImageHelper instance;
    private Context context;
    private Bitmap profileBitmap = null;

    private ImageHelper(Context context) {
        this.context = context;
    }

    public static void clearCache(Context context) {
        if (ImageHelper.isPhotoFileExist(context)) {
            new File(ImageHelper.getPhotoFilePath(context)).delete();
        }
    }

    public static void copy(File object, File object2) throws IOException {
        int n;
        object = new FileInputStream((File)object);
        object2 = new FileOutputStream((File)object2);
        byte[] byArray = new byte[1024];
        while ((n = ((InputStream)object).read(byArray)) > 0) {
            ((OutputStream)object2).write(byArray, 0, n);
        }
        ((InputStream)object).close();
        ((OutputStream)object2).close();
    }

    public static void deleteBitmap(String string2) {
        new File(string2).deleteOnExit();
    }

    public static ImageHelper getInstance(Context context) {
        if (instance == null) {
            instance = new ImageHelper(context);
        }
        return instance;
    }

    public static String getMedicineFilePath(Context object) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(object.getCacheDir());
        stringBuilder.append("/");
        stringBuilder.append(object.getString(2131756206));
        object = new File(stringBuilder.toString());
        if (!((File)object).exists()) {
            ((File)object).mkdirs();
        }
        return new File((File)object, FILE_PHOTO_MEDICINE).getAbsolutePath();
    }

    public static Bitmap getOvalImage(Bitmap bitmap) {
        if (bitmap == null) {
            return null;
        }
        Bitmap bitmap2 = Bitmap.createBitmap((int)bitmap.getWidth(), (int)bitmap.getHeight(), (Bitmap.Config)Bitmap.Config.ARGB_8888);
        Canvas canvas = new Canvas(bitmap2);
        Paint paint = new Paint();
        float f = (float)Math.min(bitmap.getWidth(), bitmap.getHeight()) / 2.0f;
        paint.setAntiAlias(true);
        canvas.drawARGB(0, 0, 0, 0);
        paint.setColor(-12434878);
        canvas.drawCircle((float)bitmap.getWidth() / 2.0f, (float)bitmap.getHeight() / 2.0f, f, paint);
        paint.setXfermode((Xfermode)new PorterDuffXfermode(PorterDuff.Mode.SRC_IN));
        canvas.drawBitmap(bitmap, 0.0f, 0.0f, paint);
        return bitmap2;
    }

    public static String getPhotoDirPath(Context object) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(object.getCacheDir());
        stringBuilder.append("/");
        stringBuilder.append(object.getString(2131756206));
        object = new File(stringBuilder.toString());
        if (!((File)object).exists()) {
            ((File)object).mkdirs();
        }
        return ((File)object).getAbsolutePath();
    }

    public static String getPhotoFilePath(Context object) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(object.getCacheDir());
        stringBuilder.append("/");
        stringBuilder.append(object.getString(2131756206));
        object = new File(stringBuilder.toString());
        if (!((File)object).exists()) {
            ((File)object).mkdirs();
        }
        return new File((File)object, FILE_PHOTO_CROP).getAbsolutePath();
    }

    public static Bitmap getSquareImage(Bitmap bitmap, int n) {
        if (bitmap == null) {
            return null;
        }
        Bitmap bitmap2 = Bitmap.createBitmap((int)n, (int)n, (Bitmap.Config)Bitmap.Config.ARGB_8888);
        Canvas canvas = new Canvas(bitmap2);
        Paint paint = new Paint();
        int n2 = Math.min(bitmap.getWidth(), bitmap.getHeight());
        float f = n;
        float f2 = f / (float)n2;
        Matrix matrix = new Matrix();
        matrix.postTranslate(((float)bitmap.getWidth() * f2 - f) / 2.0f, ((float)bitmap.getHeight() * f2 - f) / 2.0f);
        matrix.postScale(f2, f2);
        paint.setAntiAlias(true);
        canvas.drawBitmap(bitmap, matrix, paint);
        return bitmap2;
    }

    public static boolean isPhotoFileExist(Context context) {
        return new File(ImageHelper.getPhotoFilePath(context)).exists();
    }

    public static Bitmap loadBitmap(String string2) {
        return ImageHelper.loadBitmap(string2, 1);
    }

    public static Bitmap loadBitmap(String charSequence, int n) {
        File file = new File((String)charSequence);
        CharSequence charSequence2 = TAG;
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("loadBitmapFromSD: ");
        stringBuilder.append((String)charSequence);
        Log.d((String)charSequence2, (String)stringBuilder.toString());
        boolean bl = file.exists();
        Object var6_8 = null;
        charSequence = null;
        stringBuilder = null;
        if (bl) {
            charSequence = stringBuilder;
            charSequence2 = var6_8;
            charSequence = stringBuilder;
            charSequence2 = var6_8;
            FileInputStream fileInputStream = new FileInputStream(file);
            charSequence = stringBuilder;
            charSequence2 = var6_8;
            charSequence = stringBuilder;
            charSequence2 = var6_8;
            file = new BitmapFactory.Options();
            charSequence = stringBuilder;
            charSequence2 = var6_8;
            ((BitmapFactory.Options)file).inPurgeable = true;
            charSequence = stringBuilder;
            charSequence2 = var6_8;
            ((BitmapFactory.Options)file).inSampleSize = n;
            charSequence = stringBuilder;
            charSequence2 = var6_8;
            stringBuilder = BitmapFactory.decodeStream((InputStream)fileInputStream, null, (BitmapFactory.Options)file);
            charSequence = stringBuilder;
            charSequence2 = stringBuilder;
            try {
                fileInputStream.close();
                charSequence = stringBuilder;
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
            catch (FileNotFoundException fileNotFoundException) {
                fileNotFoundException.printStackTrace();
                charSequence = charSequence2;
            }
        }
        return charSequence;
    }

    public static void renameBitmap(String string2, String object, String string3) {
        if (((File)(object = new File(string2, (String)object))).exists()) {
            ((File)object).renameTo(new File(string2, string3));
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void saveBitmap(String object, Bitmap object2, Bitmap.CompressFormat object3) {
        if (TextUtils.isEmpty((CharSequence)object)) return;
        Object object4 = TAG;
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("saveBitmap: path -> ");
        stringBuilder.append((String)object);
        Log.d((String)object4, (String)stringBuilder.toString());
        object = new File((String)object);
        if (((File)object).exists()) {
            ((File)object).delete();
        }
        try {
            object4 = new ByteArrayOutputStream();
            if (!object2.compress((Bitmap.CompressFormat)object3, 100, (OutputStream)object4)) return;
            object2 = new ByteArrayInputStream(((ByteArrayOutputStream)object4).toByteArray());
            object3 = new FileOutputStream((File)object);
            object = new byte[8192];
            while (true) {
                int n;
                if ((n = ((InputStream)object2).read((byte[])object, 0, 8192)) <= 0) {
                    ((FileOutputStream)object3).close();
                    ((InputStream)object2).close();
                    Log.d((String)TAG, (String)"photoFile copy OK");
                    return;
                }
                ((FileOutputStream)object3).write((byte[])object, 0, n);
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            return;
        }
        catch (FileNotFoundException fileNotFoundException) {
            fileNotFoundException.printStackTrace();
        }
    }

    public Bitmap getProfileBitmap(boolean bl) {
        Object object = ImageHelper.getPhotoFilePath(this.context);
        File file = new File((String)object);
        String string2 = TAG;
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("loadBitmapFromSD: ");
        stringBuilder.append((String)object);
        Log.d((String)string2, (String)stringBuilder.toString());
        if (file.exists()) {
            try {
                object = new FileInputStream(file);
                file = new BitmapFactory.Options();
                ((BitmapFactory.Options)file).inPurgeable = true;
                ((BitmapFactory.Options)file).inSampleSize = 1;
                file = BitmapFactory.decodeStream((InputStream)object, null, (BitmapFactory.Options)file);
                ((FileInputStream)object).close();
                this.profileBitmap = ImageHelper.getOvalImage((Bitmap)file);
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
            catch (FileNotFoundException fileNotFoundException) {
                fileNotFoundException.printStackTrace();
            }
        }
        return this.profileBitmap;
    }
}

