/*
 * Decompiled with CFR 0.152.
 */
package com.brytonsport.active.ui.photo;

import android.app.AlertDialog;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.database.Cursor;
import android.graphics.Bitmap;
import android.graphics.Matrix;
import android.media.ExifInterface;
import android.net.Uri;
import android.os.AsyncTask;
import android.os.Bundle;
import android.provider.MediaStore;
import android.text.TextUtils;
import android.view.View;
import android.widget.AbsListView;
import android.widget.AdapterView;
import android.widget.Button;
import android.widget.GridView;
import android.widget.ImageView;
import com.brytonsport.active.base.EasyBaseFragmentActivity;
import com.brytonsport.active.ui.photo.CropView;
import com.brytonsport.active.ui.photo.ImageHelper;
import com.brytonsport.active.ui.photo.PhotoActivity$$ExternalSyntheticLambda0;
import com.brytonsport.active.ui.photo.PhotoActivity$3$$ExternalSyntheticLambda0;
import com.brytonsport.active.ui.photo.PhotoAdapter;
import com.brytonsport.active.ui.photo.PhotoData;
import com.brytonsport.active.ui.photo.PhotoLayout;
import com.brytonsport.active.utils.ToastUtil;
import com.brytonsport.active.utils.Utils;
import com.james.easycamera.CameraView;
import com.james.easyclass.ImageManager;
import com.james.utils.LogUtils;
import com.james.views.FreeLayout;
import com.james.views.FreeTextButton;
import com.james.views.FreeTextView;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class PhotoActivity
extends EasyBaseFragmentActivity
implements View.OnClickListener {
    public static final int ACTION_ALBUM = 4097;
    public static final int ACTION_CAMERA = 4098;
    public static final String DATA_PATH_ARRAYLIST = "data_path_arraylist";
    public static final String EXTRAS_ACTION = "action";
    public static final String EXTRAS_CONTAINS_VIDEOS = "contains_videos";
    public static final String EXTRAS_NEED_CROP = "need_crop";
    public static final String EXTRAS_NEED_MULTI_CHOICE = "need_multi_choice";
    private ImageView backIcon;
    private FreeLayout cameraLayout;
    private CameraView cameraView;
    private FreeTextButton cancelButton;
    private FreeTextButton chooseButton;
    private FreeLayout cropLayout;
    private CropView cropView;
    private FreeLayout gridLayout;
    private GridView photoGrid;
    private PhotoLayout photoLayout;
    private FreeTextView saveText;
    private Button takePhotoButton;
    private FreeTextView titleText;
    private FreeLayout topLayout;

    public static Intent createIntent(Context context, int n) {
        return PhotoActivity.createIntent(context, n, true);
    }

    public static Intent createIntent(Context context, int n, boolean bl) {
        return PhotoActivity.createIntent(context, n, bl, false);
    }

    public static Intent createIntent(Context context, int n, boolean bl, boolean bl2) {
        return PhotoActivity.createIntent(context, n, bl, bl2, false);
    }

    public static Intent createIntent(Context context, int n, boolean bl, boolean bl2, boolean bl3) {
        return PhotoActivity.createIntent(context, n, bl, bl2, bl3, 30);
    }

    public static Intent createIntent(Context context, int n, boolean bl, boolean bl2, boolean bl3, int n2) {
        context = new Intent(context, PhotoActivity.class);
        context.putExtra(EXTRAS_ACTION, n);
        context.putExtra(EXTRAS_NEED_CROP, bl);
        context.putExtra(EXTRAS_NEED_MULTI_CHOICE, bl2);
        context.putExtra(EXTRAS_CONTAINS_VIDEOS, bl3);
        context.putExtra("maxPhotoCount", n2);
        return context;
    }

    private void findView() {
        this.topLayout = this.photoLayout.topLayout;
        this.titleText = this.photoLayout.titleText;
        this.backIcon = this.photoLayout.backIcon;
        this.saveText = this.photoLayout.saveText;
        this.gridLayout = this.photoLayout.gridLayout;
        this.photoGrid = this.photoLayout.photoGrid;
        this.cameraLayout = this.photoLayout.cameraLayout;
        this.cameraView = this.photoLayout.cameraView;
        this.takePhotoButton = this.photoLayout.takePhotoButton;
        this.cropLayout = this.photoLayout.cropLayout;
        this.cancelButton = this.photoLayout.cancelButton;
        this.chooseButton = this.photoLayout.chooseButton;
        this.cropView = this.photoLayout.cropView;
    }

    private int getAction() {
        return this.getIntent().getIntExtra(EXTRAS_ACTION, 4097);
    }

    private String getBucketId(String string2) {
        return String.valueOf(string2.toLowerCase().hashCode());
    }

    private int getMaxPhotoCount() {
        return this.getIntent().getIntExtra("maxPhotoCount", 30);
    }

    private int getPhotoCount() {
        PhotoAdapter photoAdapter = (PhotoAdapter)this.photoGrid.getAdapter();
        ArrayList<PhotoData> arrayList = new ArrayList<PhotoData>();
        for (int i = 0; i < photoAdapter.getCount(); ++i) {
            if (!((PhotoData)photoAdapter.getItem((int)i)).isChecked) continue;
            arrayList.add(new PhotoData(((PhotoData)photoAdapter.getItem((int)i)).date, ((PhotoData)photoAdapter.getItem((int)i)).path, ((PhotoData)photoAdapter.getItem((int)i)).videoPath, ((PhotoData)photoAdapter.getItem((int)i)).orientation));
        }
        return arrayList.size();
    }

    private void getPhotoCrop(Bitmap object, int n) {
        if (this.isNeedCrop()) {
            this.topLayout.setVisibility(8);
            this.gridLayout.setVisibility(8);
            this.cameraLayout.setVisibility(8);
            this.cropLayout.setVisibility(0);
            this.cropView.setImageBitmap((Bitmap)object);
        } else {
            int n2 = object.getWidth() > object.getHeight() ? object.getWidth() : object.getHeight();
            if (n2 > 1024) {
                float f = 1024.0f / (float)n2;
                ImageHelper.saveBitmap(ImageHelper.getPhotoFilePath((Context)this), ImageManager.resize((Bitmap)object, (float)f), Bitmap.CompressFormat.JPEG);
            } else {
                ImageHelper.saveBitmap(ImageHelper.getPhotoFilePath((Context)this), (Bitmap)object, Bitmap.CompressFormat.JPEG);
            }
            object = new ArrayList();
            ((ArrayList)object).add(new PhotoData(null, ImageHelper.getPhotoFilePath((Context)this), null, n));
            Intent intent = new Intent();
            intent.putParcelableArrayListExtra(DATA_PATH_ARRAYLIST, (ArrayList)object);
            this.setResult(-1, intent);
            super.finish();
            this.overridePendingTransition(2130771980, 2130771981);
        }
    }

    private boolean isContainsVideos() {
        return this.getIntent().getBooleanExtra(EXTRAS_CONTAINS_VIDEOS, false);
    }

    private boolean isMultiChoice() {
        return this.getIntent().getBooleanExtra(EXTRAS_NEED_MULTI_CHOICE, false);
    }

    private boolean isNeedCrop() {
        return this.getIntent().getBooleanExtra(EXTRAS_NEED_CROP, false);
    }

    private void loadAllPhotosAndVideos() {
        new AsyncTask<Void, Void, ArrayList<PhotoData>>(){

            protected ArrayList<PhotoData> doInBackground(Void ... object) {
                String string2;
                CharSequence charSequence;
                Object object2;
                int n;
                int n2;
                int n3;
                int n4;
                int n5;
                ArrayList<PhotoData> arrayList = new ArrayList<PhotoData>();
                object = MediaStore.Images.Media.EXTERNAL_CONTENT_URI;
                Object object3 = PhotoActivity.this.getContentResolver().query((Uri)object, new String[]{"_id", "bucket_display_name", "datetaken", "date_added", "_data", "orientation"}, null, null, null);
                object = new StringBuilder();
                ((StringBuilder)object).append("[loadAllPhotosAndVideos] photo query count=");
                ((StringBuilder)object).append(object3.getCount());
                LogUtils.i((String)"ActivityBase", (String)((StringBuilder)object).toString());
                if (object3.moveToFirst()) {
                    n5 = object3.getColumnIndex("bucket_display_name");
                    n4 = object3.getColumnIndex("datetaken");
                    n3 = object3.getColumnIndex("date_added");
                    n2 = object3.getColumnIndexOrThrow("_data");
                    n = object3.getColumnIndexOrThrow("orientation");
                    do {
                        object2 = object3.getString(n5);
                        object = object3.getString(n4);
                        charSequence = object3.getString(n3);
                        if (TextUtils.isEmpty((CharSequence)object)) {
                            object = charSequence;
                        }
                        string2 = object3.getString(n2);
                        int n6 = object3.getInt(n);
                        if (!TextUtils.isEmpty((CharSequence)string2) && (string2.toLowerCase().endsWith(".jpg") || string2.toLowerCase().endsWith(".jpeg") || string2.toLowerCase().endsWith(".png"))) {
                            arrayList.add(new PhotoData((String)object, string2, n6));
                        }
                        charSequence = new StringBuilder();
                        ((StringBuilder)charSequence).append("[loadAllPhotosAndVideos] photo path: ");
                        ((StringBuilder)charSequence).append(string2);
                        LogUtils.i((String)"ActivityBase", (String)((StringBuilder)charSequence).toString());
                        charSequence = new StringBuilder();
                        ((StringBuilder)charSequence).append("[loadAllPhotosAndVideos] photo bucket=");
                        ((StringBuilder)charSequence).append((String)object2);
                        ((StringBuilder)charSequence).append("  date_taken=");
                        ((StringBuilder)charSequence).append((String)object);
                        LogUtils.i((String)"ActivityBase", (String)((StringBuilder)charSequence).toString());
                    } while (object3.moveToNext());
                }
                if (PhotoActivity.this.isContainsVideos()) {
                    object = MediaStore.Video.Media.EXTERNAL_CONTENT_URI;
                    object3 = PhotoActivity.this.getContentResolver();
                    charSequence = "_id";
                    Cursor cursor = object3.query((Uri)object, new String[]{"_id", "bucket_display_name", "datetaken", "date_added", "_data"}, null, null, null);
                    object = new StringBuilder();
                    ((StringBuilder)object).append("[loadAllPhotosAndVideos] video query count=");
                    ((StringBuilder)object).append(cursor.getCount());
                    LogUtils.i((String)"ActivityBase", (String)((StringBuilder)object).toString());
                    if (cursor.moveToFirst()) {
                        n4 = cursor.getColumnIndex("bucket_display_name");
                        n3 = cursor.getColumnIndex("datetaken");
                        n2 = cursor.getColumnIndex("date_added");
                        n5 = cursor.getColumnIndexOrThrow("_data");
                        do {
                            String string3 = cursor.getString(n4);
                            object = cursor.getString(n3);
                            object3 = cursor.getString(n2);
                            if (!TextUtils.isEmpty((CharSequence)object)) {
                                object3 = object;
                            }
                            string2 = cursor.getString(n5);
                            n = cursor.getInt(cursor.getColumnIndexOrThrow((String)charSequence));
                            object = PhotoActivity.this.getContentResolver().query(MediaStore.Video.Thumbnails.EXTERNAL_CONTENT_URI, new String[]{"_data", "video_id"}, "video_id=?", new String[]{String.valueOf(n)}, null);
                            object = object.moveToFirst() ? object.getString(object.getColumnIndexOrThrow("_data")) : "";
                            if (!TextUtils.isEmpty((CharSequence)string2) && (string2.toLowerCase().endsWith(".mp4") || string2.toLowerCase().endsWith(".3gp") || string2.toLowerCase().endsWith(".mov") || string2.toLowerCase().endsWith(".mpg") || string2.toLowerCase().endsWith(".mpeg") || string2.toLowerCase().endsWith(".mkv"))) {
                                object2 = TextUtils.isEmpty((CharSequence)object) ? string2 : object;
                                arrayList.add(new PhotoData((String)object3, (String)object2, string2, 0));
                            }
                            object2 = new StringBuilder();
                            ((StringBuilder)object2).append("[loadAllPhotosAndVideos] video thumbPath: ");
                            ((StringBuilder)object2).append((String)object);
                            LogUtils.v((String)"ActivityBase", (String)((StringBuilder)object2).toString());
                            object = new StringBuilder();
                            ((StringBuilder)object).append("[loadAllPhotosAndVideos] video videoPath: ");
                            ((StringBuilder)object).append(string2);
                            LogUtils.i((String)"ActivityBase", (String)((StringBuilder)object).toString());
                            object = new StringBuilder();
                            ((StringBuilder)object).append("[loadAllPhotosAndVideos] video bucket=");
                            ((StringBuilder)object).append(string3);
                            ((StringBuilder)object).append("  date_taken=");
                            ((StringBuilder)object).append((String)object3);
                            LogUtils.i((String)"ActivityBase", (String)((StringBuilder)object).toString());
                        } while (cursor.moveToNext());
                    }
                }
                try {
                    object = new Comparator<PhotoData>(){

                        /*
                         * Enabled force condition propagation
                         * Lifted jumps to return sites
                         */
                        @Override
                        public int compare(PhotoData photoData, PhotoData photoData2) {
                            block4: {
                                try {
                                    long l = Long.parseLong(photoData.date);
                                    long l2 = Long.parseLong(photoData2.date);
                                    long l3 = l == l2 ? 0 : (l < l2 ? -1 : 1);
                                    if (l3 > 0) {
                                        return -1;
                                    }
                                    if (l3 >= 0) break block4;
                                    return 1;
                                }
                                catch (Exception exception) {
                                    return 0;
                                }
                            }
                            return 0;
                        }
                    };
                    Collections.sort(arrayList, object);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
                return arrayList;
            }

            protected void onPostExecute(ArrayList<PhotoData> object) {
                super.onPostExecute(object);
                object = new PhotoAdapter((Context)PhotoActivity.this, (ArrayList<PhotoData>)object);
                PhotoActivity.this.photoGrid.setAdapter(object);
            }
        }.execute((Object[])new Void[0]);
    }

    private void setLayout() {
        PhotoLayout photoLayout;
        this.photoLayout = photoLayout = new PhotoLayout((Context)this);
        this.setContentView((View)photoLayout);
    }

    private void setListener() {
        this.backIcon.setOnClickListener((View.OnClickListener)new PhotoActivity$$ExternalSyntheticLambda0(this));
        this.photoGrid.setOnScrollListener(new AbsListView.OnScrollListener(){

            public void onScroll(AbsListView absListView, int n, int n2, int n3) {
            }

            public void onScrollStateChanged(AbsListView object, int n) {
                object = (PhotoAdapter)PhotoActivity.this.photoGrid.getAdapter();
                if (n == 0) {
                    ((PhotoAdapter)((Object)object)).startLoading();
                } else {
                    ((PhotoAdapter)((Object)object)).stopLoading();
                }
            }
        });
        this.photoGrid.setOnItemClickListener(new AdapterView.OnItemClickListener(){

            static /* synthetic */ void lambda$onItemClick$0(DialogInterface dialogInterface, int n) {
            }

            public void onItemClick(AdapterView<?> object, View object2, int n, long l) {
                object2 = (PhotoAdapter)PhotoActivity.this.photoGrid.getAdapter();
                object = ((PhotoData)object2.getItem(n)).isVideo() ? ((PhotoData)object2.getItem((int)n)).videoPath : ((PhotoData)object2.getItem((int)n)).path;
                if (Utils.getFileSize(object) / 1024L / 1024L > 250L) {
                    ToastUtil.showToast((Context)PhotoActivity.this.activity, "this file size is over 250 MB");
                    return;
                }
                if (PhotoActivity.this.isMultiChoice()) {
                    if (!((PhotoData)object2.getItem((int)n)).isChecked && PhotoActivity.this.getPhotoCount() > PhotoActivity.this.getMaxPhotoCount()) {
                        new AlertDialog.Builder((Context)PhotoActivity.this.activity).setMessage((CharSequence)"A maximum of up to 30 photos can be uploaded").setPositiveButton((CharSequence)"OK", (DialogInterface.OnClickListener)PhotoActivity$3$$ExternalSyntheticLambda0.INSTANCE).create().show();
                    } else {
                        ((PhotoData)object2.getItem((int)n)).isChecked ^= true;
                        object2.notifyDataSetChanged();
                    }
                } else if (!PhotoActivity.this.isNeedCrop()) {
                    object = new ArrayList();
                    object.add((PhotoData)new PhotoData(((PhotoData)object2.getItem((int)n)).date, ((PhotoData)object2.getItem((int)n)).path, ((PhotoData)object2.getItem((int)n)).videoPath, ((PhotoData)object2.getItem((int)n)).orientation));
                    object2 = new Intent();
                    object2.putParcelableArrayListExtra(PhotoActivity.DATA_PATH_ARRAYLIST, (ArrayList)object);
                    PhotoActivity.this.setResult(-1, (Intent)object2);
                    PhotoActivity.super.finish();
                    PhotoActivity.this.overridePendingTransition(2130771980, 2130771981);
                } else {
                    int n2 = PhotoActivity.this.getPhotoDegree(((PhotoData)object2.getItem((int)n)).path);
                    if (n2 > 0) {
                        object = new Matrix();
                        object.postRotate((float)n2);
                        object = Bitmap.createBitmap((Bitmap)object2.getBitmap(n), (int)0, (int)0, (int)object2.getBitmap(n).getWidth(), (int)object2.getBitmap(n).getHeight(), (Matrix)object, (boolean)true);
                        PhotoActivity.this.getPhotoCrop((Bitmap)object, ((PhotoData)object2.getItem((int)n)).orientation);
                    } else {
                        PhotoActivity.this.getPhotoCrop(object2.getBitmap(n), ((PhotoData)object2.getItem((int)n)).orientation);
                    }
                }
            }
        });
        this.saveText.setOnClickListener((View.OnClickListener)this);
        this.takePhotoButton.setOnClickListener((View.OnClickListener)this);
        this.cancelButton.setOnClickListener((View.OnClickListener)this);
        this.chooseButton.setOnClickListener((View.OnClickListener)this);
    }

    private void setView() {
        this.saveText.setVisibility(8);
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                if (PhotoActivity.this.getAction() == 4097) {
                    PhotoActivity.this.saveText.setVisibility(0);
                    if (PhotoActivity.this.checkPermission("android.permission.READ_EXTERNAL_STORAGE")) {
                        LogUtils.v((String)"ActivityBase", (String)"PHOTO PERMISSION_READ_EXTERNAL_STORAGE");
                        PhotoActivity.this.showAlbum();
                        PhotoActivity.this.loadAllPhotosAndVideos();
                    } else {
                        PhotoActivity.this.finish();
                    }
                } else if (PhotoActivity.this.checkPermission("android.permission.CAMERA")) {
                    LogUtils.v((String)"ActivityBase", (String)"PHOTO PERMISSION_CAMERA");
                    PhotoActivity.this.showCamera();
                } else {
                    PhotoActivity.this.finish();
                }
            }
        };
        this.checkAndRequestPermission(new String[]{"android.permission.CAMERA", "android.permission.READ_EXTERNAL_STORAGE"}, 4097, runnable);
    }

    private void showAlbum() {
        this.gridLayout.setVisibility(0);
        this.cameraLayout.setVisibility(8);
    }

    private void showCamera() {
        this.gridLayout.setVisibility(8);
        this.cameraLayout.setVisibility(0);
    }

    @Override
    public void finish() {
        if (this.cropLayout.isShown()) {
            this.topLayout.setVisibility(0);
            if (this.getAction() == 4097) {
                this.cropLayout.setVisibility(8);
                this.gridLayout.setVisibility(0);
            } else if (this.getAction() == 4098) {
                this.cropLayout.setVisibility(8);
                this.cameraLayout.setVisibility(0);
            }
        } else {
            super.finish();
        }
    }

    public int getPhotoDegree(String string2) {
        int n = 0;
        try {
            ExifInterface exifInterface = new ExifInterface(string2);
            int n2 = exifInterface.getAttributeInt("Orientation", 0);
            if (n2 != 3) {
                if (n2 != 6) {
                    if (n2 == 8) {
                        n = 270;
                    }
                } else {
                    n = 90;
                }
            } else {
                n = 180;
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        return n;
    }

    public /* synthetic */ void lambda$setListener$0$com-brytonsport-active-ui-photo-PhotoActivity(View view) {
        this.finish();
        this.overridePendingTransition(2130771980, 2130771981);
    }

    public void onClick(View object) {
        boolean bl = object.equals(this.saveText);
        int n = -1;
        if (bl) {
            int n2;
            PhotoAdapter photoAdapter = (PhotoAdapter)this.photoGrid.getAdapter();
            object = new ArrayList();
            for (n2 = 0; n2 < photoAdapter.getCount(); ++n2) {
                if (!((PhotoData)photoAdapter.getItem((int)n2)).isChecked) continue;
                ((ArrayList)object).add(new PhotoData(((PhotoData)photoAdapter.getItem((int)n2)).date, ((PhotoData)photoAdapter.getItem((int)n2)).path, ((PhotoData)photoAdapter.getItem((int)n2)).videoPath, ((PhotoData)photoAdapter.getItem((int)n2)).orientation));
            }
            photoAdapter = new Intent();
            photoAdapter.putParcelableArrayListExtra(DATA_PATH_ARRAYLIST, (ArrayList)object);
            n2 = n;
            if (((ArrayList)object).isEmpty()) {
                n2 = 0;
            }
            this.setResult(n2, (Intent)photoAdapter);
            super.finish();
            this.overridePendingTransition(2130771980, 2130771981);
        } else if (object.equals(this.takePhotoButton)) {
            this.cameraView.setSampleSize(3);
            this.cameraView.takePicture(new CameraView.OnPictureTakenListener(){

                public void onPictureTaken(Bitmap bitmap) {
                    PhotoActivity.this.getPhotoCrop(bitmap, 0);
                }
            });
        } else if (object.equals(this.cancelButton)) {
            this.finish();
        } else if (object.equals(this.chooseButton)) {
            ImageHelper.saveBitmap(ImageHelper.getPhotoFilePath((Context)this), this.cropView.getCroppedBitmap(), Bitmap.CompressFormat.JPEG);
            object = new ArrayList();
            ((ArrayList)object).add(new PhotoData(null, ImageHelper.getPhotoFilePath((Context)this), null, 0));
            Intent intent = new Intent();
            intent.putParcelableArrayListExtra(DATA_PATH_ARRAYLIST, (ArrayList)object);
            this.setResult(-1, intent);
            super.finish();
            this.overridePendingTransition(2130771980, 2130771981);
        }
    }

    @Override
    protected void onCreate(Bundle bundle) {
        super.onCreate(bundle);
        this.setLayout();
        this.findView();
        this.setView();
        this.setListener();
    }
}

