/*
 * Decompiled with CFR 0.152.
 */
package com.brytonsport.active.ui.photo;

import android.content.Context;
import android.graphics.Bitmap;
import android.view.View;
import android.view.ViewGroup;
import android.widget.AbsListView;
import android.widget.ImageView;
import com.brytonsport.active.ui.photo.PhotoData;
import com.brytonsport.active.ui.photo.PhotoLoader;
import com.james.utils.LogUtils;
import com.james.views.FreeAdapter;
import com.james.views.FreeLayout;
import java.util.ArrayList;

public class PhotoAdapter
extends FreeAdapter<PhotoData, PhotoView> {
    private static final String TAG = "PhotoAdapter";
    private boolean isPause = false;
    private PhotoLoader photoLoader;

    public PhotoAdapter(Context context, ArrayList<PhotoData> arrayList) {
        super(context, arrayList);
        this.setPicSize(640);
        this.photoLoader = new PhotoLoader(context);
    }

    public Bitmap getBitmap(int n) {
        return this.photoLoader.loadBitmap(((PhotoData)this.getItem((int)n)).path, false);
    }

    public PhotoView initView(int n) {
        PhotoView photoView = new PhotoView(this.getContext());
        photoView.setLayoutParams((ViewGroup.LayoutParams)new AbsListView.LayoutParams(-2, -2));
        return photoView;
    }

    public void setView(int n, PhotoView photoView) {
        String string2 = TAG;
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("getItem(");
        stringBuilder.append(n);
        stringBuilder.append(") -> ");
        stringBuilder.append(this.getItem(n));
        LogUtils.v((String)string2, (String)stringBuilder.toString());
        this.photoLoader.displayImage(((PhotoData)this.getItem((int)n)).path, photoView.photoImage, true);
        photoView.photoImage.setRotation((float)((PhotoData)this.getItem((int)n)).orientation);
        stringBuilder = photoView.videoPlayImage;
        boolean bl = ((PhotoData)this.getItem(n)).isVideo();
        int n2 = 0;
        int n3 = bl ? 0 : 8;
        stringBuilder.setVisibility(n3);
        photoView = photoView.checkedIcon;
        n = ((PhotoData)this.getItem((int)n)).isChecked ? n2 : 8;
        photoView.setVisibility(n);
    }

    public void startLoading() {
        this.isPause = false;
        this.notifyDataSetChanged();
    }

    public void stopLoading() {
        this.isPause = true;
        this.notifyDataSetChanged();
    }

    public static class PhotoView
    extends FreeLayout {
        public ImageView checkedIcon;
        public ImageView photoImage;
        public ImageView videoPlayImage;

        public PhotoView(Context context) {
            super(context);
            this.setPicSize(640);
            FreeLayout freeLayout = (FreeLayout)this.addFreeView((View)new FreeLayout(context), 160, 160);
            freeLayout.setPicSize(640);
            this.setPadding((View)freeLayout, 2, 2, 2, 2);
            ImageView imageView = (ImageView)freeLayout.addFreeView((View)new ImageView(context), -1, -1);
            imageView.setScaleType(ImageView.ScaleType.CENTER_CROP);
            imageView.setBackgroundResource(2131165759);
            this.photoImage = imageView = (ImageView)freeLayout.addFreeView((View)new ImageView(context), -1, -1);
            imageView.setScaleType(ImageView.ScaleType.CENTER_CROP);
            this.videoPlayImage = imageView = (ImageView)freeLayout.addFreeView((View)new ImageView(context), -1, -1);
            imageView.setScaleType(ImageView.ScaleType.CENTER_CROP);
            this.videoPlayImage.setImageResource(2131165281);
            this.videoPlayImage.setVisibility(8);
            this.setPadding((View)this.videoPlayImage, 30, 30, 30, 30);
            context = (ImageView)freeLayout.addFreeView((View)new ImageView(context), 35, 35);
            this.checkedIcon = context;
            context.setImageResource(2131165317);
        }
    }
}

