/*
 * Decompiled with CFR 0.152.
 */
package com.brytonsport.active.ui.photo;

import android.app.Activity;
import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.PorterDuff;
import android.graphics.PorterDuffXfermode;
import android.graphics.Xfermode;
import android.media.ThumbnailUtils;
import android.text.TextUtils;
import android.util.Log;
import android.widget.ImageView;
import com.james.easyclass.imageloader.MemoryCache;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

public class PhotoLoader {
    private static final String TAG = "PhotoLoader";
    private ExecutorService executorService;
    private MemoryCache memoryCache = new MemoryCache();

    public PhotoLoader(Context context) {
        this.executorService = Executors.newFixedThreadPool(5);
    }

    public static Bitmap getOvalImage(Bitmap bitmap) {
        if (bitmap == null) {
            return null;
        }
        Bitmap bitmap2 = Bitmap.createBitmap((int)bitmap.getWidth(), (int)bitmap.getHeight(), (Bitmap.Config)Bitmap.Config.ARGB_8888);
        Canvas canvas = new Canvas(bitmap2);
        Paint paint = new Paint();
        float f = (float)Math.min(bitmap.getWidth(), bitmap.getHeight()) / 2.0f;
        paint.setAntiAlias(true);
        canvas.drawARGB(0, 0, 0, 0);
        paint.setColor(-12434878);
        canvas.drawCircle((float)bitmap.getWidth() / 2.0f, (float)bitmap.getHeight() / 2.0f, f, paint);
        paint.setXfermode((Xfermode)new PorterDuffXfermode(PorterDuff.Mode.SRC_IN));
        canvas.drawBitmap(bitmap, 0.0f, 0.0f, paint);
        return bitmap2;
    }

    private void queuePhoto(String object, ImageView imageView, boolean bl, boolean bl2) {
        imageView.setImageResource(2131165759);
        object = new PhotoToLoad((String)object, imageView);
        this.executorService.submit(new PhotosLoaderRunnable((PhotoToLoad)object, bl, bl2));
    }

    public void displayImage(String string2, ImageView imageView, boolean bl) {
        this.displayImage(string2, imageView, bl, false);
    }

    public void displayImage(String string2, ImageView imageView, boolean bl, boolean bl2) {
        if (TextUtils.isEmpty((CharSequence)string2)) {
            return;
        }
        imageView.setTag((Object)string2);
        Bitmap bitmap = this.memoryCache.get(string2);
        if (bitmap != null) {
            string2 = bitmap;
            if (bl2) {
                string2 = PhotoLoader.getOvalImage(bitmap);
            }
            imageView.setImageBitmap((Bitmap)string2);
        } else {
            this.queuePhoto(string2, imageView, bl, bl2);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Bitmap loadBitmap(String string2, boolean bl) {
        Object object = this.memoryCache.get(string2);
        if (object != null && bl) {
            return object;
        }
        if (!(string2.toLowerCase().endsWith(".jpg") || string2.toLowerCase().endsWith(".jpeg") || string2.toLowerCase().endsWith(".png"))) {
            object = ThumbnailUtils.createVideoThumbnail((String)string2, (int)1);
            this.memoryCache.put(string2, (Bitmap)object);
            return object;
        }
        File file = new File(string2);
        object = TAG;
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("[loadBitmap] from: ");
        stringBuilder.append(string2);
        Log.d((String)object, (String)stringBuilder.toString());
        if (!file.exists()) return null;
        try {
            object = new FileInputStream(file);
            file = new BitmapFactory.Options();
            ((BitmapFactory.Options)file).inPurgeable = true;
            if (bl) {
                ((BitmapFactory.Options)file).inSampleSize = 4;
            }
            file = BitmapFactory.decodeStream((InputStream)object, null, (BitmapFactory.Options)file);
            ((FileInputStream)object).close();
            this.memoryCache.put(string2, (Bitmap)file);
            return file;
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            return null;
        }
        catch (FileNotFoundException fileNotFoundException) {
            fileNotFoundException.printStackTrace();
        }
        return null;
    }

    public Bitmap loadBitmapFromCache(String string2) {
        return this.memoryCache.get(string2);
    }

    private class BitmapDisplayerRunnable
    implements Runnable {
        private Bitmap bitmap;
        private boolean isCircle;
        private String path;
        private PhotoToLoad photoToLoad;

        public BitmapDisplayerRunnable(String string2, Bitmap bitmap, PhotoToLoad photoToLoad, boolean bl) {
            this.path = string2;
            this.bitmap = bitmap;
            this.photoToLoad = photoToLoad;
            this.isCircle = bl;
        }

        @Override
        public void run() {
            if (!TextUtils.equals((CharSequence)this.photoToLoad.imageView.getTag().toString(), (CharSequence)this.path)) {
                return;
            }
            if (this.bitmap != null) {
                ImageView imageView = this.photoToLoad.imageView;
                Bitmap bitmap = this.isCircle ? PhotoLoader.getOvalImage(this.bitmap) : this.bitmap;
                imageView.setImageBitmap(bitmap);
            } else {
                this.photoToLoad.imageView.setImageResource(2131165759);
            }
        }
    }

    private class PhotoToLoad {
        public ImageView imageView;
        public String path;

        public PhotoToLoad(String string2, ImageView imageView) {
            this.path = string2;
            this.imageView = imageView;
        }
    }

    private class PhotosLoaderRunnable
    implements Runnable {
        private boolean isCircle;
        private boolean needSampled;
        private PhotoToLoad photoToLoad;

        public PhotosLoaderRunnable(PhotoToLoad photoToLoad, boolean bl, boolean bl2) {
            this.photoToLoad = photoToLoad;
            this.needSampled = bl;
            this.isCircle = bl2;
        }

        @Override
        public void run() {
            Object object = PhotoLoader.this.loadBitmap(this.photoToLoad.path, this.needSampled);
            object = new BitmapDisplayerRunnable(this.photoToLoad.path, (Bitmap)object, this.photoToLoad, this.isCircle);
            ((Activity)this.photoToLoad.imageView.getContext()).runOnUiThread((Runnable)object);
        }
    }
}

