/*
 * Decompiled with CFR 0.152.
 */
package com.brytonsport.active.ui.profile;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.text.TextUtils;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.View;
import android.widget.ImageView;
import androidx.lifecycle.Observer;
import androidx.lifecycle.ViewModelProvider;
import com.brytonsport.active.api.account.vo.AccountErrorVo;
import com.brytonsport.active.api.account.vo.AccountUserProfile;
import com.brytonsport.active.base.App;
import com.brytonsport.active.base.EasyBaseFragmentActivity;
import com.brytonsport.active.base.SyncBLEViewModel;
import com.brytonsport.active.databinding.ActivityProfileBinding;
import com.brytonsport.active.repo.setting.DeviceRepository;
import com.brytonsport.active.service.BleService;
import com.brytonsport.active.ui.account.LoginActivity;
import com.brytonsport.active.ui.profile.Hilt_ProfileActivity;
import com.brytonsport.active.ui.profile.Profile3rdPartyActivity;
import com.brytonsport.active.ui.profile.ProfileAboutMeActivity;
import com.brytonsport.active.ui.profile.ProfileActivity$$ExternalSyntheticLambda0;
import com.brytonsport.active.ui.profile.ProfileActivity$$ExternalSyntheticLambda1;
import com.brytonsport.active.ui.profile.ProfileActivity$$ExternalSyntheticLambda2;
import com.brytonsport.active.ui.profile.ProfileChangePasswordActivity;
import com.brytonsport.active.ui.profile.ProfileDeleteAccountActivity;
import com.brytonsport.active.ui.profile.ProfileZonesActivity;
import com.brytonsport.active.ui.profile.adapter.ProfileAdapter;
import com.brytonsport.active.ui.profile.adapter.item.ProfileMenuItem;
import com.brytonsport.active.utils.AppUnitUtil;
import com.brytonsport.active.utils.FeatureUtil;
import com.brytonsport.active.utils.NotificationConstantsUtil;
import com.brytonsport.active.utils.ProfileUtil;
import com.brytonsport.active.utils.ToastUtil;
import com.brytonsport.active.utils.i18N;
import com.brytonsport.active.views.dialog.PopupDialog;
import com.brytonsport.active.views.layoutmanager.AdvancedLinearLayoutManager;
import com.brytonsport.active.vm.base.Profile;
import com.brytonsport.active.vm.profile.ProfileViewModel;
import java.util.ArrayList;
import java.util.Objects;
import org.json.JSONException;
import org.json.JSONObject;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class ProfileActivity
extends Hilt_ProfileActivity<ActivityProfileBinding, ProfileViewModel> {
    static final String TAG = "ProfileActivity";
    private final BroadcastReceiver mGattUpdateReceiver = new BroadcastReceiver(){

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void onReceive(Context object, Intent object2) {
            object = object2.getAction();
            ((String)object).hashCode();
            int n = ((String)object).hashCode();
            int n2 = -1;
            switch (n) {
                default: {
                    break;
                }
                case 1893855566: {
                    if (!((String)object).equals("com.brytonsport.active.announcementPopup")) break;
                    n2 = 3;
                    break;
                }
                case -19691077: {
                    if (!((String)object).equals("com.brytonsport.active.SERVICE_DEVICE_CONNECT_OR_DISCONNECT")) break;
                    n2 = 2;
                    break;
                }
                case -468795244: {
                    if (!((String)object).equals("com.brytonsport.active.SERVICE_SETTING_COMMAND_RETURN")) break;
                    n2 = 1;
                    break;
                }
                case -1985402361: {
                    if (!((String)object).equals("com.brytonsport.active.newAppVersionHint")) break;
                    n2 = 0;
                }
            }
            switch (n2) {
                default: {
                    return;
                }
                case 3: {
                    object = object2.getStringExtra("com.brytonsport.active.announcementPopupMsg");
                    if (object == null) return;
                    if (((String)object).isEmpty()) return;
                    try {
                        JSONObject jSONObject = new JSONObject((String)object);
                        NotificationConstantsUtil.showAnnouncementPopup(ProfileActivity.this.activity, jSONObject);
                        return;
                    }
                    catch (JSONException jSONException) {
                        jSONException.printStackTrace();
                        return;
                    }
                }
                case 2: {
                    ProfileActivity.this.setView();
                    return;
                }
                case 1: {
                    String string2 = object2.getStringExtra("com.brytonsport.active.SERVICE_STRING_EXTRA_DATA");
                    try {
                        object = new JSONObject(string2);
                        if (!object.has("cmd")) return;
                        n2 = object.getInt("cmd");
                        if (n2 != 47) {
                            if (n2 != 71) return;
                            if (!object.has("ack")) return;
                            if (object.getInt("ack") != 10) return;
                            Log.d((String)TAG, (String)"\u544a\u8a34 app \u652f\u63f4\u7684 feature \u7d66\u6a5f\u5668\u6210\u529f: ");
                            ((ProfileViewModel)ProfileActivity.this.viewModel).startSyncSettings();
                            return;
                        }
                        if (object.has("devSptFeature") && object.getBoolean("devSptFeature")) {
                            Log.d((String)TAG, (String)"\u8868\u793a new app version is 2 \uff0c\u8981\u4e0b CMD 71 \u544a\u8a34\u6a5f\u5668 app \u652f\u63f4\u7684 feature: ");
                            return;
                        }
                        Log.d((String)TAG, (String)"\u8868\u793a new app version \u662f 1 \u9032\u884cUUID\u6aa2\u67e5: ");
                        ((ProfileViewModel)ProfileActivity.this.viewModel).startSyncSettings();
                        return;
                    }
                    catch (JSONException jSONException) {
                        jSONException.printStackTrace();
                        return;
                    }
                }
                case 0: 
            }
            boolean bl = object2.getBooleanExtra("com.brytonsport.active.newAppVersionHintType", false);
            NotificationConstantsUtil.showNewAppVersionHint(ProfileActivity.this.activity, bl);
        }
    };
    private int mIsSptSettingCmd = 0;
    private ImageView menuMoreIcon;
    private ProfileAdapter profileAdapter;

    private void closeLoading() {
        this.dismissProgressDialog();
    }

    public static Intent createIntent(Context context) {
        return new Intent(context, ProfileActivity.class);
    }

    private ArrayList<Integer> getType(int n) {
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        arrayList.add(4097);
        if (n > 0) {
            arrayList.add(4098);
        }
        arrayList.add(4099);
        arrayList.add(4100);
        if (this.mIsSptSettingCmd > 0) {
            arrayList.add(4101);
        }
        arrayList.add(4102);
        return arrayList;
    }

    private static IntentFilter makeGattUpdateIntentFilter() {
        IntentFilter intentFilter = new IntentFilter();
        intentFilter.addAction("com.brytonsport.active.SERVICE_DEVICE_CONNECT_OR_DISCONNECT");
        intentFilter.addAction("com.brytonsport.active.SERVICE_SETTING_COMMAND_RETURN");
        intentFilter.addAction("com.brytonsport.active.announcementPopup");
        intentFilter.addAction("com.brytonsport.active.newAppVersionHint");
        return intentFilter;
    }

    private void observeViewModel() {
        ((ProfileViewModel)this.viewModel).getAccountUserProfileLiveData().observe(this, new Observer<AccountUserProfile>(){

            @Override
            public void onChanged(AccountUserProfile accountUserProfile) {
                if (accountUserProfile != null) {
                    if (accountUserProfile.getNickName() != null && !accountUserProfile.getNickName().isEmpty()) {
                        ((ProfileViewModel)ProfileActivity.this.viewModel).profile.name = accountUserProfile.getNickName();
                    }
                    if (accountUserProfile.getAvatar() != null && !accountUserProfile.getAvatar().getImage().isEmpty()) {
                        ((ProfileViewModel)ProfileActivity.this.viewModel).profile.headshotBase64 = accountUserProfile.getAvatar().getImage();
                    }
                    ProfileActivity.this.profileAdapter.notifyItem(4097);
                }
            }
        });
        ((ProfileViewModel)this.viewModel).isLogoutSuccessLiveData().observe(this, new Observer<Boolean>(){

            @Override
            public void onChanged(Boolean bl) {
                if (bl.booleanValue()) {
                    ((ProfileViewModel)ProfileActivity.this.viewModel).AfterLogoutClearData();
                    ProfileUtil.getInstance().removeKey("device_name");
                    ProfileActivity.this.closeLoading();
                    bl = LoginActivity.createIntent((Context)ProfileActivity.this.activity).addCategory("android.intent.category.HOME");
                    bl.setFlags(0x10000000);
                    ProfileActivity.this.startActivity((Intent)bl);
                    App.profile = new Profile();
                    ProfileActivity.this.finish();
                } else {
                    ProfileActivity.this.closeLoading();
                }
            }
        });
        ((ProfileViewModel)this.viewModel).getLiveAccountErrorResponse().observe(this, new Observer<AccountErrorVo>(){

            @Override
            public void onChanged(AccountErrorVo accountErrorVo) {
                ProfileActivity.this.closeLoading();
                String string2 = accountErrorVo.getMessage();
                if (string2 != null && !string2.isEmpty()) {
                    if (accountErrorVo.getCode() == 401 && string2.equals("You must be logged in to do this.")) {
                        ProfileActivity.this.showTokenExpireDialog();
                    } else {
                        ToastUtil.showToast((Context)ProfileActivity.this, string2);
                    }
                }
            }
        });
    }

    private void openLoading() {
        this.showProgressDialog("");
    }

    private void setView() {
        if (!TextUtils.isEmpty((CharSequence)((String)ProfileUtil.getInstance().get("device_name"))) && BleService.mbDevExist.booleanValue()) {
            Object object = (String)ProfileUtil.getInstance().get("device_name");
            ((ProfileViewModel)this.viewModel).mStopWatchName.setValue(object);
            object = this.getType(1);
            this.profileAdapter.swapItems(object);
            this.profileAdapter.notifyDataSetChanged();
        } else {
            ArrayList<Integer> arrayList = this.getType(0);
            this.profileAdapter.swapItems(arrayList);
        }
        new Thread(new ProfileActivity$$ExternalSyntheticLambda2(this)).start();
    }

    @Override
    protected ActivityProfileBinding createViewBinding(LayoutInflater layoutInflater) {
        return ActivityProfileBinding.inflate(layoutInflater);
    }

    @Override
    protected ProfileViewModel createViewModel() {
        return new ViewModelProvider(this).get(ProfileViewModel.class);
    }

    @Override
    protected void initColor() {
        ((ActivityProfileBinding)this.binding).getRoot().setBackgroundResource(2131034148);
    }

    @Override
    protected void initFont() {
    }

    @Override
    protected void initText() {
        App.put("PROFILE", i18N.get("Profile"));
        App.put("Change Password", i18N.get("ChangePassword"));
        App.put("Log Out", i18N.get("F_Logout"));
        App.put("Profile Name", i18N.get("ProfileName"));
        App.put("Name My Device", i18N.get("DeviceName"));
        App.put("Metric (km,kg)", i18N.get("Metric"));
        App.put("Imperial (mi,lb)", i18N.get("Imperial"));
        App.put("My Device", i18N.get("MyDevices"));
        App.put("Units", i18N.get("Unit"));
        App.put("About Me", i18N.get("firmwareUpdate"));
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(i18N.get("HeartRateZone"));
        stringBuilder.append("&");
        stringBuilder.append(i18N.get("PowerZone"));
        App.put("HR & PW Zones", stringBuilder.toString());
        App.put("Connected 3rd Party", i18N.get("F_3rdLink"));
        this.setTitle(i18N.get("Profile"));
    }

    public /* synthetic */ void lambda$setListeners$1$com-brytonsport-active-ui-profile-ProfileActivity(int n) {
        if (n == 0) {
            this.startActivity(ProfileChangePasswordActivity.createIntent((Context)this.activity));
        } else if (n == 1) {
            this.startActivity(ProfileDeleteAccountActivity.createIntent((Context)this.activity));
        } else if (n == 2) {
            this.openLoading();
            ((ProfileViewModel)this.viewModel).AfterLogoutClearData();
            ProfileUtil.getInstance().removeKey("device_name");
            this.closeLoading();
            Intent intent = LoginActivity.createIntent((Context)this.activity).addCategory("android.intent.category.HOME");
            intent.setFlags(0x10000000);
            this.startActivity(intent);
            App.profile = new Profile();
            this.finish();
        }
    }

    public /* synthetic */ void lambda$setListeners$2$com-brytonsport-active-ui-profile-ProfileActivity(View view) {
        new PopupDialog((Context)this.activity).setOnMenuItemClickListener(new ProfileActivity$$ExternalSyntheticLambda1(this)).showPopup(i18N.get("ChangePassword"), i18N.get("B_DeleteAccount"), i18N.get("F_Logout"));
    }

    public /* synthetic */ void lambda$setView$0$com-brytonsport-active-ui-profile-ProfileActivity() {
        final int n = DeviceRepository.getInstance().deviceFeatureSupportSync(FeatureUtil.FeatureType.Setting);
        final int n2 = DeviceRepository.getInstance().deviceFeatureSupportSync(FeatureUtil.FeatureType.DeviceName);
        this.mIsSptSettingCmd = n;
        this.runOnUiThread(new Runnable(){

            @Override
            public void run() {
                if (n > 0) {
                    Object object = ProfileActivity.this.getType(n2);
                    ProfileActivity.this.profileAdapter.swapItems(object);
                    if (n2 > 0) {
                        ProfileViewModel profileViewModel = (ProfileViewModel)ProfileActivity.this.viewModel;
                        object = (ProfileViewModel)ProfileActivity.this.viewModel;
                        Objects.requireNonNull((ProfileViewModel)ProfileActivity.this.viewModel);
                        Objects.requireNonNull((ProfileViewModel)ProfileActivity.this.viewModel);
                        profileViewModel.addReq(((SyncBLEViewModel)object).getBaseCmdJsonArray(30, 0, 5));
                        if (((Boolean)ProfileUtil.getInstance().get("connect_ready_to_send_get_user_name")).booleanValue()) {
                            Log.d((String)TAG, (String)"\u958b\u59cb\u53d6\u5f97 userName CMD: ");
                            ((ProfileViewModel)ProfileActivity.this.viewModel).startSyncSettings();
                        }
                    }
                } else if (TextUtils.isEmpty((CharSequence)((String)ProfileUtil.getInstance().get("device_name")))) {
                    ArrayList arrayList = ProfileActivity.this.getType(0);
                    ProfileActivity.this.profileAdapter.swapItems(arrayList);
                }
            }
        });
    }

    @Override
    protected void onCreate() {
        super.onCreate();
        this.menuMoreIcon = this.addMenu(2131165504);
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        ((ActivityProfileBinding)this.binding).profileList.setLayoutManager(new AdvancedLinearLayoutManager((Context)this));
        this.profileAdapter = new ProfileAdapter(this, arrayList);
        ((ActivityProfileBinding)this.binding).profileList.setAdapter(this.profileAdapter);
        ((ProfileViewModel)this.viewModel).loadUserProfileFromDb();
        this.observeViewModel();
        this.registerReceiver(this.mGattUpdateReceiver, ProfileActivity.makeGattUpdateIntentFilter());
        this.setView();
        this.checkBlePermission();
    }

    @Override
    protected void onDestroy() {
        super.onDestroy();
        this.unregisterReceiver(this.mGattUpdateReceiver);
    }

    @Override
    protected void setListeners() {
        this.menuMoreIcon.setOnClickListener((View.OnClickListener)new ProfileActivity$$ExternalSyntheticLambda0(this));
        this.profileAdapter.setOnActionClickListener(new ProfileAdapter.OnActionClickListener(){

            @Override
            public void on3rdPartyClick() {
                ProfileActivity profileActivity = ProfileActivity.this;
                profileActivity.startActivity(Profile3rdPartyActivity.createIntent((Context)profileActivity.activity, "profile"));
            }

            @Override
            public void onAboutMeClick() {
                ProfileActivity profileActivity = ProfileActivity.this;
                profileActivity.startActivityForResult(ProfileAboutMeActivity.createIntent((Context)profileActivity.activity), new EasyBaseFragmentActivity.OnActivityResultCall(){

                    @Override
                    public void onActivityResult(int n, int n2, Intent intent) {
                        if (-1 == n2) {
                            ProfileActivity.this.profileAdapter.notifyDataSetChanged();
                        }
                    }
                });
            }

            @Override
            public void onHeadshotClick() {
            }

            @Override
            public void onMyDeviceClick() {
                ((ProfileViewModel)ProfileActivity.this.viewModel).profile.device = (String)((ProfileViewModel)ProfileActivity.this.viewModel).mStopWatchName.getValue();
            }

            @Override
            public void onNameEditClick() {
            }

            @Override
            public void onUnitsClick() {
                ProfileUtil.getInstance().set("app_unit_id", AppUnitUtil.getIdByUnitString((String)((ProfileViewModel)ProfileActivity.this.viewModel).mUnit.getValue()));
                ((ProfileViewModel)ProfileActivity.this.viewModel).profile.timeUnit.unit = (String)((ProfileViewModel)ProfileActivity.this.viewModel).mUnit.getValue();
            }

            @Override
            public void onZonesClick() {
                ProfileActivity profileActivity = ProfileActivity.this;
                profileActivity.startActivity(ProfileZonesActivity.createIntent((Context)profileActivity.activity));
            }
        });
        this.profileAdapter.setOnViewSetListener(new ProfileAdapter.OnViewSetListener(){

            @Override
            public void onViewSet(int n, View view, ProfileAdapter.OnActionClickListener onActionClickListener) {
                if (n == 4098) {
                    if (view instanceof ProfileMenuItem) {
                        ProfileActivity.this.bindStopWatchName((ProfileMenuItem)view, onActionClickListener);
                    }
                } else if (n == 4099 && view instanceof ProfileMenuItem) {
                    ProfileActivity.this.bindUnit((ProfileMenuItem)view, onActionClickListener);
                }
            }
        });
    }
}

