/*
 * Decompiled with CFR 0.152.
 */
package com.brytonsport.active.ui.profile;

import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.text.Editable;
import android.text.TextUtils;
import android.text.TextWatcher;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.View;
import android.widget.TextView;
import androidx.lifecycle.Observer;
import androidx.lifecycle.ViewModelProvider;
import com.brytonsport.active.api.account.vo.AccountErrorVo;
import com.brytonsport.active.base.App;
import com.brytonsport.active.databinding.ActivityProfileChangePasswordBinding;
import com.brytonsport.active.ui.account.LoginActivity;
import com.brytonsport.active.ui.profile.Hilt_ProfileChangePasswordActivity;
import com.brytonsport.active.ui.profile.ProfileChangePasswordActivity$$ExternalSyntheticLambda0;
import com.brytonsport.active.ui.profile.ProfileChangePasswordActivity$$ExternalSyntheticLambda1;
import com.brytonsport.active.ui.profile.ProfileChangePasswordActivity$$ExternalSyntheticLambda2;
import com.brytonsport.active.ui.profile.ProfileChangePasswordActivity$$ExternalSyntheticLambda3;
import com.brytonsport.active.utils.i18N;
import com.brytonsport.active.views.dialog.ConfirmDialog;
import com.brytonsport.active.vm.profile.ProfileChangePasswordViewModel;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class ProfileChangePasswordActivity
extends Hilt_ProfileChangePasswordActivity<ActivityProfileChangePasswordBinding, ProfileChangePasswordViewModel> {
    private TextView menuNextButton;
    private TextView menuSaveButton;

    private void changeViewToNext() {
        this.menuNextButton.setVisibility(8);
        this.menuSaveButton.setVisibility(0);
        ((ActivityProfileChangePasswordBinding)this.binding).currentPasswordItem.okIcon.setVisibility(0);
        ((ActivityProfileChangePasswordBinding)this.binding).newPasswordItem.setVisibility(0);
        ((ActivityProfileChangePasswordBinding)this.binding).confirmPasswordItem.setVisibility(0);
        ((ActivityProfileChangePasswordBinding)this.binding).passwordHint.setVisibility(0);
    }

    private void closeLoading() {
        this.dismissProgressDialog();
    }

    public static Intent createIntent(Context context) {
        return new Intent(context, ProfileChangePasswordActivity.class);
    }

    private void observeViewModel() {
        ((ProfileChangePasswordViewModel)this.viewModel).getLiveAccountErrorResponse().observe(this, new Observer<AccountErrorVo>(){

            @Override
            public void onChanged(AccountErrorVo accountErrorVo) {
                ProfileChangePasswordActivity.this.closeLoading();
                String string2 = accountErrorVo.getMessage();
                CharSequence charSequence = new StringBuilder();
                charSequence.append("errorMessage: ");
                charSequence.append(string2);
                Log.d((String)"amap", (String)charSequence.toString());
                if (string2 != null) {
                    if (string2.equals("Incorrect password")) {
                        charSequence = i18N.get("M_InvalidPassword");
                    } else {
                        charSequence = string2;
                        if (accountErrorVo.getCode() == 401) {
                            charSequence = string2;
                            if (string2.equals("You must be logged in to do this.")) {
                                ConfirmDialog.showSelfSingle(ProfileChangePasswordActivity.this.activity, i18N.get("M_TokenExpire"), new DialogInterface.OnClickListener(){

                                    public void onClick(DialogInterface dialogInterface, int n) {
                                        ((ProfileChangePasswordViewModel)ProfileChangePasswordActivity.this.viewModel).logout();
                                        dialogInterface = LoginActivity.createIntent((Context)ProfileChangePasswordActivity.this.activity);
                                        dialogInterface.addFlags(0x4000000);
                                        ProfileChangePasswordActivity.this.startActivity((Intent)dialogInterface);
                                    }
                                });
                                return;
                            }
                        }
                    }
                } else {
                    charSequence = i18N.get("LoginFailed");
                }
                ConfirmDialog.showSelfSingle(ProfileChangePasswordActivity.this.activity, (String)charSequence);
            }
        });
        ((ProfileChangePasswordViewModel)this.viewModel).isChangePwdSuccessLiveData().observe(this, new Observer<Boolean>(){

            @Override
            public void onChanged(Boolean bl) {
                if (bl.booleanValue()) {
                    ProfileChangePasswordActivity.this.closeLoading();
                    ConfirmDialog.showSelfSingle(ProfileChangePasswordActivity.this.activity, App.get("Your password has been successfully changed."), new DialogInterface.OnClickListener(){

                        public void onClick(DialogInterface dialogInterface, int n) {
                            ProfileChangePasswordActivity.this.finish();
                        }
                    });
                } else {
                    ProfileChangePasswordActivity.this.closeLoading();
                }
            }
        });
        ((ProfileChangePasswordViewModel)this.viewModel).isLoginSuccessLiveData().observe(this, new Observer<Boolean>(){

            @Override
            public void onChanged(Boolean bl) {
                ProfileChangePasswordActivity.this.closeLoading();
                if (bl.booleanValue()) {
                    ProfileChangePasswordActivity.this.changeViewToNext();
                }
            }
        });
    }

    private void openLoading() {
        this.showProgressDialog("");
    }

    @Override
    protected ActivityProfileChangePasswordBinding createViewBinding(LayoutInflater layoutInflater) {
        return ActivityProfileChangePasswordBinding.inflate(layoutInflater);
    }

    @Override
    protected ProfileChangePasswordViewModel createViewModel() {
        return new ViewModelProvider(this).get(ProfileChangePasswordViewModel.class);
    }

    @Override
    protected void initColor() {
    }

    @Override
    protected void initFont() {
    }

    @Override
    protected void initText() {
        App.put("Next", i18N.get("B_continue"));
        App.put("Save", i18N.get("B_Save"));
        App.put("Current", "Current");
        App.put("Enter Current Password", i18N.get("EnterCurrentPassword"));
        App.put("New", i18N.get("New"));
        App.put("Enter new password", i18N.get("EnterNewPassword"));
        App.put("Confirm", i18N.get("B_Confirm"));
        App.put("Confirm new password", i18N.get("ConfirmNewPassword"));
        App.put("Password does not match", i18N.get("M_PasswordNotMatch"));
        App.put("Your password has been successfully changed.", i18N.get("M_ChangePasswordSuccess"));
        App.put("Passwords are suggested to contain at least 8 characters.", i18N.get("M_pwdLength"));
        ((ActivityProfileChangePasswordBinding)this.binding).currentPasswordItem.titleText.setText((CharSequence)i18N.get("OldPassword"));
        ((ActivityProfileChangePasswordBinding)this.binding).currentPasswordItem.editText.setHint((CharSequence)App.get("Enter Current Password"));
        ((ActivityProfileChangePasswordBinding)this.binding).currentPasswordItem.editText.setInputType(129);
        ((ActivityProfileChangePasswordBinding)this.binding).newPasswordItem.titleText.setText((CharSequence)i18N.get("NewPassword"));
        ((ActivityProfileChangePasswordBinding)this.binding).newPasswordItem.editText.setHint((CharSequence)App.get("Enter new password"));
        ((ActivityProfileChangePasswordBinding)this.binding).newPasswordItem.editText.setInputType(129);
        ((ActivityProfileChangePasswordBinding)this.binding).confirmPasswordItem.titleText.setText((CharSequence)i18N.get("M_ConfirmPassword"));
        ((ActivityProfileChangePasswordBinding)this.binding).confirmPasswordItem.editText.setHint((CharSequence)App.get("Confirm new password"));
        ((ActivityProfileChangePasswordBinding)this.binding).confirmPasswordItem.editText.setInputType(129);
        ((ActivityProfileChangePasswordBinding)this.binding).passwordHint.setText((CharSequence)App.get("Passwords are suggested to contain at least 8 characters."));
        this.setTitle(i18N.get("ChangePassword"));
    }

    public /* synthetic */ void lambda$setListeners$0$com-brytonsport-active-ui-profile-ProfileChangePasswordActivity(View object) {
        object = ((ActivityProfileChangePasswordBinding)this.binding).currentPasswordItem.editText.getEditableText().toString();
        if (((String)object).isEmpty()) {
            ConfirmDialog.showSelfSingle(this.activity, i18N.get("M_EmptyPassword"));
            return;
        }
        this.openLoading();
        ((ProfileChangePasswordViewModel)this.viewModel).checkOldPassword((String)object);
    }

    public /* synthetic */ void lambda$setListeners$1$com-brytonsport-active-ui-profile-ProfileChangePasswordActivity(View object) {
        object = ((ActivityProfileChangePasswordBinding)this.binding).currentPasswordItem.editText.getEditableText().toString();
        String string2 = ((ActivityProfileChangePasswordBinding)this.binding).newPasswordItem.editText.getEditableText().toString();
        String string3 = ((ActivityProfileChangePasswordBinding)this.binding).confirmPasswordItem.editText.getEditableText().toString();
        if (!string2.isEmpty() && !string3.isEmpty()) {
            if (!TextUtils.equals((CharSequence)string2, (CharSequence)string3)) {
                ConfirmDialog.showSelfSingle(this.activity, i18N.get("M_PasswordNotMatch"));
                return;
            }
            this.openLoading();
            ((ProfileChangePasswordViewModel)this.viewModel).changePassword((String)object, string2);
            return;
        }
        ConfirmDialog.showSelfSingle(this.activity, i18N.get("M_EmptyPassword"));
    }

    public /* synthetic */ void lambda$setListeners$2$com-brytonsport-active-ui-profile-ProfileChangePasswordActivity(View view, boolean bl) {
        view = ((ActivityProfileChangePasswordBinding)this.binding).newPasswordItem.deleteIcon;
        int n = bl ? 0 : 8;
        view.setVisibility(n);
    }

    public /* synthetic */ void lambda$setListeners$3$com-brytonsport-active-ui-profile-ProfileChangePasswordActivity(View view, boolean bl) {
        view = ((ActivityProfileChangePasswordBinding)this.binding).confirmPasswordItem.deleteIcon;
        int n = bl ? 0 : 8;
        view.setVisibility(n);
    }

    @Override
    protected void onCreate() {
        TextView textView;
        super.onCreate();
        this.menuNextButton = textView = this.addMenu(i18N.get("B_continue"));
        textView.setTextColor(-12892323);
        this.menuSaveButton = textView = this.addMenu(i18N.get("B_Save"));
        textView.setTextColor(-12892323);
        this.menuSaveButton.setVisibility(8);
        ((ActivityProfileChangePasswordBinding)this.binding).progressView.setBackgroundColor(-6118750);
        this.observeViewModel();
    }

    @Override
    protected void setListeners() {
        this.menuNextButton.setOnClickListener((View.OnClickListener)new ProfileChangePasswordActivity$$ExternalSyntheticLambda0(this));
        this.menuSaveButton.setOnClickListener((View.OnClickListener)new ProfileChangePasswordActivity$$ExternalSyntheticLambda1(this));
        ((ActivityProfileChangePasswordBinding)this.binding).currentPasswordItem.editText.addTextChangedListener(new TextWatcher(){

            public void afterTextChanged(Editable editable) {
                TextView textView = ProfileChangePasswordActivity.this.menuNextButton;
                boolean bl = editable.toString().isEmpty();
                int n = -16723133;
                int n2 = bl ? -12892323 : -16723133;
                textView.setTextColor(n2);
                textView = ((ActivityProfileChangePasswordBinding)ProfileChangePasswordActivity.this.binding).progressView;
                n2 = n;
                if (editable.toString().isEmpty()) {
                    n2 = -6118750;
                }
                textView.setBackgroundColor(n2);
            }

            public void beforeTextChanged(CharSequence charSequence, int n, int n2, int n3) {
            }

            public void onTextChanged(CharSequence charSequence, int n, int n2, int n3) {
            }
        });
        TextWatcher textWatcher = new TextWatcher(){

            public void afterTextChanged(Editable object) {
                object = ((ActivityProfileChangePasswordBinding)ProfileChangePasswordActivity.this.binding).newPasswordItem.editText.getEditableText().toString();
                String string2 = ((ActivityProfileChangePasswordBinding)ProfileChangePasswordActivity.this.binding).confirmPasswordItem.editText.getEditableText().toString();
                TextView textView = ProfileChangePasswordActivity.this.menuSaveButton;
                int n = !((String)object).isEmpty() && !string2.isEmpty() ? -16723133 : -12892323;
                textView.setTextColor(n);
            }

            public void beforeTextChanged(CharSequence charSequence, int n, int n2, int n3) {
            }

            public void onTextChanged(CharSequence charSequence, int n, int n2, int n3) {
            }
        };
        ((ActivityProfileChangePasswordBinding)this.binding).newPasswordItem.editText.addTextChangedListener(textWatcher);
        ((ActivityProfileChangePasswordBinding)this.binding).confirmPasswordItem.editText.addTextChangedListener(textWatcher);
        ((ActivityProfileChangePasswordBinding)this.binding).newPasswordItem.editText.setOnFocusChangeListener((View.OnFocusChangeListener)new ProfileChangePasswordActivity$$ExternalSyntheticLambda2(this));
        ((ActivityProfileChangePasswordBinding)this.binding).confirmPasswordItem.editText.setOnFocusChangeListener((View.OnFocusChangeListener)new ProfileChangePasswordActivity$$ExternalSyntheticLambda3(this));
    }
}

