/*
 * Decompiled with CFR 0.152.
 */
package com.brytonsport.active.ui.profile;

import android.app.Activity;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.text.Editable;
import android.text.TextWatcher;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.View;
import android.widget.CompoundButton;
import androidx.lifecycle.Observer;
import androidx.lifecycle.ViewModelProvider;
import com.brytonsport.active.api.account.vo.AccountErrorVo;
import com.brytonsport.active.databinding.ActivityProfileDeleteAccountBinding;
import com.brytonsport.active.ui.account.WelcomeActivity;
import com.brytonsport.active.ui.profile.Hilt_ProfileDeleteAccountActivity;
import com.brytonsport.active.ui.profile.ProfileDeleteAccountActivity$$ExternalSyntheticLambda0;
import com.brytonsport.active.ui.profile.ProfileDeleteAccountActivity$$ExternalSyntheticLambda1;
import com.brytonsport.active.ui.profile.ProfileDeleteAccountActivity$3$$ExternalSyntheticLambda0;
import com.brytonsport.active.utils.ProfileUtil;
import com.brytonsport.active.utils.i18N;
import com.brytonsport.active.views.dialog.ConfirmDialog;
import com.brytonsport.active.vm.profile.ProfileDeleteAccountViewModel;
import org.json.JSONException;
import org.json.JSONObject;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class ProfileDeleteAccountActivity
extends Hilt_ProfileDeleteAccountActivity<ActivityProfileDeleteAccountBinding, ProfileDeleteAccountViewModel> {
    private boolean checkClickable() {
        if (!((ActivityProfileDeleteAccountBinding)this.binding).passwordEdit.getEditableText().toString().isEmpty() && ((ActivityProfileDeleteAccountBinding)this.binding).agreeToggleButton.isChecked()) {
            ((ActivityProfileDeleteAccountBinding)this.binding).deleteAccountButton.setTextColor(-1);
            ((ActivityProfileDeleteAccountBinding)this.binding).deleteAccountButton.setBackgroundResource(2131165838);
            ((ActivityProfileDeleteAccountBinding)this.binding).deleteAccountButton.setEnabled(true);
            return true;
        }
        ((ActivityProfileDeleteAccountBinding)this.binding).deleteAccountButton.setTextColor(-12892323);
        ((ActivityProfileDeleteAccountBinding)this.binding).deleteAccountButton.setBackgroundResource(2131165833);
        ((ActivityProfileDeleteAccountBinding)this.binding).deleteAccountButton.setEnabled(false);
        return false;
    }

    private void closeLoading() {
        this.dismissProgressDialog();
    }

    public static Intent createIntent(Context context) {
        return new Intent(context, ProfileDeleteAccountActivity.class);
    }

    private void observeViewModel() {
        ((ProfileDeleteAccountViewModel)this.viewModel).getLiveAccountErrorResponse().observe(this, new Observer<AccountErrorVo>(){

            @Override
            public void onChanged(AccountErrorVo accountErrorVo) {
                ProfileDeleteAccountActivity.this.closeLoading();
                if (accountErrorVo != null) {
                    String string2;
                    String string3 = accountErrorVo.getMessage();
                    if (string3 != null) {
                        if (string3.equals("User not found")) {
                            string2 = i18N.get("M_InvalidEmail");
                        } else {
                            if (string3.equals("Incorrect password")) {
                                i18N.get("M_InvalidPassword");
                                return;
                            }
                            string2 = string3;
                            if (accountErrorVo.getCode() == 401) {
                                string2 = string3;
                                if (string3.equals("You must be logged in to do this.")) {
                                    ProfileDeleteAccountActivity.this.showTokenExpireDialog();
                                    return;
                                }
                            }
                        }
                    } else {
                        string2 = i18N.get("LoginFailed");
                    }
                    ConfirmDialog.showSelfSingle(ProfileDeleteAccountActivity.this.activity, string2, i18N.get("B_OK"));
                }
            }
        });
        ((ProfileDeleteAccountViewModel)this.viewModel).isLoginSuccessLiveData().observe(this, new Observer<Boolean>(){

            static /* synthetic */ void lambda$onChanged$0(DialogInterface dialogInterface, int n) {
            }

            @Override
            public void onChanged(Boolean bl) {
                if (bl.booleanValue()) {
                    Log.d((String)"ActivityBase", (String)"\u767b\u5165\u6210\u529f\uff0c\u8868\u793a\u5bc6\u78bc\u6b63\u78ba\uff0c\u57f7\u884c\u522a\u9664\u5e33\u865f\u52d5\u4f5c: ");
                    ProfileDeleteAccountActivity.this.runDeleteAccountActon();
                } else {
                    ProfileDeleteAccountActivity.this.closeLoading();
                    ConfirmDialog.showSelf(ProfileDeleteAccountActivity.this.activity, i18N.get("B_Confirm"), "", i18N.get("Whoops"), i18N.get("M_PasswordIncorrectly"), (DialogInterface.OnClickListener)ProfileDeleteAccountActivity$3$$ExternalSyntheticLambda0.INSTANCE);
                }
            }
        });
        ((ProfileDeleteAccountViewModel)this.viewModel).isDeleteAccountResultLiveData().observe(this, new Observer<JSONObject>(){

            /*
             * WARNING - void declaration
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public void onChanged(JSONObject object) {
                ProfileDeleteAccountActivity.this.closeLoading();
                if (object.has("status")) {
                    try {
                        if (object.getString("status").equals("success")) {
                            ((ProfileDeleteAccountViewModel)ProfileDeleteAccountActivity.this.viewModel).AfterLogoutClearData();
                            ProfileUtil.getInstance().removeKey("device_name");
                            ProfileDeleteAccountActivity profileDeleteAccountActivity = ProfileDeleteAccountActivity.this;
                            profileDeleteAccountActivity.startActivity(WelcomeActivity.createIntent((Context)profileDeleteAccountActivity.activity));
                            ProfileDeleteAccountActivity.this.finish();
                            return;
                        }
                    }
                    catch (JSONException jSONException) {
                        jSONException.printStackTrace();
                    }
                }
                try {
                    void var1_4;
                    int n = object.has("code") ? object.getInt("code") : -1;
                    boolean bl = object.has("message");
                    CharSequence charSequence = "";
                    if (bl) {
                        String string2 = object.getString("message");
                    } else {
                        String string3 = "";
                    }
                    Activity activity = ProfileDeleteAccountActivity.this.activity;
                    if (n != -1) {
                        charSequence = new StringBuilder();
                        ((StringBuilder)charSequence).append("bryton server code: ");
                        ((StringBuilder)charSequence).append(n);
                        charSequence = ((StringBuilder)charSequence).toString();
                    }
                    ConfirmDialog.showSelf(activity, (String)charSequence, (String)var1_4);
                    return;
                }
                catch (JSONException jSONException) {
                    jSONException.printStackTrace();
                }
            }
        });
    }

    private void openLoading() {
        this.showProgressDialog("");
    }

    private void runDeleteAccountActon() {
        ((ProfileDeleteAccountViewModel)this.viewModel).deleteAccount();
    }

    @Override
    protected ActivityProfileDeleteAccountBinding createViewBinding(LayoutInflater layoutInflater) {
        return ActivityProfileDeleteAccountBinding.inflate(layoutInflater);
    }

    @Override
    protected ProfileDeleteAccountViewModel createViewModel() {
        return new ViewModelProvider(this).get(ProfileDeleteAccountViewModel.class);
    }

    @Override
    protected void initColor() {
    }

    @Override
    protected void initFont() {
    }

    @Override
    protected void initText() {
        this.setTitle(i18N.get("T_DeleteAccount"));
        ((ActivityProfileDeleteAccountBinding)this.binding).deleteAccountConfirmationText.setText((CharSequence)i18N.get("DeleteAccountConfirmation"));
        ((ActivityProfileDeleteAccountBinding)this.binding).deleteAccountNoteText.setText((CharSequence)i18N.get("DeleteAccountNote"));
        ((ActivityProfileDeleteAccountBinding)this.binding).deleteAccountDesc1.setText((CharSequence)i18N.get("DeleteAccountDesc1"));
        ((ActivityProfileDeleteAccountBinding)this.binding).deleteAccountDesc2.setText((CharSequence)i18N.get("DeleteAccountDesc2"));
        ((ActivityProfileDeleteAccountBinding)this.binding).deleteAccountReadSwitchDesc.setText((CharSequence)i18N.get("DeleteAccountReadSwitch"));
        ((ActivityProfileDeleteAccountBinding)this.binding).deleteAccountDesc3.setText((CharSequence)i18N.get("DeleteAccountDesc3"));
        ((ActivityProfileDeleteAccountBinding)this.binding).passwordEdit.setHint((CharSequence)i18N.get("DeleteAccountPlaceholder"));
        ((ActivityProfileDeleteAccountBinding)this.binding).deleteAccountButton.setText((CharSequence)i18N.get("B_DeleteAccount"));
        ((ActivityProfileDeleteAccountBinding)this.binding).contactText.setText((CharSequence)i18N.get("DeleteAccountContact"));
    }

    public /* synthetic */ void lambda$setListeners$0$com-brytonsport-active-ui-profile-ProfileDeleteAccountActivity(View object) {
        if (!this.checkClickable()) {
            return;
        }
        this.openLoading();
        object = ((ActivityProfileDeleteAccountBinding)this.binding).passwordEdit.getEditableText().toString();
        ((ProfileDeleteAccountViewModel)this.viewModel).checkPassword((String)object);
    }

    public /* synthetic */ void lambda$setListeners$1$com-brytonsport-active-ui-profile-ProfileDeleteAccountActivity(CompoundButton compoundButton, boolean bl) {
        this.checkClickable();
    }

    @Override
    protected void onCreate() {
        super.onCreate();
        this.observeViewModel();
    }

    @Override
    protected void setListeners() {
        ((ActivityProfileDeleteAccountBinding)this.binding).deleteAccountButton.setOnClickListener((View.OnClickListener)new ProfileDeleteAccountActivity$$ExternalSyntheticLambda0(this));
        ((ActivityProfileDeleteAccountBinding)this.binding).passwordEdit.addTextChangedListener(new TextWatcher(){

            public void afterTextChanged(Editable editable) {
                ProfileDeleteAccountActivity.this.checkClickable();
            }

            public void beforeTextChanged(CharSequence charSequence, int n, int n2, int n3) {
            }

            public void onTextChanged(CharSequence charSequence, int n, int n2, int n3) {
            }
        });
        ((ActivityProfileDeleteAccountBinding)this.binding).agreeToggleButton.setOnCheckedChangeListener(new ProfileDeleteAccountActivity$$ExternalSyntheticLambda1(this));
    }
}

