/*
 * Decompiled with CFR 0.152.
 */
package com.brytonsport.active.ui.profile;

import android.content.Context;
import android.content.Intent;
import android.os.Parcelable;
import android.util.Log;
import android.view.LayoutInflater;
import android.widget.CompoundButton;
import android.widget.TextView;
import androidx.lifecycle.Observer;
import androidx.lifecycle.ViewModelProvider;
import com.brytonsport.active.api.account.vo.AccountErrorVo;
import com.brytonsport.active.databinding.ActivityResultSyncInfoBinding;
import com.brytonsport.active.ui.profile.Hilt_ResultSyncInfoActivity;
import com.brytonsport.active.ui.profile.Profile3rdPartyLoginActivity;
import com.brytonsport.active.ui.profile.ResultSyncInfoActivity$$ExternalSyntheticLambda0;
import com.brytonsport.active.ui.profile.StravaLoginActivity;
import com.brytonsport.active.utils.ProfileUtil;
import com.brytonsport.active.utils.ToastUtil;
import com.brytonsport.active.utils.i18N;
import com.brytonsport.active.views.dialog.ConfirmDialog;
import com.brytonsport.active.vm.base.Sync;
import com.brytonsport.active.vm.profile.ResultSyncInfoViewModel;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class ResultSyncInfoActivity
extends Hilt_ResultSyncInfoActivity<ActivityResultSyncInfoBinding, ResultSyncInfoViewModel> {
    private final int RC_AUTH;

    public ResultSyncInfoActivity() {
        this.RC_AUTH = 10;
    }

    private void closeLoading() {
        this.dismissProgressDialog();
    }

    public static Intent createIntent(Context context, Sync sync) {
        return new Intent(context, ResultSyncInfoActivity.class).putExtra("resultSync", (Parcelable)sync);
    }

    private Sync getResultSyncFromBundle() {
        return (Sync)this.getIntent().getParcelableExtra("resultSync");
    }

    private void observeViewModel() {
        ((ResultSyncInfoViewModel)this.viewModel).isUnbindServiceSuccessLiveData().observe(this, new Observer<Boolean>(){

            @Override
            public void onChanged(Boolean bl) {
                if (bl.booleanValue()) {
                    ((ResultSyncInfoViewModel)ResultSyncInfoActivity.this.viewModel).getUserInfo();
                } else {
                    ResultSyncInfoActivity.this.closeLoading();
                }
            }
        });
        ((ResultSyncInfoViewModel)this.viewModel).isUserInfoSuccessLiveData().observe(this, new Observer<Boolean>(){

            @Override
            public void onChanged(Boolean bl) {
                ResultSyncInfoActivity.this.closeLoading();
                if (!bl.booleanValue()) {
                    ToastUtil.showToast((Context)ResultSyncInfoActivity.this, "get user info failed");
                }
            }
        });
        ((ResultSyncInfoViewModel)this.viewModel).isRideWithGpsUnBindSuccessLiveData().observe(this, new Observer<Boolean>(){

            @Override
            public void onChanged(Boolean bl) {
                ResultSyncInfoActivity.this.closeLoading();
                bl.booleanValue();
            }
        });
        ((ResultSyncInfoViewModel)this.viewModel).getUpdateService2ServerSuccessLiveData().observe(this, new Observer<Boolean>(){

            @Override
            public void onChanged(Boolean bl) {
                if (bl.booleanValue()) {
                    ((ResultSyncInfoViewModel)ResultSyncInfoActivity.this.viewModel).getUserInfo();
                } else {
                    ResultSyncInfoActivity.this.closeLoading();
                    ToastUtil.showToast((Context)ResultSyncInfoActivity.this, "update 3rd party service oauth token info to server failed");
                }
            }
        });
        ((ResultSyncInfoViewModel)this.viewModel).getLiveAccountErrorResponse().observe(this, new Observer<AccountErrorVo>(){

            @Override
            public void onChanged(AccountErrorVo accountErrorVo) {
                ResultSyncInfoActivity.this.closeLoading();
                if (accountErrorVo != null && accountErrorVo.getMessage() != null && !accountErrorVo.getMessage().isEmpty()) {
                    if (accountErrorVo.getCode() == 401 && accountErrorVo.getMessage().equals("You must be logged in to do this.")) {
                        ResultSyncInfoActivity.this.showTokenExpireDialog();
                    } else {
                        ConfirmDialog.showSelfSingle(ResultSyncInfoActivity.this.activity, accountErrorVo.getMessage(), i18N.get("B_OK"));
                    }
                }
            }
        });
    }

    private void openLoading() {
        this.showProgressDialog("");
    }

    private void openRideWithGpsLoginPage() {
        this.startActivityForResult(Profile3rdPartyLoginActivity.createIntent((Context)this.activity), new ResultSyncInfoActivity$$ExternalSyntheticLambda0(this));
    }

    private void setDescContent(Sync object) {
        String string2 = ((Sync)object).appName;
        String string3 = ((Sync)object).serviceKey;
        string3.hashCode();
        int n = string3.hashCode();
        int n2 = -1;
        switch (n) {
            default: {
                break;
            }
            case 1864948603: {
                if (!string3.equals("todaysplan")) break;
                n2 = 6;
                break;
            }
            case 5443894: {
                if (!string3.equals("routeyou")) break;
                n2 = 5;
                break;
            }
            case -552658214: {
                if (!string3.equals("trainingpeaks")) break;
                n2 = 4;
                break;
            }
            case -891993349: {
                if (!string3.equals("strava")) break;
                n2 = 3;
                break;
            }
            case -934646369: {
                if (!string3.equals("relive")) break;
                n2 = 2;
                break;
            }
            case -1125779861: {
                if (!string3.equals("komoot")) break;
                n2 = 1;
                break;
            }
            case -1679167869: {
                if (!string3.equals("selfloops")) break;
                n2 = 0;
            }
        }
        switch (n2) {
            default: {
                object = "";
                break;
            }
            case 4: {
                if (((Sync)object).isChecked) {
                    object = String.format(i18N.get("M_SelfloopsIntroP4"), string2);
                    break;
                }
                object = new StringBuilder();
                ((StringBuilder)object).append(i18N.get("M_TrainingPeaksIntroP1"));
                ((StringBuilder)object).append("\n");
                ((StringBuilder)object).append(i18N.get("M_TrainingPeaksIntroP2"));
                ((StringBuilder)object).append("\n");
                ((StringBuilder)object).append(i18N.get("M_TrainingPeaksNote"));
                object = ((StringBuilder)object).toString();
                break;
            }
            case 3: {
                if (((Sync)object).isChecked) {
                    object = String.format(i18N.get("M_SelfloopsIntroP4"), string2);
                    break;
                }
                object = new StringBuilder();
                ((StringBuilder)object).append(i18N.get("M_StravaIntroP1"));
                ((StringBuilder)object).append("\n");
                ((StringBuilder)object).append(i18N.get("M_StravaIntroP2"));
                ((StringBuilder)object).append("\n");
                ((StringBuilder)object).append(i18N.get("M_StravaNote"));
                object = ((StringBuilder)object).toString();
                break;
            }
            case 0: 
            case 1: 
            case 2: 
            case 5: 
            case 6: {
                if (((Sync)object).isChecked) {
                    object = String.format(i18N.get("M_SelfloopsIntroP4"), string2);
                    break;
                }
                object = new StringBuilder();
                ((StringBuilder)object).append(String.format(i18N.get("M_SelfloopsIntroP1"), string2));
                ((StringBuilder)object).append("\n");
                ((StringBuilder)object).append(String.format(i18N.get("M_SelfloopsIntroP2"), string2, string2));
                ((StringBuilder)object).append("\n");
                ((StringBuilder)object).append(String.format(i18N.get("M_SelfloopsNote"), string2, string2));
                object = ((StringBuilder)object).toString();
            }
        }
        ((ActivityResultSyncInfoBinding)this.binding).contentText.setText((CharSequence)object);
    }

    @Override
    protected ActivityResultSyncInfoBinding createViewBinding(LayoutInflater layoutInflater) {
        return ActivityResultSyncInfoBinding.inflate(layoutInflater);
    }

    @Override
    protected ResultSyncInfoViewModel createViewModel() {
        return new ViewModelProvider(this).get(ResultSyncInfoViewModel.class);
    }

    public void getAuthCode() {
        String string2 = this.getResultSyncFromBundle().serviceKey;
        string2.hashCode();
        int n = string2.hashCode();
        int n2 = -1;
        switch (n) {
            default: {
                break;
            }
            case 1864948603: {
                if (!string2.equals("todaysplan")) break;
                n2 = 7;
                break;
            }
            case 5443894: {
                if (!string2.equals("routeyou")) break;
                n2 = 6;
                break;
            }
            case -552658214: {
                if (!string2.equals("trainingpeaks")) break;
                n2 = 5;
                break;
            }
            case -891993349: {
                if (!string2.equals("strava")) break;
                n2 = 4;
                break;
            }
            case -934646369: {
                if (!string2.equals("relive")) break;
                n2 = 3;
                break;
            }
            case -1125779861: {
                if (!string2.equals("komoot")) break;
                n2 = 2;
                break;
            }
            case -1219562964: {
                if (!string2.equals("ridewithgps")) break;
                n2 = 1;
                break;
            }
            case -1679167869: {
                if (!string2.equals("selfloops")) break;
                n2 = 0;
            }
        }
        switch (n2) {
            default: {
                break;
            }
            case 7: {
                this.getTodaysplanAuthCode();
                break;
            }
            case 6: {
                this.getRouteyouAuthCode();
                break;
            }
            case 5: {
                this.getTrainingPeaksAuthCode();
                break;
            }
            case 4: {
                this.getStravaAuthCode();
                break;
            }
            case 3: {
                this.getReliveAuthCode();
                break;
            }
            case 2: {
                this.getKomootAuthCode();
                break;
            }
            case 1: {
                this.openRideWithGpsLoginPage();
                break;
            }
            case 0: {
                this.getSelfloopsAuthCode();
            }
        }
    }

    public void getKomootAuthCode() {
        String string2 = ((ResultSyncInfoViewModel)this.viewModel).redirectUrl;
        this.openLoginWebView(((ResultSyncInfoViewModel)this.viewModel).getKomootAuthCodeUrl(), string2);
    }

    public void getReliveAuthCode() {
        String string2 = ((ResultSyncInfoViewModel)this.viewModel).reliveRedirectUrl;
        this.openLoginWebView(((ResultSyncInfoViewModel)this.viewModel).getReliveAuthCodeUrl(), string2);
    }

    public void getRouteyouAuthCode() {
        String string2 = ((ResultSyncInfoViewModel)this.viewModel).routeyouRedirectUri;
        this.openLoginWebView(((ResultSyncInfoViewModel)this.viewModel).getRouteyouAuthCodeUrl(), string2);
    }

    public void getSelfloopsAuthCode() {
        String string2 = ((ResultSyncInfoViewModel)this.viewModel).redirectUrl;
        this.openLoginWebView(((ResultSyncInfoViewModel)this.viewModel).getSelfloopsAuthCodeUrl(), string2);
    }

    public void getStravaAuthCode() {
        String string2 = ((ResultSyncInfoViewModel)this.viewModel).redirectUrl;
        this.openLoginWebView(((ResultSyncInfoViewModel)this.viewModel).getStravaAuthCodeUrl(), string2);
    }

    public void getTodaysplanAuthCode() {
        String string2 = ((ResultSyncInfoViewModel)this.viewModel).redirectUrl;
        this.openLoginWebView(((ResultSyncInfoViewModel)this.viewModel).getTodaysplanAuthCodeUrl(), string2);
    }

    public void getTrainingPeaksAuthCode() {
        String string2 = ((ResultSyncInfoViewModel)this.viewModel).redirectUrl;
        this.openLoginWebView(((ResultSyncInfoViewModel)this.viewModel).getTrainingPeaksAuthCodeUrl(), string2);
    }

    @Override
    protected void initColor() {
        ((ActivityResultSyncInfoBinding)this.binding).getRoot().setBackgroundResource(2131034148);
    }

    @Override
    protected void initFont() {
    }

    @Override
    protected void initText() {
        this.setTitle(this.getResultSyncFromBundle().appName);
        TextView textView = ((ActivityResultSyncInfoBinding)this.binding).syncSwitchTitle;
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.getResultSyncFromBundle().appName);
        stringBuilder.append(" ");
        stringBuilder.append(i18N.get("AutoSync"));
        textView.setText((CharSequence)stringBuilder.toString());
        this.setDescContent(this.getResultSyncFromBundle());
    }

    public /* synthetic */ void lambda$openRideWithGpsLoginPage$0$com-brytonsport-active-ui-profile-ResultSyncInfoActivity(int n, int n2, Intent intent) {
        this.closeLoading();
        if (n2 == -1) {
            if (((String)ProfileUtil.getInstance().get("rideWithGpsUserId")).isEmpty()) {
                ((ActivityResultSyncInfoBinding)this.binding).syncToggleButton.setChecked(false);
            } else {
                ((ActivityResultSyncInfoBinding)this.binding).syncToggleButton.setChecked(true);
            }
        } else {
            ((ActivityResultSyncInfoBinding)this.binding).syncToggleButton.setChecked(false);
        }
    }

    @Override
    public void onActivityResult(int n, int n2, Intent object) {
        super.onActivityResult(n, n2, (Intent)object);
        if (n == 10 && object != null) {
            object = object.getStringExtra("StravaLoginActivity.RESULT_CODE");
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("onActivityResult: userCode = ");
            stringBuilder.append((String)object);
            Log.d((String)"ActivityBase", (String)stringBuilder.toString());
            if (!((String)object).isEmpty()) {
                this.openLoading();
                ((ResultSyncInfoViewModel)this.viewModel).getTokenByCode(this.getResultSyncFromBundle().serviceKey, (String)object);
            }
        } else {
            this.closeLoading();
            if (!this.getResultSyncFromBundle().appName.equals("Ride with GPS")) {
                ((ActivityResultSyncInfoBinding)this.binding).syncToggleButton.setChecked(false);
            }
        }
    }

    @Override
    protected void onCreate() {
        super.onCreate();
        ((ActivityResultSyncInfoBinding)this.binding).syncToggleButton.setChecked(this.getResultSyncFromBundle().isChecked);
        this.observeViewModel();
    }

    public void openLoginWebView(String string2, String string3) {
        Intent intent = new Intent((Context)this, StravaLoginActivity.class);
        intent.putExtra("StravaLoginActivity.EXTRA_LOGIN_URL", string2);
        intent.putExtra("StravaLoginActivity.EXTRA_REDIRECT_URL", string3);
        this.startActivityForResult(intent, 10);
    }

    @Override
    protected void setListeners() {
        ((ActivityResultSyncInfoBinding)this.binding).syncToggleButton.setOnCheckedChangeListener(new CompoundButton.OnCheckedChangeListener(){

            public void onCheckedChanged(CompoundButton compoundButton, boolean bl) {
                ((ActivityResultSyncInfoBinding)ResultSyncInfoActivity.this.binding).syncToggleButton.setChecked(bl);
                ResultSyncInfoActivity.this.openLoading();
                if (bl) {
                    ResultSyncInfoActivity.this.getAuthCode();
                } else {
                    ((ResultSyncInfoViewModel)ResultSyncInfoActivity.this.viewModel).unbindService(((ResultSyncInfoActivity)ResultSyncInfoActivity.this).getResultSyncFromBundle().serviceKey);
                }
            }
        });
    }
}

