/*
 * Decompiled with CFR 0.152.
 */
package com.brytonsport.active.ui.profile.adapter.item;

import android.content.Context;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import com.brytonsport.active.base.App;
import com.brytonsport.active.databinding.ItemProfileHeaderBinding;
import com.brytonsport.active.utils.ShapeUtils;
import com.brytonsport.active.vm.base.Profile;
import com.bumptech.glide.Glide;
import com.bumptech.glide.RequestBuilder;
import com.james.views.FreeLayout;

public class ProfileHeaderItem
extends FreeLayout {
    public ItemProfileHeaderBinding binding;
    private Profile profile;

    public ProfileHeaderItem(Context context) {
        super(context);
        this.init(context);
    }

    public ProfileHeaderItem(Context context, AttributeSet attributeSet) {
        super(context, attributeSet);
        this.init(context);
    }

    public ProfileHeaderItem(Context context, AttributeSet attributeSet, int n) {
        super(context, attributeSet, n);
        this.init(context);
    }

    private void init(Context object) {
        object = ItemProfileHeaderBinding.inflate(LayoutInflater.from((Context)object));
        this.binding = object;
        this.addFreeView((View)((ItemProfileHeaderBinding)object).getRoot(), -1, -2);
        ShapeUtils.getOval((View)this.binding.headshotImage);
    }

    public void setProfile(Profile profile) {
        this.profile = profile;
        this.binding.nameText.setText((CharSequence)profile.name);
        if (profile.headshotUri != null) {
            this.binding.headshotImage.setPaddingRelative(0, 0, 0, 0);
            this.binding.headshotImage.setImageURI(profile.headshotUri);
        } else if (profile.headshotBitmap != null) {
            this.binding.headshotImage.setPaddingRelative(0, 0, 0, 0);
            this.binding.headshotImage.setImageBitmap(profile.headshotBitmap);
        } else if (profile.headshotBase64 != null) {
            this.binding.headshotImage.setPaddingRelative(0, 0, 0, 0);
            ((RequestBuilder)Glide.with((Context)App.getInstance()).load(profile.headshotBase64)).into(this.binding.headshotImage);
        }
    }
}

