/*
 * Decompiled with CFR 0.152.
 */
package com.brytonsport.active.ui.result;

import android.graphics.Color;
import android.graphics.drawable.Drawable;
import android.os.Bundle;
import android.util.Log;
import android.view.LayoutInflater;
import androidx.lifecycle.ViewModelProvider;
import com.brytonsport.active.base.App;
import com.brytonsport.active.base.BaseActivity;
import com.brytonsport.active.databinding.ActivityResultMapBinding;
import com.brytonsport.active.utils.i18N;
import com.brytonsport.active.vm.result.ResultInfoViewModel;
import com.mapbox.geojson.Feature;
import com.mapbox.geojson.FeatureCollection;
import com.mapbox.geojson.Geometry;
import com.mapbox.geojson.LineString;
import com.mapbox.geojson.Point;
import com.mapbox.mapboxsdk.camera.CameraUpdateFactory;
import com.mapbox.mapboxsdk.geometry.LatLng;
import com.mapbox.mapboxsdk.geometry.LatLngBounds;
import com.mapbox.mapboxsdk.maps.MapView;
import com.mapbox.mapboxsdk.maps.MapboxMap;
import com.mapbox.mapboxsdk.maps.OnMapReadyCallback;
import com.mapbox.mapboxsdk.maps.Style;
import com.mapbox.mapboxsdk.plugins.localization.LocalizationPlugin;
import com.mapbox.mapboxsdk.style.layers.Layer;
import com.mapbox.mapboxsdk.style.layers.LineLayer;
import com.mapbox.mapboxsdk.style.layers.PropertyFactory;
import com.mapbox.mapboxsdk.style.layers.PropertyValue;
import com.mapbox.mapboxsdk.style.layers.SymbolLayer;
import com.mapbox.mapboxsdk.style.sources.GeoJsonSource;
import com.mapbox.mapboxsdk.style.sources.Source;
import com.mapbox.mapboxsdk.utils.BitmapUtils;
import java.util.ArrayList;
import java.util.List;

public class ResultMapActivity
extends BaseActivity<ActivityResultMapBinding, ResultInfoViewModel> {
    private static final int RC_LOCATION = 24;
    private String ICON_END_SOURCE_ID = "icon-end-source-id";
    private String ICON_START_SOURCE_ID = "icon-start-source-id";
    private GeoJsonSource geoJsonSource;
    private LatLngBounds latLngBounds;
    private List<LatLng> latLngList = new ArrayList<LatLng>();
    private MapboxMap mMapboxMap;
    private Style mapBoxStyle;
    private List<Point> points = new ArrayList<Point>();
    private ResultInfoViewModel.ResultMapPointsObj resultMapPointsObj;
    private ResultInfoViewModel.ResultSummaryObj resultSummary;

    static /* synthetic */ MapboxMap access$002(ResultMapActivity resultMapActivity, MapboxMap mapboxMap) {
        resultMapActivity.mMapboxMap = mapboxMap;
        return mapboxMap;
    }

    static /* synthetic */ Style access$102(ResultMapActivity resultMapActivity, Style style2) {
        resultMapActivity.mapBoxStyle = style2;
        return style2;
    }

    private void addEndMarkerImage(Style style2, double d, double d2) {
        style2.addSource((Source)new GeoJsonSource(this.ICON_END_SOURCE_ID, FeatureCollection.fromFeatures((Feature[])new Feature[]{Feature.fromGeometry((Geometry)Point.fromLngLat((double)d2, (double)d))})));
    }

    private void addStartEndMarker() {
        Point point = this.points;
        if (point != null && point.size() > 0) {
            point = this.points.get(0);
            Point point2 = this.points;
            point2 = point2.get(point2.size() - 1);
            this.addStartMarkerImage(this.mapBoxStyle, point.latitude(), point.longitude());
            this.addEndMarkerImage(this.mapBoxStyle, point2.latitude(), point2.longitude());
        }
    }

    private void addStartMarkerImage(Style style2, double d, double d2) {
        style2.addSource((Source)new GeoJsonSource(this.ICON_START_SOURCE_ID, FeatureCollection.fromFeatures((Feature[])new Feature[]{Feature.fromGeometry((Geometry)Point.fromLngLat((double)d2, (double)d))})));
    }

    private void decideShowMapView() {
        if (this.resultMapPointsObj.mapPointList != null && this.resultMapPointsObj.mapPointList.size() > 0) {
            this.initMap();
            this.setMapPoints();
        }
    }

    private void initMap() {
        ((ActivityResultMapBinding)this.binding).mapView.onCreate(null);
        ((ActivityResultMapBinding)this.binding).mapView.SetActivityAndMode(null, false);
        ((ActivityResultMapBinding)this.binding).mapView.getMapAsync(new OnMapReadyCallback(){

            public void onMapReady(final MapboxMap mapboxMap) {
                ResultMapActivity.access$002(ResultMapActivity.this, mapboxMap);
                mapboxMap.setStyle("mapbox://styles/mapbox/streets-v11", new Style.OnStyleLoaded(){

                    public void onStyleLoaded(Style style2) {
                        ResultMapActivity.access$102(ResultMapActivity.this, style2);
                        ResultMapActivity.this.initSymbolLayer(style2);
                        ResultMapActivity.this.setMapView();
                        ResultMapActivity.this.addStartEndMarker();
                        style2 = new LocalizationPlugin((MapView)((ActivityResultMapBinding)ResultMapActivity.this.binding).mapView, mapboxMap, style2);
                        try {
                            style2.matchMapLanguageWithDeviceDefault();
                        }
                        catch (RuntimeException runtimeException) {
                            Log.d((String)"ActivityBase", (String)runtimeException.toString());
                        }
                    }
                });
            }
        });
    }

    private void initSymbolLayer(Style style2) {
        style2.addImage("icon-start-point", BitmapUtils.getBitmapFromDrawable((Drawable)this.getResources().getDrawable(2131165530)));
        style2.addImage("icon-end-point", BitmapUtils.getBitmapFromDrawable((Drawable)this.getResources().getDrawable(2131165528)));
        SymbolLayer symbolLayer = new SymbolLayer("symbol-layer-id", this.ICON_START_SOURCE_ID);
        PropertyValue propertyValue = PropertyFactory.iconImage((String)"icon-start-point");
        Float f = Float.valueOf(0.3f);
        style2.addLayer((Layer)symbolLayer.withProperties(new PropertyValue[]{propertyValue, PropertyFactory.iconSize((Float)f), PropertyFactory.iconAnchor((String)"bottom")}));
        style2.addLayer((Layer)new SymbolLayer("symbol-layer-id2", this.ICON_END_SOURCE_ID).withProperties(new PropertyValue[]{PropertyFactory.iconImage((String)"icon-end-point"), PropertyFactory.iconSize((Float)f), PropertyFactory.iconAnchor((String)"bottom")}));
    }

    private void setMapPoints() {
        if (this.points == null) {
            this.points = new ArrayList<Point>();
        }
        if (this.resultMapPointsObj.mapPointList != null && this.resultMapPointsObj.mapPointList.size() > 0) {
            for (int i = 0; i < this.resultMapPointsObj.mapPointList.size(); ++i) {
                Point point = Point.fromLngLat((double)this.resultMapPointsObj.mapPointList.get((int)i).lng, (double)this.resultMapPointsObj.mapPointList.get((int)i).lat);
                this.points.add(point);
                point = new LatLng(this.resultMapPointsObj.mapPointList.get((int)i).lat, this.resultMapPointsObj.mapPointList.get((int)i).lng);
                this.latLngList.add((LatLng)point);
            }
            if (this.latLngBounds == null) {
                if (this.points.size() >= 2) {
                    this.latLngBounds = new LatLngBounds.Builder().includes(this.latLngList).build();
                }
            } else {
                this.latLngBounds = null;
                this.latLngBounds = new LatLngBounds.Builder().includes(this.latLngList).build();
            }
        }
    }

    private void setMapView() {
        LatLngBounds latLngBounds = this.latLngBounds;
        if (latLngBounds != null) {
            this.mMapboxMap.easeCamera(CameraUpdateFactory.newLatLngBounds((LatLngBounds)latLngBounds, (int)150), 1000);
        }
        latLngBounds = Feature.fromGeometry((Geometry)LineString.fromLngLats(this.points));
        GeoJsonSource geoJsonSource = this.geoJsonSource;
        if (geoJsonSource == null) {
            latLngBounds = new GeoJsonSource("geojson-source", (Feature)latLngBounds);
            this.geoJsonSource = latLngBounds;
            this.mapBoxStyle.addSource((Source)latLngBounds);
            this.mapBoxStyle.addLayer((Layer)new LineLayer("linelayer", "geojson-source").withProperties(new PropertyValue[]{PropertyFactory.lineJoin((String)"round"), PropertyFactory.lineWidth((Float)Float.valueOf(4.0f)), PropertyFactory.lineColor((int)Color.parseColor((String)"#003ADB"))}));
        } else {
            geoJsonSource.setGeoJson((Feature)latLngBounds);
        }
    }

    @Override
    protected ActivityResultMapBinding createViewBinding(LayoutInflater layoutInflater) {
        return ActivityResultMapBinding.inflate(layoutInflater);
    }

    @Override
    protected ResultInfoViewModel createViewModel() {
        return new ViewModelProvider(this).get(ResultInfoViewModel.class);
    }

    @Override
    protected void initColor() {
    }

    @Override
    protected void initFont() {
    }

    @Override
    protected void initText() {
    }

    @Override
    protected void onCreate() {
        super.onCreate();
        this.resultMapPointsObj = App.resultMapPointsObj;
        this.decideShowMapView();
        this.setTitle(i18N.get("map"));
    }

    @Override
    public void onSaveInstanceState(Bundle bundle) {
        super.onSaveInstanceState(bundle);
        ((ActivityResultMapBinding)this.binding).mapView.onSaveInstanceState(bundle);
    }

    @Override
    protected void setListeners() {
    }
}

