/*
 * Decompiled with CFR 0.152.
 */
package com.brytonsport.active.ui.result;

import android.content.Context;
import android.text.format.DateFormat;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.TextView;
import androidx.recyclerview.widget.DiffUtil;
import androidx.recyclerview.widget.RecyclerView;
import com.brytonsport.active.base.App;
import com.brytonsport.active.db.result.entity.ActivityEntity;
import com.brytonsport.active.ui.result.DiffCallback;
import com.brytonsport.active.utils.DistanceUtil;
import com.brytonsport.active.utils.TimeUtilByLee;
import com.bumptech.glide.Glide;
import com.bumptech.glide.RequestBuilder;
import java.io.File;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import java.util.TimeZone;

public class ResultMyListAdapter
extends RecyclerView.Adapter<ResultMyHolder> {
    private static final String DEFAULT_ACTIVITY_NAME = "new activity";
    List<ActivityEntity> dataList;
    private OnResultItemClickListener onResultItemClickListener;

    public ResultMyListAdapter(List<ActivityEntity> list) {
        this.dataList = list == null ? new ArrayList<ActivityEntity>() : list;
    }

    public ActivityEntity getItem(int n) {
        return this.dataList.get(n);
    }

    @Override
    public int getItemCount() {
        List<ActivityEntity> list = this.dataList;
        int n = list == null ? 0 : list.size();
        return n;
    }

    @Override
    public void onBindViewHolder(ResultMyHolder resultMyHolder, int n) {
        ActivityEntity activityEntity = this.dataList.get(n);
        CharSequence charSequence = activityEntity.getName();
        Object object = charSequence;
        if (((String)charSequence).equals(DEFAULT_ACTIVITY_NAME)) {
            object = new StringBuilder();
            ((StringBuilder)object).append("bike");
            ((StringBuilder)object).append(resultMyHolder.getDateHour(activityEntity.getLocalStartTime()));
            object = ((StringBuilder)object).toString();
        }
        resultMyHolder.resultNameText.setText((CharSequence)object);
        resultMyHolder.resultDateText.setText((CharSequence)resultMyHolder.getYearDate(activityEntity.getLocalStartTime()));
        double d = activityEntity.getSummary().getTotalDistance();
        charSequence = new StringBuilder();
        ((StringBuilder)charSequence).append(DistanceUtil.distanceMeteor2Km(d));
        ((StringBuilder)charSequence).append("");
        charSequence = ((StringBuilder)charSequence).toString();
        if (d >= 1000.0) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append((String)charSequence);
            stringBuilder.append("\u516c\u91cc");
            charSequence = stringBuilder.toString();
        } else {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append((String)charSequence);
            stringBuilder.append("\u516c\u5c3a");
            charSequence = stringBuilder.toString();
        }
        resultMyHolder.resultDistanceText.setText(charSequence);
        if (activityEntity.getSummary().getTotalMovingTime() != null) {
            resultMyHolder.resultTimeText.setText((CharSequence)TimeUtilByLee.secondsToTime(activityEntity.getSummary().getTotalMovingTime().intValue()));
        } else {
            resultMyHolder.resultTimeText.setText((CharSequence)TimeUtilByLee.secondsToTime(0));
        }
        if (activityEntity.getMapImage() == null) {
            ((RequestBuilder)Glide.with((Context)App.getInstance()).load(2131165654)).into(resultMyHolder.mapImage);
        } else if (activityEntity.getMapImage().isEmpty()) {
            ((RequestBuilder)Glide.with((Context)App.getInstance()).load(2131165654)).into(resultMyHolder.mapImage);
        } else {
            charSequence = new StringBuilder();
            ((StringBuilder)charSequence).append("bind: ");
            ((StringBuilder)charSequence).append((String)object);
            ((StringBuilder)charSequence).append(", image path: ");
            ((StringBuilder)charSequence).append(activityEntity.getMapImage());
            Log.d((String)"TAG", (String)((StringBuilder)charSequence).toString());
            object = new StringBuilder();
            ((StringBuilder)object).append(App.getInstance().getFilesDir());
            ((StringBuilder)object).append(File.separator);
            ((StringBuilder)object).append(activityEntity.getMapImage());
            object = new File(((StringBuilder)object).toString());
            ((RequestBuilder)Glide.with((Context)App.getInstance()).load((File)object)).into(resultMyHolder.mapImage);
        }
    }

    @Override
    public void onBindViewHolder(ResultMyHolder resultMyHolder, int n, List<Object> object) {
        if (object.isEmpty()) {
            this.onBindViewHolder(resultMyHolder, n);
        } else {
            CharSequence charSequence = new StringBuilder();
            ((StringBuilder)charSequence).append("onBindViewHolder payload: ");
            ((StringBuilder)charSequence).append(object);
            Log.d((String)"PayloadAdapter", (String)((StringBuilder)charSequence).toString());
            ActivityEntity activityEntity = this.dataList.get(n);
            if (activityEntity.getMapImage() == null) {
                ((RequestBuilder)Glide.with((Context)App.getInstance()).load(2131165654)).into(resultMyHolder.mapImage);
            } else if (activityEntity.getMapImage().isEmpty()) {
                ((RequestBuilder)Glide.with((Context)App.getInstance()).load(2131165654)).into(resultMyHolder.mapImage);
            } else {
                charSequence = activityEntity.getName();
                object = charSequence;
                if (((String)charSequence).equals(DEFAULT_ACTIVITY_NAME)) {
                    object = new StringBuilder();
                    ((StringBuilder)object).append("bike");
                    ((StringBuilder)object).append(resultMyHolder.getDateHour(activityEntity.getLocalStartTime()));
                    object = ((StringBuilder)object).toString();
                }
                charSequence = new StringBuilder();
                ((StringBuilder)charSequence).append("bind: ");
                ((StringBuilder)charSequence).append((String)object);
                ((StringBuilder)charSequence).append(", image path: ");
                ((StringBuilder)charSequence).append(activityEntity.getMapImage());
                Log.d((String)"TAG", (String)((StringBuilder)charSequence).toString());
                object = new StringBuilder();
                ((StringBuilder)object).append(App.getInstance().getFilesDir());
                ((StringBuilder)object).append(File.separator);
                ((StringBuilder)object).append(activityEntity.getMapImage());
                object = new File(((StringBuilder)object).toString());
                ((RequestBuilder)Glide.with((Context)App.getInstance()).load((File)object)).into(resultMyHolder.mapImage);
            }
        }
    }

    @Override
    public ResultMyHolder onCreateViewHolder(ViewGroup viewGroup, int n) {
        return new ResultMyHolder(LayoutInflater.from((Context)viewGroup.getContext()).inflate(2131427487, viewGroup, false));
    }

    public void setDataList(List<ActivityEntity> list) {
        this.dataList = list;
        this.notifyDataSetChanged();
    }

    public void setDataListForImg(List<ActivityEntity> list) {
        this.dataList = list;
        this.notifyItemRangeChanged(0, this.getItemCount(), 0);
    }

    public void setOnResultItemClickListener(OnResultItemClickListener onResultItemClickListener) {
        this.onResultItemClickListener = onResultItemClickListener;
    }

    public void updateDataListItems(List<ActivityEntity> list) {
        if (list != null) {
            DiffUtil.DiffResult diffResult = DiffUtil.calculateDiff(new DiffCallback(new ArrayList<ActivityEntity>(this.dataList), new ArrayList<ActivityEntity>(list)));
            this.dataList.clear();
            this.dataList.addAll(new ArrayList<ActivityEntity>(list));
            diffResult.dispatchUpdatesTo(this);
        }
    }

    public static interface OnResultItemClickListener {
        public void onResultItemClick(int var1, ActivityEntity var2);
    }

    class ResultMyHolder
    extends RecyclerView.ViewHolder {
        private ImageView mapImage;
        private TextView resultDateText;
        private TextView resultDistanceText;
        private TextView resultNameText;
        private TextView resultTimeText;

        public ResultMyHolder(View view) {
            super(view);
            this.resultNameText = (TextView)view.findViewById(2131231651);
            this.resultDateText = (TextView)view.findViewById(2131231646);
            this.resultDistanceText = (TextView)view.findViewById(2131231647);
            this.resultTimeText = (TextView)view.findViewById(2131231655);
            this.mapImage = (ImageView)view.findViewById(2131231342);
            view.setOnClickListener(new View.OnClickListener(){

                public void onClick(View view) {
                    int n = ResultMyHolder.this.getAdapterPosition();
                    if (ResultMyListAdapter.this.onResultItemClickListener != null) {
                        ResultMyListAdapter.this.onResultItemClickListener.onResultItemClick(n, ResultMyListAdapter.this.getItem(n));
                    }
                }
            });
        }

        private String getDateHour(long l) {
            Calendar calendar = Calendar.getInstance();
            calendar.setTimeInMillis(l * 1000L);
            calendar.setTimeZone(TimeZone.getTimeZone("UTC"));
            return DateFormat.format((CharSequence)"ddHHmm", (Calendar)calendar).toString();
        }

        private String getDateTime(long l) {
            Calendar calendar = Calendar.getInstance();
            calendar.setTimeInMillis(l * 1000L);
            return DateFormat.format((CharSequence)"HH:mm:ss", (Calendar)calendar).toString();
        }

        private String getYearDate(long l) {
            Calendar calendar = Calendar.getInstance();
            calendar.setTimeInMillis(l * 1000L);
            calendar.setTimeZone(TimeZone.getTimeZone("UTC"));
            return DateFormat.format((CharSequence)"yyyy/MM/dd", (Calendar)calendar).toString();
        }
    }
}

