/*
 * Decompiled with CFR 0.152.
 */
package com.brytonsport.active.ui.result.adapter;

import android.content.Context;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.TextView;
import androidx.recyclerview.widget.RecyclerView;
import com.brytonsport.active.base.App;
import com.brytonsport.active.base.GroupingRecyclerViewAdapter;
import com.brytonsport.active.db.result.entity.ActivityEntity;
import com.brytonsport.active.utils.DistanceUtil;
import com.brytonsport.active.utils.TimeUtilByLee;
import com.bumptech.glide.Glide;
import com.bumptech.glide.RequestBuilder;
import java.io.File;
import java.util.List;

public class ResultListAdapter
extends GroupingRecyclerViewAdapter {
    private static final String DEFAULT_ACTIVITY_NAME = "new activity";
    private List<ActivityEntity> dataList;

    public ResultListAdapter(List<ActivityEntity> list) {
        this.dataList = list;
        this.addAll(list);
    }

    protected GroupingRecyclerViewAdapter.Group createGroup(Object object) {
        return new GroupingRecyclerViewAdapter.Group(TimeUtilByLee.getDate(((ActivityEntity)object).getLocalStartTime()));
    }

    protected void onBindGroupItemViewHolder(RecyclerView.ViewHolder viewHolder, Object object) {
        object = (ActivityEntity)object;
        ((ViewHolder)viewHolder).bind((ActivityEntity)object);
    }

    protected RecyclerView.ViewHolder onCreateGroupItemViewHolder(ViewGroup viewGroup) {
        return new ViewHolder(LayoutInflater.from((Context)viewGroup.getContext()).inflate(2131427487, viewGroup, false));
    }

    public void setDataList(List<ActivityEntity> list) {
        this.dataList = list;
        this.addAll(list);
    }

    public void setDataListForImg(List<ActivityEntity> list) {
        this.dataList = list;
        this.notifyItemChanged(0, 0);
    }

    protected boolean shouldCreateGroup(Object object, Object object2) {
        object = (ActivityEntity)object;
        object2 = (ActivityEntity)object2;
        return !TimeUtilByLee.getDate(((ActivityEntity)object).getLocalStartTime()).equals(TimeUtilByLee.getDate(((ActivityEntity)object2).getLocalStartTime()));
    }

    public static class ViewHolder
    extends RecyclerView.ViewHolder {
        private final ImageView mapImage;
        private final TextView resultDateText;
        private final TextView resultDistanceText;
        private final ImageView resultIcon;
        private final TextView resultNameText;
        private final TextView resultTimeText;

        public ViewHolder(View view) {
            super(view);
            this.resultIcon = (ImageView)view.findViewById(2131231649);
            this.resultNameText = (TextView)view.findViewById(2131231651);
            this.resultDateText = (TextView)view.findViewById(2131231646);
            this.resultDistanceText = (TextView)view.findViewById(2131231647);
            this.resultTimeText = (TextView)view.findViewById(2131231655);
            this.mapImage = (ImageView)view.findViewById(2131231342);
        }

        public void bind(ActivityEntity serializable) {
            CharSequence charSequence;
            CharSequence charSequence2 = charSequence = serializable.getName();
            if (((String)charSequence).equals(ResultListAdapter.DEFAULT_ACTIVITY_NAME)) {
                charSequence2 = new StringBuilder();
                ((StringBuilder)charSequence2).append("bike");
                ((StringBuilder)charSequence2).append(TimeUtilByLee.getDateHour(serializable.getLocalStartTime()));
                charSequence2 = ((StringBuilder)charSequence2).toString();
            }
            this.resultNameText.setText(charSequence2);
            this.resultDateText.setText((CharSequence)TimeUtilByLee.getYearDate(serializable.getLocalStartTime()));
            double d = serializable.getSummary().getTotalDistance();
            charSequence = new StringBuilder();
            ((StringBuilder)charSequence).append(DistanceUtil.distanceMeteor2Km(d));
            ((StringBuilder)charSequence).append("");
            charSequence = ((StringBuilder)charSequence).toString();
            if (d >= 1000.0) {
                StringBuilder stringBuilder = new StringBuilder();
                stringBuilder.append((String)charSequence);
                stringBuilder.append("\u516c\u91cc");
                charSequence = stringBuilder.toString();
            } else {
                StringBuilder stringBuilder = new StringBuilder();
                stringBuilder.append((String)charSequence);
                stringBuilder.append("\u516c\u5c3a");
                charSequence = stringBuilder.toString();
            }
            this.resultDistanceText.setText(charSequence);
            if (serializable.getSummary().getTotalMovingTime() != null) {
                this.resultTimeText.setText((CharSequence)TimeUtilByLee.secondsToTime(serializable.getSummary().getTotalMovingTime().intValue()));
            } else {
                this.resultTimeText.setText((CharSequence)TimeUtilByLee.secondsToTime(0));
            }
            if (serializable.getMapImage() == null) {
                ((RequestBuilder)Glide.with((Context)App.getInstance()).load(2131165654)).into(this.mapImage);
            } else if (serializable.getMapImage().isEmpty()) {
                ((RequestBuilder)Glide.with((Context)App.getInstance()).load(2131165654)).into(this.mapImage);
            } else {
                charSequence = new StringBuilder();
                ((StringBuilder)charSequence).append("bind: ");
                ((StringBuilder)charSequence).append((String)charSequence2);
                ((StringBuilder)charSequence).append(", image path: ");
                ((StringBuilder)charSequence).append(serializable.getMapImage());
                Log.d((String)"TAG", (String)((StringBuilder)charSequence).toString());
                charSequence2 = new StringBuilder();
                ((StringBuilder)charSequence2).append(App.getInstance().getFilesDir());
                ((StringBuilder)charSequence2).append(File.separator);
                ((StringBuilder)charSequence2).append(serializable.getMapImage());
                serializable = new File(((StringBuilder)charSequence2).toString());
                ((RequestBuilder)Glide.with((Context)App.getInstance()).load((File)serializable)).into(this.mapImage);
            }
        }
    }
}

