/*
 * Decompiled with CFR 0.152.
 */
package com.brytonsport.active.ui.result.adapter.item;

import android.content.Context;
import android.view.View;
import android.view.ViewGroup;
import android.widget.RelativeLayout;
import com.brytonsport.active.base.App;
import com.brytonsport.active.ui.result.adapter.item.ResultAnalysisBaseItem;
import com.brytonsport.active.utils.Utils;
import com.brytonsport.active.utils.i18N;
import com.brytonsport.active.vm.base.analysis.Altitude;
import com.github.mikephil.charting.charts.CombinedChart;
import com.github.mikephil.charting.components.YAxis;
import com.github.mikephil.charting.data.CombinedData;
import com.github.mikephil.charting.data.Entry;
import com.github.mikephil.charting.data.LineData;
import com.github.mikephil.charting.data.LineDataSet;
import com.github.mikephil.charting.interfaces.datasets.IDataSet;
import com.james.utils.MonitorUtils;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.List;

public class ResultAnalysisAltitudeItem
extends ResultAnalysisBaseItem<Altitude, Altitude> {
    private ArrayList<Altitude> altitudeList;
    private CombinedChart chart;
    List<Entry> lineEntryList = new ArrayList<Entry>();
    float max = 0.0f;
    float min = 999.0f;
    List<Entry> timeEntryList = new ArrayList<Entry>();

    public ResultAnalysisAltitudeItem(Context context) {
        super(context, 4100, "distance");
        this.setView();
    }

    private void drawDistanceLine() {
        float f;
        Object object;
        Object object2;
        block4: {
            if (this.lineEntryList.size() != 0) break block4;
            float f2 = 0.0f;
            for (int i = 0; i < this.altitudeList.size(); ++i) {
                block6: {
                    block7: {
                        block5: {
                            object2 = this.altitudeList.get(i);
                            if (this.min > object2.meter) {
                                this.min = object2.meter;
                            }
                            if (this.max < object2.meter) {
                                this.max = object2.meter;
                            }
                            if (this.lineEntryList.size() <= 1) break block5;
                            object = this.altitudeList.get(i - 1);
                            f = f2;
                            if (object2.distance == object.distance) break block6;
                            object = new Entry(f2, Utils.convertM(object2.meter));
                            this.lineEntryList.add((Entry)object);
                            break block7;
                        }
                        object = new Entry(f2, Utils.convertM(object2.meter));
                        this.lineEntryList.add((Entry)object);
                    }
                    f = f2 + 1.0f;
                }
                f2 = f;
            }
            this.max = Utils.convertM(this.max);
        }
        object2 = new LineDataSet(this.lineEntryList, App.get("Altitude"));
        object2.setDrawCircles(false);
        object2.setDrawFilled(true);
        object2.setFillColor(this.getColor(2131034139));
        object2.setColor(this.getColor(2131034139));
        object2.setAxisDependency(YAxis.AxisDependency.RIGHT);
        object2.setDrawValues(false);
        object = new LineData();
        object.addDataSet((IDataSet)object2);
        object2 = new CombinedData();
        object2.setData(object);
        this.updateItem(this.min, this.max);
        this.chart.setData((CombinedData)object2);
        object = this.chart.getAxisRight();
        object.setAxisMinimum(0.0f);
        f = this.max;
        if (f != 0.0f) {
            object.setAxisMaximum(f * 1.1f);
        }
    }

    private void drawLine(String string2) {
        if (string2.equalsIgnoreCase("distance")) {
            this.drawDistanceLine();
        } else if (string2.equalsIgnoreCase("time")) {
            this.drawTimeLine();
        }
    }

    private void drawTimeLine() {
        Object object;
        Altitude altitude;
        float f;
        if (this.timeEntryList.size() == 0) {
            f = 0.0f;
            for (int i = 0; i < this.altitudeList.size(); ++i) {
                altitude = this.altitudeList.get(i);
                altitude.meter = Utils.convertM(altitude.meter);
                float f2 = f;
                if (this.timeEntryList.size() > 1) {
                    object = this.altitudeList.get(i - 1);
                    f2 = f;
                    if (altitude.time != object.time + 1000L) {
                        int n = (int)(altitude.time - object.time) / 1000;
                        float f3 = (altitude.meter - object.meter) / (float)n;
                        Entry entry = this.timeEntryList.get((int)f - 1);
                        n = (int)object.time;
                        while (true) {
                            f2 = f;
                            if ((long)n >= altitude.time) break;
                            f2 = f;
                            if (n != (int)object.time) {
                                Entry entry2 = new Entry(f, entry.getY() + (f - entry.getX() - 1.0f) * f3);
                                this.timeEntryList.add(entry2);
                                f2 = f + 1.0f;
                            }
                            n += 1000;
                            f = f2;
                        }
                    }
                }
                altitude = new Entry(f2, altitude.meter);
                this.timeEntryList.add((Entry)altitude);
                f = f2 + 1.0f;
            }
        }
        object = new LineDataSet(this.timeEntryList, App.get("Altitude"));
        object.setDrawCircles(false);
        object.setDrawFilled(true);
        object.setFillColor(this.getColor(2131034139));
        object.setColor(this.getColor(2131034139));
        object.setAxisDependency(YAxis.AxisDependency.RIGHT);
        object.setDrawValues(false);
        altitude = new LineData();
        altitude.addDataSet((IDataSet)object);
        object = new CombinedData();
        object.setData((LineData)altitude);
        this.setDefaultChartStyle(this.chart);
        this.chart.setData((CombinedData)object);
        this.updateItem(this.min, this.max);
        this.chart.setData((CombinedData)object);
        altitude = this.chart.getAxisRight();
        altitude.setAxisMinimum(0.0f);
        f = this.max;
        if (f != 0.0f) {
            altitude.setAxisMaximum(f * 1.1f);
        }
    }

    private boolean isNeedCount(List<Entry> list, Altitude altitude) {
        float f = this.getDistanceLevel();
        int n = list.size();
        boolean bl = true;
        if (n == 0) {
            return true;
        }
        n = (int)list.get(list.size() - 1).getX();
        if (!(Math.abs(altitude.distance - this.altitudeList.get((int)n).distance) * 1000.0f > f)) {
            bl = false;
        }
        return bl;
    }

    private void setView() {
        Context context = this.getContext();
        this.binding.bottomLayout.removeAllViews();
        this.chart = new CombinedChart(context);
        this.binding.bottomLayout.addView((View)this.chart, (ViewGroup.LayoutParams)new RelativeLayout.LayoutParams(-1, MonitorUtils.dp2px((Context)context, (float)165.0f)));
    }

    private void updateItem(final float f, final float f2) {
        this.updateUiItem(new Runnable(){

            @Override
            public void run() {
                DecimalFormat decimalFormat = new DecimalFormat("##0");
                ResultAnalysisAltitudeItem.this.binding.subText1.setText((CharSequence)decimalFormat.format(Utils.convertM(f)));
                ResultAnalysisAltitudeItem.this.binding.subText2.setText((CharSequence)decimalFormat.format(f2));
            }
        });
    }

    @Override
    protected CombinedChart getChart() {
        return this.chart;
    }

    @Override
    protected CombinedChart getChart2() {
        return null;
    }

    @Override
    protected void onSwitchListener(String string2) {
        this.drawLine(string2);
    }

    @Override
    public void setList(ArrayList<Altitude> arrayList) {
        super.setList(arrayList);
        this.altitudeList = arrayList;
        this.binding.indexText.setText((CharSequence)App.get("Altitude(m)"));
        this.drawLine("distance");
        this.binding.subTitle1.setText((CharSequence)i18N.get("MiniMum"));
        this.binding.subTitle4.setText((CharSequence)i18N.get("TotalAscent"));
        this.binding.subTitle5.setText((CharSequence)i18N.get("TotalDescent"));
        this.binding.subTitle3.setVisibility(8);
        this.binding.subText3.setVisibility(8);
        if (this.lineEntryList.size() != 0) {
            this.setDefaultChartStyle(this.chart);
        }
    }

    public void setText(String string2, String string3) {
        float f;
        DecimalFormat decimalFormat = new DecimalFormat("##0");
        if (string2 != null && !string2.equals("-")) {
            f = Utils.convertM(Float.parseFloat(string2));
            this.binding.subText4.setText((CharSequence)decimalFormat.format(f));
        } else {
            this.binding.subText4.setText((CharSequence)"-");
        }
        if (string3 != null && !string3.equals("-")) {
            f = Utils.convertM(Float.parseFloat(string3));
            this.binding.subText5.setText((CharSequence)decimalFormat.format(f));
        } else {
            this.binding.subText5.setText((CharSequence)"-");
        }
    }
}

