/*
 * Decompiled with CFR 0.152.
 */
package com.brytonsport.active.ui.result.adapter.item;

import android.content.Context;
import android.view.View;
import android.view.ViewGroup;
import android.widget.LinearLayout;
import android.widget.RelativeLayout;
import android.widget.TextView;
import androidx.core.view.ViewCompat;
import com.brytonsport.active.base.App;
import com.brytonsport.active.ui.result.adapter.item.ResultAnalysisBaseItem;
import com.brytonsport.active.utils.GearDataObj;
import com.brytonsport.active.vm.base.Gear;
import com.brytonsport.active.vm.base.analysis.Altitude;
import com.github.mikephil.charting.charts.CombinedChart;
import com.github.mikephil.charting.charts.ScatterChart;
import com.github.mikephil.charting.components.YAxis;
import com.github.mikephil.charting.data.CombinedData;
import com.github.mikephil.charting.data.Entry;
import com.github.mikephil.charting.data.LineData;
import com.github.mikephil.charting.data.LineDataSet;
import com.github.mikephil.charting.data.ScatterData;
import com.github.mikephil.charting.data.ScatterDataSet;
import com.github.mikephil.charting.interfaces.datasets.IDataSet;
import com.james.utils.MonitorUtils;
import java.util.ArrayList;
import java.util.List;

public class ResultAnalysisGearItem
extends ResultAnalysisBaseItem<Gear, Altitude> {
    private CombinedChart chart;
    private TextView frontText;
    private GearDataObj gearDataObj;
    private TextView rearText;

    public ResultAnalysisGearItem(Context context) {
        super(context, 4113, "time");
        this.setView();
    }

    public ResultAnalysisGearItem(Context context, GearDataObj gearDataObj) {
        super(context, 4113, "time");
        this.gearDataObj = gearDataObj;
        this.setView();
    }

    private void setView() {
        Context context = this.getContext();
        this.binding.bottomLayout.removeAllViews();
        int n = MonitorUtils.dp2px((Context)context, (float)6.0f);
        LinearLayout linearLayout = new LinearLayout(context);
        linearLayout.setId(ViewCompat.generateViewId());
        linearLayout.setOrientation(0);
        linearLayout.setGravity(16);
        linearLayout.setPadding(MonitorUtils.dp2px((Context)context, (float)190.0f), 0, MonitorUtils.dp2px((Context)context, (float)20.0f), 0);
        this.binding.bottomLayout.addView((View)linearLayout, (ViewGroup.LayoutParams)new RelativeLayout.LayoutParams(-1, MonitorUtils.dp2px((Context)context, (float)75.0f)));
        LinearLayout linearLayout2 = new LinearLayout(context);
        linearLayout2.setGravity(17);
        linearLayout2.setOrientation(1);
        linearLayout.addView((View)linearLayout2, (ViewGroup.LayoutParams)new LinearLayout.LayoutParams(0, -1, 1.0f));
        Object object = new TextView(context);
        object.setTextColor(this.getResources().getColor(2131034240));
        object.setTextSize(12.0f);
        object.setText((CharSequence)App.get("Front"));
        linearLayout2.addView((View)object, (ViewGroup.LayoutParams)new LinearLayout.LayoutParams(-2, -2));
        this.frontText = object = new TextView(context);
        object.setTextColor(this.getResources().getColor(2131034756));
        this.frontText.setTextSize(20.0f);
        object = this.gearDataObj;
        if (object != null) {
            this.frontText.setText((CharSequence)String.valueOf(object.frontGear));
        } else {
            this.frontText.setText((CharSequence)"---");
        }
        object = this.frontText;
        object.setTypeface(object.getTypeface(), 1);
        linearLayout2.addView((View)this.frontText, (ViewGroup.LayoutParams)new LinearLayout.LayoutParams(-2, -2));
        ((ViewGroup.MarginLayoutParams)this.frontText.getLayoutParams()).topMargin = n;
        linearLayout2 = new LinearLayout(context);
        linearLayout2.setGravity(17);
        linearLayout2.setOrientation(1);
        linearLayout.addView((View)linearLayout2, (ViewGroup.LayoutParams)new LinearLayout.LayoutParams(0, -1, 1.0f));
        object = new TextView(context);
        object.setTextColor(this.getResources().getColor(2131034240));
        object.setTextSize(12.0f);
        object.setText((CharSequence)App.get("Rear"));
        linearLayout2.addView((View)object, (ViewGroup.LayoutParams)new LinearLayout.LayoutParams(-2, -2));
        this.rearText = object = new TextView(context);
        object.setTextColor(this.getResources().getColor(2131034756));
        this.rearText.setTextSize(20.0f);
        object = this.gearDataObj;
        if (object != null) {
            this.rearText.setText((CharSequence)String.valueOf(object.rearGear));
        } else {
            this.rearText.setText((CharSequence)"---");
        }
        object = this.rearText;
        object.setTypeface(object.getTypeface(), 1);
        linearLayout2.addView((View)this.rearText, (ViewGroup.LayoutParams)new LinearLayout.LayoutParams(-2, -2));
        ((ViewGroup.MarginLayoutParams)this.rearText.getLayoutParams()).topMargin = n;
        this.chart = new CombinedChart(context);
        this.binding.bottomLayout.addView((View)this.chart, (ViewGroup.LayoutParams)new RelativeLayout.LayoutParams(-1, MonitorUtils.dp2px((Context)context, (float)165.0f)));
        ((RelativeLayout.LayoutParams)this.chart.getLayoutParams()).addRule(3, linearLayout.getId());
    }

    private void updateItem() {
        this.binding.subTitle1.setText((CharSequence)App.get("Total"));
        if (this.gearDataObj != null) {
            this.binding.subText1.setText((CharSequence)String.valueOf(this.gearDataObj.totalGear));
        } else {
            this.binding.subText1.setText((CharSequence)"---");
        }
        this.binding.subTitle2.setText((CharSequence)App.get("Favorite"));
        GearDataObj gearDataObj = this.gearDataObj;
        if (gearDataObj != null && !gearDataObj.favGear.isEmpty()) {
            this.binding.subText2.setText((CharSequence)this.gearDataObj.favGear);
        } else {
            this.binding.subText2.setText((CharSequence)"---");
        }
    }

    @Override
    protected CombinedChart getChart() {
        return this.chart;
    }

    @Override
    protected CombinedChart getChart2() {
        return null;
    }

    @Override
    protected void onSwitchListener(String string2) {
    }

    @Override
    public void setList(final ArrayList<Gear> arrayList, final ArrayList<Altitude> arrayList2) {
        super.setList(arrayList, arrayList2);
        this.binding.indexText.setText((CharSequence)App.get("Gears"));
        this.runOnBgThread(new Runnable(){

            @Override
            public void run() {
                Gear gear;
                Object object;
                int n;
                LineData lineData = new ArrayList();
                int n2 = 0;
                for (n = 0; n < arrayList2.size(); ++n) {
                    object = (Altitude)arrayList2.get(n);
                    lineData.add(new Entry((float)n, ((Altitude)object).meter));
                }
                object = new LineDataSet(lineData, App.get("Altitude"));
                object.setDrawCircles(false);
                object.setDrawFilled(true);
                object.setFillColor(-11838038);
                object.setColor(-11838038);
                object.setAxisDependency(YAxis.AxisDependency.RIGHT);
                object.setDrawValues(false);
                lineData = new LineData();
                lineData.addDataSet((IDataSet)object);
                final float f = 0.0f;
                object = new ArrayList();
                ScatterData scatterData = new ArrayList();
                for (n = n2; n < arrayList.size(); ++n) {
                    gear = (Gear)arrayList.get(n);
                    float f2 = f;
                    if (f < gear.frontLevel) {
                        f2 = gear.frontLevel;
                    }
                    f = f2;
                    if (f2 < gear.rearLevel) {
                        f = gear.rearLevel;
                    }
                    object.add(new Entry((float)gear.sampleIndex, gear.frontLevel));
                    scatterData.add(new Entry((float)gear.sampleIndex, gear.rearLevel));
                }
                object = new ScatterDataSet((List)object, "");
                object.setColor(-16723133);
                object.setScatterShape(ScatterChart.ScatterShape.CIRCLE);
                gear = new ScatterDataSet(scatterData, "");
                gear.setColor(-16723133);
                gear.setScatterShape(ScatterChart.ScatterShape.CIRCLE);
                scatterData = new ScatterData();
                scatterData.addDataSet((IDataSet)object);
                scatterData.addDataSet((IDataSet)gear);
                object = new CombinedData();
                object.setData(lineData);
                object.setData(scatterData);
                ResultAnalysisGearItem.this.updateUiItem(new Runnable((CombinedData)object){
                    final /* synthetic */ CombinedData val$combinedData;
                    {
                        this.val$combinedData = combinedData;
                    }

                    @Override
                    public void run() {
                        ResultAnalysisGearItem.this.updateItem();
                        ResultAnalysisGearItem.this.chart.setDrawOrder(ResultAnalysisGearItem.this.drawOrders);
                        ResultAnalysisGearItem.this.setDefaultChartStyle(ResultAnalysisGearItem.this.chart);
                        ResultAnalysisGearItem.this.chart.getAxisLeft().setAxisMaximum(f + 10.0f);
                        ResultAnalysisGearItem.this.chart.getAxisLeft().setAxisMinimum(0.0f);
                        ResultAnalysisGearItem.this.chart.setData(this.val$combinedData);
                    }
                });
            }
        });
    }
}

