/*
 * Decompiled with CFR 0.152.
 */
package com.brytonsport.active.ui.result.pager;

import android.content.Context;
import android.graphics.Color;
import android.graphics.drawable.Drawable;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.View;
import android.widget.RelativeLayout;
import com.brytonsport.active.base.App;
import com.brytonsport.active.databinding.PagerSummaryBinding;
import com.brytonsport.active.ui.result.ResultInfoActivity;
import com.brytonsport.active.utils.TimeUtils;
import com.brytonsport.active.utils.Utils;
import com.brytonsport.active.vm.result.ResultInfoViewModel;
import com.mapbox.geojson.Feature;
import com.mapbox.geojson.FeatureCollection;
import com.mapbox.geojson.Geometry;
import com.mapbox.geojson.LineString;
import com.mapbox.geojson.Point;
import com.mapbox.mapboxsdk.camera.CameraUpdateFactory;
import com.mapbox.mapboxsdk.geometry.LatLng;
import com.mapbox.mapboxsdk.geometry.LatLngBounds;
import com.mapbox.mapboxsdk.maps.MapView;
import com.mapbox.mapboxsdk.maps.MapboxMap;
import com.mapbox.mapboxsdk.maps.OnMapReadyCallback;
import com.mapbox.mapboxsdk.maps.Style;
import com.mapbox.mapboxsdk.plugins.localization.LocalizationPlugin;
import com.mapbox.mapboxsdk.style.layers.Layer;
import com.mapbox.mapboxsdk.style.layers.LineLayer;
import com.mapbox.mapboxsdk.style.layers.PropertyFactory;
import com.mapbox.mapboxsdk.style.layers.PropertyValue;
import com.mapbox.mapboxsdk.style.layers.SymbolLayer;
import com.mapbox.mapboxsdk.style.sources.GeoJsonSource;
import com.mapbox.mapboxsdk.style.sources.Source;
import com.mapbox.mapboxsdk.utils.BitmapUtils;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.List;

public class SummaryPager
extends RelativeLayout {
    private String ICON_END_SOURCE_ID = "icon-end-source-id";
    private String ICON_START_SOURCE_ID = "icon-start-source-id";
    protected final String TAG;
    private ResultInfoActivity activity;
    private PagerSummaryBinding binding;
    DecimalFormat decimalFormat;
    private GeoJsonSource geoJsonSource;
    private LatLngBounds latLngBounds;
    private List<LatLng> latLngList = new ArrayList<LatLng>();
    private MapboxMap mMapboxMap;
    private Style mapBoxStyle;
    private List<Point> points = new ArrayList<Point>();
    private ResultInfoViewModel.ResultMapPointsObj resultMapPointsObj;
    private ResultInfoViewModel.ResultSummaryObj resultSummary;

    public SummaryPager(ResultInfoActivity object, ResultInfoViewModel.ResultSummaryObj resultSummaryObj, ResultInfoViewModel.ResultMapPointsObj resultMapPointsObj) {
        super((Context)object);
        this.TAG = "ResultSummaryPage";
        this.decimalFormat = new DecimalFormat("##0.##");
        this.activity = object;
        this.resultSummary = resultSummaryObj;
        this.resultMapPointsObj = resultMapPointsObj;
        this.binding = object = PagerSummaryBinding.inflate(LayoutInflater.from((Context)object));
        this.addView((View)((PagerSummaryBinding)object).getRoot());
        this.setView();
        this.decideShowMapView();
        this.setMapPoints();
    }

    static /* synthetic */ MapboxMap access$002(SummaryPager summaryPager, MapboxMap mapboxMap) {
        summaryPager.mMapboxMap = mapboxMap;
        return mapboxMap;
    }

    static /* synthetic */ Style access$102(SummaryPager summaryPager, Style style2) {
        summaryPager.mapBoxStyle = style2;
        return style2;
    }

    private void addEndMarkerImage(Style style2, double d, double d2) {
        style2.addSource((Source)new GeoJsonSource(this.ICON_END_SOURCE_ID, FeatureCollection.fromFeatures((Feature[])new Feature[]{Feature.fromGeometry((Geometry)Point.fromLngLat((double)d2, (double)d))})));
    }

    private void addStartEndMarker() {
        Point point = this.points;
        if (point != null && point.size() > 0) {
            point = this.points.get(0);
            Point point2 = this.points;
            point2 = point2.get(point2.size() - 1);
            this.addStartMarkerImage(this.mapBoxStyle, point.latitude(), point.longitude());
            this.addEndMarkerImage(this.mapBoxStyle, point2.latitude(), point2.longitude());
        }
    }

    private void addStartMarkerImage(Style style2, double d, double d2) {
        style2.addSource((Source)new GeoJsonSource(this.ICON_START_SOURCE_ID, FeatureCollection.fromFeatures((Feature[])new Feature[]{Feature.fromGeometry((Geometry)Point.fromLngLat((double)d2, (double)d))})));
    }

    private void decideShowMapView() {
        if (this.resultMapPointsObj.mapPointList != null && this.resultMapPointsObj.mapPointList.size() > 0) {
            this.binding.noMapImageView.setVisibility(8);
            this.binding.mapView.setVisibility(0);
            this.initMap();
        } else {
            this.binding.noMapImageView.setVisibility(0);
            this.binding.mapView.setVisibility(8);
        }
    }

    private void initMap() {
        this.binding.mapView.SetResultActivityAndMode(this.activity, true);
        this.binding.mapView.getMapAsync(new OnMapReadyCallback(){

            public void onMapReady(final MapboxMap mapboxMap) {
                SummaryPager.access$002(SummaryPager.this, mapboxMap);
                mapboxMap.setStyle("mapbox://styles/mapbox/streets-v11", new Style.OnStyleLoaded(){

                    public void onStyleLoaded(Style style2) {
                        SummaryPager.access$102(SummaryPager.this, style2);
                        SummaryPager.this.initSymbolLayer(style2);
                        SummaryPager.this.setMapView();
                        SummaryPager.this.addStartEndMarker();
                        style2 = new LocalizationPlugin((MapView)((SummaryPager)SummaryPager.this).binding.mapView, mapboxMap, style2);
                        try {
                            style2.matchMapLanguageWithDeviceDefault();
                        }
                        catch (RuntimeException runtimeException) {
                            Log.d((String)"ResultSummaryPage", (String)runtimeException.toString());
                        }
                    }
                });
            }
        });
    }

    private void initSymbolLayer(Style style2) {
        style2.addImage("icon-start-point", BitmapUtils.getBitmapFromDrawable((Drawable)this.getResources().getDrawable(2131165530)));
        style2.addImage("icon-end-point", BitmapUtils.getBitmapFromDrawable((Drawable)this.getResources().getDrawable(2131165528)));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void setMapPoints() {
        this.points = new ArrayList<Point>();
        if (this.resultMapPointsObj.mapPointList == null) return;
        if (this.resultMapPointsObj.mapPointList.size() <= 0) return;
        int n = 0;
        while (true) {
            block4: {
                block5: {
                    if (n >= this.resultMapPointsObj.mapPointList.size()) break block5;
                    if (this.resultMapPointsObj.mapPointList.get(n) == null) break block4;
                    Point point = Point.fromLngLat((double)this.resultMapPointsObj.mapPointList.get((int)n).lng, (double)this.resultMapPointsObj.mapPointList.get((int)n).lat);
                    this.points.add(point);
                    try {
                        point = new LatLng(this.resultMapPointsObj.mapPointList.get((int)n).lat, this.resultMapPointsObj.mapPointList.get((int)n).lng);
                        this.latLngList.add((LatLng)point);
                        break block4;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {}
                }
                if (this.latLngBounds == null) {
                    if (this.points.size() < 2) return;
                    this.latLngBounds = new LatLngBounds.Builder().includes(this.latLngList).build();
                    return;
                }
                this.latLngBounds = null;
                this.latLngBounds = new LatLngBounds.Builder().includes(this.latLngList).build();
                return;
            }
            ++n;
        }
    }

    private void setMapView() {
        LatLngBounds latLngBounds = this.latLngBounds;
        if (latLngBounds != null) {
            this.mMapboxMap.easeCamera(CameraUpdateFactory.newLatLngBounds((LatLngBounds)latLngBounds, (int)150), 1000);
        }
        latLngBounds = Feature.fromGeometry((Geometry)LineString.fromLngLats(this.points));
        GeoJsonSource geoJsonSource = this.geoJsonSource;
        if (geoJsonSource == null) {
            latLngBounds = new GeoJsonSource("geojson-source", (Feature)latLngBounds);
            this.geoJsonSource = latLngBounds;
            this.mapBoxStyle.addSource((Source)latLngBounds);
            this.mapBoxStyle.addLayer((Layer)new LineLayer("linelayer", "geojson-source").withProperties(new PropertyValue[]{PropertyFactory.lineJoin((String)"round"), PropertyFactory.lineWidth((Float)Float.valueOf(4.0f)), PropertyFactory.lineColor((int)Color.parseColor((String)"#003ADB"))}));
        } else {
            geoJsonSource.setGeoJson((Feature)latLngBounds);
        }
        this.mapBoxStyle.addLayer((Layer)new SymbolLayer("symbol-layer-id", this.ICON_START_SOURCE_ID).withProperties(new PropertyValue[]{PropertyFactory.iconImage((String)"icon-start-point"), PropertyFactory.iconSize((Float)Float.valueOf(0.3f)), PropertyFactory.iconAnchor((String)"bottom")}));
        this.mapBoxStyle.addLayer((Layer)new SymbolLayer("symbol-layer-id2", this.ICON_END_SOURCE_ID).withProperties(new PropertyValue[]{PropertyFactory.iconImage((String)"icon-end-point"), PropertyFactory.iconSize((Float)Float.valueOf(0.3f)), PropertyFactory.iconAnchor((String)"bottom")}));
    }

    private void setView() {
        this.binding.distanceTitle.setText((CharSequence)App.get("Distance(km)"));
        Object object = this.binding.avgSpeedTitle;
        CharSequence charSequence = new StringBuilder();
        charSequence.append(App.get("Avg. Spd(kmh)"));
        charSequence.append("(");
        charSequence.append(Utils.getUnitByKmH());
        charSequence.append(")");
        object.setText((CharSequence)charSequence.toString());
        charSequence = this.binding.altGainTitle;
        object = new StringBuilder();
        ((StringBuilder)object).append(App.get("Alt. Gain(m)"));
        ((StringBuilder)object).append("(");
        ((StringBuilder)object).append(Utils.getUnitByM());
        ((StringBuilder)object).append(")");
        charSequence.setText(((StringBuilder)object).toString());
        this.binding.rideTimeTitle.setText((CharSequence)App.get("Ride Time"));
        this.binding.tripTimeTitle.setText((CharSequence)App.get("Trip Time"));
        charSequence = this.binding.caloriesTitle;
        object = new StringBuilder();
        ((StringBuilder)object).append(App.get("Calories(kcal)"));
        ((StringBuilder)object).append("(");
        ((StringBuilder)object).append(Utils.getUnitByKcal());
        ((StringBuilder)object).append(")");
        charSequence.setText(((StringBuilder)object).toString());
        object = this.binding.hearRateTitle;
        charSequence = new StringBuilder();
        charSequence.append(App.get("Heart Rate(bpm)"));
        charSequence.append("(");
        charSequence.append(Utils.getUnitByBpm());
        charSequence.append(")");
        object.setText((CharSequence)charSequence.toString());
        this.binding.dateText.setText((CharSequence)this.resultSummary.date);
        try {
            charSequence = this.decimalFormat.format(Utils.convertKM(Double.parseDouble(this.resultSummary.avgSpeed)));
        }
        catch (Exception exception) {
            charSequence = "0";
        }
        this.binding.avgSpeedText.setText(charSequence);
        this.binding.distanceText.setText((CharSequence)this.decimalFormat.format(Utils.convertKM(Double.parseDouble(this.resultSummary.distance))));
        this.binding.altGainText.setText((CharSequence)String.valueOf((int)Utils.convertM(Float.parseFloat(this.resultSummary.altGain))));
        this.binding.rideTimeText.setText((CharSequence)TimeUtils.hmsToMSTime(this.resultSummary.rideTime));
        this.binding.tripTimeText.setText((CharSequence)TimeUtils.hmsToMSTime(this.resultSummary.tripTime));
        this.binding.caloriesText.setText((CharSequence)this.resultSummary.calories);
        charSequence = this.resultSummary.heartRate.equals("0") ? "--" : this.resultSummary.heartRate;
        this.binding.hearRateText.setText(charSequence);
    }

    public void ResetTouchEventFlag() {
        this.binding.mapView.ResetTouchEventFlag();
    }

    public void destroyActivity() {
        this.mMapboxMap = null;
        this.points = null;
        Runtime.getRuntime().gc();
    }

    public void setData(ResultInfoViewModel.ResultSummaryObj resultSummaryObj, ResultInfoViewModel.ResultMapPointsObj resultMapPointsObj) {
        this.resultSummary = resultSummaryObj;
        this.resultMapPointsObj = resultMapPointsObj;
        this.setView();
        this.decideShowMapView();
        this.setMapPoints();
    }
}

