/*
 * Decompiled with CFR 0.152.
 */
package com.brytonsport.active.ui.result.view;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.RectF;
import android.util.AttributeSet;
import android.view.View;

public class CircleChartView
extends View {
    private float end = 150.0f;
    private float endPeek = 120.0f;
    private int innerColor;
    private int outerColor;
    private Paint paint;
    private RectF rectF;
    private float start = -150.0f;
    private float startPeek = -120.0f;

    public CircleChartView(Context context) {
        super(context);
        this.init(context);
    }

    public CircleChartView(Context context, AttributeSet attributeSet) {
        super(context, attributeSet);
        this.init(context);
    }

    public CircleChartView(Context context, AttributeSet attributeSet, int n) {
        super(context, attributeSet, n);
        this.init(context);
    }

    private void init(Context context) {
        this.innerColor = this.getResources().getColor(2131034558);
        this.outerColor = this.getResources().getColor(2131034557);
        this.paint = new Paint();
        this.rectF = new RectF();
    }

    protected void onDraw(Canvas canvas) {
        super.onDraw(canvas);
        int n = this.getWidth();
        int n2 = this.getHeight();
        if (n != 0 && n2 != 0) {
            float f;
            float f2 = (float)(n * 112) / 150.0f;
            float f3 = (float)(n * 122) / 150.0f;
            float f4 = (float)(n * 140) / 150.0f;
            float f5 = (float)(n * 150) / 150.0f;
            int n3 = (int)this.start - 90;
            int n4 = (int)this.end;
            this.paint.reset();
            this.paint.setColor(this.innerColor);
            this.paint.setStyle(Paint.Style.STROKE);
            this.paint.setStrokeWidth((f4 - f3) / 2.0f);
            RectF rectF = this.rectF;
            rectF.left = f3 = (f5 - f2) / 2.0f;
            this.rectF.top = f3;
            rectF = this.rectF;
            rectF.right = f2 = (float)n - f3;
            rectF = this.rectF;
            rectF.bottom = f = (float)n2 - f3;
            canvas.drawArc(this.rectF, (float)n3, (float)(n4 - 90 - n3), false, this.paint);
            f5 = this.startPeek;
            n3 = (int)f5 - 90;
            f4 = this.endPeek;
            n4 = (int)f4;
            n2 = (int)(f5 - 5.0f) - 90;
            n = (int)(f4 + 5.0f);
            this.paint.reset();
            this.paint.setStyle(Paint.Style.STROKE);
            this.paint.setStrokeWidth(f3);
            this.rectF.left = f3;
            this.rectF.top = f3;
            this.rectF.right = f2;
            this.rectF.bottom = f;
            this.paint.setColor(this.getResources().getColor(2131034152));
            canvas.drawArc(this.rectF, (float)n2, (float)(n - 90 - n2), false, this.paint);
            this.paint.setColor(this.outerColor);
            canvas.drawArc(this.rectF, (float)n3, (float)(n4 - 90 - n3), false, this.paint);
        }
    }

    protected void onSizeChanged(int n, int n2, int n3, int n4) {
        super.onSizeChanged(n, n2, n3, n4);
        this.postInvalidate();
    }

    public void setCircleColor(int n, int n2) {
        this.innerColor = n;
        this.outerColor = n2;
        this.requestLayout();
        this.postInvalidate();
    }

    public void setData(float f, float f2, float f3, float f4) {
        this.start = f;
        this.end = f2;
        this.startPeek = f3;
        this.endPeek = f4;
        this.postInvalidate();
    }
}

