/*
 * Decompiled with CFR 0.152.
 */
package com.brytonsport.active.ui.setting;

import android.app.Activity;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.content.IntentFilter;
import android.location.Criteria;
import android.location.Location;
import android.location.LocationManager;
import android.os.Build;
import android.os.Bundle;
import android.text.Editable;
import android.text.TextWatcher;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.View;
import androidx.lifecycle.ViewModelProvider;
import com.brytonsport.active.base.App;
import com.brytonsport.active.databinding.ActivitySettingAltitudeCalibrationBinding;
import com.brytonsport.active.service.BleService;
import com.brytonsport.active.ui.setting.Hilt_SettingAltitudeCalibrationActivity;
import com.brytonsport.active.ui.setting.SettingAltitudeCalibrationActivity$$ExternalSyntheticLambda0;
import com.brytonsport.active.ui.setting.SettingAltitudeCalibrationActivity$$ExternalSyntheticLambda1;
import com.brytonsport.active.ui.setting.SettingAltitudeCalibrationActivity$$ExternalSyntheticLambda2;
import com.brytonsport.active.ui.setting.SettingAltitudeCalibrationActivity$$ExternalSyntheticLambda3;
import com.brytonsport.active.ui.setting.SettingAltitudeCalibrationActivity$2$$ExternalSyntheticLambda0;
import com.brytonsport.active.ui.setting.SettingAutoCalibrationActivity;
import com.brytonsport.active.utils.DeviceBusyStatusUtil;
import com.brytonsport.active.utils.Utils;
import com.brytonsport.active.utils.i18N;
import com.brytonsport.active.views.dialog.ConfirmDialog;
import com.brytonsport.active.vm.setting.SettingAltitudeCalibrationViewModel;
import org.json.JSONException;
import pub.devrel.easypermissions.AfterPermissionGranted;
import pub.devrel.easypermissions.EasyPermissions;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class SettingAltitudeCalibrationActivity
extends Hilt_SettingAltitudeCalibrationActivity<ActivitySettingAltitudeCalibrationBinding, SettingAltitudeCalibrationViewModel> {
    private static final float LOCATION_DISTANCE = 10.0f;
    private static final int LOCATION_INTERVAL = 1000;
    private static final int RC_LOCATION = 20;
    static final String TAG = "SettingAltitudeCalibrationActivity";
    private String locationProvider = "";
    private final BroadcastReceiver mGattUpdateReceiver = new BroadcastReceiver(){

        static /* synthetic */ void lambda$onReceive$0(DialogInterface dialogInterface, int n) {
        }

        public void onReceive(Context object, Intent intent) {
            object = intent.getAction();
            ((String)object).hashCode();
            if (!((String)object).equals("com.brytonsport.active.SERVICE_ONLOCATION_CHANGE")) {
                if (((String)object).equals("com.brytonsport.active.SERVICE_POST_DATA") && intent.getIntExtra("com.brytonsport.active.SERVICE_POST_FILE_TYPE", 0) == 1) {
                    ConfirmDialog.showSelf(SettingAltitudeCalibrationActivity.this.activity, i18N.get("B_OK"), "", "", i18N.get("M_CalibrateSuccess"), (DialogInterface.OnClickListener)SettingAltitudeCalibrationActivity$2$$ExternalSyntheticLambda0.INSTANCE);
                }
            } else {
                SettingAltitudeCalibrationActivity.this.checkRecentGetLatLngInfo();
            }
        }
    };
    private Location mLastLocation;
    private LocationListener mLocListener = null;
    private LocationListener[] mLocationListeners = null;
    private LocationManager mLocationManager = null;

    static /* synthetic */ Location access$002(SettingAltitudeCalibrationActivity settingAltitudeCalibrationActivity, Location location) {
        settingAltitudeCalibrationActivity.mLastLocation = location;
        return location;
    }

    private void callServiceInitLocManger() {
        Intent intent = new Intent((Context)this, BleService.class);
        intent.setAction("com.brytonsport.activeinitLocationManager");
        if (Build.VERSION.SDK_INT >= 26) {
            this.startForegroundService(intent);
        } else {
            this.startService(intent);
        }
    }

    private void checkRecentGetLatLngInfo() {
        if (App.recentGetLatLngInfoObj != null && App.recentGetLatLngInfoObj.length() > 0) {
            try {
                if (App.recentGetLatLngInfoObj.has("alt")) {
                    this.setAltitudeToEditText(App.recentGetLatLngInfoObj.getDouble("alt"));
                }
            }
            catch (JSONException jSONException) {
                jSONException.printStackTrace();
            }
        } else {
            this.callServiceInitLocManger();
        }
    }

    public static Intent createIntent(Context context) {
        return new Intent(context, SettingAltitudeCalibrationActivity.class);
    }

    private void initializeLocationManager() {
        String string2 = TAG;
        Log.e((String)string2, (String)"initializeLocationManager - LOCATION_INTERVAL: 1000 LOCATION_DISTANCE: 10.0");
        if (this.mLocationManager == null) {
            this.mLocationManager = (LocationManager)this.getApplicationContext().getSystemService("location");
        }
        Object object = new Criteria();
        CharSequence charSequence = this.locationProvider;
        if (charSequence == null || ((String)charSequence).isEmpty()) {
            this.locationProvider = this.mLocationManager.getBestProvider((Criteria)object, true);
        }
        if ((charSequence = this.locationProvider) != null && !((String)charSequence).isEmpty()) {
            if (this.mLocListener == null) {
                this.mLocListener = new LocationListener(this.locationProvider);
                charSequence = new StringBuilder();
                ((StringBuilder)charSequence).append("initializeLocationManager: mLocListener -> ");
                ((StringBuilder)charSequence).append(this.mLocListener);
                Log.d((String)string2, (String)((StringBuilder)charSequence).toString());
            }
            if (this.mLocListener == null) {
                return;
            }
            try {
                this.mLastLocation = this.mLocationManager.getLastKnownLocation(this.locationProvider);
                charSequence = new StringBuilder();
                ((StringBuilder)charSequence).append("initializeLocationManager: removeUpdates mLocListener -> ");
                ((StringBuilder)charSequence).append(this.mLocListener);
                Log.d((String)string2, (String)((StringBuilder)charSequence).toString());
                this.mLocationManager.removeUpdates((android.location.LocationListener)this.mLocListener);
                charSequence = new StringBuilder();
                ((StringBuilder)charSequence).append("initializeLocationManager: requestLocationUpdates mLocListener -> ");
                ((StringBuilder)charSequence).append(this.mLocListener);
                Log.d((String)string2, (String)((StringBuilder)charSequence).toString());
                this.mLocationManager.requestLocationUpdates(this.locationProvider, 1000L, 10.0f, (android.location.LocationListener)this.mLocListener);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                string2 = TAG;
                object = new StringBuilder();
                ((StringBuilder)object).append("network provider does not exist, ");
                ((StringBuilder)object).append(illegalArgumentException.getMessage());
                Log.d((String)string2, (String)((StringBuilder)object).toString());
            }
            catch (SecurityException securityException) {
                Log.i((String)TAG, (String)"fail to request location update, ignore", (Throwable)securityException);
            }
            return;
        }
        Log.d((String)string2, (String)"initializeLocationManager: locationProvider == null");
    }

    private static IntentFilter makeGattUpdateIntentFilter() {
        IntentFilter intentFilter = new IntentFilter();
        intentFilter.addAction("com.brytonsport.active.SERVICE_POST_DATA");
        intentFilter.addAction("com.brytonsport.active.SERVICE_ONLOCATION_CHANGE");
        return intentFilter;
    }

    @AfterPermissionGranted(value=20)
    private void methodRequiresTwoPermission() {
        String[] stringArray = new String[]{"android.permission.ACCESS_COARSE_LOCATION", "android.permission.ACCESS_FINE_LOCATION"};
        if (EasyPermissions.hasPermissions((Context)this, (String[])stringArray)) {
            this.initializeLocationManager();
        } else {
            EasyPermissions.requestPermissions((Activity)this, (String)i18N.get("FaqGpsTitleFornine"), (int)20, (String[])stringArray);
        }
    }

    private void removeLocationListener() {
        if (this.mLocationManager != null && this.mLocListener != null) {
            String string2 = TAG;
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("onDestroy: \u79fb\u9664 mLocListener -> ");
            stringBuilder.append(this.mLocListener);
            Log.d((String)string2, (String)stringBuilder.toString());
            this.mLocationManager.removeUpdates((android.location.LocationListener)this.mLocListener);
            this.mLocListener = null;
            this.mLocationManager = null;
        }
    }

    private void setAltitudeToEditText(double d) {
        SettingAltitudeCalibrationViewModel settingAltitudeCalibrationViewModel = (SettingAltitudeCalibrationViewModel)this.viewModel;
        float f = (float)d;
        settingAltitudeCalibrationViewModel.meter = (int)Utils.convertM(f);
        ((ActivitySettingAltitudeCalibrationBinding)this.binding).meterText.setText((CharSequence)String.valueOf((int)Utils.convertM(f)));
    }

    @Override
    protected ActivitySettingAltitudeCalibrationBinding createViewBinding(LayoutInflater layoutInflater) {
        return ActivitySettingAltitudeCalibrationBinding.inflate(layoutInflater);
    }

    @Override
    protected SettingAltitudeCalibrationViewModel createViewModel() {
        return new ViewModelProvider(this).get(SettingAltitudeCalibrationViewModel.class);
    }

    @Override
    protected void initColor() {
        ((ActivitySettingAltitudeCalibrationBinding)this.binding).getRoot().setBackgroundResource(2131034148);
    }

    @Override
    protected void initFont() {
    }

    @Override
    protected void initText() {
        App.put("Alt. Calibration", i18N.get("AltCalibration"));
        App.put("Auto Calibration", i18N.get("F_AutoAltitude"));
        App.put("OK", i18N.get("B_OK"));
        App.put("Please make sure you are at ground level for more accurate altitude calibration.", i18N.get("M_InputAltNote"));
        App.put("Calibrate", i18N.get("B_Calibrate"));
        this.setTitle(App.get("Alt. Calibration"));
        ((ActivitySettingAltitudeCalibrationBinding)this.binding).autoCalibrationItem.setVisibility(8);
        ((ActivitySettingAltitudeCalibrationBinding)this.binding).meterText.setText((CharSequence)String.valueOf(((SettingAltitudeCalibrationViewModel)this.viewModel).meter));
        ((ActivitySettingAltitudeCalibrationBinding)this.binding).unitText.setText((CharSequence)Utils.getUnitByM());
        ((ActivitySettingAltitudeCalibrationBinding)this.binding).hintText.setText((CharSequence)App.get("Please make sure you are at ground level for more accurate altitude calibration."));
        ((ActivitySettingAltitudeCalibrationBinding)this.binding).calibrateButton.setText((CharSequence)App.get("Calibrate"));
    }

    public /* synthetic */ void lambda$setListeners$0$com-brytonsport-active-ui-setting-SettingAltitudeCalibrationActivity(View view) {
        this.startActivity(SettingAutoCalibrationActivity.createIntent((Context)this.activity));
    }

    public /* synthetic */ void lambda$setListeners$1$com-brytonsport-active-ui-setting-SettingAltitudeCalibrationActivity(View object) {
        object = (SettingAltitudeCalibrationViewModel)this.viewModel;
        ++object.meter;
        ((ActivitySettingAltitudeCalibrationBinding)this.binding).meterText.setText((CharSequence)String.valueOf(((SettingAltitudeCalibrationViewModel)this.viewModel).meter));
    }

    public /* synthetic */ void lambda$setListeners$2$com-brytonsport-active-ui-setting-SettingAltitudeCalibrationActivity(View object) {
        object = (SettingAltitudeCalibrationViewModel)this.viewModel;
        --object.meter;
        ((ActivitySettingAltitudeCalibrationBinding)this.binding).meterText.setText((CharSequence)String.valueOf(((SettingAltitudeCalibrationViewModel)this.viewModel).meter));
    }

    public /* synthetic */ void lambda$setListeners$3$com-brytonsport-active-ui-setting-SettingAltitudeCalibrationActivity(View object) {
        if (!BleService.mbDevExist.booleanValue()) {
            ConfirmDialog.showSelf(this.activity, i18N.get("M_NoConnectedDev"), "");
            return;
        }
        object = DeviceBusyStatusUtil.getNowDeviceStatus();
        if (object.equals((Object)DeviceBusyStatusUtil.DeviceStatus.SyncActivity)) {
            ConfirmDialog.showSelfSingle(this.activity, i18N.get("M_ReadDevice"), i18N.get("B_OK"));
        } else if (object.equals((Object)DeviceBusyStatusUtil.DeviceStatus.RunningGroupRide)) {
            ConfirmDialog.showSelfSingle(this.activity, i18N.get("StopGRFrist"), i18N.get("B_OK"));
        } else if (object.equals((Object)DeviceBusyStatusUtil.DeviceStatus.SendServerEeToDev)) {
            ConfirmDialog.showSelfSingle(this.activity, i18N.get("M_DeviceBusy"), i18N.get("B_OK"));
        } else {
            object = ((ActivitySettingAltitudeCalibrationBinding)this.binding).meterText.getText().toString();
            if (!object.isEmpty()) {
                object = Integer.valueOf((String)object);
                ((SettingAltitudeCalibrationViewModel)this.viewModel).sendAltitudeToDevice(object.intValue());
            }
        }
    }

    @Override
    protected void onCreate() {
        super.onCreate();
        this.methodRequiresTwoPermission();
        this.registerReceiver(this.mGattUpdateReceiver, SettingAltitudeCalibrationActivity.makeGattUpdateIntentFilter());
    }

    @Override
    public void onDestroy() {
        super.onDestroy();
        this.unregisterReceiver(this.mGattUpdateReceiver);
    }

    @Override
    public void onRequestPermissionsResult(int n, String[] stringArray, int[] nArray) {
        super.onRequestPermissionsResult(n, stringArray, nArray);
        EasyPermissions.onRequestPermissionsResult((int)n, (String[])stringArray, (int[])nArray, (Object[])new Object[]{this});
    }

    @Override
    protected void onResume() {
        super.onResume();
        this.checkRecentGetLatLngInfo();
    }

    @Override
    protected void setListeners() {
        ((ActivitySettingAltitudeCalibrationBinding)this.binding).autoCalibrationItem.setOnClickListener(new SettingAltitudeCalibrationActivity$$ExternalSyntheticLambda0(this));
        ((ActivitySettingAltitudeCalibrationBinding)this.binding).meterText.addTextChangedListener(new TextWatcher(){

            public void afterTextChanged(Editable editable) {
                try {
                    ((SettingAltitudeCalibrationViewModel)SettingAltitudeCalibrationActivity.this.viewModel).meter = Integer.parseInt(editable.toString());
                }
                catch (Exception exception) {
                    ((ActivitySettingAltitudeCalibrationBinding)SettingAltitudeCalibrationActivity.this.binding).meterText.removeTextChangedListener((TextWatcher)this);
                    ((ActivitySettingAltitudeCalibrationBinding)SettingAltitudeCalibrationActivity.this.binding).meterText.setText((CharSequence)"0");
                    ((SettingAltitudeCalibrationViewModel)SettingAltitudeCalibrationActivity.this.viewModel).meter = 0;
                    ((ActivitySettingAltitudeCalibrationBinding)SettingAltitudeCalibrationActivity.this.binding).meterText.addTextChangedListener((TextWatcher)this);
                }
            }

            public void beforeTextChanged(CharSequence charSequence, int n, int n2, int n3) {
            }

            public void onTextChanged(CharSequence charSequence, int n, int n2, int n3) {
            }
        });
        ((ActivitySettingAltitudeCalibrationBinding)this.binding).upIcon.setOnClickListener((View.OnClickListener)new SettingAltitudeCalibrationActivity$$ExternalSyntheticLambda1(this));
        ((ActivitySettingAltitudeCalibrationBinding)this.binding).downIcon.setOnClickListener((View.OnClickListener)new SettingAltitudeCalibrationActivity$$ExternalSyntheticLambda2(this));
        ((ActivitySettingAltitudeCalibrationBinding)this.binding).calibrateButton.setOnClickListener((View.OnClickListener)new SettingAltitudeCalibrationActivity$$ExternalSyntheticLambda3(this));
    }

    private class LocationListener
    implements android.location.LocationListener {
        public LocationListener(String charSequence) {
            String string2 = TAG;
            CharSequence charSequence2 = new StringBuilder();
            charSequence2.append("LocationListener ");
            charSequence2.append((String)charSequence);
            Log.e((String)string2, (String)charSequence2.toString());
            SettingAltitudeCalibrationActivity.access$002(SettingAltitudeCalibrationActivity.this, new Location((String)charSequence));
            if (SettingAltitudeCalibrationActivity.this.mLastLocation != null) {
                charSequence2 = TAG;
                charSequence = new StringBuilder();
                ((StringBuilder)charSequence).append("LocationListener: (");
                ((StringBuilder)charSequence).append(SettingAltitudeCalibrationActivity.this.mLastLocation.getLatitude());
                ((StringBuilder)charSequence).append(", ");
                ((StringBuilder)charSequence).append(SettingAltitudeCalibrationActivity.this.mLastLocation.getLongitude());
                ((StringBuilder)charSequence).append(")");
                Log.d((String)charSequence2, (String)((StringBuilder)charSequence).toString());
            }
        }

        public void onLocationChanged(Location object) {
            if (object != null) {
                String string2 = TAG;
                StringBuilder stringBuilder = new StringBuilder();
                stringBuilder.append("onLocationChanged: (");
                stringBuilder.append(object.getLatitude());
                stringBuilder.append(", ");
                stringBuilder.append(object.getLongitude());
                stringBuilder.append(")");
                Log.d((String)string2, (String)stringBuilder.toString());
                if (SettingAltitudeCalibrationActivity.this.mLastLocation == null) {
                    SettingAltitudeCalibrationActivity.access$002(SettingAltitudeCalibrationActivity.this, object);
                } else {
                    SettingAltitudeCalibrationActivity.this.mLastLocation.set(object);
                }
                if (((SettingAltitudeCalibrationViewModel)SettingAltitudeCalibrationActivity.this.viewModel).meter == 0) {
                    object = SettingAltitudeCalibrationActivity.this;
                    ((SettingAltitudeCalibrationActivity)object).setAltitudeToEditText(((SettingAltitudeCalibrationActivity)object).mLastLocation.getAltitude());
                }
            }
        }

        public void onProviderDisabled(String string2) {
            String string3 = TAG;
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("onProviderDisabled: ");
            stringBuilder.append(string2);
            Log.e((String)string3, (String)stringBuilder.toString());
        }

        public void onProviderEnabled(String string2) {
            String string3 = TAG;
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("onProviderEnabled: ");
            stringBuilder.append(string2);
            Log.e((String)string3, (String)stringBuilder.toString());
        }

        public void onStatusChanged(String string2, int n, Bundle object) {
            object = TAG;
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("onStatusChanged: ");
            stringBuilder.append(string2);
            Log.e((String)object, (String)stringBuilder.toString());
        }
    }
}

